/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;

public abstract class Tuple4DReadOnlyTest<T extends Tuple4DReadOnly> {
    public abstract T createEmptyTuple();

    public abstract T createTuple(double var1, double var3, double var5, double var7);

    public abstract T createRandomTuple(Random var1);

    public abstract double getEpsilon();

    @Test
    public void testGetters() throws Exception {
        float s;
        float y;
        double s2;
        double z;
        int i;
        Random random = new Random(621541L);
        T tuple = this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y2 = random.nextDouble();
            z = random.nextDouble();
            s2 = random.nextDouble();
            tuple = this.createTuple(x, y2, z, s2);
            Assertions.assertEquals((double)tuple.getX(), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getY(), (double)y2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getZ(), (double)z, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getS(), (double)s2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            float x = random.nextFloat();
            y = random.nextFloat();
            float z2 = random.nextFloat();
            s = random.nextFloat();
            tuple = this.createTuple(x, y, z2, s);
            Assertions.assertEquals((double)tuple.getX32(), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getY32(), (double)y, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getZ32(), (double)z2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getS32(), (double)s, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y3 = random.nextDouble();
            z = random.nextDouble();
            s2 = random.nextDouble();
            tuple = this.createTuple(x, y3, z, s2);
            Assertions.assertEquals((double)tuple.getElement(0), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getElement(1), (double)y3, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getElement(2), (double)z, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple.getElement(3), (double)s2, (double)this.getEpsilon());
            try {
                tuple.getElement(-1);
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
            try {
                tuple.getElement(4);
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
        }
        for (i = 0; i < 1000; ++i) {
            float z3;
            float x = random.nextFloat();
            tuple = this.createTuple(x, y = random.nextFloat(), z3 = random.nextFloat(), s = random.nextFloat());
            Assertions.assertTrue((tuple.getElement32(0) == x ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getElement32(1) == y ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getElement32(2) == z3 ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getElement32(3) == s ? 1 : 0) != 0);
            try {
                tuple.getElement32(-1);
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
            catch (IndexOutOfBoundsException z4) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
            try {
                tuple.getElement32(4);
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
        }
        for (i = 0; i < 1000; ++i) {
            tuple = this.createRandomTuple(random);
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            tuple.get(tupleArray);
            Assertions.assertTrue((tuple.getX() == tupleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getY() == tupleArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getZ() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getS() == tupleArray[3] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            tuple = this.createRandomTuple(random);
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            tuple.get(2, tupleArray);
            Assertions.assertTrue((tuple.getX() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getY() == tupleArray[3] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getZ() == tupleArray[4] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getS() == tupleArray[5] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            tuple = this.createRandomTuple(random);
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            tuple.get(tupleArray);
            Assertions.assertTrue((tuple.getX32() == tupleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getY32() == tupleArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getZ32() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getS32() == tupleArray[3] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            tuple = this.createRandomTuple(random);
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            tuple.get(2, tupleArray);
            Assertions.assertTrue((tuple.getX32() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getY32() == tupleArray[3] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getZ32() == tupleArray[4] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getS32() == tupleArray[5] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple.get((DMatrix)matrix);
            Assertions.assertTrue((tuple.getX() == matrix.get(0, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getY() == matrix.get(1, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getZ() == matrix.get(2, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getS() == matrix.get(3, 0) ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple.get(2, (DMatrix)matrix);
            Assertions.assertTrue((tuple.getX() == matrix.get(2, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getY() == matrix.get(3, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getZ() == matrix.get(4, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getS() == matrix.get(5, 0) ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple.get(2, 4, (DMatrix)matrix);
            Assertions.assertTrue((tuple.getX() == matrix.get(2, 4) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getY() == matrix.get(3, 4) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getZ() == matrix.get(4, 4) ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getS() == matrix.get(5, 4) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testContainsNaN() throws Exception {
        Assertions.assertFalse((boolean)this.createTuple(0.0, 0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createTuple(Double.NaN, 0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createTuple(0.0, Double.NaN, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createTuple(0.0, 0.0, Double.NaN, 0.0).containsNaN());
        Assertions.assertTrue((boolean)this.createTuple(0.0, 0.0, 0.0, Double.NaN).containsNaN());
    }

    @Test
    public void testLength() {
        Random random = new Random(312310L);
        for (int i = 0; i < 1000; ++i) {
            T tuple1 = this.createRandomTuple(random);
            double length1 = tuple1.norm();
            double scalar = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            T tuple2 = this.createTuple(scalar * tuple1.getX(), scalar * tuple1.getY(), scalar * tuple1.getZ(), scalar * tuple1.getS());
            double expectedLength2 = scalar * length1;
            double actualLength2 = tuple2.norm();
            Assertions.assertEquals((double)expectedLength2, (double)actualLength2, (double)(5.0 * this.getEpsilon()));
        }
    }

    @Test
    public void testLengthSquared() {
        Random random = new Random(312310L);
        for (int i = 0; i < 1000; ++i) {
            T tuple1 = this.createRandomTuple(random);
            double length1 = tuple1.norm();
            double scalar = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            T tuple2 = this.createTuple(scalar * tuple1.getX(), scalar * tuple1.getY(), scalar * tuple1.getZ(), scalar * tuple1.getS());
            double expectedLength2 = scalar * length1;
            double actualLength2 = tuple2.normSquared();
            Assertions.assertEquals((double)expectedLength2, (double)EuclidCoreTools.squareRoot((double)actualLength2), (double)(5.0 * this.getEpsilon()));
        }
    }

    @Test
    public void testDot() {
        Random random = new Random(5461L);
        for (int i = 0; i < 1000; ++i) {
            T p = this.createRandomTuple(random);
            T q = this.createRandomTuple(random);
            Vector4D product = new Vector4D();
            double actualDot = p.dot(q);
            QuaternionTools.multiplyConjugateRight(p, q, (Vector4DBasics)product);
            double expectedDot = product.getS();
            Assertions.assertEquals((double)expectedDot, (double)actualDot, (double)this.getEpsilon());
            QuaternionTools.multiplyConjugateRight(q, p, (Vector4DBasics)product);
            expectedDot = product.getS();
            Assertions.assertEquals((double)expectedDot, (double)actualDot, (double)this.getEpsilon());
            QuaternionTools.multiplyConjugateLeft(p, q, (Vector4DBasics)product);
            expectedDot = product.getS();
            Assertions.assertEquals((double)expectedDot, (double)actualDot, (double)this.getEpsilon());
            QuaternionTools.multiplyConjugateLeft(q, p, (Vector4DBasics)product);
            expectedDot = product.getS();
            Assertions.assertEquals((double)expectedDot, (double)actualDot, (double)this.getEpsilon());
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(621541L);
        double epsilon = random.nextDouble();
        T tuple = this.createRandomTuple(random);
        double x = tuple.getX();
        double y = tuple.getY();
        double z = tuple.getZ();
        double s = tuple.getS();
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x + 0.999 * epsilon, y, z, s), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x - 0.999 * epsilon, y, z, s), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x, y + 0.999 * epsilon, z, s), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x, y - 0.999 * epsilon, z, s), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x, y, z + 0.999 * epsilon, s), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x, y, z - 0.999 * epsilon, s), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x, y, z, s + 0.999 * epsilon), epsilon));
        Assertions.assertTrue((boolean)tuple.epsilonEquals(this.createTuple(x, y, z, s - 0.999 * epsilon), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x + 1.001 * epsilon, y, z, s), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x - 1.001 * epsilon, y, z, s), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x, y + 1.001 * epsilon, z, s), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x, y - 1.001 * epsilon, z, s), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x, y, z + 1.001 * epsilon, s), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x, y, z - 1.001 * epsilon, s), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x, y, z, s + 1.001 * epsilon), epsilon));
        Assertions.assertFalse((boolean)tuple.epsilonEquals(this.createTuple(x, y, z, s - 1.001 * epsilon), epsilon));
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(621541L);
        T tuple = this.createRandomTuple(random);
        Assertions.assertFalse((boolean)tuple.equals(this.createEmptyTuple()));
        Assertions.assertFalse((boolean)tuple.equals(null));
        Assertions.assertFalse((boolean)tuple.equals(new double[5]));
        double x = tuple.getX();
        double y = tuple.getY();
        double z = tuple.getZ();
        double s = tuple.getS();
        Assertions.assertTrue((boolean)tuple.equals(this.createTuple(x, y, z, s)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x + this.getEpsilon(), y, z, s)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x - this.getEpsilon(), y, z, s)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x, y + this.getEpsilon(), z, s)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x, y - this.getEpsilon(), z, s)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x, y, z + this.getEpsilon(), s)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x, y, z - this.getEpsilon(), s)));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x, y, z, s + this.getEpsilon())));
        Assertions.assertFalse((boolean)tuple.equals(this.createTuple(x, y, z, s - this.getEpsilon())));
    }
}

