/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.Vector2DBasicsTest;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class Vector2DTest
extends Vector2DBasicsTest<Vector2D> {
    @Test
    public void testVector2D() {
        int i;
        Random random = new Random(621541L);
        Vector2D vector = new Vector2D();
        Assertions.assertTrue((0.0 == vector.getX() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == vector.getY() ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            double newY;
            double newX = random.nextDouble();
            Assertions.assertTrue((newX == (vector = new Vector2D(newX, newY = random.nextDouble())).getX() ? 1 : 0) != 0);
            Assertions.assertTrue((newY == vector.getY() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            double[] randomVector2DArray = new double[]{random.nextDouble(), random.nextDouble()};
            double[] copyRandomVector2DArray = new double[]{randomVector2DArray[0], randomVector2DArray[1]};
            Vector2D vectorArray = new Vector2D(randomVector2DArray);
            Assertions.assertTrue((randomVector2DArray[0] == vectorArray.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((randomVector2DArray[1] == vectorArray.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((copyRandomVector2DArray[0] == randomVector2DArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((copyRandomVector2DArray[1] == randomVector2DArray[1] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Vector2D vector2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            vector = new Vector2D((Tuple2DReadOnly)vector2);
            Assertions.assertTrue((vector.getX() == vector2.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY() == vector2.getY() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D vector2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            vector = new Vector2D((Tuple3DReadOnly)vector2);
            Assertions.assertTrue((vector.getX() == vector2.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY() == vector2.getY() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Vector2D tuple1 = this.createRandomTuple(random);
        int newHashCode = tuple1.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)tuple1.hashCode());
        int previousHashCode = tuple1.hashCode();
        for (int i = 0; i < 1000; ++i) {
            tuple1.setElement(i % 2, random.nextDouble());
            newHashCode = tuple1.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Vector2D vectorB;
            Vector2D vectorA = EuclidCoreRandomTools.nextVector2D((Random)random);
            if (vectorA.geometricallyEquals((EuclidGeometry)(vectorB = EuclidCoreRandomTools.nextVector2D((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
                continue;
            }
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
        }
    }

    @Override
    public double getEpsilon() {
        return 1.0E-15;
    }

    @Override
    public Vector2D createEmptyTuple() {
        return new Vector2D();
    }

    @Override
    public Vector2D createTuple(double x, double y) {
        return new Vector2D(x, y);
    }

    @Override
    public Vector2D createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextVector2D((Random)random);
    }
}

