/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple4D.Vector4D;

public class EuclidCoreToolsTest {
    @Test
    public void testConstants() {
        Point2D expectedOrigin2D = new Point2D();
        Assertions.assertEquals((Object)expectedOrigin2D, (Object)EuclidCoreTools.origin2D);
        Assertions.assertEquals((int)expectedOrigin2D.hashCode(), (int)EuclidCoreTools.origin2D.hashCode());
        Assertions.assertEquals((Object)expectedOrigin2D.toString(), (Object)EuclidCoreTools.origin2D.toString());
        Point3D expectedOrigin3D = new Point3D();
        Assertions.assertEquals((Object)expectedOrigin3D, (Object)EuclidCoreTools.origin3D);
        Assertions.assertEquals((int)expectedOrigin3D.hashCode(), (int)EuclidCoreTools.origin3D.hashCode());
        Assertions.assertEquals((Object)expectedOrigin3D.toString(), (Object)EuclidCoreTools.origin3D.toString());
        Vector2D expectedZeroVector2D = new Vector2D();
        Assertions.assertEquals((Object)expectedZeroVector2D, (Object)EuclidCoreTools.zeroVector2D);
        Assertions.assertEquals((int)expectedZeroVector2D.hashCode(), (int)EuclidCoreTools.zeroVector2D.hashCode());
        Assertions.assertEquals((Object)expectedZeroVector2D.toString(), (Object)EuclidCoreTools.zeroVector2D.toString());
        Vector3D expectedZeroVector3D = new Vector3D();
        Assertions.assertEquals((Object)expectedZeroVector3D, (Object)EuclidCoreTools.zeroVector3D);
        Assertions.assertEquals((int)expectedZeroVector3D.hashCode(), (int)EuclidCoreTools.zeroVector3D.hashCode());
        Assertions.assertEquals((Object)expectedZeroVector3D.toString(), (Object)EuclidCoreTools.zeroVector3D.toString());
        Vector4D expectedQuaternion = new Vector4D();
        expectedQuaternion.setElement(3, 1.0);
        Assertions.assertEquals((Object)expectedQuaternion, (Object)EuclidCoreTools.neutralQuaternion);
        Assertions.assertEquals((int)expectedQuaternion.hashCode(), (int)EuclidCoreTools.neutralQuaternion.hashCode());
        Assertions.assertEquals((Object)expectedQuaternion.toString(), (Object)EuclidCoreTools.neutralQuaternion.toString());
        Matrix3D expectedZeroMatrix3D = new Matrix3D();
        expectedZeroMatrix3D.setToZero();
        Assertions.assertEquals((Object)expectedZeroMatrix3D, (Object)EuclidCoreTools.zeroMatrix3D);
        Assertions.assertEquals((Object)expectedZeroMatrix3D.toString(), (Object)EuclidCoreTools.zeroMatrix3D.toString());
        Assertions.assertEquals((int)expectedZeroMatrix3D.hashCode(), (int)EuclidCoreTools.zeroMatrix3D.hashCode());
        Matrix3D expectedIdentity3D = new Matrix3D();
        expectedIdentity3D.setIdentity();
        Assertions.assertEquals((Object)expectedIdentity3D, (Object)EuclidCoreTools.identityMatrix3D);
        Assertions.assertEquals((Object)expectedIdentity3D.toString(), (Object)EuclidCoreTools.identityMatrix3D.toString());
        Assertions.assertEquals((int)expectedIdentity3D.hashCode(), (int)EuclidCoreTools.identityMatrix3D.hashCode());
    }

    @Test
    public void testFastSquareRoot() throws Exception {
        double expectedValue;
        double actualValue;
        double squaredValue;
        int i;
        Random random = new Random(2342L);
        for (i = 0; i < 1000; ++i) {
            squaredValue = 1.5 * random.nextDouble();
            squaredValue = Math.min(squaredValue, 0.99999997892658);
            actualValue = EuclidCoreTools.fastSquareRoot((double)squaredValue);
            expectedValue = EuclidCoreTools.squareRoot((double)squaredValue);
            Assertions.assertEquals((double)expectedValue, (double)actualValue, (double)Double.MIN_VALUE);
        }
        for (i = 0; i < 1000; ++i) {
            squaredValue = 0.8 + 1.5 * random.nextDouble();
            squaredValue = Math.max(squaredValue, 1.00000002107342);
            actualValue = EuclidCoreTools.fastSquareRoot((double)squaredValue);
            expectedValue = EuclidCoreTools.squareRoot((double)squaredValue);
            Assertions.assertEquals((double)expectedValue, (double)actualValue, (double)Double.MIN_VALUE);
        }
        for (i = 0; i < 1000; ++i) {
            squaredValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.99999997892658, (double)1.00000002107342);
            squaredValue = Math.max(squaredValue, 1.00000002107342);
            actualValue = EuclidCoreTools.fastSquareRoot((double)squaredValue);
            expectedValue = EuclidCoreTools.squareRoot((double)squaredValue);
            Assertions.assertEquals((double)expectedValue, (double)actualValue, (double)Double.MIN_VALUE);
        }
    }

    @Test
    public void testContainsNaNWith2Elements() throws Exception {
        Assertions.assertFalse((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)Double.NaN, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)Double.NaN));
    }

    @Test
    public void testContainsNaNWith3Elements() throws Exception {
        Assertions.assertFalse((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)Double.NaN, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)Double.NaN, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)Double.NaN));
    }

    @Test
    public void testContainsNaNWith4Elements() throws Exception {
        Assertions.assertFalse((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)Double.NaN, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)Double.NaN, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)Double.NaN, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)Double.NaN));
    }

    @Test
    public void testContainsNaNWith9Elements() throws Exception {
        Assertions.assertFalse((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN, (double)0.0));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)Double.NaN));
    }

    @Test
    public void testContainsNaNWithArray() throws Exception {
        Assertions.assertFalse((boolean)EuclidCoreTools.containsNaN((double[])new double[0]));
        Assertions.assertFalse((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0}));
        Assertions.assertTrue((boolean)EuclidCoreTools.containsNaN((double[])new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN}));
    }

    @Test
    public void testNormSquaredWith2Elements() throws Exception {
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)-1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)-1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)2.0, (double)0.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)2.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)-2.0, (double)0.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)-2.0) == 4.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNormSquaredWith3Elements() throws Exception {
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)1.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)0.0) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)-1.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)-1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)-1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)2.0, (double)0.0, (double)0.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)2.0, (double)0.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)2.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)-2.0, (double)0.0, (double)0.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)-2.0, (double)0.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)-2.0) == 4.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNormSquaredWith4Elements() throws Exception {
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)1.0, (double)0.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)1.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)0.0, (double)1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)0.0, (double)0.0) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)-1.0, (double)0.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)-1.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)-1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)0.0, (double)-1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)2.0, (double)0.0, (double)0.0, (double)0.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)2.0, (double)0.0, (double)0.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)2.0, (double)0.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)0.0, (double)2.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)-2.0, (double)0.0, (double)0.0, (double)0.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)-2.0, (double)0.0, (double)0.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)-2.0, (double)0.0) == 4.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.normSquared((double)0.0, (double)0.0, (double)0.0, (double)-2.0) == 4.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNormWith2Elements() throws Exception {
        Assertions.assertTrue((EuclidCoreTools.norm((double)1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)-1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)-1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)2.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)2.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)-2.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)-2.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)-1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)-1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)2.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)2.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)-2.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)-2.0) == 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNormWith3Elements() throws Exception {
        Assertions.assertTrue((EuclidCoreTools.norm((double)1.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)0.0) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)-1.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)-1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)-1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)2.0, (double)0.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)2.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)2.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)-2.0, (double)0.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)-2.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)-2.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)1.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)0.0) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)-1.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)-1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)-1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)2.0, (double)0.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)2.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)2.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)-2.0, (double)0.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)-2.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)-2.0) == 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNormWith4Elements() throws Exception {
        Assertions.assertTrue((EuclidCoreTools.norm((double)1.0, (double)0.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)1.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)0.0, (double)1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)0.0, (double)0.0) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)-1.0, (double)0.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)-1.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)-1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)0.0, (double)-1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)2.0, (double)0.0, (double)0.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)2.0, (double)0.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)2.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)0.0, (double)2.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)-2.0, (double)0.0, (double)0.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)-2.0, (double)0.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)-2.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.norm((double)0.0, (double)0.0, (double)0.0, (double)-2.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)1.0, (double)0.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)1.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)0.0, (double)1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)0.0, (double)0.0) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)-1.0, (double)0.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)-1.0, (double)0.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)-1.0, (double)0.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)0.0, (double)-1.0) == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)2.0, (double)0.0, (double)0.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)2.0, (double)0.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)2.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)0.0, (double)2.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)-2.0, (double)0.0, (double)0.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)-2.0, (double)0.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)-2.0, (double)0.0) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((EuclidCoreTools.fastNorm((double)0.0, (double)0.0, (double)0.0, (double)-2.0) == 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void testTrimAngleMinusPiToPi() throws Exception {
        Random random = new Random(2323L);
        for (int i = 0; i < 1000; ++i) {
            double startOfRange = -Math.PI;
            double endOfRange = Math.PI;
            double expectedAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)startOfRange, (double)endOfRange);
            double angleToShift = expectedAngle + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            double actualAngle = EuclidCoreTools.trimAngleMinusPiToPi((double)angleToShift);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12, (String)("iteration: " + i));
            expectedAngle = startOfRange;
            angleToShift = expectedAngle + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            actualAngle = EuclidCoreTools.trimAngleMinusPiToPi((double)angleToShift);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12);
            expectedAngle = endOfRange - 1.0E-9;
            angleToShift = expectedAngle + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            actualAngle = EuclidCoreTools.trimAngleMinusPiToPi((double)angleToShift);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12);
        }
    }

    @Test
    public void testAngleDifferenceMinusPiToPi() throws Exception {
        Random random = new Random(2323L);
        for (int i = 0; i < 1000; ++i) {
            double startOfRange = -Math.PI;
            double endOfRange = Math.PI;
            double expectedDifference = EuclidCoreRandomTools.nextDouble((Random)random, (double)startOfRange, (double)endOfRange);
            double untrimmedDifference = expectedDifference + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            double angleA = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 4));
            double angleB = angleA - untrimmedDifference;
            double actualDifference = EuclidCoreTools.angleDifferenceMinusPiToPi((double)angleA, (double)angleB);
            Assertions.assertEquals((double)expectedDifference, (double)actualDifference, (double)1.0E-12, (String)("iteration: " + i));
        }
    }

    @Test
    public void testShiftAngleInRange() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            double startOfRange = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 2));
            double endOfRange = startOfRange + Math.PI * 2;
            double expectedAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)startOfRange, (double)endOfRange);
            double angleToShift = expectedAngle + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            double actualAngle = EuclidCoreTools.shiftAngleInRange((double)angleToShift, (double)startOfRange);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12, (String)("iteration: " + i));
            expectedAngle = startOfRange;
            angleToShift = expectedAngle + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            actualAngle = EuclidCoreTools.shiftAngleInRange((double)angleToShift, (double)startOfRange);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12);
            expectedAngle = endOfRange - 1.0E-9;
            angleToShift = expectedAngle + (double)(random.nextInt(21) - 10) * 2.0 * Math.PI;
            actualAngle = EuclidCoreTools.shiftAngleInRange((double)angleToShift, (double)startOfRange);
            Assertions.assertEquals((double)expectedAngle, (double)actualAngle, (double)1.0E-12);
        }
    }

    @Test
    public void testAngleGeometricallyEquals() throws Exception {
        double angleA;
        double epsilon;
        int i;
        Random random = new Random(35635L);
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-12, (double)0.5);
            angleA = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 10));
            double angleNotEqual = angleA + (random.nextBoolean() ? -1.01 : 1.01) * epsilon;
            double angleEqual = angleA + (random.nextBoolean() ? -0.99 : 0.99) * epsilon;
            Assertions.assertFalse((boolean)EuclidCoreTools.angleGeometricallyEquals((double)angleA, (double)angleNotEqual, (double)epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.angleGeometricallyEquals((double)angleA, (double)angleEqual, (double)epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-12, (double)0.5);
            angleA = EuclidCoreRandomTools.nextDouble((Random)random, (double)(Math.PI * 10));
            double twoPIMutiple = (double)random.nextInt(15) * 2.0 * Math.PI;
            if (random.nextBoolean()) {
                twoPIMutiple = -twoPIMutiple;
            }
            double angleNotEqual = angleA + (random.nextBoolean() ? -1.01 : 1.01) * epsilon + twoPIMutiple;
            double angleEqual = angleA + (random.nextBoolean() ? -0.99 : 0.99) * epsilon + twoPIMutiple;
            Assertions.assertFalse((boolean)EuclidCoreTools.angleGeometricallyEquals((double)angleA, (double)angleNotEqual, (double)epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.angleGeometricallyEquals((double)angleA, (double)angleEqual, (double)epsilon));
        }
    }

    @Test
    public void testIsAngleZero() throws Exception {
        Random random = new Random(35635L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-12, (double)0.5);
            double twoPIMutiple = (double)random.nextInt(15) * 2.0 * Math.PI;
            double zeroAngle = 0.99 * EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            double nonZeroAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(1.01 * epsilon), (double)Math.PI);
            if (random.nextBoolean()) {
                nonZeroAngle = -nonZeroAngle;
            }
            Assertions.assertTrue((boolean)EuclidCoreTools.isAngleZero((double)zeroAngle, (double)epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.isAngleZero((double)(zeroAngle + twoPIMutiple), (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.isAngleZero((double)nonZeroAngle, (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.isAngleZero((double)(nonZeroAngle + twoPIMutiple), (double)epsilon));
        }
    }

    @Test
    public void testMax() throws Exception {
        double c;
        double b;
        double a;
        int i;
        Random random = new Random(45645L);
        for (i = 0; i < 1000; ++i) {
            double actual;
            a = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double expected = Math.max(a, Math.max(b = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), c = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0)));
            Assertions.assertTrue((expected == (actual = EuclidCoreTools.max((double)a, (double)b, (double)c)) ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            double actual;
            double d;
            a = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double expected = Math.max(a, Math.max(b = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), Math.max(c = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), d = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0))));
            Assertions.assertTrue((expected == (actual = EuclidCoreTools.max((double)a, (double)b, (double)c, (double)d)) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMin() throws Exception {
        double c;
        double b;
        double a;
        int i;
        Random random = new Random(45645L);
        for (i = 0; i < 1000; ++i) {
            double actual;
            a = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double expected = Math.min(a, Math.min(b = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), c = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0)));
            Assertions.assertTrue((expected == (actual = EuclidCoreTools.min((double)a, (double)b, (double)c)) ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            double actual;
            double d;
            a = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double expected = Math.min(a, Math.min(b = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), Math.min(c = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), d = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0))));
            Assertions.assertTrue((expected == (actual = EuclidCoreTools.min((double)a, (double)b, (double)c, (double)d)) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMed() throws Exception {
        Random random = new Random(45645L);
        for (int i = 0; i < 1000; ++i) {
            double a = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double b = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double c = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double[] sorted = new double[]{a, b, c};
            Arrays.sort(sorted);
            double expected = sorted[1];
            double actual = EuclidCoreTools.med((double)a, (double)b, (double)c);
            if (expected != actual) {
                EuclidCoreTools.med((double)a, (double)b, (double)c);
            }
            Assertions.assertTrue((expected == actual ? 1 : 0) != 0, (String)("a = " + a + ", b = " + b + ", c = " + c));
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        double epsilon;
        int i;
        Random random = new Random(34235L);
        for (i = 0; i < 1000; ++i) {
            epsilon = 0.0;
            double value = EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32);
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)value, (double)value, (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)value, (double)Math.nextUp(value), (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)value, (double)Math.nextDown(value), (double)epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            double expectedValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32);
            double actualValue = expectedValue + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)epsilon);
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)expectedValue, (double)actualValue, (double)epsilon));
            actualValue = expectedValue - EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)epsilon);
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)expectedValue, (double)actualValue, (double)epsilon));
            actualValue = expectedValue + EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon, (double)(10.0 * epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)expectedValue, (double)actualValue, (double)epsilon));
            actualValue = expectedValue - EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon, (double)(10.0 * epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)expectedValue, (double)actualValue, (double)epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)Double.NaN, (double)Double.NaN, (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)Double.NaN, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32), (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32), (double)Double.NaN, (double)epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)Double.POSITIVE_INFINITY, (double)Double.POSITIVE_INFINITY, (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)Double.POSITIVE_INFINITY, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32), (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32), (double)Double.POSITIVE_INFINITY, (double)epsilon));
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)Double.NEGATIVE_INFINITY, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32), (double)epsilon));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)-1.0E32, (double)1.0E32), (double)Double.NEGATIVE_INFINITY, (double)epsilon));
        }
    }

    @Test
    public void testInterpolate() throws Exception {
        Random random = new Random(3665L);
        for (int i = 0; i < 1000; ++i) {
            double a = random.nextDouble();
            double b = random.nextDouble();
            double alpha = random.nextDouble();
            double result = EuclidCoreTools.interpolate((double)a, (double)b, (double)alpha);
            double expected = a + alpha * (b - a);
            Assertions.assertEquals((double)result, (double)expected, (double)1.0E-10);
            alpha = 0.5;
            result = EuclidCoreTools.interpolate((double)a, (double)b, (double)alpha);
            Assertions.assertTrue((result == 0.5 * a + 0.5 * b ? 1 : 0) != 0);
            alpha = 0.0;
            result = EuclidCoreTools.interpolate((double)a, (double)b, (double)alpha);
            Assertions.assertTrue((result == a ? 1 : 0) != 0);
            alpha = 1.0;
            result = EuclidCoreTools.interpolate((double)a, (double)b, (double)alpha);
            Assertions.assertTrue((result == b ? 1 : 0) != 0);
            for (alpha = -2.0; alpha <= 2.0; alpha += 0.1) {
                result = EuclidCoreTools.interpolate((double)a, (double)b, (double)alpha);
                Assertions.assertEquals((double)result, (double)(a + alpha * (b - a)), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testClamp() throws Exception {
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            double minMax = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0);
            double valueInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)minMax);
            double valueUnder = EuclidCoreRandomTools.nextDouble((Random)random, (double)-100.0, (double)0.0) - minMax;
            double valueOver = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0) + minMax;
            Assertions.assertTrue((valueInside == EuclidCoreTools.clamp((double)valueInside, (double)minMax) ? 1 : 0) != 0);
            Assertions.assertTrue((-minMax == EuclidCoreTools.clamp((double)valueUnder, (double)minMax) ? 1 : 0) != 0);
            Assertions.assertTrue((minMax == EuclidCoreTools.clamp((double)valueOver, (double)minMax) ? 1 : 0) != 0);
        }
        EuclidCoreTestTools.assertExceptionIsThrown(() -> EuclidCoreTools.clamp((double)0.0, (double)-1.01E-10), (Class[])new Class[]{RuntimeException.class});
        for (i = 0; i < 1000; ++i) {
            double min = EuclidCoreRandomTools.nextDouble((Random)random, (double)-100.0, (double)100.0);
            double max = min + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0);
            double valueInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)min, (double)max);
            double valueUnder = min - EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0);
            double valueOver = max + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0);
            Assertions.assertTrue((valueInside == EuclidCoreTools.clamp((double)valueInside, (double)min, (double)max) ? 1 : 0) != 0);
            Assertions.assertTrue((min == EuclidCoreTools.clamp((double)valueUnder, (double)min, (double)max) ? 1 : 0) != 0);
            Assertions.assertTrue((max == EuclidCoreTools.clamp((double)valueOver, (double)min, (double)max) ? 1 : 0) != 0);
        }
        double min = EuclidCoreRandomTools.nextDouble((Random)random, (double)-100.0, (double)100.0);
        EuclidCoreTestTools.assertExceptionIsThrown(() -> EuclidCoreTools.clamp((double)0.0, (double)min, (double)(min - 1.0E-10 - 1.0E-12)), (Class[])new Class[]{RuntimeException.class});
    }

    @Test
    public void testFastAcos() {
        double error;
        double actual;
        double expected;
        double x;
        double epsilon = 1.0E-14;
        double maxError = 0.0;
        double maxErrorX = 0.0;
        for (x = -1.0; x < 1.0; x += 1.0E-6) {
            expected = Math.acos(x);
            actual = EuclidCoreTools.fastAcos((double)x);
            Assertions.assertEquals((double)expected, (double)actual, (double)epsilon, (String)("x=" + x));
            error = Math.abs(actual - expected);
            if (!(error > maxError)) continue;
            maxError = error;
            maxErrorX = x;
        }
        x = -1.0;
        expected = Math.acos(x);
        actual = EuclidCoreTools.fastAcos((double)x);
        Assertions.assertEquals((double)expected, (double)actual, (double)epsilon, (String)("x=" + x));
        error = Math.abs(actual - expected);
        if (error > maxError) {
            maxError = error;
            maxErrorX = x;
        }
        x = 1.0;
        expected = Math.acos(x);
        actual = EuclidCoreTools.fastAcos((double)x);
        Assertions.assertEquals((double)expected, (double)actual, (double)epsilon, (String)("x=" + x));
        error = Math.abs(actual - expected);
        if (error > maxError) {
            maxError = error;
            maxErrorX = x;
        }
        System.out.println("EuclidCoreToolsTest.testFastAcos: max error=" + maxError + " at x=" + maxErrorX);
    }

    @Test
    public void testReverse() {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            ArrayList<Integer> originalList = new ArrayList<Integer>();
            int size = random.nextInt(20);
            while (originalList.size() < size) {
                originalList.add(originalList.size());
            }
            int fromIndex = size == 0 ? 0 : random.nextInt(size);
            int toIndex = size == 0 ? 0 : fromIndex + random.nextInt(originalList.size() - fromIndex);
            ArrayList expected = new ArrayList(originalList);
            Collections.reverse(expected.subList(fromIndex, toIndex));
            ArrayList actual = new ArrayList(originalList);
            EuclidCoreTools.reverse(actual, (int)fromIndex, (int)toIndex);
            Assertions.assertEquals(expected, actual);
        }
    }

    @Test
    public void testRotate() {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            ArrayList<Integer> originalList = new ArrayList<Integer>();
            int shift = random.nextInt(100);
            int size = random.nextInt(100);
            while (originalList.size() < size) {
                originalList.add(originalList.size());
            }
            int fromIndex = size == 0 ? 0 : random.nextInt(size);
            int toIndex = size == 0 ? 0 : fromIndex + random.nextInt(originalList.size() - fromIndex);
            int subSize = toIndex - fromIndex;
            ArrayList<Integer> expectedList = new ArrayList<Integer>(originalList);
            for (int j = fromIndex; j < toIndex; ++j) {
                int originalIndex = EuclidCoreTools.wrap((int)(j - fromIndex - shift), (int)subSize) + fromIndex;
                expectedList.set(j, (Integer)originalList.get(originalIndex));
            }
            ArrayList actualList = new ArrayList(originalList);
            EuclidCoreTools.rotate(actualList, (int)fromIndex, (int)toIndex, (int)shift);
            Assertions.assertEquals(expectedList, actualList);
            expectedList = new ArrayList(originalList);
            Collections.rotate(expectedList.subList(fromIndex, toIndex), shift);
            Assertions.assertEquals(expectedList, actualList);
        }
        List<Integer> list = Arrays.asList(0, 1, 2, 3, 4);
        EuclidCoreTools.rotate(list, (int)0, (int)list.size(), (int)-1);
        Assertions.assertEquals(Arrays.asList(1, 2, 3, 4, 0), list);
        list = Arrays.asList(0, 1, 2, 3, 4);
        EuclidCoreTools.rotate(list, (int)0, (int)list.size(), (int)1);
        Assertions.assertEquals(Arrays.asList(4, 0, 1, 2, 3), list);
        list = Arrays.asList(9, 0, 1, 2, 9);
        EuclidCoreTools.rotate(list, (int)1, (int)4, (int)-1);
        Assertions.assertEquals(Arrays.asList(9, 1, 2, 0, 9), list);
        list = Arrays.asList(9, 0, 1, 2, 9);
        EuclidCoreTools.rotate(list, (int)1, (int)4, (int)1);
        Assertions.assertEquals(Arrays.asList(9, 2, 0, 1, 9), list);
    }
}

