/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidCoreRandomToolsTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testNextVector3D() {
        Random random = new Random(16451L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D vector = EuclidCoreRandomTools.nextVector3D((Random)random);
            for (int j = 0; j < 3; ++j) {
                Assertions.assertTrue((Math.abs(vector.getElement(j)) <= 1.0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testNextOrthogonalVector3D() throws Exception {
        int i;
        Random random = new Random(346346L);
        for (i = 0; i < 1000; ++i) {
            Vector3D randomVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)randomVector, (boolean)false);
            Assertions.assertEquals((double)0.0, (double)randomVector.dot((Tuple3DReadOnly)orthogonal), (double)1.0E-12);
            orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)randomVector, (boolean)true);
            Assertions.assertEquals((double)0.0, (double)randomVector.dot((Tuple3DReadOnly)orthogonal), (double)1.0E-12);
            Assertions.assertEquals((double)1.0, (double)orthogonal.norm(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            Axis3D vector = Axis3D.values[random.nextInt(3)];
            Vector3D orthogonal1 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)vector, (boolean)false);
            Assertions.assertEquals((double)0.0, (double)vector.dot((Tuple3DReadOnly)orthogonal1), (double)1.0E-12);
            Vector3D orthogonal2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)vector, (boolean)false);
            Assertions.assertEquals((double)0.0, (double)vector.dot((Tuple3DReadOnly)orthogonal2), (double)1.0E-12);
            Assertions.assertFalse((boolean)orthogonal1.epsilonEquals((EuclidGeometry)orthogonal2, 1.0E-12));
            orthogonal1 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)vector, (boolean)true);
            Assertions.assertEquals((double)0.0, (double)vector.dot((Tuple3DReadOnly)orthogonal1), (double)1.0E-12);
            Assertions.assertEquals((double)1.0, (double)orthogonal1.norm(), (double)1.0E-12);
            orthogonal2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)vector, (boolean)true);
            Assertions.assertEquals((double)0.0, (double)vector.dot((Tuple3DReadOnly)orthogonal2), (double)1.0E-12);
            Assertions.assertEquals((double)1.0, (double)orthogonal2.norm(), (double)1.0E-12);
            Assertions.assertFalse((boolean)orthogonal1.epsilonEquals((EuclidGeometry)orthogonal2, 1.0E-12));
        }
    }

    @Test
    public void testRandomizeTuple3D() {
        Random random = new Random(6841032L);
        Point3D tupleToRandomize = new Point3D();
        Point3D tupleToRandomizeCopy = new Point3D();
        tupleToRandomizeCopy.setX(tupleToRandomize.getX());
        tupleToRandomizeCopy.setY(tupleToRandomize.getY());
        tupleToRandomizeCopy.setZ(tupleToRandomize.getZ());
        Point3D previousValue = new Point3D();
        previousValue.setToNaN();
        for (int i = 0; i < 1000; ++i) {
            EuclidCoreRandomTools.randomizeTuple3D((Random)random, (Tuple3DBasics)tupleToRandomize);
            Assertions.assertTrue((-1.0 <= tupleToRandomize.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((tupleToRandomize.getX() <= 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((-1.0 <= tupleToRandomize.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((tupleToRandomize.getY() <= 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((-1.0 <= tupleToRandomize.getZ() ? 1 : 0) != 0);
            Assertions.assertTrue((tupleToRandomize.getZ() <= 1.0 ? 1 : 0) != 0);
            Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple3DReadOnly)tupleToRandomize, (Tuple3DReadOnly)previousValue, (double)1.0E-10));
            previousValue.set((Tuple3DReadOnly)tupleToRandomize);
        }
        for (int i = 0; i < 1000; ++i) {
            Point3D minMax = new Point3D();
            minMax.setX(random.nextDouble());
            minMax.setY(random.nextDouble());
            minMax.setZ(random.nextDouble());
            EuclidCoreRandomTools.randomizeTuple3D((Random)random, (Tuple3DReadOnly)minMax, (Tuple3DBasics)tupleToRandomize);
            Assertions.assertTrue((tupleToRandomizeCopy.getX() - minMax.getX() <= tupleToRandomize.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((tupleToRandomize.getX() <= tupleToRandomizeCopy.getX() + minMax.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((tupleToRandomizeCopy.getY() - minMax.getY() <= tupleToRandomize.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((tupleToRandomize.getY() <= tupleToRandomizeCopy.getY() + minMax.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((tupleToRandomizeCopy.getZ() - minMax.getZ() <= tupleToRandomize.getZ() ? 1 : 0) != 0);
            Assertions.assertTrue((tupleToRandomize.getZ() <= tupleToRandomizeCopy.getZ() + minMax.getZ() ? 1 : 0) != 0);
        }
        Point3D min = new Point3D();
        Point3D max = new Point3D();
        for (int i = 0; i < 1000; ++i) {
            min.setX(random.nextDouble());
            min.setY(random.nextDouble());
            min.setZ(random.nextDouble());
            max.setX(min.getX() + random.nextDouble());
            max.setY(min.getY() + random.nextDouble());
            max.setZ(min.getZ() + random.nextDouble());
            EuclidCoreRandomTools.randomizeTuple3D((Random)random, (Tuple3DReadOnly)min, (Tuple3DReadOnly)max, (Tuple3DBasics)tupleToRandomize);
            Assertions.assertTrue((tupleToRandomizeCopy.getX() - min.getX() <= tupleToRandomize.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((tupleToRandomize.getX() <= tupleToRandomizeCopy.getX() + max.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((tupleToRandomizeCopy.getY() - min.getY() <= tupleToRandomize.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((tupleToRandomize.getY() <= tupleToRandomizeCopy.getY() + max.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((tupleToRandomizeCopy.getZ() - min.getZ() <= tupleToRandomize.getZ() ? 1 : 0) != 0);
            Assertions.assertTrue((tupleToRandomize.getZ() <= tupleToRandomizeCopy.getZ() + max.getZ() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNextAxisAngle() throws Exception {
        boolean hasChanged;
        double uNorm;
        int i;
        Random random = new Random(54654L);
        AxisAngle axisAngle = new AxisAngle();
        AxisAngle axisAnglePrevious = new AxisAngle();
        double minMax = 1.0;
        double actualAngleMin = Double.POSITIVE_INFINITY;
        double actualAngleMax = Double.NEGATIVE_INFINITY;
        axisAnglePrevious.setToNaN();
        for (i = 0; i < 1000; ++i) {
            EuclidCoreRandomTools.randomizeAxisAngle((Random)random, (double)minMax, (AxisAngleBasics)axisAngle);
            Assertions.assertTrue((Math.abs(axisAngle.getAngle()) < minMax ? 1 : 0) != 0);
            uNorm = EuclidCoreTools.norm((double)axisAngle.getX(), (double)axisAngle.getY(), (double)axisAngle.getZ());
            Assertions.assertTrue((Math.abs(uNorm - 1.0) < 1.0E-12 ? 1 : 0) != 0);
            hasChanged = axisAngle.getX() != axisAnglePrevious.getX();
            hasChanged &= axisAngle.getY() != axisAnglePrevious.getY();
            hasChanged &= axisAngle.getZ() != axisAnglePrevious.getZ();
            Assertions.assertTrue((boolean)(hasChanged &= axisAngle.getAngle() != axisAnglePrevious.getAngle()));
            actualAngleMin = Math.min(actualAngleMin, axisAngle.getAngle());
            actualAngleMax = Math.max(actualAngleMax, axisAngle.getAngle());
            axisAnglePrevious.setX(axisAngle.getX());
            axisAnglePrevious.setY(axisAngle.getY());
            axisAnglePrevious.setZ(axisAngle.getZ());
            axisAnglePrevious.setAngle(axisAngle.getAngle());
        }
        Assertions.assertTrue((actualAngleMax > 0.75 * minMax ? 1 : 0) != 0);
        Assertions.assertTrue((actualAngleMin < -0.75 * minMax ? 1 : 0) != 0);
        axisAnglePrevious.setToNaN();
        for (i = 0; i < 1000; ++i) {
            EuclidCoreRandomTools.randomizeAxisAngle((Random)random, (AxisAngleBasics)axisAngle);
            Assertions.assertTrue((Math.abs(axisAngle.getAngle()) < Math.PI ? 1 : 0) != 0);
            uNorm = EuclidCoreTools.norm((double)axisAngle.getX(), (double)axisAngle.getY(), (double)axisAngle.getZ());
            Assertions.assertTrue((Math.abs(uNorm - 1.0) < 1.0E-12 ? 1 : 0) != 0);
            hasChanged = axisAngle.getX() != axisAnglePrevious.getX();
            hasChanged &= axisAngle.getY() != axisAnglePrevious.getY();
            hasChanged &= axisAngle.getZ() != axisAnglePrevious.getZ();
            Assertions.assertTrue((boolean)(hasChanged &= axisAngle.getAngle() != axisAnglePrevious.getAngle()));
            axisAnglePrevious.setX(axisAngle.getX());
            axisAnglePrevious.setY(axisAngle.getY());
            axisAnglePrevious.setZ(axisAngle.getZ());
            axisAnglePrevious.setAngle(axisAngle.getAngle());
        }
    }

    @Test
    public void testNextMatrix3D() throws Exception {
        int i;
        Random random = new Random(23452L);
        for (i = 0; i < 1000; ++i) {
            Matrix3D matrix3D = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    Assertions.assertTrue((matrix3D.getElement(row, column) <= 1.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((matrix3D.getElement(row, column) >= -1.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((matrix3D.getElement(row, column) != 0.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((boolean)Double.isFinite(matrix3D.getElement(row, column)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            double minMaxValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0);
            Matrix3D matrix3D = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)minMaxValue);
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    Assertions.assertTrue((matrix3D.getElement(row, column) <= minMaxValue ? 1 : 0) != 0);
                    Assertions.assertTrue((matrix3D.getElement(row, column) >= -minMaxValue ? 1 : 0) != 0);
                    Assertions.assertTrue((matrix3D.getElement(row, column) != 0.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((boolean)Double.isFinite(matrix3D.getElement(row, column)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            double minValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)100.0);
            double maxValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)minValue, (double)100.0);
            Matrix3D matrix3D = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)minValue, (double)maxValue);
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    Assertions.assertTrue((matrix3D.getElement(row, column) <= maxValue ? 1 : 0) != 0);
                    Assertions.assertTrue((matrix3D.getElement(row, column) >= minValue ? 1 : 0) != 0);
                    Assertions.assertTrue((matrix3D.getElement(row, column) != 0.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((boolean)Double.isFinite(matrix3D.getElement(row, column)));
                }
            }
        }
        try {
            EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)-0.1);
            Assertions.fail((String)"Should have thrown an exception.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)0.1, (double)0.05);
            Assertions.fail((String)"Should have thrown an exception.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)-0.1, (double)-0.15);
            Assertions.fail((String)"Should have thrown an exception.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testNextDiagonalMatrix3D() throws Exception {
        int i;
        Random random = new Random(23452L);
        for (i = 0; i < 1000; ++i) {
            Matrix3D matrix3D = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random);
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    if (row != column) {
                        Assertions.assertTrue((matrix3D.getElement(row, column) == 0.0 ? 1 : 0) != 0);
                        continue;
                    }
                    Assertions.assertTrue((matrix3D.getElement(row, column) <= 1.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((matrix3D.getElement(row, column) >= -1.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((matrix3D.getElement(row, column) != 0.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((boolean)Double.isFinite(matrix3D.getElement(row, column)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            double minMaxValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0);
            Matrix3D matrix3D = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)minMaxValue);
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    if (row != column) {
                        Assertions.assertTrue((matrix3D.getElement(row, column) == 0.0 ? 1 : 0) != 0);
                        continue;
                    }
                    Assertions.assertTrue((matrix3D.getElement(row, column) <= minMaxValue ? 1 : 0) != 0);
                    Assertions.assertTrue((matrix3D.getElement(row, column) >= -minMaxValue ? 1 : 0) != 0);
                    Assertions.assertTrue((matrix3D.getElement(row, column) != 0.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((boolean)Double.isFinite(matrix3D.getElement(row, column)));
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            double minValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)100.0);
            double maxValue = EuclidCoreRandomTools.nextDouble((Random)random, (double)minValue, (double)100.0);
            Matrix3D matrix3D = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)minValue, (double)maxValue);
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    if (row != column) {
                        Assertions.assertTrue((matrix3D.getElement(row, column) == 0.0 ? 1 : 0) != 0);
                        continue;
                    }
                    Assertions.assertTrue((matrix3D.getElement(row, column) <= maxValue ? 1 : 0) != 0);
                    Assertions.assertTrue((matrix3D.getElement(row, column) >= minValue ? 1 : 0) != 0);
                    Assertions.assertTrue((matrix3D.getElement(row, column) != 0.0 ? 1 : 0) != 0);
                    Assertions.assertTrue((boolean)Double.isFinite(matrix3D.getElement(row, column)));
                }
            }
        }
        try {
            EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)-0.1);
            Assertions.fail((String)"Should have thrown an exception.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)0.1, (double)0.05);
            Assertions.fail((String)"Should have thrown an exception.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)-0.1, (double)-0.15);
            Assertions.fail((String)"Should have thrown an exception.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

