/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.tools;

import java.util.Arrays;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DBasics;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

class EuclidShapeRandomToolsTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    EuclidShapeRandomToolsTest() {
    }

    @Test
    void testNextPoint2DInTriangle() {
        Random random = new Random(43L);
        for (int i = 0; i < 1000; ++i) {
            Point2D a = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)5.0);
            Point2D b = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)5.0);
            Point2D c = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)5.0);
            Point2D nextPoint = EuclidGeometryRandomTools.nextPoint2DInTriangle((Random)random, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c);
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)nextPoint, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
        }
        int numberOfPoints = 1000000;
        double averageDistanceToCentroid = 0.0;
        double averageDistanceToA = 0.0;
        double averageDistanceToB = 0.0;
        double averageDistanceToC = 0.0;
        for (int i = 0; i < numberOfPoints; ++i) {
            double l = random.nextDouble();
            Vector2D ab = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)l);
            Vector2D ac = new Vector2D();
            RotationMatrixTools.applyYawRotation((double)1.0471975511965976, (Tuple2DReadOnly)ab, (Tuple2DBasics)ac);
            Point2D a = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)5.0);
            Point2D b = new Point2D((Tuple2DReadOnly)a);
            Point2D c = new Point2D((Tuple2DReadOnly)a);
            b.add((Tuple2DReadOnly)ab);
            c.add((Tuple2DReadOnly)ac);
            Assertions.assertEquals((double)l, (double)b.distance((Point2DReadOnly)c), (double)1.0E-12);
            Point2D nextPoint = EuclidGeometryRandomTools.nextPoint2DInTriangle((Random)random, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c);
            Assertions.assertTrue((boolean)EuclidGeometryTools.isPoint2DInsideTriangleABC((Point2DReadOnly)nextPoint, (Point2DReadOnly)a, (Point2DReadOnly)b, (Point2DReadOnly)c));
            Point2D centroid = EuclidGeometryTools.averagePoint2Ds(Arrays.asList(a, b, c));
            averageDistanceToCentroid += centroid.distance((Point2DReadOnly)nextPoint) / (double)numberOfPoints;
            averageDistanceToA += a.distance((Point2DReadOnly)nextPoint) / (double)numberOfPoints;
            averageDistanceToB += a.distance((Point2DReadOnly)nextPoint) / (double)numberOfPoints;
            averageDistanceToC += a.distance((Point2DReadOnly)nextPoint) / (double)numberOfPoints;
        }
        double sqrt3 = EuclidCoreTools.squareRoot((double)3.0);
        double expectedDistanceToCentroid = (8.0 * sqrt3 + 3.0 * EuclidShapeRandomToolsTest.asinh(sqrt3) + Math.log(2.0 + sqrt3)) / 72.0;
        Assertions.assertEquals((double)(0.5 * expectedDistanceToCentroid), (double)averageDistanceToCentroid, (double)1.0E-4);
        double expectedDistanceToAnyVertex = (4.0 + 3.0 * Math.log(3.0)) / 12.0;
        Assertions.assertEquals((double)(0.5 * expectedDistanceToAnyVertex), (double)averageDistanceToA, (double)0.001);
        Assertions.assertEquals((double)(0.5 * expectedDistanceToAnyVertex), (double)averageDistanceToB, (double)0.001);
        Assertions.assertEquals((double)(0.5 * expectedDistanceToAnyVertex), (double)averageDistanceToC, (double)0.001);
    }

    @Test
    public void testNextConvexShape() {
        Random random = new Random(4367L);
        for (int i = 0; i < 1000; ++i) {
            Point3D shapeCentroid = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Shape3DBasics next = EuclidShapeRandomTools.nextConvexShape3D((Random)random, (Tuple3DReadOnly)shapeCentroid);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)shapeCentroid, (EuclidGeometry)next.getCentroid(), (double)1.0E-12);
        }
    }

    private static double asinh(double x) {
        return Math.log(x + EuclidCoreTools.squareRoot((double)(x * x + 1.0)));
    }
}

