/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.collision.gjk;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.collision.EuclidFrameShape3DCollisionResult;
import us.ihmc.euclid.referenceFrame.collision.gjk.FrameGilbertJohnsonKeerthiCollisionDetector;
import us.ihmc.euclid.referenceFrame.collision.interfaces.EuclidFrameShape3DCollisionResultBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePointShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeRandomTools;
import us.ihmc.euclid.shape.collision.EuclidShape3DCollisionResult;
import us.ihmc.euclid.shape.collision.gjk.GilbertJohnsonKeerthiCollisionDetector;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultBasics;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;

public class FrameGilbertJohnsonKeerthiCollisionDetectorTest {
    private static final boolean VERBOSE = false;
    private static final int ITERATIONS = 10000;
    private static final double DISTANCE_EPSILON = 0.0;
    private static final double POINT_TANGENTIAL_EPSILON = 0.0;
    private static final double LARGE_DISTANCE_EPSILON = 1.0E-7;
    private static final double LARGE_POINT_TANGENTIAL_EPSILON = 1.0E-4;
    private static final double DISTANCE_AVERAGE_EPSILON = 1.0E-10;
    private static final double POINT_NORMAL_ERROR_AVERAGE_EPSILON = 1.0E-10;
    private static final double POINT_TANGENTIAL_ERROR_AVERAGE_EPSILON = 1.0E-7;

    @Test
    void testReusingSupportDirection() {
        int newNumberOfIterations;
        EuclidFrameShape3DCollisionResult actualResult;
        FrameVector3D initialSupportDirection;
        int originalNumberOfIterations;
        EuclidFrameShape3DCollisionResult expectedResult;
        FrameShape3DBasics shapeB;
        FrameShape3DBasics shapeA;
        int i;
        Random random = new Random(789034504L);
        Object[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        FrameGilbertJohnsonKeerthiCollisionDetector detector = new FrameGilbertJohnsonKeerthiCollisionDetector();
        double distanceEpsilon = 1.0E-4;
        double pointTangentialEpsilon = 0.01;
        int totalIterationsWithoutHint = 0;
        int totalIterationsWithHint = 0;
        for (i = 0; i < 10000; ++i) {
            shapeA = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])referenceFrames)));
            expectedResult = detector.evaluateCollision((FrameShape3DReadOnly)shapeA, (FrameShape3DReadOnly)(shapeB = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])referenceFrames)))));
            if (expectedResult.areShapesColliding()) {
                --i;
                continue;
            }
            originalNumberOfIterations = detector.getNumberOfIterations();
            initialSupportDirection = new FrameVector3D((FrameTuple3DReadOnly)detector.getSupportDirection());
            detector.setInitialSupportDirection((FrameVector3DReadOnly)initialSupportDirection);
            actualResult = detector.evaluateCollision((FrameShape3DReadOnly)shapeA, (FrameShape3DReadOnly)shapeB);
            newNumberOfIterations = detector.getNumberOfIterations();
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)distanceEpsilon, (double)pointTangentialEpsilon, (double)0.0);
            totalIterationsWithoutHint += originalNumberOfIterations;
            totalIterationsWithHint += newNumberOfIterations;
        }
        Assertions.assertTrue((totalIterationsWithHint < totalIterationsWithoutHint / 3 ? 1 : 0) != 0);
        totalIterationsWithoutHint = 0;
        totalIterationsWithHint = 0;
        for (i = 0; i < 10000; ++i) {
            shapeA = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])referenceFrames)));
            shapeB = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)((ReferenceFrame)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])referenceFrames)));
            if (shapeA instanceof FramePointShape3DReadOnly && shapeB instanceof FramePointShape3DReadOnly) {
                --i;
                continue;
            }
            expectedResult = detector.evaluateCollision((FrameShape3DReadOnly)shapeA, (FrameShape3DReadOnly)shapeB);
            while (!expectedResult.areShapesColliding()) {
                FramePoint3D centroidSeparation = new FramePoint3D((FrameTuple3DReadOnly)shapeB.getCentroid());
                centroidSeparation.changeFrame(shapeA.getReferenceFrame());
                centroidSeparation.sub((FrameTuple3DReadOnly)shapeA.getCentroid());
                centroidSeparation.scale(0.5);
                shapeA.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)centroidSeparation));
                expectedResult = detector.evaluateCollision((FrameShape3DReadOnly)shapeA, (FrameShape3DReadOnly)shapeB);
            }
            originalNumberOfIterations = detector.getNumberOfIterations();
            initialSupportDirection = new FrameVector3D((FrameTuple3DReadOnly)detector.getSupportDirection());
            detector.setInitialSupportDirection((FrameVector3DReadOnly)initialSupportDirection);
            actualResult = detector.evaluateCollision((FrameShape3DReadOnly)shapeA, (FrameShape3DReadOnly)shapeB);
            newNumberOfIterations = detector.getNumberOfIterations();
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)distanceEpsilon, (double)pointTangentialEpsilon, (double)0.0);
            totalIterationsWithoutHint += originalNumberOfIterations;
            totalIterationsWithHint += newNumberOfIterations;
        }
        Assertions.assertTrue((totalIterationsWithHint < totalIterationsWithoutHint ? 1 : 0) != 0);
    }

    @Test
    public void testCompareAgainstFramelessGJK() {
        FrameShape3DBasics shapeB;
        FrameShape3DBasics shapeA;
        ReferenceFrame frameB;
        ReferenceFrame frameA;
        FrameShape3DBasics shapeB2;
        FrameShape3DBasics shapeA2;
        Random random = new Random(34307L);
        EuclidShape3DCollisionResult expectedResult = new EuclidShape3DCollisionResult();
        EuclidFrameShape3DCollisionResult actualResult = new EuclidFrameShape3DCollisionResult();
        ArrayList<ComparisonError> errors = new ArrayList<ComparisonError>();
        for (int i = 0; i < 10000; ++i) {
            ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
            shapeA2 = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)worldFrame);
            shapeB2 = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)worldFrame);
            FrameGilbertJohnsonKeerthiCollisionDetectorTest.computeResults(shapeA2, shapeB2, expectedResult, actualResult);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration : " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)0.0, (double)0.0, (double)0.0);
            errors.add(ComparisonError.toComparisonError(expectedResult, actualResult));
        }
        ComparisonError average = ComparisonError.average(errors);
        Assertions.assertEquals((double)0.0, (double)average.distanceError, (double)1.0E-10, (String)"average distance error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointNormalError, (double)1.0E-10, (String)"average point normal error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointTangentialError, (double)1.0E-7, (String)"average point tangential error too large: ");
        errors = new ArrayList();
        for (int i = 0; i < 10000; ++i) {
            ReferenceFrame shapeFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            shapeA2 = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)shapeFrame);
            shapeB2 = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)shapeFrame);
            FrameGilbertJohnsonKeerthiCollisionDetectorTest.computeResults(shapeA2, shapeB2, expectedResult, actualResult);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration : " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)0.0, (double)0.0, (double)0.0);
            errors.add(ComparisonError.toComparisonError(expectedResult, actualResult));
        }
        average = ComparisonError.average(errors);
        Assertions.assertEquals((double)0.0, (double)average.distanceError, (double)1.0E-10, (String)"average distance error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointNormalError, (double)1.0E-10, (String)"average point normal error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointTangentialError, (double)1.0E-7, (String)"average point tangential error too large: ");
        errors = new ArrayList();
        for (int i = 0; i < 10000; ++i) {
            frameA = ReferenceFrame.getWorldFrame();
            frameB = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            shapeA = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)frameA);
            shapeB = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)frameB);
            FrameGilbertJohnsonKeerthiCollisionDetectorTest.computeResults(shapeA, shapeB, expectedResult, actualResult);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration : " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)1.0E-7, (double)1.0E-4, (double)0.0);
            errors.add(ComparisonError.toComparisonError(expectedResult, actualResult));
        }
        average = ComparisonError.average(errors);
        Assertions.assertEquals((double)0.0, (double)average.distanceError, (double)1.0E-10, (String)"average distance error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointNormalError, (double)1.0E-10, (String)"average point normal error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointTangentialError, (double)1.0E-7, (String)"average point tangential error too large: ");
        errors = new ArrayList();
        for (int i = 0; i < 10000; ++i) {
            frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameB = ReferenceFrame.getWorldFrame();
            shapeA = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)frameA);
            shapeB = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)frameB);
            FrameGilbertJohnsonKeerthiCollisionDetectorTest.computeResults(shapeA, shapeB, expectedResult, actualResult);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration : " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)1.0E-7, (double)1.0E-4, (double)0.0);
            errors.add(ComparisonError.toComparisonError(expectedResult, actualResult));
        }
        average = ComparisonError.average(errors);
        Assertions.assertEquals((double)0.0, (double)average.distanceError, (double)1.0E-10, (String)"average distance error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointNormalError, (double)1.0E-10, (String)"average point normal error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointTangentialError, (double)1.0E-7, (String)"average point tangential error too large: ");
        errors = new ArrayList();
        for (int i = 0; i < 10000; ++i) {
            frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameB = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            shapeA = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)frameA);
            shapeB = EuclidFrameShapeRandomTools.nextFrameConvexShape3D((Random)random, (ReferenceFrame)frameB);
            FrameGilbertJohnsonKeerthiCollisionDetectorTest.computeResults(shapeA, shapeB, expectedResult, actualResult);
            EuclidShapeTestTools.assertEuclidShape3DCollisionResultGeometricallyEquals((String)("Iteration : " + i), (EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult, (double)1.0E-7, (double)1.0E-4, (double)0.0);
            errors.add(ComparisonError.toComparisonError(expectedResult, actualResult));
        }
        average = ComparisonError.average(errors);
        Assertions.assertEquals((double)0.0, (double)average.distanceError, (double)1.0E-10, (String)"average distance error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointNormalError, (double)1.0E-10, (String)"average point normal error too large: ");
        Assertions.assertEquals((double)0.0, (double)average.pointTangentialError, (double)1.0E-7, (String)"average point tangential error too large: ");
    }

    private static void computeResults(FrameShape3DBasics shapeA, FrameShape3DBasics shapeB, EuclidShape3DCollisionResult framelessResultToPack, EuclidFrameShape3DCollisionResult frameResultToPack) {
        ReferenceFrame frameA = shapeA.getReferenceFrame();
        ReferenceFrame frameB = shapeB.getReferenceFrame();
        FrameGilbertJohnsonKeerthiCollisionDetector frameDetector = new FrameGilbertJohnsonKeerthiCollisionDetector();
        frameDetector.evaluateCollision((FrameShape3DReadOnly)shapeA, (FrameShape3DReadOnly)shapeB, (EuclidFrameShape3DCollisionResultBasics)frameResultToPack);
        Assertions.assertTrue((frameDetector.getDetectorFrame() == frameA || frameDetector.getDetectorFrame() == frameB ? 1 : 0) != 0);
        frameResultToPack.getPointOnA().checkReferenceFrameMatch(frameDetector.getDetectorFrame());
        frameResultToPack.getPointOnB().checkReferenceFrameMatch(frameDetector.getDetectorFrame());
        GilbertJohnsonKeerthiCollisionDetector framelessDetector = new GilbertJohnsonKeerthiCollisionDetector();
        FrameShape3DBasics shapeBInDetectorFrame = shapeB.copy();
        shapeBInDetectorFrame.changeFrame(frameDetector.getDetectorFrame());
        FrameShape3DBasics shapeAInDetectorFrame = shapeA.copy();
        shapeAInDetectorFrame.changeFrame(frameDetector.getDetectorFrame());
        framelessDetector.evaluateCollision((Shape3DReadOnly)shapeAInDetectorFrame, (Shape3DReadOnly)shapeBInDetectorFrame, (EuclidShape3DCollisionResultBasics)framelessResultToPack);
        framelessResultToPack.setShapeA((Shape3DReadOnly)shapeA);
        framelessResultToPack.setShapeB((Shape3DReadOnly)shapeB);
    }

    public static class ComparisonError {
        public double distanceError = 0.0;
        public double pointNormalError = 0.0;
        public double pointTangentialError = 0.0;

        public ComparisonError() {
        }

        public ComparisonError(EuclidShape3DCollisionResultReadOnly resultA, EuclidShape3DCollisionResultReadOnly resultB) {
            this.distanceError = Math.abs(resultA.getDistance() - resultB.getDistance());
            Vector3D collisionVector = new Vector3D();
            collisionVector.sub((Tuple3DReadOnly)resultA.getPointOnA(), (Tuple3DReadOnly)resultA.getPointOnB());
            collisionVector.normalize();
            this.updatePointError(resultA.getPointOnA(), resultB.getPointOnA(), (Vector3DReadOnly)collisionVector);
            this.updatePointError(resultA.getPointOnB(), resultB.getPointOnB(), (Vector3DReadOnly)collisionVector);
        }

        private void updatePointError(Point3DReadOnly point1, Point3DReadOnly point2, Vector3DReadOnly normal) {
            Vector3D errorPointOnA = new Vector3D();
            errorPointOnA.sub((Tuple3DReadOnly)point1, (Tuple3DReadOnly)point2);
            double normalError = errorPointOnA.dot((Tuple3DReadOnly)normal);
            Vector3D errorNormalVector = new Vector3D();
            errorNormalVector.setAndScale(normalError, (Tuple3DReadOnly)normal);
            Vector3D errorTangentialVector = new Vector3D();
            errorTangentialVector.sub((Tuple3DReadOnly)errorPointOnA, (Tuple3DReadOnly)errorNormalVector);
            this.pointNormalError = Math.max(this.pointNormalError, normalError);
            this.pointTangentialError = Math.max(this.pointTangentialError, errorTangentialVector.norm());
        }

        private void add(ComparisonError other) {
            this.distanceError += other.distanceError;
            this.pointNormalError += other.pointNormalError;
            this.pointTangentialError += other.pointTangentialError;
        }

        private void scale(double scalar) {
            this.distanceError *= scalar;
            this.pointNormalError *= scalar;
            this.pointTangentialError *= scalar;
        }

        private static ComparisonError max(ComparisonError a, ComparisonError b) {
            ComparisonError max = new ComparisonError();
            max.distanceError = Math.max(a.distanceError, b.distanceError);
            max.pointNormalError = Math.max(a.pointNormalError, b.pointNormalError);
            max.pointTangentialError = Math.max(a.pointTangentialError, b.pointTangentialError);
            return max;
        }

        public static ComparisonError average(List<ComparisonError> errors) {
            ComparisonError average = new ComparisonError();
            List<ComparisonError> nonNull = errors.stream().filter(o -> o != null).collect(Collectors.toList());
            nonNull.forEach(average::add);
            average.scale(1.0 / (double)nonNull.size());
            return average;
        }

        public static ComparisonError max(List<ComparisonError> errors) {
            return errors.stream().filter(o -> o != null).reduce(new ComparisonError(), ComparisonError::max);
        }

        public String toString() {
            return "distance: " + this.distanceError + ", point (normal): " + this.pointNormalError + ", point (tangential): " + this.pointTangentialError;
        }

        public static ComparisonError toComparisonError(EuclidShape3DCollisionResult expectedResult, EuclidFrameShape3DCollisionResult actualResult) {
            return expectedResult.areShapesColliding() ? null : new ComparisonError((EuclidShape3DCollisionResultReadOnly)expectedResult, (EuclidShape3DCollisionResultReadOnly)actualResult);
        }
    }
}

