/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameUnitVector2D;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameUnitVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameUnitVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;

public class FrameUnitVector2DTest {
    @Test
    public void testOverloading() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameUnitVector2DReadOnly.class, UnitVector2DReadOnly.class, true);
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{UnitVector2DReadOnly.class}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        tester.assertOverloadingWithFrameObjects(FixedFrameUnitVector2DBasics.class, UnitVector2DBasics.class, true, 1, methodFilter);
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(EuclidFrameRandomTools::nextFrameUnitVector2D, methodFilter, 10);
    }

    @Test
    public void testConsistencyWithUnitVector2D() throws Exception {
        FrameTypeCopier frameTypeBuilder = (frame, unitVector) -> new FrameUnitVector2D(frame, (Tuple2DReadOnly)((UnitVector2DReadOnly)unitVector));
        RandomFramelessTypeBuilder framelessTypeBuilber = EuclidCoreRandomTools::nextUnitVector2D;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("toString");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilber, methodFilter, 10);
    }

    @Test
    public void testSetMatchingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameUnitVector2D, 10);
    }

    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameUnitVector2D, 10);
    }
}

