/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tuple3D.Tuple3DReadOnlyTest;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public abstract class FrameTuple3DReadOnlyTest<F extends FrameTuple3DReadOnly> {
    public static final double EPSILON = 1.0E-15;

    public final F createEmptyFrameTuple() {
        return this.createFrameTuple(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
    }

    public final F createEmptyFrameTuple(ReferenceFrame referenceFrame) {
        return this.createFrameTuple(referenceFrame, 0.0, 0.0, 0.0);
    }

    public final F createFrameTuple(ReferenceFrame referenceFrame, Tuple3DReadOnly tuple) {
        return this.createFrameTuple(referenceFrame, tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public final F createRandomFrameTuple(Random random) {
        return this.createFrameTuple(ReferenceFrame.getWorldFrame(), random.nextDouble(), random.nextDouble(), random.nextDouble());
    }

    public final F createRandomFrameTuple(Random random, ReferenceFrame referenceFrame) {
        return this.createFrameTuple(referenceFrame, random.nextDouble(), random.nextDouble(), random.nextDouble());
    }

    public final F createFrameTuple(double x, double y, double z) {
        return this.createFrameTuple(ReferenceFrame.getWorldFrame(), x, y, z);
    }

    public abstract F createFrameTuple(ReferenceFrame var1, double var2, double var4, double var6);

    @Test
    public void testTuple3DReadOnlyFeatures() throws Throwable {
        Tuple3DReadOnlyTest test = new Tuple3DReadOnlyTest<F>(){

            @Override
            public F createEmptyTuple() {
                return FrameTuple3DReadOnlyTest.this.createEmptyFrameTuple();
            }

            @Override
            public F createRandomTuple(Random random) {
                return FrameTuple3DReadOnlyTest.this.createRandomFrameTuple(random);
            }

            @Override
            public F createTuple(double x, double y, double z) {
                return FrameTuple3DReadOnlyTest.this.createFrameTuple(x, y, z);
            }

            @Override
            public double getEpsilon() {
                return 1.0E-15;
            }
        };
        for (Method testMethod : test.getClass().getMethods()) {
            if (!testMethod.getName().startsWith("test") || !Modifier.isPublic(testMethod.getModifiers()) || Modifier.isStatic(testMethod.getModifiers())) continue;
            try {
                testMethod.invoke((Object)test, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(621541L);
        double epsilon = 0.0;
        ReferenceFrame frame1 = ReferenceFrame.getWorldFrame();
        ReferenceFrame frame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        double x = random.nextDouble();
        double y = random.nextDouble();
        double z = random.nextDouble();
        F tuple1 = this.createFrameTuple(frame1, x, y, z);
        F tuple2 = this.createFrameTuple(frame1, x, y, z);
        F tuple3 = this.createFrameTuple(frame2, x, y, z);
        F tuple4 = this.createFrameTuple(frame2, x, y, z);
        Assertions.assertTrue((boolean)tuple1.epsilonEquals(tuple2, epsilon));
        Assertions.assertFalse((boolean)tuple1.epsilonEquals(tuple3, epsilon));
        Assertions.assertFalse((boolean)tuple3.epsilonEquals(tuple2, epsilon));
        Assertions.assertTrue((boolean)tuple3.epsilonEquals(tuple4, epsilon));
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(621541L);
        ReferenceFrame frame1 = ReferenceFrame.getWorldFrame();
        ReferenceFrame frame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        double x = random.nextDouble();
        double y = random.nextDouble();
        double z = random.nextDouble();
        F tuple1 = this.createFrameTuple(frame1, x, y, z);
        F tuple2 = this.createFrameTuple(frame1, x, y, z);
        F tuple3 = this.createFrameTuple(frame2, x, y, z);
        F tuple4 = this.createFrameTuple(frame2, x, y, z);
        Assertions.assertTrue((boolean)tuple1.equals(tuple2));
        Assertions.assertFalse((boolean)tuple1.equals(tuple3));
        Assertions.assertFalse((boolean)tuple3.equals(tuple2));
        Assertions.assertTrue((boolean)tuple3.equals(tuple4));
        F tuple2AsObject = tuple2;
        F tuple3AsObject = tuple3;
        F tuple4AsObject = tuple4;
        Assertions.assertTrue((boolean)tuple1.equals(tuple2AsObject));
        Assertions.assertFalse((boolean)tuple1.equals(tuple3AsObject));
        Assertions.assertFalse((boolean)tuple3.equals(tuple2AsObject));
        Assertions.assertTrue((boolean)tuple3.equals(tuple4AsObject));
    }

    @Test
    public void testOverloading() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameTuple3DReadOnly.class, Tuple3DReadOnly.class, true);
    }
}

