/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.orientation.Orientation2D;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation2DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;

public abstract class FrameOrientation2DReadOnlyTest<T extends FrameOrientation2DReadOnly> {
    public abstract T createFrameOrientation(ReferenceFrame var1, Orientation2DReadOnly var2);

    public final T createEmptyFramePose(ReferenceFrame referenceFrame) {
        return this.createFrameOrientation(referenceFrame, (Orientation2DReadOnly)new Orientation2D());
    }

    public final T createRandomOrientation(Random random) {
        return this.createRandomFrameOrientation(random, ReferenceFrame.getWorldFrame());
    }

    public final T createRandomFrameOrientation(Random random, ReferenceFrame referenceFrame) {
        return this.createFrameOrientation(referenceFrame, (Orientation2DReadOnly)EuclidCoreRandomTools.nextOrientation2D((Random)random));
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(this::createRandomFrameOrientation, methodFilter, 10);
    }

    @Test
    public void testOverloading() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameOrientation2DReadOnly.class, Orientation2DReadOnly.class, true);
    }
}

