/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.FrameBox3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameShapeAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoxPolytope3DView;
import us.ihmc.euclid.referenceFrame.polytope.FrameConvexPolytope3D;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameFace3DReadOnly;
import us.ihmc.euclid.referenceFrame.polytope.interfaces.FrameVertex3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.BoxPolytope3DView;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class FrameBoxPolytope3DTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testIntegrity() {
        Random random = new Random(897234L);
        for (int i = 0; i < 1000; ++i) {
            FrameBox3D box3D = EuclidFrameShapeRandomTools.nextFrameBox3D((Random)random, (ReferenceFrame)worldFrame);
            FrameBoxPolytope3DView boxPolytope = box3D.asConvexPolytope();
            EuclidShapeTestTools.assertConvexPolytope3DGeneralIntegrity((String)("Iteration " + i), (ConvexPolytope3DReadOnly)boxPolytope);
            Assertions.assertEquals((int)6, (int)boxPolytope.getNumberOfFaces());
            Assertions.assertEquals((int)12, (int)boxPolytope.getNumberOfEdges());
            Assertions.assertEquals((int)8, (int)boxPolytope.getNumberOfVertices());
            for (FrameFace3DReadOnly face : boxPolytope.getFaces()) {
                Assertions.assertEquals((int)4, (int)face.getNumberOfEdges());
            }
            for (FrameVertex3DReadOnly vertex : boxPolytope.getVertices()) {
                Assertions.assertEquals((int)3, (int)vertex.getNumberOfAssociatedEdges());
            }
        }
    }

    @Test
    public void testAgainstConvexPolytope() {
        Random random = new Random(987345L);
        FrameBox3D box3D = EuclidFrameShapeRandomTools.nextFrameBox3D((Random)random, (ReferenceFrame)worldFrame);
        FrameBoxPolytope3DView boxPolytope3D = box3D.asConvexPolytope();
        for (int i = 0; i < 1000; ++i) {
            switch (random.nextInt(3)) {
                case 0: {
                    box3D.set((Box3DReadOnly)EuclidShapeRandomTools.nextBox3D((Random)random));
                    break;
                }
                case 1: {
                    box3D.getPose().set((RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
                    break;
                }
                case 2: {
                    box3D.getSize().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
                }
            }
            FrameConvexPolytope3D convexPolytope3D = new FrameConvexPolytope3D(worldFrame);
            for (int vertexIndex = 0; vertexIndex < 8; ++vertexIndex) {
                Point3D vertex = new Point3D();
                vertex.set((vertexIndex & 1) == 0 ? box3D.getSizeX() : -box3D.getSizeX(), (vertexIndex & 2) == 0 ? box3D.getSizeY() : -box3D.getSizeY(), (vertexIndex & 4) == 0 ? box3D.getSizeZ() : -box3D.getSizeZ());
                vertex.scale(0.5);
                box3D.transformToWorld((Transformable)vertex);
                convexPolytope3D.addVertex((Point3DReadOnly)vertex);
            }
            Assertions.assertEquals((double)boxPolytope3D.getVolume(), (double)convexPolytope3D.getVolume(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)convexPolytope3D.getCentroid(), (EuclidGeometry)boxPolytope3D.getCentroid(), (double)1.0E-12);
            for (FrameFace3DReadOnly boxFace : boxPolytope3D.getFaces()) {
                FrameFace3DReadOnly polytopeFace = convexPolytope3D.getClosestFace(boxFace.getCentroid());
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)boxFace.getCentroid(), (EuclidFrameGeometry)boxFace.getCentroid(), (double)1.0E-12);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)boxFace.getNormal(), (EuclidFrameGeometry)boxFace.getNormal(), (double)1.0E-12);
                for (FrameVertex3DReadOnly boxVertex : boxFace.getVertices()) {
                    Assertions.assertEquals((long)1L, (long)polytopeFace.getVertices().stream().filter(polytopeVertex -> polytopeVertex.epsilonEquals((EuclidFrameGeometry)boxVertex, 1.0E-12)).count());
                }
            }
        }
    }

    @Test
    public void testAPIOverloading() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("getSupportingVertex", new Class[]{Vertex3DReadOnly.class, Vector3DReadOnly.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        methodFilter = methodFilter.and(m -> m.getParameterTypes().equals(new Class[]{Axis3D.class}));
        tester.assertOverloadingWithFrameObjects(FrameBoxPolytope3DView.class, BoxPolytope3DView.class, false, 1, methodFilter);
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("getBoundingBox", new Class[]{FixedFrameBoundingBox3DBasics.class}));
        signaturesToIgnore.add(new MethodSignature("getBoundingBox", new Class[]{ReferenceFrame.class, FrameBoundingBox3DBasics.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        methodFilter = methodFilter.and(m -> Stream.of(m.getParameterTypes()).noneMatch(type -> Vertex3DReadOnly.class.isAssignableFrom((Class<?>)type)));
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(FrameBoxPolytope3DTest::nextFrameBoxPolytope3DView, methodFilter, 10);
    }

    @Test
    public void testConsistencyWithBox3D() {
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("hashCode", new Class[0]));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{FrameConvexPolytope3D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{FrameConvexPolytope3D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{FrameConvexPolytope3D.class}));
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        methodFilter = methodFilter.and(m -> Stream.of(m.getParameterTypes()).noneMatch(type -> Vertex3DReadOnly.class.isAssignableFrom((Class<?>)type)));
        methodFilter = methodFilter.and(m -> m.getName().equals("othogonalProjectionCopy"));
        EuclidFrameAPITester tester = new EuclidFrameAPITester((EuclidFrameAPIDefaultConfiguration)new EuclidFrameShapeAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality((frame, boxPolytope) -> FrameBoxPolytope3DTest.copy(frame, (BoxPolytope3DView)boxPolytope), FrameBoxPolytope3DTest::nextBoxPolytope3DView, methodFilter, 10);
    }

    @Test
    public void testFaceCentroidBug() {
        int i;
        Box3D unitBox3D = new Box3D(1.0, 1.0, 1.0);
        FrameBox3D unitFrameBox3D = new FrameBox3D(worldFrame, 1.0, 1.0, 1.0);
        BoxPolytope3DView boxPolytope = unitBox3D.asConvexPolytope();
        FrameBoxPolytope3DView frameBoxPolytope = unitFrameBox3D.asConvexPolytope();
        Assertions.assertEquals((Object)new Point3D(-0.5, 0.0, 0.0), (Object)boxPolytope.getFace(0).getCentroid());
        Assertions.assertEquals((Object)new Point3D(0.0, -0.5, 0.0), (Object)boxPolytope.getFace(1).getCentroid());
        Assertions.assertEquals((Object)new Point3D(0.0, 0.0, -0.5), (Object)boxPolytope.getFace(2).getCentroid());
        Assertions.assertEquals((Object)new Point3D(0.5, 0.0, 0.0), (Object)boxPolytope.getFace(3).getCentroid());
        Assertions.assertEquals((Object)new Point3D(0.0, 0.5, 0.0), (Object)boxPolytope.getFace(4).getCentroid());
        Assertions.assertEquals((Object)new Point3D(0.0, 0.0, 0.5), (Object)boxPolytope.getFace(5).getCentroid());
        Assertions.assertEquals((Object)new Point3D(-0.5, 0.0, 0.0), (Object)frameBoxPolytope.getFace(0).getCentroid());
        Assertions.assertEquals((Object)new Point3D(0.0, -0.5, 0.0), (Object)frameBoxPolytope.getFace(1).getCentroid());
        Assertions.assertEquals((Object)new Point3D(0.0, 0.0, -0.5), (Object)frameBoxPolytope.getFace(2).getCentroid());
        Assertions.assertEquals((Object)new Point3D(0.5, 0.0, 0.0), (Object)frameBoxPolytope.getFace(3).getCentroid());
        Assertions.assertEquals((Object)new Point3D(0.0, 0.5, 0.0), (Object)frameBoxPolytope.getFace(4).getCentroid());
        Assertions.assertEquals((Object)new Point3D(0.0, 0.0, 0.5), (Object)frameBoxPolytope.getFace(5).getCentroid());
        for (i = 0; i < 8; ++i) {
            Assertions.assertTrue((boolean)frameBoxPolytope.getVertices().contains(unitFrameBox3D.getVertex(i)));
            Assertions.assertEquals((Object)boxPolytope.getVertex(i), (Object)frameBoxPolytope.getVertex(i));
            Assertions.assertEquals((Object)boxPolytope.getHalfEdge(i), (Object)frameBoxPolytope.getHalfEdge(i));
            Assertions.assertEquals((double)1.0, (double)boxPolytope.getHalfEdge(i).length());
            Assertions.assertEquals((double)1.0, (double)frameBoxPolytope.getHalfEdge(i).length());
        }
        for (i = 0; i < 6; ++i) {
            Face3DReadOnly boxFace = boxPolytope.getFace(i);
            FrameFace3DReadOnly frameBoxFace = frameBoxPolytope.getFace(i);
            for (int j = 0; j < 4; ++j) {
                Assertions.assertEquals((Object)boxFace.getVertex(j), (Object)frameBoxFace.getVertex(j));
            }
            Assertions.assertEquals((Object)boxFace.getNormal(), (Object)frameBoxFace.getNormal());
            Assertions.assertEquals((Object)boxFace.getCentroid(), (Object)frameBoxFace.getCentroid());
            Assertions.assertEquals((Object)boxFace.getBoundingBox(), (Object)frameBoxFace.getBoundingBox());
            Assertions.assertEquals((double)1.0, (double)boxFace.getArea());
            Assertions.assertEquals((double)1.0, (double)frameBoxFace.getArea());
        }
    }

    private static BoxPolytope3DView nextBoxPolytope3DView(Random random) {
        return EuclidShapeRandomTools.nextBox3D((Random)random).asConvexPolytope();
    }

    private static FrameBoxPolytope3DView nextFrameBoxPolytope3DView(Random random, ReferenceFrame referenceFrame) {
        return EuclidFrameShapeRandomTools.nextFrameBox3D((Random)random, (ReferenceFrame)referenceFrame).asConvexPolytope();
    }

    private static FrameBoxPolytope3DView copy(ReferenceFrame referenceFrame, BoxPolytope3DView boxPolytope3DView) {
        return new FrameBox3D(referenceFrame, (Box3DReadOnly)boxPolytope3DView.copy()).asConvexPolytope();
    }
}

