/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Line3DTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testConstructors() throws Exception {
        Random random = new Random(2342L);
        Point3D expectedPoint = new Point3D();
        Vector3D expectedDirection = new Vector3D(1.0, 0.0, 0.0);
        Line3D line3d = new Line3D();
        try {
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)line3d.getPoint(), (double)1.0E-12);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedDirection, (EuclidGeometry)line3d.getDirection(), (double)1.0E-12);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        expectedPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        expectedDirection = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
        expectedDirection.normalize();
        line3d = new Line3D((Point3DReadOnly)expectedPoint, (Vector3DReadOnly)expectedDirection);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)line3d.getPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedDirection, (EuclidGeometry)line3d.getDirection(), (double)1.0E-12);
        Assertions.assertTrue((expectedPoint != line3d.getPoint() ? 1 : 0) != 0);
        Assertions.assertTrue((expectedDirection != line3d.getDirection() ? 1 : 0) != 0);
        Point3D firstPointOnLine = new Point3D((Tuple3DReadOnly)expectedPoint);
        Point3D secondPointOnLine = new Point3D();
        secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)expectedDirection, (Tuple3DReadOnly)firstPointOnLine);
        line3d = new Line3D((Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)line3d.getPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedDirection, (EuclidGeometry)line3d.getDirection(), (double)1.0E-12);
        Line3D otherLine = EuclidGeometryRandomTools.nextLine3D((Random)random, (double)10.0);
        line3d = new Line3D((Line3DReadOnly)otherLine);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)otherLine.getPoint(), (EuclidGeometry)line3d.getPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)otherLine.getDirection(), (EuclidGeometry)line3d.getDirection(), (double)1.0E-12);
    }

    @Test
    public void testSetters() throws Exception {
        Random random = new Random(2342L);
        Point3D expectedPoint = new Point3D();
        Vector3D expectedDirection = new Vector3D();
        Vector3D direction = new Vector3D();
        Line3D line3d = new Line3D((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        expectedPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        expectedDirection = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
        direction.set(expectedDirection);
        expectedDirection.normalize();
        line3d.getPoint().set((Tuple3DReadOnly)expectedPoint);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)line3d.getPoint(), (double)1.0E-12);
        line3d.getDirection().set((Tuple3DReadOnly)direction);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedDirection, (EuclidGeometry)line3d.getDirection(), (double)1.0E-12);
        expectedPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        expectedDirection = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-10.0, (double)10.0);
        expectedDirection.normalize();
        line3d.set((Point3DReadOnly)expectedPoint, (Vector3DReadOnly)expectedDirection);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)line3d.getPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedDirection, (EuclidGeometry)line3d.getDirection(), (double)1.0E-12);
        Point3D firstPointOnLine = new Point3D((Tuple3DReadOnly)expectedPoint);
        Point3D secondPointOnLine = new Point3D();
        secondPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)expectedDirection, (Tuple3DReadOnly)firstPointOnLine);
        line3d.set((Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)line3d.getPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedDirection, (EuclidGeometry)line3d.getDirection(), (double)1.0E-12);
        line3d = new Line3D();
        line3d.set(new Line3D((Point3DReadOnly)expectedPoint, (Vector3DReadOnly)expectedDirection));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)line3d.getPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedDirection, (EuclidGeometry)line3d.getDirection(), (double)1.0E-12);
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(32423L);
        Line3D line3D = EuclidGeometryRandomTools.nextLine3D((Random)random);
        line3D.setToZero();
        try {
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)line3D.getPoint());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidCoreTestTools.assertEquals((EuclidGeometry)Axis3D.X, (EuclidGeometry)line3D.getDirection(), (double)1.0E-12);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(32423L);
        Line3D line3D = EuclidGeometryRandomTools.nextLine3D((Random)random);
        line3D.setToNaN();
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)line3D.getPoint());
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)line3D.getDirection());
    }

    @Test
    public void testContainsNaN() throws Exception {
        Line3D line3D = new Line3D();
        Assertions.assertFalse((boolean)line3D.containsNaN());
        line3D.set(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertFalse((boolean)line3D.containsNaN());
        line3D.set(Double.NaN, 0.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertTrue((boolean)line3D.containsNaN());
        line3D.set(0.0, Double.NaN, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertTrue((boolean)line3D.containsNaN());
        line3D.set(0.0, 0.0, Double.NaN, 0.0, 0.0, 1.0);
        Assertions.assertTrue((boolean)line3D.containsNaN());
        line3D.set(0.0, 0.0, 0.0, Double.NaN, 0.0, 1.0);
        Assertions.assertTrue((boolean)line3D.containsNaN());
        line3D.set(0.0, 0.0, 0.0, 0.0, Double.NaN, 1.0);
        Assertions.assertTrue((boolean)line3D.containsNaN());
        line3D.set(0.0, 0.0, 0.0, 0.0, 1.0, Double.NaN);
        Assertions.assertTrue((boolean)line3D.containsNaN());
    }

    @Test
    public void testDistance() throws Exception {
        Random random = new Random(32423L);
        for (int i = 0; i < 1000; ++i) {
            Line3D line = EuclidGeometryRandomTools.nextLine3D((Random)random, (double)10.0);
            Point3D query = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            double expectedDistance = EuclidGeometryTools.distanceFromPoint3DToLine3D((Point3DReadOnly)query, (Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection());
            double actualDistance = line.distance((Point3DReadOnly)query);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            Line3D otherLine = EuclidGeometryRandomTools.nextLine3D((Random)random, (double)10.0);
            expectedDistance = EuclidGeometryTools.distanceBetweenTwoLine3Ds((Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Point3DReadOnly)otherLine.getPoint(), (Vector3DReadOnly)otherLine.getDirection());
            actualDistance = line.distance((Line3DReadOnly)otherLine);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
    }

    @Test
    public void testClosestPointsWith() throws Exception {
        Random random = new Random(32423L);
        for (int i = 0; i < 1000; ++i) {
            Line3D line = EuclidGeometryRandomTools.nextLine3D((Random)random, (double)10.0);
            Line3D otherLine = EuclidGeometryRandomTools.nextLine3D((Random)random, (double)10.0);
            Point3D expectedClosestPointOnLine = new Point3D();
            Point3D expectedClosestPointOnOtherLine = new Point3D();
            Point3D actualClosestPointOnLine = new Point3D();
            Point3D actualClosestPointOnOtherLine = new Point3D();
            double expectedDistance = EuclidGeometryTools.closestPoint3DsBetweenTwoLine3Ds((Point3DReadOnly)line.getPoint(), (Vector3DReadOnly)line.getDirection(), (Point3DReadOnly)otherLine.getPoint(), (Vector3DReadOnly)otherLine.getDirection(), (Point3DBasics)expectedClosestPointOnLine, (Point3DBasics)expectedClosestPointOnOtherLine);
            double actualDistance = line.closestPointsWith((Line3DReadOnly)otherLine, (Point3DBasics)actualClosestPointOnLine, (Point3DBasics)actualClosestPointOnOtherLine);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPointOnLine, (EuclidGeometry)actualClosestPointOnLine, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPointOnOtherLine, (EuclidGeometry)actualClosestPointOnOtherLine, (double)1.0E-12);
        }
    }

    @Test
    public void testNormalizeDirection() throws Exception {
        Random random = new Random(3242L);
        for (int i = 0; i < 1000; ++i) {
            Line3D line = new Line3D();
            Point3D point = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Vector3D direction = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            line.set((Point3DReadOnly)point, (Vector3DReadOnly)direction);
            Assertions.assertFalse((boolean)direction.epsilonEquals((EuclidGeometry)line.getDirection(), 0.001));
            Assertions.assertTrue((direction.dot((Tuple3DReadOnly)line.getDirection()) > 0.0 ? 1 : 0) != 0);
            Assertions.assertEquals((double)direction.norm(), (double)direction.dot((Tuple3DReadOnly)line.getDirection()), (double)1.0E-12);
            Assertions.assertEquals((double)1.0, (double)line.getDirection().norm(), (double)1.0E-12);
        }
    }

    @Test
    public void testApplyTransform() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            Line3D line3d = EuclidGeometryRandomTools.nextLine3D((Random)random, (double)1.0E-12);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Point3D expectedPoint = new Point3D((Tuple3DReadOnly)line3d.getPoint());
            Vector3D expectedDirection = new Vector3D((Tuple3DReadOnly)line3d.getDirection());
            line3d.applyTransform((Transform)transform);
            expectedPoint.applyTransform((Transform)transform);
            expectedDirection.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)line3d.getPoint(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedDirection, (EuclidGeometry)line3d.getDirection(), (double)1.0E-12);
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            Line3D line1 = EuclidGeometryRandomTools.nextLine3D((Random)random, (double)1.0E-12);
            Line3D line2 = new Line3D((Line3DReadOnly)line1);
            double epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
            for (int j = 0; j < 3; ++j) {
                Point3D point = new Point3D();
                line2.set(line1);
                Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
                double element = line1.getPoint().getElement(j);
                point.set((Tuple3DReadOnly)line1.getPoint());
                point.setElement(j, element + 0.999 * epsilon);
                line2.getPoint().set((Tuple3DReadOnly)point);
                Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
                point.set((Tuple3DReadOnly)line1.getPoint());
                point.setElement(j, element - 0.999 * epsilon);
                line2.getPoint().set((Tuple3DReadOnly)point);
                Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
                point.set((Tuple3DReadOnly)line1.getPoint());
                point.setElement(j, element + 1.001 * epsilon);
                line2.getPoint().set((Tuple3DReadOnly)point);
                Assertions.assertFalse((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
                point.set((Tuple3DReadOnly)line1.getPoint());
                point.setElement(j, element - 1.001 * epsilon);
                line2.getPoint().set((Tuple3DReadOnly)point);
                Assertions.assertFalse((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
            }
            line2.set(line1);
            Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
            AxisAngle axisAngle = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)line1.getDirection(), (boolean)true), 0.0);
            axisAngle.setAngle(0.999 * epsilon);
            axisAngle.transform((Tuple3DReadOnly)line1.getDirection(), (Tuple3DBasics)line2.getDirection());
            Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
            axisAngle.setAngle(-0.999 * epsilon);
            axisAngle.transform((Tuple3DReadOnly)line1.getDirection(), (Tuple3DBasics)line2.getDirection());
            Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
            axisAngle.setAngle(2.0 * epsilon);
            axisAngle.transform((Tuple3DReadOnly)line1.getDirection(), (Tuple3DBasics)line2.getDirection());
            Assertions.assertFalse((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
            axisAngle.setAngle(-2.0 * epsilon);
            axisAngle.transform((Tuple3DReadOnly)line1.getDirection(), (Tuple3DBasics)line2.getDirection());
            Assertions.assertFalse((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
        }
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            double element;
            int j;
            Line3D line1 = EuclidGeometryRandomTools.nextLine3D((Random)random);
            Line3D line2 = new Line3D((Line3DReadOnly)line1);
            double epsilon = 1.0E-12;
            EuclidGeometry nullAsLine3D = null;
            Assertions.assertFalse((boolean)line1.equals(nullAsLine3D));
            Object nullAsObject = null;
            Assertions.assertFalse((boolean)line1.equals(nullAsObject));
            Assertions.assertFalse((boolean)line1.equals((Object)new double[3]));
            for (j = 0; j < 3; ++j) {
                line2.set(line1);
                Point3D point = new Point3D((Tuple3DReadOnly)line2.getPoint());
                element = point.getElement(j);
                point.setElement(j, element + epsilon);
                line2.getPoint().set((Tuple3DReadOnly)point);
                Assertions.assertFalse((boolean)line1.equals((EuclidGeometry)line2));
                point.setElement(j, element - epsilon);
                line2.getPoint().set((Tuple3DReadOnly)point);
                Assertions.assertFalse((boolean)line1.equals((EuclidGeometry)line2));
            }
            for (j = 0; j < 3; ++j) {
                line2.set(line1);
                Vector3D direction = new Vector3D((Tuple3DReadOnly)line2.getDirection());
                element = direction.getElement(j);
                direction.setElement(j, element + epsilon);
                line2.getDirection().set((Tuple3DReadOnly)direction);
                Assertions.assertFalse((boolean)line1.equals((EuclidGeometry)line2));
                direction.setElement(j, element - epsilon);
                line2.getDirection().set((Tuple3DReadOnly)direction);
                Assertions.assertFalse((boolean)line1.equals((EuclidGeometry)line2));
            }
        }
    }

    @Test
    public void testGeometricallyEquals() {
        Vector3D orthogonal;
        int i;
        Random random = new Random(57021L);
        double epsilon = 1.0E-6;
        Vector3D direction = new Vector3D();
        Line3D firstLine = EuclidGeometryRandomTools.nextLine3D((Random)random);
        Line3D secondLine = new Line3D((Line3DReadOnly)firstLine);
        Assertions.assertTrue((boolean)firstLine.geometricallyEquals((EuclidGeometry)secondLine, epsilon));
        Assertions.assertTrue((boolean)secondLine.geometricallyEquals((EuclidGeometry)firstLine, epsilon));
        Assertions.assertTrue((boolean)firstLine.geometricallyEquals((EuclidGeometry)firstLine, epsilon));
        Assertions.assertTrue((boolean)secondLine.geometricallyEquals((EuclidGeometry)secondLine, epsilon));
        for (i = 0; i < 1000; ++i) {
            firstLine = EuclidGeometryRandomTools.nextLine3D((Random)random);
            secondLine = new Line3D((Line3DReadOnly)firstLine);
            orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)firstLine.getDirection(), (boolean)true);
            orthogonal.scale(0.99 * epsilon / orthogonal.norm());
            secondLine.translate(orthogonal.getX(), orthogonal.getY(), orthogonal.getZ());
            Assertions.assertTrue((boolean)firstLine.geometricallyEquals((EuclidGeometry)secondLine, epsilon));
            secondLine.set(firstLine);
            orthogonal.scale(1.01 * epsilon / orthogonal.norm());
            secondLine.translate(orthogonal.getX(), orthogonal.getY(), orthogonal.getZ());
            Assertions.assertFalse((boolean)firstLine.geometricallyEquals((EuclidGeometry)secondLine, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            firstLine = EuclidGeometryRandomTools.nextLine3D((Random)random);
            secondLine = new Line3D((Line3DReadOnly)firstLine);
            orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)firstLine.getDirection(), (boolean)true);
            direction.set((Tuple3DReadOnly)secondLine.getDirection());
            direction.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)orthogonal, epsilon * 0.99), (Tuple3DReadOnly)new Vector3D()));
            secondLine.getDirection().set((Tuple3DReadOnly)direction);
            Assertions.assertTrue((boolean)firstLine.geometricallyEquals((EuclidGeometry)secondLine, epsilon));
            secondLine.set(firstLine);
            direction.set((Tuple3DReadOnly)secondLine.getDirection());
            direction.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)orthogonal, epsilon * 1.01), (Tuple3DReadOnly)new Vector3D()));
            secondLine.getDirection().set((Tuple3DReadOnly)direction);
            Assertions.assertFalse((boolean)firstLine.geometricallyEquals((EuclidGeometry)secondLine, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            firstLine = EuclidGeometryRandomTools.nextLine3D((Random)random);
            secondLine = new Line3D((Line3DReadOnly)firstLine);
            double scale = random.nextDouble() - random.nextDouble();
            secondLine.translate(secondLine.getDirectionX() * scale, secondLine.getDirectionY() * scale, secondLine.getDirectionZ() * scale);
            Assertions.assertTrue((boolean)firstLine.geometricallyEquals((EuclidGeometry)secondLine, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            firstLine = EuclidGeometryRandomTools.nextLine3D((Random)random);
            direction.set((Tuple3DReadOnly)firstLine.getDirection());
            direction.negate();
            secondLine = new Line3D((Point3DReadOnly)firstLine.getPoint(), (Vector3DReadOnly)direction);
            Assertions.assertTrue((boolean)firstLine.geometricallyEquals((EuclidGeometry)secondLine, epsilon));
        }
    }
}

