/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.Vector4DBasicsTest;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class Vector4DTest
extends Vector4DBasicsTest<Vector4D> {
    private static final double EPS = 1.0E-10;

    @Test
    public void testConstructors() throws Exception {
        int i;
        Random random = new Random(3453L);
        Vector4D vector = new Vector4D();
        Assertions.assertTrue((vector.getX() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((vector.getY() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((vector.getZ() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((vector.getS() == 0.0 ? 1 : 0) != 0);
        double x = random.nextDouble();
        double y = random.nextDouble();
        double z = random.nextDouble();
        double s = random.nextDouble();
        Vector4D vector2 = new Vector4D(x, y, z, s);
        Assertions.assertTrue((vector2.getX() == x ? 1 : 0) != 0);
        Assertions.assertTrue((vector2.getY() == y ? 1 : 0) != 0);
        Assertions.assertTrue((vector2.getZ() == z ? 1 : 0) != 0);
        Assertions.assertTrue((vector2.getS() == s ? 1 : 0) != 0);
        x = random.nextDouble();
        y = random.nextDouble();
        z = random.nextDouble();
        s = random.nextDouble();
        double[] vectorArray = new double[]{x, y, z, s};
        Vector4D vector3 = new Vector4D(vectorArray);
        Assertions.assertTrue((vector3.getX() == x ? 1 : 0) != 0);
        Assertions.assertTrue((vector3.getY() == y ? 1 : 0) != 0);
        Assertions.assertTrue((vector3.getZ() == z ? 1 : 0) != 0);
        Assertions.assertTrue((vector3.getS() == s ? 1 : 0) != 0);
        Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Vector4D vector4 = new Vector4D((Tuple4DReadOnly)quaternion);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)vector4, (double)1.0E-10);
        quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        vector4 = new Vector4D((Tuple4DReadOnly)quaternion);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion, (EuclidGeometry)vector4, (double)1.0E-10);
        Vector3D vector3D = EuclidCoreRandomTools.nextVector3D((Random)random);
        vector4 = new Vector4D((Vector3DReadOnly)vector3D);
        for (i = 0; i < 3; ++i) {
            Assertions.assertTrue((vector4.getElement(i) == vector3D.getElement(i) ? 1 : 0) != 0);
        }
        Assertions.assertTrue((vector4.getS() == 0.0 ? 1 : 0) != 0);
        Point3D point3D = EuclidCoreRandomTools.nextPoint3D((Random)random);
        vector4 = new Vector4D((Point3DReadOnly)point3D);
        for (i = 0; i < 3; ++i) {
            Assertions.assertTrue((vector4.getElement(i) == point3D.getElement(i) ? 1 : 0) != 0);
        }
        Assertions.assertTrue((vector4.getS() == 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Vector4D vector = this.createRandomTuple(random);
        int newHashCode = vector.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)vector.hashCode());
        int previousHashCode = vector.hashCode();
        for (int i = 0; i < 1000; ++i) {
            vector.setElement(i % 4, random.nextDouble());
            newHashCode = vector.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Vector4D vectorB;
            Vector4D vectorA = EuclidCoreRandomTools.nextVector4D((Random)random);
            if (vectorA.geometricallyEquals((EuclidGeometry)(vectorB = EuclidCoreRandomTools.nextVector4D((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
                continue;
            }
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, this.getEpsilon()));
        }
    }

    @Override
    public Vector4D createEmptyTuple() {
        return new Vector4D();
    }

    @Override
    public Vector4D createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextVector4D((Random)random);
    }

    @Override
    public Vector4D createTuple(double x, double y, double z, double s) {
        return new Vector4D(x, y, z, s);
    }

    @Override
    public double getEpsilon() {
        return 1.0E-14;
    }
}

