/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3DBasicsTest;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class Point3DTest
extends Point3DBasicsTest<Point3D> {
    @Test
    public void testPoint3D() {
        int i;
        Random random = new Random(621541L);
        Point3D point = new Point3D();
        Assertions.assertTrue((0.0 == point.getX() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == point.getY() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == point.getZ() ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            double newZ;
            double newY;
            double newX = random.nextDouble();
            Assertions.assertTrue((newX == (point = new Point3D(newX, newY = random.nextDouble(), newZ = random.nextDouble())).getX() ? 1 : 0) != 0);
            Assertions.assertTrue((newY == point.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((newZ == point.getZ() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            double[] randomPointArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            double[] copyRandomPointArray = new double[]{randomPointArray[0], randomPointArray[1], randomPointArray[2]};
            Point3D pointArray = new Point3D(randomPointArray);
            Assertions.assertTrue((randomPointArray[0] == pointArray.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((randomPointArray[1] == pointArray.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((randomPointArray[2] == pointArray.getZ() ? 1 : 0) != 0);
            Assertions.assertTrue((copyRandomPointArray[0] == randomPointArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((copyRandomPointArray[1] == randomPointArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((copyRandomPointArray[2] == randomPointArray[2] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D point2 = new Point3D();
            point2.setX(random.nextDouble());
            point2.setY(random.nextDouble());
            point2.setZ(random.nextDouble());
            point = new Point3D((Tuple3DReadOnly)point2);
            Assertions.assertTrue((point.getX() == point2.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((point.getY() == point2.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((point.getZ() == point2.getZ() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Point3D tuple1 = this.createEmptyTuple();
        tuple1.setX(random.nextDouble());
        tuple1.setY(random.nextDouble());
        tuple1.setZ(random.nextDouble());
        int newHashCode = tuple1.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)tuple1.hashCode());
        int previousHashCode = tuple1.hashCode();
        for (int i = 0; i < 1000; ++i) {
            tuple1.setElement(i % 3, random.nextDouble());
            newHashCode = tuple1.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Point3D pointB;
            Point3D pointA = EuclidCoreRandomTools.nextPoint3D((Random)random);
            if (pointA.geometricallyEquals((EuclidGeometry)(pointB = EuclidCoreRandomTools.nextPoint3D((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)pointA.geometricallyEquals((EuclidGeometry)pointB, this.getEpsilon()));
                continue;
            }
            Assertions.assertFalse((boolean)pointA.geometricallyEquals((EuclidGeometry)pointB, this.getEpsilon()));
        }
    }

    @Override
    public Point3D createEmptyTuple() {
        return new Point3D();
    }

    @Override
    public Point3D createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextPoint3D((Random)random);
    }

    @Override
    public Point3D createTuple(double x, double y, double z) {
        return new Point3D(x, y, z);
    }

    @Override
    public double getEpsilon() {
        return 1.0E-14;
    }
}

