/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.Orientation2D;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.QuaternionBasedTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class EuclidCoreIOToolsTest {
    @Test
    public void testGetRigidBodyTransformStringRegression() {
        Random random = new Random(345345L);
        String randomFormat = EuclidCoreIOTools.getStringFormat((int)8, (int)7);
        RigidBodyTransform t = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        String expected = "-0.146  0.372  0.917 |  0.969\n 0.050  0.928 -0.369 |  0.028\n-0.988 -0.008 -0.154 | -0.619\n 0.000  0.000  0.000 |  1.000";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getRigidBodyTransformString((RigidBodyTransform)t));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getRigidBodyTransformString((String)EuclidCoreIOTools.DEFAULT_FORMAT, (RigidBodyTransform)t));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getRigidBodyTransformString(null));
        expected = "-0.1460544 0.3719639 0.9166848 | 0.9690608\n0.0497947 0.9282109 -0.3687071 | 0.0275034\n-0.9880226 -0.0082053 -0.1540911 | -0.6188257\n0.0000000 0.0000000 0.0000000 | 1.0000000";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getRigidBodyTransformString((String)randomFormat, (RigidBodyTransform)t));
        expected = "-0.14605438133050594 0.3719638705161967 0.916684785913224 | 0.9690607506715772\n0.04979465293823307 0.9282109416799752 -0.36870711992628336 | 0.02750342450772747\n-0.9880225757708799 -0.008205289524678472 -0.154091086669191 | -0.6188257166341338\n0.0 0.0 0.0 | 1.0";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getRigidBodyTransformString(null, (RigidBodyTransform)t));
    }

    @Test
    public void testGetAffineTransformStringRegression() {
        Random random = new Random(345345L);
        String randomFormat = EuclidCoreIOTools.getStringFormat((int)8, (int)7);
        AffineTransform t = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        String expected = " 1.639 -5.595  9.691 | -0.618\n 0.275 -6.188  7.012 | -0.556\n-0.728  6.787 -4.461 |  0.498\n 0.000  0.000  0.000 |  1.000";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getAffineTransformString((AffineTransformReadOnly)t));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getAffineTransformString((String)EuclidCoreIOTools.DEFAULT_FORMAT, (AffineTransformReadOnly)t));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getAffineTransformString(null));
        expected = "1.6394447 -5.5954184 9.6906075 | -0.6176655\n0.2750342 -6.1882572 7.0120891 | -0.5556910\n-0.7281610 6.7873417 -4.4606236 | 0.4979491\n0.0000000 0.0000000 0.0000000 | 1.0000000";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getAffineTransformString((String)randomFormat, (AffineTransformReadOnly)t));
        expected = "1.6394446573547388 -5.59541839804184 9.690607506715772 | -0.6176654552449496\n0.2750342450772756 -6.188257166341337 7.012089076126404 | -0.5556910209492063\n-0.7281610246766981 6.787341699515743 -4.460623648325692 | 0.4979490960610431\n0.0 0.0 0.0 | 1.0";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getAffineTransformString(null, (AffineTransformReadOnly)t));
    }

    @Test
    public void testGetQuaternionBasedTransformStringRegression() {
        Random random = new Random(345345L);
        String randomFormat = EuclidCoreIOTools.getStringFormat((int)8, (int)7);
        QuaternionBasedTransform t = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        String expected = "Quaternion:  ( 0.141,  0.746, -0.126,  0.638 )\nTranslation: ( 0.969,  0.028, -0.619 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getQuaternionBasedTransformString((QuaternionBasedTransform)t));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getQuaternionBasedTransformString((String)EuclidCoreIOTools.DEFAULT_FORMAT, (QuaternionBasedTransform)t));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getQuaternionBasedTransformString(null));
        expected = "Quaternion:  (0.1412673, 0.7463840, -0.1262461, 0.6379783 )\nTranslation: (0.9690608, 0.0275034, -0.6188257 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getQuaternionBasedTransformString((String)randomFormat, (QuaternionBasedTransform)t));
        expected = "Quaternion:  (0.14126726766904454, 0.7463840180630331, -0.12624614150672073, 0.6379783447892801 )\nTranslation: (0.9690607506715772, 0.02750342450772747, -0.6188257166341338 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getQuaternionBasedTransformString(null, (QuaternionBasedTransform)t));
    }

    @Test
    public void testGetTuple2DStringRegression() {
        Random random = new Random(345345L);
        String randomFormat = EuclidCoreIOTools.getStringFormat((int)8, (int)7);
        Point2D t = EuclidCoreRandomTools.nextPoint2D((Random)random);
        String expected = "( 0.164, -0.560 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getTuple2DString((Tuple2DReadOnly)t));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getTuple2DString((String)EuclidCoreIOTools.DEFAULT_FORMAT, (Tuple2DReadOnly)t));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getTuple2DString(null));
        expected = "(0.1639445, -0.5595418 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getTuple2DString((String)randomFormat, (Tuple2DReadOnly)t));
        expected = "(0.16394446573547383, -0.559541839804184 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getTuple2DString(null, (Tuple2DReadOnly)t));
    }

    @Test
    public void testGetTuple3DStringRegression() {
        Random random = new Random(345345L);
        String randomFormat = EuclidCoreIOTools.getStringFormat((int)8, (int)7);
        Point3D t = EuclidCoreRandomTools.nextPoint3D((Random)random);
        String expected = "( 0.164, -0.560,  0.969 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)t));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getTuple3DString((String)EuclidCoreIOTools.DEFAULT_FORMAT, (Tuple3DReadOnly)t));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getTuple3DString(null));
        expected = "(0.1639445, -0.5595418, 0.9690608 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getTuple3DString((String)randomFormat, (Tuple3DReadOnly)t));
        expected = "(0.16394446573547383, -0.559541839804184, 0.9690607506715772 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getTuple3DString(null, (Tuple3DReadOnly)t));
    }

    @Test
    public void testGetTuple4DStringRegression() {
        Random random = new Random(345345L);
        String randomFormat = EuclidCoreIOTools.getStringFormat((int)8, (int)7);
        Vector4D t = EuclidCoreRandomTools.nextVector4D((Random)random);
        String expected = "( 0.164, -0.560,  0.969,  0.028 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getTuple4DString((Tuple4DReadOnly)t));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getTuple4DString((String)EuclidCoreIOTools.DEFAULT_FORMAT, (Tuple4DReadOnly)t));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getTuple4DString(null));
        expected = "(0.1639445, -0.5595418, 0.9690608, 0.0275034 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getTuple4DString((String)randomFormat, (Tuple4DReadOnly)t));
        expected = "(0.16394446573547383, -0.559541839804184, 0.9690607506715772, 0.02750342450772747 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getTuple4DString(null, (Tuple4DReadOnly)t));
    }

    @Test
    public void testGetAxisAngleStringRegression() {
        Random random = new Random(345345L);
        String randomFormat = EuclidCoreIOTools.getStringFormat((int)8, (int)7);
        AxisAngle t = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        String expected = "(-0.183, -0.969,  0.164, -1.758 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getAxisAngleString((AxisAngleReadOnly)t));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getAxisAngleString((String)EuclidCoreIOTools.DEFAULT_FORMAT, (AxisAngleReadOnly)t));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getAxisAngleString(null));
        expected = "(-0.1834510, -0.9692615, 0.1639445, -1.7578525 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getAxisAngleString((String)randomFormat, (AxisAngleReadOnly)t));
        expected = "(-0.18345104608744625, -0.9692615363482303, 0.16394446573547383, -1.7578525333049415 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getAxisAngleString(null, (AxisAngleReadOnly)t));
    }

    @Test
    public void testGetOrientation2DStringRegression() {
        Random random = new Random(345345L);
        String randomFormat = EuclidCoreIOTools.getStringFormat((int)8, (int)7);
        Orientation2D t = EuclidCoreRandomTools.nextOrientation2D((Random)random);
        String expected = "( 0.515 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getOrientation2DString((Orientation2DReadOnly)t));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getOrientation2DString((String)EuclidCoreIOTools.DEFAULT_FORMAT, (Orientation2DReadOnly)t));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getOrientation2DString(null));
        expected = "(0.5150467 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getOrientation2DString((String)randomFormat, (Orientation2DReadOnly)t));
        expected = "(0.5150467291512681 )";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getOrientation2DString(null, (Orientation2DReadOnly)t));
    }

    @Test
    public void testGetMatrix3DStringRegression() {
        Random random = new Random(345345L);
        String randomFormat = EuclidCoreIOTools.getStringFormat((int)8, (int)7);
        Matrix3D t = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        String expected = "/ 0.164, -0.560,  0.969 \\\n| 0.028, -0.619,  0.701 |\n\\-0.073,  0.679, -0.446 /";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getMatrix3DString((Matrix3DReadOnly)t));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getMatrix3DString((String)EuclidCoreIOTools.DEFAULT_FORMAT, (Matrix3DReadOnly)t));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getMatrix3DString(null));
        expected = "/0.1639445, -0.5595418, 0.9690608 \\\n|0.0275034, -0.6188257, 0.7012089 |\n\\-0.0728161, 0.6787342, -0.4460624 /";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getMatrix3DString((String)randomFormat, (Matrix3DReadOnly)t));
        expected = "/0.16394446573547383, -0.559541839804184, 0.9690607506715772 \\\n|0.02750342450772747, -0.6188257166341338, 0.7012089076126404 |\n\\-0.0728161024676699, 0.6787341699515741, -0.4460623648325692 /";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getMatrix3DString(null, (Matrix3DReadOnly)t));
    }

    @Test
    public void testGetYawPitchRollStringRegression() {
        Random random = new Random(345345L);
        String randomFormat = EuclidCoreIOTools.getStringFormat((int)8, (int)7);
        YawPitchRoll t = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
        String expected = "yaw-pitch-roll: ( 0.515, -0.861,  3.044)";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getYawPitchRollString((YawPitchRollReadOnly)t));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getYawPitchRollString((String)EuclidCoreIOTools.DEFAULT_FORMAT, (YawPitchRollReadOnly)t));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getYawPitchRollString(null));
        expected = "yaw-pitch-roll: (0.5150467, -0.8611524, 3.0443941)";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getYawPitchRollString((String)randomFormat, (YawPitchRollReadOnly)t));
        expected = "yaw-pitch-roll: (0.5150467291512681, -0.8611524243712763, 3.0443941351920367)";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getYawPitchRollString(null, (YawPitchRollReadOnly)t));
    }

    @Test
    public void testGetStringOf() {
        Random random = new Random(345345L);
        String separator = "-p-";
        String randomFormat = EuclidCoreIOTools.getStringFormat((int)8, (int)7);
        Object[] values = random.doubles(3L).map(d -> d - 0.5).toArray();
        String expected = " 0.082-p--0.280-p- 0.485";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)separator, (double[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (double[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])values));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)separator, (double[])null));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])null));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (double[])null));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])null));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf((String)separator, (double[])new double[0]));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf((String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])new double[0]));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (double[])new double[0]));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])new double[0]));
        expected = "0.0819722-p--0.2797709-p-0.4845304";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)separator, (String)randomFormat, (double[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (String)randomFormat, (double[])values));
        expected = "0.08197223286773692-p--0.279770919902092-p-0.4845303753357886";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)separator, null, (double[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, null, (double[])values));
        String prefix = "!prefix!";
        String suffix = "?suffix?";
        expected = "!prefix! 0.082-p--0.280-p- 0.485?suffix?";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (double[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])values));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (double[])null));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])null));
        Assertions.assertEquals((Object)"!prefix!?suffix?", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (double[])new double[0]));
        Assertions.assertEquals((Object)"!prefix!?suffix?", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (double[])new double[0]));
        expected = "!prefix!0.0819722-p--0.2797709-p-0.4845304?suffix?";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (String)randomFormat, (double[])values));
        expected = "!prefix!0.08197223286773692-p--0.279770919902092-p-0.4845303753357886?suffix?";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, null, (double[])values));
        values = new float[]{random.nextFloat() - 0.5f, random.nextFloat() - 0.5f, random.nextFloat() - 0.5f};
        expected = " 0.014-p- 0.287-p--0.309";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)separator, (float[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (float[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (float[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (float[])values));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)separator, (float[])null));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (float[])null));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (float[])null));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (float[])null));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf((String)separator, (float[])new float[0]));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf((String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (float[])new float[0]));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (float[])new float[0]));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (float[])new float[0]));
        expected = "0.0137517-p-0.2874116-p--0.3094129";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)separator, (String)randomFormat, (float[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (String)randomFormat, (float[])values));
        expected = "0.013751686-p-0.28741163-p--0.3094129";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)separator, null, (float[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, null, (float[])values));
        prefix = "!prefix!";
        suffix = "?suffix?";
        expected = "!prefix! 0.014-p- 0.287-p--0.309?suffix?";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (float[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (float[])values));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (float[])null));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (float[])null));
        Assertions.assertEquals((Object)"!prefix!?suffix?", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (float[])new float[0]));
        Assertions.assertEquals((Object)"!prefix!?suffix?", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (String)EuclidCoreIOTools.DEFAULT_FORMAT, (float[])new float[0]));
        expected = "!prefix!0.0137517-p-0.2874116-p--0.3094129?suffix?";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (String)randomFormat, (float[])values));
        expected = "!prefix!0.013751686-p-0.28741163-p--0.3094129?suffix?";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, null, (float[])values));
        values = new boolean[]{random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), random.nextBoolean()};
        expected = "true-p-true-p-true-p-false";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)separator, (boolean[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (boolean[])values));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)separator, (boolean[])null));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (boolean[])null));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf((String)separator, (boolean[])new boolean[0]));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (boolean[])new boolean[0]));
        prefix = "!prefix!";
        suffix = "?suffix?";
        expected = "!prefix!true-p-true-p-true-p-false?suffix?";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (boolean[])values));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (boolean[])null));
        Assertions.assertEquals((Object)"!prefix!?suffix?", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (boolean[])new boolean[0]));
        values = new int[]{random.nextInt(1000) - 500, random.nextInt(1000) - 500, random.nextInt(1000) - 500, random.nextInt(1000) - 500};
        expected = "325-p--400-p--255-p--494";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)separator, (int[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (int[])values));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)separator, (int[])null));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (int[])null));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf((String)separator, (int[])new int[0]));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (int[])new int[0]));
        prefix = "!prefix!";
        suffix = "?suffix?";
        expected = "!prefix!325-p--400-p--255-p--494?suffix?";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (int[])values));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (int[])null));
        Assertions.assertEquals((Object)"!prefix!?suffix?", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (int[])new int[0]));
        values = new long[]{random.nextInt(1000) - 500, random.nextInt(1000) - 500, random.nextInt(1000) - 500, random.nextInt(1000) - 500};
        expected = "-107-p-104-p-246-p--373";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)separator, (long[])values));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (long[])values));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)separator, (long[])null));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (long[])null));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf((String)separator, (long[])new long[0]));
        Assertions.assertEquals((Object)"", (Object)EuclidCoreIOTools.getStringOf(null, null, (String)separator, (long[])new long[0]));
        prefix = "!prefix!";
        suffix = "?suffix?";
        expected = "!prefix!-107-p-104-p-246-p--373?suffix?";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (long[])values));
        Assertions.assertEquals((Object)"null", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (long[])null));
        Assertions.assertEquals((Object)"!prefix!?suffix?", (Object)EuclidCoreIOTools.getStringOf((String)prefix, (String)suffix, (String)separator, (long[])new long[0]));
    }

    @Test
    public void testGetArrayString() {
        Random random = new Random(345345L);
        String separator = "-p-";
        Object[] array = EuclidCoreIOToolsTest.nextTestObjectArray(random, 3);
        String expected = "[blop=4, choux=-0.0727027174796302]-p-[blop=-4, choux=0.4845303753357886]-p-[blop=44, choux=0.2874116776971093]";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString((String)separator, (Object[])array));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString(null, null, (String)separator, (Object[])array));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString((String)separator, (Object[])array, Object::toString));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString(null, null, (String)separator, (Object[])array, Object::toString));
        String prefix = "!prefix!";
        String suffix = "?suffix?";
        expected = "!prefix![blop=4, choux=-0.0727027174796302]-p-[blop=-4, choux=0.4845303753357886]-p-[blop=44, choux=0.2874116776971093]?suffix?";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString((String)prefix, (String)suffix, (String)separator, (Object[])array));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString((String)prefix, (String)suffix, (String)separator, (Object[])array, Object::toString));
        expected = "blop=4-p-blop=-4-p-blop=44";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString((String)separator, (Object[])array, e -> "blop=" + ((TestObject)e).blop));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString(null, null, (String)separator, (Object[])array, e -> "blop=" + ((TestObject)e).blop));
        array[random.nextInt((int)array.length)] = null;
        expected = "[blop=4, choux=-0.0727027174796302]-p-[blop=-4, choux=0.4845303753357886]-p-null";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString((String)separator, (Object[])array));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString(null, null, (String)separator, (Object[])array));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString((String)separator, (Object[])array, Object::toString));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString(null, null, (String)separator, (Object[])array, Object::toString));
        prefix = "!prefix!";
        suffix = "?suffix?";
        expected = "!prefix![blop=4, choux=-0.0727027174796302]-p-[blop=-4, choux=0.4845303753357886]-p-null?suffix?";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString((String)prefix, (String)suffix, (String)separator, (Object[])array));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString((String)prefix, (String)suffix, (String)separator, (Object[])array, Object::toString));
        expected = "blop=4-p-blop=-4-p-null";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString((String)separator, (Object[])array, e -> "blop=" + ((TestObject)e).blop));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getArrayString(null, null, (String)separator, (Object[])array, e -> "blop=" + ((TestObject)e).blop));
    }

    @Test
    public void testGetCollectionString() {
        Random random = new Random(345345L);
        String separator = "-p-";
        List<TestObject> list = Arrays.asList(EuclidCoreIOToolsTest.nextTestObjectArray(random, 3));
        String expected = "[blop=4, choux=-0.0727027174796302]-p-[blop=-4, choux=0.4845303753357886]-p-[blop=44, choux=0.2874116776971093]";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString((String)separator, list));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString(null, null, (String)separator, list));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString((String)separator, list, Object::toString));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString(null, null, (String)separator, list, Object::toString));
        String prefix = "!prefix!";
        String suffix = "?suffix?";
        expected = "!prefix![blop=4, choux=-0.0727027174796302]-p-[blop=-4, choux=0.4845303753357886]-p-[blop=44, choux=0.2874116776971093]?suffix?";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString((String)prefix, (String)suffix, (String)separator, list));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString((String)prefix, (String)suffix, (String)separator, list, Object::toString));
        expected = "blop=4-p-blop=-4-p-blop=44";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString((String)separator, list, e -> "blop=" + ((TestObject)e).blop));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString(null, null, (String)separator, list, e -> "blop=" + ((TestObject)e).blop));
        list.set(random.nextInt(list.size()), null);
        expected = "[blop=4, choux=-0.0727027174796302]-p-[blop=-4, choux=0.4845303753357886]-p-null";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString((String)separator, list));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString(null, null, (String)separator, list));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString((String)separator, list, Object::toString));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString(null, null, (String)separator, list, Object::toString));
        prefix = "!prefix!";
        suffix = "?suffix?";
        expected = "!prefix![blop=4, choux=-0.0727027174796302]-p-[blop=-4, choux=0.4845303753357886]-p-null?suffix?";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString((String)prefix, (String)suffix, (String)separator, list));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString((String)prefix, (String)suffix, (String)separator, list, Object::toString));
        expected = "blop=4-p-blop=-4-p-null";
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString((String)separator, list, e -> "blop=" + ((TestObject)e).blop));
        Assertions.assertEquals((Object)expected, (Object)EuclidCoreIOTools.getCollectionString(null, null, (String)separator, list, e -> "blop=" + ((TestObject)e).blop));
    }

    private static TestObject[] nextTestObjectArray(Random random, int length) {
        return (TestObject[])IntStream.range(0, length).mapToObj(i -> new TestObject(random)).toArray(TestObject[]::new);
    }

    private static class TestObject {
        private int blop;
        private double choux;

        public TestObject(Random random) {
            this.blop = random.nextInt(100) - 50;
            this.choux = random.nextDouble() - 0.5;
        }

        public String toString() {
            return "[blop=" + this.blop + ", choux=" + this.choux + "]";
        }
    }
}

