/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.UnitVector2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.Vector2DBasicsTest;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class UnitVector2DTest
extends Vector2DBasicsTest<UnitVector2D> {
    private static final double DOUBLE_EPSILON = 1.0E-14;
    private static final double FLOAT_EPSILON = 1.0E-7;

    @Test
    public void testConstructor() {
        UnitVector2D actual;
        int i;
        Random random = new Random(621541L);
        UnitVector2D actual2 = new UnitVector2D();
        Assertions.assertTrue((1.0 == actual2.getX() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == actual2.getY() ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            double newX = random.nextDouble();
            double newY = random.nextDouble();
            UnitVector2D actual3 = new UnitVector2D(newX, newY);
            Vector2D expected = new Vector2D(newX, newY);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual3, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            double[] randomVectorArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
            actual = new UnitVector2D(randomVectorArray);
            Vector2D expected = new Vector2D(randomVectorArray);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D other = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual = new UnitVector2D((Tuple2DReadOnly)other);
            Vector2D expected = new Vector2D((Tuple2DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testSetters() throws Exception {
        DMatrixRMaj matrix;
        Object[] tupleArray;
        Vector2D expected;
        UnitVector2D other;
        double y;
        double x;
        UnitVector2D actual;
        Vector2D expected2;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            expected2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new UnitVector2D((Tuple2DReadOnly)expected2);
            x = random.nextDouble();
            actual.setX(x);
            expected2.setX(x);
            expected2.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected2, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            expected2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new UnitVector2D((Tuple2DReadOnly)expected2);
            double y2 = random.nextDouble();
            actual.setY(y2);
            expected2.setY(y2);
            expected2.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected2, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            expected2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new UnitVector2D((Tuple2DReadOnly)expected2);
            try {
                actual.setElement(-1, random.nextDouble());
                Assertions.fail((String)"Should have thrown a IndexOutOfBoundsException.");
            }
            catch (IndexOutOfBoundsException y2) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a IndexOutOfBoundsException.");
            }
            try {
                actual.setElement(2, random.nextDouble());
                Assertions.fail((String)"Should have thrown a IndexOutOfBoundsException.");
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown a IndexOutOfBoundsException.");
            }
            x = random.nextDouble();
            y = random.nextDouble();
            actual.setElement(0, x);
            actual.setElement(1, y);
            expected2.setElement(0, x);
            expected2.setElement(1, y);
            expected2.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected2, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            expected2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new UnitVector2D((Tuple2DReadOnly)expected2);
            expected2.normalize();
            x = random.nextDouble();
            y = random.nextDouble();
            actual.set(x, y);
            expected2.set(x, y);
            expected2.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected2, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextUnitVector2D((Random)random);
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual2 = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual2.set((UnitVector2DReadOnly)other);
            expected.set((Tuple2DReadOnly)other);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual2, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual3 = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual3.set((Tuple2DReadOnly)other);
            expected.set((Tuple2DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual3, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D tuple3D = EuclidCoreRandomTools.nextPoint3D((Random)random);
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual4 = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual4.set((Tuple3DReadOnly)tuple3D);
            expected.set((Tuple3DReadOnly)tuple3D);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual4, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual5 = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual5.set(tupleArray);
            expected.set(tupleArray);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual5, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual6 = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual6.set(2, tupleArray);
            expected.set(2, tupleArray);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual6, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual7 = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual7.set((float[])tupleArray);
            expected.set((float[])tupleArray);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual7, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual8 = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual8.set(2, (float[])tupleArray);
            expected.set(2, (float[])tupleArray);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual8, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = new DMatrixRMaj(5, 4);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual9 = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual9.set((DMatrix)matrix);
            expected.set((DMatrix)matrix);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual9, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = new DMatrixRMaj(10, 4);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual10 = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual10.set(5, (DMatrix)matrix);
            expected.set(5, (DMatrix)matrix);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual10, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = new DMatrixRMaj(10, 4);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual11 = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual11.set(5, 2, (DMatrix)matrix);
            expected.set(5, 2, (DMatrix)matrix);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual11, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testAbsolute() throws Exception {
        Random random = new Random(45036L);
        for (int i = 0; i < 1000; ++i) {
            Point2D other = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Vector2D expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual.absolute();
            expected.absolute();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.setAndAbsolute((Tuple2DReadOnly)other);
            expected.setAndAbsolute((Tuple2DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testNegate() throws Exception {
        Random random = new Random(45036L);
        for (int i = 0; i < 1000; ++i) {
            Point2D other = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Vector2D expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual.negate();
            expected.negate();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.setAndNegate((Tuple2DReadOnly)other);
            expected.setAndNegate((Tuple2DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testGetters() throws Exception {
        double length;
        float y;
        double length2;
        double y2;
        int i;
        Random random = new Random(621541L);
        UnitVector2D vector = this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            y2 = random.nextDouble();
            vector = this.createTuple(x, y2);
            length2 = EuclidCoreTools.norm((double)x, (double)y2);
            Assertions.assertEquals((double)vector.getX(), (double)(x / length2), (double)1.0E-14);
            Assertions.assertEquals((double)vector.getY(), (double)(y2 / length2), (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            float x = random.nextFloat();
            y = random.nextFloat();
            vector = this.createTuple(x, y);
            length = EuclidCoreTools.norm((double)x, (double)y);
            Assertions.assertEquals((double)vector.getX32(), (double)((double)x / length), (double)1.0E-7);
            Assertions.assertEquals((double)vector.getY32(), (double)((double)y / length), (double)1.0E-7);
        }
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            y2 = random.nextDouble();
            vector = this.createTuple(x, y2);
            length2 = EuclidCoreTools.norm((double)x, (double)y2);
            Assertions.assertEquals((double)vector.getElement(0), (double)(x / length2), (double)1.0E-14);
            Assertions.assertEquals((double)vector.getElement(1), (double)(y2 / length2), (double)1.0E-14);
            try {
                vector.getElement(-1);
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
            try {
                vector.getElement(2);
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
        }
        for (i = 0; i < 1000; ++i) {
            float x = random.nextFloat();
            y = random.nextFloat();
            vector = this.createTuple(x, y);
            length = EuclidCoreTools.norm((double)x, (double)y);
            Assertions.assertEquals((double)vector.getElement32(0), (double)((double)x / length), (double)1.0E-7);
            Assertions.assertEquals((double)vector.getElement32(1), (double)((double)y / length), (double)1.0E-7);
            try {
                vector.getElement32(-1);
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
            catch (IndexOutOfBoundsException length3) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
            try {
                vector.getElement32(2);
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            catch (Exception e) {
                Assertions.fail((String)"Should have thrown IndexOutOfBoundsException.");
            }
        }
        for (i = 0; i < 1000; ++i) {
            vector = this.createRandomTuple(random);
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            vector.get(tupleArray);
            Assertions.assertTrue((vector.getX() == tupleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY() == tupleArray[1] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            vector = this.createRandomTuple(random);
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            vector.get(2, tupleArray);
            Assertions.assertTrue((vector.getX() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY() == tupleArray[3] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            vector = this.createRandomTuple(random);
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            vector.get(tupleArray);
            Assertions.assertTrue((vector.getX32() == tupleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY32() == tupleArray[1] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            vector = this.createRandomTuple(random);
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            vector.get(2, tupleArray);
            Assertions.assertTrue((vector.getX32() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY32() == tupleArray[3] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            vector.get((DMatrix)matrix);
            Assertions.assertTrue((vector.getX() == matrix.get(0, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY() == matrix.get(1, 0) ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            vector.get(2, (DMatrix)matrix);
            Assertions.assertTrue((vector.getX() == matrix.get(2, 0) ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY() == matrix.get(3, 0) ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            DMatrixRMaj matrix = new DMatrixRMaj(10, 5);
            for (int index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            vector.get(2, 4, (DMatrix)matrix);
            Assertions.assertTrue((vector.getX() == matrix.get(2, 4) ? 1 : 0) != 0);
            Assertions.assertTrue((vector.getY() == matrix.get(3, 4) ? 1 : 0) != 0);
        }
    }

    @Override
    @Test
    public void testAdd() throws Exception {
        double y;
        double x;
        Vector2D expected;
        UnitVector2D actual;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector2D();
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            x = random.nextDouble();
            y = random.nextDouble();
            actual.set((Tuple2DReadOnly)expected);
            actual.addX(x);
            expected.addX(x);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.addY(y);
            expected.addY(y);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector2D();
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            x = random.nextDouble();
            y = random.nextDouble();
            actual.set((Tuple2DReadOnly)expected);
            actual.add(x, y);
            expected.add(x, y);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector2D();
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            Point2D tupleToAdd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual.set((Tuple2DReadOnly)expected);
            actual.add((Tuple2DReadOnly)tupleToAdd);
            expected.add((Tuple2DReadOnly)tupleToAdd);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector2D();
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            Point2D tupleToAdd1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Point2D tupleToAdd2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual.set((Tuple2DReadOnly)expected);
            actual.add((Tuple2DReadOnly)tupleToAdd1, (Tuple2DReadOnly)tupleToAdd2);
            expected.add((Tuple2DReadOnly)tupleToAdd1, (Tuple2DReadOnly)tupleToAdd2);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testSub() throws Exception {
        double y;
        double x;
        Vector2D expected;
        UnitVector2D actual;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector2D();
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            x = random.nextDouble();
            y = random.nextDouble();
            actual.set((Tuple2DReadOnly)expected);
            actual.subX(x);
            expected.subX(x);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.subY(y);
            expected.subY(y);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector2D();
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            x = random.nextDouble();
            y = random.nextDouble();
            actual.set((Tuple2DReadOnly)expected);
            actual.sub(x, y);
            expected.sub(x, y);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector2D();
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            Point2D tupleToSub = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual.set((Tuple2DReadOnly)expected);
            actual.sub((Tuple2DReadOnly)tupleToSub);
            expected.sub((Tuple2DReadOnly)tupleToSub);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            actual = new UnitVector2D();
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            Point2D tupleToSub1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Point2D tupleToSub2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual.set((Tuple2DReadOnly)expected);
            actual.sub((Tuple2DReadOnly)tupleToSub1, (Tuple2DReadOnly)tupleToSub2);
            expected.sub((Tuple2DReadOnly)tupleToSub1, (Tuple2DReadOnly)tupleToSub2);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testClip() throws Exception {
        double min;
        UnitVector2D actual;
        Vector2D expected;
        Point2D other;
        UnitVector2D actual2;
        Vector2D expected2;
        double max;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            max = random.nextDouble();
            expected2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual2 = new UnitVector2D((Tuple2DReadOnly)expected2);
            expected2.normalize();
            actual2.clipToMax(max);
            expected2.clipToMax(max);
            expected2.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected2, (EuclidGeometry)actual2, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            max = random.nextDouble();
            other = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual.setAndClipToMax(max, (Tuple2DReadOnly)other);
            expected.setAndClipToMax(max, (Tuple2DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble();
            expected2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual2 = new UnitVector2D((Tuple2DReadOnly)expected2);
            expected2.normalize();
            actual2.clipToMin(min);
            expected2.clipToMin(min);
            expected2.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected2, (EuclidGeometry)actual2, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble();
            other = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            actual.setAndClipToMin(min, (Tuple2DReadOnly)other);
            expected.setAndClipToMin(min, (Tuple2DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble() - 0.5;
            double max2 = random.nextDouble() + 0.5;
            Vector2D expected3 = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual3 = new UnitVector2D((Tuple2DReadOnly)expected3);
            expected3.normalize();
            actual3.clipToMinMax(min, max2);
            expected3.clipToMinMax(min, max2);
            expected3.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected3, (EuclidGeometry)actual3, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble() - 0.5;
            double max3 = random.nextDouble() + 0.5;
            Point2D other2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Vector2D expected4 = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual4 = new UnitVector2D((Tuple2DReadOnly)expected4);
            expected4.normalize();
            actual4.setAndClipToMinMax(min, max3, (Tuple2DReadOnly)other2);
            expected4.setAndClipToMinMax(min, max3, (Tuple2DReadOnly)other2);
            expected4.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected4, (EuclidGeometry)actual4, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testScale() throws Exception {
        double scale;
        Point2D other2;
        Point2D other1;
        double scale2;
        Vector2D expected;
        Point2D other;
        UnitVector2D actual;
        Vector2D expected2;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            expected2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new UnitVector2D((Tuple2DReadOnly)expected2);
            double scale3 = random.nextDouble();
            actual.scale(scale3);
            expected2.scale(scale3);
            expected2.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected2, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            expected2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            actual = new UnitVector2D((Tuple2DReadOnly)expected2);
            double scaleX = random.nextDouble();
            double scaleY = random.nextDouble();
            actual.scale(scaleX, scaleY);
            expected2.scale(scaleX, scaleY);
            expected2.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected2, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual2 = new UnitVector2D((Tuple2DReadOnly)expected);
            scale2 = random.nextDouble();
            actual2.setAndScale(scale2, (Tuple2DReadOnly)other);
            expected.setAndScale(scale2, (Tuple2DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual2, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual3 = new UnitVector2D((Tuple2DReadOnly)expected);
            scale2 = random.nextDouble();
            actual3.scaleAdd(scale2, (Tuple2DReadOnly)other);
            expected.add((Tuple2DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual3, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            other2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Vector2D expected3 = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual4 = new UnitVector2D((Tuple2DReadOnly)expected3);
            scale = random.nextDouble();
            actual4.scaleAdd(scale, (Tuple2DReadOnly)other1, (Tuple2DReadOnly)other2);
            expected3.scaleAdd(scale, (Tuple2DReadOnly)other1, (Tuple2DReadOnly)other2);
            expected3.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected3, (EuclidGeometry)actual4, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual5 = new UnitVector2D((Tuple2DReadOnly)expected);
            double scale4 = random.nextDouble();
            actual5.scaleAdd(scale4, (Tuple2DReadOnly)other, (Tuple2DReadOnly)actual5);
            expected.scaleAdd(scale4, (Tuple2DReadOnly)other, (Tuple2DReadOnly)expected);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual5, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual6 = new UnitVector2D((Tuple2DReadOnly)expected);
            double scale5 = random.nextDouble();
            actual6.scaleSub(scale5, (Tuple2DReadOnly)other);
            expected.sub((Tuple2DReadOnly)other);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual6, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            other2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Vector2D expected4 = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual7 = new UnitVector2D((Tuple2DReadOnly)expected4);
            scale = random.nextDouble();
            actual7.scaleSub(scale, (Tuple2DReadOnly)other1, (Tuple2DReadOnly)other2);
            expected4.scaleSub(scale, (Tuple2DReadOnly)other1, (Tuple2DReadOnly)other2);
            expected4.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected4, (EuclidGeometry)actual7, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            other = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual8 = new UnitVector2D((Tuple2DReadOnly)expected);
            double scale6 = random.nextDouble();
            actual8.scaleSub(scale6, (Tuple2DReadOnly)other, (Tuple2DReadOnly)actual8);
            expected.scaleSub(scale6, (Tuple2DReadOnly)other, (Tuple2DReadOnly)expected);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual8, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(621541L);
        for (int i = 0; i < 1000; ++i) {
            UnitVector2D tuple = EuclidCoreRandomTools.nextUnitVector2D((Random)random);
            tuple.setToZero();
            Assertions.assertTrue((tuple.getX() == 1.0 ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getY() == 0.0 ? 1 : 0) != 0);
        }
    }

    @Override
    @Test
    public void testNormSquared() {
        Random random = new Random(312310L);
        for (int i = 0; i < 1000; ++i) {
            Vector2D expected = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-100.0, (double)100.0);
            UnitVector2D actual = new UnitVector2D((Tuple2DReadOnly)expected);
            Assertions.assertEquals((double)1.0, (double)actual.normSquared());
        }
    }

    @Override
    @Test
    public void testInterpolate() throws Exception {
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            Point2D other = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Vector2D expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            double alpha = random.nextDouble();
            actual.interpolate((Tuple2DReadOnly)other, alpha);
            expected.interpolate((Tuple2DReadOnly)other, alpha);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D other1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Point2D other2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Vector2D expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            double alpha = random.nextDouble();
            actual.interpolate((Tuple2DReadOnly)other1, (Tuple2DReadOnly)other2, alpha);
            expected.interpolate((Tuple2DReadOnly)other1, (Tuple2DReadOnly)other2, alpha);
            expected.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        UnitVector2D tuple1 = this.createRandomTuple(random);
        int newHashCode = tuple1.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)tuple1.hashCode());
        int previousHashCode = tuple1.hashCode();
        for (int i = 0; i < 1000; ++i) {
            tuple1.setElement(i % 2, random.nextDouble());
            newHashCode = tuple1.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testNorm() {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            UnitVector2D vector = new UnitVector2D((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random, (double)-100.0, (double)100.0));
            Assertions.assertTrue((vector.norm() == 1.0 ? 1 : 0) != 0);
        }
    }

    @Override
    @Test
    public void testClipToMaxNorm() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            UnitVector2D vector = EuclidCoreRandomTools.nextUnitVector2D((Random)random);
            Vector2D oldValues = new Vector2D((Tuple2DReadOnly)vector);
            Assertions.assertFalse((boolean)vector.clipToMaxLength(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0)));
            Assertions.assertTrue((boolean)oldValues.equals((EuclidGeometry)vector));
        }
    }

    @Override
    @Test
    public void testCross() {
        Random random = new Random(56461L);
        for (int i = 0; i < 1000; ++i) {
            Point2D other = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Vector2D expected = EuclidCoreRandomTools.nextVector2D((Random)random);
            UnitVector2D actual = new UnitVector2D((Tuple2DReadOnly)expected);
            expected.normalize();
            Assertions.assertEquals((double)actual.cross((Tuple2DReadOnly)other), (double)expected.cross((Tuple2DReadOnly)other));
        }
    }

    @Override
    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(621541L);
        double epsilon = random.nextDouble();
        UnitVector2D vector1 = this.createRandomTuple(random);
        UnitVector2D vector2 = this.createRandomTuple(random);
        vector2.set((UnitVector2DReadOnly)vector1);
        Assertions.assertTrue((boolean)vector1.epsilonEquals((EuclidGeometry)vector2, epsilon));
        AxisAngle axisAngle = new AxisAngle((Vector3DReadOnly)Axis3D.Z, 0.0);
        axisAngle.setAngle(0.999 * epsilon);
        axisAngle.transform((Tuple2DReadOnly)vector1, (Tuple2DBasics)vector2);
        Assertions.assertTrue((boolean)vector1.epsilonEquals((EuclidGeometry)vector2, epsilon));
        axisAngle.setAngle(-0.999 * epsilon);
        axisAngle.transform((Tuple2DReadOnly)vector1, (Tuple2DBasics)vector2);
        Assertions.assertTrue((boolean)vector1.epsilonEquals((EuclidGeometry)vector2, epsilon));
        axisAngle.setAngle(2.0 * epsilon);
        axisAngle.transform((Tuple2DReadOnly)vector1, (Tuple2DBasics)vector2);
        Assertions.assertFalse((boolean)vector1.epsilonEquals((EuclidGeometry)vector2, epsilon));
        axisAngle.setAngle(-2.0 * epsilon);
        axisAngle.transform((Tuple2DReadOnly)vector1, (Tuple2DBasics)vector2);
        Assertions.assertFalse((boolean)vector1.epsilonEquals((EuclidGeometry)vector2, epsilon));
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            UnitVector2D vectorB;
            UnitVector2D vectorA = EuclidCoreRandomTools.nextUnitVector2D((Random)random);
            if (vectorA.geometricallyEquals((EuclidGeometry)(vectorB = EuclidCoreRandomTools.nextUnitVector2D((Random)random)), 1.0E-14)) {
                Assertions.assertTrue((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, 1.0E-14));
                continue;
            }
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((EuclidGeometry)vectorB, 1.0E-14));
        }
    }

    @Override
    public UnitVector2D createEmptyTuple() {
        return new UnitVector2D();
    }

    @Override
    public UnitVector2D createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextUnitVector2D((Random)random);
    }

    @Override
    public UnitVector2D createTuple(double x, double y) {
        return new UnitVector2D(x, y);
    }

    @Override
    public double getEpsilon() {
        return 1.0E-14;
    }
}

