/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple2D.Tuple2DReadOnlyTest;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public abstract class Tuple2DBasicsTest<T extends Tuple2DBasics>
extends Tuple2DReadOnlyTest<T> {
    @Test
    public void testSetters() throws Exception {
        int index;
        double y;
        double x;
        Tuple2DBasics tuple1;
        int i;
        Random random = new Random(621541L);
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            x = random.nextDouble();
            tuple1.setX(x);
            Assertions.assertEquals((double)tuple1.getX(), (double)x, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            double y2 = random.nextDouble();
            tuple1.setY(y2);
            Assertions.assertEquals((double)tuple1.getY(), (double)y2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            x = random.nextDouble();
            y = random.nextDouble();
            tuple1.setElement(0, x);
            Assertions.assertEquals((double)tuple1.getX(), (double)x, (double)this.getEpsilon());
            tuple1.setElement(1, y);
            Assertions.assertEquals((double)tuple1.getY(), (double)y, (double)this.getEpsilon());
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple1.setElement(-1, random.nextDouble()));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple1.setElement(2, random.nextDouble()));
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            x = random.nextDouble();
            y = random.nextDouble();
            tuple1.setElement(Axis2D.X, x);
            Assertions.assertEquals((double)tuple1.getX(), (double)x, (double)this.getEpsilon());
            tuple1.setElement(Axis2D.Y, y);
            Assertions.assertEquals((double)tuple1.getY(), (double)y, (double)this.getEpsilon());
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple1.setElement(-1, random.nextDouble()));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> tuple1.setElement(2, random.nextDouble()));
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            x = random.nextDouble();
            y = random.nextDouble();
            tuple1.set(x, y);
            Assertions.assertEquals((double)tuple1.getX(), (double)x, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)y, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            Tuple2DBasics tuple2 = (Tuple2DBasics)this.createEmptyTuple();
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple1.set((Tuple2DReadOnly)tuple2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple1, (EuclidGeometry)tuple2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            Tuple2DBasics tuple2 = (Tuple2DBasics)this.createEmptyTuple();
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple1.set((Tuple2DReadOnly)tuple2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tuple1, (EuclidGeometry)tuple2, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            Point3D tuple3D = EuclidCoreRandomTools.nextPoint3D((Random)random);
            tuple1.set((Tuple3DReadOnly)tuple3D);
            Assertions.assertEquals((double)tuple3D.getX(), (double)tuple1.getX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple3D.getY(), (double)tuple1.getY(), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            tuple1.set(tupleArray);
            Assertions.assertEquals((double)tuple1.getX(), (double)tupleArray[0], (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)tupleArray[1], (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            double[] tupleArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble()};
            tuple1.set(2, tupleArray);
            Assertions.assertEquals((double)tuple1.getX(), (double)tupleArray[2], (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)tupleArray[3], (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            tuple1.set(tupleArray);
            Assertions.assertTrue((tuple1.getX() == (double)tupleArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple1.getY() == (double)tupleArray[1] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            float[] tupleArray = new float[]{random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat()};
            tuple1.set(2, tupleArray);
            Assertions.assertTrue((tuple1.getX32() == tupleArray[2] ? 1 : 0) != 0);
            Assertions.assertTrue((tuple1.getY32() == tupleArray[3] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            DMatrixRMaj matrix = new DMatrixRMaj(5, 4);
            for (index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple1.set((DMatrix)matrix);
            Assertions.assertEquals((double)tuple1.getX(), (double)matrix.get(0, 0), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)matrix.get(1, 0), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            DMatrixRMaj matrix = new DMatrixRMaj(10, 4);
            for (index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple1.set(5, (DMatrix)matrix);
            Assertions.assertEquals((double)tuple1.getX(), (double)matrix.get(5, 0), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)matrix.get(6, 0), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1 = (Tuple2DBasics)this.createEmptyTuple();
            DMatrixRMaj matrix = new DMatrixRMaj(10, 4);
            for (index = 0; index < matrix.getNumElements(); ++index) {
                matrix.set(index, random.nextDouble());
            }
            tuple1.set(5, 2, (DMatrix)matrix);
            Assertions.assertEquals((double)tuple1.getX(), (double)matrix.get(5, 2), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)matrix.get(6, 2), (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(621541L);
        for (int i = 0; i < 1000; ++i) {
            Tuple2DBasics tuple = (Tuple2DBasics)this.createEmptyTuple();
            tuple.setX(random.nextDouble());
            tuple.setY(random.nextDouble());
            tuple.setToNaN();
            Assertions.assertTrue((boolean)Double.isNaN(tuple.getX()));
            Assertions.assertTrue((boolean)Double.isNaN(tuple.getY()));
        }
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(621541L);
        for (int i = 0; i < 1000; ++i) {
            Tuple2DBasics tuple = (Tuple2DBasics)this.createEmptyTuple();
            tuple.setX(random.nextDouble());
            tuple.setY(random.nextDouble());
            tuple.setToZero();
            Assertions.assertTrue((tuple.getX() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((tuple.getY() == 0.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAbsolute() throws Exception {
        Random random = new Random(621541L);
        Tuple2DBasics tuple1 = (Tuple2DBasics)this.createEmptyTuple();
        Tuple2DBasics tuple2 = (Tuple2DBasics)this.createEmptyTuple();
        for (double signX = -1.0; signX <= 1.0; signX += 2.0) {
            for (double signY = -1.0; signY <= 1.0; signY += 2.0) {
                double xPos = random.nextDouble();
                double yPos = random.nextDouble();
                tuple1.setX(signX * xPos);
                tuple1.setY(signY * yPos);
                tuple2.setAndAbsolute((Tuple2DReadOnly)tuple1);
                Assertions.assertEquals((double)tuple2.getX(), (double)xPos, (double)this.getEpsilon());
                Assertions.assertEquals((double)tuple2.getY(), (double)yPos, (double)this.getEpsilon());
                Assertions.assertEquals((double)tuple1.getX(), (double)(signX * xPos), (double)this.getEpsilon());
                Assertions.assertEquals((double)tuple1.getY(), (double)(signY * yPos), (double)this.getEpsilon());
                tuple1.absolute();
                Assertions.assertEquals((double)tuple1.getX(), (double)xPos, (double)this.getEpsilon());
                Assertions.assertEquals((double)tuple1.getY(), (double)yPos, (double)this.getEpsilon());
            }
        }
    }

    @Test
    public void testNegate() throws Exception {
        Random random = new Random(621541L);
        Tuple2DBasics tuple1 = (Tuple2DBasics)this.createEmptyTuple();
        Tuple2DBasics tuple2 = (Tuple2DBasics)this.createEmptyTuple();
        for (double signX = -1.0; signX <= 1.0; signX += 2.0) {
            for (double signY = -1.0; signY <= 1.0; signY += 2.0) {
                double xOriginal = signX * random.nextDouble();
                double yOriginal = signY * random.nextDouble();
                tuple1.setX(xOriginal);
                tuple1.setY(yOriginal);
                tuple2.setAndNegate((Tuple2DReadOnly)tuple1);
                Assertions.assertEquals((double)tuple2.getX(), (double)(-xOriginal), (double)this.getEpsilon());
                Assertions.assertEquals((double)tuple2.getY(), (double)(-yOriginal), (double)this.getEpsilon());
                Assertions.assertEquals((double)tuple1.getX(), (double)xOriginal, (double)this.getEpsilon());
                Assertions.assertEquals((double)tuple1.getY(), (double)yOriginal, (double)this.getEpsilon());
                tuple1.negate();
                Assertions.assertEquals((double)tuple1.getX(), (double)(-xOriginal), (double)this.getEpsilon());
                Assertions.assertEquals((double)tuple1.getY(), (double)(-yOriginal), (double)this.getEpsilon());
            }
        }
    }

    @Test
    public void testClip() throws Exception {
        double max;
        double min;
        double max2;
        int i;
        Random random = new Random(621541L);
        Tuple2DBasics tuple1 = (Tuple2DBasics)this.createEmptyTuple();
        Tuple2DBasics tuple2 = (Tuple2DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            max2 = random.nextDouble();
            tuple1.setX(max2 + random.nextDouble());
            tuple1.setY(max2 + random.nextDouble());
            tuple1.clipToMax(max2);
            Assertions.assertEquals((double)tuple1.getX(), (double)max2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)max2, (double)this.getEpsilon());
            max2 = random.nextDouble();
            tuple2.setX(max2 - random.nextDouble());
            tuple2.setY(max2 - random.nextDouble());
            tuple1.set((Tuple2DReadOnly)tuple2);
            tuple1.clipToMax(max2);
            Assertions.assertTrue((boolean)tuple1.equals((EuclidGeometry)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            max2 = random.nextDouble();
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple2.setX(max2 + random.nextDouble());
            tuple2.setY(max2 + random.nextDouble());
            tuple1.setAndClipToMax(max2, (Tuple2DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)max2, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)max2, (double)this.getEpsilon());
            max2 = random.nextDouble();
            tuple2.setX(max2 - random.nextDouble());
            tuple2.setY(max2 - random.nextDouble());
            tuple1.setAndClipToMax(max2, (Tuple2DReadOnly)tuple2);
            Assertions.assertTrue((boolean)tuple1.equals((EuclidGeometry)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble();
            tuple1.setX(min - random.nextDouble());
            tuple1.setY(min - random.nextDouble());
            tuple1.clipToMin(min);
            Assertions.assertEquals((double)tuple1.getX(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)min, (double)this.getEpsilon());
            min = random.nextDouble();
            tuple2.setX(min + random.nextDouble());
            tuple2.setY(min + random.nextDouble());
            tuple1.set((Tuple2DReadOnly)tuple2);
            tuple1.clipToMin(min);
            Assertions.assertTrue((boolean)tuple1.equals((EuclidGeometry)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble();
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple2.setX(min - random.nextDouble());
            tuple2.setY(min - random.nextDouble());
            tuple1.setAndClipToMin(min, (Tuple2DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)min, (double)this.getEpsilon());
            min = random.nextDouble();
            tuple2.setX(min + random.nextDouble());
            tuple2.setY(min + random.nextDouble());
            tuple1.setAndClipToMin(min, (Tuple2DReadOnly)tuple2);
            Assertions.assertTrue((boolean)tuple1.equals((EuclidGeometry)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble() - 0.5;
            max = random.nextDouble() + 0.5;
            tuple1.setX(min - random.nextDouble());
            tuple1.setY(min - random.nextDouble());
            tuple1.clipToMinMax(min, max);
            Assertions.assertEquals((double)tuple1.getX(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)min, (double)this.getEpsilon());
            min = random.nextDouble() - 0.5;
            max = random.nextDouble() + 0.5;
            tuple1.setX(max + random.nextDouble());
            tuple1.setY(max + random.nextDouble());
            tuple1.clipToMinMax(min, max);
            Assertions.assertEquals((double)tuple1.getX(), (double)max, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)max, (double)this.getEpsilon());
            min = random.nextDouble() - 1.0;
            max = random.nextDouble() + 1.0;
            tuple2.setX(min + random.nextDouble());
            tuple2.setY(min + random.nextDouble());
            tuple1.set((Tuple2DReadOnly)tuple2);
            tuple1.clipToMinMax(min, max);
            Assertions.assertTrue((boolean)tuple1.equals((EuclidGeometry)tuple2));
        }
        for (i = 0; i < 1000; ++i) {
            min = random.nextDouble() - 0.5;
            max = random.nextDouble() + 0.5;
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple2.setX(min - random.nextDouble());
            tuple2.setY(min - random.nextDouble());
            tuple1.setAndClipToMinMax(min, max, (Tuple2DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)min, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)min, (double)this.getEpsilon());
            min = random.nextDouble() - 0.5;
            max = random.nextDouble() + 0.5;
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple2.setX(max + random.nextDouble());
            tuple2.setY(max + random.nextDouble());
            tuple1.setAndClipToMinMax(min, max, (Tuple2DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)max, (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)max, (double)this.getEpsilon());
            min = random.nextDouble() - 1.0;
            max = random.nextDouble() + 1.0;
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple2.setX(min + random.nextDouble());
            tuple2.setY(min + random.nextDouble());
            tuple1.setAndClipToMinMax(min, max, (Tuple2DReadOnly)tuple2);
            Assertions.assertTrue((boolean)tuple1.equals((EuclidGeometry)tuple2));
        }
    }

    @Test
    public void testClipToMaxNorm() throws Exception {
        double yaw;
        double maxNorm;
        int i;
        Random random = new Random(234234L);
        for (i = 0; i < 1000; ++i) {
            maxNorm = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7, (double)10.0);
            double tupleNorm = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Tuple2DBasics expectedTuple = (Tuple2DBasics)this.createTuple(1.0, 0.0);
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            RotationMatrixTools.applyYawRotation((double)yaw, (Tuple2DReadOnly)expectedTuple, (Tuple2DBasics)expectedTuple);
            Tuple2DBasics actualTuple = (Tuple2DBasics)this.createEmptyTuple();
            actualTuple.setAndScale(tupleNorm, (Tuple2DReadOnly)expectedTuple);
            if (maxNorm > tupleNorm) {
                expectedTuple.scale(tupleNorm);
                Assertions.assertFalse((boolean)actualTuple.clipToMaxNorm(maxNorm));
            } else {
                expectedTuple.scale(maxNorm);
                Assertions.assertTrue((boolean)actualTuple.clipToMaxNorm(maxNorm));
            }
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i + ", maxNorm: " + maxNorm), (EuclidGeometry)expectedTuple, (EuclidGeometry)actualTuple, (double)(5.0 * this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            maxNorm = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0E-7);
            double vectorNorm = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Tuple2DBasics actualNorm = (Tuple2DBasics)this.createTuple(vectorNorm, 0.0);
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            RotationMatrixTools.applyYawRotation((double)yaw, (Tuple2DReadOnly)actualNorm, (Tuple2DBasics)actualNorm);
            Assertions.assertTrue((boolean)actualNorm.clipToMaxNorm(maxNorm));
            EuclidCoreTestTools.assertTuple2DIsSetToZero((String)("Iteration: " + i + ", maxLength: " + maxNorm), (Tuple2DReadOnly)actualNorm);
        }
    }

    @Test
    public void testAdd() throws Exception {
        double y;
        double x;
        double yOld;
        double xOld;
        int i;
        Random random = new Random(621541L);
        Tuple2DBasics tuple1 = (Tuple2DBasics)this.createEmptyTuple();
        Tuple2DBasics tuple2 = (Tuple2DBasics)this.createEmptyTuple();
        Tuple2DBasics tuple3 = (Tuple2DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            x = random.nextDouble();
            y = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.addX(x);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld + x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)yOld, (double)this.getEpsilon());
            tuple1.addY(y);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld + x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld + y), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            x = random.nextDouble();
            y = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.add(x, y);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld + x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld + y), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.add((Tuple2DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld + tuple2.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld + tuple2.getY()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple3.setX(random.nextDouble());
            tuple3.setY(random.nextDouble());
            tuple1.add((Tuple2DReadOnly)tuple2, (Tuple2DReadOnly)tuple3);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() + tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() + tuple3.getY()), (double)this.getEpsilon());
        }
    }

    @Test
    public void testSub() throws Exception {
        double y;
        double x;
        double yOld;
        double xOld;
        int i;
        Random random = new Random(621541L);
        Tuple2DBasics tuple1 = (Tuple2DBasics)this.createEmptyTuple();
        Tuple2DBasics tuple2 = (Tuple2DBasics)this.createEmptyTuple();
        Tuple2DBasics tuple3 = (Tuple2DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            x = random.nextDouble();
            y = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.subX(x);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld - x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)yOld, (double)this.getEpsilon());
            tuple1.subY(y);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld - x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld - y), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            x = random.nextDouble();
            y = random.nextDouble();
            tuple1.set(xOld, yOld);
            tuple1.sub(x, y);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld - x), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld - y), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple1.sub((Tuple2DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld - tuple2.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld - tuple2.getY()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple3.setX(random.nextDouble());
            tuple3.setY(random.nextDouble());
            tuple1.sub((Tuple2DReadOnly)tuple2, (Tuple2DReadOnly)tuple3);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() - tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() - tuple3.getY()), (double)this.getEpsilon());
        }
    }

    @Test
    public void testScale() throws Exception {
        double yOld;
        double xOld;
        double scale;
        double yOld2;
        double xOld2;
        int i;
        Random random = new Random(621541L);
        Tuple2DBasics tuple1 = (Tuple2DBasics)this.createEmptyTuple();
        Tuple2DBasics tuple2 = (Tuple2DBasics)this.createEmptyTuple();
        Tuple2DBasics tuple3 = (Tuple2DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            xOld2 = random.nextDouble();
            yOld2 = random.nextDouble();
            double scale2 = random.nextDouble();
            tuple1.set(xOld2, yOld2);
            tuple1.scale(scale2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld2 * scale2), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld2 * scale2), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            xOld2 = random.nextDouble();
            yOld2 = random.nextDouble();
            double scaleX = random.nextDouble();
            double scaleY = random.nextDouble();
            tuple1.set(xOld2, yOld2);
            tuple1.scale(scaleX, scaleY);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld2 * scaleX), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld2 * scaleY), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple1.setAndScale(scale, (Tuple2DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple1.scaleAdd(scale, (Tuple2DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld * scale + tuple2.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld * scale + tuple2.getY()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple3.setX(random.nextDouble());
            tuple3.setY(random.nextDouble());
            tuple1.scaleAdd(scale, (Tuple2DReadOnly)tuple2, (Tuple2DReadOnly)tuple3);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale + tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale + tuple3.getY()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble());
            tuple3.set((Tuple2DReadOnly)tuple1);
            tuple1.scaleAdd(scale, (Tuple2DReadOnly)tuple2, (Tuple2DReadOnly)tuple1);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale + tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale + tuple3.getY()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            xOld = random.nextDouble();
            yOld = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple1.scaleSub(scale, (Tuple2DReadOnly)tuple2);
            Assertions.assertEquals((double)tuple1.getX(), (double)(xOld * scale - tuple2.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(yOld * scale - tuple2.getY()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple3.setX(random.nextDouble());
            tuple3.setY(random.nextDouble());
            tuple1.scaleSub(scale, (Tuple2DReadOnly)tuple2, (Tuple2DReadOnly)tuple3);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale - tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale - tuple3.getY()), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            scale = random.nextDouble();
            tuple1.set(random.nextDouble(), random.nextDouble());
            tuple2.set(random.nextDouble(), random.nextDouble());
            tuple3.set((Tuple2DReadOnly)tuple1);
            tuple1.scaleSub(scale, (Tuple2DReadOnly)tuple2, (Tuple2DReadOnly)tuple1);
            Assertions.assertEquals((double)tuple1.getX(), (double)(tuple2.getX() * scale - tuple3.getX()), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)(tuple2.getY() * scale - tuple3.getY()), (double)this.getEpsilon());
        }
    }

    @Test
    public void testInterpolate() throws Exception {
        double alpha;
        int i;
        Random random = new Random(621541L);
        Tuple2DBasics tuple1 = (Tuple2DBasics)this.createEmptyTuple();
        Tuple2DBasics tuple2 = (Tuple2DBasics)this.createEmptyTuple();
        Tuple2DBasics tuple3 = (Tuple2DBasics)this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            alpha = random.nextDouble();
            double xOld = random.nextDouble();
            double yOld = random.nextDouble();
            tuple1.setX(xOld);
            tuple1.setY(yOld);
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple1.interpolate((Tuple2DReadOnly)tuple2, alpha);
            Assertions.assertEquals((double)tuple1.getX(), (double)EuclidCoreTools.interpolate((double)xOld, (double)tuple2.getX(), (double)alpha), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)EuclidCoreTools.interpolate((double)yOld, (double)tuple2.getY(), (double)alpha), (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            alpha = random.nextDouble();
            tuple1.setX(random.nextDouble());
            tuple1.setY(random.nextDouble());
            tuple2.setX(random.nextDouble());
            tuple2.setY(random.nextDouble());
            tuple3.setX(random.nextDouble());
            tuple3.setY(random.nextDouble());
            tuple1.interpolate((Tuple2DReadOnly)tuple2, (Tuple2DReadOnly)tuple3, alpha);
            Assertions.assertEquals((double)tuple1.getX(), (double)EuclidCoreTools.interpolate((double)tuple2.getX(), (double)tuple3.getX(), (double)alpha), (double)this.getEpsilon());
            Assertions.assertEquals((double)tuple1.getY(), (double)EuclidCoreTools.interpolate((double)tuple2.getY(), (double)tuple3.getY(), (double)alpha), (double)this.getEpsilon());
        }
    }
}

