/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.transform;

import java.util.Arrays;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.exceptions.NotAnOrientation2DException;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.QuaternionBasedTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.RigidBodyTransformBasicsTest;
import us.ihmc.euclid.transform.interfaces.AffineTransformBasics;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;

public class RigidBodyTransformTest
extends RigidBodyTransformBasicsTest<RigidBodyTransform> {
    private static final double EPS = 1.0E-14;

    @Test
    public void testConstructors() throws Exception {
        int column;
        int row;
        Random random = new Random(345L);
        RigidBodyTransform transform = new RigidBodyTransform();
        for (int row2 = 0; row2 < 4; ++row2) {
            for (int column2 = 0; column2 < 4; ++column2) {
                if (row2 == column2) {
                    Assertions.assertTrue((transform.getElement(row2, column2) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertTrue((transform.getElement(row2, column2) == 0.0 ? 1 : 0) != 0);
            }
        }
        RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform actual = new RigidBodyTransform((RigidBodyTransformReadOnly)expected);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = new RigidBodyTransform((RigidBodyTransformReadOnly)new QuaternionBasedTransform((RigidBodyTransformReadOnly)expected));
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        for (row = 0; row < 4; ++row) {
            for (column = 0; column < 4; ++column) {
                Assertions.assertEquals((double)expected.getElement(row, column), (double)actual.getElement(row, column), (double)1.0E-14);
            }
        }
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        DMatrixRMaj denseMatrix = new DMatrixRMaj(4, 4);
        for (row = 0; row < 4; ++row) {
            for (column = 0; column < 4; ++column) {
                denseMatrix.set(row, column, expected.getElement(row, column));
            }
        }
        RigidBodyTransform actual2 = new RigidBodyTransform((DMatrix)denseMatrix);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual2, (double)0.0);
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        denseMatrix = new DMatrixRMaj(4, 4);
        for (int row3 = 0; row3 < 4; ++row3) {
            for (column = 0; column < 4; ++column) {
                denseMatrix.set(row3, column, expected.getElement(row3, column));
            }
        }
        RotationMatrix rotationMatrix = new RotationMatrix();
        rotationMatrix.set((DMatrix)denseMatrix);
        Vector3D vector = new Vector3D();
        vector.set(0, 3, (DMatrix)denseMatrix);
        RigidBodyTransform actual3 = new RigidBodyTransform((Orientation3DReadOnly)rotationMatrix, (Tuple3DReadOnly)vector);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual3, (double)0.0);
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        denseMatrix = new DMatrixRMaj(4, 4);
        for (int row4 = 0; row4 < 4; ++row4) {
            for (int column3 = 0; column3 < 4; ++column3) {
                denseMatrix.set(row4, column3, expected.getElement(row4, column3));
            }
        }
        rotationMatrix = new RotationMatrix();
        rotationMatrix.set((DMatrix)denseMatrix);
        vector = new Vector3D();
        vector.set(0, 3, (DMatrix)denseMatrix);
        actual3 = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion((Orientation3DReadOnly)rotationMatrix), (Tuple3DReadOnly)vector);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual3, (double)1.0E-14);
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        denseMatrix = new DMatrixRMaj(4, 4);
        for (int row5 = 0; row5 < 4; ++row5) {
            for (int column4 = 0; column4 < 4; ++column4) {
                denseMatrix.set(row5, column4, expected.getElement(row5, column4));
            }
        }
        rotationMatrix = new RotationMatrix();
        rotationMatrix.set((DMatrix)denseMatrix);
        vector = new Vector3D();
        vector.set(0, 3, (DMatrix)denseMatrix);
        actual3 = new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Orientation3DReadOnly)rotationMatrix), (Tuple3DReadOnly)vector);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual3, (double)1.0E-14);
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        double[] transformArray = new double[16];
        for (int row6 = 0; row6 < 4; ++row6) {
            for (int column5 = 0; column5 < 4; ++column5) {
                transformArray[4 * row6 + column5] = expected.getElement(row6, column5);
            }
        }
        actual = new RigidBodyTransform(transformArray);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        for (int row7 = 0; row7 < 4; ++row7) {
            for (int column6 = 0; column6 < 4; ++column6) {
                Assertions.assertTrue((expected.getElement(row7, column6) == actual.getElement(row7, column6) ? 1 : 0) != 0);
            }
        }
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        double m00 = expected.getM00();
        double m01 = expected.getM01();
        double m02 = expected.getM02();
        double m03 = expected.getM03();
        double m10 = expected.getM10();
        double m11 = expected.getM11();
        double m12 = expected.getM12();
        double m13 = expected.getM13();
        double m20 = expected.getM20();
        double m21 = expected.getM21();
        double m22 = expected.getM22();
        double m23 = expected.getM23();
        RigidBodyTransform actual4 = new RigidBodyTransform(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual4, (double)0.0);
        for (int row8 = 0; row8 < 4; ++row8) {
            for (int column7 = 0; column7 < 4; ++column7) {
                Assertions.assertTrue((expected.getElement(row8, column7) == actual4.getElement(row8, column7) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testDeterminantRotationPart() throws Exception {
        Random random = new Random(42353L);
        RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform transform = new RigidBodyTransform((RigidBodyTransformReadOnly)original);
        double corruptionFactor = 0.1;
        double m00 = original.getM00() * corruptionFactor;
        double m01 = original.getM01() * corruptionFactor;
        double m02 = original.getM02() * corruptionFactor;
        double m10 = original.getM10() * corruptionFactor;
        double m11 = original.getM11() * corruptionFactor;
        double m12 = original.getM12() * corruptionFactor;
        double m20 = original.getM20() * corruptionFactor;
        double m21 = original.getM21() * corruptionFactor;
        double m22 = original.getM22() * corruptionFactor;
        transform.getRotation().setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        Assertions.assertTrue((transform.getRotation().determinant() < corruptionFactor ? 1 : 0) != 0);
        transform.normalizeRotationPart();
        Assertions.assertEquals((double)1.0, (double)transform.getRotation().determinant(), (double)1.0E-14);
    }

    @Test
    public void testSet() throws Exception {
        int row;
        int row2;
        Random random = new Random(34534L);
        RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform actual = new RigidBodyTransform();
        double m00 = expected.getM00();
        double m01 = expected.getM01();
        double m02 = expected.getM02();
        double m03 = expected.getM03();
        double m10 = expected.getM10();
        double m11 = expected.getM11();
        double m12 = expected.getM12();
        double m13 = expected.getM13();
        double m20 = expected.getM20();
        double m21 = expected.getM21();
        double m22 = expected.getM22();
        double m23 = expected.getM23();
        actual.set(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setTranslationToZero();
        m00 = expected.getM00();
        m01 = expected.getM01();
        m02 = expected.getM02();
        m03 = expected.getM03();
        m10 = expected.getM10();
        m11 = expected.getM11();
        m12 = expected.getM12();
        m13 = expected.getM13();
        m20 = expected.getM20();
        m21 = expected.getM21();
        m22 = expected.getM22();
        m23 = expected.getM23();
        actual.set(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertFalse((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setRotationToZero();
        m00 = expected.getM00();
        m01 = expected.getM01();
        m02 = expected.getM02();
        m03 = expected.getM03();
        m10 = expected.getM10();
        m11 = expected.getM11();
        m12 = expected.getM12();
        m13 = expected.getM13();
        m20 = expected.getM20();
        m21 = expected.getM21();
        m22 = expected.getM22();
        m23 = expected.getM23();
        actual.set(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertFalse((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = new RigidBodyTransform();
        m00 = expected.getM00();
        m01 = expected.getM01();
        m02 = expected.getM02();
        m03 = expected.getM03();
        m10 = expected.getM10();
        m11 = expected.getM11();
        m12 = expected.getM12();
        m13 = expected.getM13();
        m20 = expected.getM20();
        m21 = expected.getM21();
        m22 = expected.getM22();
        m23 = expected.getM23();
        actual.setUnsafe(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setTranslationToZero();
        m00 = expected.getM00();
        m01 = expected.getM01();
        m02 = expected.getM02();
        m03 = expected.getM03();
        m10 = expected.getM10();
        m11 = expected.getM11();
        m12 = expected.getM12();
        m13 = expected.getM13();
        m20 = expected.getM20();
        m21 = expected.getM21();
        m22 = expected.getM22();
        m23 = expected.getM23();
        actual.setUnsafe(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertFalse((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setRotationToZero();
        m00 = expected.getM00();
        m01 = expected.getM01();
        m02 = expected.getM02();
        m03 = expected.getM03();
        m10 = expected.getM10();
        m11 = expected.getM11();
        m12 = expected.getM12();
        m13 = expected.getM13();
        m20 = expected.getM20();
        m21 = expected.getM21();
        m22 = expected.getM22();
        m23 = expected.getM23();
        actual.setUnsafe(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertFalse((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = new RigidBodyTransform();
        actual.set((RigidBodyTransformReadOnly)expected);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setTranslationToZero();
        actual.set((RigidBodyTransformReadOnly)expected);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertFalse((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setRotationToZero();
        actual.set((RigidBodyTransformReadOnly)expected);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertFalse((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = new RigidBodyTransform();
        actual.set((RigidBodyTransformReadOnly)new QuaternionBasedTransform((RigidBodyTransformReadOnly)expected));
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = new RigidBodyTransform();
        DMatrixRMaj denseMatrix = new DMatrixRMaj(4, 4);
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                denseMatrix.set(row2, column, expected.getElement(row2, column));
            }
        }
        actual.set((DMatrix)denseMatrix);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setTranslationToZero();
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                denseMatrix.set(row2, column, expected.getElement(row2, column));
            }
        }
        actual.set((DMatrix)denseMatrix);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertFalse((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setRotationToZero();
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                denseMatrix.set(row2, column, expected.getElement(row2, column));
            }
        }
        actual.set((DMatrix)denseMatrix);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertFalse((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = new RigidBodyTransform();
        int startRow = random.nextInt(10);
        int startColumn = random.nextInt(10);
        DMatrixRMaj denseMatrix2 = new DMatrixRMaj(4 + startRow, 4 + startColumn);
        for (row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                denseMatrix2.set(row + startRow, column + startColumn, expected.getElement(row, column));
            }
        }
        actual.set((DMatrix)denseMatrix2, startRow, startColumn);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setTranslationToZero();
        for (row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                denseMatrix2.set(row + startRow, column + startColumn, expected.getElement(row, column));
            }
        }
        actual.set((DMatrix)denseMatrix2, startRow, startColumn);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertFalse((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setRotationToZero();
        for (row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                denseMatrix2.set(row + startRow, column + startColumn, expected.getElement(row, column));
            }
        }
        actual.set((DMatrix)denseMatrix2, startRow, startColumn);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertFalse((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = new RigidBodyTransform();
        Object[] transformArray = new double[16];
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                transformArray[4 * row2 + column] = expected.getElement(row2, column);
            }
        }
        actual.set(transformArray);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setTranslationToZero();
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                transformArray[4 * row2 + column] = expected.getElement(row2, column);
            }
        }
        actual.set(transformArray);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertFalse((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setRotationToZero();
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                transformArray[4 * row2 + column] = expected.getElement(row2, column);
            }
        }
        actual.set(transformArray);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertFalse((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = new RigidBodyTransform();
        transformArray = new float[16];
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                transformArray[4 * row2 + column] = (float)expected.getElement(row2, column);
            }
        }
        actual.set((float[])transformArray);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-7);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setTranslationToZero();
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                transformArray[4 * row2 + column] = (float)expected.getElement(row2, column);
            }
        }
        actual.set((float[])transformArray);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-7);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertFalse((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setRotationToZero();
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                transformArray[4 * row2 + column] = (float)expected.getElement(row2, column);
            }
        }
        actual.set((float[])transformArray);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-7);
        Assertions.assertFalse((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = new RigidBodyTransform();
        transformArray = new double[16];
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                transformArray[4 * row2 + column] = expected.getElement(column, row2);
            }
        }
        actual.setAsTranspose(transformArray);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setTranslationToZero();
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                transformArray[4 * row2 + column] = expected.getElement(column, row2);
            }
        }
        actual.setAsTranspose(transformArray);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertFalse((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setRotationToZero();
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                transformArray[4 * row2 + column] = expected.getElement(column, row2);
            }
        }
        actual.setAsTranspose(transformArray);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)0.0);
        Assertions.assertFalse((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = new RigidBodyTransform();
        transformArray = new float[16];
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                transformArray[4 * row2 + column] = (float)expected.getElement(column, row2);
            }
        }
        actual.setAsTranspose((float[])transformArray);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-7);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setTranslationToZero();
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                transformArray[4 * row2 + column] = (float)expected.getElement(column, row2);
            }
        }
        actual.setAsTranspose((float[])transformArray);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-7);
        Assertions.assertTrue((boolean)actual.hasRotation());
        Assertions.assertFalse((boolean)actual.hasTranslation());
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected.setRotationToZero();
        for (row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                transformArray[4 * row2 + column] = (float)expected.getElement(column, row2);
            }
        }
        actual.setAsTranspose((float[])transformArray);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-7);
        Assertions.assertFalse((boolean)actual.hasRotation());
        Assertions.assertTrue((boolean)actual.hasTranslation());
        RigidBodyTransform actual2 = new RigidBodyTransform();
        RotationMatrix expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        Vector3D expectedTranslation = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual2.set((Matrix3DReadOnly)expectedRotation, (Tuple3DReadOnly)expectedTranslation);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual2.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actual2.getTranslation(), (double)0.0);
        Assertions.assertTrue((boolean)actual2.hasRotation());
        Assertions.assertTrue((boolean)actual2.hasTranslation());
        expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        expectedTranslation = new Vector3D();
        actual2.set((Matrix3DReadOnly)expectedRotation, (Tuple3DReadOnly)expectedTranslation);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual2.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actual2.getTranslation(), (double)0.0);
        Assertions.assertTrue((boolean)actual2.hasRotation());
        Assertions.assertFalse((boolean)actual2.hasTranslation());
        expectedRotation = new RotationMatrix();
        expectedTranslation = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual2.set((Matrix3DReadOnly)expectedRotation, (Tuple3DReadOnly)expectedTranslation);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual2.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actual2.getTranslation(), (double)0.0);
        Assertions.assertFalse((boolean)actual2.hasRotation());
        Assertions.assertTrue((boolean)actual2.hasTranslation());
        actual2 = new RigidBodyTransform();
        expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        expectedTranslation = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual2.set((RotationMatrixReadOnly)expectedRotation, (Tuple3DReadOnly)expectedTranslation);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual2.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actual2.getTranslation(), (double)0.0);
        Assertions.assertTrue((boolean)actual2.hasRotation());
        Assertions.assertTrue((boolean)actual2.hasTranslation());
        expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        expectedTranslation = new Vector3D();
        actual2.set((RotationMatrixReadOnly)expectedRotation, (Tuple3DReadOnly)expectedTranslation);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual2.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actual2.getTranslation(), (double)0.0);
        Assertions.assertTrue((boolean)actual2.hasRotation());
        Assertions.assertFalse((boolean)actual2.hasTranslation());
        expectedRotation = new RotationMatrix();
        expectedTranslation = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual2.set((RotationMatrixReadOnly)expectedRotation, (Tuple3DReadOnly)expectedTranslation);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual2.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actual2.getTranslation(), (double)0.0);
        Assertions.assertFalse((boolean)actual2.hasRotation());
        Assertions.assertTrue((boolean)actual2.hasTranslation());
        actual2 = new RigidBodyTransform();
        Quaternion expectedOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        expectedTranslation = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual2.set((Orientation3DReadOnly)expectedOrientation, (Tuple3DReadOnly)expectedTranslation);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)expectedOrientation), (Matrix3DReadOnly)actual2.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actual2.getTranslation(), (double)0.0);
        Assertions.assertTrue((boolean)actual2.hasRotation());
        Assertions.assertTrue((boolean)actual2.hasTranslation());
        expectedOrientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
        expectedTranslation = new Vector3D();
        actual2.set((Orientation3DReadOnly)expectedOrientation, (Tuple3DReadOnly)expectedTranslation);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)expectedOrientation), (Matrix3DReadOnly)actual2.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actual2.getTranslation(), (double)0.0);
        Assertions.assertTrue((boolean)actual2.hasRotation());
        Assertions.assertFalse((boolean)actual2.hasTranslation());
        expectedOrientation = new Quaternion();
        expectedTranslation = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual2.set((Orientation3DReadOnly)expectedOrientation, (Tuple3DReadOnly)expectedTranslation);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)expectedOrientation), (Matrix3DReadOnly)actual2.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actual2.getTranslation(), (double)0.0);
        Assertions.assertFalse((boolean)actual2.hasRotation());
        Assertions.assertTrue((boolean)actual2.hasTranslation());
    }

    @Test
    public void testSetIdentity() throws Exception {
        int column;
        int row;
        Random random = new Random(2342L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Assertions.assertTrue((boolean)transform.hasRotation());
        Assertions.assertTrue((boolean)transform.hasTranslation());
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 4; ++column) {
                if (row == column) {
                    Assertions.assertFalse((transform.getElement(row, column) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertFalse((transform.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
        transform.setIdentity();
        Assertions.assertFalse((boolean)transform.hasRotation());
        Assertions.assertFalse((boolean)transform.hasTranslation());
        for (row = 0; row < 4; ++row) {
            for (column = 0; column < 4; ++column) {
                if (row == column) {
                    Assertions.assertTrue((transform.getElement(row, column) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertTrue((transform.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testIsMatrix2D() throws Exception {
        Random random = new Random(3242L);
        RigidBodyTransform transform = new RigidBodyTransform();
        double d = EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0);
        transform.getRotation().setUnsafe(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        transform.getTranslation().set(5.0, 3.0, -2.0);
        Assertions.assertTrue((boolean)transform.isRotation2D());
        transform.getRotation().setUnsafe(0.0, 0.0, d, 0.0, 0.0, d, d, d, d);
        transform.getTranslation().set(5.0, 3.0, -2.0);
        Assertions.assertFalse((boolean)transform.isRotation2D());
        transform.getRotation().setUnsafe(d, d, 0.0, d, d, 0.0, 0.0, 0.0, 1.0);
        transform.getTranslation().set(5.0, 3.0, -2.0);
        Assertions.assertTrue((boolean)transform.isRotation2D());
    }

    @Test
    public void testCheckIfMatrix2D() throws Exception {
        Random random = new Random(3242L);
        RigidBodyTransform transform = new RigidBodyTransform();
        double d = EuclidCoreRandomTools.nextDouble((Random)random, (double)5.0);
        transform.getRotation().setUnsafe(0.0, 0.0, d, 0.0, 0.0, d, d, d, d);
        transform.getTranslation().set(5.0, 3.0, -2.0);
        try {
            transform.checkIfRotation2D();
            Assertions.fail((String)"Should have thrown a NotAMatrix2DException.");
        }
        catch (NotAnOrientation2DException e) {
            Assertions.assertTrue((boolean)e.getMessage().equals("The orientation is not in XY plane: \n" + transform.getRotation()));
        }
        transform.getRotation().setUnsafe(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        transform.getTranslation().set(5.0, 3.0, -2.0);
        transform.checkIfRotation2D();
        transform.getRotation().setUnsafe(d, d, 0.0, d, d, 0.0, 0.0, 0.0, 1.0);
        transform.getTranslation().set(5.0, 3.0, -2.0);
        transform.checkIfRotation2D();
    }

    @Test
    @Deprecated
    public void testSetRotation() throws Exception {
        Random random = new Random(2342L);
        RotationMatrix expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        double m00 = expectedRotation.getM00();
        double m01 = expectedRotation.getM01();
        double m02 = expectedRotation.getM02();
        double m10 = expectedRotation.getM10();
        double m11 = expectedRotation.getM11();
        double m12 = expectedRotation.getM12();
        double m20 = expectedRotation.getM20();
        double m21 = expectedRotation.getM21();
        double m22 = expectedRotation.getM22();
        actual.getRotation().set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual.getRotation(), (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        expectedRotation.setToZero();
        m00 = expectedRotation.getM00();
        m01 = expectedRotation.getM01();
        m02 = expectedRotation.getM02();
        m10 = expectedRotation.getM10();
        m11 = expectedRotation.getM11();
        m12 = expectedRotation.getM12();
        m20 = expectedRotation.getM20();
        m21 = expectedRotation.getM21();
        m22 = expectedRotation.getM22();
        actual.getRotation().set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual.getRotation(), (double)0.0);
        Assertions.assertFalse((boolean)actual.hasRotation());
        expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        m00 = expectedRotation.getM00();
        m01 = expectedRotation.getM01();
        m02 = expectedRotation.getM02();
        m10 = expectedRotation.getM10();
        m11 = expectedRotation.getM11();
        m12 = expectedRotation.getM12();
        m20 = expectedRotation.getM20();
        m21 = expectedRotation.getM21();
        m22 = expectedRotation.getM22();
        actual.getRotation().setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual.getRotation(), (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        expectedRotation.setToZero();
        m00 = expectedRotation.getM00();
        m01 = expectedRotation.getM01();
        m02 = expectedRotation.getM02();
        m10 = expectedRotation.getM10();
        m11 = expectedRotation.getM11();
        m12 = expectedRotation.getM12();
        m20 = expectedRotation.getM20();
        m21 = expectedRotation.getM21();
        m22 = expectedRotation.getM22();
        actual.getRotation().setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual.getRotation(), (double)0.0);
        Assertions.assertFalse((boolean)actual.hasRotation());
        expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        AxisAngle axisAngle = new AxisAngle((Orientation3DReadOnly)expectedRotation);
        actual.getRotation().set((Orientation3DReadOnly)axisAngle);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual.getRotation(), (double)1.0E-14);
        Assertions.assertTrue((boolean)actual.hasRotation());
        axisAngle.setToZero();
        expectedRotation.set((Orientation3DReadOnly)axisAngle);
        actual.getRotation().set((Orientation3DReadOnly)axisAngle);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual.getRotation(), (double)0.0);
        Assertions.assertFalse((boolean)actual.hasRotation());
        expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        expectedRotation.get((DMatrix)denseMatrix);
        actual.getRotation().set((DMatrix)denseMatrix);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual.getRotation(), (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        CommonOps_DDRM.setIdentity((DMatrix1Row)denseMatrix);
        expectedRotation.set((DMatrix)denseMatrix);
        actual.getRotation().set((DMatrix)denseMatrix);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual.getRotation(), (double)0.0);
        Assertions.assertFalse((boolean)actual.hasRotation());
        expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Quaternion quaternion = new Quaternion((Orientation3DReadOnly)expectedRotation);
        actual.getRotation().set((Orientation3DReadOnly)quaternion);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual.getRotation(), (double)1.0E-14);
        Assertions.assertTrue((boolean)actual.hasRotation());
        quaternion.setToZero();
        expectedRotation.set((Orientation3DReadOnly)quaternion);
        actual.getRotation().set((Orientation3DReadOnly)quaternion);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual.getRotation(), (double)0.0);
        Assertions.assertFalse((boolean)actual.hasRotation());
        expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual.getRotation().set((RotationMatrixReadOnly)expectedRotation);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual.getRotation(), (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual.getRotation().set((Matrix3DReadOnly)expectedRotation);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual.getRotation(), (double)0.0);
        Assertions.assertTrue((boolean)actual.hasRotation());
        expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        Vector3D rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
        RigidBodyTransform actual2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual2.getRotation().setRotationVector((Vector3DReadOnly)rotationVector);
        expectedRotation.setRotationVector((Vector3DReadOnly)rotationVector);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actual2.getRotation(), (double)0.0);
        Assertions.assertTrue((boolean)actual2.hasRotation());
    }

    @Test
    @Deprecated
    public void testAppendTranslation() throws Exception {
        RigidBodyTransform translationTransform;
        RigidBodyTransform original;
        RigidBodyTransform actual;
        RigidBodyTransform expected;
        int i;
        Random random = new Random(35454L);
        for (i = 0; i < 1000; ++i) {
            expected = new RigidBodyTransform();
            actual = new RigidBodyTransform();
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            translationTransform = new RigidBodyTransform();
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double z = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            translationTransform.getTranslation().set(x, y, z);
            expected.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)expected.hasTranslation());
            expected.multiply((RigidBodyTransformReadOnly)translationTransform);
            Assertions.assertTrue((boolean)expected.hasTranslation());
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.appendTranslation(x, y, z);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            original.setToZero();
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.appendTranslation(x, y, z);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.appendTranslation(0.0, 0.0, 0.0);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)original.getTranslation());
            negateTranslation.negate();
            original.inverseTransform((Vector3DBasics)negateTranslation);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.appendTranslation(negateTranslation.getX(), negateTranslation.getY(), negateTranslation.getZ());
            Assertions.assertFalse((boolean)actual.hasTranslation());
        }
        for (i = 0; i < 1000; ++i) {
            expected = new RigidBodyTransform();
            actual = new RigidBodyTransform();
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            translationTransform = new RigidBodyTransform();
            Point3D translation = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
            translationTransform.getTranslation().set((Tuple3DReadOnly)translation);
            expected.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)expected.hasTranslation());
            expected.multiply((RigidBodyTransformReadOnly)translationTransform);
            Assertions.assertTrue((boolean)expected.hasTranslation());
            actual.set((RigidBodyTransformReadOnly)original);
            actual.appendTranslation((Tuple3DReadOnly)translation);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            original.setToZero();
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.appendTranslation((Tuple3DReadOnly)translation);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.appendTranslation(0.0, 0.0, 0.0);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)original.getTranslation());
            negateTranslation.negate();
            original.inverseTransform((Vector3DBasics)negateTranslation);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.appendTranslation((Tuple3DReadOnly)negateTranslation);
            Assertions.assertFalse((boolean)actual.hasTranslation());
        }
    }

    @Test
    @Deprecated
    public void testSetRotationYawPitchRoll() throws Exception {
        Random random = new Random(234L);
        RotationMatrix expectedRotation = new RotationMatrix();
        RigidBodyTransform actualTransform = new RigidBodyTransform();
        YawPitchRoll yawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
        expectedRotation.set((Orientation3DReadOnly)yawPitchRoll);
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Vector3D expectedTranslation = new Vector3D();
        expectedTranslation.set((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.getRotation().setYawPitchRoll(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll());
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)0.0);
        actualTransform.getRotation().setYawPitchRoll(0.0, 0.0, 0.0);
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        expectedRotation.set((Orientation3DReadOnly)yawPitchRoll);
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actualTransform.setRotationYawPitchRollAndZeroTranslation(yawPitchRoll.getYaw(), yawPitchRoll.getPitch(), yawPitchRoll.getRoll());
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.setRotationYawPitchRollAndZeroTranslation(0.0, 0.0, 0.0);
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        expectedRotation.set((Orientation3DReadOnly)yawPitchRoll);
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actualTransform.setRotationEulerAndZeroTranslation(yawPitchRoll.getRoll(), yawPitchRoll.getPitch(), yawPitchRoll.getYaw());
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.setRotationEulerAndZeroTranslation(0.0, 0.0, 0.0);
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        expectedRotation.setToYawOrientation(yawPitchRoll.getYaw());
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expectedTranslation = new Vector3D();
        expectedTranslation.set((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.getRotation().setToYawOrientation(yawPitchRoll.getYaw());
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)0.0);
        actualTransform.getRotation().setToYawOrientation(0.0);
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        expectedRotation.setToPitchOrientation(yawPitchRoll.getPitch());
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expectedTranslation = new Vector3D();
        expectedTranslation.set((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.getRotation().setToPitchOrientation(yawPitchRoll.getPitch());
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)0.0);
        actualTransform.getRotation().setToPitchOrientation(0.0);
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        expectedRotation.setToRollOrientation(yawPitchRoll.getRoll());
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expectedTranslation = new Vector3D();
        expectedTranslation.set((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.getRotation().setToRollOrientation(yawPitchRoll.getRoll());
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)0.0);
        actualTransform.getRotation().setToRollOrientation(0.0);
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        expectedRotation.setToYawOrientation(yawPitchRoll.getYaw());
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actualTransform.setRotationYawAndZeroTranslation(yawPitchRoll.getYaw());
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.setRotationYawAndZeroTranslation(0.0);
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        expectedRotation.setToPitchOrientation(yawPitchRoll.getPitch());
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actualTransform.setRotationPitchAndZeroTranslation(yawPitchRoll.getPitch());
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.setRotationPitchAndZeroTranslation(0.0);
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        expectedRotation.setToRollOrientation(yawPitchRoll.getRoll());
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actualTransform.setRotationRollAndZeroTranslation(yawPitchRoll.getRoll());
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.setRotationRollAndZeroTranslation(0.0);
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
    }

    @Test
    @Deprecated
    public void testRotationEuler() throws Exception {
        Random random = new Random(42353L);
        RotationMatrix expectedRotation = new RotationMatrix();
        Vector3D expectedTranslation = new Vector3D();
        RigidBodyTransform actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expectedTranslation.set((Tuple3DReadOnly)actualTransform.getTranslation());
        Vector3D eulerAngles = EuclidCoreRandomTools.nextRotationVector((Random)random);
        expectedRotation.setEuler((Vector3DReadOnly)eulerAngles);
        actualTransform.getRotation().setEuler((Vector3DReadOnly)eulerAngles);
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)0.0);
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expectedTranslation.set((Tuple3DReadOnly)actualTransform.getTranslation());
        eulerAngles = EuclidCoreRandomTools.nextRotationVector((Random)random);
        expectedRotation.setEuler((Vector3DReadOnly)eulerAngles);
        actualTransform.setRotationEulerAndZeroTranslation((Vector3DReadOnly)eulerAngles);
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expectedTranslation.set((Tuple3DReadOnly)actualTransform.getTranslation());
        double rotX = Math.PI * random.nextDouble();
        double rotY = Math.PI * random.nextDouble();
        double rotZ = Math.PI * random.nextDouble();
        expectedRotation.setEuler(rotX, rotY, rotZ);
        actualTransform.getRotation().setEuler(rotX, rotY, rotZ);
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)0.0);
    }

    @Test
    @Deprecated
    public void testSetTranslation() throws Exception {
        Random random = new Random(243L);
        RotationMatrix expectedRotation = new RotationMatrix();
        Vector3D expectedTranslation = EuclidCoreRandomTools.nextVector3D((Random)random);
        RigidBodyTransform actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expectedRotation.set((RotationMatrixReadOnly)actualTransform.getRotation());
        actualTransform.getTranslation().setX(expectedTranslation.getX());
        actualTransform.getTranslation().setY(expectedTranslation.getY());
        actualTransform.getTranslation().setZ(expectedTranslation.getZ());
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)0.0);
        actualTransform.getTranslation().setX(0.0);
        actualTransform.getTranslation().setY(0.0);
        actualTransform.getTranslation().setZ(0.0);
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        actualTransform.getTranslation().setX(1.0);
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        actualTransform.getTranslation().setX(0.0);
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        actualTransform.getTranslation().setY(1.0);
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        actualTransform.getTranslation().setY(0.0);
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        actualTransform.getTranslation().setZ(1.0);
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        actualTransform.getTranslation().setZ(0.0);
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expectedRotation.set((RotationMatrixReadOnly)actualTransform.getRotation());
        actualTransform.getTranslation().set((Tuple3DReadOnly)expectedTranslation);
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)0.0);
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expectedRotation.set((RotationMatrixReadOnly)actualTransform.getRotation());
        actualTransform.getTranslation().set(expectedTranslation.getX(), expectedTranslation.getY(), expectedTranslation.getZ());
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)0.0);
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actualTransform.setTranslationAndIdentityRotation((Tuple3DReadOnly)expectedTranslation);
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)0.0);
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expectedRotation.set((RotationMatrixReadOnly)actualTransform.getRotation());
        actualTransform.setTranslationAndIdentityRotation(expectedTranslation.getX(), expectedTranslation.getY(), expectedTranslation.getZ());
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        Assertions.assertTrue((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslation, (EuclidGeometry)actualTransform.getTranslation(), (double)0.0);
    }

    @Test
    public void testGetRotation() throws Exception {
        int row;
        int column;
        int row2;
        int column2;
        int row3;
        Random random = new Random(2345L);
        RotationMatrix rotationMatrix = new RotationMatrix();
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        rotationMatrix.set((RotationMatrixReadOnly)transform.getRotation());
        for (row3 = 0; row3 < 3; ++row3) {
            for (column2 = 0; column2 < 3; ++column2) {
                Assertions.assertTrue((rotationMatrix.getElement(row3, column2) == transform.getElement(row3, column2) ? 1 : 0) != 0);
            }
        }
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        rotationMatrix.set((RotationMatrixReadOnly)transform.getRotation());
        for (row3 = 0; row3 < 3; ++row3) {
            for (column2 = 0; column2 < 3; ++column2) {
                Assertions.assertTrue((rotationMatrix.getElement(row3, column2) == transform.getElement(row3, column2) ? 1 : 0) != 0);
            }
        }
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        transform.getRotation().get((DMatrix)denseMatrix);
        for (row2 = 0; row2 < 3; ++row2) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertTrue((denseMatrix.get(row2, column) == transform.getElement(row2, column) ? 1 : 0) != 0);
            }
        }
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Quaternion quaternion = new Quaternion();
        quaternion.set((Orientation3DReadOnly)transform.getRotation());
        rotationMatrix.set((Orientation3DReadOnly)quaternion);
        for (row2 = 0; row2 < 3; ++row2) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertEquals((double)rotationMatrix.getElement(row2, column), (double)transform.getElement(row2, column), (double)1.0E-14);
            }
        }
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        AxisAngle axisAngle = new AxisAngle();
        axisAngle.set((Orientation3DReadOnly)transform.getRotation());
        rotationMatrix.set((Orientation3DReadOnly)axisAngle);
        for (row2 = 0; row2 < 3; ++row2) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertEquals((double)rotationMatrix.getElement(row2, column), (double)transform.getElement(row2, column), (double)1.0E-14);
            }
        }
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        double[] expected = new double[9];
        double[] actual = new double[9];
        transform.getRotation().get(actual);
        transform.getRotation().get(expected);
        Assertions.assertTrue((boolean)Arrays.equals(expected, actual));
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Vector3D rotationVector = new Vector3D();
        transform.getRotation().getRotationVector((Vector3DBasics)rotationVector);
        rotationMatrix.setRotationVector((Vector3DReadOnly)rotationVector);
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertEquals((double)rotationMatrix.getElement(row, column), (double)transform.getElement(row, column), (double)1.0E-14);
            }
        }
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Vector3D eulerAngles = new Vector3D();
        transform.getRotation().getEuler((Tuple3DBasics)eulerAngles);
        rotationMatrix.setEuler((Vector3DReadOnly)eulerAngles);
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                Assertions.assertEquals((double)rotationMatrix.getElement(row, column), (double)transform.getElement(row, column), (double)1.0E-14);
            }
        }
    }

    @Test
    public void testGetTranslation() throws Exception {
        Random random = new Random(2345L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Vector3D translation = new Vector3D();
        translation.set((Tuple3DReadOnly)transform.getTranslation());
        for (int row = 0; row < 3; ++row) {
            Assertions.assertTrue((translation.getElement(row) == transform.getElement(row, 3) ? 1 : 0) != 0);
        }
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)transform.getTranslation(), (double)1.0E-14);
        translation.set(transform.getTranslationX(), transform.getTranslationY(), transform.getTranslationZ());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)translation, (EuclidGeometry)transform.getTranslation(), (double)1.0E-14);
    }

    @Test
    public void testGet() throws Exception {
        int row;
        Random random = new Random(2342L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        DMatrixRMaj denseMatrix = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)4, (int)4);
        transform.get((DMatrix)denseMatrix);
        for (row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                Assertions.assertTrue((denseMatrix.get(row, column) == transform.getElement(row, column) ? 1 : 0) != 0);
            }
        }
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        int startRow = random.nextInt(10);
        int startColumn = random.nextInt(10);
        DMatrixRMaj denseMatrix2 = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)(4 + startRow), (int)(4 + startColumn));
        transform.get(startRow, startColumn, (DMatrix)denseMatrix2);
        for (int row2 = 0; row2 < 4; ++row2) {
            for (int column = 0; column < 4; ++column) {
                Assertions.assertTrue((denseMatrix2.get(row2 + startRow, column + startColumn) == transform.getElement(row2, column) ? 1 : 0) != 0);
            }
        }
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Object[] transformArray = new double[16];
        transform.get(transformArray);
        for (row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                Assertions.assertTrue((transformArray[4 * row + column] == transform.getElement(row, column) ? 1 : 0) != 0);
            }
        }
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        transformArray = new float[16];
        transform.get((float[])transformArray);
        for (row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                Assertions.assertEquals((double)transformArray[4 * row + column], (double)transform.getElement(row, column), (double)1.0E-7);
            }
        }
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Quaternion expectedQuaternion = new Quaternion();
        Quaternion actualQuaternion = new Quaternion();
        Vector3D expectedTranslation = new Vector3D();
        Vector3D actualTranslation = new Vector3D();
        expectedQuaternion.set((Orientation3DReadOnly)transform.getRotation());
        expectedTranslation.set((Tuple3DReadOnly)transform.getTranslation());
        transform.get((Orientation3DBasics)actualQuaternion, (Tuple3DBasics)actualTranslation);
        Assertions.assertEquals((Object)expectedQuaternion, (Object)actualQuaternion);
        Assertions.assertEquals((Object)expectedTranslation, (Object)actualTranslation);
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        AxisAngle expected = new AxisAngle();
        AxisAngle actual = new AxisAngle();
        expectedTranslation = new Vector3D();
        actualTranslation = new Vector3D();
        expected.set((Orientation3DReadOnly)transform.getRotation());
        expectedTranslation.set((Tuple3DReadOnly)transform.getTranslation());
        transform.get((Orientation3DBasics)actual, (Tuple3DBasics)actualTranslation);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertEquals((Object)expectedTranslation, (Object)actualTranslation);
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expected = new Vector3D();
        actual = new Vector3D();
        expectedTranslation = new Vector3D();
        actualTranslation = new Vector3D();
        transform.getRotation().getRotationVector((Vector3DBasics)expected);
        expectedTranslation.set((Tuple3DReadOnly)transform.getTranslation());
        transform.get((Vector3DBasics)actual, (Tuple3DBasics)actualTranslation);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertEquals((Object)expectedTranslation, (Object)actualTranslation);
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Matrix3D expectedMatrix = new Matrix3D();
        Matrix3D actualMatrix = new Matrix3D();
        expectedTranslation = new Vector3D();
        actualTranslation = new Vector3D();
        expectedMatrix.set((RotationMatrixReadOnly)transform.getRotation());
        expectedTranslation.set((Tuple3DReadOnly)transform.getTranslation());
        transform.get((CommonMatrix3DBasics)actualMatrix, (Tuple3DBasics)actualTranslation);
        Assertions.assertEquals((Object)expectedMatrix, (Object)actualMatrix);
        Assertions.assertEquals((Object)expectedTranslation, (Object)actualTranslation);
        transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        expectedMatrix = new RotationMatrix();
        actualMatrix = new RotationMatrix();
        expectedTranslation = new Vector3D();
        actualTranslation = new Vector3D();
        expectedMatrix.set((RotationMatrixReadOnly)transform.getRotation());
        expectedTranslation.set((Tuple3DReadOnly)transform.getTranslation());
        transform.get((RotationMatrixBasics)actualMatrix, (Tuple3DBasics)actualTranslation);
        Assertions.assertEquals((Object)expectedMatrix, (Object)actualMatrix);
        Assertions.assertEquals((Object)expectedTranslation, (Object)actualTranslation);
    }

    @Test
    @Deprecated
    public void testInvert() throws Exception {
        RigidBodyTransform transform;
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            DMatrixRMaj denseMatrix = new DMatrixRMaj(4, 4);
            transform.get((DMatrix)denseMatrix);
            CommonOps_DDRM.invert((DMatrixRMaj)denseMatrix);
            transform.invert();
            for (int row = 0; row < 4; ++row) {
                for (int column = 0; column < 4; ++column) {
                    Assertions.assertEquals((double)denseMatrix.get(row, column), (double)transform.getElement(row, column), (double)1.0E-14);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RotationMatrix expectedRotationPart = new RotationMatrix((RotationMatrixReadOnly)transform.getRotation());
            Vector3D expectedTranslationPart = new Vector3D((Tuple3DReadOnly)transform.getTranslation());
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotationPart, (Matrix3DReadOnly)transform.getRotation(), (double)1.0E-14);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTranslationPart, (EuclidGeometry)transform.getTranslation(), (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform expectedTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actualTransform = new RigidBodyTransform();
            actualTransform.setAndInvert((RigidBodyTransformReadOnly)expectedTransform);
            expectedTransform.invert();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)actualTransform, (double)1.0E-14);
        }
    }

    @Test
    public void testInterpolate() throws Exception {
        Random random = new Random(23542342L);
        RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform t0 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform tf = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual.interpolate(t0, tf, 0.0);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)t0, (EuclidGeometry)actual, (double)1.0E-14);
        actual.interpolate(tf, 0.0);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)t0, (EuclidGeometry)actual, (double)1.0E-14);
        actual.interpolate(tf, 1.0);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)tf, (EuclidGeometry)actual, (double)1.0E-14);
        actual.interpolate(t0, tf, 1.0);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)tf, (EuclidGeometry)actual, (double)1.0E-14);
        for (int i = 0; i < 1000; ++i) {
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            Vector3D interpolatedVector = new Vector3D();
            RotationMatrix interpolatedRotation = new RotationMatrix();
            interpolatedVector.interpolate((Tuple3DReadOnly)t0.getTranslation(), (Tuple3DReadOnly)tf.getTranslation(), alpha);
            interpolatedRotation.interpolate((RotationMatrixReadOnly)t0.getRotation(), (RotationMatrixReadOnly)tf.getRotation(), alpha);
            expected.set((RotationMatrixReadOnly)interpolatedRotation, (Tuple3DReadOnly)interpolatedVector);
            actual.interpolate(t0, tf, alpha);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.set((RigidBodyTransformReadOnly)t0);
            actual.interpolate(tf, alpha);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Test
    public void testTransformWithTuple() throws Exception {
        int i;
        Random random = new Random(432L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        DMatrixRMaj matrix = new DMatrixRMaj(4, 4);
        transform.get((DMatrix)matrix);
        DMatrixRMaj ejmlPoint = new DMatrixRMaj(4, 1);
        DMatrixRMaj ejmlTransformedPoint = new DMatrixRMaj(4, 1);
        Point3D point = EuclidCoreRandomTools.nextPoint3D((Random)random);
        point.get((DMatrix)ejmlPoint);
        ejmlPoint.set(3, 0, 1.0);
        transform.transform((Point3DBasics)point);
        CommonOps_DDRM.mult((DMatrix1Row)matrix, (DMatrix1Row)ejmlPoint, (DMatrix1Row)ejmlTransformedPoint);
        for (int i2 = 0; i2 < 3; ++i2) {
            Assertions.assertEquals((double)ejmlTransformedPoint.get(i2, 0), (double)point.getElement(i2), (double)1.0E-14);
        }
        ejmlPoint = new DMatrixRMaj(4, 1);
        ejmlTransformedPoint = new DMatrixRMaj(4, 1);
        point = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Point3D pointTransformed = new Point3D();
        point.get((DMatrix)ejmlPoint);
        ejmlPoint.set(3, 0, 1.0);
        transform.transform((Point3DReadOnly)point, (Point3DBasics)pointTransformed);
        CommonOps_DDRM.mult((DMatrix1Row)matrix, (DMatrix1Row)ejmlPoint, (DMatrix1Row)ejmlTransformedPoint);
        for (i = 0; i < 3; ++i) {
            Assertions.assertEquals((double)ejmlTransformedPoint.get(i, 0), (double)pointTransformed.getElement(i), (double)1.0E-14);
        }
        DMatrixRMaj ejmlVector = new DMatrixRMaj(4, 1);
        DMatrixRMaj ejmlTransformedVector = new DMatrixRMaj(4, 1);
        Vector3D vector = EuclidCoreRandomTools.nextVector3D((Random)random);
        vector.get((DMatrix)ejmlVector);
        transform.transform((Vector3DBasics)vector);
        CommonOps_DDRM.mult((DMatrix1Row)matrix, (DMatrix1Row)ejmlVector, (DMatrix1Row)ejmlTransformedVector);
        for (int i3 = 0; i3 < 3; ++i3) {
            Assertions.assertEquals((double)ejmlTransformedVector.get(i3, 0), (double)vector.getElement(i3), (double)1.0E-14);
        }
        ejmlVector = new DMatrixRMaj(4, 1);
        ejmlTransformedVector = new DMatrixRMaj(4, 1);
        vector = EuclidCoreRandomTools.nextVector3D((Random)random);
        Vector3D vectorTransformed = new Vector3D();
        vector.get((DMatrix)ejmlVector);
        transform.transform((Vector3DReadOnly)vector, (Vector3DBasics)vectorTransformed);
        CommonOps_DDRM.mult((DMatrix1Row)matrix, (DMatrix1Row)ejmlVector, (DMatrix1Row)ejmlTransformedVector);
        for (i = 0; i < 3; ++i) {
            Assertions.assertEquals((double)ejmlTransformedVector.get(i, 0), (double)vectorTransformed.getElement(i), (double)1.0E-14);
        }
    }

    @Test
    public void testTransformWithQuaternion() throws Exception {
        Random random = new Random(34534L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Quaternion quaternionOriginal = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Quaternion quaternionExpected = new Quaternion();
        Quaternion quaternionActual = new Quaternion();
        quaternionExpected.set((Orientation3DReadOnly)transform.getRotation());
        quaternionExpected.multiply((QuaternionReadOnly)quaternionOriginal);
        transform.transform((Orientation3DReadOnly)quaternionOriginal, (Orientation3DBasics)quaternionActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternionExpected, (EuclidGeometry)quaternionActual, (double)1.0E-14);
        quaternionActual.set((QuaternionReadOnly)quaternionOriginal);
        transform.transform((Orientation3DBasics)quaternionActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternionExpected, (EuclidGeometry)quaternionActual, (double)1.0E-14);
    }

    @Test
    public void testTransformWithVector4D() throws Exception {
        Random random = new Random(5634L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Vector4D vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
        Vector4D vectorExpected = new Vector4D();
        Vector4D vectorActual = new Vector4D();
        Vector3D vector3D = new Vector3D(vectorOriginal.getX(), vectorOriginal.getY(), vectorOriginal.getZ());
        transform.transform((Vector3DBasics)vector3D);
        vectorExpected.set((Vector3DReadOnly)vector3D);
        vectorExpected.setS(vectorOriginal.getS());
        vectorExpected.addX(vectorExpected.getS() * transform.getM03());
        vectorExpected.addY(vectorExpected.getS() * transform.getM13());
        vectorExpected.addZ(vectorExpected.getS() * transform.getM23());
        transform.transform((Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)1.0E-14);
        vectorActual.set((Tuple4DReadOnly)vectorOriginal);
        transform.transform((Vector4DBasics)vectorActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)1.0E-14);
        DMatrixRMaj transformDenseMatrix = new DMatrixRMaj(4, 4);
        transform.get((DMatrix)transformDenseMatrix);
        DMatrixRMaj vectorOriginalDenseMatrix = new DMatrixRMaj(4, 1);
        vectorOriginal.get((DMatrix)vectorOriginalDenseMatrix);
        DMatrixRMaj vectorTransformedDenseMatrix = new DMatrixRMaj(4, 1);
        CommonOps_DDRM.mult((DMatrix1Row)transformDenseMatrix, (DMatrix1Row)vectorOriginalDenseMatrix, (DMatrix1Row)vectorTransformedDenseMatrix);
        vectorExpected.set((DMatrix)vectorTransformedDenseMatrix);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)1.0E-14);
    }

    @Test
    public void testTransformWithTuple2D() throws Exception {
        Random random = new Random(4353L);
        RigidBodyTransform transfom2D = new RigidBodyTransform();
        transfom2D.getRotation().setToYawOrientation(Math.PI * 2 * random.nextDouble() - Math.PI);
        transfom2D.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        Point2D pointOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
        Point2D pointExpected = new Point2D();
        Point2D pointActual = new Point2D();
        Point3D point = new Point3D(pointOriginal.getX(), pointOriginal.getY(), 0.0);
        transfom2D.transform((Point3DBasics)point);
        pointExpected.set(point.getX(), point.getY());
        pointActual.set((Tuple2DReadOnly)pointOriginal);
        transfom2D.transform((Point2DBasics)pointActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)pointExpected, (EuclidGeometry)pointActual, (double)1.0E-14);
        pointOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
        pointExpected = new Point2D();
        pointActual = new Point2D();
        point = new Point3D(pointOriginal.getX(), pointOriginal.getY(), 0.0);
        transfom2D.transform((Point3DBasics)point);
        pointExpected.set(point.getX(), point.getY());
        pointActual.set((Tuple2DReadOnly)pointOriginal);
        transfom2D.transform((Point2DBasics)pointActual, true);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)pointExpected, (EuclidGeometry)pointActual, (double)1.0E-14);
        pointOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
        pointExpected = new Point2D();
        pointActual = new Point2D();
        point = new Point3D(pointOriginal.getX(), pointOriginal.getY(), 0.0);
        transfom2D.transform((Point3DBasics)point);
        pointExpected.set(point.getX(), point.getY());
        transfom2D.transform((Point2DReadOnly)pointOriginal, (Point2DBasics)pointActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)pointExpected, (EuclidGeometry)pointActual, (double)1.0E-14);
        pointOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
        pointExpected = new Point2D();
        pointActual = new Point2D();
        point = new Point3D(pointOriginal.getX(), pointOriginal.getY(), 0.0);
        transfom2D.transform((Point3DBasics)point);
        pointExpected.set(point.getX(), point.getY());
        transfom2D.transform((Point2DReadOnly)pointOriginal, (Point2DBasics)pointActual, true);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)pointExpected, (EuclidGeometry)pointActual, (double)1.0E-14);
        Vector2D vectorOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
        Vector2D vectorExpected = new Vector2D();
        Vector2D vectorActual = new Vector2D();
        Vector3D vector = new Vector3D(vectorOriginal.getX(), vectorOriginal.getY(), 0.0);
        transfom2D.transform((Vector3DBasics)vector);
        vectorExpected.set(vector.getX(), vector.getY());
        vectorActual.set((Tuple2DReadOnly)vectorOriginal);
        transfom2D.transform((Vector2DBasics)vectorActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)1.0E-14);
        vectorOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
        vectorExpected = new Vector2D();
        vectorActual = new Vector2D();
        vector = new Vector3D(vectorOriginal.getX(), vectorOriginal.getY(), 0.0);
        transfom2D.transform((Vector3DBasics)vector);
        vectorExpected.set(vector.getX(), vector.getY());
        transfom2D.transform((Vector2DReadOnly)vectorOriginal, (Vector2DBasics)vectorActual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)vectorExpected, (EuclidGeometry)vectorActual, (double)1.0E-14);
    }

    @Test
    public void testTransformWithMatrix3D() throws Exception {
        Random random = new Random(4534L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Matrix3D matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        Matrix3D matrixExpected = new Matrix3D();
        Matrix3D matrixActual = new Matrix3D();
        Matrix3D m = new Matrix3D();
        m.set((RotationMatrixReadOnly)transform.getRotation());
        matrixExpected.set((Matrix3DReadOnly)matrixOriginal);
        matrixExpected.preMultiply((Matrix3DReadOnly)m);
        matrixExpected.multiplyTransposeOther((Matrix3DReadOnly)m);
        transform.transform((Matrix3DReadOnly)matrixOriginal, (Matrix3DBasics)matrixActual);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-14);
        matrixActual.set((Matrix3DReadOnly)matrixOriginal);
        transform.transform((Matrix3DBasics)matrixActual);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-14);
    }

    @Test
    public void testTransformWithRotationMatrix() throws Exception {
        Random random = new Random(2342L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RotationMatrix matrixOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        RotationMatrix matrixExpected = new RotationMatrix();
        RotationMatrix matrixActual = new RotationMatrix();
        matrixExpected.set((RotationMatrixReadOnly)transform.getRotation());
        matrixExpected.multiply((RotationMatrixReadOnly)matrixOriginal);
        matrixActual.set((RotationMatrixReadOnly)matrixOriginal);
        transform.transform((RotationMatrixBasics)matrixActual);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-14);
    }

    @Test
    public void testTransformWithOtherRigidBodyTransform() throws Exception {
        Random random = new Random(23423L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform expected = new RigidBodyTransform();
        RigidBodyTransform actual = new RigidBodyTransform();
        expected.set((RigidBodyTransformReadOnly)transform);
        expected.multiply((RigidBodyTransformReadOnly)original);
        transform.transform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        actual.set((RigidBodyTransformReadOnly)original);
        transform.transform((RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        RigidBodyTransform inverse = new RigidBodyTransform((RigidBodyTransformReadOnly)transform);
        inverse.invert();
        inverse.transform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)expected);
        transform.inverseTransform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        actual.set((RigidBodyTransformReadOnly)original);
        transform.inverseTransform((RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
    }

    @Test
    public void testTransformWithQuaternionBasedTransform() throws Exception {
        Random random = new Random(23423L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform originalRigidBodyTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform expectedRigidBodyTransform = new RigidBodyTransform();
        QuaternionBasedTransform original = new QuaternionBasedTransform((RigidBodyTransformReadOnly)originalRigidBodyTransform);
        QuaternionBasedTransform expected = new QuaternionBasedTransform();
        QuaternionBasedTransform actual = new QuaternionBasedTransform();
        transform.transform((RigidBodyTransformReadOnly)originalRigidBodyTransform, (RigidBodyTransformBasics)expectedRigidBodyTransform);
        expected.set((RigidBodyTransformReadOnly)expectedRigidBodyTransform);
        transform.transform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        actual.set((RigidBodyTransformReadOnly)original);
        transform.transform((RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        RigidBodyTransform inverse = new RigidBodyTransform((RigidBodyTransformReadOnly)transform);
        inverse.invert();
        inverse.transform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)expected);
        transform.inverseTransform((RigidBodyTransformReadOnly)original, (RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        actual.set((RigidBodyTransformReadOnly)original);
        transform.inverseTransform((RigidBodyTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
    }

    @Test
    public void testTransformWithAffineTransform() throws Exception {
        Random random = new Random(23423L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform originalRigidBodyTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform expectedRigidBodyTransform = new RigidBodyTransform();
        Vector3D scale = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
        AffineTransform original = new AffineTransform((RigidBodyTransformReadOnly)originalRigidBodyTransform);
        original.appendScale((Tuple3DReadOnly)scale);
        AffineTransform expected = new AffineTransform();
        AffineTransform actual = new AffineTransform();
        transform.transform((RigidBodyTransformReadOnly)originalRigidBodyTransform, (RigidBodyTransformBasics)expectedRigidBodyTransform);
        expected.set((RigidBodyTransformReadOnly)expectedRigidBodyTransform);
        expected.appendScale((Tuple3DReadOnly)scale);
        transform.transform((AffineTransformReadOnly)original, (AffineTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        actual.set((AffineTransformReadOnly)original);
        transform.transform((AffineTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        RigidBodyTransform inverse = new RigidBodyTransform((RigidBodyTransformReadOnly)transform);
        inverse.invert();
        inverse.transform((AffineTransformReadOnly)original, (AffineTransformBasics)expected);
        transform.inverseTransform((AffineTransformReadOnly)original, (AffineTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        actual.set((AffineTransformReadOnly)original);
        transform.inverseTransform((AffineTransformBasics)actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
    }

    @Test
    public void testGetElement() throws Exception {
        Random random = new Random(5464L);
        RigidBodyTransform transform = new RigidBodyTransform();
        double coeff = random.nextDouble();
        transform.setUnsafe(coeff, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((transform.getM00() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(0, 0) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        transform.setUnsafe(0.0, coeff, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((transform.getM01() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(0, 1) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        transform.setUnsafe(0.0, 0.0, coeff, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((transform.getM02() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(0, 2) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        transform.setUnsafe(0.0, 0.0, 0.0, coeff, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((transform.getM03() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(0, 3) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, coeff, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((transform.getM10() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(1, 0) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, coeff, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((transform.getM11() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(1, 1) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, coeff, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((transform.getM12() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(1, 2) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, coeff, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((transform.getM13() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(1, 3) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, coeff, 0.0, 0.0, 0.0);
        Assertions.assertTrue((transform.getM20() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(2, 0) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, coeff, 0.0, 0.0);
        Assertions.assertTrue((transform.getM21() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(2, 1) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, coeff, 0.0);
        Assertions.assertTrue((transform.getM22() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(2, 2) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, coeff);
        Assertions.assertTrue((transform.getM23() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((transform.getElement(2, 3) == coeff ? 1 : 0) != 0);
        try {
            transform.getElement(0, 4);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            transform.getElement(1, 4);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            transform.getElement(2, 4);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            transform.getElement(3, 4);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            transform.getElement(4, 0);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(2354L);
        RigidBodyTransform t1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform t2 = new RigidBodyTransform();
        Assertions.assertFalse((boolean)t1.equals((EuclidGeometry)t2));
        Assertions.assertFalse((boolean)t1.equals(null));
        Assertions.assertFalse((boolean)t1.equals((Object)new double[4]));
        t2.set((RigidBodyTransformReadOnly)t1);
        Assertions.assertTrue((boolean)t1.equals((EuclidGeometry)t2));
        RigidBodyTransform t2AsObject = t2;
        Assertions.assertTrue((boolean)t1.equals((Object)t2AsObject));
        double smallestEpsilon = 1.0E-16;
        double[] coeffs = new double[16];
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 4; ++column) {
                t2.set((RigidBodyTransformReadOnly)t1);
                Assertions.assertTrue((boolean)t1.equals((EuclidGeometry)t2));
                t1.get(coeffs);
                int n = 3 * row + column;
                coeffs[n] = coeffs[n] + smallestEpsilon;
                t2.set(coeffs);
                Assertions.assertFalse((boolean)t1.equals((EuclidGeometry)t2));
                t2.set((RigidBodyTransformReadOnly)t1);
                Assertions.assertTrue((boolean)t1.equals((EuclidGeometry)t2));
                t1.get(coeffs);
                int n2 = 3 * row + column;
                coeffs[n2] = coeffs[n2] - smallestEpsilon;
                t2.set(coeffs);
                Assertions.assertFalse((boolean)t1.equals((EuclidGeometry)t2));
            }
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(2354L);
        RigidBodyTransform t1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform t2 = new RigidBodyTransform();
        double epsilon = 0.001;
        double[] coeffs = new double[16];
        Assertions.assertFalse((boolean)t1.epsilonEquals((EuclidGeometry)t2, epsilon));
        t2.set((RigidBodyTransformReadOnly)t1);
        Assertions.assertTrue((boolean)t1.epsilonEquals((EuclidGeometry)t2, epsilon));
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 4; ++column) {
                t2.set((RigidBodyTransformReadOnly)t1);
                Assertions.assertTrue((boolean)t1.epsilonEquals((EuclidGeometry)t2, epsilon));
                t1.get(coeffs);
                int n = 3 * row + column;
                coeffs[n] = coeffs[n] + 0.999 * epsilon;
                t2.setUnsafe(coeffs[0], coeffs[1], coeffs[2], coeffs[3], coeffs[4], coeffs[5], coeffs[6], coeffs[7], coeffs[8], coeffs[9], coeffs[10], coeffs[11]);
                Assertions.assertTrue((boolean)t1.epsilonEquals((EuclidGeometry)t2, epsilon));
                t2.set((RigidBodyTransformReadOnly)t1);
                Assertions.assertTrue((boolean)t1.epsilonEquals((EuclidGeometry)t2, epsilon));
                t1.get(coeffs);
                int n2 = 3 * row + column;
                coeffs[n2] = coeffs[n2] + 1.001 * epsilon;
                t2.setUnsafe(coeffs[0], coeffs[1], coeffs[2], coeffs[3], coeffs[4], coeffs[5], coeffs[6], coeffs[7], coeffs[8], coeffs[9], coeffs[10], coeffs[11]);
                Assertions.assertFalse((boolean)t1.epsilonEquals((EuclidGeometry)t2, epsilon));
                t2.set((RigidBodyTransformReadOnly)t1);
                Assertions.assertTrue((boolean)t1.epsilonEquals((EuclidGeometry)t2, epsilon));
                t1.get(coeffs);
                int n3 = 3 * row + column;
                coeffs[n3] = coeffs[n3] - 0.999 * epsilon;
                t2.setUnsafe(coeffs[0], coeffs[1], coeffs[2], coeffs[3], coeffs[4], coeffs[5], coeffs[6], coeffs[7], coeffs[8], coeffs[9], coeffs[10], coeffs[11]);
                Assertions.assertTrue((boolean)t1.epsilonEquals((EuclidGeometry)t2, epsilon));
                t2.set((RigidBodyTransformReadOnly)t1);
                Assertions.assertTrue((boolean)t1.epsilonEquals((EuclidGeometry)t2, epsilon));
                t1.get(coeffs);
                int n4 = 3 * row + column;
                coeffs[n4] = coeffs[n4] - 1.001 * epsilon;
                t2.setUnsafe(coeffs[0], coeffs[1], coeffs[2], coeffs[3], coeffs[4], coeffs[5], coeffs[6], coeffs[7], coeffs[8], coeffs[9], coeffs[10], coeffs[11]);
                Assertions.assertFalse((boolean)t1.epsilonEquals((EuclidGeometry)t2, epsilon));
            }
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        RigidBodyTransform rigbodB;
        RotationMatrix rotmat;
        AxisAngle aa;
        double angleDiff;
        RigidBodyTransform rigbodA;
        double epsilon;
        int i;
        Random random = new Random(19825L);
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            rigbodA = this.createRandomTransform(random);
            angleDiff = 0.99 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            rotmat = new RotationMatrix((Orientation3DReadOnly)aa);
            rotmat.preMultiply((RotationMatrixReadOnly)rigbodA.getRotation());
            rigbodB = new RigidBodyTransform((Orientation3DReadOnly)rotmat, (Tuple3DReadOnly)rigbodA.getTranslation());
            Assertions.assertTrue((boolean)rigbodA.geometricallyEquals((EuclidGeometry)rigbodB, epsilon));
            Assertions.assertTrue((boolean)rigbodB.geometricallyEquals((EuclidGeometry)rigbodA, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            rigbodA = this.createRandomTransform(random);
            angleDiff = 1.01 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff);
            rotmat = new RotationMatrix((Orientation3DReadOnly)aa);
            rotmat.preMultiply((RotationMatrixReadOnly)rigbodA.getRotation());
            rigbodB = new RigidBodyTransform((Orientation3DReadOnly)rotmat, (Tuple3DReadOnly)rigbodA.getTranslation());
            Assertions.assertFalse((boolean)rigbodA.geometricallyEquals((EuclidGeometry)rigbodB, epsilon));
            Assertions.assertFalse((boolean)rigbodB.geometricallyEquals((EuclidGeometry)rigbodA, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            rigbodA = this.createRandomTransform(random);
            Vector3D translation = new Vector3D((Tuple3DReadOnly)rigbodA.getTranslation());
            Vector3D perturb = new Vector3D((Tuple3DReadOnly)translation);
            perturb.setX(translation.getX() + 0.9 * epsilon);
            rigbodB = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix((RotationMatrixReadOnly)rigbodA.getRotation()), (Tuple3DReadOnly)perturb);
            Assertions.assertTrue((boolean)rigbodA.geometricallyEquals((EuclidGeometry)rigbodB, epsilon));
            Assertions.assertTrue((boolean)rigbodB.geometricallyEquals((EuclidGeometry)rigbodA, epsilon));
            perturb.setX(translation.getX() + 1.1 * epsilon);
            rigbodB = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix((RotationMatrixReadOnly)rigbodA.getRotation()), (Tuple3DReadOnly)perturb);
            Assertions.assertFalse((boolean)rigbodA.geometricallyEquals((EuclidGeometry)rigbodB, epsilon));
            Assertions.assertFalse((boolean)rigbodB.geometricallyEquals((EuclidGeometry)rigbodA, epsilon));
            perturb = new Vector3D((Tuple3DReadOnly)translation);
            perturb.setY(translation.getY() + 0.9 * epsilon);
            rigbodB = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix((RotationMatrixReadOnly)rigbodA.getRotation()), (Tuple3DReadOnly)perturb);
            Assertions.assertTrue((boolean)rigbodA.geometricallyEquals((EuclidGeometry)rigbodB, epsilon));
            Assertions.assertTrue((boolean)rigbodB.geometricallyEquals((EuclidGeometry)rigbodA, epsilon));
            perturb.setY(translation.getY() + 1.1 * epsilon);
            rigbodB = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix((RotationMatrixReadOnly)rigbodA.getRotation()), (Tuple3DReadOnly)perturb);
            Assertions.assertFalse((boolean)rigbodA.geometricallyEquals((EuclidGeometry)rigbodB, epsilon));
            Assertions.assertFalse((boolean)rigbodB.geometricallyEquals((EuclidGeometry)rigbodA, epsilon));
            perturb = new Vector3D((Tuple3DReadOnly)translation);
            perturb.setZ(translation.getZ() + 0.9 * epsilon);
            rigbodB = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix((RotationMatrixReadOnly)rigbodA.getRotation()), (Tuple3DReadOnly)perturb);
            Assertions.assertTrue((boolean)rigbodA.geometricallyEquals((EuclidGeometry)rigbodB, epsilon));
            Assertions.assertTrue((boolean)rigbodB.geometricallyEquals((EuclidGeometry)rigbodA, epsilon));
            perturb.setZ(translation.getZ() + 1.1 * epsilon);
            rigbodB = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix((RotationMatrixReadOnly)rigbodA.getRotation()), (Tuple3DReadOnly)perturb);
            Assertions.assertFalse((boolean)rigbodA.geometricallyEquals((EuclidGeometry)rigbodB, epsilon));
            Assertions.assertFalse((boolean)rigbodB.geometricallyEquals((EuclidGeometry)rigbodA, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            rigbodA = this.createRandomTransform(random);
            double angleDiff2 = 1.01 * epsilon;
            aa = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleDiff2);
            rotmat = new RotationMatrix((Orientation3DReadOnly)aa);
            rotmat.preMultiply((RotationMatrixReadOnly)rigbodA.getRotation());
            rigbodB = new RigidBodyTransform((Orientation3DReadOnly)rotmat, (Tuple3DReadOnly)rigbodA.getTranslation());
            Assertions.assertFalse((boolean)rigbodA.geometricallyEquals((EuclidGeometry)rigbodB, epsilon));
            Assertions.assertFalse((boolean)rigbodB.geometricallyEquals((EuclidGeometry)rigbodA, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(12345L);
        RigidBodyTransform rbt = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        int newHashCode = rbt.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)rbt.hashCode());
        int previousHashCode = rbt.hashCode();
        for (int i = 0; i < 1000; ++i) {
            RotationMatrix rotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Vector3D translation = EuclidCoreRandomTools.nextVector3D((Random)random);
            rbt = new RigidBodyTransform((Orientation3DReadOnly)rotation, (Tuple3DReadOnly)translation);
            newHashCode = rbt.hashCode();
            Assertions.assertNotEquals((int)previousHashCode, (int)newHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testResetRotation() throws Exception {
        super.testResetRotation();
        Random random = new Random(42353L);
        RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform transform = new RigidBodyTransform((RigidBodyTransformReadOnly)original);
        Assertions.assertTrue((boolean)transform.hasRotation());
        transform.setRotationToZero();
        Assertions.assertFalse((boolean)transform.hasRotation());
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                if (column == 3) {
                    Assertions.assertTrue((transform.getElement(row, column) == original.getElement(row, column) ? 1 : 0) != 0);
                    continue;
                }
                if (row == column) {
                    Assertions.assertTrue((transform.getElement(row, column) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertTrue((transform.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
    }

    @Override
    @Test
    public void testResetTranslation() throws Exception {
        super.testResetTranslation();
        Random random = new Random(42353L);
        RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform transform = new RigidBodyTransform((RigidBodyTransformReadOnly)original);
        Assertions.assertTrue((boolean)transform.hasTranslation());
        transform.setTranslationToZero();
        Assertions.assertFalse((boolean)transform.hasTranslation());
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 4; ++column) {
                if (column < 3) {
                    Assertions.assertTrue((transform.getElement(row, column) == original.getElement(row, column) ? 1 : 0) != 0);
                    continue;
                }
                if (row == column) {
                    Assertions.assertTrue((transform.getElement(row, column) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertTrue((transform.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
    }

    @Override
    @Test
    public void testNormalizeRotationPart() throws Exception {
        int column;
        int row;
        int j;
        super.testNormalizeRotationPart();
        Random random = new Random(42353L);
        RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        RigidBodyTransform transform = new RigidBodyTransform((RigidBodyTransformReadOnly)original);
        double corruptionFactor = 0.1;
        double m00 = original.getM00() + corruptionFactor * random.nextDouble();
        double m01 = original.getM01() + corruptionFactor * random.nextDouble();
        double m02 = original.getM02() + corruptionFactor * random.nextDouble();
        double m10 = original.getM10() + corruptionFactor * random.nextDouble();
        double m11 = original.getM11() + corruptionFactor * random.nextDouble();
        double m12 = original.getM12() + corruptionFactor * random.nextDouble();
        double m20 = original.getM20() + corruptionFactor * random.nextDouble();
        double m21 = original.getM21() + corruptionFactor * random.nextDouble();
        double m22 = original.getM22() + corruptionFactor * random.nextDouble();
        transform.getRotation().setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        transform.normalizeRotationPart();
        Matrix3D rotation = new Matrix3D();
        Vector3D vector1 = new Vector3D();
        Vector3D vector2 = new Vector3D();
        rotation.set((RotationMatrixReadOnly)transform.getRotation());
        for (j = 0; j < 3; ++j) {
            rotation.getRow(j, (Tuple3DBasics)vector1);
            Assertions.assertEquals((double)1.0, (double)vector1.norm(), (double)1.0E-14);
            rotation.getColumn(j, (Tuple3DBasics)vector1);
            Assertions.assertEquals((double)1.0, (double)vector1.norm(), (double)1.0E-14);
        }
        for (j = 0; j < 3; ++j) {
            rotation.getRow(j, (Tuple3DBasics)vector1);
            rotation.getRow((j + 1) % 3, (Tuple3DBasics)vector2);
            Assertions.assertEquals((double)0.0, (double)vector1.dot((Tuple3DReadOnly)vector2), (double)1.0E-14);
            rotation.getColumn(j, (Tuple3DBasics)vector1);
            rotation.getColumn((j + 1) % 3, (Tuple3DBasics)vector2);
            Assertions.assertEquals((double)0.0, (double)vector1.dot((Tuple3DReadOnly)vector2), (double)1.0E-14);
        }
        corruptionFactor = 9.0E-13;
        m00 = 1.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m01 = 0.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m02 = 0.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m10 = 0.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m11 = 1.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m12 = 0.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m20 = 0.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m21 = 0.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        m22 = 1.0 + EuclidCoreRandomTools.nextDouble((Random)random, (double)corruptionFactor);
        transform.getRotation().setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        Assertions.assertFalse((boolean)transform.hasRotation());
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                if (row == column) {
                    Assertions.assertEquals((double)1.0, (double)transform.getElement(row, column), (double)corruptionFactor);
                    Assertions.assertFalse((1.0 == transform.getElement(row, column) ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertEquals((double)0.0, (double)transform.getElement(row, column), (double)corruptionFactor);
                Assertions.assertFalse((0.0 == transform.getElement(row, column) ? 1 : 0) != 0);
            }
        }
        transform.normalizeRotationPart();
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                if (row == column) {
                    Assertions.assertTrue((1.0 == transform.getElement(row, column) ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertTrue((0.0 == transform.getElement(row, column) ? 1 : 0) != 0);
            }
        }
    }

    @Override
    @Test
    public void testSetToZero() throws Exception {
        int column;
        int row;
        super.testSetToZero();
        Random random = new Random(2342L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Assertions.assertTrue((boolean)transform.hasRotation());
        Assertions.assertTrue((boolean)transform.hasTranslation());
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 4; ++column) {
                if (row == column) {
                    Assertions.assertFalse((transform.getElement(row, column) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertFalse((transform.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
        transform.setToZero();
        Assertions.assertFalse((boolean)transform.hasRotation());
        Assertions.assertFalse((boolean)transform.hasTranslation());
        for (row = 0; row < 4; ++row) {
            for (column = 0; column < 4; ++column) {
                if (row == column) {
                    Assertions.assertTrue((transform.getElement(row, column) == 1.0 ? 1 : 0) != 0);
                    continue;
                }
                Assertions.assertTrue((transform.getElement(row, column) == 0.0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testToString() throws Exception {
        RigidBodyTransform rbtB;
        RigidBodyTransform rbtA;
        int i;
        Random random = new Random(12345L);
        for (i = 0; i < 1000; ++i) {
            rbtA = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            rbtB = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Assertions.assertNotEquals((Object)rbtA.toString(), (Object)rbtB.toString());
        }
        for (i = 0; i < 1000; ++i) {
            rbtA = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            rbtB = new RigidBodyTransform((RigidBodyTransformReadOnly)rbtA);
            Assertions.assertEquals((Object)rbtA.toString(), (Object)rbtB.toString());
        }
    }

    @Override
    @Test
    public void testSetToNaN() throws Exception {
        int column;
        int row;
        super.testSetToNaN();
        Random random = new Random(2342L);
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Assertions.assertTrue((boolean)transform.hasRotation());
        Assertions.assertTrue((boolean)transform.hasTranslation());
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 4; ++column) {
                Assertions.assertFalse((boolean)Double.isNaN(transform.getElement(row, column)));
            }
        }
        transform.setToNaN();
        Assertions.assertTrue((boolean)transform.hasRotation());
        Assertions.assertTrue((boolean)transform.hasTranslation());
        for (row = 0; row < 3; ++row) {
            for (column = 0; column < 4; ++column) {
                Assertions.assertTrue((boolean)Double.isNaN(transform.getElement(row, column)));
            }
        }
        transform.setToZero();
        Assertions.assertFalse((boolean)transform.hasRotation());
        Assertions.assertFalse((boolean)transform.hasTranslation());
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)transform.getRotation(), (double)1.0E-14);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)transform.getTranslation());
        transform.setRotationToNaN();
        Assertions.assertTrue((boolean)transform.hasRotation());
        Assertions.assertFalse((boolean)transform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)transform.getRotation());
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)transform.getTranslation());
        transform.setToZero();
        Assertions.assertFalse((boolean)transform.hasRotation());
        Assertions.assertFalse((boolean)transform.hasTranslation());
        transform.setTranslationToNaN();
        Assertions.assertFalse((boolean)transform.hasRotation());
        Assertions.assertTrue((boolean)transform.hasTranslation());
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)transform.getRotation(), (double)1.0E-14);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)transform.getTranslation());
    }

    @Override
    @Test
    public void testContainsNaN() throws Exception {
        super.testContainsNaN();
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertFalse((boolean)transform.containsNaN());
        transform.setUnsafe(Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0);
        Assertions.assertTrue((boolean)transform.containsNaN());
        transform.setUnsafe(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN);
        Assertions.assertTrue((boolean)transform.containsNaN());
    }

    @Override
    @Test
    public void testAppendOrientation() throws Exception {
        super.testAppendOrientation();
        Random random = new Random(46575L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            RigidBodyTransform orientationTransform = new RigidBodyTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)new Vector3D());
            RigidBodyTransform expected = new RigidBodyTransform();
            expected.set((RigidBodyTransformReadOnly)original);
            expected.multiply((RigidBodyTransformReadOnly)orientationTransform);
            RigidBodyTransform actual = new RigidBodyTransform();
            actual.set((RigidBodyTransformReadOnly)original);
            actual.appendOrientation((Orientation3DReadOnly)orientation);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testAppendYawPitchRoll() throws Exception {
        RotationMatrix expectedRotation;
        RigidBodyTransform original;
        int i;
        super.testAppendYawPitchRoll();
        Random random = new Random(35454L);
        RigidBodyTransform expected = new RigidBodyTransform();
        RigidBodyTransform actual = new RigidBodyTransform();
        for (i = 0; i < 1000; ++i) {
            RotationMatrix expectedRotation2 = new RotationMatrix();
            RigidBodyTransform original2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            expectedRotation2.set((RotationMatrixReadOnly)original2.getRotation());
            expectedRotation2.appendYawRotation(yaw);
            expected.set((RotationMatrixReadOnly)expectedRotation2, (Tuple3DReadOnly)original2.getTranslation());
            Assertions.assertTrue((boolean)expected.hasRotation());
            actual.set((RigidBodyTransformReadOnly)original2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendYawRotation(yaw);
            Assertions.assertTrue((boolean)actual.hasRotation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            original2.setToZero();
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actual.set((RigidBodyTransformReadOnly)original2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            actual.appendYawRotation(yaw);
            Assertions.assertTrue((boolean)actual.hasRotation());
            original2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            yaw = 0.0;
            actual.set((RigidBodyTransformReadOnly)original2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendYawRotation(yaw);
            Assertions.assertTrue((boolean)actual.hasRotation());
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            original2.getRotation().setToYawOrientation(-yaw);
            actual.set((RigidBodyTransformReadOnly)original2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendYawRotation(yaw);
            Assertions.assertFalse((boolean)actual.hasRotation());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expectedRotation = new RotationMatrix((RotationMatrixReadOnly)original.getRotation());
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            expectedRotation.appendPitchRotation(pitch);
            expected.set((RotationMatrixReadOnly)expectedRotation, (Tuple3DReadOnly)original.getTranslation());
            Assertions.assertTrue((boolean)expected.hasRotation());
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendPitchRotation(pitch);
            Assertions.assertTrue((boolean)actual.hasRotation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            original.setToZero();
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertFalse((boolean)actual.hasRotation());
            actual.appendPitchRotation(pitch);
            Assertions.assertTrue((boolean)actual.hasRotation());
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            pitch = 0.0;
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendPitchRotation(pitch);
            Assertions.assertTrue((boolean)actual.hasRotation());
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            original.getRotation().setToPitchOrientation(-pitch);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendPitchRotation(pitch);
            Assertions.assertFalse((boolean)actual.hasRotation());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expectedRotation = new RotationMatrix((RotationMatrixReadOnly)original.getRotation());
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            expectedRotation.appendRollRotation(roll);
            expected.set((RotationMatrixReadOnly)expectedRotation, (Tuple3DReadOnly)original.getTranslation());
            Assertions.assertTrue((boolean)expected.hasRotation());
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendRollRotation(roll);
            Assertions.assertTrue((boolean)actual.hasRotation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            original.setToZero();
            roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertFalse((boolean)actual.hasRotation());
            actual.appendRollRotation(roll);
            Assertions.assertTrue((boolean)actual.hasRotation());
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            roll = 0.0;
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendRollRotation(roll);
            Assertions.assertTrue((boolean)actual.hasRotation());
            roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            original.getRotation().setToRollOrientation(-roll);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.appendRollRotation(roll);
            Assertions.assertFalse((boolean)actual.hasRotation());
        }
    }

    @Override
    @Test
    public void testPrependTranslation() throws Exception {
        RigidBodyTransform translationTransform;
        RigidBodyTransform original;
        int i;
        super.testPrependTranslation();
        Random random = new Random(35454L);
        RigidBodyTransform expected = new RigidBodyTransform();
        RigidBodyTransform actual = new RigidBodyTransform();
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            translationTransform = new RigidBodyTransform();
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double z = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)10.0);
            translationTransform.getTranslation().set(x, y, z);
            expected.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)expected.hasTranslation());
            expected.preMultiply((RigidBodyTransformReadOnly)translationTransform);
            Assertions.assertTrue((boolean)expected.hasTranslation());
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.prependTranslation(x, y, z);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            original.setToZero();
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.prependTranslation(x, y, z);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.prependTranslation(0.0, 0.0, 0.0);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)original.getTranslation());
            negateTranslation.negate();
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.prependTranslation(negateTranslation.getX(), negateTranslation.getY(), negateTranslation.getZ());
            Assertions.assertFalse((boolean)actual.hasTranslation());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            translationTransform = new RigidBodyTransform();
            Point3D translation = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0, (double)10.0, (double)10.0);
            translationTransform.getTranslation().set((Tuple3DReadOnly)translation);
            expected.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)expected.hasTranslation());
            expected.preMultiply((RigidBodyTransformReadOnly)translationTransform);
            Assertions.assertTrue((boolean)expected.hasTranslation());
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.prependTranslation((Tuple3DReadOnly)translation);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            original.setToZero();
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.prependTranslation((Tuple3DReadOnly)translation);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.prependTranslation(0.0, 0.0, 0.0);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)original.getTranslation());
            negateTranslation.negate();
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.prependTranslation((Tuple3DReadOnly)negateTranslation);
            Assertions.assertFalse((boolean)actual.hasTranslation());
        }
    }

    @Override
    @Test
    public void testPrependOrientation() throws Exception {
        super.testPrependOrientation();
        Random random = new Random(3456L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Orientation3DBasics orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            RigidBodyTransform orientationTransform = new RigidBodyTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)new Vector3D());
            RigidBodyTransform expected = new RigidBodyTransform();
            expected.set((RigidBodyTransformReadOnly)original);
            expected.preMultiply((RigidBodyTransformReadOnly)orientationTransform);
            RigidBodyTransform actual = new RigidBodyTransform();
            actual.set((RigidBodyTransformReadOnly)original);
            actual.prependOrientation((Orientation3DReadOnly)orientation);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testPrependYawPitchRoll() throws Exception {
        RigidBodyTransform original;
        int i;
        super.testPrependYawPitchRoll();
        Random random = new Random(35454L);
        RigidBodyTransform expected = new RigidBodyTransform();
        RigidBodyTransform actual = new RigidBodyTransform();
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform yawTransform = new RigidBodyTransform();
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            yawTransform.getRotation().setToYawOrientation(yaw);
            expected.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)expected.hasRotation());
            expected.preMultiply((RigidBodyTransformReadOnly)yawTransform);
            Assertions.assertTrue((boolean)expected.hasRotation());
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependYawRotation(yaw);
            Assertions.assertTrue((boolean)actual.hasRotation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            original.setToZero();
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertFalse((boolean)actual.hasRotation());
            actual.prependYawRotation(yaw);
            Assertions.assertTrue((boolean)actual.hasRotation());
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            yaw = 0.0;
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependYawRotation(yaw);
            Assertions.assertTrue((boolean)actual.hasRotation());
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            original.getRotation().setToYawOrientation(-yaw);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependYawRotation(yaw);
            Assertions.assertFalse((boolean)actual.hasRotation());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform pitchTransform = new RigidBodyTransform();
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            pitchTransform.getRotation().setToPitchOrientation(pitch);
            expected.set((RigidBodyTransformReadOnly)original);
            expected.preMultiply((RigidBodyTransformReadOnly)pitchTransform);
            Assertions.assertTrue((boolean)expected.hasRotation());
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependPitchRotation(pitch);
            Assertions.assertTrue((boolean)actual.hasRotation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            original.setToZero();
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertFalse((boolean)actual.hasRotation());
            actual.prependPitchRotation(pitch);
            Assertions.assertTrue((boolean)actual.hasRotation());
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            pitch = 0.0;
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependPitchRotation(pitch);
            Assertions.assertTrue((boolean)actual.hasRotation());
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            original.getRotation().setToPitchOrientation(-pitch);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependPitchRotation(pitch);
            Assertions.assertFalse((boolean)actual.hasRotation());
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform rollTransform = new RigidBodyTransform();
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            rollTransform.getRotation().setToRollOrientation(roll);
            expected.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)expected.hasRotation());
            expected.preMultiply((RigidBodyTransformReadOnly)rollTransform);
            Assertions.assertTrue((boolean)expected.hasRotation());
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependRollRotation(roll);
            Assertions.assertTrue((boolean)actual.hasRotation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            original.setToZero();
            roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertFalse((boolean)actual.hasRotation());
            actual.prependRollRotation(roll);
            Assertions.assertTrue((boolean)actual.hasRotation());
            original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            roll = 0.0;
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependRollRotation(roll);
            Assertions.assertTrue((boolean)actual.hasRotation());
            roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            original.getRotation().setToRollOrientation(-roll);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            actual.prependRollRotation(roll);
            Assertions.assertFalse((boolean)actual.hasRotation());
        }
    }

    @Override
    @Test
    public void testSetRotationAndZeroTranslation() throws Exception {
        super.testSetRotationAndZeroTranslation();
        Random random = new Random(2342L);
        RotationMatrix expectedRotation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        RigidBodyTransform actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        AxisAngle axisAngle = new AxisAngle((Orientation3DReadOnly)expectedRotation);
        actualTransform.setRotationAndZeroTranslation((Orientation3DReadOnly)axisAngle);
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.setRotationAndZeroTranslation((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), 0.0));
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        expectedRotation.get((DMatrix)denseMatrix);
        actualTransform.setRotationAndZeroTranslation((DMatrix)denseMatrix);
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.setRotationAndZeroTranslation((DMatrix)CommonOps_DDRM.identity((int)3));
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        Quaternion quaternion = new Quaternion((Orientation3DReadOnly)expectedRotation);
        actualTransform.setRotationAndZeroTranslation((Orientation3DReadOnly)quaternion);
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)1.0E-14);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.setRotationAndZeroTranslation((Orientation3DReadOnly)new Quaternion());
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        actualTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actualTransform.setRotationAndZeroTranslation((RotationMatrixReadOnly)expectedRotation);
        Assertions.assertTrue((boolean)actualTransform.hasRotation());
        Assertions.assertFalse((boolean)actualTransform.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform.getTranslation());
        actualTransform.setRotationAndZeroTranslation((RotationMatrixReadOnly)new RotationMatrix());
        Assertions.assertFalse((boolean)actualTransform.hasRotation());
        Vector3D rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
        RigidBodyTransform actualTransform2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actualTransform2.setRotationAndZeroTranslation((Vector3DReadOnly)rotationVector);
        expectedRotation.setRotationVector((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((boolean)actualTransform2.hasRotation());
        Assertions.assertFalse((boolean)actualTransform2.hasTranslation());
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedRotation, (Matrix3DReadOnly)actualTransform2.getRotation(), (double)0.0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualTransform2.getTranslation());
        actualTransform2.getRotation().setRotationVector((Vector3DReadOnly)new Vector3D());
        Assertions.assertFalse((boolean)actualTransform2.hasRotation());
    }

    @Override
    @Test
    public void testMultiplyWithQuaternionBasedTransform() throws Exception {
        super.testMultiplyWithQuaternionBasedTransform();
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWithRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            QuaternionBasedTransform multipliedWith = new QuaternionBasedTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            expected.set((RigidBodyTransformReadOnly)original);
            expected.multiply((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiply((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            multipliedWith.set((RigidBodyTransformReadOnly)actual);
            multipliedWith.invert();
            actual.multiply((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testMultiplyWithAffineTransform() throws Exception {
        super.testMultiplyWithAffineTransform();
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWithRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            AffineTransform multipliedWith = new AffineTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            multipliedWith.appendScale((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set((RigidBodyTransformReadOnly)original);
            expected.multiply((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiply((AffineTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            multipliedWithRigidBody.set((RigidBodyTransformReadOnly)actual);
            multipliedWithRigidBody.invert();
            actual.multiply((AffineTransformReadOnly)new AffineTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testMultiplyInvertThis() throws Exception {
        int i;
        super.testMultiplyInvertThis();
        Random random = new Random(465416L);
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.set((RigidBodyTransformReadOnly)original);
            expected.invert();
            expected.multiply((RigidBodyTransformReadOnly)multipliedWith);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)new RigidBodyTransform((RigidBodyTransformReadOnly)actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform expected = new RigidBodyTransform();
            RigidBodyTransform actual = new RigidBodyTransform();
            RigidBodyTransform t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            RigidBodyTransform t2 = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.setAndInvert((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.setAndInvert((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            expected.setAndInvert((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.setAndInvert((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.setAndInvert((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            expected.setAndInvert((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)t1.getRotation(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.setAndInvert((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)t1.getTranslation());
            expected.setAndInvert((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testMultiplyInvertOther() throws Exception {
        int i;
        super.testMultiplyInvertOther();
        Random random = new Random(465416L);
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform inverseOfMultipliedWith = new RigidBodyTransform((RigidBodyTransformReadOnly)multipliedWith);
            inverseOfMultipliedWith.invert();
            expected.set((RigidBodyTransformReadOnly)original);
            expected.multiply((RigidBodyTransformReadOnly)inverseOfMultipliedWith);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)new RigidBodyTransform((RigidBodyTransformReadOnly)actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform expected = new RigidBodyTransform();
            RigidBodyTransform actual = new RigidBodyTransform();
            RigidBodyTransform t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            RigidBodyTransform t2 = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            RigidBodyTransform t2Inverse = new RigidBodyTransform();
            t2Inverse.setAndInvert((RigidBodyTransformReadOnly)t2);
            expected.set((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2Inverse);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2Inverse.setAndInvert((RigidBodyTransformReadOnly)t2);
            expected.set((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2Inverse);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2Inverse.setAndInvert((RigidBodyTransformReadOnly)t2);
            expected.set((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2Inverse);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2Inverse.setAndInvert((RigidBodyTransformReadOnly)t2);
            expected.set((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2Inverse);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2Inverse.setAndInvert((RigidBodyTransformReadOnly)t2);
            expected.set((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2Inverse);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2Inverse.setAndInvert((RigidBodyTransformReadOnly)t2);
            expected.set((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2Inverse);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)t1.getRotation(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2Inverse.setAndInvert((RigidBodyTransformReadOnly)t2);
            expected.set((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2Inverse);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)t1.getTranslation());
            t1.inverseTransform((Vector3DBasics)negateTranslation);
            t2.transform((Vector3DBasics)negateTranslation);
            t2.getTranslation().set((Tuple3DReadOnly)negateTranslation);
            t2Inverse.setAndInvert((RigidBodyTransformReadOnly)t2);
            expected.set((RigidBodyTransformReadOnly)t1);
            expected.multiply((RigidBodyTransformReadOnly)t2Inverse);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testMultiplyInvertThisWithQuaternionBasedTransform() throws Exception {
        super.testMultiplyInvertThisWithQuaternionBasedTransform();
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWithRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            QuaternionBasedTransform multipliedWith = new QuaternionBasedTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            expected.set((RigidBodyTransformReadOnly)original);
            expected.invert();
            expected.multiply((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.multiplyInvertThis((RigidBodyTransformReadOnly)new QuaternionBasedTransform((RigidBodyTransformReadOnly)actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testMultiplyInvertOtherWithQuaternionBasedTransform() throws Exception {
        super.testMultiplyInvertOtherWithQuaternionBasedTransform();
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWithRigidBody = this.createRandomTransform(random);
            RigidBodyTransform inverseOfMultipliedWithRigidBody = new RigidBodyTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            inverseOfMultipliedWithRigidBody.invert();
            QuaternionBasedTransform multipliedWith = new QuaternionBasedTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            expected.set((RigidBodyTransformReadOnly)original);
            expected.multiply((RigidBodyTransformReadOnly)inverseOfMultipliedWithRigidBody);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.multiplyInvertOther((RigidBodyTransformReadOnly)new QuaternionBasedTransform((RigidBodyTransformReadOnly)actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testMultiplyInvertThisWithAffineTransform() throws Exception {
        super.testMultiplyInvertThisWithAffineTransform();
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWithRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            AffineTransform multipliedWith = new AffineTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            multipliedWith.appendScale((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set((RigidBodyTransformReadOnly)original);
            expected.invert();
            expected.multiply((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertThis((AffineTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.multiplyInvertThis((AffineTransformReadOnly)new AffineTransform((RigidBodyTransformReadOnly)actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testMultiplyInvertOtherWithAffineTransform() throws Exception {
        super.testMultiplyInvertOtherWithAffineTransform();
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWithRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform inverseOfMultipliedWithRigidBody = new RigidBodyTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            inverseOfMultipliedWithRigidBody.invert();
            AffineTransform multipliedWith = new AffineTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            multipliedWith.appendScale((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set((RigidBodyTransformReadOnly)original);
            expected.multiply((RigidBodyTransformReadOnly)inverseOfMultipliedWithRigidBody);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.multiplyInvertOther((AffineTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.multiplyInvertOther((AffineTransformReadOnly)new AffineTransform((RigidBodyTransformReadOnly)actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testPreMultiply() throws Exception {
        int i;
        super.testPreMultiply();
        Random random = new Random(465416L);
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform inverse = new RigidBodyTransform((RigidBodyTransformReadOnly)transform);
            inverse.invert();
            Assertions.assertTrue((boolean)transform.hasRotation());
            Assertions.assertTrue((boolean)transform.hasTranslation());
            transform.preMultiply((RigidBodyTransformReadOnly)inverse);
            Assertions.assertFalse((boolean)transform.hasRotation());
            Assertions.assertFalse((boolean)transform.hasTranslation());
            for (int row = 0; row < 4; ++row) {
                for (int column = 0; column < 4; ++column) {
                    if (row == column) {
                        Assertions.assertEquals((double)transform.getElement(row, column), (double)1.0, (double)1.0E-14);
                        continue;
                    }
                    Assertions.assertEquals((double)transform.getElement(row, column), (double)0.0, (double)1.0E-14);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform t1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform t2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform t3 = new RigidBodyTransform((RigidBodyTransformReadOnly)t2);
            t3.preMultiply((RigidBodyTransformReadOnly)t1);
            DMatrixRMaj m1 = new DMatrixRMaj(4, 4);
            DMatrixRMaj m2 = new DMatrixRMaj(4, 4);
            DMatrixRMaj m3 = new DMatrixRMaj(4, 4);
            t1.get((DMatrix)m1);
            t2.get((DMatrix)m2);
            CommonOps_DDRM.mult((DMatrix1Row)m1, (DMatrix1Row)m2, (DMatrix1Row)m3);
            for (int row = 0; row < 4; ++row) {
                for (int column = 0; column < 4; ++column) {
                    Assertions.assertEquals((double)m3.get(row, column), (double)t3.getElement(row, column), (double)1.0E-14);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform expected = new RigidBodyTransform();
            RigidBodyTransform actual = new RigidBodyTransform();
            RigidBodyTransform t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            RigidBodyTransform t2 = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiply((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiply((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiply((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiply((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.preMultiply((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiply((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply((RigidBodyTransformReadOnly)t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiply((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.preMultiply((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t1.getRotation().set((RotationMatrixReadOnly)t2.getRotation());
            t1.invertRotation();
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiply((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply((RigidBodyTransformReadOnly)t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)t2.getTranslation());
            negateTranslation.negate();
            t2.inverseTransform((Vector3DBasics)negateTranslation);
            t1.getTranslation().set((Tuple3DReadOnly)negateTranslation);
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiply((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testPreMultiplyWithQuaternionBasedTransform() throws Exception {
        super.testPreMultiplyWithQuaternionBasedTransform();
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWithRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            QuaternionBasedTransform multipliedWith = new QuaternionBasedTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            expected.set((RigidBodyTransformReadOnly)original);
            expected.preMultiply((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            multipliedWith.set((RigidBodyTransformReadOnly)actual);
            multipliedWith.invert();
            actual.preMultiply((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testPreMultiplyWithAffineTransform() throws Exception {
        super.testPreMultiplyWithAffineTransform();
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWithRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            AffineTransform multipliedWith = new AffineTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            multipliedWith.appendScale((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set((RigidBodyTransformReadOnly)original);
            expected.preMultiply((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiply((AffineTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            multipliedWithRigidBody.set((RigidBodyTransformReadOnly)actual);
            multipliedWithRigidBody.invert();
            actual.preMultiply((AffineTransformReadOnly)new AffineTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testPreMultiplyInvertThis() throws Exception {
        int i;
        super.testPreMultiplyInvertThis();
        Random random = new Random(465416L);
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.set((RigidBodyTransformReadOnly)original);
            expected.invert();
            expected.preMultiply((RigidBodyTransformReadOnly)multipliedWith);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)new RigidBodyTransform((RigidBodyTransformReadOnly)actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform expected = new RigidBodyTransform();
            RigidBodyTransform actual = new RigidBodyTransform();
            RigidBodyTransform t1 = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            RigidBodyTransform t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertOther((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertOther((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertOther((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertOther((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertOther((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertOther((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t1.getRotation().set((RotationMatrixReadOnly)t2.getRotation());
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertOther((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            Vector3D negateTranslation = new Vector3D((Tuple3DReadOnly)t2.getTranslation());
            t2.inverseTransform((Vector3DBasics)negateTranslation);
            t1.transform((Vector3DBasics)negateTranslation);
            t1.getTranslation().set((Tuple3DReadOnly)negateTranslation);
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertOther((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testPreMultiplyInvertOther() throws Exception {
        int i;
        super.testPreMultiplyInvertOther();
        Random random = new Random(465416L);
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWith = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform inverseOfMultipliedWith = new RigidBodyTransform((RigidBodyTransformReadOnly)multipliedWith);
            inverseOfMultipliedWith.invert();
            expected.set((RigidBodyTransformReadOnly)original);
            expected.preMultiply((RigidBodyTransformReadOnly)inverseOfMultipliedWith);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)new RigidBodyTransform((RigidBodyTransformReadOnly)actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform expected = new RigidBodyTransform();
            RigidBodyTransform actual = new RigidBodyTransform();
            RigidBodyTransform t1 = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            RigidBodyTransform t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertThis((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertThis((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertThis((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertThis((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix(), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertThis((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)new Vector3D());
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertThis((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t1.getRotation().set((RotationMatrixReadOnly)t2.getRotation());
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertThis((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            t1 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t2 = new RigidBodyTransform((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random), (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            t1.getTranslation().set((Tuple3DReadOnly)t2.getTranslation());
            expected.set((RigidBodyTransformReadOnly)t2);
            expected.multiplyInvertThis((RigidBodyTransformReadOnly)t1);
            actual.set((RigidBodyTransformReadOnly)t1);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)t2);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testPreMultiplyInvertThisWithQuaternionBasedTransform() throws Exception {
        super.testPreMultiplyInvertThisWithQuaternionBasedTransform();
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWithRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            QuaternionBasedTransform multipliedWith = new QuaternionBasedTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            expected.set((RigidBodyTransformReadOnly)original);
            expected.invert();
            expected.preMultiply((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            actual.set((RigidBodyTransformReadOnly)original);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)multipliedWith);
            Assertions.assertTrue((boolean)actual.hasRotation());
            Assertions.assertTrue((boolean)actual.hasTranslation());
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.preMultiplyInvertThis((RigidBodyTransformReadOnly)new QuaternionBasedTransform((RigidBodyTransformReadOnly)actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testPreMultiplyInvertOtherWithQuaternionBasedTransform() throws Exception {
        super.testPreMultiplyInvertOtherWithQuaternionBasedTransform();
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWithRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform inverseOfMultipliedWithRigidBody = new RigidBodyTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            inverseOfMultipliedWithRigidBody.invert();
            QuaternionBasedTransform multipliedWith = new QuaternionBasedTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            expected.set((RigidBodyTransformReadOnly)original);
            expected.preMultiply((RigidBodyTransformReadOnly)inverseOfMultipliedWithRigidBody);
            actual.set((RigidBodyTransformReadOnly)original);
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.preMultiplyInvertOther((RigidBodyTransformReadOnly)new QuaternionBasedTransform((RigidBodyTransformReadOnly)actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testPreMultiplyInvertThisWithAffineTransform() throws Exception {
        super.testPreMultiplyInvertThisWithAffineTransform();
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWithRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            AffineTransform multipliedWith = new AffineTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            multipliedWith.appendScale((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set((RigidBodyTransformReadOnly)original);
            expected.invert();
            expected.preMultiply((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            actual.set((RigidBodyTransformReadOnly)original);
            actual.preMultiplyInvertThis((AffineTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
            actual.preMultiplyInvertThis((AffineTransformReadOnly)new AffineTransform((RigidBodyTransformReadOnly)actual));
            Assertions.assertFalse((boolean)actual.hasRotation());
            Assertions.assertFalse((boolean)actual.hasTranslation());
            expected.setToZero();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    @Test
    public void testPreMultiplyInvertOtherWithAffineTransform() throws Exception {
        super.testPreMultiplyInvertOtherWithAffineTransform();
        Random random = new Random(465416L);
        for (int i = 0; i < 1000; ++i) {
            RigidBodyTransform original = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform multipliedWithRigidBody = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform inverseOfMultipliedWithRigidBody = new RigidBodyTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            inverseOfMultipliedWithRigidBody.invert();
            AffineTransform multipliedWith = new AffineTransform((RigidBodyTransformReadOnly)multipliedWithRigidBody);
            multipliedWith.appendScale((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
            expected.set((RigidBodyTransformReadOnly)original);
            expected.preMultiply((RigidBodyTransformReadOnly)inverseOfMultipliedWithRigidBody);
            actual.set((RigidBodyTransformReadOnly)original);
            actual.preMultiplyInvertOther((AffineTransformReadOnly)multipliedWith);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-14);
        }
    }

    @Override
    public double getEpsilon() {
        return 1.0E-14;
    }

    @Override
    public RigidBodyTransform createRandomTransform(Random random) {
        return EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
    }

    @Override
    @Deprecated
    public RigidBodyTransform createRandomTransform2D(Random random) {
        RigidBodyTransform transfom2D = new RigidBodyTransform();
        transfom2D.getRotation().setToYawOrientation(Math.PI * 2 * random.nextDouble() - Math.PI);
        transfom2D.getTranslation().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        return transfom2D;
    }

    @Override
    public RigidBodyTransform copy(RigidBodyTransform original) {
        return new RigidBodyTransform((RigidBodyTransformReadOnly)original);
    }

    @Override
    public RigidBodyTransform identity() {
        RigidBodyTransform identity = new RigidBodyTransform();
        identity.setIdentity();
        return identity;
    }
}

