/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractFace3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.RampPolytope3DView;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class RampPolytope3DTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testIntegrity() {
        Random random = new Random(897234L);
        for (int i = 0; i < 1000; ++i) {
            Ramp3D ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            RampPolytope3DView rampPolytope = ramp3D.asConvexPolytope();
            EuclidShapeTestTools.assertConvexPolytope3DGeneralIntegrity((String)("Iteration " + i), (ConvexPolytope3DReadOnly)rampPolytope);
            Assertions.assertEquals((int)5, (int)rampPolytope.getNumberOfFaces());
            Assertions.assertEquals((int)9, (int)rampPolytope.getNumberOfEdges());
            Assertions.assertEquals((int)6, (int)rampPolytope.getNumberOfVertices());
        }
    }

    @Test
    public void testAgainstConvexPolytope() {
        Random random = new Random(987345L);
        Ramp3D ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
        RampPolytope3DView rampPolytope3D = ramp3D.asConvexPolytope();
        for (int i = 0; i < 1000; ++i) {
            switch (random.nextInt(3)) {
                case 0: {
                    ramp3D.set((Ramp3DReadOnly)EuclidShapeRandomTools.nextRamp3D((Random)random));
                    break;
                }
                case 1: {
                    ramp3D.getPose().set((RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
                    break;
                }
                case 2: {
                    ramp3D.getSize().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
                }
            }
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D();
            for (int vertexIndex = 0; vertexIndex < 6; ++vertexIndex) {
                Point3D vertex = new Point3D();
                vertex.set((vertexIndex & 2) == 0 ? ramp3D.getSizeX() : 0.0, (vertexIndex & 1) == 0 ? 0.5 * ramp3D.getSizeY() : -0.5 * ramp3D.getSizeY(), (vertexIndex & 4) == 0 ? 0.0 : ramp3D.getSizeZ());
                ramp3D.transformToWorld((Transformable)vertex);
                convexPolytope3D.addVertex((Point3DReadOnly)vertex);
            }
            Assertions.assertEquals((double)convexPolytope3D.getVolume(), (double)rampPolytope3D.getVolume(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)rampPolytope3D.getCentroid(), (EuclidGeometry)convexPolytope3D.getCentroid(), (double)1.0E-12);
            for (Face3DReadOnly rampFace : rampPolytope3D.getFaces()) {
                AbstractFace3D polytopeFace = convexPolytope3D.getClosestFace(rampFace.getCentroid());
                EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)rampFace.getCentroid(), (Point3DReadOnly)rampFace.getCentroid(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)rampFace.getNormal(), (Vector3DReadOnly)rampFace.getNormal(), (double)1.0E-12);
                for (Vertex3DReadOnly rampVertex : rampFace.getVertices()) {
                    Assertions.assertEquals((long)1L, (long)polytopeFace.getVertices().stream().filter(polytopeVertex -> polytopeVertex.epsilonEquals((EuclidGeometry)rampVertex, 1.0E-12)).count());
                }
            }
        }
    }
}

