/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.Arrays;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;

public class Ramp3DTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    void testConstructors() throws Exception {
        Ramp3D ramp3D;
        Pose3D pose;
        RotationMatrix orientation;
        Point3D position;
        double sizeZ;
        double sizeY;
        double sizeX;
        int i;
        Random random = new Random(10869L);
        Ramp3D ramp3D2 = new Ramp3D();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(1.0, 1.0, 1.0), (EuclidGeometry)ramp3D2.getSize(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)ramp3D2.getPosition());
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)ramp3D2.getOrientation(), (double)1.0E-12);
        ramp3D2 = new Ramp3D();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(1.0, 1.0, 1.0), (EuclidGeometry)ramp3D2.getSize(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)ramp3D2.getPosition());
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)ramp3D2.getOrientation(), (double)1.0E-12);
        for (i = 0; i < 1000; ++i) {
            sizeX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            Ramp3D ramp3D3 = new Ramp3D(sizeX, sizeY, sizeZ);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(sizeX, sizeY, sizeZ), (EuclidGeometry)ramp3D3.getSize(), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)ramp3D3.getPosition());
            EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)ramp3D3.getOrientation(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            sizeX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            orientation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Ramp3D ramp3D4 = new Ramp3D((Point3DReadOnly)position, (Orientation3DReadOnly)orientation, sizeX, sizeY, sizeZ);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(sizeX, sizeY, sizeZ), (EuclidGeometry)ramp3D4.getSize(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)position, (EuclidGeometry)ramp3D4.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)orientation, (Matrix3DReadOnly)ramp3D4.getOrientation(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            sizeX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            orientation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            pose = new Pose3D((Tuple3DReadOnly)position, (Orientation3DReadOnly)orientation);
            ramp3D = new Ramp3D((Pose3DReadOnly)pose, sizeX, sizeY, sizeZ);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(sizeX, sizeY, sizeZ), (EuclidGeometry)ramp3D.getSize(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)position, (EuclidGeometry)ramp3D.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)orientation, (Matrix3DReadOnly)ramp3D.getOrientation(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            sizeX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            orientation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            pose = new RigidBodyTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)position);
            ramp3D = new Ramp3D((RigidBodyTransformReadOnly)pose, sizeX, sizeY, sizeZ);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(sizeX, sizeY, sizeZ), (EuclidGeometry)ramp3D.getSize(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)position, (EuclidGeometry)ramp3D.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)orientation, (Matrix3DReadOnly)ramp3D.getOrientation(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            Ramp3D original = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Ramp3D copy = new Ramp3D((Ramp3DReadOnly)original);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)copy, (double)1.0E-12);
        }
    }

    @Test
    void testSetToNaN() throws Exception {
        Random random = new Random(34575754L);
        for (int i = 0; i < 1000; ++i) {
            Ramp3D ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Assertions.assertFalse((boolean)ramp3D.containsNaN());
            Assertions.assertFalse((boolean)ramp3D.getPose().containsNaN());
            Assertions.assertFalse((boolean)ramp3D.getPosition().containsNaN());
            Assertions.assertFalse((boolean)ramp3D.getOrientation().containsNaN());
            Assertions.assertFalse((boolean)ramp3D.getSize().containsNaN());
            ramp3D.setToNaN();
            Assertions.assertTrue((boolean)ramp3D.containsNaN());
            Assertions.assertTrue((boolean)ramp3D.getPose().containsNaN());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)ramp3D.getPosition());
            EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)ramp3D.getOrientation());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)ramp3D.getSize());
        }
    }

    @Test
    void testSetToZero() throws Exception {
        Random random = new Random(34575754L);
        for (int i = 0; i < 1000; ++i) {
            Ramp3D ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((EuclidGeometry)ramp3D.getPosition(), 1.0E-12));
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((EuclidGeometry)ramp3D.getSize(), 1.0E-12));
            Assertions.assertFalse((boolean)new RotationMatrix().epsilonEquals((EuclidGeometry)ramp3D.getOrientation(), 1.0E-12));
            ramp3D.setToZero();
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)ramp3D.getPosition());
            EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)ramp3D.getOrientation(), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)ramp3D.getSize());
        }
    }

    @Test
    void testSetters() throws Exception {
        Ramp3D actual;
        Ramp3D expected;
        int i;
        Random random = new Random(45837543L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextRamp3D((Random)random);
            actual = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((Ramp3DReadOnly)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextRamp3D((Random)random);
            actual = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((Ramp3DReadOnly)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextRamp3D((Random)random);
            actual = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((Point3DReadOnly)expected.getPosition(), (Orientation3DReadOnly)expected.getOrientation(), expected.getSizeX(), expected.getSizeY(), expected.getSizeZ());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().set((Point3DReadOnly)new Point3D(), (Orientation3DReadOnly)new Quaternion(), -0.1, 1.0, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().set((Point3DReadOnly)new Point3D(), (Orientation3DReadOnly)new Quaternion(), 1.0, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().set((Point3DReadOnly)new Point3D(), (Orientation3DReadOnly)new Quaternion(), 1.0, 1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextRamp3D((Random)random);
            actual = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((Pose3DReadOnly)new Pose3D((Tuple3DReadOnly)expected.getPosition(), (Orientation3DReadOnly)expected.getOrientation()), expected.getSizeX(), expected.getSizeY(), expected.getSizeZ());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().set((Pose3DReadOnly)new Pose3D(), -0.1, 1.0, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().set((Pose3DReadOnly)new Pose3D(), 1.0, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().set((Pose3DReadOnly)new Pose3D(), 1.0, 1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextRamp3D((Random)random);
            actual = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)expected.getOrientation(), (Tuple3DReadOnly)expected.getPosition()), expected.getSizeX(), expected.getSizeY(), expected.getSizeZ());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), -0.1, 1.0, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), 1.0, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), 1.0, 1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextRamp3D((Random)random);
            actual = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)expected.getOrientation(), (Tuple3DReadOnly)expected.getPosition()), new double[]{expected.getSizeX(), expected.getSizeY(), expected.getSizeZ()});
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), new double[]{-0.1, 1.0, 1.0}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), new double[]{1.0, -0.1, 1.0}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), new double[]{1.0, 1.0, -0.1}));
    }

    @Test
    void testSetSize() throws Exception {
        Random random = new Random(0x536566L);
        for (int i = 0; i < 1000; ++i) {
            double sizeX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            double sizeY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            double sizeZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            Ramp3D ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)sizeX, (double)ramp3D.getSizeX(), (double)1.0E-12));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)sizeY, (double)ramp3D.getSizeY(), (double)1.0E-12));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)sizeZ, (double)ramp3D.getSizeZ(), (double)1.0E-12));
            ramp3D.getSize().set(sizeX, sizeY, sizeZ);
            Assertions.assertEquals((double)sizeX, (double)ramp3D.getSizeX(), (double)1.0E-12);
            Assertions.assertEquals((double)sizeY, (double)ramp3D.getSizeY(), (double)1.0E-12);
            Assertions.assertEquals((double)sizeZ, (double)ramp3D.getSizeZ(), (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().getSize().set(-0.1, 1.0, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().getSize().set(1.0, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Ramp3D().getSize().set(1.0, 1.0, -0.1));
    }

    @Test
    void testIsPointInside() throws Exception {
        Point3D pointOutside;
        Ramp3D ramp3D;
        int i;
        Random random = new Random(839161L);
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOutside = new Point3D();
            pointOutside.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeX()));
            pointOutside.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside.setZ(-random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(ramp3D.getSizeX() + random.nextDouble());
            pointOutside.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside.setZ(-random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(-random.nextDouble());
            pointOutside.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside.setZ(-random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeX()));
            pointOutside.setY(0.5 * ramp3D.getSizeY() + random.nextDouble());
            pointOutside.setZ(-random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeX()));
            pointOutside.setY(-0.5 * ramp3D.getSizeY() - random.nextDouble());
            pointOutside.setZ(-random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(ramp3D.getSizeX() + random.nextDouble());
            pointOutside.setY(0.5 * ramp3D.getSizeY() + random.nextDouble());
            pointOutside.setZ(-random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(ramp3D.getSizeX() + random.nextDouble());
            pointOutside.setY(-0.5 * ramp3D.getSizeY() - random.nextDouble());
            pointOutside.setZ(-random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(-random.nextDouble());
            pointOutside.setY(0.5 * ramp3D.getSizeY() + random.nextDouble());
            pointOutside.setZ(-random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(-random.nextDouble());
            pointOutside.setY(-0.5 * ramp3D.getSizeY() - random.nextDouble());
            pointOutside.setZ(-random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOutside = new Point3D();
            pointOutside.setX(ramp3D.getSizeX() + random.nextDouble());
            pointOutside.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside.setZ(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeZ()));
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(ramp3D.getSizeX() + random.nextDouble());
            pointOutside.setY(0.5 * ramp3D.getSizeY() + random.nextDouble());
            pointOutside.setZ(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeZ()));
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(ramp3D.getSizeX() + random.nextDouble());
            pointOutside.setY(-0.5 * ramp3D.getSizeY() - random.nextDouble());
            pointOutside.setZ(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeZ()));
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(ramp3D.getSizeX() + random.nextDouble());
            pointOutside.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside.setZ(ramp3D.getSizeZ() + random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(ramp3D.getSizeX() + random.nextDouble());
            pointOutside.setY(0.5 * ramp3D.getSizeY() + random.nextDouble());
            pointOutside.setZ(ramp3D.getSizeZ() + random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(ramp3D.getSizeX() + random.nextDouble());
            pointOutside.setY(-0.5 * ramp3D.getSizeY() - random.nextDouble());
            pointOutside.setZ(ramp3D.getSizeZ() + random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOutside = new Point3D();
            pointOutside.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeX()));
            pointOutside.setY(0.5 * ramp3D.getSizeY() + random.nextDouble());
            pointOutside.setZ(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeZ()));
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeX()));
            pointOutside.setY(0.5 * ramp3D.getSizeY() + random.nextDouble());
            pointOutside.setZ(ramp3D.getSizeZ() + random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOutside = new Point3D();
            pointOutside.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeX()));
            pointOutside.setY(-0.5 * ramp3D.getSizeY() - random.nextDouble());
            pointOutside.setZ(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeZ()));
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)ramp3D.getSizeX()));
            pointOutside.setY(-0.5 * ramp3D.getSizeY() - random.nextDouble());
            pointOutside.setZ(ramp3D.getSizeZ() + random.nextDouble());
            ramp3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)ramp3D.isPointInside((Point3DReadOnly)pointOutside));
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Point3DReadOnly[])ramp3D.getVertices());
            Assertions.assertTrue((boolean)ramp3D.isPointInside((Point3DReadOnly)pointInside));
        }
    }

    @Test
    void testEvaluatePoint3DCollision() throws Exception {
        Point3D pointOutside;
        double distance;
        Vector3D towardOutside;
        Vector3D slopeFaceNormal;
        Vector3D rightFaceNormal;
        Vector3D leftFaceNormal;
        Point3D pointOutside2;
        Vector3D towardOutside2;
        Vector3DReadOnly rampNormal;
        Point3D pointOutside3;
        double distanceOnRamp;
        Point3D pointOutside4;
        Ramp3D ramp3D;
        int i;
        Random random = new Random(17792681L);
        Point3D actualClosestPoint = new Point3D();
        Vector3D actualNormal = new Vector3D();
        Point3D expectedClosestPoint = new Point3D();
        Vector3D expectedNormal = new Vector3D();
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOutside4 = new Point3D();
            pointOutside4.setX(random.nextDouble() * ramp3D.getSizeX());
            pointOutside4.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside4.setZ(-random.nextDouble());
            expectedClosestPoint.set(pointOutside4.getX(), pointOutside4.getY(), 0.0);
            expectedNormal.setAndNegate((Tuple3DReadOnly)Axis3D.Z);
            ramp3D.transformToWorld((Transformable)pointOutside4);
            ramp3D.transformToWorld((Transformable)expectedClosestPoint);
            ramp3D.transformToWorld((Transformable)expectedNormal);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside4, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOutside4 = new Point3D();
            pointOutside4.setX(ramp3D.getSizeX() + random.nextDouble());
            pointOutside4.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside4.setZ(random.nextDouble() * ramp3D.getSizeZ());
            expectedClosestPoint.set(ramp3D.getSizeX(), pointOutside4.getY(), pointOutside4.getZ());
            expectedNormal.set((Tuple3DReadOnly)Axis3D.X);
            ramp3D.transformToWorld((Transformable)pointOutside4);
            ramp3D.transformToWorld((Transformable)expectedClosestPoint);
            ramp3D.transformToWorld((Transformable)expectedNormal);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside4, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            distanceOnRamp = random.nextDouble() * ramp3D.getRampLength();
            pointOutside3 = new Point3D();
            pointOutside3.setX(distanceOnRamp * EuclidCoreTools.cos((double)angle));
            pointOutside3.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside3.setZ(distanceOnRamp * EuclidCoreTools.sin((double)angle));
            expectedClosestPoint.set((Tuple3DReadOnly)pointOutside3);
            expectedNormal.set((Tuple3DReadOnly)ramp3D.getRampSurfaceNormal());
            ramp3D.transformToWorld((Transformable)pointOutside3);
            pointOutside3.scaleAdd(random.nextDouble(), (Tuple3DReadOnly)ramp3D.getRampSurfaceNormal(), (Tuple3DReadOnly)pointOutside3);
            ramp3D.transformToWorld((Transformable)expectedClosestPoint);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside3, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            distanceOnRamp = random.nextDouble() * ramp3D.getRampLength();
            pointOutside3 = new Point3D();
            pointOutside3.setX(distanceOnRamp * EuclidCoreTools.cos((double)angle));
            pointOutside3.setY(0.5 * ramp3D.getSizeY() + random.nextDouble());
            pointOutside3.setZ(distanceOnRamp * EuclidCoreTools.sin((double)angle) * random.nextDouble());
            expectedClosestPoint.set(pointOutside3.getX(), 0.5 * ramp3D.getSizeY(), pointOutside3.getZ());
            expectedNormal.set((Tuple3DReadOnly)Axis3D.Y);
            ramp3D.transformToWorld((Transformable)pointOutside3);
            ramp3D.transformToWorld((Transformable)expectedClosestPoint);
            ramp3D.transformToWorld((Transformable)expectedNormal);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside3, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            distanceOnRamp = random.nextDouble() * ramp3D.getRampLength();
            pointOutside3 = new Point3D();
            pointOutside3.setX(distanceOnRamp * EuclidCoreTools.cos((double)angle));
            pointOutside3.setY(-0.5 * ramp3D.getSizeY() - random.nextDouble());
            pointOutside3.setZ(distanceOnRamp * EuclidCoreTools.sin((double)angle) * random.nextDouble());
            expectedClosestPoint.set(pointOutside3.getX(), -0.5 * ramp3D.getSizeY(), pointOutside3.getZ());
            expectedNormal.setAndNegate((Tuple3DReadOnly)Axis3D.Y);
            ramp3D.transformToWorld((Transformable)pointOutside3);
            ramp3D.transformToWorld((Transformable)expectedClosestPoint);
            ramp3D.transformToWorld((Transformable)expectedNormal);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside3, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(ramp3D.getSizeX(), EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())), ramp3D.getSizeZ());
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            rampNormal = ramp3D.getRampSurfaceNormal();
            Vector3D backFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)rampNormal, (Tuple3DReadOnly)backFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double distance2 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(distance2, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            expectedClosestPoint.set((Tuple3DReadOnly)pointOnEdge);
            expectedNormal.set((Tuple3DReadOnly)towardOutside2);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside2, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())), 0.0);
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            rampNormal = ramp3D.getRampSurfaceNormal();
            Vector3D bottomFaceNormal = new Vector3D();
            bottomFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)rampNormal, (Tuple3DReadOnly)bottomFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double distance3 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(distance3, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            expectedClosestPoint.set((Tuple3DReadOnly)pointOnEdge);
            expectedNormal.set((Tuple3DReadOnly)towardOutside2);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside2, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(ramp3D.getSizeX(), EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())), 0.0);
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D backFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            Vector3D bottomFaceNormal = new Vector3D();
            bottomFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)backFaceNormal, (Tuple3DReadOnly)bottomFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double distance4 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(distance4, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            expectedClosestPoint.set((Tuple3DReadOnly)pointOnEdge);
            expectedNormal.set((Tuple3DReadOnly)towardOutside2);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside2, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(random.nextDouble() * ramp3D.getSizeX(), 0.5 * ramp3D.getSizeY(), 0.0);
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            leftFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Vector3D bottomFaceNormal = new Vector3D();
            bottomFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)leftFaceNormal, (Tuple3DReadOnly)bottomFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double distance5 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(distance5, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            expectedClosestPoint.set((Tuple3DReadOnly)pointOnEdge);
            expectedNormal.set((Tuple3DReadOnly)towardOutside2);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside2, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(random.nextDouble() * ramp3D.getSizeX(), -0.5 * ramp3D.getSizeY(), 0.0);
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            rightFaceNormal = new Vector3D();
            rightFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Vector3D bottomFaceNormal = new Vector3D();
            bottomFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)rightFaceNormal, (Tuple3DReadOnly)bottomFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double distance6 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(distance6, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            expectedClosestPoint.set((Tuple3DReadOnly)pointOnEdge);
            expectedNormal.set((Tuple3DReadOnly)towardOutside2);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside2, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(ramp3D.getSizeX(), 0.5 * ramp3D.getSizeY(), random.nextDouble() * ramp3D.getSizeZ());
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            leftFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Vector3D backFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)leftFaceNormal, (Tuple3DReadOnly)backFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double distance7 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(distance7, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            expectedClosestPoint.set((Tuple3DReadOnly)pointOnEdge);
            expectedNormal.set((Tuple3DReadOnly)towardOutside2);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside2, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(ramp3D.getSizeX(), -0.5 * ramp3D.getSizeY(), random.nextDouble() * ramp3D.getSizeZ());
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            rightFaceNormal = new Vector3D();
            rightFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Vector3D backFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)rightFaceNormal, (Tuple3DReadOnly)backFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double distance8 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(distance8, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            expectedClosestPoint.set((Tuple3DReadOnly)pointOnEdge);
            expectedNormal.set((Tuple3DReadOnly)towardOutside2);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside2, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            double distanceOnRamp2 = random.nextDouble() * ramp3D.getRampLength();
            Point3D pointOnEdge = new Point3D(distanceOnRamp2 * EuclidCoreTools.cos((double)angle), 0.5 * ramp3D.getSizeY(), distanceOnRamp2 * EuclidCoreTools.sin((double)angle));
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D leftFaceNormal2 = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            slopeFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getRampSurfaceNormal());
            towardOutside = new Vector3D();
            towardOutside.interpolate((Tuple3DReadOnly)leftFaceNormal2, (Tuple3DReadOnly)slopeFaceNormal, random.nextDouble());
            towardOutside.normalize();
            distance = random.nextDouble();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distance, (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointOnEdge);
            expectedClosestPoint.set((Tuple3DReadOnly)pointOnEdge);
            expectedNormal.set((Tuple3DReadOnly)towardOutside);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            double distanceOnRamp3 = random.nextDouble() * ramp3D.getRampLength();
            Point3D pointOnEdge = new Point3D(distanceOnRamp3 * EuclidCoreTools.cos((double)angle), -0.5 * ramp3D.getSizeY(), distanceOnRamp3 * EuclidCoreTools.sin((double)angle));
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D rightFaceNormal2 = new Vector3D();
            rightFaceNormal2.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            slopeFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getRampSurfaceNormal());
            towardOutside = new Vector3D();
            towardOutside.interpolate((Tuple3DReadOnly)rightFaceNormal2, (Tuple3DReadOnly)slopeFaceNormal, random.nextDouble());
            towardOutside.normalize();
            distance = random.nextDouble();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distance, (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointOnEdge);
            expectedClosestPoint.set((Tuple3DReadOnly)pointOnEdge);
            expectedNormal.set((Tuple3DReadOnly)towardOutside);
            Assertions.assertFalse((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Point3DReadOnly[])ramp3D.getVertices());
            Plane3D backPlane = new Plane3D((Point3DReadOnly)new Point3D(ramp3D.getSizeX(), 0.0, 0.0), (Vector3DReadOnly)Axis3D.X);
            Plane3D bottomPlane = new Plane3D((Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), (Vector3DReadOnly)new Vector3D(0.0, 0.0, -1.0));
            Plane3D leftPlane = new Plane3D((Point3DReadOnly)new Point3D(0.0, 0.5 * ramp3D.getSizeY(), 0.0), (Vector3DReadOnly)Axis3D.Y);
            Plane3D rightPlane = new Plane3D((Point3DReadOnly)new Point3D(0.0, -0.5 * ramp3D.getSizeY(), 0.0), (Vector3DReadOnly)new Vector3D(0.0, -1.0, 0.0));
            Plane3D slopePlane = new Plane3D((Point3DReadOnly)ramp3D.getPosition(), ramp3D.getRampSurfaceNormal());
            ramp3D.transformToWorld((Transformable)backPlane);
            ramp3D.transformToWorld((Transformable)bottomPlane);
            ramp3D.transformToWorld((Transformable)leftPlane);
            ramp3D.transformToWorld((Transformable)rightPlane);
            double distanceToBack = backPlane.distance((Point3DReadOnly)pointInside);
            double distanceToBottom = bottomPlane.distance((Point3DReadOnly)pointInside);
            double distanceToLeft = leftPlane.distance((Point3DReadOnly)pointInside);
            double distanceToRight = rightPlane.distance((Point3DReadOnly)pointInside);
            double distanceToSlope = slopePlane.distance((Point3DReadOnly)pointInside);
            Plane3D closestPlane = EuclidShapeTools.isFirstValueMinimum((double)distanceToBack, (double)distanceToBottom, (double)distanceToLeft, (double)distanceToRight, (double)distanceToSlope) ? backPlane : (EuclidShapeTools.isFirstValueMinimum((double)distanceToBottom, (double)distanceToLeft, (double)distanceToRight, (double)distanceToSlope) ? bottomPlane : (EuclidShapeTools.isFirstValueMinimum((double)distanceToLeft, (double)distanceToRight, (double)distanceToSlope) ? leftPlane : (distanceToRight <= distanceToSlope ? rightPlane : slopePlane)));
            expectedClosestPoint.set((Tuple3DReadOnly)closestPlane.orthogonalProjectionCopy((Point3DReadOnly)pointInside));
            expectedNormal.set((Tuple3DReadOnly)closestPlane.getNormal());
            Assertions.assertTrue((boolean)ramp3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
    }

    @Test
    void testGetVertices() throws Exception {
        Ramp3D ramp3D;
        int i;
        Random random = new Random(335436L);
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            ramp3D.getPose().setToZero();
            double sizeX = ramp3D.getSizeX();
            double sizeY = 0.5 * ramp3D.getSizeY();
            double sizeZ = ramp3D.getSizeZ();
            Point3DBasics[] vertices = ramp3D.getVertices();
            Assertions.assertEquals((int)6, (int)vertices.length);
            int vertexIndex = 0;
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(sizeX, sizeY, 0.0), (EuclidGeometry)vertices[vertexIndex++], (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(sizeX, -sizeY, 0.0), (EuclidGeometry)vertices[vertexIndex++], (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, sizeY, 0.0), (EuclidGeometry)vertices[vertexIndex++], (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, -sizeY, 0.0), (EuclidGeometry)vertices[vertexIndex++], (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(sizeX, sizeY, sizeZ), (EuclidGeometry)vertices[vertexIndex++], (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(sizeX, -sizeY, sizeZ), (EuclidGeometry)vertices[vertexIndex++], (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3DBasics[] expectedVertices = ramp3D.getVertices();
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            ramp3D.applyTransform((Transform)transform);
            Arrays.asList(expectedVertices).forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
            Point3DBasics[] actualVertices = ramp3D.getVertices();
            for (int j = 0; j < 6; ++j) {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVertices[j], (EuclidGeometry)actualVertices[j], (double)1.0E-12);
            }
        }
    }

    @Test
    void testApplyTransform() {
        RigidBodyTransform transform;
        Ramp3D expected;
        Ramp3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextRamp3D((Random)random);
            expected = new Ramp3D((Ramp3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPose().applyTransform((Transform)transform);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextRamp3D((Random)random);
            expected = new Ramp3D((Ramp3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPose().applyTransform((Transform)transform);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    void testApplyInverseTransform() {
        RigidBodyTransform transform;
        Ramp3D expected;
        Ramp3D original;
        Ramp3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextRamp3D((Random)random);
            original = new Ramp3D((Ramp3DReadOnly)actual);
            expected = new Ramp3D((Ramp3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPose().applyInverseTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextRamp3D((Random)random);
            original = new Ramp3D((Ramp3DReadOnly)actual);
            expected = new Ramp3D((Ramp3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPose().applyInverseTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    void testGetSupportingVertex() throws Exception {
        Random random = new Random(546161L);
        for (int i = 0; i < 1000; ++i) {
            Ramp3D ramp = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Vector3D supportDirection = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3DReadOnly supportingVertex = ramp.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Point3D supportingVertexTranslated = new Point3D();
            supportDirection.normalize();
            Assertions.assertTrue((boolean)ramp.isPointInside(supportingVertex, 1.0E-12));
            supportingVertexTranslated.scaleAdd(1.0E-6, (Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)supportingVertex);
            Assertions.assertFalse((boolean)ramp.isPointInside((Point3DReadOnly)supportingVertexTranslated, 1.0E-12));
            supportingVertexTranslated.scaleAdd(0.01, (Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)supportingVertex);
            Vector3D expectedNormal = new Vector3D();
            expectedNormal.sub((Tuple3DReadOnly)supportingVertexTranslated, (Tuple3DReadOnly)supportingVertex);
            expectedNormal.normalize();
            Vector3D actualNormal = new Vector3D();
            ramp.evaluatePoint3DCollision((Point3DReadOnly)supportingVertexTranslated, (Point3DBasics)new Point3D(), (Vector3DBasics)actualNormal);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
    }

    @Test
    void testDistance() throws Exception {
        Point3D pointOutside;
        double expectedDistance;
        Vector3D towardOutside;
        Vector3D slopeFaceNormal;
        Point3D pointOutside2;
        Vector3D towardOutside2;
        double expectedDistance2;
        Point3D pointOutside3;
        double distanceOnRamp;
        double expectedDistance3;
        Point3D pointOutside4;
        Ramp3D ramp3D;
        int i;
        Random random = new Random(11426096L);
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOutside4 = new Point3D();
            pointOutside4.setX(random.nextDouble() * ramp3D.getSizeX());
            pointOutside4.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside4.setZ(-random.nextDouble());
            expectedDistance3 = -pointOutside4.getZ();
            ramp3D.transformToWorld((Transformable)pointOutside4);
            Assertions.assertEquals((double)expectedDistance3, (double)ramp3D.distance((Point3DReadOnly)pointOutside4), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOutside4 = new Point3D();
            pointOutside4.setX(ramp3D.getSizeX() + random.nextDouble());
            pointOutside4.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside4.setZ(random.nextDouble() * ramp3D.getSizeZ());
            expectedDistance3 = pointOutside4.getX() - ramp3D.getSizeX();
            ramp3D.transformToWorld((Transformable)pointOutside4);
            Assertions.assertEquals((double)expectedDistance3, (double)ramp3D.distance((Point3DReadOnly)pointOutside4), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            distanceOnRamp = random.nextDouble() * ramp3D.getRampLength();
            pointOutside3 = new Point3D();
            pointOutside3.setX(distanceOnRamp * EuclidCoreTools.cos((double)angle));
            pointOutside3.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside3.setZ(distanceOnRamp * EuclidCoreTools.sin((double)angle));
            ramp3D.transformToWorld((Transformable)pointOutside3);
            expectedDistance2 = random.nextDouble();
            pointOutside3.scaleAdd(expectedDistance2, (Tuple3DReadOnly)ramp3D.getRampSurfaceNormal(), (Tuple3DReadOnly)pointOutside3);
            Assertions.assertEquals((double)expectedDistance2, (double)ramp3D.distance((Point3DReadOnly)pointOutside3), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            distanceOnRamp = random.nextDouble() * ramp3D.getRampLength();
            pointOutside3 = new Point3D();
            pointOutside3.setX(distanceOnRamp * EuclidCoreTools.cos((double)angle));
            pointOutside3.setY(0.5 * ramp3D.getSizeY() + random.nextDouble());
            pointOutside3.setZ(distanceOnRamp * EuclidCoreTools.sin((double)angle) * random.nextDouble());
            expectedDistance2 = pointOutside3.getY() - 0.5 * ramp3D.getSizeY();
            ramp3D.transformToWorld((Transformable)pointOutside3);
            Assertions.assertEquals((double)expectedDistance2, (double)ramp3D.distance((Point3DReadOnly)pointOutside3), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            distanceOnRamp = random.nextDouble() * ramp3D.getRampLength();
            pointOutside3 = new Point3D();
            pointOutside3.setX(distanceOnRamp * EuclidCoreTools.cos((double)angle));
            pointOutside3.setY(-0.5 * ramp3D.getSizeY() - random.nextDouble());
            pointOutside3.setZ(distanceOnRamp * EuclidCoreTools.sin((double)angle) * random.nextDouble());
            expectedDistance2 = -pointOutside3.getY() - 0.5 * ramp3D.getSizeY();
            ramp3D.transformToWorld((Transformable)pointOutside3);
            Assertions.assertEquals((double)expectedDistance2, (double)ramp3D.distance((Point3DReadOnly)pointOutside3), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(ramp3D.getSizeX(), EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())), ramp3D.getSizeZ());
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3DReadOnly rampNormal = ramp3D.getRampSurfaceNormal();
            Vector3D backFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)rampNormal, (Tuple3DReadOnly)backFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance4 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance4, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance4, (double)ramp3D.distance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())), 0.0);
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3DReadOnly rampNormal = ramp3D.getRampSurfaceNormal();
            Vector3D bottomFaceNormal = new Vector3D();
            bottomFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)rampNormal, (Tuple3DReadOnly)bottomFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance5 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance5, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance5, (double)ramp3D.distance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(ramp3D.getSizeX(), EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())), 0.0);
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D backFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            Vector3D bottomFaceNormal = new Vector3D();
            bottomFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)backFaceNormal, (Tuple3DReadOnly)bottomFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance6 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance6, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance6, (double)ramp3D.distance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(random.nextDouble() * ramp3D.getSizeX(), 0.5 * ramp3D.getSizeY(), 0.0);
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D leftFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Vector3D bottomFaceNormal = new Vector3D();
            bottomFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)leftFaceNormal, (Tuple3DReadOnly)bottomFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance7 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance7, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance7, (double)ramp3D.distance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(random.nextDouble() * ramp3D.getSizeX(), -0.5 * ramp3D.getSizeY(), 0.0);
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D rightFaceNormal = new Vector3D();
            rightFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Vector3D bottomFaceNormal = new Vector3D();
            bottomFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)rightFaceNormal, (Tuple3DReadOnly)bottomFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance8 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance8, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance8, (double)ramp3D.distance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(ramp3D.getSizeX(), 0.5 * ramp3D.getSizeY(), random.nextDouble() * ramp3D.getSizeZ());
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D leftFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Vector3D backFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)leftFaceNormal, (Tuple3DReadOnly)backFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance9 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance9, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance9, (double)ramp3D.distance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(ramp3D.getSizeX(), -0.5 * ramp3D.getSizeY(), random.nextDouble() * ramp3D.getSizeZ());
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D rightFaceNormal = new Vector3D();
            rightFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Vector3D backFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)rightFaceNormal, (Tuple3DReadOnly)backFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance10 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance10, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance10, (double)ramp3D.distance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            double distanceOnRamp2 = random.nextDouble() * ramp3D.getRampLength();
            Point3D pointOnEdge = new Point3D(distanceOnRamp2 * EuclidCoreTools.cos((double)angle), 0.5 * ramp3D.getSizeY(), distanceOnRamp2 * EuclidCoreTools.sin((double)angle));
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D leftFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            slopeFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getRampSurfaceNormal());
            towardOutside = new Vector3D();
            towardOutside.interpolate((Tuple3DReadOnly)leftFaceNormal, (Tuple3DReadOnly)slopeFaceNormal, random.nextDouble());
            towardOutside.normalize();
            expectedDistance = random.nextDouble();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(expectedDistance, (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance, (double)ramp3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            double distanceOnRamp3 = random.nextDouble() * ramp3D.getRampLength();
            Point3D pointOnEdge = new Point3D(distanceOnRamp3 * EuclidCoreTools.cos((double)angle), -0.5 * ramp3D.getSizeY(), distanceOnRamp3 * EuclidCoreTools.sin((double)angle));
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D rightFaceNormal = new Vector3D();
            rightFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            slopeFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getRampSurfaceNormal());
            towardOutside = new Vector3D();
            towardOutside.interpolate((Tuple3DReadOnly)rightFaceNormal, (Tuple3DReadOnly)slopeFaceNormal, random.nextDouble());
            towardOutside.normalize();
            expectedDistance = random.nextDouble();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(expectedDistance, (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance, (double)ramp3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Point3DReadOnly[])ramp3D.getVertices());
            Assertions.assertEquals((double)0.0, (double)ramp3D.distance((Point3DReadOnly)pointInside));
        }
    }

    @Test
    void testSignedDistance() throws Exception {
        Point3D pointOutside;
        double expectedDistance;
        Vector3D towardOutside;
        Vector3D slopeFaceNormal;
        Point3D pointOutside2;
        Vector3D towardOutside2;
        double expectedDistance2;
        Point3D pointOutside3;
        double distanceOnRamp;
        double expectedDistance3;
        Point3D pointOutside4;
        Ramp3D ramp3D;
        int i;
        Random random = new Random(13199357L);
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOutside4 = new Point3D();
            pointOutside4.setX(random.nextDouble() * ramp3D.getSizeX());
            pointOutside4.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside4.setZ(-random.nextDouble());
            expectedDistance3 = -pointOutside4.getZ();
            ramp3D.transformToWorld((Transformable)pointOutside4);
            Assertions.assertEquals((double)expectedDistance3, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside4), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            pointOutside4 = new Point3D();
            pointOutside4.setX(ramp3D.getSizeX() + random.nextDouble());
            pointOutside4.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside4.setZ(random.nextDouble() * ramp3D.getSizeZ());
            expectedDistance3 = pointOutside4.getX() - ramp3D.getSizeX();
            ramp3D.transformToWorld((Transformable)pointOutside4);
            Assertions.assertEquals((double)expectedDistance3, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside4), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            distanceOnRamp = random.nextDouble() * ramp3D.getRampLength();
            pointOutside3 = new Point3D();
            pointOutside3.setX(distanceOnRamp * EuclidCoreTools.cos((double)angle));
            pointOutside3.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())));
            pointOutside3.setZ(distanceOnRamp * EuclidCoreTools.sin((double)angle));
            ramp3D.transformToWorld((Transformable)pointOutside3);
            expectedDistance2 = random.nextDouble();
            pointOutside3.scaleAdd(expectedDistance2, (Tuple3DReadOnly)ramp3D.getRampSurfaceNormal(), (Tuple3DReadOnly)pointOutside3);
            Assertions.assertEquals((double)expectedDistance2, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside3), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            distanceOnRamp = random.nextDouble() * ramp3D.getRampLength();
            pointOutside3 = new Point3D();
            pointOutside3.setX(distanceOnRamp * EuclidCoreTools.cos((double)angle));
            pointOutside3.setY(0.5 * ramp3D.getSizeY() + random.nextDouble());
            pointOutside3.setZ(distanceOnRamp * EuclidCoreTools.sin((double)angle) * random.nextDouble());
            expectedDistance2 = pointOutside3.getY() - 0.5 * ramp3D.getSizeY();
            ramp3D.transformToWorld((Transformable)pointOutside3);
            Assertions.assertEquals((double)expectedDistance2, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside3), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            distanceOnRamp = random.nextDouble() * ramp3D.getRampLength();
            pointOutside3 = new Point3D();
            pointOutside3.setX(distanceOnRamp * EuclidCoreTools.cos((double)angle));
            pointOutside3.setY(-0.5 * ramp3D.getSizeY() - random.nextDouble());
            pointOutside3.setZ(distanceOnRamp * EuclidCoreTools.sin((double)angle) * random.nextDouble());
            expectedDistance2 = -pointOutside3.getY() - 0.5 * ramp3D.getSizeY();
            ramp3D.transformToWorld((Transformable)pointOutside3);
            Assertions.assertEquals((double)expectedDistance2, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside3), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(ramp3D.getSizeX(), EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())), ramp3D.getSizeZ());
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3DReadOnly rampNormal = ramp3D.getRampSurfaceNormal();
            Vector3D backFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)rampNormal, (Tuple3DReadOnly)backFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance4 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance4, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance4, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(0.0, EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())), 0.0);
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3DReadOnly rampNormal = ramp3D.getRampSurfaceNormal();
            Vector3D bottomFaceNormal = new Vector3D();
            bottomFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)rampNormal, (Tuple3DReadOnly)bottomFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance5 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance5, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance5, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(ramp3D.getSizeX(), EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * ramp3D.getSizeY())), 0.0);
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D backFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            Vector3D bottomFaceNormal = new Vector3D();
            bottomFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)backFaceNormal, (Tuple3DReadOnly)bottomFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance6 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance6, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance6, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(random.nextDouble() * ramp3D.getSizeX(), 0.5 * ramp3D.getSizeY(), 0.0);
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D leftFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Vector3D bottomFaceNormal = new Vector3D();
            bottomFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)leftFaceNormal, (Tuple3DReadOnly)bottomFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance7 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance7, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance7, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(random.nextDouble() * ramp3D.getSizeX(), -0.5 * ramp3D.getSizeY(), 0.0);
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D rightFaceNormal = new Vector3D();
            rightFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Vector3D bottomFaceNormal = new Vector3D();
            bottomFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getZAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)rightFaceNormal, (Tuple3DReadOnly)bottomFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance8 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance8, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance8, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(ramp3D.getSizeX(), 0.5 * ramp3D.getSizeY(), random.nextDouble() * ramp3D.getSizeZ());
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D leftFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Vector3D backFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)leftFaceNormal, (Tuple3DReadOnly)backFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance9 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance9, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance9, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointOnEdge = new Point3D(ramp3D.getSizeX(), -0.5 * ramp3D.getSizeY(), random.nextDouble() * ramp3D.getSizeZ());
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D rightFaceNormal = new Vector3D();
            rightFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            Vector3D backFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getXAxis());
            towardOutside2 = new Vector3D();
            towardOutside2.interpolate((Tuple3DReadOnly)rightFaceNormal, (Tuple3DReadOnly)backFaceNormal, random.nextDouble());
            towardOutside2.normalize();
            double expectedDistance10 = random.nextDouble();
            pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(expectedDistance10, (Tuple3DReadOnly)towardOutside2, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance10, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            double distanceOnRamp2 = random.nextDouble() * ramp3D.getRampLength();
            Point3D pointOnEdge = new Point3D(distanceOnRamp2 * EuclidCoreTools.cos((double)angle), 0.5 * ramp3D.getSizeY(), distanceOnRamp2 * EuclidCoreTools.sin((double)angle));
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D leftFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            slopeFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getRampSurfaceNormal());
            towardOutside = new Vector3D();
            towardOutside.interpolate((Tuple3DReadOnly)leftFaceNormal, (Tuple3DReadOnly)slopeFaceNormal, random.nextDouble());
            towardOutside.normalize();
            expectedDistance = random.nextDouble();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(expectedDistance, (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            double angle = ramp3D.getRampIncline();
            double distanceOnRamp3 = random.nextDouble() * ramp3D.getRampLength();
            Point3D pointOnEdge = new Point3D(distanceOnRamp3 * EuclidCoreTools.cos((double)angle), -0.5 * ramp3D.getSizeY(), distanceOnRamp3 * EuclidCoreTools.sin((double)angle));
            ramp3D.transformToWorld((Transformable)pointOnEdge);
            Vector3D rightFaceNormal = new Vector3D();
            rightFaceNormal.setAndNegate((Tuple3DReadOnly)ramp3D.getPose().getYAxis());
            slopeFaceNormal = new Vector3D((Tuple3DReadOnly)ramp3D.getRampSurfaceNormal());
            towardOutside = new Vector3D();
            towardOutside.interpolate((Tuple3DReadOnly)rightFaceNormal, (Tuple3DReadOnly)slopeFaceNormal, random.nextDouble());
            towardOutside.normalize();
            expectedDistance = random.nextDouble();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(expectedDistance, (Tuple3DReadOnly)towardOutside, (Tuple3DReadOnly)pointOnEdge);
            Assertions.assertEquals((double)expectedDistance, (double)ramp3D.signedDistance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Point3DReadOnly[])ramp3D.getVertices());
            Plane3D backPlane = new Plane3D((Point3DReadOnly)new Point3D(ramp3D.getSizeX(), 0.0, 0.0), (Vector3DReadOnly)Axis3D.X);
            Plane3D bottomPlane = new Plane3D((Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), (Vector3DReadOnly)new Vector3D(0.0, 0.0, -1.0));
            Plane3D leftPlane = new Plane3D((Point3DReadOnly)new Point3D(0.0, 0.5 * ramp3D.getSizeY(), 0.0), (Vector3DReadOnly)Axis3D.Y);
            Plane3D rightPlane = new Plane3D((Point3DReadOnly)new Point3D(0.0, -0.5 * ramp3D.getSizeY(), 0.0), (Vector3DReadOnly)new Vector3D(0.0, -1.0, 0.0));
            Plane3D slopePlane = new Plane3D((Point3DReadOnly)ramp3D.getPosition(), ramp3D.getRampSurfaceNormal());
            ramp3D.transformToWorld((Transformable)backPlane);
            ramp3D.transformToWorld((Transformable)bottomPlane);
            ramp3D.transformToWorld((Transformable)leftPlane);
            ramp3D.transformToWorld((Transformable)rightPlane);
            double expectedDistance11 = Math.min(backPlane.distance((Point3DReadOnly)pointInside), bottomPlane.distance((Point3DReadOnly)pointInside));
            expectedDistance11 = Math.min(expectedDistance11, leftPlane.distance((Point3DReadOnly)pointInside));
            expectedDistance11 = Math.min(expectedDistance11, rightPlane.distance((Point3DReadOnly)pointInside));
            expectedDistance11 = Math.min(expectedDistance11, slopePlane.distance((Point3DReadOnly)pointInside));
            Assertions.assertEquals((double)(-expectedDistance11), (double)ramp3D.signedDistance((Point3DReadOnly)pointInside), (double)1.0E-12);
        }
    }

    @Test
    void testOrthogonalProjection() throws Exception {
        Ramp3D ramp3D;
        int i;
        Random random = new Random(10276897L);
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Point3DReadOnly[])ramp3D.getVertices());
            Assertions.assertNull((Object)ramp3D.orthogonalProjectionCopy((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            Point3D point = new Point3D();
            point.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)-2.0, (double)(2.0 + ramp3D.getSizeX())));
            point.setY(EuclidCoreRandomTools.nextDouble((Random)random, (double)(-1.0 - 0.5 * ramp3D.getSizeY()), (double)(1.0 + 0.5 * ramp3D.getSizeY())));
            point.setX(EuclidCoreRandomTools.nextDouble((Random)random, (double)-2.0, (double)(2.0 + ramp3D.getSizeZ())));
            ramp3D.transformToWorld((Transformable)point);
            Point3D expectedProjection = new Point3D();
            boolean isInside = ramp3D.evaluatePoint3DCollision((Point3DReadOnly)point, (Point3DBasics)expectedProjection, (Vector3DBasics)new Vector3D());
            if (isInside) {
                Assertions.assertNull((Object)ramp3D.orthogonalProjectionCopy((Point3DReadOnly)point));
                continue;
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)ramp3D.orthogonalProjectionCopy((Point3DReadOnly)point), (double)1.0E-12);
        }
    }

    @Test
    void testGetBoundingBox3D() throws Exception {
        Ramp3D ramp3D;
        int i;
        Random random = new Random(34563L);
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            BoundingBox3D boundingBox = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random);
            ramp3D.getBoundingBox((BoundingBox3DBasics)boundingBox);
            for (Point3DBasics vertex : ramp3D.getVertices()) {
                Assertions.assertTrue((boolean)boundingBox.isInsideInclusive((Point3DReadOnly)vertex));
            }
            for (int j = 0; j < 100; ++j) {
                Assertions.assertTrue((boolean)boundingBox.isInsideExclusive((Point3DReadOnly)EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Point3DReadOnly[])ramp3D.getVertices())));
            }
        }
        for (i = 0; i < 1000; ++i) {
            ramp3D = EuclidShapeRandomTools.nextRamp3D((Random)random);
            BoundingBox3D expectedBoundingBox = new BoundingBox3D();
            expectedBoundingBox.setToNaN();
            Vector3D supportDirection = new Vector3D((Tuple3DReadOnly)Axis3D.X);
            expectedBoundingBox.updateToIncludePoint(ramp3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(ramp3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Y);
            expectedBoundingBox.updateToIncludePoint(ramp3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(ramp3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Z);
            expectedBoundingBox.updateToIncludePoint(ramp3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(ramp3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            BoundingBox3DReadOnly actualBoundingBox = ramp3D.getBoundingBox();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedBoundingBox, (EuclidGeometry)actualBoundingBox, (double)1.0E-12);
        }
    }

    @Test
    public void testSurfaceNormal() {
        Ramp3D ramp = new Ramp3D(1.0, 1.0, 1.0);
        Vector3D surfaceNormal = new Vector3D();
        ramp.getRampSurfaceNormal((Vector3DBasics)surfaceNormal);
        Assertions.assertEquals((double)surfaceNormal.getX(), (double)(-1.0 / EuclidCoreTools.squareRoot((double)2.0)), (double)1.0E-14, (String)"not equal");
        Assertions.assertEquals((double)surfaceNormal.getY(), (double)0.0, (double)1.0E-14, (String)"not equal");
        Assertions.assertEquals((double)surfaceNormal.getZ(), (double)(1.0 / EuclidCoreTools.squareRoot((double)2.0)), (double)1.0E-14, (String)"not equal");
    }

    @Test
    public void testGeometricallyEquals() {
        int i;
        Random random = new Random(34201L);
        double epsilon = 1.0E-7;
        double lengthX = random.nextDouble();
        double widthY = random.nextDouble();
        double heightZ = random.nextDouble();
        Ramp3D firstRamp = new Ramp3D(lengthX, widthY, heightZ);
        Ramp3D secondRamp = new Ramp3D(lengthX, widthY, heightZ);
        Assertions.assertTrue((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        Assertions.assertTrue((boolean)secondRamp.geometricallyEquals((EuclidGeometry)firstRamp, epsilon));
        Assertions.assertTrue((boolean)firstRamp.geometricallyEquals((EuclidGeometry)firstRamp, epsilon));
        Assertions.assertTrue((boolean)secondRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        secondRamp = new Ramp3D(lengthX + epsilon * 0.99, widthY, heightZ);
        Assertions.assertTrue((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        secondRamp = new Ramp3D(lengthX, widthY + epsilon * 0.99, heightZ);
        Assertions.assertTrue((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        secondRamp = new Ramp3D(lengthX, widthY, heightZ + epsilon * 0.99);
        Assertions.assertTrue((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        secondRamp = new Ramp3D(lengthX - epsilon * 0.99, widthY, heightZ);
        Assertions.assertTrue((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        secondRamp = new Ramp3D(lengthX, widthY - epsilon * 0.99, heightZ);
        Assertions.assertTrue((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        secondRamp = new Ramp3D(lengthX, widthY, heightZ - epsilon * 0.99);
        Assertions.assertTrue((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        secondRamp = new Ramp3D(lengthX + epsilon * 1.01, widthY, heightZ);
        Assertions.assertFalse((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        secondRamp = new Ramp3D(lengthX, widthY + epsilon * 1.01, heightZ);
        Assertions.assertFalse((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        secondRamp = new Ramp3D(lengthX, widthY, heightZ + epsilon * 1.01);
        Assertions.assertFalse((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        secondRamp = new Ramp3D(lengthX - epsilon * 1.01, widthY, heightZ);
        Assertions.assertFalse((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        secondRamp = new Ramp3D(lengthX, widthY - epsilon * 1.01, heightZ);
        Assertions.assertFalse((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        secondRamp = new Ramp3D(lengthX, widthY, heightZ - epsilon * 1.01);
        Assertions.assertFalse((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        for (i = 0; i < 1000; ++i) {
            Vector3D translationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
            firstRamp = new Ramp3D((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)new RotationMatrix(), (Tuple3DReadOnly)translationVector), lengthX, widthY, heightZ);
            secondRamp = new Ramp3D((Ramp3DReadOnly)firstRamp);
            translationVector = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(0.99 * epsilon));
            secondRamp.getPose().appendTranslation((Tuple3DReadOnly)translationVector);
            Assertions.assertTrue((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
            secondRamp = new Ramp3D((Ramp3DReadOnly)firstRamp);
            translationVector = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(1.01 * epsilon));
            secondRamp.getPose().appendTranslation((Tuple3DReadOnly)translationVector);
            Assertions.assertFalse((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            Quaternion rotation = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Point3D position = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Pose3D pose = new Pose3D((Tuple3DReadOnly)position, (Orientation3DReadOnly)rotation);
            firstRamp = new Ramp3D((Pose3DReadOnly)pose, lengthX, widthY, heightZ);
            secondRamp = new Ramp3D((Ramp3DReadOnly)firstRamp);
            RigidBodyTransform transform = new RigidBodyTransform();
            AxisAngle axisAngle = new AxisAngle();
            axisAngle.set((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), 0.99 * epsilon);
            transform.getRotation().set((Orientation3DReadOnly)axisAngle);
            secondRamp.getPose().multiply((RigidBodyTransformReadOnly)transform);
            Assertions.assertTrue((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
            secondRamp = new Ramp3D((Ramp3DReadOnly)firstRamp);
            axisAngle.set((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), 1.01 * epsilon);
            transform.getRotation().set((Orientation3DReadOnly)axisAngle);
            secondRamp.getPose().multiply((RigidBodyTransformReadOnly)transform);
            Assertions.assertFalse((boolean)firstRamp.geometricallyEquals((EuclidGeometry)secondRamp, epsilon));
        }
    }
}

