/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;

public class Cylinder3DTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    void testConstructors() throws Exception {
        int i;
        Random random = new Random(67542L);
        Cylinder3D cylinder3D = new Cylinder3D();
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)cylinder3D.getPosition());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)Axis3D.Z, (EuclidGeometry)cylinder3D.getAxis(), (double)1.0E-12);
        Assertions.assertEquals((double)1.0, (double)cylinder3D.getLength());
        Assertions.assertEquals((double)0.5, (double)cylinder3D.getHalfLength());
        Assertions.assertEquals((double)0.5, (double)cylinder3D.getRadius());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, 0.0, 0.5), (EuclidGeometry)cylinder3D.getTopCenter(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, 0.0, -0.5), (EuclidGeometry)cylinder3D.getBottomCenter(), (double)1.0E-12);
        for (i = 0; i < 1000; ++i) {
            double length = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
            Cylinder3D cylinder3D2 = new Cylinder3D(length, radius);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)cylinder3D2.getPosition());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)Axis3D.Z, (EuclidGeometry)cylinder3D2.getAxis(), (double)1.0E-12);
            Assertions.assertEquals((double)length, (double)cylinder3D2.getLength());
            Assertions.assertEquals((double)(0.5 * length), (double)cylinder3D2.getHalfLength());
            Assertions.assertEquals((double)radius, (double)cylinder3D2.getRadius());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, 0.0, 0.5 * length), (EuclidGeometry)cylinder3D2.getTopCenter(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, 0.0, -0.5 * length), (EuclidGeometry)cylinder3D2.getBottomCenter(), (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Cylinder3D(-0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Cylinder3D(1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            Point3D expectedTopCenter = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D expectedBottomCenter = EuclidCoreRandomTools.nextPoint3D((Random)random);
            double length = expectedTopCenter.distance((Point3DReadOnly)expectedBottomCenter);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
            Point3D position = EuclidGeometryTools.averagePoint3Ds((Point3DReadOnly)expectedTopCenter, (Point3DReadOnly)expectedBottomCenter);
            Vector3D axis = new Vector3D();
            axis.sub((Tuple3DReadOnly)expectedTopCenter, (Tuple3DReadOnly)expectedBottomCenter);
            Cylinder3D cylinder3D3 = new Cylinder3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, length, radius);
            axis.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)position, (EuclidGeometry)cylinder3D3.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axis, (EuclidGeometry)cylinder3D3.getAxis(), (double)1.0E-12);
            Assertions.assertEquals((double)length, (double)cylinder3D3.getLength());
            Assertions.assertEquals((double)(0.5 * length), (double)cylinder3D3.getHalfLength());
            Assertions.assertEquals((double)radius, (double)cylinder3D3.getRadius());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTopCenter, (EuclidGeometry)cylinder3D3.getTopCenter(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedBottomCenter, (EuclidGeometry)cylinder3D3.getBottomCenter(), (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Cylinder3D((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)Axis3D.Z, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Cylinder3D((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)Axis3D.Z, 1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            Cylinder3D original = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Cylinder3D copy = new Cylinder3D((Cylinder3DReadOnly)original);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)copy, (double)1.0E-12);
        }
    }

    @Test
    void testSetToNaN() throws Exception {
        Random random = new Random(34575754L);
        for (int i = 0; i < 1000; ++i) {
            Cylinder3D cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Assertions.assertFalse((boolean)cylinder3D.containsNaN());
            Assertions.assertFalse((boolean)cylinder3D.getPosition().containsNaN());
            Assertions.assertFalse((boolean)cylinder3D.getAxis().containsNaN());
            Assertions.assertFalse((boolean)cylinder3D.getTopCenter().containsNaN());
            Assertions.assertFalse((boolean)cylinder3D.getBottomCenter().containsNaN());
            Assertions.assertFalse((boolean)Double.isNaN(cylinder3D.getLength()));
            Assertions.assertFalse((boolean)Double.isNaN(cylinder3D.getHalfLength()));
            Assertions.assertFalse((boolean)Double.isNaN(cylinder3D.getRadius()));
            cylinder3D.setToNaN();
            Assertions.assertTrue((boolean)cylinder3D.containsNaN());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)cylinder3D.getPosition());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)cylinder3D.getAxis());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)cylinder3D.getTopCenter());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)cylinder3D.getBottomCenter());
            Assertions.assertTrue((boolean)Double.isNaN(cylinder3D.getLength()));
            Assertions.assertTrue((boolean)Double.isNaN(cylinder3D.getHalfLength()));
            Assertions.assertTrue((boolean)Double.isNaN(cylinder3D.getRadius()));
        }
    }

    @Test
    void testSetToZero() throws Exception {
        Random random = new Random(34575754L);
        for (int i = 0; i < 1000; ++i) {
            Cylinder3D cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((EuclidGeometry)cylinder3D.getPosition(), 1.0E-12));
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((EuclidGeometry)cylinder3D.getAxis(), 1.0E-12));
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((EuclidGeometry)cylinder3D.getTopCenter(), 1.0E-12));
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((EuclidGeometry)cylinder3D.getBottomCenter(), 1.0E-12));
            Assertions.assertNotEquals((double)0.0, (double)cylinder3D.getLength());
            Assertions.assertNotEquals((double)0.0, (double)cylinder3D.getHalfLength());
            Assertions.assertNotEquals((double)0.0, (double)cylinder3D.getRadius());
            cylinder3D.setToZero();
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)cylinder3D.getPosition());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)Axis3D.Z, (EuclidGeometry)cylinder3D.getAxis(), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)cylinder3D.getTopCenter());
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)cylinder3D.getBottomCenter());
            Assertions.assertEquals((double)0.0, (double)cylinder3D.getLength());
            Assertions.assertEquals((double)0.0, (double)cylinder3D.getHalfLength());
            Assertions.assertEquals((double)0.0, (double)cylinder3D.getRadius());
        }
    }

    @Test
    void testSetters() throws Exception {
        Cylinder3D actual;
        Cylinder3D expected;
        int i;
        Random random = new Random(5467457L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            actual = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((Cylinder3DReadOnly)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            actual = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((Cylinder3DReadOnly)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            actual = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((Point3DReadOnly)expected.getPosition(), (Vector3DReadOnly)expected.getAxis(), expected.getLength(), expected.getRadius());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Cylinder3D().set((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)Axis3D.Z, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Cylinder3D().set((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)Axis3D.Z, 1.0, -0.1));
    }

    @Test
    void testSize() throws Exception {
        Random random = new Random(43905783L);
        for (int i = 0; i < 1000; ++i) {
            double length = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            Cylinder3D cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Assertions.assertNotEquals((double)length, (double)cylinder3D.getLength());
            Assertions.assertNotEquals((double)radius, (double)cylinder3D.getRadius());
            cylinder3D.setSize(length, radius);
            Assertions.assertEquals((double)length, (double)cylinder3D.getLength());
            Assertions.assertEquals((double)radius, (double)cylinder3D.getRadius());
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Cylinder3D().setSize(-0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Cylinder3D().setSize(1.0, -0.1));
    }

    @Test
    void testIsPointInside() throws Exception {
        Vector3D orthogonalToAxis;
        Point3D pointOnAxis;
        Cylinder3D cylinder3D;
        int i;
        Random random = new Random(3465463L);
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            pointOnAxis = new Point3D();
            double alpha = random.nextDouble();
            pointOnAxis.interpolate((Tuple3DReadOnly)cylinder3D.getTopCenter(), (Tuple3DReadOnly)cylinder3D.getBottomCenter(), alpha);
            Vector3D orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            double distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinder3D.getRadius());
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            Assertions.assertTrue((boolean)cylinder3D.isPointInside((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)cylinder3D.getTopCenter(), (Tuple3DReadOnly)cylinder3D.getBottomCenter(), random.nextDouble());
            Vector3D orthogonalToAxis3 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            double distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0) * cylinder3D.getRadius();
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis3, (Tuple3DReadOnly)pointOnAxis);
            Assertions.assertFalse((boolean)cylinder3D.isPointInside((Point3DReadOnly)pointOutside));
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnTopCap = new Point3D();
            pointOnTopCap.scaleAdd(random.nextDouble() * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getTopCenter());
            double distanceOffTopCap = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffTopCap, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnTopCap);
            Assertions.assertFalse((boolean)cylinder3D.isPointInside((Point3DReadOnly)pointOutside));
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnBottomCap = new Point3D();
            pointOnBottomCap.scaleAdd(random.nextDouble() * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getBottomCenter());
            double distanceOffBottomCap = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(-distanceOffBottomCap, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnBottomCap);
            Assertions.assertFalse((boolean)cylinder3D.isPointInside((Point3DReadOnly)pointOutside));
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnTopPlane = new Point3D();
            pointOnTopPlane.scaleAdd((1.0 + random.nextDouble()) * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getTopCenter());
            double distanceOffTopPlane = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffTopPlane, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnTopPlane);
            Assertions.assertFalse((boolean)cylinder3D.isPointInside((Point3DReadOnly)pointOutside));
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnBottomPlane = new Point3D();
            pointOnBottomPlane.scaleAdd((1.0 + random.nextDouble()) * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getBottomCenter());
            double distanceOffBottomPlane = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(-distanceOffBottomPlane, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnBottomPlane);
            Assertions.assertFalse((boolean)cylinder3D.isPointInside((Point3DReadOnly)pointOutside));
        }
    }

    @Test
    void testEvaluatePoint3DCollision() throws Exception {
        Vector3D orthogonalToAxis;
        Point3D pointOnAxis;
        Cylinder3D cylinder3D;
        int i;
        Random random = new Random(4444L);
        Point3D actualClosestPoint = new Point3D();
        Vector3D actualNormal = new Vector3D();
        Point3D expectedClosestPoint = new Point3D();
        Vector3D expectedNormal = new Vector3D();
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)cylinder3D.getTopCenter(), (Tuple3DReadOnly)cylinder3D.getBottomCenter(), random.nextDouble());
            Assertions.assertTrue((boolean)cylinder3D.evaluatePoint3DCollision((Point3DReadOnly)pointOnAxis, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            Assertions.assertFalse((boolean)actualClosestPoint.containsNaN());
            Assertions.assertFalse((boolean)actualNormal.containsNaN());
            cylinder3D.evaluatePoint3DCollision((Point3DReadOnly)actualClosestPoint, (Point3DBasics)expectedClosestPoint, (Vector3DBasics)expectedNormal);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            pointOnAxis = new Point3D();
            double alpha = random.nextDouble();
            pointOnAxis.interpolate((Tuple3DReadOnly)cylinder3D.getTopCenter(), (Tuple3DReadOnly)cylinder3D.getBottomCenter(), alpha);
            Vector3D orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            double distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinder3D.getRadius());
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            double distanceFromInfiniteCylinder = cylinder3D.getRadius() - distanceOffAxis;
            double distanceFromTopCap = alpha * cylinder3D.getLength();
            double distanceFromBottomCap = (1.0 - alpha) * cylinder3D.getLength();
            if (distanceFromInfiniteCylinder <= distanceFromTopCap && distanceFromInfiniteCylinder <= distanceFromBottomCap) {
                expectedClosestPoint.scaleAdd(cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
                expectedNormal.setAndNormalize((Tuple3DReadOnly)orthogonalToAxis2);
                Assertions.assertTrue((boolean)cylinder3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)(distanceOffAxis < 0.001 ? 2.0E-12 : 1.0E-12));
                continue;
            }
            if (distanceFromTopCap <= distanceFromBottomCap) {
                expectedClosestPoint.set((Tuple3DReadOnly)EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointInside, (Point3DReadOnly)cylinder3D.getTopCenter(), (Vector3DReadOnly)cylinder3D.getAxis()));
                expectedNormal.set((Tuple3DReadOnly)cylinder3D.getAxis());
            } else {
                expectedClosestPoint.set((Tuple3DReadOnly)EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointInside, (Point3DReadOnly)cylinder3D.getBottomCenter(), (Vector3DReadOnly)cylinder3D.getAxis()));
                expectedNormal.setAndNegate((Tuple3DReadOnly)cylinder3D.getAxis());
            }
            Assertions.assertTrue((boolean)cylinder3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)cylinder3D.getTopCenter(), (Tuple3DReadOnly)cylinder3D.getBottomCenter(), random.nextDouble());
            Vector3D orthogonalToAxis3 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            double distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0) * cylinder3D.getRadius();
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis3, (Tuple3DReadOnly)pointOnAxis);
            expectedClosestPoint.scaleAdd(cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis3, (Tuple3DReadOnly)pointOnAxis);
            expectedNormal.setAndNormalize((Tuple3DReadOnly)orthogonalToAxis3);
            Assertions.assertFalse((boolean)cylinder3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnTopCap = new Point3D();
            pointOnTopCap.scaleAdd(random.nextDouble() * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getTopCenter());
            double distanceOffTopCap = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffTopCap, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnTopCap);
            expectedClosestPoint.set((Tuple3DReadOnly)pointOnTopCap);
            expectedNormal.set((Tuple3DReadOnly)cylinder3D.getAxis());
            Assertions.assertFalse((boolean)cylinder3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnBottomCap = new Point3D();
            pointOnBottomCap.scaleAdd(random.nextDouble() * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getBottomCenter());
            double distanceOffBottomCap = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(-distanceOffBottomCap, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnBottomCap);
            expectedClosestPoint.set((Tuple3DReadOnly)pointOnBottomCap);
            expectedNormal.setAndNegate((Tuple3DReadOnly)cylinder3D.getAxis());
            Assertions.assertFalse((boolean)cylinder3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnTopPlane = new Point3D();
            pointOnTopPlane.scaleAdd((1.0 + random.nextDouble()) * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getTopCenter());
            double distanceOffTopPlane = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffTopPlane, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnTopPlane);
            expectedClosestPoint.scaleAdd(cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getTopCenter());
            expectedNormal.sub((Tuple3DReadOnly)pointOutside, (Tuple3DReadOnly)expectedClosestPoint);
            expectedNormal.normalize();
            Assertions.assertFalse((boolean)cylinder3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnBottomPlane = new Point3D();
            pointOnBottomPlane.scaleAdd((1.0 + random.nextDouble()) * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getBottomCenter());
            double distanceOffBottomPlane = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(-distanceOffBottomPlane, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnBottomPlane);
            expectedClosestPoint.scaleAdd(cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getBottomCenter());
            expectedNormal.sub((Tuple3DReadOnly)pointOutside, (Tuple3DReadOnly)expectedClosestPoint);
            expectedNormal.normalize();
            Assertions.assertFalse((boolean)cylinder3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
    }

    @Test
    void testApplyTransform() {
        RigidBodyTransform transform;
        Cylinder3D expected;
        Cylinder3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            expected = new Cylinder3D((Cylinder3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPosition().applyTransform((Transform)transform);
            expected.getAxis().applyTransform((Transform)transform);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            expected = new Cylinder3D((Cylinder3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPosition().applyTransform((Transform)transform);
            expected.getAxis().applyTransform((Transform)transform);
            expected.getAxis().normalize();
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    void testApplyInverseTransform() {
        RigidBodyTransform transform;
        Cylinder3D expected;
        Cylinder3D original;
        Cylinder3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            original = new Cylinder3D((Cylinder3DReadOnly)actual);
            expected = new Cylinder3D((Cylinder3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPosition().applyInverseTransform((Transform)transform);
            expected.getAxis().applyInverseTransform((Transform)transform);
            expected.getAxis().normalize();
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            original = new Cylinder3D((Cylinder3DReadOnly)actual);
            expected = new Cylinder3D((Cylinder3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPosition().applyInverseTransform((Transform)transform);
            expected.getAxis().applyInverseTransform((Transform)transform);
            expected.getAxis().normalize();
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    void testDistance() throws Exception {
        double expectedDistance;
        Point3D pointOutside;
        double distanceOrthogonalToAxis;
        Vector3D orthogonalToAxis;
        Point3D pointOnAxis;
        Cylinder3D cylinder3D;
        int i;
        Random random = new Random(987346L);
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            pointOnAxis = new Point3D();
            double alpha = random.nextDouble();
            pointOnAxis.interpolate((Tuple3DReadOnly)cylinder3D.getTopCenter(), (Tuple3DReadOnly)cylinder3D.getBottomCenter(), alpha);
            Vector3D orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            double distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinder3D.getRadius());
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            Assertions.assertEquals((double)0.0, (double)cylinder3D.distance((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)cylinder3D.getTopCenter(), (Tuple3DReadOnly)cylinder3D.getBottomCenter(), random.nextDouble());
            Vector3D orthogonalToAxis3 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            double distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0) * cylinder3D.getRadius();
            Point3D pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis3, (Tuple3DReadOnly)pointOnAxis);
            Assertions.assertEquals((double)(distanceOffAxis - cylinder3D.getRadius()), (double)cylinder3D.distance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnTopCap = new Point3D();
            pointOnTopCap.scaleAdd(random.nextDouble() * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getTopCenter());
            double distanceOffTopCap = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside3 = new Point3D();
            pointOutside3.scaleAdd(distanceOffTopCap, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnTopCap);
            Assertions.assertEquals((double)distanceOffTopCap, (double)cylinder3D.distance((Point3DReadOnly)pointOutside3), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnBottomCap = new Point3D();
            pointOnBottomCap.scaleAdd(random.nextDouble() * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getBottomCenter());
            double distanceOffBottomCap = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside4 = new Point3D();
            pointOutside4.scaleAdd(-distanceOffBottomCap, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnBottomCap);
            Assertions.assertEquals((double)distanceOffBottomCap, (double)cylinder3D.distance((Point3DReadOnly)pointOutside4), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnTopPlane = new Point3D();
            distanceOrthogonalToAxis = (1.0 + random.nextDouble()) * cylinder3D.getRadius();
            pointOnTopPlane.scaleAdd(distanceOrthogonalToAxis, (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getTopCenter());
            double distanceOffTopPlane = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffTopPlane, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnTopPlane);
            expectedDistance = EuclidCoreTools.norm((double)(distanceOrthogonalToAxis - cylinder3D.getRadius()), (double)distanceOffTopPlane);
            Assertions.assertEquals((double)expectedDistance, (double)cylinder3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnBottomPlane = new Point3D();
            distanceOrthogonalToAxis = (1.0 + random.nextDouble()) * cylinder3D.getRadius();
            pointOnBottomPlane.scaleAdd(distanceOrthogonalToAxis, (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getBottomCenter());
            double distanceOffBottomPlane = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            pointOutside = new Point3D();
            pointOutside.scaleAdd(-distanceOffBottomPlane, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnBottomPlane);
            expectedDistance = EuclidCoreTools.norm((double)(distanceOrthogonalToAxis - cylinder3D.getRadius()), (double)distanceOffBottomPlane);
            Assertions.assertEquals((double)expectedDistance, (double)cylinder3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
    }

    @Test
    void testSignedDistance() throws Exception {
        double expectedDistance;
        Point3D pointOutside;
        double distanceOrthogonalToAxis;
        Vector3D orthogonalToAxis;
        Point3D pointOnAxis;
        Cylinder3D cylinder3D;
        int i;
        Random random = new Random(987L);
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            pointOnAxis = new Point3D();
            double alpha = random.nextDouble();
            pointOnAxis.interpolate((Tuple3DReadOnly)cylinder3D.getTopCenter(), (Tuple3DReadOnly)cylinder3D.getBottomCenter(), alpha);
            Vector3D orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            double distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinder3D.getRadius());
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            double distanceFromInfiniteCylinder = cylinder3D.getRadius() - distanceOffAxis;
            double distanceFromTopCap = alpha * cylinder3D.getLength();
            double distanceFromBottomCap = (1.0 - alpha) * cylinder3D.getLength();
            Assertions.assertEquals((double)(-EuclidCoreTools.min((double)distanceFromInfiniteCylinder, (double)distanceFromTopCap, (double)distanceFromBottomCap)), (double)cylinder3D.signedDistance((Point3DReadOnly)pointInside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)cylinder3D.getTopCenter(), (Tuple3DReadOnly)cylinder3D.getBottomCenter(), random.nextDouble());
            Vector3D orthogonalToAxis3 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            double distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0) * cylinder3D.getRadius();
            Point3D pointOutside2 = new Point3D();
            pointOutside2.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis3, (Tuple3DReadOnly)pointOnAxis);
            Assertions.assertEquals((double)(distanceOffAxis - cylinder3D.getRadius()), (double)cylinder3D.signedDistance((Point3DReadOnly)pointOutside2), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnTopCap = new Point3D();
            pointOnTopCap.scaleAdd(random.nextDouble() * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getTopCenter());
            double distanceOffTopCap = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside3 = new Point3D();
            pointOutside3.scaleAdd(distanceOffTopCap, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnTopCap);
            Assertions.assertEquals((double)distanceOffTopCap, (double)cylinder3D.signedDistance((Point3DReadOnly)pointOutside3), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnBottomCap = new Point3D();
            pointOnBottomCap.scaleAdd(random.nextDouble() * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getBottomCenter());
            double distanceOffBottomCap = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside4 = new Point3D();
            pointOutside4.scaleAdd(-distanceOffBottomCap, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnBottomCap);
            Assertions.assertEquals((double)distanceOffBottomCap, (double)cylinder3D.signedDistance((Point3DReadOnly)pointOutside4), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnTopPlane = new Point3D();
            distanceOrthogonalToAxis = (1.0 + random.nextDouble()) * cylinder3D.getRadius();
            pointOnTopPlane.scaleAdd(distanceOrthogonalToAxis, (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getTopCenter());
            double distanceOffTopPlane = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffTopPlane, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnTopPlane);
            expectedDistance = EuclidCoreTools.norm((double)(distanceOrthogonalToAxis - cylinder3D.getRadius()), (double)distanceOffTopPlane);
            Assertions.assertEquals((double)expectedDistance, (double)cylinder3D.signedDistance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnBottomPlane = new Point3D();
            distanceOrthogonalToAxis = (1.0 + random.nextDouble()) * cylinder3D.getRadius();
            pointOnBottomPlane.scaleAdd(distanceOrthogonalToAxis, (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getBottomCenter());
            double distanceOffBottomPlane = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            pointOutside = new Point3D();
            pointOutside.scaleAdd(-distanceOffBottomPlane, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnBottomPlane);
            expectedDistance = EuclidCoreTools.norm((double)(distanceOrthogonalToAxis - cylinder3D.getRadius()), (double)distanceOffBottomPlane);
            Assertions.assertEquals((double)expectedDistance, (double)cylinder3D.signedDistance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
    }

    @Test
    void testOrthogonalProjection() throws Exception {
        Vector3D orthogonalToAxis;
        Point3D pointOnAxis;
        Cylinder3D cylinder3D;
        int i;
        Random random = new Random(768L);
        Point3D expectedProjection = new Point3D();
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            pointOnAxis = new Point3D();
            double alpha = random.nextDouble();
            pointOnAxis.interpolate((Tuple3DReadOnly)cylinder3D.getTopCenter(), (Tuple3DReadOnly)cylinder3D.getBottomCenter(), alpha);
            Vector3D orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            double distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)cylinder3D.getRadius());
            Point3D pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            Assertions.assertNull((Object)cylinder3D.orthogonalProjectionCopy((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)cylinder3D.getTopCenter(), (Tuple3DReadOnly)cylinder3D.getBottomCenter(), random.nextDouble());
            Vector3D orthogonalToAxis3 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            double distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0) * cylinder3D.getRadius();
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis3, (Tuple3DReadOnly)pointOnAxis);
            expectedProjection.scaleAdd(cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis3, (Tuple3DReadOnly)pointOnAxis);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)cylinder3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnTopCap = new Point3D();
            pointOnTopCap.scaleAdd(random.nextDouble() * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getTopCenter());
            double distanceOffTopCap = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffTopCap, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnTopCap);
            expectedProjection.set((Tuple3DReadOnly)pointOnTopCap);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)cylinder3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnBottomCap = new Point3D();
            pointOnBottomCap.scaleAdd(random.nextDouble() * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getBottomCenter());
            double distanceOffBottomCap = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(-distanceOffBottomCap, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnBottomCap);
            expectedProjection.set((Tuple3DReadOnly)pointOnBottomCap);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)cylinder3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnTopPlane = new Point3D();
            pointOnTopPlane.scaleAdd((1.0 + random.nextDouble()) * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getTopCenter());
            double distanceOffTopPlane = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffTopPlane, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnTopPlane);
            expectedProjection.scaleAdd(cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getTopCenter());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)cylinder3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)cylinder3D.getAxis(), (boolean)true);
            Point3D pointOnBottomPlane = new Point3D();
            pointOnBottomPlane.scaleAdd((1.0 + random.nextDouble()) * cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getBottomCenter());
            double distanceOffBottomPlane = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3D pointOutside = new Point3D();
            pointOutside.scaleAdd(-distanceOffBottomPlane, (Tuple3DReadOnly)cylinder3D.getAxis(), (Tuple3DReadOnly)pointOnBottomPlane);
            expectedProjection.scaleAdd(cylinder3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)cylinder3D.getBottomCenter());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)cylinder3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
    }

    @Test
    public void testGeometricallyEquals() {
        int i;
        Random random = new Random(12653L);
        double epsilon = 1.0E-7;
        double height = random.nextDouble();
        double radius = random.nextDouble();
        Point3D position = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        Cylinder3D firstCylinder = new Cylinder3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, height, radius);
        Cylinder3D secondCylinder = new Cylinder3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, height, radius);
        Assertions.assertTrue((boolean)firstCylinder.geometricallyEquals((EuclidGeometry)secondCylinder, epsilon));
        Assertions.assertTrue((boolean)secondCylinder.geometricallyEquals((EuclidGeometry)firstCylinder, epsilon));
        Assertions.assertTrue((boolean)firstCylinder.geometricallyEquals((EuclidGeometry)firstCylinder, epsilon));
        Assertions.assertTrue((boolean)secondCylinder.geometricallyEquals((EuclidGeometry)secondCylinder, epsilon));
        for (i = 0; i < 1000; ++i) {
            height = random.nextDouble();
            radius = random.nextDouble();
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            firstCylinder = new Cylinder3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, height, radius);
            secondCylinder = new Cylinder3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, height, radius);
            secondCylinder.setLength(height + 0.99 * epsilon);
            Assertions.assertTrue((boolean)firstCylinder.geometricallyEquals((EuclidGeometry)secondCylinder, epsilon));
            secondCylinder.setLength(height + 1.01 * epsilon);
            Assertions.assertFalse((boolean)firstCylinder.geometricallyEquals((EuclidGeometry)secondCylinder, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            height = random.nextDouble();
            radius = random.nextDouble();
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            firstCylinder = new Cylinder3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, height, radius);
            secondCylinder = new Cylinder3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, height, radius);
            secondCylinder.setRadius(radius + 0.99 * epsilon);
            Assertions.assertTrue((boolean)firstCylinder.geometricallyEquals((EuclidGeometry)secondCylinder, epsilon));
            secondCylinder.setRadius(radius + 1.01 * epsilon);
            Assertions.assertFalse((boolean)firstCylinder.geometricallyEquals((EuclidGeometry)secondCylinder, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            height = random.nextDouble();
            radius = random.nextDouble();
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            firstCylinder = new Cylinder3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, height, radius);
            secondCylinder = new Cylinder3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, height, radius);
            Vector3D orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)axis, (boolean)true);
            secondCylinder.getAxis().applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)orthogonalToAxis, Math.PI), (Tuple3DReadOnly)new Vector3D()));
            Assertions.assertTrue((boolean)firstCylinder.geometricallyEquals((EuclidGeometry)secondCylinder, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            height = random.nextDouble();
            radius = random.nextDouble();
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            firstCylinder = new Cylinder3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, height, radius);
            secondCylinder = new Cylinder3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, height, radius);
            Vector3D translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(0.99 * epsilon));
            secondCylinder.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)translation));
            Assertions.assertTrue((boolean)firstCylinder.geometricallyEquals((EuclidGeometry)secondCylinder, epsilon));
            secondCylinder = new Cylinder3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, height, radius);
            translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(1.01 * epsilon));
            secondCylinder.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)translation));
            Assertions.assertFalse((boolean)firstCylinder.geometricallyEquals((EuclidGeometry)secondCylinder, epsilon));
        }
    }

    @Test
    void testGetSupportingVertex() throws Exception {
        Random random = new Random(546161L);
        for (int i = 0; i < 1000; ++i) {
            Cylinder3D cylinder = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Vector3D supportDirection = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3DReadOnly supportingVertex = cylinder.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((boolean)cylinder.isPointInside(supportingVertex, 1.0E-12));
            Point3D supportingVertexTranslated = new Point3D();
            supportDirection.normalize();
            supportingVertexTranslated.scaleAdd(0.01, (Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)supportingVertex);
            Assertions.assertFalse((boolean)cylinder.isPointInside((Point3DReadOnly)supportingVertexTranslated, 1.0E-12));
            Vector3D actualNormal = new Vector3D();
            cylinder.evaluatePoint3DCollision((Point3DReadOnly)supportingVertexTranslated, (Point3DBasics)new Point3D(), (Vector3DBasics)actualNormal);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)supportDirection, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
    }

    @Test
    void testGetBoundingBox() throws Exception {
        Random random = new Random(36342L);
        for (int i = 0; i < 1000; ++i) {
            Cylinder3D cylinder3D = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            BoundingBox3D expectedBoundingBox = new BoundingBox3D();
            expectedBoundingBox.setToNaN();
            Vector3D supportDirection = new Vector3D((Tuple3DReadOnly)Axis3D.X);
            expectedBoundingBox.updateToIncludePoint(cylinder3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(cylinder3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Y);
            expectedBoundingBox.updateToIncludePoint(cylinder3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(cylinder3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Z);
            expectedBoundingBox.updateToIncludePoint(cylinder3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(cylinder3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            BoundingBox3DReadOnly actualBoundingBox = cylinder3D.getBoundingBox();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedBoundingBox, (EuclidGeometry)actualBoundingBox, (double)1.0E-12);
        }
    }
}

