/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.shape.primitives.Capsule3D;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

class Capsule3DTest {
    private static final double EPSILON = 1.0E-12;

    Capsule3DTest() {
    }

    @Test
    void testConstructors() throws Exception {
        int i;
        Random random = new Random(67542L);
        Capsule3D capsule3D = new Capsule3D();
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)capsule3D.getPosition());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)Axis3D.Z, (EuclidGeometry)capsule3D.getAxis(), (double)1.0E-12);
        Assertions.assertEquals((double)1.0, (double)capsule3D.getLength());
        Assertions.assertEquals((double)0.5, (double)capsule3D.getHalfLength());
        Assertions.assertEquals((double)0.5, (double)capsule3D.getRadius());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, 0.0, 0.5), (EuclidGeometry)capsule3D.getTopCenter(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, 0.0, -0.5), (EuclidGeometry)capsule3D.getBottomCenter(), (double)1.0E-12);
        for (i = 0; i < 1000; ++i) {
            double length = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
            Capsule3D capsule3D2 = new Capsule3D(length, radius);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)capsule3D2.getPosition());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)Axis3D.Z, (EuclidGeometry)capsule3D2.getAxis(), (double)1.0E-12);
            Assertions.assertEquals((double)length, (double)capsule3D2.getLength());
            Assertions.assertEquals((double)(0.5 * length), (double)capsule3D2.getHalfLength());
            Assertions.assertEquals((double)radius, (double)capsule3D2.getRadius());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, 0.0, 0.5 * length), (EuclidGeometry)capsule3D2.getTopCenter(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.0, 0.0, -0.5 * length), (EuclidGeometry)capsule3D2.getBottomCenter(), (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Capsule3D(-0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Capsule3D(1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            Point3D expectedTopCenter = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D expectedBottomCenter = EuclidCoreRandomTools.nextPoint3D((Random)random);
            double length = expectedTopCenter.distance((Point3DReadOnly)expectedBottomCenter);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
            Point3D position = EuclidGeometryTools.averagePoint3Ds((Point3DReadOnly)expectedTopCenter, (Point3DReadOnly)expectedBottomCenter);
            Vector3D axis = new Vector3D();
            axis.sub((Tuple3DReadOnly)expectedTopCenter, (Tuple3DReadOnly)expectedBottomCenter);
            Capsule3D capsule3D3 = new Capsule3D((Point3DReadOnly)position, (Vector3DReadOnly)axis, length, radius);
            axis.normalize();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)position, (EuclidGeometry)capsule3D3.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)axis, (EuclidGeometry)capsule3D3.getAxis(), (double)1.0E-12);
            Assertions.assertEquals((double)length, (double)capsule3D3.getLength());
            Assertions.assertEquals((double)(0.5 * length), (double)capsule3D3.getHalfLength());
            Assertions.assertEquals((double)radius, (double)capsule3D3.getRadius());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTopCenter, (EuclidGeometry)capsule3D3.getTopCenter(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedBottomCenter, (EuclidGeometry)capsule3D3.getBottomCenter(), (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Capsule3D((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)Axis3D.Z, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Capsule3D((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)Axis3D.Z, 1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            Capsule3D original = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Capsule3D copy = new Capsule3D((Capsule3DReadOnly)original);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)copy, (double)1.0E-12);
        }
    }

    @Test
    void testSetToNaN() throws Exception {
        Random random = new Random(34575754L);
        for (int i = 0; i < 1000; ++i) {
            Capsule3D capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Assertions.assertFalse((boolean)capsule3D.containsNaN());
            Assertions.assertFalse((boolean)capsule3D.getPosition().containsNaN());
            Assertions.assertFalse((boolean)capsule3D.getAxis().containsNaN());
            Assertions.assertFalse((boolean)capsule3D.getTopCenter().containsNaN());
            Assertions.assertFalse((boolean)capsule3D.getBottomCenter().containsNaN());
            Assertions.assertFalse((boolean)Double.isNaN(capsule3D.getLength()));
            Assertions.assertFalse((boolean)Double.isNaN(capsule3D.getHalfLength()));
            Assertions.assertFalse((boolean)Double.isNaN(capsule3D.getRadius()));
            capsule3D.setToNaN();
            Assertions.assertTrue((boolean)capsule3D.containsNaN());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)capsule3D.getPosition());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)capsule3D.getAxis());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)capsule3D.getTopCenter());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)capsule3D.getBottomCenter());
            Assertions.assertTrue((boolean)Double.isNaN(capsule3D.getLength()));
            Assertions.assertTrue((boolean)Double.isNaN(capsule3D.getHalfLength()));
            Assertions.assertTrue((boolean)Double.isNaN(capsule3D.getRadius()));
        }
    }

    @Test
    void testSetToZero() throws Exception {
        Random random = new Random(34575754L);
        for (int i = 0; i < 1000; ++i) {
            Capsule3D capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((EuclidGeometry)capsule3D.getPosition(), 1.0E-12));
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((EuclidGeometry)capsule3D.getAxis(), 1.0E-12));
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((EuclidGeometry)capsule3D.getTopCenter(), 1.0E-12));
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((EuclidGeometry)capsule3D.getBottomCenter(), 1.0E-12));
            Assertions.assertNotEquals((double)0.0, (double)capsule3D.getLength());
            Assertions.assertNotEquals((double)0.0, (double)capsule3D.getHalfLength());
            Assertions.assertNotEquals((double)0.0, (double)capsule3D.getRadius());
            capsule3D.setToZero();
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)capsule3D.getPosition());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)Axis3D.Z, (EuclidGeometry)capsule3D.getAxis(), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)capsule3D.getTopCenter());
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)capsule3D.getBottomCenter());
            Assertions.assertEquals((double)0.0, (double)capsule3D.getLength());
            Assertions.assertEquals((double)0.0, (double)capsule3D.getHalfLength());
            Assertions.assertEquals((double)0.0, (double)capsule3D.getRadius());
        }
    }

    @Test
    void testSetters() throws Exception {
        Capsule3D actual;
        Capsule3D expected;
        int i;
        Random random = new Random(5467457L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            actual = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((Capsule3DReadOnly)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            actual = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((Capsule3DReadOnly)expected);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            actual = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals((EuclidGeometry)actual, 1.0E-12));
            actual.set((Point3DReadOnly)expected.getPosition(), (Vector3DReadOnly)expected.getAxis(), expected.getLength(), expected.getRadius());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Capsule3D().set((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)Axis3D.Z, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Capsule3D().set((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)Axis3D.Z, 1.0, -0.1));
    }

    @Test
    void testSetSize() throws Exception {
        Random random = new Random(43905783L);
        for (int i = 0; i < 1000; ++i) {
            double length = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)5.0);
            Capsule3D capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Assertions.assertNotEquals((double)length, (double)capsule3D.getLength());
            Assertions.assertNotEquals((double)radius, (double)capsule3D.getRadius());
            capsule3D.setSize(length, radius);
            Assertions.assertEquals((double)length, (double)capsule3D.getLength());
            Assertions.assertEquals((double)radius, (double)capsule3D.getRadius());
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Capsule3D().setSize(-0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Capsule3D().setSize(1.0, -0.1));
    }

    @Test
    void testIsPointInside() throws Exception {
        Vector3D direction;
        Point3D pointInside;
        Point3D pointOutside;
        double distanceOffAxis;
        Vector3D orthogonalToAxis;
        Point3D pointOnAxis;
        Capsule3D capsule3D;
        int i;
        Random random = new Random(3465463L);
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)capsule3D.getTopCenter(), (Tuple3DReadOnly)capsule3D.getBottomCenter(), random.nextDouble());
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)capsule3D.getRadius());
            Point3D pointInside2 = new Point3D();
            pointInside2.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)pointOnAxis);
            Assertions.assertTrue((boolean)capsule3D.isPointInside((Point3DReadOnly)pointInside2));
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)capsule3D.getTopCenter(), (Tuple3DReadOnly)capsule3D.getBottomCenter(), random.nextDouble());
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis, (Tuple3DReadOnly)pointOnAxis);
            Assertions.assertFalse((boolean)capsule3D.isPointInside((Point3DReadOnly)pointOutside));
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            double distanceOffTopCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0) * capsule3D.getRadius();
            Vector3D translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)distanceOffTopCenter);
            pointInside = new Point3D();
            pointInside.add((Tuple3DReadOnly)capsule3D.getTopCenter(), (Tuple3DReadOnly)translation);
            Assertions.assertTrue((boolean)capsule3D.isPointInside((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            double distanceOffBottomCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0) * capsule3D.getRadius();
            Vector3D translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)distanceOffBottomCenter);
            pointInside = new Point3D();
            pointInside.add((Tuple3DReadOnly)capsule3D.getBottomCenter(), (Tuple3DReadOnly)translation);
            Assertions.assertTrue((boolean)capsule3D.isPointInside((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Vector3D orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D();
            direction.interpolate((Tuple3DReadOnly)capsule3D.getAxis(), (Tuple3DReadOnly)orthogonalToAxis2, random.nextDouble());
            direction.normalize();
            double distanceOffTopCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)2.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffTopCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getTopCenter());
            Assertions.assertFalse((boolean)capsule3D.isPointInside((Point3DReadOnly)pointOutside));
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Vector3D orthogonalToAxis3 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D((Tuple3DReadOnly)capsule3D.getAxis());
            direction.negate();
            direction.interpolate((Tuple3DReadOnly)orthogonalToAxis3, random.nextDouble());
            direction.normalize();
            double distanceOffBottomCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)2.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffBottomCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getBottomCenter());
            Assertions.assertFalse((boolean)capsule3D.isPointInside((Point3DReadOnly)pointOutside));
        }
    }

    @Test
    void testEvaluatePoint3DCollision() throws Exception {
        double distanceOffBottomCenter;
        double distanceOffTopCenter;
        Vector3D direction;
        Vector3D orthogonalToAxis;
        Point3D pointOutside;
        Point3D pointInside;
        double distanceOffAxis;
        Vector3D orthogonalToAxis2;
        Point3D pointOnAxis;
        Capsule3D capsule3D;
        int i;
        Random random = new Random(675654L);
        Point3D actualClosestPoint = new Point3D();
        Vector3D actualNormal = new Vector3D();
        Point3D expectedClosestPoint = new Point3D();
        Vector3D expectedNormal = new Vector3D();
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)capsule3D.getTopCenter(), (Tuple3DReadOnly)capsule3D.getBottomCenter(), random.nextDouble());
            Assertions.assertTrue((boolean)capsule3D.evaluatePoint3DCollision((Point3DReadOnly)pointOnAxis, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            Assertions.assertFalse((boolean)actualClosestPoint.containsNaN());
            Assertions.assertFalse((boolean)actualNormal.containsNaN());
            capsule3D.evaluatePoint3DCollision((Point3DReadOnly)actualClosestPoint, (Point3DBasics)expectedClosestPoint, (Vector3DBasics)expectedNormal);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Assertions.assertTrue((boolean)capsule3D.evaluatePoint3DCollision(capsule3D.getTopCenter(), (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            Assertions.assertFalse((boolean)actualClosestPoint.containsNaN());
            Assertions.assertFalse((boolean)actualNormal.containsNaN());
            capsule3D.evaluatePoint3DCollision((Point3DReadOnly)actualClosestPoint, (Point3DBasics)expectedClosestPoint, (Vector3DBasics)expectedNormal);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Assertions.assertTrue((boolean)capsule3D.evaluatePoint3DCollision(capsule3D.getBottomCenter(), (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            Assertions.assertFalse((boolean)actualClosestPoint.containsNaN());
            Assertions.assertFalse((boolean)actualNormal.containsNaN());
            capsule3D.evaluatePoint3DCollision((Point3DReadOnly)actualClosestPoint, (Point3DBasics)expectedClosestPoint, (Vector3DBasics)expectedNormal);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)capsule3D.getTopCenter(), (Tuple3DReadOnly)capsule3D.getBottomCenter(), random.nextDouble());
            orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)capsule3D.getRadius());
            pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            expectedClosestPoint.scaleAdd(capsule3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            expectedNormal.setAndNormalize((Tuple3DReadOnly)orthogonalToAxis2);
            Assertions.assertTrue((boolean)capsule3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)capsule3D.getTopCenter(), (Tuple3DReadOnly)capsule3D.getBottomCenter(), random.nextDouble());
            orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            expectedClosestPoint.scaleAdd(capsule3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            expectedNormal.setAndNormalize((Tuple3DReadOnly)orthogonalToAxis2);
            Assertions.assertFalse((boolean)capsule3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D();
            direction.interpolate((Tuple3DReadOnly)capsule3D.getAxis(), (Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffTopCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0) * capsule3D.getRadius();
            pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffTopCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getTopCenter());
            expectedClosestPoint.scaleAdd(capsule3D.getRadius(), (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getTopCenter());
            expectedNormal.set((Tuple3DReadOnly)direction);
            Assertions.assertTrue((boolean)capsule3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D((Tuple3DReadOnly)capsule3D.getAxis());
            direction.negate();
            direction.interpolate((Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffBottomCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0) * capsule3D.getRadius();
            pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffBottomCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getBottomCenter());
            expectedClosestPoint.scaleAdd(capsule3D.getRadius(), (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getBottomCenter());
            expectedNormal.set((Tuple3DReadOnly)direction);
            Assertions.assertTrue((boolean)capsule3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D();
            direction.interpolate((Tuple3DReadOnly)capsule3D.getAxis(), (Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffTopCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)2.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffTopCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getTopCenter());
            expectedClosestPoint.scaleAdd(capsule3D.getRadius(), (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getTopCenter());
            expectedNormal.set((Tuple3DReadOnly)direction);
            Assertions.assertFalse((boolean)capsule3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D((Tuple3DReadOnly)capsule3D.getAxis());
            direction.negate();
            direction.interpolate((Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffBottomCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)2.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffBottomCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getBottomCenter());
            expectedClosestPoint.scaleAdd(capsule3D.getRadius(), (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getBottomCenter());
            expectedNormal.set((Tuple3DReadOnly)direction);
            Assertions.assertFalse((boolean)capsule3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedClosestPoint, (EuclidGeometry)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedNormal, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
    }

    @Test
    void testApplyTransform() {
        RigidBodyTransform transform;
        Capsule3D expected;
        Capsule3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            expected = new Capsule3D((Capsule3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPosition().applyTransform((Transform)transform);
            expected.getAxis().applyTransform((Transform)transform);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            expected = new Capsule3D((Capsule3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPosition().applyTransform((Transform)transform);
            expected.getAxis().applyTransform((Transform)transform);
            expected.getAxis().normalize();
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    void testApplyInverseTransform() {
        RigidBodyTransform transform;
        Capsule3D expected;
        Capsule3D original;
        Capsule3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            original = new Capsule3D((Capsule3DReadOnly)actual);
            expected = new Capsule3D((Capsule3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPosition().applyInverseTransform((Transform)transform);
            expected.getAxis().applyInverseTransform((Transform)transform);
            expected.getAxis().normalize();
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            original = new Capsule3D((Capsule3DReadOnly)actual);
            expected = new Capsule3D((Capsule3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPosition().applyInverseTransform((Transform)transform);
            expected.getAxis().applyInverseTransform((Transform)transform);
            expected.getAxis().normalize();
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    void testDistance() throws Exception {
        double distanceOffBottomCenter;
        double distanceOffTopCenter;
        Vector3D direction;
        Vector3D orthogonalToAxis;
        Point3D pointOutside;
        Point3D pointInside;
        double distanceOffAxis;
        Vector3D orthogonalToAxis2;
        Point3D pointOnAxis;
        Capsule3D capsule3D;
        int i;
        Random random = new Random(4305973L);
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)capsule3D.getTopCenter(), (Tuple3DReadOnly)capsule3D.getTopCenter(), random.nextDouble());
            orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)capsule3D.getRadius());
            pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            Assertions.assertEquals((double)0.0, (double)capsule3D.distance((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)capsule3D.getTopCenter(), (Tuple3DReadOnly)capsule3D.getTopCenter(), random.nextDouble());
            orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            Assertions.assertEquals((double)(distanceOffAxis - capsule3D.getRadius()), (double)capsule3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D();
            direction.interpolate((Tuple3DReadOnly)capsule3D.getAxis(), (Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffTopCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0) * capsule3D.getRadius();
            pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffTopCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getTopCenter());
            Assertions.assertEquals((double)0.0, (double)capsule3D.distance((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D((Tuple3DReadOnly)capsule3D.getAxis());
            direction.negate();
            direction.interpolate((Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffBottomCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0) * capsule3D.getRadius();
            pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffBottomCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getBottomCenter());
            Assertions.assertEquals((double)0.0, (double)capsule3D.distance((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D();
            direction.interpolate((Tuple3DReadOnly)capsule3D.getAxis(), (Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffTopCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)2.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffTopCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getTopCenter());
            Assertions.assertEquals((double)(distanceOffTopCenter - capsule3D.getRadius()), (double)capsule3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D((Tuple3DReadOnly)capsule3D.getAxis());
            direction.negate();
            direction.interpolate((Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffBottomCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)2.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffBottomCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getBottomCenter());
            Assertions.assertEquals((double)(distanceOffBottomCenter - capsule3D.getRadius()), (double)capsule3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
    }

    @Test
    void testSignedDistance() throws Exception {
        double distanceOffBottomCenter;
        double distanceOffTopCenter;
        Vector3D direction;
        Vector3D orthogonalToAxis;
        Point3D pointOutside;
        Point3D pointInside;
        double distanceOffAxis;
        Vector3D orthogonalToAxis2;
        Point3D pointOnAxis;
        Capsule3D capsule3D;
        int i;
        Random random = new Random(94753L);
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)capsule3D.getTopCenter(), (Tuple3DReadOnly)capsule3D.getTopCenter(), random.nextDouble());
            orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)capsule3D.getRadius());
            pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            Assertions.assertEquals((double)(distanceOffAxis - capsule3D.getRadius()), (double)capsule3D.signedDistance((Point3DReadOnly)pointInside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)capsule3D.getTopCenter(), (Tuple3DReadOnly)capsule3D.getTopCenter(), random.nextDouble());
            orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            Assertions.assertEquals((double)(distanceOffAxis - capsule3D.getRadius()), (double)capsule3D.signedDistance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D();
            direction.interpolate((Tuple3DReadOnly)capsule3D.getAxis(), (Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffTopCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0) * capsule3D.getRadius();
            pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffTopCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getTopCenter());
            Assertions.assertEquals((double)(distanceOffTopCenter - capsule3D.getRadius()), (double)capsule3D.signedDistance((Point3DReadOnly)pointInside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D((Tuple3DReadOnly)capsule3D.getAxis());
            direction.negate();
            direction.interpolate((Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffBottomCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0) * capsule3D.getRadius();
            pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffBottomCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getBottomCenter());
            Assertions.assertEquals((double)(distanceOffBottomCenter - capsule3D.getRadius()), (double)capsule3D.signedDistance((Point3DReadOnly)pointInside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D();
            direction.interpolate((Tuple3DReadOnly)capsule3D.getAxis(), (Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffTopCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)2.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffTopCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getTopCenter());
            Assertions.assertEquals((double)(distanceOffTopCenter - capsule3D.getRadius()), (double)capsule3D.signedDistance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D((Tuple3DReadOnly)capsule3D.getAxis());
            direction.negate();
            direction.interpolate((Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffBottomCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)2.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffBottomCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getBottomCenter());
            Assertions.assertEquals((double)(distanceOffBottomCenter - capsule3D.getRadius()), (double)capsule3D.signedDistance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
    }

    @Test
    void testOrthogonalProjection() throws Exception {
        double distanceOffBottomCenter;
        double distanceOffTopCenter;
        Vector3D direction;
        Vector3D orthogonalToAxis;
        Point3D pointOutside;
        Point3D pointInside;
        double distanceOffAxis;
        Vector3D orthogonalToAxis2;
        Point3D pointOnAxis;
        Capsule3D capsule3D;
        int i;
        Random random = new Random(4867L);
        Point3D expectedProjection = new Point3D();
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)capsule3D.getTopCenter(), (Tuple3DReadOnly)capsule3D.getTopCenter(), random.nextDouble());
            orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)capsule3D.getRadius());
            pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            Assertions.assertNull((Object)capsule3D.orthogonalProjectionCopy((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            pointOnAxis = new Point3D();
            pointOnAxis.interpolate((Tuple3DReadOnly)capsule3D.getTopCenter(), (Tuple3DReadOnly)capsule3D.getTopCenter(), random.nextDouble());
            orthogonalToAxis2 = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            distanceOffAxis = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffAxis, (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            expectedProjection.scaleAdd(capsule3D.getRadius(), (Tuple3DReadOnly)orthogonalToAxis2, (Tuple3DReadOnly)pointOnAxis);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)capsule3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D();
            direction.interpolate((Tuple3DReadOnly)capsule3D.getAxis(), (Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffTopCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0) * capsule3D.getRadius();
            pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffTopCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getTopCenter());
            Assertions.assertNull((Object)capsule3D.orthogonalProjectionCopy((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D((Tuple3DReadOnly)capsule3D.getAxis());
            direction.negate();
            direction.interpolate((Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffBottomCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0) * capsule3D.getRadius();
            pointInside = new Point3D();
            pointInside.scaleAdd(distanceOffBottomCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getBottomCenter());
            Assertions.assertNull((Object)capsule3D.orthogonalProjectionCopy((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D();
            direction.interpolate((Tuple3DReadOnly)capsule3D.getAxis(), (Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffTopCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)2.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffTopCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getTopCenter());
            expectedProjection.scaleAdd(capsule3D.getRadius(), (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getTopCenter());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)capsule3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            orthogonalToAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)capsule3D.getAxis(), (boolean)true);
            direction = new Vector3D((Tuple3DReadOnly)capsule3D.getAxis());
            direction.negate();
            direction.interpolate((Tuple3DReadOnly)orthogonalToAxis, random.nextDouble());
            direction.normalize();
            distanceOffBottomCenter = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)2.0) * capsule3D.getRadius();
            pointOutside = new Point3D();
            pointOutside.scaleAdd(distanceOffBottomCenter, (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getBottomCenter());
            expectedProjection.scaleAdd(capsule3D.getRadius(), (Tuple3DReadOnly)direction, (Tuple3DReadOnly)capsule3D.getBottomCenter());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedProjection, (EuclidGeometry)capsule3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
    }

    @Test
    void testGetSupportingVertex() throws Exception {
        Random random = new Random(546161L);
        for (int i = 0; i < 1000; ++i) {
            Capsule3D capsule = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Vector3D supportDirection = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3DReadOnly supportingVertex = capsule.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((boolean)capsule.isPointInside(supportingVertex, 1.0E-12));
            Point3D supportingVertexTranslated = new Point3D();
            supportDirection.normalize();
            supportingVertexTranslated.scaleAdd(1.0E-6, (Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)supportingVertex);
            Assertions.assertFalse((boolean)capsule.isPointInside((Point3DReadOnly)supportingVertexTranslated, 1.0E-12));
            Vector3D actualNormal = new Vector3D();
            capsule.evaluatePoint3DCollision((Point3DReadOnly)supportingVertexTranslated, (Point3DBasics)new Point3D(), (Vector3DBasics)actualNormal);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)supportDirection, (EuclidGeometry)actualNormal, (double)1.0E-12);
        }
    }

    @Test
    void testGetBoundingBox() throws Exception {
        Random random = new Random(36342L);
        for (int i = 0; i < 1000; ++i) {
            Capsule3D capsule3D = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            BoundingBox3D expectedBoundingBox = new BoundingBox3D();
            expectedBoundingBox.setToNaN();
            Vector3D supportDirection = new Vector3D((Tuple3DReadOnly)Axis3D.X);
            expectedBoundingBox.updateToIncludePoint(capsule3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(capsule3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Y);
            expectedBoundingBox.updateToIncludePoint(capsule3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(capsule3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Z);
            expectedBoundingBox.updateToIncludePoint(capsule3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(capsule3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            BoundingBox3DReadOnly actualBoundingBox = capsule3D.getBoundingBox();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedBoundingBox, (EuclidGeometry)actualBoundingBox, (double)1.0E-12);
        }
    }
}

