/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.impl.AbstractFace3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Vertex3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.BoxPolytope3DView;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class BoxPolytope3DTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testIntegrity() {
        Random random = new Random(897234L);
        for (int i = 0; i < 1000; ++i) {
            Box3D box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            BoxPolytope3DView boxPolytope = box3D.asConvexPolytope();
            EuclidShapeTestTools.assertConvexPolytope3DGeneralIntegrity((String)("Iteration " + i), (ConvexPolytope3DReadOnly)boxPolytope);
            Assertions.assertEquals((int)6, (int)boxPolytope.getNumberOfFaces());
            Assertions.assertEquals((int)12, (int)boxPolytope.getNumberOfEdges());
            Assertions.assertEquals((int)8, (int)boxPolytope.getNumberOfVertices());
            for (Face3DReadOnly face : boxPolytope.getFaces()) {
                Assertions.assertEquals((int)4, (int)face.getNumberOfEdges());
            }
            for (Vertex3DReadOnly vertex : boxPolytope.getVertices()) {
                Assertions.assertEquals((int)3, (int)vertex.getNumberOfAssociatedEdges());
            }
        }
    }

    @Test
    public void testAgainstConvexPolytope() {
        Random random = new Random(987345L);
        Box3D box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
        BoxPolytope3DView boxPolytope3D = box3D.asConvexPolytope();
        for (int i = 0; i < 1000; ++i) {
            switch (random.nextInt(3)) {
                case 0: {
                    box3D.set((Box3DReadOnly)EuclidShapeRandomTools.nextBox3D((Random)random));
                    break;
                }
                case 1: {
                    box3D.getPose().set((RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
                    break;
                }
                case 2: {
                    box3D.getSize().set((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0));
                }
            }
            ConvexPolytope3D convexPolytope3D = new ConvexPolytope3D();
            for (int vertexIndex = 0; vertexIndex < 8; ++vertexIndex) {
                Point3D vertex = new Point3D();
                vertex.set((vertexIndex & 1) == 0 ? box3D.getSizeX() : -box3D.getSizeX(), (vertexIndex & 2) == 0 ? box3D.getSizeY() : -box3D.getSizeY(), (vertexIndex & 4) == 0 ? box3D.getSizeZ() : -box3D.getSizeZ());
                vertex.scale(0.5);
                box3D.transformToWorld((Transformable)vertex);
                convexPolytope3D.addVertex((Point3DReadOnly)vertex);
            }
            Assertions.assertEquals((double)boxPolytope3D.getVolume(), (double)convexPolytope3D.getVolume(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)convexPolytope3D.getCentroid(), (EuclidGeometry)boxPolytope3D.getCentroid(), (double)1.0E-12);
            for (Face3DReadOnly boxFace : boxPolytope3D.getFaces()) {
                AbstractFace3D polytopeFace = convexPolytope3D.getClosestFace(boxFace.getCentroid());
                EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)boxFace.getCentroid(), (Point3DReadOnly)boxFace.getCentroid(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)boxFace.getNormal(), (Vector3DReadOnly)boxFace.getNormal(), (double)1.0E-12);
                for (Vertex3DReadOnly boxVertex : boxFace.getVertices()) {
                    Assertions.assertEquals((long)1L, (long)polytopeFace.getVertices().stream().filter(polytopeVertex -> polytopeVertex.epsilonEquals((EuclidGeometry)boxVertex, 1.0E-12)).count());
                }
            }
        }
    }
}

