/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.rotationConversion;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.rotationConversion.RotationVectorConversion;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;

public class YawPitchRollConversionTest {
    private static final double EPSILON = 1.0E-12;
    private static final double MAX_PITCH_ANGLE = YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE - 1.0E-12;
    private static final double MIN_PITCH_ANGLE = YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE + 1.0E-12;

    @Test
    public void testMatrixToYawPitchRoll() throws Exception {
        RotationMatrix matrix = new RotationMatrix();
        YawPitchRoll actualYawPitchRoll = new YawPitchRoll();
        Vector3D actualEulerAngles = new Vector3D();
        double deltaAngle = 0.15707963267948966;
        for (double yaw = -Math.PI; yaw <= Math.PI; yaw += deltaAngle) {
            for (double roll = -Math.PI; roll <= Math.PI; roll += deltaAngle) {
                for (double pitch = -1.5707963267948966; pitch <= 1.5707963267948966; pitch += deltaAngle) {
                    RotationMatrixConversion.convertYawPitchRollToMatrix((double)yaw, (double)pitch, (double)roll, (CommonMatrix3DBasics)matrix);
                    double actualYaw = YawPitchRollConversion.computeYawImpl((double)matrix.getM00(), (double)matrix.getM10());
                    Assertions.assertEquals((double)yaw, (double)actualYaw, (double)1.0E-12);
                    double actualPitch = YawPitchRollConversion.computePitchImpl((double)matrix.getM20());
                    Assertions.assertEquals((double)pitch, (double)actualPitch, (double)1.0E-12);
                    double actualRoll = YawPitchRollConversion.computeRollImpl((double)matrix.getM21(), (double)matrix.getM22());
                    Assertions.assertEquals((double)roll, (double)actualRoll, (double)1.0E-12);
                    actualYaw = YawPitchRollConversion.computeYaw((RotationMatrixReadOnly)matrix);
                    Assertions.assertEquals((double)yaw, (double)actualYaw, (double)1.0E-12);
                    actualPitch = YawPitchRollConversion.computePitch((RotationMatrixReadOnly)matrix);
                    Assertions.assertEquals((double)pitch, (double)actualPitch, (double)1.0E-12);
                    actualRoll = YawPitchRollConversion.computeRoll((RotationMatrixReadOnly)matrix);
                    Assertions.assertEquals((double)roll, (double)actualRoll, (double)1.0E-12);
                    YawPitchRollConversion.convertMatrixToYawPitchRoll((RotationMatrixReadOnly)matrix, (YawPitchRollBasics)actualYawPitchRoll);
                    Assertions.assertEquals((double)yaw, (double)actualYawPitchRoll.getYaw(), (double)1.0E-12);
                    Assertions.assertEquals((double)pitch, (double)actualYawPitchRoll.getPitch(), (double)1.0E-12);
                    Assertions.assertEquals((double)roll, (double)actualYawPitchRoll.getRoll(), (double)1.0E-12);
                    YawPitchRollConversion.convertMatrixToYawPitchRoll((RotationMatrixReadOnly)matrix, (Tuple3DBasics)actualEulerAngles);
                    Assertions.assertEquals((double)yaw, (double)actualEulerAngles.getZ(), (double)1.0E-12);
                    Assertions.assertEquals((double)pitch, (double)actualEulerAngles.getY(), (double)1.0E-12);
                    Assertions.assertEquals((double)roll, (double)actualEulerAngles.getX(), (double)1.0E-12);
                }
            }
        }
        double actualYaw = YawPitchRollConversion.computeYawImpl((double)1.0, (double)0.0);
        Assertions.assertTrue((actualYaw == 0.0 ? 1 : 0) != 0);
        actualYaw = YawPitchRollConversion.computeYawImpl((double)Double.NaN, (double)0.0);
        Assertions.assertTrue((boolean)Double.isNaN(actualYaw));
        actualYaw = YawPitchRollConversion.computeYawImpl((double)0.0, (double)Double.NaN);
        Assertions.assertTrue((boolean)Double.isNaN(actualYaw));
        double actualPitch = YawPitchRollConversion.computePitchImpl((double)0.0);
        Assertions.assertTrue((actualPitch == 0.0 ? 1 : 0) != 0);
        actualPitch = YawPitchRollConversion.computePitchImpl((double)Double.NaN);
        Assertions.assertTrue((boolean)Double.isNaN(actualPitch));
        double actualRoll = YawPitchRollConversion.computeRollImpl((double)0.0, (double)1.0);
        Assertions.assertTrue((actualRoll == 0.0 ? 1 : 0) != 0);
        actualRoll = YawPitchRollConversion.computeRollImpl((double)Double.NaN, (double)0.0);
        Assertions.assertTrue((boolean)Double.isNaN(actualRoll));
        actualRoll = YawPitchRollConversion.computeRollImpl((double)0.0, (double)Double.NaN);
        Assertions.assertTrue((boolean)Double.isNaN(actualRoll));
    }

    @Test
    public void testQuaternionToYawPitchRoll() throws Exception {
        Quaternion quaternion = new Quaternion();
        YawPitchRoll actualYawPitchRoll = new YawPitchRoll();
        Vector3D actualEulerAngles = new Vector3D();
        double deltaAngle = 0.15707963267948966;
        for (double yaw = -Math.PI; yaw <= Math.PI; yaw += deltaAngle) {
            for (double roll = -Math.PI; roll <= Math.PI; roll += deltaAngle) {
                double pitch;
                double epsilon;
                double alpha;
                for (alpha = 0.0; alpha <= 1.0; alpha += 0.1) {
                    double pitch2 = EuclidCoreTools.interpolate((double)MIN_PITCH_ANGLE, (double)MAX_PITCH_ANGLE, (double)alpha);
                    this.assertQuaternionToYawPitchRoll(yaw, pitch2, roll, 1.0E-12);
                }
                for (alpha = 0.0; alpha <= 1.0; alpha += 0.1) {
                    epsilon = EuclidCoreTools.interpolate((double)1.0E-12, (double)0.001, (double)alpha);
                    pitch = EuclidCoreTools.interpolate((double)MAX_PITCH_ANGLE, (double)1.5707963267938965, (double)alpha);
                    this.assertQuaternionToYawPitchRoll(yaw, pitch, roll, epsilon);
                }
                for (alpha = 0.0; alpha <= 1.0; alpha += 0.1) {
                    epsilon = EuclidCoreTools.interpolate((double)1.0E-12, (double)0.001, (double)alpha);
                    pitch = EuclidCoreTools.interpolate((double)MIN_PITCH_ANGLE, (double)-1.5707963267938965, (double)alpha);
                    this.assertQuaternionToYawPitchRoll(yaw, pitch, roll, epsilon);
                }
            }
        }
        Random random = new Random(239478L);
        for (double yaw = -Math.PI; yaw <= Math.PI; yaw += deltaAngle) {
            for (double roll = -Math.PI; roll <= Math.PI; roll += deltaAngle) {
                for (double pitch = MIN_PITCH_ANGLE; pitch <= MAX_PITCH_ANGLE; pitch += deltaAngle) {
                    QuaternionConversion.convertYawPitchRollToQuaternion((double)yaw, (double)pitch, (double)roll, (QuaternionBasics)quaternion);
                    double randomScale = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
                    quaternion.setUnsafe(quaternion.getX() * randomScale, quaternion.getY() * randomScale, quaternion.getZ() * randomScale, quaternion.getS() * randomScale);
                    double actualYaw = YawPitchRollConversion.computeYaw((QuaternionReadOnly)quaternion);
                    EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualYaw, (double)1.0E-12);
                    double actualPitch = YawPitchRollConversion.computePitch((QuaternionReadOnly)quaternion);
                    Assertions.assertEquals((double)pitch, (double)actualPitch, (double)1.0E-12);
                    double actualRoll = YawPitchRollConversion.computeRoll((QuaternionReadOnly)quaternion);
                    EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualRoll, (double)1.0E-12);
                    YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (YawPitchRollBasics)actualYawPitchRoll);
                    EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualYawPitchRoll.getYaw(), (double)1.0E-12);
                    Assertions.assertEquals((double)pitch, (double)actualYawPitchRoll.getPitch(), (double)1.0E-12);
                    EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualYawPitchRoll.getRoll(), (double)1.0E-12);
                    YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (Tuple3DBasics)actualEulerAngles);
                    EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualEulerAngles.getZ(), (double)1.0E-12);
                    Assertions.assertEquals((double)pitch, (double)actualEulerAngles.getY(), (double)1.0E-12);
                    EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualEulerAngles.getX(), (double)1.0E-12);
                }
            }
        }
        quaternion.setUnsafe(0.0, 0.0, 0.0, 0.0);
        double actualYaw = YawPitchRollConversion.computeYaw((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((actualYaw == 0.0 ? 1 : 0) != 0);
        double actualPitch = YawPitchRollConversion.computePitch((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((actualPitch == 0.0 ? 1 : 0) != 0);
        double actualRoll = YawPitchRollConversion.computeRoll((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((actualRoll == 0.0 ? 1 : 0) != 0);
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (YawPitchRollBasics)actualYawPitchRoll);
        Assertions.assertTrue((actualYawPitchRoll.getYaw() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((actualYawPitchRoll.getPitch() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((actualYawPitchRoll.getRoll() == 0.0 ? 1 : 0) != 0);
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (Tuple3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualEulerAngles);
        quaternion.setUnsafe(Double.NaN, 0.0, 0.0, 0.0);
        actualYaw = YawPitchRollConversion.computeYaw((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((boolean)Double.isNaN(actualYaw));
        actualPitch = YawPitchRollConversion.computePitch((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((boolean)Double.isNaN(actualPitch));
        actualRoll = YawPitchRollConversion.computeRoll((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((boolean)Double.isNaN(actualRoll));
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (YawPitchRollBasics)actualYawPitchRoll);
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getYaw()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getPitch()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getRoll()));
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (Tuple3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualEulerAngles);
        quaternion.setUnsafe(0.0, Double.NaN, 0.0, 0.0);
        actualYaw = YawPitchRollConversion.computeYaw((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((boolean)Double.isNaN(actualYaw));
        actualPitch = YawPitchRollConversion.computePitch((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((boolean)Double.isNaN(actualPitch));
        actualRoll = YawPitchRollConversion.computeRoll((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((boolean)Double.isNaN(actualRoll));
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (YawPitchRollBasics)actualYawPitchRoll);
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getYaw()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getPitch()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getRoll()));
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (Tuple3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualEulerAngles);
        quaternion.setUnsafe(0.0, 0.0, Double.NaN, 0.0);
        actualYaw = YawPitchRollConversion.computeYaw((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((boolean)Double.isNaN(actualYaw));
        actualPitch = YawPitchRollConversion.computePitch((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((boolean)Double.isNaN(actualPitch));
        actualRoll = YawPitchRollConversion.computeRoll((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((boolean)Double.isNaN(actualRoll));
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (YawPitchRollBasics)actualYawPitchRoll);
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getYaw()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getPitch()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getRoll()));
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (Tuple3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualEulerAngles);
        quaternion.setUnsafe(0.0, 0.0, 0.0, Double.NaN);
        actualYaw = YawPitchRollConversion.computeYaw((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((boolean)Double.isNaN(actualYaw));
        actualPitch = YawPitchRollConversion.computePitch((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((boolean)Double.isNaN(actualPitch));
        actualRoll = YawPitchRollConversion.computeRoll((QuaternionReadOnly)quaternion);
        Assertions.assertTrue((boolean)Double.isNaN(actualRoll));
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (YawPitchRollBasics)actualYawPitchRoll);
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getYaw()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getPitch()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getRoll()));
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (Tuple3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualEulerAngles);
    }

    public void assertQuaternionToYawPitchRoll(double yaw, double pitch, double roll, double epsilon) {
        Quaternion quaternion = new Quaternion();
        YawPitchRoll actualYawPitchRoll = new YawPitchRoll();
        Vector3D actualEulerAngles = new Vector3D();
        QuaternionConversion.convertYawPitchRollToQuaternion((double)yaw, (double)pitch, (double)roll, (QuaternionBasics)quaternion);
        double qx = quaternion.getX();
        double qy = quaternion.getY();
        double qz = quaternion.getZ();
        double qs = quaternion.getS();
        double actualYaw = YawPitchRollConversion.computeYawFromQuaternionImpl((double)qx, (double)qy, (double)qz, (double)qs);
        EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualYaw, (double)epsilon);
        double actualPitch = YawPitchRollConversion.computePitchFromQuaternionImpl((double)qx, (double)qy, (double)qz, (double)qs);
        Assertions.assertEquals((double)pitch, (double)actualPitch, (double)epsilon);
        double actualRoll = YawPitchRollConversion.computeRollFromQuaternionImpl((double)qx, (double)qy, (double)qz, (double)qs);
        EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualRoll, (double)epsilon);
        actualYaw = YawPitchRollConversion.computeYaw((QuaternionReadOnly)quaternion);
        EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualYaw, (double)epsilon);
        actualPitch = YawPitchRollConversion.computePitch((QuaternionReadOnly)quaternion);
        Assertions.assertEquals((double)pitch, (double)actualPitch, (double)epsilon);
        actualRoll = YawPitchRollConversion.computeRoll((QuaternionReadOnly)quaternion);
        EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualRoll, (double)epsilon);
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (YawPitchRollBasics)actualYawPitchRoll);
        EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualYawPitchRoll.getYaw(), (double)epsilon);
        Assertions.assertEquals((double)pitch, (double)actualYawPitchRoll.getPitch(), (double)epsilon);
        EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualYawPitchRoll.getRoll(), (double)epsilon);
        YawPitchRollConversion.convertQuaternionToYawPitchRoll((QuaternionReadOnly)quaternion, (Tuple3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualEulerAngles.getZ(), (double)epsilon);
        Assertions.assertEquals((double)pitch, (double)actualEulerAngles.getY(), (double)epsilon);
        EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualEulerAngles.getX(), (double)epsilon);
    }

    @Test
    public void testAxisAngleToYawPitchRoll() throws Exception {
        AxisAngle axisAngle = new AxisAngle();
        YawPitchRoll actualYawPitchRoll = new YawPitchRoll();
        Vector3D actualEulerAngles = new Vector3D();
        double deltaAngle = 0.15707963267948966;
        for (double yaw = -Math.PI; yaw <= Math.PI; yaw += deltaAngle) {
            for (double roll = -Math.PI; roll <= Math.PI; roll += deltaAngle) {
                double pitch;
                double epsilon;
                double alpha;
                for (alpha = 0.0; alpha <= 1.0; alpha += 0.1) {
                    double pitch2 = EuclidCoreTools.interpolate((double)MIN_PITCH_ANGLE, (double)MAX_PITCH_ANGLE, (double)alpha);
                    this.assertAxisAngleToYawPitchRoll(yaw, pitch2, roll, 1.0E-12);
                }
                for (alpha = 0.0; alpha <= 1.0; alpha += 0.1) {
                    epsilon = EuclidCoreTools.interpolate((double)1.0E-12, (double)0.001, (double)alpha);
                    pitch = EuclidCoreTools.interpolate((double)MAX_PITCH_ANGLE, (double)1.5707963267938965, (double)alpha);
                    this.assertAxisAngleToYawPitchRoll(yaw, pitch, roll, epsilon);
                }
                for (alpha = 0.0; alpha <= 1.0; alpha += 0.1) {
                    epsilon = EuclidCoreTools.interpolate((double)1.0E-12, (double)0.001, (double)alpha);
                    pitch = EuclidCoreTools.interpolate((double)MIN_PITCH_ANGLE, (double)-1.5707963267938965, (double)alpha);
                    this.assertAxisAngleToYawPitchRoll(yaw, pitch, roll, epsilon);
                }
            }
        }
        Random random = new Random(239478L);
        for (double yaw = -Math.PI; yaw <= Math.PI; yaw += deltaAngle) {
            for (double roll = -Math.PI; roll <= Math.PI; roll += deltaAngle) {
                for (double pitch = MIN_PITCH_ANGLE; pitch <= MAX_PITCH_ANGLE; pitch += deltaAngle) {
                    AxisAngleConversion.convertYawPitchRollToAxisAngle((double)yaw, (double)pitch, (double)roll, (AxisAngleBasics)axisAngle);
                    double randomScale = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
                    axisAngle.setX(axisAngle.getX() * randomScale);
                    axisAngle.setY(axisAngle.getY() * randomScale);
                    axisAngle.setZ(axisAngle.getZ() * randomScale);
                    double actualYaw = YawPitchRollConversion.computeYaw((AxisAngleReadOnly)axisAngle);
                    EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualYaw, (double)1.0E-12);
                    double actualPitch = YawPitchRollConversion.computePitch((AxisAngleReadOnly)axisAngle);
                    Assertions.assertEquals((double)pitch, (double)actualPitch, (double)1.0E-12);
                    double actualRoll = YawPitchRollConversion.computeRoll((AxisAngleReadOnly)axisAngle);
                    EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualRoll, (double)1.0E-12);
                    YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)axisAngle, (YawPitchRollBasics)actualYawPitchRoll);
                    EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualYawPitchRoll.getYaw(), (double)1.0E-12);
                    Assertions.assertEquals((double)pitch, (double)actualYawPitchRoll.getPitch(), (double)1.0E-12);
                    EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualYawPitchRoll.getRoll(), (double)1.0E-12);
                    YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)axisAngle, (Tuple3DBasics)actualEulerAngles);
                    EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualEulerAngles.getZ(), (double)1.0E-12);
                    Assertions.assertEquals((double)pitch, (double)actualEulerAngles.getY(), (double)1.0E-12);
                    EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualEulerAngles.getX(), (double)1.0E-12);
                }
            }
        }
        axisAngle.set(Double.NaN, 0.0, 0.0, 1.0);
        double actualYaw = YawPitchRollConversion.computeYaw((AxisAngleReadOnly)axisAngle);
        Assertions.assertTrue((boolean)Double.isNaN(actualYaw));
        double actualPitch = YawPitchRollConversion.computePitch((AxisAngleReadOnly)axisAngle);
        Assertions.assertTrue((boolean)Double.isNaN(actualPitch));
        double actualRoll = YawPitchRollConversion.computeRoll((AxisAngleReadOnly)axisAngle);
        Assertions.assertTrue((boolean)Double.isNaN(actualRoll));
        YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)axisAngle, (YawPitchRollBasics)actualYawPitchRoll);
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getYaw()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getPitch()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getRoll()));
        YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)axisAngle, (Tuple3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualEulerAngles);
        axisAngle.set(0.0, Double.NaN, 0.0, 1.0);
        actualYaw = YawPitchRollConversion.computeYaw((AxisAngleReadOnly)axisAngle);
        Assertions.assertTrue((boolean)Double.isNaN(actualYaw));
        actualPitch = YawPitchRollConversion.computePitch((AxisAngleReadOnly)axisAngle);
        Assertions.assertTrue((boolean)Double.isNaN(actualPitch));
        actualRoll = YawPitchRollConversion.computeRoll((AxisAngleReadOnly)axisAngle);
        Assertions.assertTrue((boolean)Double.isNaN(actualRoll));
        YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)axisAngle, (YawPitchRollBasics)actualYawPitchRoll);
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getYaw()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getPitch()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getRoll()));
        YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)axisAngle, (Tuple3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualEulerAngles);
        axisAngle.set(0.0, 0.0, Double.NaN, 1.0);
        actualYaw = YawPitchRollConversion.computeYaw((AxisAngleReadOnly)axisAngle);
        Assertions.assertTrue((boolean)Double.isNaN(actualYaw));
        actualPitch = YawPitchRollConversion.computePitch((AxisAngleReadOnly)axisAngle);
        Assertions.assertTrue((boolean)Double.isNaN(actualPitch));
        actualRoll = YawPitchRollConversion.computeRoll((AxisAngleReadOnly)axisAngle);
        Assertions.assertTrue((boolean)Double.isNaN(actualRoll));
        YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)axisAngle, (YawPitchRollBasics)actualYawPitchRoll);
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getYaw()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getPitch()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getRoll()));
        YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)axisAngle, (Tuple3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualEulerAngles);
        axisAngle.set(0.0, 0.0, 0.0, Double.NaN);
        actualYaw = YawPitchRollConversion.computeYaw((AxisAngleReadOnly)axisAngle);
        Assertions.assertTrue((boolean)Double.isNaN(actualYaw));
        actualPitch = YawPitchRollConversion.computePitch((AxisAngleReadOnly)axisAngle);
        Assertions.assertTrue((boolean)Double.isNaN(actualPitch));
        actualRoll = YawPitchRollConversion.computeRoll((AxisAngleReadOnly)axisAngle);
        Assertions.assertTrue((boolean)Double.isNaN(actualRoll));
        YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)axisAngle, (YawPitchRollBasics)actualYawPitchRoll);
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getYaw()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getPitch()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getRoll()));
        YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)axisAngle, (Tuple3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualEulerAngles);
    }

    public void assertAxisAngleToYawPitchRoll(double yaw, double pitch, double roll, double epsilon) {
        AxisAngle axisAngle = new AxisAngle();
        YawPitchRoll actualYawPitchRoll = new YawPitchRoll();
        Vector3D actualEulerAngles = new Vector3D();
        AxisAngleConversion.convertYawPitchRollToAxisAngle((double)yaw, (double)pitch, (double)roll, (AxisAngleBasics)axisAngle);
        double ux = axisAngle.getX();
        double uy = axisAngle.getY();
        double uz = axisAngle.getZ();
        double angle = axisAngle.getAngle();
        double actualYaw = YawPitchRollConversion.computeYawFromAxisAngleImpl((double)ux, (double)uy, (double)uz, (double)angle);
        EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualYaw, (double)epsilon);
        double actualPitch = YawPitchRollConversion.computePitchFromAxisAngleImpl((double)ux, (double)uy, (double)uz, (double)angle);
        Assertions.assertEquals((double)pitch, (double)actualPitch, (double)epsilon);
        double actualRoll = YawPitchRollConversion.computeRollFromAxisAngleImpl((double)ux, (double)uy, (double)uz, (double)angle);
        EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualRoll, (double)epsilon);
        actualYaw = YawPitchRollConversion.computeYaw((AxisAngleReadOnly)axisAngle);
        EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualYaw, (double)epsilon);
        actualPitch = YawPitchRollConversion.computePitch((AxisAngleReadOnly)axisAngle);
        Assertions.assertEquals((double)pitch, (double)actualPitch, (double)epsilon);
        actualRoll = YawPitchRollConversion.computeRoll((AxisAngleReadOnly)axisAngle);
        EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualRoll, (double)epsilon);
        YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)axisAngle, (YawPitchRollBasics)actualYawPitchRoll);
        EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualYawPitchRoll.getYaw(), (double)epsilon);
        Assertions.assertEquals((double)pitch, (double)actualYawPitchRoll.getPitch(), (double)epsilon);
        EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualYawPitchRoll.getRoll(), (double)epsilon);
        YawPitchRollConversion.convertAxisAngleToYawPitchRoll((AxisAngleReadOnly)axisAngle, (Tuple3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualEulerAngles.getZ(), (double)epsilon);
        Assertions.assertEquals((double)pitch, (double)actualEulerAngles.getY(), (double)epsilon);
        EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualEulerAngles.getX(), (double)epsilon);
    }

    @Test
    public void testRotationVectorToYawPitchRoll() throws Exception {
        Vector3D rotationVector = new Vector3D();
        YawPitchRoll actualYawPitchRoll = new YawPitchRoll();
        Vector3D actualEulerAngles = new Vector3D();
        double deltaAngle = 0.15707963267948966;
        for (double yaw = -Math.PI; yaw <= Math.PI; yaw += deltaAngle) {
            for (double roll = -Math.PI; roll <= Math.PI; roll += deltaAngle) {
                double pitch;
                double epsilon;
                double alpha;
                for (alpha = 0.0; alpha <= 1.0; alpha += 0.1) {
                    double pitch2 = EuclidCoreTools.interpolate((double)MIN_PITCH_ANGLE, (double)MAX_PITCH_ANGLE, (double)alpha);
                    this.assertRotationVectorToYawPitchRoll(yaw, pitch2, roll, 1.0E-12);
                }
                for (alpha = 0.0; alpha <= 1.0; alpha += 0.1) {
                    epsilon = EuclidCoreTools.interpolate((double)1.0E-12, (double)0.001, (double)alpha);
                    pitch = EuclidCoreTools.interpolate((double)MAX_PITCH_ANGLE, (double)1.5707963267938965, (double)alpha);
                    this.assertRotationVectorToYawPitchRoll(yaw, pitch, roll, epsilon);
                }
                for (alpha = 0.0; alpha <= 1.0; alpha += 0.1) {
                    epsilon = EuclidCoreTools.interpolate((double)1.0E-12, (double)0.001, (double)alpha);
                    pitch = EuclidCoreTools.interpolate((double)MIN_PITCH_ANGLE, (double)-1.5707963267938965, (double)alpha);
                    this.assertRotationVectorToYawPitchRoll(yaw, pitch, roll, epsilon);
                }
            }
        }
        rotationVector.setX(0.0);
        rotationVector.setY(0.0);
        rotationVector.setZ(0.0);
        double actualYaw = YawPitchRollConversion.computeYaw((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((actualYaw == 0.0 ? 1 : 0) != 0);
        double actualPitch = YawPitchRollConversion.computePitch((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((actualPitch == 0.0 ? 1 : 0) != 0);
        double actualRoll = YawPitchRollConversion.computeRoll((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((actualRoll == 0.0 ? 1 : 0) != 0);
        YawPitchRollConversion.convertRotationVectorToYawPitchRoll((Vector3DReadOnly)rotationVector, (YawPitchRollBasics)actualYawPitchRoll);
        Assertions.assertTrue((actualYawPitchRoll.getYaw() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((actualYawPitchRoll.getPitch() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((actualYawPitchRoll.getRoll() == 0.0 ? 1 : 0) != 0);
        YawPitchRollConversion.convertRotationVectorToYawPitchRoll((Vector3DReadOnly)rotationVector, (Vector3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)actualEulerAngles);
        rotationVector.set(Double.NaN, 0.0, 0.0);
        actualYaw = YawPitchRollConversion.computeYaw((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((boolean)Double.isNaN(actualYaw));
        actualPitch = YawPitchRollConversion.computePitch((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((boolean)Double.isNaN(actualPitch));
        actualRoll = YawPitchRollConversion.computeRoll((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((boolean)Double.isNaN(actualRoll));
        YawPitchRollConversion.convertRotationVectorToYawPitchRoll((Vector3DReadOnly)rotationVector, (YawPitchRollBasics)actualYawPitchRoll);
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getYaw()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getPitch()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getRoll()));
        YawPitchRollConversion.convertRotationVectorToYawPitchRoll((Vector3DReadOnly)rotationVector, (Vector3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualEulerAngles);
        rotationVector.set(0.0, Double.NaN, 0.0);
        actualYaw = YawPitchRollConversion.computeYaw((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((boolean)Double.isNaN(actualYaw));
        actualPitch = YawPitchRollConversion.computePitch((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((boolean)Double.isNaN(actualPitch));
        actualRoll = YawPitchRollConversion.computeRoll((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((boolean)Double.isNaN(actualRoll));
        YawPitchRollConversion.convertRotationVectorToYawPitchRoll((Vector3DReadOnly)rotationVector, (YawPitchRollBasics)actualYawPitchRoll);
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getYaw()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getPitch()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getRoll()));
        YawPitchRollConversion.convertRotationVectorToYawPitchRoll((Vector3DReadOnly)rotationVector, (Vector3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualEulerAngles);
        rotationVector.set(0.0, 0.0, Double.NaN);
        actualYaw = YawPitchRollConversion.computeYaw((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((boolean)Double.isNaN(actualYaw));
        actualPitch = YawPitchRollConversion.computePitch((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((boolean)Double.isNaN(actualPitch));
        actualRoll = YawPitchRollConversion.computeRoll((Vector3DReadOnly)rotationVector);
        Assertions.assertTrue((boolean)Double.isNaN(actualRoll));
        YawPitchRollConversion.convertRotationVectorToYawPitchRoll((Vector3DReadOnly)rotationVector, (YawPitchRollBasics)actualYawPitchRoll);
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getYaw()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getPitch()));
        Assertions.assertTrue((boolean)Double.isNaN(actualYawPitchRoll.getRoll()));
        YawPitchRollConversion.convertRotationVectorToYawPitchRoll((Vector3DReadOnly)rotationVector, (Vector3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualEulerAngles);
    }

    public void assertRotationVectorToYawPitchRoll(double yaw, double pitch, double roll, double epsilon) {
        Vector3D rotationVector = new Vector3D();
        Vector3D rotationVectorCopy = new Vector3D();
        YawPitchRoll actualYawPitchRoll = new YawPitchRoll();
        Vector3D actualEulerAngles = new Vector3D();
        RotationVectorConversion.convertYawPitchRollToRotationVector((double)yaw, (double)pitch, (double)roll, (Vector3DBasics)rotationVector);
        rotationVectorCopy.set((Tuple3DReadOnly)rotationVector);
        double actualYaw = YawPitchRollConversion.computeYaw((Vector3DReadOnly)rotationVector);
        EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualYaw, (double)epsilon);
        Assertions.assertTrue((boolean)rotationVector.equals((EuclidGeometry)rotationVectorCopy));
        double actualPitch = YawPitchRollConversion.computePitch((Vector3DReadOnly)rotationVector);
        Assertions.assertEquals((double)pitch, (double)actualPitch, (double)epsilon);
        Assertions.assertTrue((boolean)rotationVector.equals((EuclidGeometry)rotationVectorCopy));
        double actualRoll = YawPitchRollConversion.computeRoll((Vector3DReadOnly)rotationVector);
        EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualRoll, (double)epsilon);
        Assertions.assertTrue((boolean)rotationVector.equals((EuclidGeometry)rotationVectorCopy));
        YawPitchRollConversion.convertRotationVectorToYawPitchRoll((Vector3DReadOnly)rotationVector, (YawPitchRollBasics)actualYawPitchRoll);
        EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualYawPitchRoll.getYaw(), (double)epsilon);
        Assertions.assertEquals((double)pitch, (double)actualYawPitchRoll.getPitch(), (double)epsilon);
        EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualYawPitchRoll.getRoll(), (double)epsilon);
        Assertions.assertTrue((boolean)rotationVector.equals((EuclidGeometry)rotationVectorCopy));
        YawPitchRollConversion.convertRotationVectorToYawPitchRoll((Vector3DReadOnly)rotationVector, (Vector3DBasics)actualEulerAngles);
        EuclidCoreTestTools.assertAngleEquals((double)yaw, (double)actualEulerAngles.getZ(), (double)epsilon);
        Assertions.assertEquals((double)pitch, (double)actualEulerAngles.getY(), (double)epsilon);
        EuclidCoreTestTools.assertAngleEquals((double)roll, (double)actualEulerAngles.getX(), (double)epsilon);
        Assertions.assertTrue((boolean)rotationVector.equals((EuclidGeometry)rotationVectorCopy));
    }
}

