/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.EuclidMutationTesting;
import us.ihmc.euclid.EuclidTestConstants;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class ReferenceFrameTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testIssue12() {
        ReferenceFrame constantFrame;
        RigidBodyTransform actual;
        RigidBodyTransform expected;
        int i;
        Random random = new Random(43563L);
        ReferenceFrame world = ReferenceFrameTools.getWorldFrame();
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            actual = new RigidBodyTransform();
            constantFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)("constant" + i), (ReferenceFrame)world, (RigidBodyTransformReadOnly)expected);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)constantFrame.getTransformToParent(), (double)1.0E-12);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)constantFrame.getTransformToDesiredFrame(world), (double)1.0E-12);
            constantFrame.getTransformToParent(actual);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            constantFrame.getTransformToDesiredFrame(actual, world);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            actual = new RigidBodyTransform();
            constantFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformFromParent((String)("constant" + i), (ReferenceFrame)world, (RigidBodyTransformReadOnly)expected);
            expected.invert();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)constantFrame.getTransformToParent(), (double)1.0E-12);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)constantFrame.getTransformToDesiredFrame(world), (double)1.0E-12);
            constantFrame.getTransformToParent(actual);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            constantFrame.getTransformToDesiredFrame(actual, world);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testChildrenFramesAreGarbageCollected() throws Exception {
        boolean verbose = false;
        Random random = new Random(543L);
        Runtime runtime = Runtime.getRuntime();
        int numberOfTests = 10;
        double averageUsedMemoryInMB = 0.0;
        ReferenceFrameTest.runGarbageCollector();
        for (int i = 0; i < numberOfTests; ++i) {
            ReferenceFrameTest.runGarbageCollector();
            long usedMemoryStart = runtime.totalMemory() - runtime.freeMemory() >> 20;
            EuclidFrameRandomTools.nextReferenceFrameTree((Random)random, (int)100000);
            ReferenceFrameTest.runGarbageCollector();
            long usedMemoryEnd = runtime.totalMemory() - runtime.freeMemory() >> 20;
            long difference = usedMemoryEnd - usedMemoryStart;
            if (verbose) {
                System.out.println("(In MB) usedMemoryStart: " + usedMemoryStart + ", usedMemoryEnd: " + usedMemoryEnd + ", used: " + difference);
            }
            averageUsedMemoryInMB += (double)difference;
        }
        Assertions.assertTrue(((averageUsedMemoryInMB /= (double)numberOfTests) < 1.0 ? 1 : 0) != 0);
    }

    private static void runGarbageCollector() {
        System.gc();
        System.runFinalization();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static RandomlyChangingFrame[] nextRandomlyChangingFrameTree(Random random, int numberOfReferenceFrames) {
        return ReferenceFrameTest.nextRandomlyChangingFrameTree("randomFrame", random, numberOfReferenceFrames);
    }

    private static RandomlyChangingFrame[] nextRandomlyChangingFrameTree(String frameNamePrefix, Random random, int numberOfReferenceFrames) {
        return ReferenceFrameTest.nextRandomlyChangingFrameTree(frameNamePrefix, random, worldFrame, numberOfReferenceFrames);
    }

    private static RandomlyChangingFrame[] nextRandomlyChangingFrameTree(String frameNamePrefix, Random random, ReferenceFrame rootFrame, int numberOfReferenceFrames) {
        RandomlyChangingFrame[] referenceFrames = new RandomlyChangingFrame[numberOfReferenceFrames];
        ReferenceFrame[] referenceFramesWithRoot = new ReferenceFrame[numberOfReferenceFrames + 1];
        referenceFramesWithRoot[0] = rootFrame;
        for (int i = 0; i < numberOfReferenceFrames; ++i) {
            RandomlyChangingFrame randomlyChangingFrame;
            int parentFrameIndex = random.nextInt(i + 1);
            ReferenceFrame parentFrame = referenceFramesWithRoot[parentFrameIndex];
            referenceFrames[i] = randomlyChangingFrame = new RandomlyChangingFrame(frameNamePrefix + i, parentFrame, random);
            referenceFramesWithRoot[i + 1] = randomlyChangingFrame;
        }
        return referenceFrames;
    }

    @Test
    public void testTypicalExample() {
        Random random = new Random(87L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] treeFrame = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame frameA = treeFrame[random.nextInt(treeFrame.length)];
            ReferenceFrame frameB = treeFrame[random.nextInt(treeFrame.length)];
            RigidBodyTransform shouldBeIdentity = new RigidBodyTransform((RigidBodyTransformReadOnly)frameB.getTransformToDesiredFrame(frameA));
            shouldBeIdentity.multiply((RigidBodyTransformReadOnly)frameA.getTransformToDesiredFrame(frameB));
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)new RigidBodyTransform(), (EuclidGeometry)shouldBeIdentity, (double)1.0E-12);
        }
    }

    @Test
    public void testGetTransformToParents() {
        Random random = new Random(87L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] treeFrame = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame frame = treeFrame[random.nextInt(treeFrame.length)];
            this.checkRepInvariants(frame);
            ReferenceFrame parent = frame.getParent();
            if (parent == null) continue;
            RigidBodyTransform transformToParentOne = frame.getTransformToParent();
            RigidBodyTransform transformToParentTwo = frame.getTransformToDesiredFrame(parent);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)transformToParentOne, (EuclidGeometry)transformToParentTwo, (double)1.0E-12);
            RigidBodyTransform transformToParentThree = parent.getTransformToDesiredFrame(frame);
            transformToParentThree.invert();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)transformToParentOne, (EuclidGeometry)transformToParentThree, (double)1.0E-12);
        }
    }

    private void checkRepInvariants(ReferenceFrame frame) {
        ReferenceFrame parent;
        int branchLength;
        List<ReferenceFrame> framesStartingWithRootEndingWithThis = Arrays.asList(frame.getFramesStartingWithRootEndingWithThis());
        if (framesStartingWithRootEndingWithThis.get((branchLength = framesStartingWithRootEndingWithThis.size()) - 1) != frame) {
            Assertions.fail((String)"This must be the last frame in the chain.");
        }
        if ((parent = frame.getParent()) == null) {
            if (branchLength != 1) {
                Assertions.fail((String)"If the parentFrame is null, then this must be a root frame, in which there should be only one frame in the chain.");
            }
            try {
                frame.getTransformToParent();
                Assertions.fail((String)"Root frames don't have transformToParent or transformToRoot defined.");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (frame.getTransformToRoot() != null) {
                Assertions.fail((String)"Root frames don't have transformToParent or transformToRoot defined.");
            }
            if (frame.transformToRootID != 0L) {
                System.err.println("this ReferenceFrame = " + this);
                Assertions.fail((String)("transformToRootID = " + frame.transformToRootID + ", Root frames must not be updated."));
            }
        } else {
            if (framesStartingWithRootEndingWithThis.get(branchLength - 2) != parent) {
                Assertions.fail((String)"The parent must be the second to last frame in the chain.");
            }
            long maxIdSoFar = 0L;
            RigidBodyTransform computedTransformToRoot = new RigidBodyTransform();
            for (int i = 1; i < branchLength; ++i) {
                ReferenceFrame frameInTree = framesStartingWithRootEndingWithThis.get(i);
                computedTransformToRoot.multiply((RigidBodyTransformReadOnly)frameInTree.getTransformToParent());
                long id = frameInTree.transformToRootID;
                if (id < maxIdSoFar) break;
                maxIdSoFar = id;
                if (frameInTree.getTransformToRoot().epsilonEquals((EuclidGeometry)computedTransformToRoot, 1.0E-5)) continue;
                System.err.println("frame.transformToRoot = " + frameInTree.getTransformToRoot() + ", computedTransformToRoot = " + computedTransformToRoot);
                System.err.println("this = " + this + " frame = " + frameInTree);
                Assertions.fail((String)"transformToRoot is inconsistent!!");
            }
        }
    }

    @Test
    public void testGetTransformToRoots() {
        ReferenceFrame[] treeFrame;
        int i;
        Random random = new Random(453L);
        for (i = 0; i < 1000; ++i) {
            treeFrame = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame frame = treeFrame[random.nextInt(treeFrame.length)];
            RigidBodyTransform transformToRootOne = frame.getTransformToDesiredFrame(worldFrame);
            this.verifyTransformToRootByClimbingTree(frame, transformToRootOne);
        }
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame anotherRoot = ReferenceFrameTools.constructARootFrame((String)"anotherRoot");
            ReferenceFrame[] treeFrame2 = EuclidFrameRandomTools.nextReferenceFrameTree((String)"blop", (Random)random, (ReferenceFrame)anotherRoot, (int)20);
            ReferenceFrame frame = treeFrame2[random.nextInt(treeFrame2.length)];
            RigidBodyTransform transformToRootOne = frame.getTransformToDesiredFrame(anotherRoot);
            this.verifyTransformToRootByClimbingTree(frame, transformToRootOne);
        }
        for (i = 0; i < 1000; ++i) {
            treeFrame = ReferenceFrameTest.nextRandomlyChangingFrameTree(random, 100);
            int numberOfRandomUpdates = random.nextInt(treeFrame.length / 2) + 1;
            for (int j = 0; j < numberOfRandomUpdates; ++j) {
                treeFrame[random.nextInt(treeFrame.length)].update();
            }
            for (ReferenceFrame frame : treeFrame) {
                this.verifyTransformToRootByClimbingTree(frame, frame.getTransformToRoot());
            }
        }
    }

    @Test
    public void getTransformToSelf() {
        Random random = new Random(453L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] treeFrame = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame frame = treeFrame[random.nextInt(treeFrame.length)];
            RigidBodyTransform transformToSelf = frame.getTransformToDesiredFrame(frame);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)new RigidBodyTransform(), (EuclidGeometry)transformToSelf, (double)1.0E-12);
        }
    }

    @Test
    public void testGetTransformBetweenFrames() {
        Random random = new Random(1776L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] treeFrame = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame frame1 = treeFrame[random.nextInt(treeFrame.length)];
            ReferenceFrame frame2 = treeFrame[random.nextInt(treeFrame.length)];
            RigidBodyTransform transformOne = frame1.getTransformToDesiredFrame(frame2);
            RigidBodyTransform transformTwo = frame2.getTransformToDesiredFrame(frame1);
            transformTwo.invert();
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)transformOne, (EuclidGeometry)transformTwo, (double)1.0E-12);
            RigidBodyTransform transformThree = new RigidBodyTransform();
            if (frame2.getTransformToRoot() != null) {
                transformThree.setAndInvert((RigidBodyTransformReadOnly)frame2.getTransformToRoot());
            }
            if (frame1.getTransformToRoot() != null) {
                transformThree.multiply((RigidBodyTransformReadOnly)frame1.getTransformToRoot());
            }
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)transformOne, (EuclidGeometry)transformThree, (double)1.0E-12);
            RigidBodyTransform transformFour = new RigidBodyTransform();
            transformFour.set((RigidBodyTransformReadOnly)worldFrame.getTransformToDesiredFrame(frame2));
            transformFour.multiply((RigidBodyTransformReadOnly)frame1.getTransformToDesiredFrame(worldFrame));
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)transformOne, (EuclidGeometry)transformFour, (double)1.0E-12);
            ReferenceFrame frame3 = treeFrame[random.nextInt(treeFrame.length)];
            RigidBodyTransform transformFive = new RigidBodyTransform();
            transformFive.set((RigidBodyTransformReadOnly)frame3.getTransformToDesiredFrame(frame2));
            transformFive.multiply((RigidBodyTransformReadOnly)frame1.getTransformToDesiredFrame(frame3));
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)transformOne, (EuclidGeometry)transformFive, (double)1.0E-12);
        }
    }

    private void verifyTransformToRootByClimbingTree(ReferenceFrame frame, RigidBodyTransform transformToRootOne) {
        RigidBodyTransform transformToRootTwo = this.getTransformToDesiredAncestorByClimbingTree(frame, null);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)transformToRootOne, (EuclidGeometry)transformToRootTwo, (double)1.0E-12);
    }

    private RigidBodyTransform getTransformToDesiredAncestorByClimbingTree(ReferenceFrame frame, ReferenceFrame desiredFrame) {
        ReferenceFrame parent;
        RigidBodyTransform ret = new RigidBodyTransform();
        ReferenceFrame nextFrame = frame;
        while ((parent = nextFrame.getParent()) != null) {
            RigidBodyTransform transformToParent = nextFrame.getTransformToParent();
            RigidBodyTransform transform = new RigidBodyTransform((RigidBodyTransformReadOnly)transformToParent);
            transform.multiply((RigidBodyTransformReadOnly)ret);
            ret.set((RigidBodyTransformReadOnly)transform);
            nextFrame = parent;
            if (nextFrame != desiredFrame) continue;
            break;
        }
        return ret;
    }

    @Test
    public void testTransformFromHereToDesiredFrame() throws Exception {
        Random random = new Random(9825L);
        for (int i = 0; i < 1000; ++i) {
            Point3D original = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D expected = new Point3D((Tuple3DReadOnly)original);
            Point3D actual = new Point3D((Tuple3DReadOnly)expected);
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame desiredFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            RigidBodyTransform transform = initialFrame.getTransformToDesiredFrame(desiredFrame);
            transform.transform((Point3DBasics)expected);
            initialFrame.transformFromThisToDesiredFrame(desiredFrame, (Transformable)actual);
            EuclidCoreTestTools.assertEquals((String)("Iteration #" + i), (EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
            desiredFrame.transformFromThisToDesiredFrame(initialFrame, (Transformable)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)original, (EuclidGeometry)actual, (double)1.0E-12);
            ReferenceFrame differentRootFrame = ReferenceFrameTools.constructARootFrame((String)"anotherRootFrame");
            try {
                initialFrame.transformFromThisToDesiredFrame(differentRootFrame, (Transformable)actual);
                Assertions.fail((String)"Should have thrown a RuntimeException");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testUniqueFrameIndex() {
        Random random = new Random(84358345L);
        HashSet<Long> existingIds = new HashSet<Long>();
        ReferenceFrameTools.clearWorldFrameTree();
        Assertions.assertEquals((long)0L, (long)ReferenceFrameTools.getWorldFrame().getFrameIndex());
        existingIds.add(0L);
        ArrayList<Long> frameIndices = new ArrayList<Long>();
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame frameToClear;
            ReferenceFrame[] frameTree;
            for (ReferenceFrame referenceFrame : frameTree = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random)) {
                if (referenceFrame == ReferenceFrameTools.getWorldFrame()) continue;
                long frameIndex = referenceFrame.getFrameIndex();
                Assertions.assertFalse((boolean)existingIds.contains(frameIndex), (String)("Already has ID " + frameIndex));
                existingIds.add(frameIndex);
                frameIndices.add(frameIndex);
            }
            if (!random.nextBoolean() || (frameToClear = frameTree[random.nextInt(frameTree.length)]) == ReferenceFrameTools.getWorldFrame()) continue;
            frameToClear.clearChildren();
        }
        ReferenceFrameTools.clearWorldFrameTree();
        random = new Random(84358345L);
        Assertions.assertEquals((long)0L, (long)ReferenceFrameTools.getWorldFrame().getFrameIndex());
        int position = 0;
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] frameTree;
            for (ReferenceFrame referenceFrame : frameTree = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random)) {
                if (referenceFrame == ReferenceFrameTools.getWorldFrame()) continue;
                long frameIndex = referenceFrame.getFrameIndex();
                Assertions.assertEquals((Long)((Long)frameIndices.get(position++)), (long)frameIndex);
            }
        }
    }

    @Disabled
    @Test
    public void testUniqueNaming() {
        Random random = new Random(13L);
        ReferenceFrame someFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        String frameName = someFrame.getName();
        ReferenceFrame parent = someFrame.getParent();
        try {
            ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)frameName, (ReferenceFrame)parent, (RigidBodyTransformReadOnly)new RigidBodyTransform());
            Assertions.fail((String)"Should have thrown a RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        someFrame.remove();
        someFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)frameName, (ReferenceFrame)parent, (RigidBodyTransformReadOnly)new RigidBodyTransform());
        someFrame.remove();
        someFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)frameName, (ReferenceFrame)parent, (RigidBodyTransformReadOnly)new RigidBodyTransform());
        ReferenceFrameTools.clearFrameTree((ReferenceFrame)someFrame);
        someFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)frameName, (ReferenceFrame)parent, (RigidBodyTransformReadOnly)new RigidBodyTransform());
        ReferenceFrameTools.clearWorldFrameTree();
        ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)frameName, (ReferenceFrame)parent, (RigidBodyTransformReadOnly)new RigidBodyTransform());
    }

    @Deprecated
    @Test
    public void testDisabeling() throws InstantiationException, IllegalAccessException {
        Random random = new Random(314114L);
        ReferenceFrame[] someFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
        ReferenceFrame frameToDisable = someFrames[random.nextInt(someFrames.length - 1) + 1];
        ReferenceFrame[] moreChildren = EuclidFrameRandomTools.nextReferenceFrameTree((String)"AdditionalChild", (Random)random, (ReferenceFrame)frameToDisable, (int)10);
        frameToDisable.remove();
        ReferenceFrameTest.checkDisabled(frameToDisable);
        for (ReferenceFrame child : moreChildren) {
            ReferenceFrameTest.checkDisabled(child);
        }
    }

    private static void checkDisabled(ReferenceFrame frame) throws InstantiationException, IllegalAccessException {
        Method[] methods;
        for (Method method : methods = ReferenceFrame.class.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass() != ReferenceFrame.class) continue;
            int numberOfParameters = method.getParameterTypes().length;
            if (method.getName().equals("remove") && numberOfParameters == 0) continue;
            Object[] parameters = new Object[numberOfParameters];
            for (int paramIdx = 0; paramIdx < numberOfParameters; ++paramIdx) {
                Class<?> parameterClass = method.getParameterTypes()[paramIdx];
                if (!parameterClass.isPrimitive()) continue;
                parameters[paramIdx] = 0;
            }
            try {
                method.invoke((Object)frame, parameters);
                Assertions.fail((String)("Should have thrown a RuntimeException on " + method.getName()));
            }
            catch (Exception e) {
                if (e.getCause() instanceof RuntimeException) continue;
                Assertions.fail((String)("There was an exception in " + method.getName() + " but expected a RuntimeException."));
            }
        }
    }

    @Test
    public void testEfficientComputeTransformMultiThreaded() {
        Random random = new Random(343L);
        int numberOfFrames = 100;
        ReferenceFrame[] frames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random, (int)numberOfFrames);
        Thread mainThread = Thread.currentThread();
        ReferenceFrame.getWorldFrame().setTreeUpdateCondition(f -> Thread.currentThread() == mainThread);
        IntStream.range(0, 10000000).parallel().forEach(i -> {
            ++ReferenceFrame.nextTransformToRootID;
            ReferenceFrame.getWorldFrame().update();
            frames[random.nextInt(numberOfFrames)].getTransformToRoot();
        });
    }

    public static void main(String[] args) {
        String targetTests = EuclidTestConstants.class.getName();
        String targetClasses = ReferenceFrame.class.getName() + " " + ReferenceFrameTools.class.getName();
        EuclidMutationTesting.doPITMutationTestAndOpenResult(targetTests, targetClasses);
    }

    private static class RandomlyChangingFrame
    extends ReferenceFrame {
        private final Random random;
        private final RigidBodyTransform randomTransform = new RigidBodyTransform();

        public RandomlyChangingFrame(String frameName, ReferenceFrame parentFrame, Random random) {
            super(frameName, parentFrame);
            this.random = random;
        }

        protected void updateTransformToParent(RigidBodyTransform transformToParent) {
            this.randomTransform.set((RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)this.random));
            transformToParent.set((RigidBodyTransformReadOnly)this.randomTransform);
        }
    }
}

