/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2DBasicsTest;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class FrameConvexPolygon2DTest
extends FrameConvexPolygon2DBasicsTest<FrameConvexPolygon2D> {
    @Override
    public FrameConvexPolygon2D createFrameConvexPolygon2D(ReferenceFrame referenceFrame, Vertex2DSupplier vertex2DSupplier) {
        return new FrameConvexPolygon2D(referenceFrame, vertex2DSupplier);
    }

    @Test
    public void testIssue16() {
        Random random = new Random(342L);
        ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        FrameConvexPolygon2D firstPolygon = EuclidFrameRandomTools.nextFrameConvexPolygon2D((Random)random, (ReferenceFrame)frameA, (double)1.0, (int)10);
        FrameConvexPolygon2D secondPolygon = new FrameConvexPolygon2D(frameB);
        firstPolygon.setIncludingFrame((FrameVertex2DSupplier)secondPolygon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)firstPolygon, (EuclidGeometry)secondPolygon, (double)1.0E-15);
        frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        frameB = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        firstPolygon = EuclidFrameRandomTools.nextFrameConvexPolygon2D((Random)random, (ReferenceFrame)frameA, (double)1.0, (int)10);
        secondPolygon = new FrameConvexPolygon2D(frameB);
        FrameConvexPolygon2D thirdPolygon = new FrameConvexPolygon2D(frameB);
        firstPolygon.setIncludingFrame((FrameVertex2DSupplier)secondPolygon, (FrameVertex2DSupplier)thirdPolygon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)firstPolygon, (EuclidGeometry)secondPolygon, (double)1.0E-15);
    }

    @Test
    public void testIssue17() throws Exception {
        FrameConvexPolygon2D polygon;
        FramePoint2D pointB;
        FramePoint2D pointA;
        ReferenceFrame frame;
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            frame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            pointA = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)frame, (double)10.0);
            pointB = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)frame, (double)10.0);
            polygon = new FrameConvexPolygon2D(frame);
            polygon.addVertex((FramePoint2DReadOnly)pointA);
            polygon.addVertex((FramePoint2DReadOnly)pointA);
            polygon.addVertex((FramePoint2DReadOnly)pointB);
            polygon.addVertex((FramePoint2DReadOnly)pointB);
            Assertions.assertFalse((boolean)pointA.epsilonEquals((EuclidFrameGeometry)pointB, 1.0E-7));
            polygon.update();
            Assertions.assertEquals((int)2, (int)polygon.getNumberOfVertices());
            if (polygon.getVertex(0).equals((EuclidFrameGeometry)pointA)) {
                Assertions.assertEquals((Object)polygon.getVertex(1), (Object)pointB);
                continue;
            }
            Assertions.assertEquals((Object)polygon.getVertex(0), (Object)pointB);
            Assertions.assertEquals((Object)polygon.getVertex(1), (Object)pointA);
        }
        for (i = 0; i < 1000; ++i) {
            frame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            pointA = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)frame, (double)10.0);
            pointB = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)frame, (double)10.0);
            polygon = new FrameConvexPolygon2D(frame);
            polygon.addVertex((FramePoint2DReadOnly)pointA);
            polygon.addVertex((FramePoint2DReadOnly)pointB);
            polygon.addVertex((FramePoint2DReadOnly)pointA);
            polygon.addVertex((FramePoint2DReadOnly)pointB);
            Assertions.assertFalse((boolean)pointA.epsilonEquals((EuclidFrameGeometry)pointB, 1.0E-7));
            polygon.update();
            Assertions.assertEquals((int)2, (int)polygon.getNumberOfVertices());
            if (polygon.getVertex(0).equals((EuclidFrameGeometry)pointA)) {
                Assertions.assertEquals((Object)polygon.getVertex(1), (Object)pointB);
                continue;
            }
            Assertions.assertEquals((Object)polygon.getVertex(0), (Object)pointB);
            Assertions.assertEquals((Object)polygon.getVertex(1), (Object)pointA);
        }
    }

    @Override
    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{ConvexPolygon2D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{ConvexPolygon2D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{ConvexPolygon2D.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameConvexPolygon2D.class, ConvexPolygon2D.class, true, 1, methodFilter);
    }

    @Test
    public void testAddVertexMatchingFrame() throws Exception {
        FramePoint2D expected;
        FrameConvexPolygon2D polygon;
        FramePoint3D newVertex;
        ReferenceFrame frameB;
        int i;
        Random random = new Random(23423L);
        for (i = 0; i < 1000; ++i) {
            boolean useTransform2D = random.nextBoolean();
            ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)useTransform2D);
            ReferenceFrame frameB2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)useTransform2D);
            FramePoint2D newVertex2 = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)frameA);
            FrameConvexPolygon2D polygon2 = (FrameConvexPolygon2D)this.createEmptyFrameConvexPolygon2D(frameB2);
            polygon2.addVertexMatchingFrame(newVertex2.getReferenceFrame(), (Point2DReadOnly)newVertex2, useTransform2D);
            FramePoint2D expected2 = new FramePoint2D(frameB2);
            newVertex2.changeFrameAndProjectToXYPlane(frameB2);
            expected2.set((FrameTuple2DReadOnly)newVertex2);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected2, (EuclidGeometry)polygon2.getVertexUnsafe(0), (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameB = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            newVertex = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)frameA);
            polygon = (FrameConvexPolygon2D)this.createEmptyFrameConvexPolygon2D(frameB);
            polygon.addVertexMatchingFrame(newVertex.getReferenceFrame(), (Point3DReadOnly)newVertex);
            expected = new FramePoint2D(frameB);
            newVertex.changeFrame(frameB);
            expected.set((FrameTuple3DReadOnly)newVertex);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)polygon.getVertexUnsafe(0), (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameB = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            newVertex = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)frameA);
            polygon = (FrameConvexPolygon2D)this.createEmptyFrameConvexPolygon2D(frameB);
            polygon.addVertexMatchingFrame((FramePoint3DReadOnly)newVertex);
            expected = new FramePoint2D(frameB);
            newVertex.changeFrame(frameB);
            expected.set((FrameTuple3DReadOnly)newVertex);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected, (EuclidGeometry)polygon.getVertexUnsafe(0), (double)1.0E-15);
        }
    }

    @Test
    public void testSetMatchingFrame() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameConvexPolygon2D, m -> true, 10);
        Random random = new Random(544354L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            ReferenceFrame destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            FrameConvexPolygon2D source = EuclidFrameRandomTools.nextFrameConvexPolygon2D((Random)random, (ReferenceFrame)sourceFrame, (double)1.0, (int)10);
            FrameConvexPolygon2D actual = EuclidFrameRandomTools.nextFrameConvexPolygon2D((Random)random, (ReferenceFrame)destinationFrame, (double)1.0, (int)10);
            actual.setMatchingFrame((FrameVertex2DSupplier)source, true);
            FrameConvexPolygon2D expected = new FrameConvexPolygon2D((FrameVertex2DSupplier)source);
            expected.changeFrame(destinationFrame);
            Assertions.assertTrue((boolean)expected.epsilonEquals((EuclidFrameGeometry)actual, 1.0E-15));
        }
    }

    @Test
    public void testSetIncludingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameConvexPolygon2D, 10);
    }
}

