/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.matrix;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.exceptions.SingularMatrixException;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.CommonMatrix3DBasicsTest;
import us.ihmc.euclid.matrix.LinearTransform3D;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public abstract class Matrix3DBasicsTest<T extends Matrix3DBasics>
extends CommonMatrix3DBasicsTest<T> {
    private static final double MID_EPS = 1.0E-10;

    @Test
    public void testSet() throws Exception {
        int row;
        int i;
        Random random = new Random(6345L);
        Matrix3DBasics actualMatrix = (Matrix3DBasics)this.createEmptyMatrix();
        for (int j = 0; j < 1000; ++j) {
            double m00 = random.nextDouble();
            double m01 = random.nextDouble();
            double m02 = random.nextDouble();
            double m10 = random.nextDouble();
            double m11 = random.nextDouble();
            double m12 = random.nextDouble();
            double m20 = random.nextDouble();
            double m21 = random.nextDouble();
            double m22 = random.nextDouble();
            actualMatrix.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            Assertions.assertTrue((m00 == actualMatrix.getM00() ? 1 : 0) != 0);
            Assertions.assertTrue((m01 == actualMatrix.getM01() ? 1 : 0) != 0);
            Assertions.assertTrue((m02 == actualMatrix.getM02() ? 1 : 0) != 0);
            Assertions.assertTrue((m10 == actualMatrix.getM10() ? 1 : 0) != 0);
            Assertions.assertTrue((m11 == actualMatrix.getM11() ? 1 : 0) != 0);
            Assertions.assertTrue((m12 == actualMatrix.getM12() ? 1 : 0) != 0);
            Assertions.assertTrue((m20 == actualMatrix.getM20() ? 1 : 0) != 0);
            Assertions.assertTrue((m21 == actualMatrix.getM21() ? 1 : 0) != 0);
            Assertions.assertTrue((m22 == actualMatrix.getM22() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Matrix3D expectedMatrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actualMatrix.set((Matrix3DReadOnly)expectedMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            RotationMatrix expectedMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actualMatrix.set((RotationMatrixReadOnly)expectedMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            LinearTransform3D expectedMatrix = EuclidCoreRandomTools.nextLinearTransform3D((Random)random);
            actualMatrix.set((Matrix3DReadOnly)expectedMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            Matrix3D expectedMatrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actualMatrix.set((Matrix3DReadOnly)expectedMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            double[] matrixArray = new double[9];
            for (int index = 0; index < 9; ++index) {
                matrixArray[index] = random.nextDouble();
            }
            actualMatrix.set(matrixArray);
            for (row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    Assertions.assertTrue((actualMatrix.getElement(row, column) == matrixArray[row * 3 + column] ? 1 : 0) != 0);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            DMatrixRMaj denseMatrix = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)3, (int)3);
            actualMatrix.set((DMatrix)denseMatrix);
            for (row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    Assertions.assertTrue((actualMatrix.getElement(row, column) == denseMatrix.get(row, column) ? 1 : 0) != 0);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            int startRow = random.nextInt(10);
            int startColumn = random.nextInt(10);
            DMatrixRMaj denseMatrix = EuclidCoreRandomTools.nextDMatrixRMaj((Random)random, (int)(3 + startRow), (int)(3 + startColumn));
            actualMatrix.set(startRow, startColumn, (DMatrix)denseMatrix);
            for (int row2 = 0; row2 < 3; ++row2) {
                for (int column = 0; column < 3; ++column) {
                    Assertions.assertTrue((actualMatrix.getElement(row2, column) == denseMatrix.get(row2 + startRow, column + startColumn) ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testSetToDiagonal() throws Exception {
        int col;
        int row;
        Matrix3DBasics matrix;
        int i;
        Random random = new Random(23423L);
        for (i = 0; i < 1000; ++i) {
            double m00 = random.nextDouble();
            double m11 = random.nextDouble();
            double m22 = random.nextDouble();
            matrix = (Matrix3DBasics)this.createRandomMatrix(random);
            matrix.setToDiagonal(m00, m11, m22);
            Assertions.assertTrue((matrix.getM00() == m00 ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM11() == m11 ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM22() == m22 ? 1 : 0) != 0);
            for (row = 0; row < 3; ++row) {
                for (col = 0; col < 3; ++col) {
                    if (row == col) continue;
                    Assertions.assertTrue((matrix.getElement(row, col) == 0.0 ? 1 : 0) != 0);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            double x = random.nextDouble();
            double y = random.nextDouble();
            double z = random.nextDouble();
            matrix = (Matrix3DBasics)this.createRandomMatrix(random);
            matrix.setToDiagonal((Tuple3DReadOnly)new Point3D(x, y, z));
            Assertions.assertTrue((matrix.getM00() == x ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM11() == y ? 1 : 0) != 0);
            Assertions.assertTrue((matrix.getM22() == z ? 1 : 0) != 0);
            for (row = 0; row < 3; ++row) {
                for (col = 0; col < 3; ++col) {
                    if (row == col) continue;
                    Assertions.assertTrue((matrix.getElement(row, col) == 0.0 ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testSetToTildeForm() {
        Random random = new Random(646L);
        Matrix3D tildeMatrix = new Matrix3D();
        Vector3D expected = new Vector3D();
        Vector3D actual = new Vector3D();
        for (int k = 0; k < 1000; ++k) {
            Vector3D vector1 = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D vector2 = EuclidCoreRandomTools.nextVector3D((Random)random);
            expected.cross((Tuple3DReadOnly)vector1, (Tuple3DReadOnly)vector2);
            tildeMatrix.setToTildeForm((Tuple3DReadOnly)vector1);
            tildeMatrix.transform((Tuple3DReadOnly)vector2, (Tuple3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testSetToYawPitchRollMatrix() {
        Random random = new Random(35454L);
        RotationMatrix rotationMatrix = new RotationMatrix();
        for (int i = 0; i < 1000; ++i) {
            Matrix3DBasics matrix = (Matrix3DBasics)this.createRandomMatrix(random);
            double pitch = random.nextDouble();
            matrix.setToNaN();
            rotationMatrix.setToNaN();
            matrix.setToPitchMatrix(pitch);
            RotationMatrixConversion.computePitchMatrix((double)pitch, (CommonMatrix3DBasics)rotationMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)rotationMatrix, (double)1.0E-12);
            double roll = random.nextDouble();
            matrix.setToNaN();
            rotationMatrix.setToNaN();
            matrix.setToRollMatrix(roll);
            RotationMatrixConversion.computeRollMatrix((double)roll, (CommonMatrix3DBasics)rotationMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)rotationMatrix, (double)1.0E-12);
            double yaw = random.nextDouble();
            matrix.setToNaN();
            rotationMatrix.setToNaN();
            matrix.setToYawMatrix(yaw);
            RotationMatrixConversion.computeYawMatrix((double)yaw, (CommonMatrix3DBasics)rotationMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrix, (Matrix3DReadOnly)rotationMatrix, (double)1.0E-12);
        }
    }

    @Test
    public void testAdd() {
        Random random = new Random(6345L);
        Matrix3D a = new Matrix3D();
        Matrix3D b = new Matrix3D();
        Matrix3DBasics c = (Matrix3DBasics)this.createEmptyMatrix();
        for (int p = 0; p < 1000; ++p) {
            double cij;
            double bij;
            double aij;
            int column;
            int row;
            c.setToNaN();
            a = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            b = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            c.set((Matrix3DReadOnly)a);
            c.add((Matrix3DReadOnly)b);
            for (row = 0; row < 3; ++row) {
                for (column = 0; column < 3; ++column) {
                    aij = a.getElement(row, column);
                    bij = b.getElement(row, column);
                    cij = c.getElement(row, column);
                    Assertions.assertEquals((double)(aij + bij), (double)cij, (double)1.0E-12);
                }
            }
            c.setToNaN();
            a = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            b = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            c.add((Matrix3DReadOnly)a, (Matrix3DReadOnly)b);
            for (row = 0; row < 3; ++row) {
                for (column = 0; column < 3; ++column) {
                    aij = a.getElement(row, column);
                    bij = b.getElement(row, column);
                    cij = c.getElement(row, column);
                    Assertions.assertEquals((double)(aij + bij), (double)cij, (double)1.0E-12);
                }
            }
        }
    }

    @Test
    public void testSub() {
        Random random = new Random(6345L);
        Matrix3D a = new Matrix3D();
        Matrix3D b = new Matrix3D();
        Matrix3DBasics c = (Matrix3DBasics)this.createEmptyMatrix();
        for (int p = 0; p < 1000; ++p) {
            double cij;
            double bij;
            double aij;
            int column;
            int row;
            c.setToNaN();
            a = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            b = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            c.set((Matrix3DReadOnly)a);
            c.sub((Matrix3DReadOnly)b);
            for (row = 0; row < 3; ++row) {
                for (column = 0; column < 3; ++column) {
                    aij = a.getElement(row, column);
                    bij = b.getElement(row, column);
                    cij = c.getElement(row, column);
                    Assertions.assertEquals((double)(aij - bij), (double)cij, (double)1.0E-12);
                }
            }
            c.setToNaN();
            a = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            b = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            c.sub((Matrix3DReadOnly)a, (Matrix3DReadOnly)b);
            for (row = 0; row < 3; ++row) {
                for (column = 0; column < 3; ++column) {
                    aij = a.getElement(row, column);
                    bij = b.getElement(row, column);
                    cij = c.getElement(row, column);
                    Assertions.assertEquals((double)(aij - bij), (double)cij, (double)1.0E-12);
                }
            }
        }
    }

    @Test
    public void testScale() {
        double sij;
        double mij;
        int row;
        double sij2;
        int column;
        int row2;
        int i;
        Random random = new Random(6345L);
        double scalar = Double.NaN;
        Matrix3D matrixOriginal = new Matrix3D();
        Matrix3DBasics scaledMatrix = (Matrix3DBasics)this.createEmptyMatrix();
        Vector3D scales = new Vector3D();
        for (i = 0; i < 1000; ++i) {
            matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            scalar = random.nextDouble();
            scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
            scaledMatrix.scale(scalar);
            for (row2 = 0; row2 < 3; ++row2) {
                for (column = 0; column < 3; ++column) {
                    double mij2 = matrixOriginal.getElement(row2, column);
                    sij2 = scaledMatrix.getElement(row2, column);
                    Assertions.assertEquals((double)(scalar * mij2), (double)sij2, (double)1.0E-12);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            scalar = random.nextDouble();
            int scaledRow = random.nextInt(3);
            scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
            scaledMatrix.scaleRow(scaledRow, scalar);
            for (row = 0; row < 3; ++row) {
                for (int column2 = 0; column2 < 3; ++column2) {
                    mij = matrixOriginal.getElement(row, column2);
                    sij = scaledMatrix.getElement(row, column2);
                    if (row == scaledRow) {
                        Assertions.assertEquals((double)(scalar * mij), (double)sij, (double)1.0E-12);
                        continue;
                    }
                    Assertions.assertEquals((double)mij, (double)sij, (double)1.0E-12);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            scalar = random.nextDouble();
            int scaledColumn = random.nextInt(3);
            scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
            scaledMatrix.scaleColumn(scaledColumn, scalar);
            for (row = 0; row < 3; ++row) {
                for (int column3 = 0; column3 < 3; ++column3) {
                    mij = matrixOriginal.getElement(row, column3);
                    sij = scaledMatrix.getElement(row, column3);
                    if (column3 == scaledColumn) {
                        Assertions.assertEquals((double)(scalar * mij), (double)sij, (double)1.0E-12);
                        continue;
                    }
                    Assertions.assertEquals((double)mij, (double)sij, (double)1.0E-12);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            scales = EuclidCoreRandomTools.nextRotationVector((Random)random, (double)2.0);
            scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
            scaledMatrix.scaleColumns(scales.getX(), scales.getY(), scales.getZ());
            for (row2 = 0; row2 < 3; ++row2) {
                for (column = 0; column < 3; ++column) {
                    double mij3 = matrixOriginal.getElement(row2, column);
                    sij2 = scaledMatrix.getElement(row2, column);
                    Assertions.assertEquals((double)(scales.getElement(column) * mij3), (double)sij2, (double)1.0E-12);
                }
            }
        }
        for (i = 0; i < 1000; ++i) {
            matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            scales = EuclidCoreRandomTools.nextRotationVector((Random)random, (double)2.0);
            scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
            scaledMatrix.scaleRows(scales.getX(), scales.getY(), scales.getZ());
            for (row2 = 0; row2 < 3; ++row2) {
                for (column = 0; column < 3; ++column) {
                    double mij4 = matrixOriginal.getElement(row2, column);
                    sij2 = scaledMatrix.getElement(row2, column);
                    Assertions.assertEquals((double)(scales.getElement(row2) * mij4), (double)sij2, (double)1.0E-12);
                }
            }
        }
        matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
        scalar = random.nextDouble();
        scaledMatrix.scaleM00(scalar);
        Assertions.assertEquals((double)(scalar * matrixOriginal.getM00()), (double)scaledMatrix.getM00(), (double)1.0E-12);
        matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
        scalar = random.nextDouble();
        scaledMatrix.scaleM01(scalar);
        Assertions.assertEquals((double)(scalar * matrixOriginal.getM01()), (double)scaledMatrix.getM01(), (double)1.0E-12);
        matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
        scalar = random.nextDouble();
        scaledMatrix.scaleM02(scalar);
        Assertions.assertEquals((double)(scalar * matrixOriginal.getM02()), (double)scaledMatrix.getM02(), (double)1.0E-12);
        matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
        scalar = random.nextDouble();
        scaledMatrix.scaleM10(scalar);
        Assertions.assertEquals((double)(scalar * matrixOriginal.getM10()), (double)scaledMatrix.getM10(), (double)1.0E-12);
        matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
        scalar = random.nextDouble();
        scaledMatrix.scaleM11(scalar);
        Assertions.assertEquals((double)(scalar * matrixOriginal.getM11()), (double)scaledMatrix.getM11(), (double)1.0E-12);
        matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
        scalar = random.nextDouble();
        scaledMatrix.scaleM12(scalar);
        Assertions.assertEquals((double)(scalar * matrixOriginal.getM12()), (double)scaledMatrix.getM12(), (double)1.0E-12);
        matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
        scalar = random.nextDouble();
        scaledMatrix.scaleM20(scalar);
        Assertions.assertEquals((double)(scalar * matrixOriginal.getM20()), (double)scaledMatrix.getM20(), (double)1.0E-12);
        matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
        scalar = random.nextDouble();
        scaledMatrix.scaleM21(scalar);
        Assertions.assertEquals((double)(scalar * matrixOriginal.getM21()), (double)scaledMatrix.getM21(), (double)1.0E-12);
        matrixOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        scaledMatrix.set((Matrix3DReadOnly)matrixOriginal);
        scalar = random.nextDouble();
        scaledMatrix.scaleM22(scalar);
        Assertions.assertEquals((double)(scalar * matrixOriginal.getM22()), (double)scaledMatrix.getM22(), (double)1.0E-12);
        double scalarFinal = scalar;
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> scaledMatrix.scaleRow(3, scalarFinal));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> scaledMatrix.scaleColumn(3, scalarFinal));
    }

    @Test
    public void testMultiplyOuter() {
        Matrix3DBasics expectedMatrix;
        Matrix3DBasics actualMatrix;
        int i;
        Random random = new Random(51665L);
        for (i = 0; i < 1000; ++i) {
            actualMatrix = (Matrix3DBasics)this.createRandomMatrix(random);
            expectedMatrix = (Matrix3DBasics)this.createEmptyMatrix();
            Matrix3DTools.multiplyTransposeRight((Matrix3DReadOnly)actualMatrix, (Matrix3DReadOnly)actualMatrix, (CommonMatrix3DBasics)expectedMatrix);
            actualMatrix.multiplyOuter();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)actualMatrix, (Matrix3DReadOnly)expectedMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            actualMatrix = (Matrix3DBasics)this.createRandomMatrix(random);
            expectedMatrix = (Matrix3DBasics)this.createEmptyMatrix();
            Matrix3D m = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actualMatrix.setAndMultiplyOuter((Matrix3DReadOnly)m);
            expectedMatrix.set((Matrix3DReadOnly)m);
            expectedMatrix.multiplyOuter();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)actualMatrix, (Matrix3DReadOnly)expectedMatrix, (double)1.0E-12);
        }
    }

    @Test
    public void testInvert() throws Exception {
        Random random = new Random(54654L);
        Matrix3D matrix = new Matrix3D();
        Matrix3DBasics expectedInvert = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics actualInvert = (Matrix3DBasics)this.createEmptyMatrix();
        actualInvert.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertThrows(SingularMatrixException.class, () -> actualInvert.invert());
        for (int i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.invert((Matrix3DReadOnly)matrix, (CommonMatrix3DBasics)expectedInvert);
            actualInvert.set((Matrix3DReadOnly)matrix);
            actualInvert.invert();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedInvert, (Matrix3DReadOnly)actualInvert, (double)1.0E-12);
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.invert((Matrix3DReadOnly)matrix, (CommonMatrix3DBasics)expectedInvert);
            actualInvert.setAndInvert((Matrix3DReadOnly)matrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedInvert, (Matrix3DReadOnly)actualInvert, (double)1.0E-12);
        }
    }

    @Test
    public void testNormalize() throws Exception {
        Matrix3D matrix;
        int i;
        Random random = new Random(541654L);
        Matrix3DBasics actualMatrix = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics expectedMatrix = (Matrix3DBasics)this.createEmptyMatrix();
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)2.0);
            expectedMatrix.set((Matrix3DReadOnly)matrix);
            Matrix3DTools.normalize((CommonMatrix3DBasics)expectedMatrix);
            actualMatrix.set((Matrix3DReadOnly)matrix);
            actualMatrix.normalize();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)2.0);
            expectedMatrix.set((Matrix3DReadOnly)matrix);
            Matrix3DTools.normalize((CommonMatrix3DBasics)expectedMatrix);
            actualMatrix.setAndNormalize((Matrix3DReadOnly)matrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedMatrix, (Matrix3DReadOnly)actualMatrix, (double)1.0E-12);
        }
    }

    @Override
    @Test
    public void testTranspose() throws Exception {
        super.testTranspose();
        Random random = new Random(65451L);
        for (int i = 0; i < 1000; ++i) {
            Matrix3DBasics matrix = (Matrix3DBasics)this.createRandomMatrix(random);
            Matrix3DBasics matrixTranspose = (Matrix3DBasics)this.createEmptyMatrix();
            matrixTranspose.setAndTranspose((Matrix3DReadOnly)matrix);
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    Assertions.assertEquals((double)matrix.getElement(row, column), (double)matrixTranspose.getElement(column, row), (double)1.0E-12);
                }
            }
        }
    }

    @Test
    public void testNegate() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            Matrix3DBasics original = (Matrix3DBasics)this.createRandomMatrix(random);
            Matrix3DBasics negated = (Matrix3DBasics)this.createRandomMatrix(random);
            negated.set((Matrix3DReadOnly)original);
            negated.negate();
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    Assertions.assertEquals((double)(-original.getElement(row, column)), (double)negated.getElement(row, column), (double)1.0E-12);
                }
            }
            negated.setToNaN();
            EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)negated);
            negated.setAndNegate((Matrix3DReadOnly)original);
            original.negate();
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)original, (Matrix3DReadOnly)negated, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiply() throws Exception {
        Random random = new Random(65561L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3DBasics expected = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics actual = (Matrix3DBasics)this.createEmptyMatrix();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.multiply((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.multiply((Matrix3DReadOnly)m2);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiplyTransposeThis() throws Exception {
        Random random = new Random(65561L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3DBasics expected = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics actual = (Matrix3DBasics)this.createEmptyMatrix();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.multiplyTransposeLeft((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.multiplyTransposeThis((Matrix3DReadOnly)m2);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiplyInvertThis() throws Exception {
        Random random = new Random(65561L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3DBasics expected = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics actual = (Matrix3DBasics)this.createEmptyMatrix();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.multiplyInvertLeft((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.multiplyInvertThis((Matrix3DReadOnly)m2);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiplyTransposeOther() throws Exception {
        Random random = new Random(65561L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3DBasics expected = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics actual = (Matrix3DBasics)this.createEmptyMatrix();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.multiplyTransposeRight((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.multiplyTransposeOther((Matrix3DReadOnly)m2);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiplyInvertOther() throws Exception {
        Random random = new Random(65561L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3DBasics expected = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics actual = (Matrix3DBasics)this.createEmptyMatrix();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.multiplyInvertRight((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.multiplyInvertOther((Matrix3DReadOnly)m2);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Matrix3DTools.multiplyInvertRight((Matrix3DReadOnly)m1, (RotationMatrixReadOnly)rotationMatrix, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.multiplyInvertOther((RotationMatrixReadOnly)rotationMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testMultiplyTransposeBoth() throws Exception {
        Random random = new Random(65561L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3DBasics expected = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics actual = (Matrix3DBasics)this.createEmptyMatrix();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.multiplyTransposeBoth((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.multiplyTransposeBoth((Matrix3DReadOnly)m2);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPreMultiply() throws Exception {
        Random random = new Random(65561L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3DBasics expected = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics actual = (Matrix3DBasics)this.createEmptyMatrix();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.multiply((Matrix3DReadOnly)m2, (Matrix3DReadOnly)m1, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.preMultiply((Matrix3DReadOnly)m2);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPreMultiplyTransposeThis() throws Exception {
        Random random = new Random(65561L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3DBasics expected = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics actual = (Matrix3DBasics)this.createEmptyMatrix();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.multiplyTransposeRight((Matrix3DReadOnly)m2, (Matrix3DReadOnly)m1, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.preMultiplyTransposeThis((Matrix3DReadOnly)m2);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPreMultiplyInvertThis() throws Exception {
        Random random = new Random(65561L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3DBasics expected = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics actual = (Matrix3DBasics)this.createEmptyMatrix();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.multiplyInvertRight((Matrix3DReadOnly)m2, (Matrix3DReadOnly)m1, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.preMultiplyInvertThis((Matrix3DReadOnly)m2);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPreMultiplyTransposeOther() throws Exception {
        Random random = new Random(65561L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3DBasics expected = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics actual = (Matrix3DBasics)this.createEmptyMatrix();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.multiplyTransposeLeft((Matrix3DReadOnly)m2, (Matrix3DReadOnly)m1, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.preMultiplyTransposeOther((Matrix3DReadOnly)m2);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPreMultiplyInvertOther() throws Exception {
        Random random = new Random(65561L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3DBasics expected = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics actual = (Matrix3DBasics)this.createEmptyMatrix();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.multiplyInvertLeft((Matrix3DReadOnly)m2, (Matrix3DReadOnly)m1, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.preMultiplyInvertOther((Matrix3DReadOnly)m2);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Matrix3DTools.multiplyInvertLeft((RotationMatrixReadOnly)rotationMatrix, (Matrix3DReadOnly)m1, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.preMultiplyInvertOther((RotationMatrixReadOnly)rotationMatrix);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPreMultiplyTransposeBoth() throws Exception {
        Random random = new Random(65561L);
        Matrix3D m1 = new Matrix3D();
        Matrix3D m2 = new Matrix3D();
        Matrix3DBasics expected = (Matrix3DBasics)this.createEmptyMatrix();
        Matrix3DBasics actual = (Matrix3DBasics)this.createEmptyMatrix();
        for (int i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.multiplyTransposeBoth((Matrix3DReadOnly)m2, (Matrix3DReadOnly)m1, (CommonMatrix3DBasics)expected);
            actual.set((Matrix3DReadOnly)m1);
            actual.preMultiplyTransposeBoth((Matrix3DReadOnly)m2);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testSetRow() throws Exception {
        Random random = new Random(6465L);
        Matrix3DBasics matrix = (Matrix3DBasics)this.createEmptyMatrix();
        double[] rowArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
        matrix.setRow(0, rowArray);
        Assertions.assertTrue((matrix.getM00() == rowArray[0] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM01() == rowArray[1] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM02() == rowArray[2] ? 1 : 0) != 0);
        matrix.setRow(1, rowArray);
        Assertions.assertTrue((matrix.getM10() == rowArray[0] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM11() == rowArray[1] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM12() == rowArray[2] ? 1 : 0) != 0);
        matrix.setRow(2, rowArray);
        Assertions.assertTrue((matrix.getM20() == rowArray[0] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM21() == rowArray[1] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM22() == rowArray[2] ? 1 : 0) != 0);
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> matrix.setRow(3, rowArray));
        double x = random.nextDouble();
        double y = random.nextDouble();
        double z = random.nextDouble();
        matrix.setRow(0, x, y, z);
        Assertions.assertTrue((matrix.getM00() == x ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM01() == y ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM02() == z ? 1 : 0) != 0);
        matrix.setRow(1, x, y, z);
        Assertions.assertTrue((matrix.getM10() == x ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM11() == y ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM12() == z ? 1 : 0) != 0);
        matrix.setRow(2, x, y, z);
        Assertions.assertTrue((matrix.getM20() == x ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM21() == y ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM22() == z ? 1 : 0) != 0);
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> matrix.setRow(3, x, y, z));
        Vector3D rowVector = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
        matrix.setRow(0, (Tuple3DReadOnly)rowVector);
        Assertions.assertTrue((matrix.getM00() == rowVector.getElement(0) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM01() == rowVector.getElement(1) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM02() == rowVector.getElement(2) ? 1 : 0) != 0);
        matrix.setRow(1, (Tuple3DReadOnly)rowVector);
        Assertions.assertTrue((matrix.getM10() == rowVector.getElement(0) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM11() == rowVector.getElement(1) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM12() == rowVector.getElement(2) ? 1 : 0) != 0);
        matrix.setRow(2, (Tuple3DReadOnly)rowVector);
        Assertions.assertTrue((matrix.getM20() == rowVector.getElement(0) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM21() == rowVector.getElement(1) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM22() == rowVector.getElement(2) ? 1 : 0) != 0);
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> matrix.setRow(3, (Tuple3DReadOnly)rowVector));
    }

    @Test
    public void testSetColumn() throws Exception {
        Random random = new Random(6465L);
        Matrix3DBasics matrix = (Matrix3DBasics)this.createEmptyMatrix();
        double[] columnArray = new double[]{random.nextDouble(), random.nextDouble(), random.nextDouble()};
        matrix.setColumn(0, columnArray);
        Assertions.assertTrue((matrix.getM00() == columnArray[0] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM10() == columnArray[1] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM20() == columnArray[2] ? 1 : 0) != 0);
        matrix.setColumn(1, columnArray);
        Assertions.assertTrue((matrix.getM01() == columnArray[0] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM11() == columnArray[1] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM21() == columnArray[2] ? 1 : 0) != 0);
        matrix.setColumn(2, columnArray);
        Assertions.assertTrue((matrix.getM02() == columnArray[0] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM12() == columnArray[1] ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM22() == columnArray[2] ? 1 : 0) != 0);
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> matrix.setColumn(3, columnArray));
        double x = random.nextDouble();
        double y = random.nextDouble();
        double z = random.nextDouble();
        matrix.setColumn(0, x, y, z);
        Assertions.assertTrue((matrix.getM00() == x ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM10() == y ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM20() == z ? 1 : 0) != 0);
        matrix.setColumn(1, x, y, z);
        Assertions.assertTrue((matrix.getM01() == x ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM11() == y ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM21() == z ? 1 : 0) != 0);
        matrix.setColumn(2, x, y, z);
        Assertions.assertTrue((matrix.getM02() == x ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM12() == y ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM22() == z ? 1 : 0) != 0);
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> matrix.setColumn(3, x, y, z));
        Vector3D columnVector = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
        matrix.setColumn(0, (Tuple3DReadOnly)columnVector);
        Assertions.assertTrue((matrix.getM00() == columnVector.getElement(0) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM10() == columnVector.getElement(1) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM20() == columnVector.getElement(2) ? 1 : 0) != 0);
        matrix.setColumn(1, (Tuple3DReadOnly)columnVector);
        Assertions.assertTrue((matrix.getM01() == columnVector.getElement(0) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM11() == columnVector.getElement(1) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM21() == columnVector.getElement(2) ? 1 : 0) != 0);
        matrix.setColumn(2, (Tuple3DReadOnly)columnVector);
        Assertions.assertTrue((matrix.getM02() == columnVector.getElement(0) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM12() == columnVector.getElement(1) ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getM22() == columnVector.getElement(2) ? 1 : 0) != 0);
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> matrix.setColumn(3, (Tuple3DReadOnly)columnVector));
    }

    @Test
    public void testSetGetElement() throws Exception {
        Random random = new Random(5464L);
        Matrix3DBasics matrix = (Matrix3DBasics)this.createEmptyMatrix();
        double coeff = random.nextDouble();
        matrix.setElement(0, 0, coeff);
        Assertions.assertTrue((matrix.getM00() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getElement(0, 0) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setElement(0, 1, coeff);
        Assertions.assertTrue((matrix.getM01() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getElement(0, 1) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setElement(0, 2, coeff);
        Assertions.assertTrue((matrix.getM02() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getElement(0, 2) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setElement(1, 0, coeff);
        Assertions.assertTrue((matrix.getM10() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getElement(1, 0) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setElement(1, 1, coeff);
        Assertions.assertTrue((matrix.getM11() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getElement(1, 1) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setElement(1, 2, coeff);
        Assertions.assertTrue((matrix.getM12() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getElement(1, 2) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setElement(2, 0, coeff);
        Assertions.assertTrue((matrix.getM20() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getElement(2, 0) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setElement(2, 1, coeff);
        Assertions.assertTrue((matrix.getM21() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getElement(2, 1) == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setElement(2, 2, coeff);
        Assertions.assertTrue((matrix.getM22() == coeff ? 1 : 0) != 0);
        Assertions.assertTrue((matrix.getElement(2, 2) == coeff ? 1 : 0) != 0);
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> matrix.setElement(0, 3, random.nextDouble()));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> matrix.setElement(1, 3, random.nextDouble()));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> matrix.setElement(2, 3, random.nextDouble()));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> matrix.setElement(3, 0, random.nextDouble()));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> matrix.setElement(3, 1, random.nextDouble()));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> matrix.setElement(3, 2, random.nextDouble()));
    }

    @Test
    public void testFieldSettersAndGetters() throws Exception {
        Random random = new Random(654654L);
        Matrix3DBasics matrix = (Matrix3DBasics)this.createEmptyMatrix();
        double coeff = random.nextDouble();
        matrix.setM00(coeff);
        Assertions.assertTrue((matrix.getM00() == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setM01(coeff);
        Assertions.assertTrue((matrix.getM01() == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setM02(coeff);
        Assertions.assertTrue((matrix.getM02() == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setM10(coeff);
        Assertions.assertTrue((matrix.getM10() == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setM11(coeff);
        Assertions.assertTrue((matrix.getM11() == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setM12(coeff);
        Assertions.assertTrue((matrix.getM12() == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setM20(coeff);
        Assertions.assertTrue((matrix.getM20() == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setM21(coeff);
        Assertions.assertTrue((matrix.getM21() == coeff ? 1 : 0) != 0);
        coeff = random.nextDouble();
        matrix.setM22(coeff);
        Assertions.assertTrue((matrix.getM22() == coeff ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(2354L);
        Matrix3D m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        Matrix3D m2 = new Matrix3D();
        Assertions.assertFalse((boolean)m1.equals((EuclidGeometry)m2));
        Assertions.assertFalse((boolean)m1.equals(null));
        Assertions.assertFalse((boolean)m1.equals((Object)new double[4]));
        m2.set((Matrix3DReadOnly)m1);
        Assertions.assertTrue((boolean)m1.equals((EuclidGeometry)m2));
        Matrix3D m2AsObject = m2;
        Assertions.assertTrue((boolean)m1.equals((Object)m2AsObject));
        double smallestEpsilon = 1.0E-16;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                m2.set((Matrix3DReadOnly)m1);
                Assertions.assertTrue((boolean)m1.equals((EuclidGeometry)m2));
                m2.setElement(row, column, m2.getElement(row, column) + smallestEpsilon);
                Assertions.assertFalse((boolean)m1.equals((EuclidGeometry)m2));
                m2.set((Matrix3DReadOnly)m1);
                Assertions.assertTrue((boolean)m1.equals((EuclidGeometry)m2));
                m2.setElement(row, column, m2.getElement(row, column) - smallestEpsilon);
                Assertions.assertFalse((boolean)m1.equals((EuclidGeometry)m2));
            }
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Matrix3DBasics matrix = (Matrix3DBasics)this.createRandomMatrix(random);
        int newHashCode = matrix.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)matrix.hashCode());
        int previousHashCode = matrix.hashCode();
        for (int i = 0; i < 1000; ++i) {
            int row = random.nextInt(3);
            int column = random.nextInt(3);
            matrix.setElement(row, column, random.nextDouble());
            newHashCode = matrix.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Test
    public void testApplyTransform() throws Exception {
        Matrix3DBasics actual;
        Matrix3DBasics expected;
        Matrix3DBasics original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = (Matrix3DBasics)this.createRandomMatrix(random);
            expected = (Matrix3DBasics)this.createEmptyMatrix();
            actual = (Matrix3DBasics)this.createEmptyMatrix();
            expected.set((Matrix3DReadOnly)original);
            transform.transform(expected);
            actual.set((Matrix3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = (Matrix3DBasics)this.createRandomMatrix(random);
            expected = (Matrix3DBasics)this.createEmptyMatrix();
            actual = (Matrix3DBasics)this.createEmptyMatrix();
            expected.set((Matrix3DReadOnly)original);
            transform.transform(expected);
            actual.set((Matrix3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            original = (Matrix3DBasics)this.createRandomMatrix(random);
            expected = (Matrix3DBasics)this.createEmptyMatrix();
            actual = (Matrix3DBasics)this.createEmptyMatrix();
            expected.set((Matrix3DReadOnly)original);
            transform.transform(expected);
            actual.set((Matrix3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testApplyInverseTransform() throws Exception {
        Matrix3DBasics actual;
        Matrix3DBasics expected;
        Matrix3DBasics original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = (Matrix3DBasics)this.createRandomMatrix(random);
            expected = (Matrix3DBasics)this.createEmptyMatrix();
            actual = (Matrix3DBasics)this.createEmptyMatrix();
            expected.set((Matrix3DReadOnly)original);
            actual.set((Matrix3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = (Matrix3DBasics)this.createRandomMatrix(random);
            expected = (Matrix3DBasics)this.createEmptyMatrix();
            actual = (Matrix3DBasics)this.createEmptyMatrix();
            expected.set((Matrix3DReadOnly)original);
            actual.set((Matrix3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextNonSingularAffineTransform((Random)random);
            original = (Matrix3DBasics)this.createRandomMatrix(random);
            expected = (Matrix3DBasics)this.createEmptyMatrix();
            actual = (Matrix3DBasics)this.createEmptyMatrix();
            expected.set((Matrix3DReadOnly)original);
            actual.set((Matrix3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
    }
}

