/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.tools;

import java.util.EnumMap;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryFactories;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreFactoriesTest;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class EuclidGeometryFactoriesTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testNewLinkedBoundingBox2DReadOnly() {
        Random random = new Random(5416L);
        BoundingBox2D expected = new BoundingBox2D();
        BoundingBox2DReadOnly actual = EuclidGeometryFactories.newLinkedBoundingBox2DReadOnly((Point2DReadOnly)expected.getMinPoint(), (Point2DReadOnly)expected.getMaxPoint());
        for (int i = 0; i < 1000; ++i) {
            expected.set((BoundingBox2DReadOnly)EuclidGeometryRandomTools.nextBoundingBox2D((Random)random));
            EuclidGeometryFactoriesTest.thoroughAssertionsBoundingBox2D((BoundingBox2DReadOnly)expected, actual);
        }
    }

    @Test
    public void testNewLinkedBoundingBox3DReadOnly() {
        Random random = new Random(5416L);
        BoundingBox3D expected = new BoundingBox3D();
        BoundingBox3DReadOnly actual = EuclidGeometryFactories.newLinkedBoundingBox3DReadOnly((Point3DReadOnly)expected.getMinPoint(), (Point3DReadOnly)expected.getMaxPoint());
        for (int i = 0; i < 1000; ++i) {
            expected.set((BoundingBox3DReadOnly)EuclidGeometryRandomTools.nextBoundingBox3D((Random)random));
            EuclidGeometryFactoriesTest.thoroughAssertionsBoundingBox3D((BoundingBox3DReadOnly)expected, actual);
        }
    }

    @Test
    public void testNewLinkedBoundingBox2DBasics() {
        Random random = new Random(5416L);
        BoundingBox2D expected = new BoundingBox2D();
        BoundingBox2DBasics actual = EuclidGeometryFactories.newLinkedBoundingBox2DBasics((Point2DBasics)expected.getMinPoint(), (Point2DBasics)expected.getMaxPoint());
        for (int i = 0; i < 1000; ++i) {
            expected.set((BoundingBox2DReadOnly)EuclidGeometryRandomTools.nextBoundingBox2D((Random)random));
            EuclidGeometryFactoriesTest.thoroughAssertionsBoundingBox2D((BoundingBox2DReadOnly)expected, (BoundingBox2DReadOnly)actual);
            actual.set((BoundingBox2DReadOnly)EuclidGeometryRandomTools.nextBoundingBox2D((Random)random));
            EuclidGeometryFactoriesTest.thoroughAssertionsBoundingBox2D((BoundingBox2DReadOnly)expected, (BoundingBox2DReadOnly)actual);
        }
    }

    @Test
    public void testNewLinkedBoundingBox3DBasics() {
        Random random = new Random(5416L);
        BoundingBox3D expected = new BoundingBox3D();
        BoundingBox3DBasics actual = EuclidGeometryFactories.newLinkedBoundingBox3DBasics((Point3DBasics)expected.getMinPoint(), (Point3DBasics)expected.getMaxPoint());
        for (int i = 0; i < 1000; ++i) {
            expected.set((BoundingBox3DReadOnly)EuclidGeometryRandomTools.nextBoundingBox3D((Random)random));
            EuclidGeometryFactoriesTest.thoroughAssertionsBoundingBox3D((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual);
            actual.set((BoundingBox3DReadOnly)EuclidGeometryRandomTools.nextBoundingBox3D((Random)random));
            EuclidGeometryFactoriesTest.thoroughAssertionsBoundingBox3D((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual);
        }
    }

    @Test
    public void testNewObservableBoundingBox2DBasics() {
        Random random = new Random(4367L);
        BoundingBox2D expected = new BoundingBox2D();
        BoundingBox2DBasics actual = EuclidGeometryFactories.newObservableBoundingBox2DBasics(null, null, (BoundingBox2DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((BoundingBox2DReadOnly)EuclidGeometryRandomTools.nextBoundingBox2D((Random)random));
            EuclidGeometryFactoriesTest.thoroughAssertionsBoundingBox2D((BoundingBox2DReadOnly)expected, (BoundingBox2DReadOnly)actual);
            actual.set((BoundingBox2DReadOnly)EuclidGeometryRandomTools.nextBoundingBox2D((Random)random));
            EuclidGeometryFactoriesTest.thoroughAssertionsBoundingBox2D((BoundingBox2DReadOnly)expected, (BoundingBox2DReadOnly)actual);
        }
        EnumMap<Bound, boolean[]> changeTraceMap = new EnumMap<Bound, boolean[]>(Bound.class);
        EnumMap<Bound, boolean[]> accessTraceMap = new EnumMap<Bound, boolean[]>(Bound.class);
        for (Bound bound2 : Bound.values) {
            changeTraceMap.put(bound2, new boolean[]{false, false});
            accessTraceMap.put(bound2, new boolean[]{false, false});
        }
        BoundingBox2D source = new BoundingBox2D();
        BoundingBox2DBasics observable = EuclidGeometryFactories.newObservableBoundingBox2DBasics((axis, bound, newValue) -> {
            ((boolean[])changeTraceMap.get((Object)bound))[axis.ordinal()] = true;
        }, (axis, bound) -> {
            ((boolean[])accessTraceMap.get((Object)bound))[axis.ordinal()] = true;
        }, (BoundingBox2DBasics)source);
        EnumMap<Bound, Point2DBasics> boundPoints = new EnumMap<Bound, Point2DBasics>(Bound.class);
        boundPoints.put(Bound.MIN, observable.getMinPoint());
        boundPoints.put(Bound.MAX, observable.getMaxPoint());
        for (Bound bound3 : Bound.values) {
            boolean[] changeTrace = (boolean[])changeTraceMap.get(bound3);
            boolean[] accessTraces = (boolean[])accessTraceMap.get(bound3);
            Point2DBasics boundPoint = (Point2DBasics)boundPoints.get(bound3);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTraces);
            for (int i = 0; i < 2; ++i) {
                double value = random.nextDouble();
                boundPoint.setElement(i, value);
                Assertions.assertTrue((boolean)changeTrace[i]);
                changeTrace[i] = false;
                boundPoint.setElement(i, value);
                Assertions.assertFalse((boolean)changeTrace[i]);
                EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
                EuclidCoreFactoriesTest.assertAllFalses(accessTraces);
                boundPoint.getElement(i);
                Assertions.assertTrue((boolean)accessTraces[i]);
                accessTraces[i] = false;
                EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
                EuclidCoreFactoriesTest.assertAllFalses(accessTraces);
            }
        }
    }

    @Test
    public void testNewObservableBoundingBox3DBasics() {
        Random random = new Random(4367L);
        BoundingBox3D expected = new BoundingBox3D();
        BoundingBox3DBasics actual = EuclidGeometryFactories.newObservableBoundingBox3DBasics(null, null, (BoundingBox3DBasics)expected);
        for (int i = 0; i < 1000; ++i) {
            expected.set((BoundingBox3DReadOnly)EuclidGeometryRandomTools.nextBoundingBox3D((Random)random));
            EuclidGeometryFactoriesTest.thoroughAssertionsBoundingBox3D((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual);
            actual.set((BoundingBox3DReadOnly)EuclidGeometryRandomTools.nextBoundingBox3D((Random)random));
            EuclidGeometryFactoriesTest.thoroughAssertionsBoundingBox3D((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual);
        }
        EnumMap<Bound, boolean[]> changeTraceMap = new EnumMap<Bound, boolean[]>(Bound.class);
        EnumMap<Bound, boolean[]> accessTraceMap = new EnumMap<Bound, boolean[]>(Bound.class);
        for (Bound bound2 : Bound.values) {
            changeTraceMap.put(bound2, new boolean[]{false, false, false});
            accessTraceMap.put(bound2, new boolean[]{false, false, false});
        }
        BoundingBox3D source = new BoundingBox3D();
        BoundingBox3DBasics observable = EuclidGeometryFactories.newObservableBoundingBox3DBasics((axis, bound, newValue) -> {
            ((boolean[])changeTraceMap.get((Object)bound))[axis.ordinal()] = true;
        }, (axis, bound) -> {
            ((boolean[])accessTraceMap.get((Object)bound))[axis.ordinal()] = true;
        }, (BoundingBox3DBasics)source);
        EnumMap<Bound, Point3DBasics> boundPoints = new EnumMap<Bound, Point3DBasics>(Bound.class);
        boundPoints.put(Bound.MIN, observable.getMinPoint());
        boundPoints.put(Bound.MAX, observable.getMaxPoint());
        for (Bound bound3 : Bound.values) {
            boolean[] changeTrace = (boolean[])changeTraceMap.get(bound3);
            boolean[] accessTraces = (boolean[])accessTraceMap.get(bound3);
            Point3DBasics boundPoint = (Point3DBasics)boundPoints.get(bound3);
            EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
            EuclidCoreFactoriesTest.assertAllFalses(accessTraces);
            for (int i = 0; i < 3; ++i) {
                double value = random.nextDouble();
                boundPoint.setElement(i, value);
                Assertions.assertTrue((boolean)changeTrace[i]);
                changeTrace[i] = false;
                boundPoint.setElement(i, value);
                Assertions.assertFalse((boolean)changeTrace[i]);
                EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
                EuclidCoreFactoriesTest.assertAllFalses(accessTraces);
                boundPoint.getElement(i);
                Assertions.assertTrue((boolean)accessTraces[i]);
                accessTraces[i] = false;
                EuclidCoreFactoriesTest.assertAllFalses(changeTrace);
                EuclidCoreFactoriesTest.assertAllFalses(accessTraces);
            }
        }
    }

    public static void thoroughAssertionsBoundingBox2D(BoundingBox2DReadOnly expected, BoundingBox2DReadOnly actual) {
        EuclidCoreFactoriesTest.assertObjectMethods(expected, actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actual, (EuclidGeometry)expected, (double)1.0E-12);
    }

    public static void thoroughAssertionsBoundingBox3D(BoundingBox3DReadOnly expected, BoundingBox3DReadOnly actual) {
        EuclidCoreFactoriesTest.assertObjectMethods(expected, actual);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)actual, (EuclidGeometry)expected, (double)1.0E-12);
    }
}

