/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class LineSegment3DTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testConstructors() throws Exception {
        Random random = new Random(324324L);
        Point3D expectedFirstEndpoint = new Point3D();
        Point3D expectedSecondEndpoint = new Point3D();
        LineSegment3D lineSegment3D = new LineSegment3D();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstEndpoint, (EuclidGeometry)lineSegment3D.getFirstEndpoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondEndpoint, (EuclidGeometry)lineSegment3D.getSecondEndpoint(), (double)1.0E-12);
        expectedFirstEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        expectedSecondEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        lineSegment3D = new LineSegment3D((Point3DReadOnly)expectedFirstEndpoint, (Point3DReadOnly)expectedSecondEndpoint);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstEndpoint, (EuclidGeometry)lineSegment3D.getFirstEndpoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondEndpoint, (EuclidGeometry)lineSegment3D.getSecondEndpoint(), (double)1.0E-12);
        expectedFirstEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        expectedSecondEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        lineSegment3D = new LineSegment3D(expectedFirstEndpoint.getX(), expectedFirstEndpoint.getY(), expectedFirstEndpoint.getZ(), expectedSecondEndpoint.getX(), expectedSecondEndpoint.getY(), expectedSecondEndpoint.getZ());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstEndpoint, (EuclidGeometry)lineSegment3D.getFirstEndpoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondEndpoint, (EuclidGeometry)lineSegment3D.getSecondEndpoint(), (double)1.0E-12);
        LineSegment3D otherLineSegment = new LineSegment3D((LineSegment3DReadOnly)lineSegment3D);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstEndpoint, (EuclidGeometry)otherLineSegment.getFirstEndpoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondEndpoint, (EuclidGeometry)otherLineSegment.getSecondEndpoint(), (double)1.0E-12);
    }

    @Test
    public void testSetters() throws Exception {
        Random random = new Random(324324L);
        LineSegment3D lineSegment3D = new LineSegment3D();
        Point3D expectedFirstEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        Point3D expectedSecondEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        lineSegment3D.set(expectedFirstEndpoint.getX(), expectedFirstEndpoint.getY(), expectedFirstEndpoint.getZ(), expectedSecondEndpoint.getX(), expectedSecondEndpoint.getY(), expectedSecondEndpoint.getZ());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstEndpoint, (EuclidGeometry)lineSegment3D.getFirstEndpoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondEndpoint, (EuclidGeometry)lineSegment3D.getSecondEndpoint(), (double)1.0E-12);
        expectedFirstEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        expectedSecondEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        lineSegment3D.set((Point3DReadOnly)expectedFirstEndpoint, (Point3DReadOnly)expectedSecondEndpoint);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstEndpoint, (EuclidGeometry)lineSegment3D.getFirstEndpoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondEndpoint, (EuclidGeometry)lineSegment3D.getSecondEndpoint(), (double)1.0E-12);
        expectedFirstEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        expectedSecondEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        Vector3D fromFirstToSecondEndpoint = new Vector3D();
        fromFirstToSecondEndpoint.sub((Tuple3DReadOnly)expectedSecondEndpoint, (Tuple3DReadOnly)expectedFirstEndpoint);
        lineSegment3D.set((Point3DReadOnly)expectedFirstEndpoint, (Vector3DReadOnly)fromFirstToSecondEndpoint);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstEndpoint, (EuclidGeometry)lineSegment3D.getFirstEndpoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondEndpoint, (EuclidGeometry)lineSegment3D.getSecondEndpoint(), (double)1.0E-12);
        expectedFirstEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        expectedSecondEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        LineSegment3D other = new LineSegment3D((Point3DReadOnly)expectedFirstEndpoint, (Point3DReadOnly)expectedSecondEndpoint);
        lineSegment3D.set((LineSegment3DReadOnly)other);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstEndpoint, (EuclidGeometry)lineSegment3D.getFirstEndpoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondEndpoint, (EuclidGeometry)lineSegment3D.getSecondEndpoint(), (double)1.0E-12);
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(32423L);
        LineSegment3D lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random);
        lineSegment3D.setToZero();
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)lineSegment3D.getFirstEndpoint());
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)lineSegment3D.getSecondEndpoint());
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(32423L);
        LineSegment3D lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random);
        lineSegment3D.setToNaN();
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)lineSegment3D.getFirstEndpoint());
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)lineSegment3D.getSecondEndpoint());
    }

    @Test
    public void testContainsNaN() throws Exception {
        LineSegment3D lineSegment3D;
        int i;
        for (i = 0; i < 3; ++i) {
            lineSegment3D = new LineSegment3D();
            Assertions.assertFalse((boolean)lineSegment3D.containsNaN());
            Point3D firstEndpoint = new Point3D();
            firstEndpoint.setElement(i, Double.NaN);
            lineSegment3D.getFirstEndpoint().set((Tuple3DReadOnly)firstEndpoint);
            Assertions.assertTrue((boolean)lineSegment3D.containsNaN());
            Assertions.assertTrue((boolean)lineSegment3D.getFirstEndpoint().containsNaN());
            Assertions.assertFalse((boolean)lineSegment3D.getSecondEndpoint().containsNaN());
        }
        for (i = 0; i < 3; ++i) {
            lineSegment3D = new LineSegment3D();
            Assertions.assertFalse((boolean)lineSegment3D.containsNaN());
            Point3D secondEndpoint = new Point3D();
            secondEndpoint.setElement(i, Double.NaN);
            lineSegment3D.getSecondEndpoint().set((Tuple3DReadOnly)secondEndpoint);
            Assertions.assertTrue((boolean)lineSegment3D.containsNaN());
            Assertions.assertFalse((boolean)lineSegment3D.getFirstEndpoint().containsNaN());
            Assertions.assertTrue((boolean)lineSegment3D.getSecondEndpoint().containsNaN());
        }
    }

    @Test
    public void testLength() throws Exception {
        Random random = new Random(32434L);
        for (int i = 0; i < 1000; ++i) {
            LineSegment3D lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            double actualLength = lineSegment3D.length();
            double expectedLength = lineSegment3D.getFirstEndpoint().distance((Point3DReadOnly)lineSegment3D.getSecondEndpoint());
            Assertions.assertEquals((double)expectedLength, (double)actualLength, (double)1.0E-12);
        }
    }

    @Test
    public void testDistance() throws Exception {
        double actual;
        double expected;
        Point3D query;
        LineSegment3D lineSegment3D;
        int i;
        Random random = new Random(234234L);
        for (i = 0; i < 1000; ++i) {
            lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            query = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            expected = EuclidGeometryTools.distanceSquaredFromPoint3DToLineSegment3D((Point3DReadOnly)query, (Point3DReadOnly)lineSegment3D.getFirstEndpoint(), (Point3DReadOnly)lineSegment3D.getSecondEndpoint());
            actual = lineSegment3D.distanceSquared((Point3DReadOnly)query);
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            query = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            expected = EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((Point3DReadOnly)query, (Point3DReadOnly)lineSegment3D.getFirstEndpoint(), (Point3DReadOnly)lineSegment3D.getSecondEndpoint());
            actual = lineSegment3D.distance((Point3DReadOnly)query);
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            LineSegment3D lineSegment1 = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            LineSegment3D lineSegment2 = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            expected = EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds((Point3DReadOnly)lineSegment1.getFirstEndpoint(), (Point3DReadOnly)lineSegment1.getSecondEndpoint(), (Point3DReadOnly)lineSegment2.getFirstEndpoint(), (Point3DReadOnly)lineSegment2.getSecondEndpoint());
            actual = lineSegment1.distance((LineSegment3DReadOnly)lineSegment2);
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testOrthogonalProjection() throws Exception {
        Point3D actual;
        Point3D expected;
        Point3D query;
        LineSegment3D lineSegment3D;
        int i;
        Random random = new Random(2342L);
        for (i = 0; i < 1000; ++i) {
            lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            query = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            expected = new Point3D();
            actual = new Point3D();
            expected = EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)query, (Point3DReadOnly)lineSegment3D.getFirstEndpoint(), (Point3DReadOnly)lineSegment3D.getSecondEndpoint());
            actual = lineSegment3D.orthogonalProjectionCopy((Point3DReadOnly)query);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            query = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            expected = new Point3D();
            actual = new Point3D();
            expected = EuclidGeometryTools.orthogonalProjectionOnLineSegment3D((Point3DReadOnly)query, (Point3DReadOnly)lineSegment3D.getFirstEndpoint(), (Point3DReadOnly)lineSegment3D.getSecondEndpoint());
            Assertions.assertTrue((boolean)lineSegment3D.orthogonalProjection((Point3DReadOnly)query, (Point3DBasics)actual));
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testPointBetweenEndpointsGivenPercentage() throws Exception {
        Point3D actual;
        Point3D expected;
        double percentage;
        LineSegment3D lineSegment3D;
        int i;
        Random random = new Random(342L);
        for (i = 0; i < 1000; ++i) {
            lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            percentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            expected = new Point3D();
            expected.interpolate((Tuple3DReadOnly)lineSegment3D.getFirstEndpoint(), (Tuple3DReadOnly)lineSegment3D.getSecondEndpoint(), percentage);
            actual = new Point3D();
            actual = lineSegment3D.pointBetweenEndpointsGivenPercentage(percentage);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            percentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            expected = new Point3D();
            expected.interpolate((Tuple3DReadOnly)lineSegment3D.getFirstEndpoint(), (Tuple3DReadOnly)lineSegment3D.getSecondEndpoint(), percentage);
            actual = new Point3D();
            lineSegment3D.pointBetweenEndpointsGivenPercentage(percentage, (Point3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
        try {
            new LineSegment3D().pointBetweenEndpointsGivenPercentage(-4.9E-324);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            new LineSegment3D().pointBetweenEndpointsGivenPercentage(1.0000000000000002);
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            new LineSegment3D().pointBetweenEndpointsGivenPercentage(-4.9E-324, (Point3DBasics)new Point3D());
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            new LineSegment3D().pointBetweenEndpointsGivenPercentage(1.0000000000000002, (Point3DBasics)new Point3D());
            Assertions.fail((String)("Should have thrown a " + RuntimeException.class.getSimpleName()));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testPointOnLineGivenPercentage() throws Exception {
        Random random = new Random(342L);
        for (int i = 0; i < 1000; ++i) {
            LineSegment3D lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            double percentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            Point3D expected = new Point3D();
            expected.interpolate((Tuple3DReadOnly)lineSegment3D.getFirstEndpoint(), (Tuple3DReadOnly)lineSegment3D.getSecondEndpoint(), percentage);
            Point3D actual = new Point3D();
            actual = lineSegment3D.pointOnLineGivenPercentage(percentage);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testMidPoint() throws Exception {
        Random random = new Random(32244L);
        for (int i = 0; i < 1000; ++i) {
            LineSegment3D lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            Point3D expected = new Point3D();
            expected = EuclidGeometryTools.averagePoint3Ds((Point3DReadOnly)lineSegment3D.getFirstEndpoint(), (Point3DReadOnly)lineSegment3D.getSecondEndpoint());
            Point3D actual = new Point3D();
            lineSegment3D.midpoint((Point3DBasics)actual);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testGetDirection() throws Exception {
        Vector3D expectedDirection;
        Vector3D actualDirection;
        LineSegment3D lineSegment3D;
        int i;
        Random random = new Random(1000L);
        for (i = 0; i < 1000; ++i) {
            lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            actualDirection = new Vector3D();
            lineSegment3D.getDirection(false, (Vector3DBasics)actualDirection);
            Point3DBasics firstEndpoint = lineSegment3D.getFirstEndpoint();
            Point3DBasics secondEndpoint = lineSegment3D.getSecondEndpoint();
            Vector3D expectedDirection2 = new Vector3D();
            expectedDirection2.sub((Tuple3DReadOnly)secondEndpoint, (Tuple3DReadOnly)firstEndpoint);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedDirection2, (EuclidGeometry)actualDirection, (double)1.0E-12);
            Assertions.assertEquals((double)lineSegment3D.length(), (double)actualDirection.norm(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            actualDirection = new Vector3D();
            lineSegment3D.getDirection(true, (Vector3DBasics)actualDirection);
            Assertions.assertEquals((double)1.0, (double)actualDirection.norm(), (double)1.0E-12);
            expectedDirection = new Vector3D();
            lineSegment3D.getDirection(false, (Vector3DBasics)expectedDirection);
            expectedDirection.scale(1.0 / lineSegment3D.length());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedDirection, (EuclidGeometry)actualDirection, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            actualDirection = lineSegment3D.getDirection(false);
            expectedDirection = new Vector3D();
            lineSegment3D.getDirection(false, (Vector3DBasics)expectedDirection);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedDirection, (EuclidGeometry)actualDirection, (double)1.0E-12);
            Assertions.assertEquals((double)lineSegment3D.length(), (double)actualDirection.norm(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            actualDirection = lineSegment3D.getDirection(true);
            Assertions.assertEquals((double)1.0, (double)actualDirection.norm(), (double)1.0E-12);
            expectedDirection = new Vector3D();
            lineSegment3D.getDirection(true, (Vector3DBasics)expectedDirection);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedDirection, (EuclidGeometry)actualDirection, (double)1.0E-12);
        }
    }

    @Test
    public void testIsBetweenEndpoints() throws Exception {
        double epsilon;
        double percentage;
        LineSegment3D lineSegment3D;
        int i;
        Random random = new Random(32423L);
        for (i = 0; i < 1000; ++i) {
            lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            percentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point3DBasics pointInside = lineSegment3D.pointBetweenEndpointsGivenPercentage(percentage);
            Assertions.assertTrue((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointInside));
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double epsilonLength = epsilon * lineSegment3D.length();
            double distanceInside = Math.min(lineSegment3D.getFirstEndpoint().distance((Point3DReadOnly)pointInside), lineSegment3D.getSecondEndpoint().distance((Point3DReadOnly)pointInside));
            if (distanceInside < epsilonLength) {
                Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointInside, epsilon));
                Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints(pointInside.getX(), pointInside.getY(), pointInside.getZ(), epsilon));
            } else {
                Assertions.assertTrue((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointInside, epsilon));
                Assertions.assertTrue((boolean)lineSegment3D.isBetweenEndpoints(pointInside.getX(), pointInside.getY(), pointInside.getZ(), epsilon));
            }
            Assertions.assertTrue((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)new Point3D((Tuple3DReadOnly)lineSegment3D.getFirstEndpoint())));
            Assertions.assertTrue((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)new Point3D((Tuple3DReadOnly)lineSegment3D.getSecondEndpoint())));
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)new Point3D((Tuple3DReadOnly)lineSegment3D.getFirstEndpoint()), Double.MIN_VALUE));
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)new Point3D((Tuple3DReadOnly)lineSegment3D.getSecondEndpoint()), 5.55555E-17));
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints(lineSegment3D.getFirstEndpoint().getX(), lineSegment3D.getFirstEndpoint().getY(), lineSegment3D.getFirstEndpoint().getZ(), Double.MIN_VALUE));
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints(lineSegment3D.getSecondEndpoint().getX(), lineSegment3D.getSecondEndpoint().getY(), lineSegment3D.getSecondEndpoint().getZ(), 5.55555E-17));
            Vector3D orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegment3D.getDirection(true), (boolean)true);
            pointInside.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)pointInside);
            Assertions.assertTrue((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointInside));
            if (distanceInside < epsilonLength) {
                Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointInside, epsilon));
                Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints(pointInside.getX(), pointInside.getY(), pointInside.getZ(), epsilon));
                continue;
            }
            Assertions.assertTrue((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointInside, epsilon));
            Assertions.assertTrue((boolean)lineSegment3D.isBetweenEndpoints(pointInside.getX(), pointInside.getY(), pointInside.getZ(), epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            percentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            Point3DBasics pointBefore = lineSegment3D.pointOnLineGivenPercentage(percentage);
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointBefore));
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointBefore, epsilon));
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints(pointBefore.getX(), pointBefore.getY(), pointBefore.getZ(), epsilon));
            Vector3D orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegment3D.getDirection(true), (boolean)true);
            pointBefore.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)pointBefore);
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointBefore));
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointBefore, epsilon));
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints(pointBefore.getX(), pointBefore.getY(), pointBefore.getZ(), epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            percentage = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
            Point3DBasics pointAfter = lineSegment3D.pointOnLineGivenPercentage(percentage);
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointAfter));
            epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointAfter, epsilon));
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints(pointAfter.getX(), pointAfter.getY(), pointAfter.getZ(), epsilon));
            Vector3D orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)lineSegment3D.getDirection(true), (boolean)true);
            pointAfter.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)orthogonal, (Tuple3DReadOnly)pointAfter);
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointAfter));
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints((Point3DReadOnly)pointAfter, epsilon));
            Assertions.assertFalse((boolean)lineSegment3D.isBetweenEndpoints(pointAfter.getX(), pointAfter.getY(), pointAfter.getZ(), epsilon));
        }
    }

    @Test
    public void testPercentageAlongLineSegment() throws Exception {
        Random random = new Random(23452L);
        for (int i = 0; i < 1000; ++i) {
            LineSegment3D lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            Point3D query = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            double expected = EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)query, (Point3DReadOnly)lineSegment3D.getFirstEndpoint(), (Point3DReadOnly)lineSegment3D.getSecondEndpoint());
            double actual = lineSegment3D.percentageAlongLineSegment((Point3DReadOnly)query);
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
            actual = lineSegment3D.percentageAlongLineSegment(query.getX(), query.getY(), query.getZ());
            Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testGetters() throws Exception {
        Random random = new Random(3242L);
        for (int i = 0; i < 1000; ++i) {
            Point3D expectedFirstEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D expectedSecondEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            LineSegment3D lineSegment3D = new LineSegment3D((Point3DReadOnly)expectedFirstEndpoint, (Point3DReadOnly)expectedSecondEndpoint);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstEndpoint, (EuclidGeometry)lineSegment3D.getFirstEndpoint(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondEndpoint, (EuclidGeometry)lineSegment3D.getSecondEndpoint(), (double)1.0E-12);
            Assertions.assertFalse((expectedFirstEndpoint == lineSegment3D.getFirstEndpoint() ? 1 : 0) != 0);
            Assertions.assertFalse((expectedSecondEndpoint == lineSegment3D.getSecondEndpoint() ? 1 : 0) != 0);
            Point3D actualFirstEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D actualSecondEndpoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            actualFirstEndpoint.set((Tuple3DReadOnly)lineSegment3D.getFirstEndpoint());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstEndpoint, (EuclidGeometry)actualFirstEndpoint, (double)1.0E-12);
            actualSecondEndpoint.set((Tuple3DReadOnly)lineSegment3D.getSecondEndpoint());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondEndpoint, (EuclidGeometry)actualSecondEndpoint, (double)1.0E-12);
        }
    }

    @Test
    public void testApplyTransform() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            LineSegment3D lineSegment3d = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)1.0E-12);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Point3D expectedFirstEndPoint = new Point3D((Tuple3DReadOnly)lineSegment3d.getFirstEndpoint());
            Point3D expectedSecondEndpoint = new Point3D((Tuple3DReadOnly)lineSegment3d.getSecondEndpoint());
            lineSegment3d.applyTransform((Transform)transform);
            expectedFirstEndPoint.applyTransform((Transform)transform);
            expectedSecondEndpoint.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstEndPoint, (EuclidGeometry)lineSegment3d.getFirstEndpoint(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondEndpoint, (EuclidGeometry)lineSegment3d.getSecondEndpoint(), (double)1.0E-12);
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            double element;
            int j;
            LineSegment3D line1 = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)1.0E-12);
            LineSegment3D line2 = new LineSegment3D((LineSegment3DReadOnly)line1);
            double epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
            for (j = 0; j < 3; ++j) {
                line2.set((LineSegment3DReadOnly)line1);
                Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
                element = line1.getFirstEndpoint().getElement(j);
                Point3D firstEndpoint = new Point3D((Tuple3DReadOnly)line2.getFirstEndpoint());
                firstEndpoint.setElement(j, element + 0.999 * epsilon);
                line2.getFirstEndpoint().set((Tuple3DReadOnly)firstEndpoint);
                Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
                firstEndpoint.setElement(j, element - 0.999 * epsilon);
                line2.getFirstEndpoint().set((Tuple3DReadOnly)firstEndpoint);
                Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
                firstEndpoint.setElement(j, element + 1.001 * epsilon);
                line2.getFirstEndpoint().set((Tuple3DReadOnly)firstEndpoint);
                Assertions.assertFalse((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
                firstEndpoint.setElement(j, element - 1.001 * epsilon);
                line2.getFirstEndpoint().set((Tuple3DReadOnly)firstEndpoint);
                Assertions.assertFalse((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
            }
            for (j = 0; j < 3; ++j) {
                line2.set((LineSegment3DReadOnly)line1);
                Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
                element = line1.getSecondEndpoint().getElement(j);
                Point3D secondEndpoint = new Point3D((Tuple3DReadOnly)line2.getSecondEndpoint());
                secondEndpoint.setElement(j, element + 0.999 * epsilon);
                line2.getSecondEndpoint().set((Tuple3DReadOnly)secondEndpoint);
                Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
                secondEndpoint.setElement(j, element - 0.999 * epsilon);
                line2.getSecondEndpoint().set((Tuple3DReadOnly)secondEndpoint);
                Assertions.assertTrue((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
                secondEndpoint.setElement(j, element + 1.001 * epsilon);
                line2.getSecondEndpoint().set((Tuple3DReadOnly)secondEndpoint);
                Assertions.assertFalse((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
                secondEndpoint.setElement(j, element - 1.001 * epsilon);
                line2.getSecondEndpoint().set((Tuple3DReadOnly)secondEndpoint);
                Assertions.assertFalse((boolean)line1.epsilonEquals((EuclidGeometry)line2, epsilon));
            }
        }
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            double element;
            int j;
            LineSegment3D line1 = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)1.0E-12);
            LineSegment3D line2 = new LineSegment3D((LineSegment3DReadOnly)line1);
            double epsilon = 1.0E-15;
            Assertions.assertTrue((boolean)line1.equals((EuclidGeometry)line2));
            LineSegment3D line2AsObject = line2;
            Assertions.assertTrue((boolean)line1.equals((Object)line2AsObject));
            EuclidGeometry nullAsLineSegment3D = null;
            Assertions.assertFalse((boolean)line1.equals(nullAsLineSegment3D));
            Object nullAsObject = null;
            Assertions.assertFalse((boolean)line1.equals(nullAsObject));
            Assertions.assertFalse((boolean)line1.equals((Object)new double[3]));
            for (j = 0; j < 3; ++j) {
                line2.set((LineSegment3DReadOnly)line1);
                Assertions.assertTrue((boolean)line1.equals((EuclidGeometry)line2));
                element = line1.getFirstEndpoint().getElement(j);
                Point3D firstEndpoint = new Point3D((Tuple3DReadOnly)line2.getFirstEndpoint());
                firstEndpoint.setElement(j, element + epsilon);
                line2.getFirstEndpoint().set((Tuple3DReadOnly)firstEndpoint);
                Assertions.assertFalse((boolean)line1.equals((EuclidGeometry)line2));
                firstEndpoint.setElement(j, element - epsilon);
                line2.getFirstEndpoint().set((Tuple3DReadOnly)firstEndpoint);
                Assertions.assertFalse((boolean)line1.equals((EuclidGeometry)line2));
            }
            for (j = 0; j < 3; ++j) {
                line2.set((LineSegment3DReadOnly)line1);
                Assertions.assertTrue((boolean)line1.equals((EuclidGeometry)line2));
                element = line1.getSecondEndpoint().getElement(j);
                Point3D secondEndpoint = new Point3D((Tuple3DReadOnly)line2.getSecondEndpoint());
                secondEndpoint.setElement(j, element + epsilon);
                line2.getSecondEndpoint().set((Tuple3DReadOnly)secondEndpoint);
                Assertions.assertFalse((boolean)line1.equals((EuclidGeometry)line2));
                secondEndpoint.setElement(j, element - epsilon);
                line2.getSecondEndpoint().set((Tuple3DReadOnly)secondEndpoint);
                Assertions.assertFalse((boolean)line1.equals((EuclidGeometry)line2));
            }
        }
    }

    @Test
    public void testTranslate() throws Exception {
        LineSegment3D translatedLineSegment;
        LineSegment3D originalLineSegment;
        int i;
        Random random = new Random(3653L);
        for (i = 0; i < 1000; ++i) {
            originalLineSegment = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            translatedLineSegment = new LineSegment3D((LineSegment3DReadOnly)originalLineSegment);
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double z = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            translatedLineSegment.translate(x, y, z);
            Assertions.assertEquals((double)originalLineSegment.length(), (double)translatedLineSegment.length(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalLineSegment.getDirection(false), (EuclidGeometry)translatedLineSegment.getDirection(false), (double)1.0E-12);
            LineSegment3D expectedLineSegment = new LineSegment3D((LineSegment3DReadOnly)originalLineSegment);
            RigidBodyTransform transform = new RigidBodyTransform();
            transform.getTranslation().set(x, y, z);
            expectedLineSegment.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineSegment, (EuclidGeometry)translatedLineSegment, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            originalLineSegment = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            translatedLineSegment = new LineSegment3D((LineSegment3DReadOnly)originalLineSegment);
            Point3D translation = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            translatedLineSegment.translate((Tuple3DReadOnly)translation);
            Assertions.assertEquals((double)originalLineSegment.length(), (double)translatedLineSegment.length(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)originalLineSegment.getDirection(false), (EuclidGeometry)translatedLineSegment.getDirection(false), (double)1.0E-12);
            LineSegment3D expectedLineSegment = new LineSegment3D((LineSegment3DReadOnly)originalLineSegment);
            RigidBodyTransform transform = new RigidBodyTransform();
            transform.getTranslation().set((Tuple3DReadOnly)translation);
            expectedLineSegment.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLineSegment, (EuclidGeometry)translatedLineSegment, (double)1.0E-12);
        }
    }

    @Test
    public void testGeometricallyEquals() {
        Random random = new Random(19263L);
        Point3D segment1Point1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Point3D segment1Point2 = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Point3D segment2Point1 = new Point3D((Tuple3DReadOnly)segment1Point1);
        Point3D segment2Point2 = new Point3D((Tuple3DReadOnly)segment1Point2);
        LineSegment3D lineSegment1 = new LineSegment3D((Point3DReadOnly)segment1Point1, (Point3DReadOnly)segment1Point2);
        LineSegment3D lineSegment2 = new LineSegment3D((Point3DReadOnly)segment2Point1, (Point3DReadOnly)segment2Point2);
        Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment1, 1.0E-12));
        Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
        Assertions.assertTrue((boolean)lineSegment2.geometricallyEquals((EuclidGeometry)lineSegment1, 1.0E-12));
        Assertions.assertTrue((boolean)lineSegment2.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
        for (int i = 0; i < 1000; ++i) {
            segment1Point1 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            segment1Point2 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            segment2Point1 = new Point3D();
            segment2Point2 = new Point3D();
            lineSegment1 = new LineSegment3D((Point3DReadOnly)segment1Point1, (Point3DReadOnly)segment1Point2);
            segment2Point1.set((Tuple3DReadOnly)segment1Point1);
            segment2Point2.add((Tuple3DReadOnly)segment1Point2, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)9.9E-13));
            lineSegment2 = new LineSegment3D((Point3DReadOnly)segment2Point1, (Point3DReadOnly)segment2Point2);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
            lineSegment2 = new LineSegment3D((Point3DReadOnly)segment2Point2, (Point3DReadOnly)segment2Point1);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
            segment2Point1.set((Tuple3DReadOnly)segment1Point1);
            segment2Point2.add((Tuple3DReadOnly)segment1Point2, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.01E-12));
            lineSegment2 = new LineSegment3D((Point3DReadOnly)segment2Point1, (Point3DReadOnly)segment2Point2);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
            lineSegment2 = new LineSegment3D((Point3DReadOnly)segment2Point2, (Point3DReadOnly)segment2Point1);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
            segment2Point1.add((Tuple3DReadOnly)segment1Point1, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)9.9E-13));
            segment2Point2.set((Tuple3DReadOnly)segment1Point2);
            lineSegment2 = new LineSegment3D((Point3DReadOnly)segment2Point1, (Point3DReadOnly)segment2Point2);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
            lineSegment2 = new LineSegment3D((Point3DReadOnly)segment2Point2, (Point3DReadOnly)segment2Point1);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
            segment2Point1.add((Tuple3DReadOnly)segment1Point1, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.01E-12));
            segment2Point2.set((Tuple3DReadOnly)segment1Point2);
            lineSegment2 = new LineSegment3D((Point3DReadOnly)segment2Point1, (Point3DReadOnly)segment2Point2);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
            lineSegment2 = new LineSegment3D((Point3DReadOnly)segment2Point2, (Point3DReadOnly)segment2Point1);
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
            lineSegment2.set((LineSegment3DReadOnly)lineSegment1);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
            lineSegment2.translate((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)9.9E-13));
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
            lineSegment2.flipDirection();
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
            lineSegment2.set((LineSegment3DReadOnly)lineSegment1);
            Assertions.assertTrue((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
            lineSegment2.translate((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.01E-12));
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
            lineSegment2.flipDirection();
            Assertions.assertFalse((boolean)lineSegment1.geometricallyEquals((EuclidGeometry)lineSegment2, 1.0E-12));
        }
    }
}

