/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.exceptions.BoundingBoxException;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class BoundingBox3DTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testConstructors() throws Exception {
        Random random = new Random(345345L);
        Point3D min = new Point3D();
        Point3D max = new Point3D();
        BoundingBox3D boundingBox = new BoundingBox3D();
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)boundingBox.getMinPoint());
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)boundingBox.getMaxPoint());
        min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple3DReadOnly)min);
        boundingBox = new BoundingBox3D((Point3DReadOnly)min, (Point3DReadOnly)max);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)min, (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)max, (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple3DReadOnly)min);
        boundingBox = new BoundingBox3D((BoundingBox3DReadOnly)new BoundingBox3D((Point3DReadOnly)min, (Point3DReadOnly)max));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)min, (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)max, (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple3DReadOnly)min);
        double[] minArray = new double[3];
        double[] maxArray = new double[3];
        min.get(minArray);
        max.get(maxArray);
        boundingBox = new BoundingBox3D(minArray, maxArray);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)min, (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)max, (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple3DReadOnly)min);
        boundingBox = new BoundingBox3D(min.getX(), min.getY(), min.getZ(), max.getX(), max.getY(), max.getZ());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)min, (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)max, (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-12);
        try {
            new BoundingBox3D(new double[]{1.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            new BoundingBox3D(new double[]{0.0, 1.0, 0.0}, new double[]{0.0, 0.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            new BoundingBox3D(new double[]{0.0, 0.0, 1.0}, new double[]{0.0, 0.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            new BoundingBox3D((Point3DReadOnly)new Point3D(1.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(0.0, 0.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            new BoundingBox3D((Point3DReadOnly)new Point3D(0.0, 1.0, 0.0), (Point3DReadOnly)new Point3D(0.0, 0.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            new BoundingBox3D((Point3DReadOnly)new Point3D(0.0, 0.0, 1.0), (Point3DReadOnly)new Point3D(0.0, 0.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            new BoundingBox3D(1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            new BoundingBox3D(0.0, 1.0, 0.0, 0.0, 0.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            new BoundingBox3D(0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        new BoundingBox3D(new double[]{1.0, 1.0, 1.0}, new double[]{1.0, 1.0, 1.0});
        new BoundingBox3D((Point3DReadOnly)new Point3D(1.0, 1.0, 1.0), (Point3DReadOnly)new Point3D(1.0, 1.0, 1.0));
        new BoundingBox3D(1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
    }

    @Test
    public void testStaticConstructors() throws Exception {
        Random random = new Random(32443L);
        Point3D min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        Point3D max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple3DReadOnly)min);
        Point3D center = new Point3D();
        center.add((Tuple3DReadOnly)min, (Tuple3DReadOnly)max);
        center.scale(0.5);
        Vector3D halfSize = new Vector3D();
        halfSize.sub((Tuple3DReadOnly)max, (Tuple3DReadOnly)min);
        halfSize.scale(0.5);
        BoundingBox3D boundingBox = BoundingBox3D.createUsingCenterAndPlusMinusVector((Point3DReadOnly)center, (Tuple3DReadOnly)halfSize);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)min, (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)max, (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-12);
        for (int i = 0; i < 1000; ++i) {
            BoundingBox3D boundingBoxOne = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            BoundingBox3D boundingBoxTwo = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            BoundingBox3D expected = new BoundingBox3D();
            expected.combine((BoundingBox3DReadOnly)boundingBoxOne, (BoundingBox3DReadOnly)boundingBoxTwo);
            BoundingBox3D actual = BoundingBox3D.union((BoundingBox3DReadOnly)boundingBoxOne, (BoundingBox3DReadOnly)boundingBoxTwo);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testSetMin() throws Exception {
        Random random = new Random(3242L);
        BoundingBox3D boundingBox = new BoundingBox3D();
        Point3D min = new Point3D();
        min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)-10.0, (double)0.0);
        boundingBox.setMin((Point3DReadOnly)min);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)min, (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)-10.0, (double)0.0);
        boundingBox.setMin(new double[]{min.getX(), min.getY(), min.getZ()});
        EuclidCoreTestTools.assertEquals((EuclidGeometry)min, (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)-10.0, (double)0.0);
        boundingBox.setMin(min.getX(), min.getY(), min.getZ());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)min, (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-12);
        boundingBox.setToZero();
        try {
            boundingBox.setMin(new double[]{1.0, 0.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMin(new double[]{0.0, 1.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMin(new double[]{0.0, 0.0, 1.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMin((Point3DReadOnly)new Point3D(1.0, 0.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMin((Point3DReadOnly)new Point3D(0.0, 1.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMin((Point3DReadOnly)new Point3D(0.0, 0.0, 1.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMin(1.0, 0.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMin(0.0, 1.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMin(0.0, 0.0, 1.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        boundingBox.setMin(new double[]{0.0, 0.0, 0.0});
        boundingBox.setMin((Point3DReadOnly)new Point3D(0.0, 0.0, 0.0));
        boundingBox.setMin(0.0, 0.0, 0.0);
    }

    @Test
    public void testSetMax() throws Exception {
        Random random = new Random(3242L);
        BoundingBox3D boundingBox = new BoundingBox3D();
        Point3D max = new Point3D();
        max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
        boundingBox.setMax((Point3DReadOnly)max);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)max, (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-12);
        max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
        boundingBox.setMax(new double[]{max.getX(), max.getY(), max.getZ()});
        EuclidCoreTestTools.assertEquals((EuclidGeometry)max, (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-12);
        max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
        boundingBox.setMax(max.getX(), max.getY(), max.getZ());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)max, (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-12);
        boundingBox.setToZero();
        try {
            boundingBox.setMax(new double[]{-1.0, 0.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMax(new double[]{0.0, -1.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMax(new double[]{0.0, 0.0, -1.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMax((Point3DReadOnly)new Point3D(-1.0, 0.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMax((Point3DReadOnly)new Point3D(0.0, -1.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMax((Point3DReadOnly)new Point3D(0.0, 0.0, -1.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMax(-1.0, 0.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMax(0.0, -1.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMax(0.0, 0.0, -1.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        boundingBox.setMax(new double[]{0.0, 0.0, 0.0});
        boundingBox.setMax((Point3DReadOnly)new Point3D(0.0, 0.0, 0.0));
        boundingBox.setMax(0.0, 0.0, 0.0);
    }

    @Test
    public void testSetters() throws Exception {
        Random random = new Random(34534L);
        BoundingBox3D boundingBox = new BoundingBox3D();
        Point3D min = new Point3D();
        Point3D max = new Point3D();
        min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple3DReadOnly)min);
        boundingBox.set(min.getX(), min.getY(), min.getZ(), max.getX(), max.getY(), max.getZ());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)min, (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)max, (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple3DReadOnly)min);
        double[] minArray = new double[3];
        double[] maxArray = new double[3];
        min.get(minArray);
        max.get(maxArray);
        boundingBox.set(minArray, maxArray);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)min, (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)max, (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple3DReadOnly)min);
        boundingBox.set((Point3DReadOnly)min, (Point3DReadOnly)max);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)min, (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)max, (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple3DReadOnly)min);
        Point3D center = new Point3D();
        center.add((Tuple3DReadOnly)min, (Tuple3DReadOnly)max);
        center.scale(0.5);
        Vector3D halfSize = new Vector3D();
        halfSize.sub((Tuple3DReadOnly)max, (Tuple3DReadOnly)min);
        halfSize.scale(0.5);
        boundingBox.set((Point3DReadOnly)center, (Vector3DReadOnly)halfSize);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)min, (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)max, (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple3DReadOnly)min);
        boundingBox.set((BoundingBox3DReadOnly)new BoundingBox3D((Point3DReadOnly)min, (Point3DReadOnly)max));
        EuclidCoreTestTools.assertEquals((EuclidGeometry)min, (EuclidGeometry)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)max, (EuclidGeometry)boundingBox.getMaxPoint(), (double)1.0E-12);
        try {
            boundingBox.set(new double[]{1.0, 0.0, 0.0}, new double[]{0.0, 0.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set(new double[]{0.0, 1.0, 0.0}, new double[]{0.0, 0.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set(new double[]{0.0, 0.0, 1.0}, new double[]{0.0, 0.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set((Point3DReadOnly)new Point3D(1.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(0.0, 0.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set((Point3DReadOnly)new Point3D(0.0, 1.0, 0.0), (Point3DReadOnly)new Point3D(0.0, 0.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set((Point3DReadOnly)new Point3D(0.0, 0.0, 1.0), (Point3DReadOnly)new Point3D(0.0, 0.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set((Point3DReadOnly)new Point3D(1.0, 0.0, 0.0), (Vector3DReadOnly)new Vector3D(-1.0, 0.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set((Point3DReadOnly)new Point3D(1.0, 0.0, 0.0), (Vector3DReadOnly)new Vector3D(0.0, -1.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set((Point3DReadOnly)new Point3D(1.0, 0.0, 0.0), (Vector3DReadOnly)new Vector3D(0.0, 0.0, -1.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set(1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set(0.0, 1.0, 0.0, 0.0, 0.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set(0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        boundingBox.set(new double[]{1.0, 1.0, 1.0}, new double[]{1.0, 1.0, 1.0});
        boundingBox.set((Point3DReadOnly)new Point3D(1.0, 1.0, 1.0), (Point3DReadOnly)new Point3D(1.0, 1.0, 1.0));
        boundingBox.set(1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
    }

    @Test
    public void testCombine() throws Exception {
        int axisIndex;
        Point3DReadOnly[] originalMaxCoordinates;
        boolean isMinCoordinateFromOriginal;
        Point3DReadOnly[] originalMinCoordinates;
        BoundingBox3D combined;
        BoundingBox3D boundingBoxTwo;
        BoundingBox3D boundingBoxOne;
        int i;
        Random random = new Random(234234L);
        for (i = 0; i < 1000; ++i) {
            int n;
            boundingBoxOne = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            boundingBoxTwo = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            combined = new BoundingBox3D();
            combined.combine((BoundingBox3DReadOnly)boundingBoxOne, (BoundingBox3DReadOnly)boundingBoxTwo);
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point3DReadOnly)boundingBoxOne.getMinPoint()));
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point3DReadOnly)boundingBoxOne.getMaxPoint()));
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point3DReadOnly)boundingBoxTwo.getMinPoint()));
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point3DReadOnly)boundingBoxTwo.getMaxPoint()));
            originalMinCoordinates = new Point3DReadOnly[]{boundingBoxOne.getMinPoint(), boundingBoxTwo.getMinPoint()};
            for (int axisIndex2 = 0; axisIndex2 < 3; ++axisIndex2) {
                isMinCoordinateFromOriginal = false;
                Point3DReadOnly[] point3DReadOnlyArray = originalMinCoordinates;
                int n2 = point3DReadOnlyArray.length;
                for (n = 0; n < n2; ++n) {
                    Point3DReadOnly originalCoordinate = point3DReadOnlyArray[n];
                    if (combined.getMinPoint().getElement(axisIndex2) != originalCoordinate.getElement(axisIndex2)) continue;
                    isMinCoordinateFromOriginal = true;
                    break;
                }
                Assertions.assertTrue((boolean)isMinCoordinateFromOriginal, (String)("Unexpected min coordinate for the combined bounding box, axis index = " + axisIndex2));
            }
            originalMaxCoordinates = new Point3DReadOnly[]{boundingBoxOne.getMaxPoint(), boundingBoxTwo.getMaxPoint()};
            for (axisIndex = 0; axisIndex < 3; ++axisIndex) {
                boolean isMaxCoordinateFromOriginal = false;
                Point3DReadOnly[] point3DReadOnlyArray = originalMaxCoordinates;
                n = point3DReadOnlyArray.length;
                for (int originalCoordinate = 0; originalCoordinate < n; ++originalCoordinate) {
                    Point3DReadOnly originalCoordinate2 = point3DReadOnlyArray[originalCoordinate];
                    if (combined.getMaxPoint().getElement(axisIndex) != originalCoordinate2.getElement(axisIndex)) continue;
                    isMaxCoordinateFromOriginal = true;
                    break;
                }
                Assertions.assertTrue((boolean)isMaxCoordinateFromOriginal, (String)("Unexpected max coordinate for the combined bounding box, axis index = " + axisIndex));
            }
        }
        for (i = 0; i < 1000; ++i) {
            boundingBoxOne = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            boundingBoxTwo = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            combined = new BoundingBox3D();
            combined.set((BoundingBox3DReadOnly)boundingBoxOne);
            combined.combine((BoundingBox3DReadOnly)boundingBoxTwo);
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point3DReadOnly)boundingBoxOne.getMinPoint()));
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point3DReadOnly)boundingBoxOne.getMaxPoint()));
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point3DReadOnly)boundingBoxTwo.getMinPoint()));
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point3DReadOnly)boundingBoxTwo.getMaxPoint()));
            originalMinCoordinates = new Point3DReadOnly[]{boundingBoxOne.getMinPoint(), boundingBoxTwo.getMinPoint()};
            for (int axisIndex3 = 0; axisIndex3 < 3; ++axisIndex3) {
                isMinCoordinateFromOriginal = false;
                for (Point3DReadOnly originalCoordinate : originalMinCoordinates) {
                    if (combined.getMinPoint().getElement(axisIndex3) != originalCoordinate.getElement(axisIndex3)) continue;
                    isMinCoordinateFromOriginal = true;
                    break;
                }
                Assertions.assertTrue((boolean)isMinCoordinateFromOriginal, (String)("Unexpected min coordinate for the combined bounding box, axis index = " + axisIndex3));
            }
            originalMaxCoordinates = new Point3DReadOnly[]{boundingBoxOne.getMaxPoint(), boundingBoxTwo.getMaxPoint()};
            for (axisIndex = 0; axisIndex < 3; ++axisIndex) {
                boolean isMaxCoordinateFromOriginal = false;
                for (Point3DReadOnly originalCoordinate2 : originalMaxCoordinates) {
                    if (combined.getMaxPoint().getElement(axisIndex) != originalCoordinate2.getElement(axisIndex)) continue;
                    isMaxCoordinateFromOriginal = true;
                    break;
                }
                Assertions.assertTrue((boolean)isMaxCoordinateFromOriginal, (String)("Unexpected max coordinate for the combined bounding box, axis index = " + axisIndex));
            }
        }
        for (i = 0; i < 1000; ++i) {
            boundingBoxOne = new BoundingBox3D();
            boundingBoxOne.setToNaN();
            boundingBoxTwo = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            combined = new BoundingBox3D();
            combined.set((BoundingBox3DReadOnly)boundingBoxOne);
            combined.combine((BoundingBox3DReadOnly)boundingBoxTwo);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)boundingBoxTwo, (EuclidGeometry)combined, (double)1.0E-12);
            boundingBoxOne = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            boundingBoxTwo.setToNaN();
            combined = new BoundingBox3D();
            combined.set((BoundingBox3DReadOnly)boundingBoxOne);
            combined.combine((BoundingBox3DReadOnly)boundingBoxTwo);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)boundingBoxOne, (EuclidGeometry)combined, (double)1.0E-12);
        }
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(453453L);
        BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
        boundingBox3D.setToNaN();
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)boundingBox3D.getMinPoint());
        EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)boundingBox3D.getMaxPoint());
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(453453L);
        BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
        boundingBox3D.setToZero();
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)boundingBox3D.getMinPoint());
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)boundingBox3D.getMaxPoint());
    }

    @Test
    public void testContainsNaN() throws Exception {
        Random random = new Random(23434L);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertFalse((boolean)EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0).containsNaN());
        }
        Assertions.assertTrue((boolean)new BoundingBox3D(Double.NaN, 0.0, 0.0, 0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)new BoundingBox3D(0.0, Double.NaN, 0.0, 0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)new BoundingBox3D(0.0, 0.0, Double.NaN, 0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)new BoundingBox3D(0.0, 0.0, 0.0, Double.NaN, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)new BoundingBox3D(0.0, 0.0, 0.0, 0.0, Double.NaN, 0.0).containsNaN());
        Assertions.assertTrue((boolean)new BoundingBox3D(0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN).containsNaN());
    }

    @Test
    public void testGetCenterPoint() throws Exception {
        Random random = new Random(24324L);
        for (int i = 0; i < 1000; ++i) {
            Point3D center = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D halfSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            BoundingBox3D boundingBox3D = new BoundingBox3D();
            boundingBox3D.set((Point3DReadOnly)center, (Vector3DReadOnly)halfSize);
            Point3D actualCenter = new Point3D();
            boundingBox3D.getCenterPoint((Point3DBasics)actualCenter);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)center, (EuclidGeometry)actualCenter, (double)1.0E-12);
            Vector3D centerToMin = new Vector3D();
            centerToMin.sub((Tuple3DReadOnly)boundingBox3D.getMinPoint(), (Tuple3DReadOnly)center);
            Vector3D centerToMax = new Vector3D();
            centerToMax.sub((Tuple3DReadOnly)boundingBox3D.getMaxPoint(), (Tuple3DReadOnly)center);
            centerToMax.negate();
            EuclidCoreTestTools.assertEquals((EuclidGeometry)centerToMax, (EuclidGeometry)centerToMin, (double)1.0E-12);
        }
    }

    @Test
    public void testGetPointGivenParameters() throws Exception {
        int i;
        Random random = new Random(324432L);
        for (i = 0; i < 1000; ++i) {
            Point3D expectedPoint = new Point3D();
            Point3D actualPoint = new Point3D();
            BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            expectedPoint.interpolate((Tuple3DReadOnly)boundingBox3D.getMinPoint(), (Tuple3DReadOnly)boundingBox3D.getMaxPoint(), alpha);
            boundingBox3D.getPointGivenParameters(alpha, alpha, alpha, (Point3DBasics)actualPoint);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)actualPoint, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D actualPoint = new Point3D();
            BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            Point3D alpha = new Point3D();
            for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                alpha.setElement(axisIndex, 0.0);
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)actualPoint);
                Assertions.assertEquals((double)boundingBox3D.getMinPoint().getElement(axisIndex), (double)actualPoint.getElement(axisIndex), (double)1.0E-12);
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                alpha.setElement(axisIndex, 1.0);
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)actualPoint);
                Assertions.assertEquals((double)boundingBox3D.getMaxPoint().getElement(axisIndex), (double)actualPoint.getElement(axisIndex), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testGetDiagonalLengthSquared() throws Exception {
        Random random = new Random(324234L);
        for (int i = 0; i < 1000; ++i) {
            Point3D center = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D halfSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            BoundingBox3D boundingBox3D = new BoundingBox3D();
            boundingBox3D.set((Point3DReadOnly)center, (Vector3DReadOnly)halfSize);
            Assertions.assertEquals((double)(4.0 * halfSize.normSquared()), (double)boundingBox3D.getDiagonalLengthSquared(), (double)1.0E-12);
        }
    }

    @Test
    public void testIsInsideExclusive() throws Exception {
        Random random = new Random(3243L);
        for (int i = 0; i < 1000; ++i) {
            BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            Point3DBasics minPoint = boundingBox3D.getMinPoint();
            Point3DBasics maxPoint = boundingBox3D.getMaxPoint();
            Assertions.assertFalse((boolean)boundingBox3D.isInsideExclusive((Point3DReadOnly)minPoint));
            Assertions.assertFalse((boolean)boundingBox3D.isInsideExclusive((Point3DReadOnly)maxPoint));
            Assertions.assertFalse((boolean)boundingBox3D.isInsideExclusive(minPoint.getX(), minPoint.getY(), minPoint.getZ()));
            Assertions.assertFalse((boolean)boundingBox3D.isInsideExclusive(maxPoint.getX(), maxPoint.getY(), maxPoint.getZ()));
            Point3D alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)Double.MIN_VALUE, (double)0.999999999999999);
            Point3D query = new Point3D();
            boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
            Assertions.assertTrue((boolean)boundingBox3D.isInsideExclusive((Point3DReadOnly)query));
            Assertions.assertTrue((boolean)boundingBox3D.isInsideExclusive(query.getX(), query.getY(), query.getZ()));
            for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)Double.MIN_VALUE, (double)0.999999999999999);
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                Assertions.assertFalse((boolean)boundingBox3D.isInsideExclusive((Point3DReadOnly)query));
                Assertions.assertFalse((boolean)boundingBox3D.isInsideExclusive(query.getX(), query.getY(), query.getZ()));
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                Assertions.assertFalse((boolean)boundingBox3D.isInsideExclusive((Point3DReadOnly)query));
                Assertions.assertFalse((boolean)boundingBox3D.isInsideExclusive(query.getX(), query.getY(), query.getZ()));
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)Double.MIN_VALUE, (double)0.999999999999999);
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                query.setElement(axisIndex, minPoint.getElement(axisIndex));
                Assertions.assertFalse((boolean)boundingBox3D.isInsideExclusive((Point3DReadOnly)query));
                Assertions.assertFalse((boolean)boundingBox3D.isInsideExclusive(query.getX(), query.getY(), query.getZ()));
                query.setElement(axisIndex, maxPoint.getElement(axisIndex));
                Assertions.assertFalse((boolean)boundingBox3D.isInsideExclusive((Point3DReadOnly)query));
                Assertions.assertFalse((boolean)boundingBox3D.isInsideExclusive(query.getX(), query.getY(), query.getZ()));
            }
        }
    }

    @Test
    public void testIsInsideInclusive() throws Exception {
        Random random = new Random(3243L);
        for (int i = 0; i < 1000; ++i) {
            BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            Point3DBasics minPoint = boundingBox3D.getMinPoint();
            Point3DBasics maxPoint = boundingBox3D.getMaxPoint();
            Assertions.assertTrue((boolean)boundingBox3D.isInsideInclusive((Point3DReadOnly)minPoint));
            Assertions.assertTrue((boolean)boundingBox3D.isInsideInclusive((Point3DReadOnly)maxPoint));
            Assertions.assertTrue((boolean)boundingBox3D.isInsideInclusive(minPoint.getX(), minPoint.getY(), minPoint.getZ()));
            Assertions.assertTrue((boolean)boundingBox3D.isInsideInclusive(maxPoint.getX(), maxPoint.getY(), maxPoint.getZ()));
            Point3D alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)1.0);
            Point3D query = new Point3D();
            boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
            Assertions.assertTrue((boolean)boundingBox3D.isInsideInclusive((Point3DReadOnly)query));
            Assertions.assertTrue((boolean)boundingBox3D.isInsideInclusive(query.getX(), query.getY(), query.getZ()));
            for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)1.0);
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                Assertions.assertFalse((boolean)boundingBox3D.isInsideInclusive((Point3DReadOnly)query));
                Assertions.assertFalse((boolean)boundingBox3D.isInsideInclusive(query.getX(), query.getY(), query.getZ()));
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                Assertions.assertFalse((boolean)boundingBox3D.isInsideInclusive((Point3DReadOnly)query));
                Assertions.assertFalse((boolean)boundingBox3D.isInsideInclusive(query.getX(), query.getY(), query.getZ()));
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)1.0);
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                query.setElement(axisIndex, minPoint.getElement(axisIndex));
                Assertions.assertTrue((boolean)boundingBox3D.isInsideInclusive((Point3DReadOnly)query));
                Assertions.assertTrue((boolean)boundingBox3D.isInsideInclusive(query.getX(), query.getY(), query.getZ()));
                query.setElement(axisIndex, maxPoint.getElement(axisIndex));
                Assertions.assertTrue((boolean)boundingBox3D.isInsideInclusive((Point3DReadOnly)query));
                Assertions.assertTrue((boolean)boundingBox3D.isInsideInclusive(query.getX(), query.getY(), query.getZ()));
            }
        }
    }

    @Test
    public void testIsInsideEpsilon() throws Exception {
        Random random = new Random(3243L);
        for (int i = 0; i < 1000; ++i) {
            Point3D center = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D halfSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            BoundingBox3D boundingBoxEpsilon = BoundingBox3D.createUsingCenterAndPlusMinusVector((Point3DReadOnly)center, (Tuple3DReadOnly)halfSize);
            double epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.min(halfSize.getX(), Math.min(halfSize.getY(), halfSize.getZ()))), (double)1.0);
            halfSize.add(epsilon, epsilon, epsilon);
            BoundingBox3D boundingBoxExclusive = BoundingBox3D.createUsingCenterAndPlusMinusVector((Point3DReadOnly)center, (Tuple3DReadOnly)halfSize);
            Point3DBasics minPoint = boundingBoxEpsilon.getMinPoint();
            Point3DBasics maxPoint = boundingBoxEpsilon.getMaxPoint();
            Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)minPoint), (Object)boundingBoxEpsilon.isInsideEpsilon((Point3DReadOnly)minPoint, epsilon));
            Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)maxPoint), (Object)boundingBoxEpsilon.isInsideEpsilon((Point3DReadOnly)maxPoint, epsilon));
            Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)minPoint), (Object)boundingBoxEpsilon.isInsideEpsilon(minPoint.getX(), minPoint.getY(), minPoint.getZ(), epsilon));
            Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)maxPoint), (Object)boundingBoxEpsilon.isInsideEpsilon(maxPoint.getX(), maxPoint.getY(), maxPoint.getZ(), epsilon));
            Point3D alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)1.0);
            Point3D query = new Point3D();
            boundingBoxEpsilon.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
            Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon((Point3DReadOnly)query, epsilon));
            Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon(query.getX(), query.getY(), query.getZ(), epsilon));
            for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)1.0);
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                boundingBoxEpsilon.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon((Point3DReadOnly)query, epsilon));
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon(query.getX(), query.getY(), query.getZ(), epsilon));
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                boundingBoxEpsilon.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon((Point3DReadOnly)query, epsilon));
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon(query.getX(), query.getY(), query.getZ(), epsilon));
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)1.0);
                boundingBoxEpsilon.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                query.setElement(axisIndex, minPoint.getElement(axisIndex));
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon((Point3DReadOnly)query, epsilon));
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon(query.getX(), query.getY(), query.getZ(), epsilon));
                query.setElement(axisIndex, maxPoint.getElement(axisIndex));
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon((Point3DReadOnly)query, epsilon));
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point3DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon(query.getX(), query.getY(), query.getZ(), epsilon));
            }
            Assertions.assertFalse((boolean)boundingBoxEpsilon.isInsideEpsilon((Point3DReadOnly)boundingBoxEpsilon.getMaxPoint(), 0.0));
            Assertions.assertFalse((boolean)boundingBoxEpsilon.isInsideEpsilon((Point3DReadOnly)boundingBoxEpsilon.getMinPoint(), 0.0));
        }
    }

    @Test
    public void testIsXYInsideExclusive() throws Exception {
        Random random = new Random(3243L);
        for (int i = 0; i < 1000; ++i) {
            BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            Point3DBasics minPoint = boundingBox3D.getMinPoint();
            Point3DBasics maxPoint = boundingBox3D.getMaxPoint();
            Assertions.assertFalse((boolean)boundingBox3D.isXYInsideExclusive((Point2DReadOnly)new Point2D(minPoint.getX(), minPoint.getY())));
            Assertions.assertFalse((boolean)boundingBox3D.isXYInsideExclusive((Point2DReadOnly)new Point2D(maxPoint.getX(), maxPoint.getY())));
            Assertions.assertFalse((boolean)boundingBox3D.isXYInsideExclusive(minPoint.getX(), minPoint.getY()));
            Assertions.assertFalse((boolean)boundingBox3D.isXYInsideExclusive(maxPoint.getX(), maxPoint.getY()));
            Point3D alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)Double.MIN_VALUE, (double)0.999999999999999);
            Point2D query2D = new Point2D();
            Point3D query3D = new Point3D();
            boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), 0.0, (Point3DBasics)query3D);
            query2D.set(query3D.getX(), query3D.getY());
            Assertions.assertTrue((boolean)boundingBox3D.isXYInsideExclusive((Point2DReadOnly)query2D));
            Assertions.assertTrue((boolean)boundingBox3D.isXYInsideExclusive(query2D.getX(), query2D.getY()));
            for (int axisIndex = 0; axisIndex < 2; ++axisIndex) {
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)Double.MIN_VALUE, (double)0.999999999999999);
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query3D);
                query2D.set(query3D.getX(), query3D.getY());
                Assertions.assertFalse((boolean)boundingBox3D.isXYInsideExclusive((Point2DReadOnly)query2D));
                Assertions.assertFalse((boolean)boundingBox3D.isXYInsideExclusive(query2D.getX(), query2D.getY()));
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query3D);
                query2D.set(query3D.getX(), query3D.getY());
                Assertions.assertFalse((boolean)boundingBox3D.isXYInsideExclusive((Point2DReadOnly)query2D));
                Assertions.assertFalse((boolean)boundingBox3D.isXYInsideExclusive(query2D.getX(), query2D.getY()));
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)Double.MIN_VALUE, (double)0.999999999999999);
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query3D);
                query2D.set(query3D.getX(), query3D.getY());
                query2D.setElement(axisIndex, minPoint.getElement(axisIndex));
                Assertions.assertFalse((boolean)boundingBox3D.isXYInsideExclusive((Point2DReadOnly)query2D));
                Assertions.assertFalse((boolean)boundingBox3D.isXYInsideExclusive(query2D.getX(), query2D.getY()));
                query2D.setElement(axisIndex, maxPoint.getElement(axisIndex));
                Assertions.assertFalse((boolean)boundingBox3D.isXYInsideExclusive((Point2DReadOnly)query2D));
                Assertions.assertFalse((boolean)boundingBox3D.isXYInsideExclusive(query2D.getX(), query2D.getY()));
            }
        }
    }

    @Test
    public void testIsXYInsideInclusive() throws Exception {
        Random random = new Random(3243L);
        for (int i = 0; i < 1000; ++i) {
            BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            Point3DBasics minPoint = boundingBox3D.getMinPoint();
            Point3DBasics maxPoint = boundingBox3D.getMaxPoint();
            Assertions.assertTrue((boolean)boundingBox3D.isXYInsideInclusive((Point2DReadOnly)new Point2D(minPoint.getX(), minPoint.getY())));
            Assertions.assertTrue((boolean)boundingBox3D.isXYInsideInclusive((Point2DReadOnly)new Point2D(maxPoint.getX(), maxPoint.getY())));
            Assertions.assertTrue((boolean)boundingBox3D.isXYInsideInclusive(minPoint.getX(), minPoint.getY()));
            Assertions.assertTrue((boolean)boundingBox3D.isXYInsideInclusive(maxPoint.getX(), maxPoint.getY()));
            Point3D alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)1.0);
            Point3D query = new Point3D();
            boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
            Assertions.assertTrue((boolean)boundingBox3D.isInsideInclusive((Point3DReadOnly)query));
            Assertions.assertTrue((boolean)boundingBox3D.isInsideInclusive(query.getX(), query.getY(), query.getZ()));
            for (int axisIndex = 0; axisIndex < 2; ++axisIndex) {
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)1.0);
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                Assertions.assertFalse((boolean)boundingBox3D.isXYInsideInclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())));
                Assertions.assertFalse((boolean)boundingBox3D.isXYInsideInclusive(query.getX(), query.getY()));
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                Assertions.assertFalse((boolean)boundingBox3D.isXYInsideInclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())));
                Assertions.assertFalse((boolean)boundingBox3D.isXYInsideInclusive(query.getX(), query.getY()));
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)1.0);
                boundingBox3D.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                query.setElement(axisIndex, minPoint.getElement(axisIndex));
                Assertions.assertTrue((boolean)boundingBox3D.isXYInsideInclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())));
                Assertions.assertTrue((boolean)boundingBox3D.isXYInsideInclusive(query.getX(), query.getY()));
                query.setElement(axisIndex, maxPoint.getElement(axisIndex));
                Assertions.assertTrue((boolean)boundingBox3D.isXYInsideInclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())));
                Assertions.assertTrue((boolean)boundingBox3D.isXYInsideInclusive(query.getX(), query.getY()));
            }
        }
    }

    @Test
    public void testIsXYInsideEpsilon() throws Exception {
        Random random = new Random(3243L);
        for (int i = 0; i < 1000; ++i) {
            Point3D center = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D halfSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            BoundingBox3D boundingBoxEpsilon = BoundingBox3D.createUsingCenterAndPlusMinusVector((Point3DReadOnly)center, (Tuple3DReadOnly)halfSize);
            double epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.min(halfSize.getX(), Math.min(halfSize.getY(), halfSize.getZ()))), (double)1.0);
            halfSize.add(epsilon, epsilon, epsilon);
            BoundingBox3D boundingBoxExclusive = BoundingBox3D.createUsingCenterAndPlusMinusVector((Point3DReadOnly)center, (Tuple3DReadOnly)halfSize);
            Point3DBasics minPoint = boundingBoxEpsilon.getMinPoint();
            Point3DBasics maxPoint = boundingBoxEpsilon.getMaxPoint();
            Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(minPoint.getX(), minPoint.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon((Point2DReadOnly)new Point2D(minPoint.getX(), minPoint.getY()), epsilon));
            Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(maxPoint.getX(), maxPoint.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon((Point2DReadOnly)new Point2D(maxPoint.getX(), maxPoint.getY()), epsilon));
            Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(minPoint.getX(), minPoint.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon(minPoint.getX(), minPoint.getY(), epsilon));
            Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(maxPoint.getX(), maxPoint.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon(maxPoint.getX(), maxPoint.getY(), epsilon));
            Point3D alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)1.0);
            Point3D query = new Point3D();
            boundingBoxEpsilon.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
            Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon((Point2DReadOnly)new Point2D(query.getX(), query.getY()), epsilon));
            Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon(query.getX(), query.getY(), epsilon));
            for (int axisIndex = 0; axisIndex < 2; ++axisIndex) {
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)1.0);
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                boundingBoxEpsilon.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon((Point2DReadOnly)new Point2D(query.getX(), query.getY()), epsilon));
                Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon(query.getX(), query.getY(), epsilon));
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                boundingBoxEpsilon.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon((Point2DReadOnly)new Point2D(query.getX(), query.getY()), epsilon));
                Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon(query.getX(), query.getY(), epsilon));
                alpha = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.0, (double)1.0);
                boundingBoxEpsilon.getPointGivenParameters(alpha.getX(), alpha.getY(), alpha.getZ(), (Point3DBasics)query);
                query.setElement(axisIndex, minPoint.getElement(axisIndex));
                Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon((Point2DReadOnly)new Point2D(query.getX(), query.getY()), epsilon));
                Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon(query.getX(), query.getY(), epsilon));
                query.setElement(axisIndex, maxPoint.getElement(axisIndex));
                Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon((Point2DReadOnly)new Point2D(query.getX(), query.getY()), epsilon));
                Assertions.assertEquals((Object)boundingBoxExclusive.isXYInsideExclusive((Point2DReadOnly)new Point2D(query.getX(), query.getY())), (Object)boundingBoxEpsilon.isXYInsideEpsilon(query.getX(), query.getY(), epsilon));
            }
        }
    }

    @Test
    public void testIntersectsExclusive() throws Exception {
        Random random = new Random(34545L);
        for (int i = 0; i < 1000; ++i) {
            Point3D center = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D halfSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            BoundingBox3D boundingBox3D = BoundingBox3D.createUsingCenterAndPlusMinusVector((Point3DReadOnly)center, (Tuple3DReadOnly)halfSize);
            Point3D queryCenter = new Point3D();
            Vector3D queryHalfSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            BoundingBox3D query = new BoundingBox3D();
            double xParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double yParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double zParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            boundingBox3D.getPointGivenParameters(xParameter, yParameter, zParameter, (Point3DBasics)queryCenter);
            query.set((Point3DReadOnly)queryCenter, (Vector3DReadOnly)queryHalfSize);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsExclusive((BoundingBox3DReadOnly)query));
            for (double xSign = -1.0; xSign <= 1.0; xSign += 1.0) {
                for (double ySign = -1.0; ySign <= 1.0; ySign += 1.0) {
                    for (double zSign = -1.0; zSign <= 1.0; zSign += 1.0) {
                        Vector3D shift = new Vector3D();
                        shift.add((Tuple3DReadOnly)queryHalfSize, (Tuple3DReadOnly)halfSize);
                        shift.scale(xSign, ySign, zSign);
                        queryCenter.scaleAdd(0.999, (Tuple3DReadOnly)shift, (Tuple3DReadOnly)center);
                        query.set((Point3DReadOnly)queryCenter, (Vector3DReadOnly)queryHalfSize);
                        Assertions.assertTrue((boolean)boundingBox3D.intersectsExclusive((BoundingBox3DReadOnly)query));
                        if (Math.abs(xSign) + Math.abs(ySign) + Math.abs(zSign) == 0.0) continue;
                        queryCenter.scaleAdd(1.0001, (Tuple3DReadOnly)shift, (Tuple3DReadOnly)center);
                        query.set((Point3DReadOnly)queryCenter, (Vector3DReadOnly)queryHalfSize);
                        Assertions.assertFalse((boolean)boundingBox3D.intersectsExclusive((BoundingBox3DReadOnly)query));
                    }
                }
            }
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(-1.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsExclusive((BoundingBox3DReadOnly)query));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(0.0, -1.0, 0.0, 1.0, 0.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsExclusive((BoundingBox3DReadOnly)query));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(0.0, 0.0, -1.0, 1.0, 1.0, 0.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsExclusive((BoundingBox3DReadOnly)query));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(1.0, 0.0, 0.0, 2.0, 1.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsExclusive((BoundingBox3DReadOnly)query));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(0.0, 1.0, 0.0, 1.0, 2.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsExclusive((BoundingBox3DReadOnly)query));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(0.0, 0.0, 1.0, 1.0, 1.0, 2.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsExclusive((BoundingBox3DReadOnly)query));
        }
    }

    @Test
    public void testIntersectsInclusive() throws Exception {
        Random random = new Random(34545L);
        for (int i = 0; i < 1000; ++i) {
            Point3D center = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D halfSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            BoundingBox3D boundingBox3D = BoundingBox3D.createUsingCenterAndPlusMinusVector((Point3DReadOnly)center, (Tuple3DReadOnly)halfSize);
            Point3D queryCenter = new Point3D();
            Vector3D queryHalfSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            BoundingBox3D query = new BoundingBox3D();
            double xParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double yParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double zParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            boundingBox3D.getPointGivenParameters(xParameter, yParameter, zParameter, (Point3DBasics)queryCenter);
            query.set((Point3DReadOnly)queryCenter, (Vector3DReadOnly)queryHalfSize);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsInclusive((BoundingBox3DReadOnly)query));
            for (double xSign = -1.0; xSign <= 1.0; xSign += 1.0) {
                for (double ySign = -1.0; ySign <= 1.0; ySign += 1.0) {
                    for (double zSign = -1.0; zSign <= 1.0; zSign += 1.0) {
                        Vector3D shift = new Vector3D();
                        shift.add((Tuple3DReadOnly)queryHalfSize, (Tuple3DReadOnly)halfSize);
                        shift.scale(xSign, ySign, zSign);
                        queryCenter.scaleAdd(0.999, (Tuple3DReadOnly)shift, (Tuple3DReadOnly)center);
                        query.set((Point3DReadOnly)queryCenter, (Vector3DReadOnly)queryHalfSize);
                        Assertions.assertTrue((boolean)boundingBox3D.intersectsInclusive((BoundingBox3DReadOnly)query));
                        if (Math.abs(xSign) + Math.abs(ySign) + Math.abs(zSign) == 0.0) continue;
                        queryCenter.scaleAdd(1.0001, (Tuple3DReadOnly)shift, (Tuple3DReadOnly)center);
                        query.set((Point3DReadOnly)queryCenter, (Vector3DReadOnly)queryHalfSize);
                        Assertions.assertFalse((boolean)boundingBox3D.intersectsInclusive((BoundingBox3DReadOnly)query));
                    }
                }
            }
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(-1.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsInclusive((BoundingBox3DReadOnly)query));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(0.0, -1.0, 0.0, 1.0, 0.0, 1.0);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsInclusive((BoundingBox3DReadOnly)query));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(0.0, 0.0, -1.0, 1.0, 1.0, 0.0);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsInclusive((BoundingBox3DReadOnly)query));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(1.0, 0.0, 0.0, 2.0, 1.0, 1.0);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsInclusive((BoundingBox3DReadOnly)query));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(0.0, 1.0, 0.0, 1.0, 2.0, 1.0);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsInclusive((BoundingBox3DReadOnly)query));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(0.0, 0.0, 1.0, 1.0, 1.0, 2.0);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsInclusive((BoundingBox3DReadOnly)query));
        }
    }

    @Test
    public void testIntersectsEpsilon() throws Exception {
        Random random = new Random(34545L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Point3D center = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector3D halfSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)(2.0 * Math.abs(epsilon)), (double)10.0);
            BoundingBox3D boundingBox3D = BoundingBox3D.createUsingCenterAndPlusMinusVector((Point3DReadOnly)center, (Tuple3DReadOnly)halfSize);
            Point3D queryCenter = new Point3D();
            Vector3D queryHalfSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)(2.0 * Math.abs(epsilon)), (double)10.0);
            BoundingBox3D query = new BoundingBox3D();
            double xParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double yParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double zParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            boundingBox3D.getPointGivenParameters(xParameter, yParameter, zParameter, (Point3DBasics)queryCenter);
            query.set((Point3DReadOnly)queryCenter, (Vector3DReadOnly)queryHalfSize);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsEpsilon((BoundingBox3DReadOnly)query, epsilon));
            for (double xSign = -1.0; xSign <= 1.0; xSign += 1.0) {
                for (double ySign = -1.0; ySign <= 1.0; ySign += 1.0) {
                    for (double zSign = -1.0; zSign <= 1.0; zSign += 1.0) {
                        Vector3D shift = new Vector3D();
                        shift.add((Tuple3DReadOnly)queryHalfSize, (Tuple3DReadOnly)halfSize);
                        shift.add(epsilon, epsilon, epsilon);
                        shift.scale(xSign, ySign, zSign);
                        queryCenter.scaleAdd(0.999, (Tuple3DReadOnly)shift, (Tuple3DReadOnly)center);
                        query.set((Point3DReadOnly)queryCenter, (Vector3DReadOnly)queryHalfSize);
                        Assertions.assertTrue((boolean)boundingBox3D.intersectsEpsilon((BoundingBox3DReadOnly)query, epsilon));
                        if (Math.abs(xSign) + Math.abs(ySign) + Math.abs(zSign) == 0.0) continue;
                        queryCenter.scaleAdd(1.0001, (Tuple3DReadOnly)shift, (Tuple3DReadOnly)center);
                        query.set((Point3DReadOnly)queryCenter, (Vector3DReadOnly)queryHalfSize);
                        Assertions.assertFalse((boolean)boundingBox3D.intersectsEpsilon((BoundingBox3DReadOnly)query, epsilon));
                    }
                }
            }
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(-1.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsEpsilon((BoundingBox3DReadOnly)query, 0.0));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(0.0, -1.0, 0.0, 1.0, 0.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsEpsilon((BoundingBox3DReadOnly)query, 0.0));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(0.0, 0.0, -1.0, 1.0, 1.0, 0.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsEpsilon((BoundingBox3DReadOnly)query, 0.0));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(1.0, 0.0, 0.0, 2.0, 1.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsEpsilon((BoundingBox3DReadOnly)query, 0.0));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(0.0, 1.0, 0.0, 1.0, 2.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsEpsilon((BoundingBox3DReadOnly)query, 0.0));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query.set(0.0, 0.0, 1.0, 1.0, 1.0, 2.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsEpsilon((BoundingBox3DReadOnly)query, 0.0));
        }
    }

    @Test
    public void testIntersectsExclusiveInXYPlane() throws Exception {
        Random random = new Random(34545L);
        for (int i = 0; i < 1000; ++i) {
            Point3D center3D = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point2D center2D = new Point2D(center3D.getX(), center3D.getY());
            Vector3D halfSize3D = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            BoundingBox3D boundingBox3D = BoundingBox3D.createUsingCenterAndPlusMinusVector((Point3DReadOnly)center3D, (Tuple3DReadOnly)halfSize3D);
            Point2D queryCenter2D = new Point2D();
            Point3D queryCenter3D = new Point3D();
            Vector2D queryHalfSize2D = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.0, (double)10.0);
            BoundingBox2D query2D = new BoundingBox2D();
            double xParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double yParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            boundingBox3D.getPointGivenParameters(xParameter, yParameter, 0.0, (Point3DBasics)queryCenter3D);
            queryCenter2D.set(queryCenter3D.getX(), queryCenter3D.getY());
            query2D.set((Point2DReadOnly)queryCenter2D, (Vector2DReadOnly)queryHalfSize2D);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsExclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
            for (double xSign = -1.0; xSign <= 1.0; xSign += 1.0) {
                for (double ySign = -1.0; ySign <= 1.0; ySign += 1.0) {
                    Vector2D shift2D = new Vector2D((Tuple2DReadOnly)queryHalfSize2D);
                    shift2D.add(halfSize3D.getX(), halfSize3D.getY());
                    shift2D.scale(xSign, ySign);
                    queryCenter2D.scaleAdd(0.999, (Tuple2DReadOnly)shift2D, (Tuple2DReadOnly)center2D);
                    query2D.set((Point2DReadOnly)queryCenter2D, (Vector2DReadOnly)queryHalfSize2D);
                    Assertions.assertTrue((boolean)boundingBox3D.intersectsExclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
                    if (Math.abs(xSign) + Math.abs(ySign) == 0.0) continue;
                    queryCenter2D.scaleAdd(1.0001, (Tuple2DReadOnly)shift2D, (Tuple2DReadOnly)center2D);
                    query2D.set((Point2DReadOnly)queryCenter2D, (Vector2DReadOnly)queryHalfSize2D);
                    Assertions.assertFalse((boolean)boundingBox3D.intersectsExclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
                }
            }
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query2D.set(-1.0, 0.0, 0.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsExclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query2D.set(0.0, -1.0, 1.0, 0.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsExclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query2D.set(1.0, 0.0, 2.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsExclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query2D.set(0.0, 1.0, 1.0, 2.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsExclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
        }
    }

    @Test
    public void testIntersectsInclusiveInXYPlane() throws Exception {
        Random random = new Random(34545L);
        for (int i = 0; i < 1000; ++i) {
            Point3D center3D = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point2D center2D = new Point2D(center3D.getX(), center3D.getY());
            Vector3D halfSize3D = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            BoundingBox3D boundingBox3D = BoundingBox3D.createUsingCenterAndPlusMinusVector((Point3DReadOnly)center3D, (Tuple3DReadOnly)halfSize3D);
            Point2D queryCenter2D = new Point2D();
            Point3D queryCenter3D = new Point3D();
            Vector2D queryHalfSize2D = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.0, (double)10.0);
            BoundingBox2D query2D = new BoundingBox2D();
            double xParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double yParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            boundingBox3D.getPointGivenParameters(xParameter, yParameter, 0.0, (Point3DBasics)queryCenter3D);
            queryCenter2D.set(queryCenter3D.getX(), queryCenter3D.getY());
            query2D.set((Point2DReadOnly)queryCenter2D, (Vector2DReadOnly)queryHalfSize2D);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsExclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
            for (double xSign = -1.0; xSign <= 1.0; xSign += 1.0) {
                for (double ySign = -1.0; ySign <= 1.0; ySign += 1.0) {
                    Vector2D shift = new Vector2D((Tuple2DReadOnly)queryHalfSize2D);
                    shift.add(halfSize3D.getX(), halfSize3D.getY());
                    shift.scale(xSign, ySign);
                    queryCenter2D.scaleAdd(0.999, (Tuple2DReadOnly)shift, (Tuple2DReadOnly)center2D);
                    query2D.set((Point2DReadOnly)queryCenter2D, (Vector2DReadOnly)queryHalfSize2D);
                    Assertions.assertTrue((boolean)boundingBox3D.intersectsInclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
                    if (Math.abs(xSign) + Math.abs(ySign) == 0.0) continue;
                    queryCenter2D.scaleAdd(1.0001, (Tuple2DReadOnly)shift, (Tuple2DReadOnly)center2D);
                    query2D.set((Point2DReadOnly)queryCenter2D, (Vector2DReadOnly)queryHalfSize2D);
                    Assertions.assertFalse((boolean)boundingBox3D.intersectsInclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
                }
            }
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query2D.set(-1.0, 0.0, 0.0, 1.0);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsInclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query2D.set(0.0, -1.0, 1.0, 0.0);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsInclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query2D.set(1.0, 0.0, 2.0, 1.0);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsInclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query2D.set(0.0, 1.0, 1.0, 2.0);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsInclusiveInXYPlane((BoundingBox2DReadOnly)query2D));
        }
    }

    @Test
    public void testIntersectsEpsilonInXYPlane() throws Exception {
        Random random = new Random(34545L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Point3D center3D = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point2D center2D = new Point2D(center3D.getX(), center3D.getY());
            Vector3D halfSize3D = EuclidCoreRandomTools.nextVector3D((Random)random, (double)(2.0 * Math.abs(epsilon)), (double)10.0);
            BoundingBox3D boundingBox3D = BoundingBox3D.createUsingCenterAndPlusMinusVector((Point3DReadOnly)center3D, (Tuple3DReadOnly)halfSize3D);
            Point2D queryCenter2D = new Point2D();
            Point3D queryCenter3D = new Point3D();
            Vector2D queryHalfSize2D = EuclidCoreRandomTools.nextVector2D((Random)random, (double)(2.0 * Math.abs(epsilon)), (double)10.0);
            BoundingBox2D query2D = new BoundingBox2D();
            double xParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double yParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            boundingBox3D.getPointGivenParameters(xParameter, yParameter, 0.0, (Point3DBasics)queryCenter3D);
            queryCenter2D.set(queryCenter3D.getX(), queryCenter3D.getY());
            query2D.set((Point2DReadOnly)queryCenter2D, (Vector2DReadOnly)queryHalfSize2D);
            Assertions.assertTrue((boolean)boundingBox3D.intersectsEpsilonInXYPlane((BoundingBox2DReadOnly)query2D, epsilon));
            for (double xSign = -1.0; xSign <= 1.0; xSign += 1.0) {
                for (double ySign = -1.0; ySign <= 1.0; ySign += 1.0) {
                    Vector2D shift = new Vector2D((Tuple2DReadOnly)queryHalfSize2D);
                    shift.add(halfSize3D.getX(), halfSize3D.getY());
                    shift.add(epsilon, epsilon);
                    shift.scale(xSign, ySign);
                    queryCenter2D.scaleAdd(0.999, (Tuple2DReadOnly)shift, (Tuple2DReadOnly)center2D);
                    query2D.set((Point2DReadOnly)queryCenter2D, (Vector2DReadOnly)queryHalfSize2D);
                    Assertions.assertTrue((boolean)boundingBox3D.intersectsEpsilonInXYPlane((BoundingBox2DReadOnly)query2D, epsilon));
                    if (Math.abs(xSign) + Math.abs(ySign) == 0.0) continue;
                    queryCenter2D.scaleAdd(1.0001, (Tuple2DReadOnly)shift, (Tuple2DReadOnly)center2D);
                    query2D.set((Point2DReadOnly)queryCenter2D, (Vector2DReadOnly)queryHalfSize2D);
                    Assertions.assertFalse((boolean)boundingBox3D.intersectsEpsilonInXYPlane((BoundingBox2DReadOnly)query2D, epsilon));
                }
            }
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query2D.set(-1.0, 0.0, 0.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsEpsilonInXYPlane((BoundingBox2DReadOnly)query2D, 0.0));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query2D.set(0.0, -1.0, 1.0, 0.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsEpsilonInXYPlane((BoundingBox2DReadOnly)query2D, 0.0));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query2D.set(1.0, 0.0, 2.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsEpsilonInXYPlane((BoundingBox2DReadOnly)query2D, 0.0));
            boundingBox3D.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            query2D.set(0.0, 1.0, 1.0, 2.0);
            Assertions.assertFalse((boolean)boundingBox3D.intersectsEpsilonInXYPlane((BoundingBox2DReadOnly)query2D, 0.0));
        }
    }

    @Test
    public void testDoesIntersectWithLine3D() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            Line3D line3D = EuclidGeometryRandomTools.nextLine3D((Random)random, (double)10.0);
            BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            boolean expected = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBox3D.getMinPoint(), (Point3DReadOnly)boundingBox3D.getMaxPoint(), (Point3DReadOnly)line3D.getPoint(), (Vector3DReadOnly)line3D.getDirection(), null, null) != 0;
            boolean actual = boundingBox3D.doesIntersectWithLine3D((Line3DReadOnly)line3D);
            Assertions.assertEquals((Object)expected, (Object)actual);
            actual = boundingBox3D.doesIntersectWithLine3D((Point3DReadOnly)line3D.getPoint(), (Vector3DReadOnly)line3D.getDirection());
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testDoesIntersectWithLineSegment3D() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            LineSegment3D lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            boolean expected = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBox3D.getMinPoint(), (Point3DReadOnly)boundingBox3D.getMaxPoint(), (Point3DReadOnly)lineSegment3D.getFirstEndpoint(), (Point3DReadOnly)lineSegment3D.getSecondEndpoint(), null, null) != 0;
            boolean actual = boundingBox3D.doesIntersectWithLineSegment3D((LineSegment3DReadOnly)lineSegment3D);
            Assertions.assertEquals((Object)expected, (Object)actual);
            actual = boundingBox3D.doesIntersectWithLineSegment3D((Point3DReadOnly)lineSegment3D.getFirstEndpoint(), (Point3DReadOnly)lineSegment3D.getSecondEndpoint());
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testDoesIntersectWithRay3D() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            Line3D ray3D = EuclidGeometryRandomTools.nextLine3D((Random)random, (double)10.0);
            BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            boolean expected = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBox3D.getMinPoint(), (Point3DReadOnly)boundingBox3D.getMaxPoint(), (Point3DReadOnly)ray3D.getPoint(), (Vector3DReadOnly)ray3D.getDirection(), null, null) != 0;
            boolean actual = boundingBox3D.doesIntersectWithRay3D((Point3DReadOnly)ray3D.getPoint(), (Vector3DReadOnly)ray3D.getDirection());
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testintersectionWithLine3D() throws Exception {
        Random random = new Random(435345L);
        for (int i = 0; i < 1000; ++i) {
            Line3D line3D = EuclidGeometryRandomTools.nextLine3D((Random)random, (double)10.0);
            BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            Point3D expectedFirstIntersection = new Point3D();
            Point3D expectedSecondIntersection = new Point3D();
            Point3D actualFirstIntersection = new Point3D();
            Point3D actualSecondIntersection = new Point3D();
            int expectedN = EuclidGeometryTools.intersectionBetweenLine3DAndBoundingBox3D((Point3DReadOnly)boundingBox3D.getMinPoint(), (Point3DReadOnly)boundingBox3D.getMaxPoint(), (Point3DReadOnly)line3D.getPoint(), (Vector3DReadOnly)line3D.getDirection(), (Point3DBasics)expectedFirstIntersection, (Point3DBasics)expectedSecondIntersection);
            int actualN = boundingBox3D.intersectionWithLine3D((Point3DReadOnly)line3D.getPoint(), (Vector3DReadOnly)line3D.getDirection(), (Point3DBasics)actualFirstIntersection, (Point3DBasics)actualSecondIntersection);
            Assertions.assertEquals((int)expectedN, (int)actualN);
            if (expectedN == 0) {
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)expectedFirstIntersection);
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualFirstIntersection);
            } else {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
            }
            if (expectedN <= 1) {
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)expectedSecondIntersection);
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualSecondIntersection);
            } else {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
            }
            actualFirstIntersection.setToZero();
            actualSecondIntersection.setToZero();
            actualN = boundingBox3D.intersectionWithLine3D((Line3DReadOnly)line3D, (Point3DBasics)actualFirstIntersection, (Point3DBasics)actualSecondIntersection);
            Assertions.assertEquals((int)expectedN, (int)actualN);
            if (expectedN == 0) {
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)expectedFirstIntersection);
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualFirstIntersection);
            } else {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
            }
            if (expectedN <= 1) {
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)expectedSecondIntersection);
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualSecondIntersection);
                continue;
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        }
    }

    @Test
    public void testIntersectionWithLineSegment3D() throws Exception {
        Random random = new Random(435345L);
        for (int i = 0; i < 1000; ++i) {
            LineSegment3D lineSegment3D = EuclidGeometryRandomTools.nextLineSegment3D((Random)random, (double)10.0);
            BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            Point3D expectedFirstIntersection = new Point3D();
            Point3D expectedSecondIntersection = new Point3D();
            Point3D actualFirstIntersection = new Point3D();
            Point3D actualSecondIntersection = new Point3D();
            int expectedN = EuclidGeometryTools.intersectionBetweenLineSegment3DAndBoundingBox3D((Point3DReadOnly)boundingBox3D.getMinPoint(), (Point3DReadOnly)boundingBox3D.getMaxPoint(), (Point3DReadOnly)lineSegment3D.getFirstEndpoint(), (Point3DReadOnly)lineSegment3D.getSecondEndpoint(), (Point3DBasics)expectedFirstIntersection, (Point3DBasics)expectedSecondIntersection);
            int actualN = boundingBox3D.intersectionWithLineSegment3D((Point3DReadOnly)lineSegment3D.getFirstEndpoint(), (Point3DReadOnly)lineSegment3D.getSecondEndpoint(), (Point3DBasics)actualFirstIntersection, (Point3DBasics)actualSecondIntersection);
            Assertions.assertEquals((int)expectedN, (int)actualN);
            if (expectedN == 0) {
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)expectedFirstIntersection);
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualFirstIntersection);
            } else {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
            }
            if (expectedN <= 1) {
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)expectedSecondIntersection);
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualSecondIntersection);
            } else {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
            }
            actualFirstIntersection.setToZero();
            actualSecondIntersection.setToZero();
            actualN = boundingBox3D.intersectionWithLineSegment3D((LineSegment3DReadOnly)lineSegment3D, (Point3DBasics)actualFirstIntersection, (Point3DBasics)actualSecondIntersection);
            Assertions.assertEquals((int)expectedN, (int)actualN);
            if (expectedN == 0) {
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)expectedFirstIntersection);
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualFirstIntersection);
            } else {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
            }
            if (expectedN <= 1) {
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)expectedSecondIntersection);
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualSecondIntersection);
                continue;
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        }
    }

    @Test
    public void testIntersectionWithRay3D() throws Exception {
        Random random = new Random(435345L);
        for (int i = 0; i < 1000; ++i) {
            Line3D ray3D = EuclidGeometryRandomTools.nextLine3D((Random)random, (double)10.0);
            BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            Point3D expectedFirstIntersection = new Point3D();
            Point3D expectedSecondIntersection = new Point3D();
            Point3D actualFirstIntersection = new Point3D();
            Point3D actualSecondIntersection = new Point3D();
            int expectedN = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)boundingBox3D.getMinPoint(), (Point3DReadOnly)boundingBox3D.getMaxPoint(), (Point3DReadOnly)ray3D.getPoint(), (Vector3DReadOnly)ray3D.getDirection(), (Point3DBasics)expectedFirstIntersection, (Point3DBasics)expectedSecondIntersection);
            int actualN = boundingBox3D.intersectionWithRay3D((Point3DReadOnly)ray3D.getPoint(), (Vector3DReadOnly)ray3D.getDirection(), (Point3DBasics)actualFirstIntersection, (Point3DBasics)actualSecondIntersection);
            Assertions.assertEquals((int)expectedN, (int)actualN);
            if (expectedN == 0) {
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)expectedFirstIntersection);
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualFirstIntersection);
            } else {
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFirstIntersection, (EuclidGeometry)actualFirstIntersection, (double)1.0E-12);
            }
            if (expectedN <= 1) {
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)expectedSecondIntersection);
                EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)actualSecondIntersection);
                continue;
            }
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedSecondIntersection, (EuclidGeometry)actualSecondIntersection, (double)1.0E-12);
        }
    }

    @Test
    public void testUpdateToIncludePoint() throws Exception {
        boolean hasGrownToPoint;
        boolean hasNotChanged;
        int axis;
        Point3DBasics extendedMax;
        Point3DBasics originalMax;
        boolean hasGrownToPoint2;
        Point3DBasics extendedMin;
        Point3DBasics originalMin;
        Point3D point;
        BoundingBox3D extended;
        BoundingBox3D original;
        int i;
        Random random = new Random(234234L);
        for (i = 0; i < 1000; ++i) {
            original = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            extended = new BoundingBox3D((BoundingBox3DReadOnly)original);
            point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            extended.updateToIncludePoint((Point3DReadOnly)point);
            if (original.isInsideInclusive((Point3DReadOnly)point)) {
                Assertions.assertEquals((Object)original, (Object)extended);
                continue;
            }
            Assertions.assertTrue((boolean)extended.isInsideInclusive((Point3DReadOnly)point));
            originalMin = original.getMinPoint();
            extendedMin = extended.getMinPoint();
            for (int axis2 = 0; axis2 < 3; ++axis2) {
                boolean hasNotChanged2 = originalMin.getElement(axis2) == extendedMin.getElement(axis2);
                hasGrownToPoint2 = point.getElement(axis2) == extendedMin.getElement(axis2);
                Assertions.assertTrue((hasNotChanged2 || hasGrownToPoint2 ? 1 : 0) != 0);
            }
            originalMax = original.getMaxPoint();
            extendedMax = extended.getMaxPoint();
            for (axis = 0; axis < 3; ++axis) {
                hasNotChanged = originalMax.getElement(axis) == extendedMax.getElement(axis);
                hasGrownToPoint = point.getElement(axis) == extendedMax.getElement(axis);
                Assertions.assertTrue((hasNotChanged || hasGrownToPoint ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
            extended = new BoundingBox3D((BoundingBox3DReadOnly)original);
            point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            extended.updateToIncludePoint(point.getX(), point.getY(), point.getZ());
            if (original.isInsideInclusive((Point3DReadOnly)point)) {
                Assertions.assertEquals((Object)original, (Object)extended);
                continue;
            }
            Assertions.assertTrue((boolean)extended.isInsideInclusive((Point3DReadOnly)point));
            originalMin = original.getMinPoint();
            extendedMin = extended.getMinPoint();
            for (int axis3 = 0; axis3 < 3; ++axis3) {
                boolean hasNotChanged3 = originalMin.getElement(axis3) == extendedMin.getElement(axis3);
                hasGrownToPoint2 = point.getElement(axis3) == extendedMin.getElement(axis3);
                Assertions.assertTrue((hasNotChanged3 || hasGrownToPoint2 ? 1 : 0) != 0);
            }
            originalMax = original.getMaxPoint();
            extendedMax = extended.getMaxPoint();
            for (axis = 0; axis < 3; ++axis) {
                hasNotChanged = originalMax.getElement(axis) == extendedMax.getElement(axis);
                hasGrownToPoint = point.getElement(axis) == extendedMax.getElement(axis);
                Assertions.assertTrue((hasNotChanged || hasGrownToPoint ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testGetters() throws Exception {
        Random random = new Random(3242L);
        BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
        Point3DBasics min = boundingBox3D.getMinPoint();
        Point3DBasics max = boundingBox3D.getMaxPoint();
        Assertions.assertTrue((min.getX() == boundingBox3D.getMinX() ? 1 : 0) != 0);
        Assertions.assertTrue((min.getY() == boundingBox3D.getMinY() ? 1 : 0) != 0);
        Assertions.assertTrue((min.getZ() == boundingBox3D.getMinZ() ? 1 : 0) != 0);
        Assertions.assertTrue((max.getX() == boundingBox3D.getMaxX() ? 1 : 0) != 0);
        Assertions.assertTrue((max.getY() == boundingBox3D.getMaxY() ? 1 : 0) != 0);
        Assertions.assertTrue((max.getZ() == boundingBox3D.getMaxZ() ? 1 : 0) != 0);
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(234234L);
        double epsilon = random.nextDouble();
        BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
        double minX = boundingBox3D.getMinX();
        double minY = boundingBox3D.getMinY();
        double minZ = boundingBox3D.getMinZ();
        double maxX = boundingBox3D.getMaxX();
        double maxY = boundingBox3D.getMaxY();
        double maxZ = boundingBox3D.getMaxZ();
        double small = 0.999 * epsilon;
        double big = 1.001 * epsilon;
        Assertions.assertTrue((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX + small, minY, minZ, maxX, maxY, maxZ), epsilon));
        Assertions.assertTrue((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY + small, minZ, maxX, maxY, maxZ), epsilon));
        Assertions.assertTrue((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ + small, maxX, maxY, maxZ), epsilon));
        Assertions.assertTrue((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX + small, maxY, maxZ), epsilon));
        Assertions.assertTrue((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX, maxY + small, maxZ), epsilon));
        Assertions.assertTrue((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX, maxY, maxZ + small), epsilon));
        Assertions.assertTrue((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX - small, minY, minZ, maxX, maxY, maxZ), epsilon));
        Assertions.assertTrue((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY - small, minZ, maxX, maxY, maxZ), epsilon));
        Assertions.assertTrue((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ - small, maxX, maxY, maxZ), epsilon));
        Assertions.assertTrue((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX - small, maxY, maxZ), epsilon));
        Assertions.assertTrue((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX, maxY - small, maxZ), epsilon));
        Assertions.assertTrue((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX, maxY, maxZ - small), epsilon));
        Assertions.assertFalse((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX + big, minY, minZ, maxX, maxY, maxZ), epsilon));
        Assertions.assertFalse((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY + big, minZ, maxX, maxY, maxZ), epsilon));
        Assertions.assertFalse((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ + big, maxX, maxY, maxZ), epsilon));
        Assertions.assertFalse((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX + big, maxY, maxZ), epsilon));
        Assertions.assertFalse((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX, maxY + big, maxZ), epsilon));
        Assertions.assertFalse((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX, maxY, maxZ + big), epsilon));
        Assertions.assertFalse((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX - big, minY, minZ, maxX, maxY, maxZ), epsilon));
        Assertions.assertFalse((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY - big, minZ, maxX, maxY, maxZ), epsilon));
        Assertions.assertFalse((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ - big, maxX, maxY, maxZ), epsilon));
        Assertions.assertFalse((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX - big, maxY, maxZ), epsilon));
        Assertions.assertFalse((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX, maxY - big, maxZ), epsilon));
        Assertions.assertFalse((boolean)boundingBox3D.epsilonEquals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX, maxY, maxZ - big), epsilon));
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(234234L);
        BoundingBox3D boundingBox3D = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random, (double)10.0, (double)10.0);
        double minX = boundingBox3D.getMinX();
        double minY = boundingBox3D.getMinY();
        double minZ = boundingBox3D.getMinZ();
        double maxX = boundingBox3D.getMaxX();
        double maxY = boundingBox3D.getMaxY();
        double maxZ = boundingBox3D.getMaxZ();
        double smallestEpsilon = 8.8888E-16;
        Assertions.assertTrue((boolean)boundingBox3D.equals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX, maxY, maxZ)));
        BoundingBox3D bbxAsObject = new BoundingBox3D(minX, minY, minZ, maxX, maxY, maxZ);
        Assertions.assertTrue((boolean)boundingBox3D.equals((Object)bbxAsObject));
        Assertions.assertFalse((boolean)boundingBox3D.equals(null));
        Assertions.assertFalse((boolean)boundingBox3D.equals((Object)new double[5]));
        Assertions.assertFalse((boolean)boundingBox3D.equals((EuclidGeometry)new BoundingBox3D(minX + smallestEpsilon, minY, minZ, maxX, maxY, maxZ)));
        Assertions.assertFalse((boolean)boundingBox3D.equals((EuclidGeometry)new BoundingBox3D(minX, minY + smallestEpsilon, minZ, maxX, maxY, maxZ)));
        Assertions.assertFalse((boolean)boundingBox3D.equals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ + smallestEpsilon, maxX, maxY, maxZ)));
        Assertions.assertFalse((boolean)boundingBox3D.equals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX + smallestEpsilon, maxY, maxZ)));
        Assertions.assertFalse((boolean)boundingBox3D.equals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX, maxY + smallestEpsilon, maxZ)));
        Assertions.assertFalse((boolean)boundingBox3D.equals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX, maxY, maxZ + smallestEpsilon)));
        Assertions.assertFalse((boolean)boundingBox3D.equals((EuclidGeometry)new BoundingBox3D(minX - smallestEpsilon, minY, minZ, maxX, maxY, maxZ)));
        Assertions.assertFalse((boolean)boundingBox3D.equals((EuclidGeometry)new BoundingBox3D(minX, minY - smallestEpsilon, minZ, maxX, maxY, maxZ)));
        Assertions.assertFalse((boolean)boundingBox3D.equals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ - smallestEpsilon, maxX, maxY, maxZ)));
        Assertions.assertFalse((boolean)boundingBox3D.equals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX - smallestEpsilon, maxY, maxZ)));
        Assertions.assertFalse((boolean)boundingBox3D.equals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX, maxY - smallestEpsilon, maxZ)));
        Assertions.assertFalse((boolean)boundingBox3D.equals((EuclidGeometry)new BoundingBox3D(minX, minY, minZ, maxX, maxY, maxZ - smallestEpsilon)));
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(987234L);
        Point3D firstPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.1, (double)2.5);
        Point3D secondPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)2.5, (double)5.0);
        BoundingBox3D firstBox = new BoundingBox3D((Point3DReadOnly)firstPoint, (Point3DReadOnly)secondPoint);
        BoundingBox3D secondBox = new BoundingBox3D((BoundingBox3DReadOnly)firstBox);
        Assertions.assertTrue((boolean)firstBox.geometricallyEquals((EuclidGeometry)secondBox, 1.0E-12));
        Assertions.assertTrue((boolean)secondBox.geometricallyEquals((EuclidGeometry)firstBox, 1.0E-12));
        Assertions.assertTrue((boolean)firstBox.geometricallyEquals((EuclidGeometry)firstBox, 1.0E-12));
        Assertions.assertTrue((boolean)secondBox.geometricallyEquals((EuclidGeometry)secondBox, 1.0E-12));
        for (int i = 0; i < 1000; ++i) {
            Point3D min = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)0.1, (double)2.5);
            Point3D max = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)2.5, (double)5.0);
            firstBox = new BoundingBox3D((Point3DReadOnly)min, (Point3DReadOnly)max);
            Point3D minCorrupted = new Point3D((Tuple3DReadOnly)min);
            minCorrupted.add((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)9.9E-13));
            secondBox = new BoundingBox3D((Point3DReadOnly)minCorrupted, (Point3DReadOnly)max);
            Assertions.assertTrue((boolean)firstBox.geometricallyEquals((EuclidGeometry)secondBox, 1.0E-12));
            minCorrupted = new Point3D((Tuple3DReadOnly)min);
            minCorrupted.add((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.01E-12));
            secondBox = new BoundingBox3D((Point3DReadOnly)minCorrupted, (Point3DReadOnly)max);
            Assertions.assertFalse((boolean)firstBox.geometricallyEquals((EuclidGeometry)secondBox, 1.0E-12));
            Point3D maxCorrupted = new Point3D((Tuple3DReadOnly)max);
            maxCorrupted.add((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)9.9E-13));
            secondBox = new BoundingBox3D((Point3DReadOnly)min, (Point3DReadOnly)maxCorrupted);
            Assertions.assertTrue((boolean)firstBox.geometricallyEquals((EuclidGeometry)secondBox, 1.0E-12));
            maxCorrupted = new Point3D((Tuple3DReadOnly)max);
            maxCorrupted.add((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.01E-12));
            secondBox = new BoundingBox3D((Point3DReadOnly)min, (Point3DReadOnly)maxCorrupted);
            Assertions.assertFalse((boolean)firstBox.geometricallyEquals((EuclidGeometry)secondBox, 1.0E-12));
        }
    }
}

