/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Tuple3DBasicsTest;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public abstract class Vector3DBasicsTest<T extends Vector3DBasics>
extends Tuple3DBasicsTest<T> {
    @Test
    public void testLength() {
        Random random = new Random(312310L);
        for (int i = 0; i < 1000; ++i) {
            Vector3DBasics vector1 = (Vector3DBasics)this.createRandomTuple(random);
            double length1 = vector1.length();
            Vector3DBasics vector2 = (Vector3DBasics)this.createEmptyTuple();
            double scalar = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            vector2.setAndScale(scalar, (Tuple3DReadOnly)vector1);
            double expectedLength2 = scalar * length1;
            double actualLength2 = vector2.length();
            Assertions.assertEquals((double)expectedLength2, (double)actualLength2, (double)(5.0 * this.getEpsilon()));
        }
    }

    @Test
    public void testLengthSquared() {
        Random random = new Random(312310L);
        for (int i = 0; i < 1000; ++i) {
            Vector3DBasics vector1 = (Vector3DBasics)this.createRandomTuple(random);
            double length1 = vector1.length();
            Vector3DBasics vector2 = (Vector3DBasics)this.createEmptyTuple();
            double scalar = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            vector2.setAndScale(scalar, (Tuple3DReadOnly)vector1);
            double expectedLength2 = scalar * length1;
            double actualLength2 = vector2.lengthSquared();
            Assertions.assertEquals((double)expectedLength2, (double)EuclidCoreTools.squareRoot((double)actualLength2), (double)(5.0 * this.getEpsilon()));
        }
    }

    @Test
    public void testDot() {
        Random random = new Random(5461L);
        for (int i = 0; i < 1000; ++i) {
            Vector3DBasics vector1 = (Vector3DBasics)this.createRandomTuple(random);
            vector1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0));
            Vector3D axis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)vector1, (boolean)true);
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)Math.PI);
            if (random.nextBoolean()) {
                angle = -angle;
            }
            Vector3DBasics vector2 = (Vector3DBasics)this.createEmptyTuple();
            RotationMatrix rotationMatrix = new RotationMatrix((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)axis, angle));
            rotationMatrix.transform((Tuple3DReadOnly)vector1, (Tuple3DBasics)vector2);
            vector2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)2.0));
            double expectedDot = vector1.length() * vector2.length() * EuclidCoreTools.cos((double)angle);
            double actualDot = vector1.dot((Vector3DReadOnly)vector2);
            Assertions.assertEquals((double)expectedDot, (double)actualDot, (double)(10.0 * this.getEpsilon()));
        }
    }

    @Test
    public void testAngle() {
        Random random = new Random(56461L);
        for (int i = 0; i < 1000; ++i) {
            Vector3DBasics vector1 = (Vector3DBasics)this.createRandomTuple(random);
            vector1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0));
            Vector3D axis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)vector1, (boolean)true);
            double expectedAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)3.1315926535897933);
            if (random.nextBoolean()) {
                expectedAngle = -expectedAngle;
            }
            Vector3DBasics vector2 = (Vector3DBasics)this.createEmptyTuple();
            RotationMatrix rotationMatrix = new RotationMatrix((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)axis, expectedAngle));
            rotationMatrix.transform((Tuple3DReadOnly)vector1, (Tuple3DBasics)vector2);
            vector2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)2.0));
            double actualAngle = vector1.angle((Vector3DReadOnly)vector2);
            Assertions.assertEquals((double)Math.abs(expectedAngle), (double)actualAngle, (double)(10.0 * this.getEpsilon()));
        }
    }

    @Test
    public void testCross() {
        RotationMatrix rotationMatrix;
        Vector3DBasics vector2;
        double angle;
        Vector3D axis;
        Vector3DBasics vector1;
        int i;
        Random random = new Random(56461L);
        for (i = 0; i < 1000; ++i) {
            vector1 = (Vector3DBasics)this.createRandomTuple(random);
            vector1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)2.0));
            axis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)vector1, (boolean)true);
            angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)3.1315926535897933);
            vector2 = (Vector3DBasics)this.createEmptyTuple();
            rotationMatrix = new RotationMatrix((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)axis, angle));
            rotationMatrix.transform((Tuple3DReadOnly)vector1, (Tuple3DBasics)vector2);
            vector2.normalize();
            vector2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)2.0));
            Vector3DBasics vector3 = (Vector3DBasics)this.createEmptyTuple();
            vector3.cross((Tuple3DReadOnly)vector1, (Tuple3DReadOnly)vector2);
            double expectedCrossMagnitude = vector1.length() * vector2.length() * EuclidCoreTools.sin((double)angle);
            double actualCrossMagnitude = vector3.length();
            Assertions.assertEquals((double)expectedCrossMagnitude, (double)actualCrossMagnitude, (double)(10.0 * this.getEpsilon()));
            Assertions.assertEquals((double)0.0, (double)vector1.dot((Vector3DReadOnly)vector3), (double)(10.0 * this.getEpsilon()));
            Assertions.assertEquals((double)0.0, (double)vector2.dot((Vector3DReadOnly)vector3), (double)(10.0 * this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            vector1 = (Vector3DBasics)this.createRandomTuple(random);
            vector1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0));
            axis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)vector1, (boolean)true);
            angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)Math.PI);
            vector2 = (Vector3DBasics)this.createEmptyTuple();
            rotationMatrix = new RotationMatrix((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)axis, angle));
            rotationMatrix.transform((Tuple3DReadOnly)vector1, (Tuple3DBasics)vector2);
            vector2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)2.0));
            Vector3DBasics expectedVector = (Vector3DBasics)this.createEmptyTuple();
            expectedVector.cross((Tuple3DReadOnly)vector1, (Tuple3DReadOnly)vector2);
            Vector3DBasics actualVector = (Vector3DBasics)this.createEmptyTuple();
            actualVector.set((Tuple3DReadOnly)vector1);
            actualVector.cross((Tuple3DReadOnly)vector2);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedVector, (Tuple3DReadOnly)actualVector, (double)this.getEpsilon());
        }
    }

    @Test
    public void testClipToMaxLength() throws Exception {
        RotationMatrix rotationMatrix;
        double vectorLength;
        double maxLength;
        int i;
        Random random = new Random(234234L);
        for (i = 0; i < 1000; ++i) {
            maxLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7, (double)10.0);
            vectorLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Vector3DBasics expectedVector = (Vector3DBasics)this.createTuple(1.0, 0.0, 0.0);
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrix.transform((Tuple3DReadOnly)expectedVector, (Tuple3DBasics)expectedVector);
            Vector3DBasics actualVector = (Vector3DBasics)this.createEmptyTuple();
            actualVector.setAndScale(vectorLength, (Tuple3DReadOnly)expectedVector);
            if (maxLength > vectorLength) {
                expectedVector.scale(vectorLength);
                Assertions.assertFalse((boolean)actualVector.clipToMaxLength(maxLength));
            } else {
                expectedVector.scale(maxLength);
                Assertions.assertTrue((boolean)actualVector.clipToMaxLength(maxLength));
            }
            EuclidCoreTestTools.assertTuple3DEquals((String)("Iteration: " + i + ", maxLength: " + maxLength), (Tuple3DReadOnly)expectedVector, (Tuple3DReadOnly)actualVector, (double)(5.0 * this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            maxLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0E-7);
            vectorLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Vector3DBasics actualVector = (Vector3DBasics)this.createTuple(vectorLength, 0.0, 0.0);
            rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            rotationMatrix.transform((Tuple3DReadOnly)actualVector, (Tuple3DBasics)actualVector);
            Assertions.assertTrue((boolean)actualVector.clipToMaxLength(maxLength));
            EuclidCoreTestTools.assertTuple3DIsSetToZero((String)("Iteration: " + i + ", maxLength: " + maxLength), (Tuple3DReadOnly)actualVector);
        }
    }

    @Test
    public void testNormalize() {
        Vector3DBasics vector1;
        int i;
        Random random = new Random(312310L);
        for (i = 0; i < 1000; ++i) {
            vector1 = (Vector3DBasics)this.createRandomTuple(random);
            vector1.normalize();
            double expectedLength = 1.0;
            double actualLength = vector1.length();
            Assertions.assertEquals((double)expectedLength, (double)actualLength, (double)this.getEpsilon());
            Vector3DBasics vector2 = (Vector3DBasics)this.createRandomTuple(random);
            vector2.normalize();
            vector1.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)vector2);
            vector1.normalize();
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)vector1, (Tuple3DReadOnly)vector2, (double)this.getEpsilon());
            vector1.setToNaN();
            vector1.normalize();
            for (int index = 0; index < 3; ++index) {
                Assertions.assertTrue((boolean)Double.isNaN(vector1.getElement(index)));
            }
        }
        for (i = 0; i < 1000; ++i) {
            vector1 = (Vector3DBasics)this.createRandomTuple(random);
            Vector3DBasics vector2 = (Vector3DBasics)this.createEmptyTuple();
            vector2.setAndNormalize((Tuple3DReadOnly)vector1);
            double expectedLength = 1.0;
            double actualLength = vector2.length();
            Assertions.assertEquals((double)expectedLength, (double)actualLength, (double)this.getEpsilon());
            vector2 = (Vector3DBasics)this.createRandomTuple(random);
            vector2.normalize();
            Vector3DBasics vector3 = (Vector3DBasics)this.createEmptyTuple();
            vector3.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple3DReadOnly)vector2);
            vector1.setAndNormalize((Tuple3DReadOnly)vector3);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)vector1, (Tuple3DReadOnly)vector2, (double)this.getEpsilon());
            vector3.setToNaN();
            vector1.setToZero();
            vector1.setAndNormalize((Tuple3DReadOnly)vector3);
            for (int index = 0; index < 3; ++index) {
                Assertions.assertTrue((boolean)Double.isNaN(vector1.getElement(index)));
            }
        }
    }

    @Test
    public void testApplyTransform() throws Exception {
        Vector3DBasics actual;
        Vector3DBasics expected;
        Vector3DBasics original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = (Vector3DBasics)this.createRandomTuple(random);
            expected = (Vector3DBasics)this.createEmptyTuple();
            actual = (Vector3DBasics)this.createEmptyTuple();
            expected.set((Tuple3DReadOnly)original);
            transform.transform(expected);
            actual.set((Tuple3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = (Vector3DBasics)this.createRandomTuple(random);
            expected = (Vector3DBasics)this.createEmptyTuple();
            actual = (Vector3DBasics)this.createEmptyTuple();
            expected.set((Tuple3DReadOnly)original);
            transform.transform(expected);
            actual.set((Tuple3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            original = (Vector3DBasics)this.createRandomTuple(random);
            expected = (Vector3DBasics)this.createEmptyTuple();
            actual = (Vector3DBasics)this.createEmptyTuple();
            expected.set((Tuple3DReadOnly)original);
            transform.transform(expected);
            actual.set((Tuple3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)(10.0 * this.getEpsilon()));
        }
    }

    @Test
    public void testApplyInverseTransform() throws Exception {
        Vector3DBasics actual;
        Vector3DBasics expected;
        Vector3DBasics original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = (Vector3DBasics)this.createRandomTuple(random);
            expected = (Vector3DBasics)this.createEmptyTuple();
            actual = (Vector3DBasics)this.createEmptyTuple();
            expected.set((Tuple3DReadOnly)original);
            actual.set((Tuple3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)(10.0 * this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = (Vector3DBasics)this.createRandomTuple(random);
            expected = (Vector3DBasics)this.createEmptyTuple();
            actual = (Vector3DBasics)this.createEmptyTuple();
            expected.set((Tuple3DReadOnly)original);
            actual.set((Tuple3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)(10.0 * this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            original = (Vector3DBasics)this.createRandomTuple(random);
            expected = (Vector3DBasics)this.createEmptyTuple();
            actual = (Vector3DBasics)this.createEmptyTuple();
            expected.set((Tuple3DReadOnly)original);
            actual.set((Tuple3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)(100.0 * this.getEpsilon()));
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Vector3D vectorB;
            Vector3D vectorA = EuclidCoreRandomTools.nextVector3D((Random)random);
            if (vectorA.epsilonEquals((Tuple3DReadOnly)(vectorB = EuclidCoreRandomTools.nextVector3D((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)vectorA.geometricallyEquals((Vector3DReadOnly)vectorB, EuclidCoreTools.squareRoot((double)3.0) * this.getEpsilon()));
            } else if (EuclidCoreTools.norm((double)(vectorA.getX() - vectorB.getX()), (double)(vectorA.getY() - vectorB.getY()), (double)(vectorA.getZ() - vectorB.getZ())) <= this.getEpsilon()) {
                Assertions.assertTrue((boolean)vectorA.geometricallyEquals((Vector3DReadOnly)vectorB, this.getEpsilon()));
            } else {
                Assertions.assertFalse((boolean)vectorA.geometricallyEquals((Vector3DReadOnly)vectorB, this.getEpsilon()));
            }
            vectorA = EuclidCoreRandomTools.nextVector3D((Random)random);
            vectorB = new Vector3D((Tuple3DReadOnly)vectorA);
            Assertions.assertTrue((boolean)vectorA.geometricallyEquals((Vector3DReadOnly)vectorB, 0.0));
            vectorB.set(vectorA.getX() + 0.9 * this.getEpsilon(), vectorA.getY(), vectorA.getZ());
            Assertions.assertTrue((boolean)vectorA.geometricallyEquals((Vector3DReadOnly)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX() + 1.1 * this.getEpsilon(), vectorA.getY(), vectorA.getZ());
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((Vector3DReadOnly)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX(), vectorA.getY() + 0.9 * this.getEpsilon(), vectorA.getZ());
            Assertions.assertTrue((boolean)vectorA.geometricallyEquals((Vector3DReadOnly)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX(), vectorA.getY() + 1.1 * this.getEpsilon(), vectorA.getZ());
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((Vector3DReadOnly)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX(), vectorA.getY(), vectorA.getZ() + 0.9 * this.getEpsilon());
            Assertions.assertTrue((boolean)vectorA.geometricallyEquals((Vector3DReadOnly)vectorB, this.getEpsilon()));
            vectorB.set(vectorA.getX(), vectorA.getY(), vectorA.getZ() + 1.1 * this.getEpsilon());
            Assertions.assertFalse((boolean)vectorA.geometricallyEquals((Vector3DReadOnly)vectorB, this.getEpsilon()));
        }
    }
}

