/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Point2DBasicsTest;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class Point2DTest
extends Point2DBasicsTest<Point2D> {
    @Test
    public void testPoint2D() {
        int i;
        Random random = new Random(621541L);
        Point2D point = new Point2D();
        Assertions.assertTrue((0.0 == point.getX() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == point.getY() ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            double newY;
            double newX = random.nextDouble();
            Assertions.assertTrue((newX == (point = new Point2D(newX, newY = random.nextDouble())).getX() ? 1 : 0) != 0);
            Assertions.assertTrue((newY == point.getY() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D pointArray;
            double[] randomPoint2DArray = new double[]{random.nextDouble(), random.nextDouble()};
            Assertions.assertTrue((randomPoint2DArray[0] == (pointArray = new Point2D(randomPoint2DArray)).getX() ? 1 : 0) != 0);
            Assertions.assertTrue((randomPoint2DArray[1] == pointArray.getY() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D point2 = this.createRandomTuple(random);
            point = new Point2D((Tuple2DReadOnly)point2);
            Assertions.assertTrue((point.getX() == point2.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((point.getY() == point2.getY() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Point3D point2 = EuclidCoreRandomTools.nextPoint3D((Random)random);
            point = new Point2D((Tuple3DReadOnly)point2);
            Assertions.assertTrue((point.getX() == point2.getX() ? 1 : 0) != 0);
            Assertions.assertTrue((point.getY() == point2.getY() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Point2D tuple1 = this.createRandomTuple(random);
        int newHashCode = tuple1.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)tuple1.hashCode());
        int previousHashCode = tuple1.hashCode();
        for (int i = 0; i < 1000; ++i) {
            tuple1.setElement(i % 2, random.nextDouble());
            newHashCode = tuple1.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Point2D pointB;
            Point2D pointA = EuclidCoreRandomTools.nextPoint2D((Random)random);
            if (pointA.geometricallyEquals((Point2DReadOnly)(pointB = EuclidCoreRandomTools.nextPoint2D((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)pointA.geometricallyEquals(pointB, this.getEpsilon()));
                continue;
            }
            Assertions.assertFalse((boolean)pointA.geometricallyEquals(pointB, this.getEpsilon()));
        }
    }

    @Override
    public double getEpsilon() {
        return 1.0E-14;
    }

    @Override
    public Point2D createEmptyTuple() {
        return new Point2D();
    }

    @Override
    public Point2D createTuple(double x, double y) {
        return new Point2D(x, y);
    }

    @Override
    public Point2D createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextPoint2D((Random)random);
    }
}

