/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.exceptions.NotAMatrix2DException;
import us.ihmc.euclid.exceptions.SingularMatrixException;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public class Matrix3DToolsTest {
    private static final double EPS = 1.0E-10;

    @Test
    public void testInvert() throws Exception {
        RotationMatrix expected;
        RotationMatrix original;
        int i;
        Random random = new Random(298364L);
        Matrix3D matrix = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)1.0, (double)2.0);
        Matrix3D matrixCopy = new Matrix3D((Matrix3DReadOnly)matrix);
        boolean success = Matrix3DTools.invert((Matrix3DReadOnly)matrix, (CommonMatrix3DBasics)new Matrix3D());
        Assertions.assertTrue((boolean)success);
        Assertions.assertEquals((Object)matrix, (Object)matrixCopy);
        Matrix3D zero = new Matrix3D();
        Matrix3D zeroCopy = new Matrix3D();
        success = Matrix3DTools.invert((CommonMatrix3DBasics)zero);
        Assertions.assertFalse((boolean)success);
        Assertions.assertEquals((Object)zero, (Object)zeroCopy);
        success = Matrix3DTools.invert((Matrix3DReadOnly)zero, (CommonMatrix3DBasics)new Matrix3D());
        Assertions.assertFalse((boolean)success);
        Matrix3D identity = new Matrix3D(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        Matrix3D matrix2 = new Matrix3D((Matrix3DReadOnly)identity);
        Matrix3D inverse = new Matrix3D();
        boolean success2 = Matrix3DTools.invert((CommonMatrix3DBasics)matrix2);
        Assertions.assertTrue((boolean)success2);
        Assertions.assertEquals((Object)identity, (Object)matrix2);
        success2 = Matrix3DTools.invert((Matrix3DReadOnly)matrix2, (CommonMatrix3DBasics)inverse);
        Assertions.assertTrue((boolean)success2);
        Assertions.assertEquals((Object)identity, (Object)inverse);
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expected = new RotationMatrix();
            expected.setAndTranspose((Matrix3DReadOnly)original);
            Matrix3D actual = new Matrix3D((Matrix3DReadOnly)original);
            boolean success3 = Matrix3DTools.invert((CommonMatrix3DBasics)actual);
            Assertions.assertTrue((boolean)success3);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
            actual.setToZero();
            success3 = Matrix3DTools.invert((Matrix3DReadOnly)original, (CommonMatrix3DBasics)actual);
            Assertions.assertTrue((boolean)success3);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            expected = new Matrix3D();
            Matrix3D actual = new Matrix3D((Matrix3DReadOnly)original);
            DMatrixRMaj originalDenseMatrix = new DMatrixRMaj(3, 3);
            original.get((DMatrix)originalDenseMatrix);
            DMatrixRMaj expectedDenseMatrix = new DMatrixRMaj(3, 3);
            boolean expectedSuccess = CommonOps_DDRM.invert((DMatrixRMaj)originalDenseMatrix, (DMatrixRMaj)expectedDenseMatrix);
            expected.set((DMatrix)expectedDenseMatrix);
            boolean actualSuccess = Matrix3DTools.invert((CommonMatrix3DBasics)actual);
            Assertions.assertTrue((expectedSuccess == actualSuccess ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)expected.epsilonEquals(actual, 1.0E-10));
            actual.setToZero();
            actualSuccess = Matrix3DTools.invert((Matrix3DReadOnly)original, (CommonMatrix3DBasics)actual);
            Assertions.assertTrue((expectedSuccess == actualSuccess ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)expected.epsilonEquals(actual, 1.0E-10));
        }
    }

    @Test
    public void testMultiply() throws Exception {
        Matrix3D actual;
        RotationMatrix rotationMatrix;
        Orientation3DBasics orientation;
        Matrix3D matrix;
        Matrix3D m2;
        Matrix3D m1;
        int i;
        Matrix3D m;
        int i2;
        Random random = new Random(53463L);
        Matrix3D matrixExpected = new Matrix3D();
        Matrix3D matrixActual = new Matrix3D();
        for (i2 = 0; i2 < 1000; ++i2) {
            m = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            matrixActual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D mCopy = new Matrix3D((Matrix3DReadOnly)m);
            Matrix3D identity = new Matrix3D();
            identity.setIdentity();
            Matrix3D identityCopy = new Matrix3D((Matrix3DReadOnly)identity);
            matrixExpected.set(m);
            Matrix3DTools.multiply((Matrix3DReadOnly)m, (Matrix3DReadOnly)identity, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
            Assertions.assertEquals((Object)m, (Object)mCopy);
            Assertions.assertEquals((Object)identity, (Object)identityCopy);
            Matrix3DTools.multiply((Matrix3DReadOnly)identity, (Matrix3DReadOnly)m, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            m = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            matrixActual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D mInverse = new Matrix3D();
            boolean success = Matrix3DTools.invert((Matrix3DReadOnly)m, (CommonMatrix3DBasics)mInverse);
            if (!success) {
                m = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)1.0, (double)10.0);
                Matrix3DTools.invert((Matrix3DReadOnly)m, (CommonMatrix3DBasics)mInverse);
            }
            matrixExpected.setIdentity();
            Matrix3DTools.multiply((Matrix3DReadOnly)m, (Matrix3DReadOnly)mInverse, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
            Matrix3DTools.multiply((Matrix3DReadOnly)mInverse, (Matrix3DReadOnly)m, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            double angle1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            double angle2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            RotationMatrix rotationMatrixExpected = new RotationMatrix();
            RotationMatrix rotationMatrixActual = new RotationMatrix();
            RotationMatrix m12 = new RotationMatrix();
            RotationMatrix m22 = new RotationMatrix();
            RotationMatrixConversion.convertAxisAngleToMatrix((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle1, (CommonMatrix3DBasics)m12);
            RotationMatrixConversion.convertAxisAngleToMatrix((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle2, (CommonMatrix3DBasics)m22);
            RotationMatrixConversion.convertAxisAngleToMatrix((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)(angle1 + angle2), (CommonMatrix3DBasics)rotationMatrixExpected);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)m12, (RotationMatrixReadOnly)m22, (CommonMatrix3DBasics)rotationMatrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrixExpected, (Matrix3DReadOnly)rotationMatrixActual, (double)1.0E-10);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)m22, (RotationMatrixReadOnly)m12, (CommonMatrix3DBasics)rotationMatrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrixExpected, (Matrix3DReadOnly)rotationMatrixActual, (double)1.0E-10);
        }
        for (i2 = 0; i2 < 1000; ++i2) {
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            RotationMatrix rotationMatrixExpected = new RotationMatrix();
            RotationMatrix rotationMatrixActual = new RotationMatrix();
            RotationMatrixConversion.convertAxisAngleToMatrix((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)angle, (CommonMatrix3DBasics)rotationMatrixActual);
            RotationMatrixConversion.convertAxisAngleToMatrix((double)axis.getX(), (double)axis.getY(), (double)axis.getZ(), (double)(2.0 * angle), (CommonMatrix3DBasics)rotationMatrixExpected);
            RotationMatrixTools.multiply((RotationMatrixReadOnly)rotationMatrixActual, (RotationMatrixReadOnly)rotationMatrixActual, (CommonMatrix3DBasics)rotationMatrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)rotationMatrixExpected, (Matrix3DReadOnly)rotationMatrixActual, (double)1.0E-10);
        }
        DMatrixRMaj dm1 = new DMatrixRMaj(3, 3);
        DMatrixRMaj dm2 = new DMatrixRMaj(3, 3);
        DMatrixRMaj dmResult = new DMatrixRMaj(3, 3);
        for (i = 0; i < 1000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m1.get((DMatrix)dm1);
            m2.get((DMatrix)dm2);
            CommonOps_DDRM.mult((DMatrix1Row)dm1, (DMatrix1Row)dm2, (DMatrix1Row)dmResult);
            matrixExpected.set((DMatrix)dmResult);
            Matrix3DTools.multiply((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        }
        for (i = 0; i < 4000; ++i) {
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            if (random.nextBoolean()) {
                m1.setIdentity();
            }
            if (random.nextBoolean()) {
                m2.setIdentity();
            }
            boolean transpose1 = random.nextBoolean();
            boolean invert1 = random.nextBoolean();
            boolean transpose2 = random.nextBoolean();
            boolean invert2 = random.nextBoolean();
            m1.get((DMatrix)dm1);
            m2.get((DMatrix)dm2);
            if (transpose1) {
                CommonOps_DDRM.transpose((DMatrixRMaj)dm1);
            }
            if (invert1) {
                CommonOps_DDRM.invert((DMatrixRMaj)dm1);
            }
            if (transpose2) {
                CommonOps_DDRM.transpose((DMatrixRMaj)dm2);
            }
            if (invert2) {
                CommonOps_DDRM.invert((DMatrixRMaj)dm2);
            }
            CommonOps_DDRM.mult((DMatrix1Row)dm1, (DMatrix1Row)dm2, (DMatrix1Row)dmResult);
            matrixExpected.set((DMatrix)dmResult);
            Matrix3DTools.multiply((Matrix3DReadOnly)m1, (boolean)transpose1, (boolean)invert1, (Matrix3DReadOnly)m2, (boolean)transpose2, (boolean)invert2, (CommonMatrix3DBasics)matrixActual);
            if (invert1 || invert2) {
                EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)2.0E-9);
                continue;
            }
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        }
        for (i = 0; i < 4000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            if (random.nextBoolean()) {
                matrix.setIdentity();
            }
            if (random.nextBoolean()) {
                orientation.setToZero();
            }
            boolean transposeMatrix = random.nextBoolean();
            boolean invertMatrix = random.nextBoolean();
            boolean invertOrientation = random.nextBoolean();
            Matrix3D expected = new Matrix3D();
            rotationMatrix = new RotationMatrix((Orientation3DReadOnly)orientation);
            Matrix3DTools.multiply((Matrix3DReadOnly)matrix, (boolean)transposeMatrix, (boolean)invertMatrix, (Matrix3DReadOnly)rotationMatrix, (boolean)invertOrientation, (boolean)false, (CommonMatrix3DBasics)expected);
            actual = new Matrix3D();
            Matrix3DTools.multiply((Matrix3DReadOnly)matrix, (boolean)transposeMatrix, (boolean)invertMatrix, (Orientation3DReadOnly)orientation, (boolean)invertOrientation, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
        for (i = 0; i < 4000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            orientation = EuclidCoreRandomTools.nextOrientation3D((Random)random);
            if (random.nextBoolean()) {
                matrix.setIdentity();
            }
            if (random.nextBoolean()) {
                orientation.setToZero();
            }
            boolean transposeMatrix = random.nextBoolean();
            boolean invertMatrix = random.nextBoolean();
            boolean invertOrientation = random.nextBoolean();
            Matrix3D expected = new Matrix3D();
            rotationMatrix = new RotationMatrix((Orientation3DReadOnly)orientation);
            Matrix3DTools.multiply((Matrix3DReadOnly)matrix, (boolean)transposeMatrix, (boolean)invertMatrix, (Matrix3DReadOnly)rotationMatrix, (boolean)invertOrientation, (boolean)false, (CommonMatrix3DBasics)expected);
            actual = new Matrix3D();
            Matrix3DTools.multiply((Matrix3DReadOnly)matrix, (boolean)transposeMatrix, (boolean)invertMatrix, (Orientation3DReadOnly)orientation, (boolean)invertOrientation, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyTransposeBoth() throws Exception {
        Random random = new Random(53463L);
        Matrix3D matrixExpected = new Matrix3D();
        Matrix3D matrixActual = new Matrix3D();
        for (int i = 0; i < 1000; ++i) {
            matrixActual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m1Copy = new Matrix3D((Matrix3DReadOnly)m1);
            Matrix3D m2Copy = new Matrix3D((Matrix3DReadOnly)m2);
            Matrix3D m1Transpose = new Matrix3D();
            m1Transpose.setAndTranspose((Matrix3DReadOnly)m1);
            Matrix3D m2Transpose = new Matrix3D();
            m2Transpose.setAndTranspose((Matrix3DReadOnly)m2);
            Matrix3DTools.multiply((Matrix3DReadOnly)m1Transpose, (Matrix3DReadOnly)m2Transpose, (CommonMatrix3DBasics)matrixExpected);
            Matrix3DTools.multiplyTransposeBoth((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
            Assertions.assertEquals((Object)m1, (Object)m1Copy);
            Assertions.assertEquals((Object)m2, (Object)m2Copy);
        }
        DMatrixRMaj dm1 = new DMatrixRMaj(3, 3);
        DMatrixRMaj dm2 = new DMatrixRMaj(3, 3);
        DMatrixRMaj dmResult = new DMatrixRMaj(3, 3);
        for (int i = 0; i < 1000; ++i) {
            Matrix3D m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m1.get((DMatrix)dm1);
            m2.get((DMatrix)dm2);
            CommonOps_DDRM.multTransAB((DMatrix1Row)dm1, (DMatrix1Row)dm2, (DMatrix1Row)dmResult);
            matrixExpected.set((DMatrix)dmResult);
            Matrix3DTools.multiplyTransposeBoth((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertBoth() throws Exception {
        int i;
        Random random = new Random(53463L);
        Matrix3D matrixExpected = new Matrix3D();
        Matrix3D matrixActual = new Matrix3D();
        matrixActual.setToZero();
        try {
            Matrix3DTools.multiplyInvertBoth((Matrix3DReadOnly)matrixActual, (Matrix3DReadOnly)matrixActual, (CommonMatrix3DBasics)matrixActual);
            Assertions.fail((String)("Should have thrown a " + SingularMatrixException.class.getSimpleName()));
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        for (i = 0; i < 1000; ++i) {
            matrixActual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)1.0, (double)10.0);
            Matrix3D m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)1.0, (double)10.0);
            Matrix3D m1Copy = new Matrix3D((Matrix3DReadOnly)m1);
            Matrix3D m2Copy = new Matrix3D((Matrix3DReadOnly)m2);
            Matrix3D m1Inverse = new Matrix3D();
            m1Inverse.setAndInvert((Matrix3DReadOnly)m1);
            Matrix3D m2Inverse = new Matrix3D();
            m2Inverse.setAndInvert((Matrix3DReadOnly)m2);
            Matrix3DTools.multiply((Matrix3DReadOnly)m1Inverse, (Matrix3DReadOnly)m2Inverse, (CommonMatrix3DBasics)matrixExpected);
            Matrix3DTools.multiplyInvertBoth((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-7);
            Assertions.assertEquals((Object)m1, (Object)m1Copy);
            Assertions.assertEquals((Object)m2, (Object)m2Copy);
        }
        for (i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrixActual = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix m1 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix m2 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Matrix3D m1Inverse = new Matrix3D();
            m1Inverse.setAndInvert((Matrix3DReadOnly)m1);
            Matrix3D m2Inverse = new Matrix3D();
            m2Inverse.setAndInvert((Matrix3DReadOnly)m2);
            Matrix3DTools.multiply((Matrix3DReadOnly)m1Inverse, (Matrix3DReadOnly)m2Inverse, (CommonMatrix3DBasics)matrixExpected);
            RotationMatrixTools.multiplyTransposeBoth((RotationMatrixReadOnly)m1, (RotationMatrixReadOnly)m2, (CommonMatrix3DBasics)rotationMatrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)rotationMatrixActual, (double)1.0E-7);
        }
    }

    @Test
    public void testMultiplyTransposeLeft() throws Exception {
        Random random = new Random(53463L);
        Matrix3D matrixExpected = new Matrix3D();
        Matrix3D matrixActual = new Matrix3D();
        for (int i = 0; i < 1000; ++i) {
            matrixActual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m1Copy = new Matrix3D((Matrix3DReadOnly)m1);
            Matrix3D m2Copy = new Matrix3D((Matrix3DReadOnly)m2);
            Matrix3D m1Transpose = new Matrix3D();
            m1Transpose.setAndTranspose((Matrix3DReadOnly)m1);
            Matrix3DTools.multiply((Matrix3DReadOnly)m1Transpose, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixExpected);
            Matrix3DTools.multiplyTransposeLeft((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
            Assertions.assertEquals((Object)m1, (Object)m1Copy);
            Assertions.assertEquals((Object)m2, (Object)m2Copy);
        }
        DMatrixRMaj dm1 = new DMatrixRMaj(3, 3);
        DMatrixRMaj dm2 = new DMatrixRMaj(3, 3);
        DMatrixRMaj dmResult = new DMatrixRMaj(3, 3);
        for (int i = 0; i < 1000; ++i) {
            Matrix3D m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m1.get((DMatrix)dm1);
            m2.get((DMatrix)dm2);
            CommonOps_DDRM.multTransA((DMatrix1Row)dm1, (DMatrix1Row)dm2, (DMatrix1Row)dmResult);
            matrixExpected.set((DMatrix)dmResult);
            Matrix3DTools.multiplyTransposeLeft((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertLeft() throws Exception {
        Matrix3D m2;
        Matrix3D m1;
        int i;
        Random random = new Random(53463L);
        Matrix3D matrixExpected = new Matrix3D();
        Matrix3D matrixActual = new Matrix3D();
        matrixActual.setToZero();
        try {
            Matrix3DTools.multiplyInvertLeft((Matrix3DReadOnly)matrixActual, (Matrix3DReadOnly)matrixActual, (CommonMatrix3DBasics)matrixActual);
            Assertions.fail((String)("Should have thrown a " + SingularMatrixException.class.getSimpleName()));
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        for (i = 0; i < 1000; ++i) {
            matrixActual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m1Copy = new Matrix3D((Matrix3DReadOnly)m1);
            Matrix3D m2Copy = new Matrix3D((Matrix3DReadOnly)m2);
            Matrix3D m1Inverse = new Matrix3D();
            m1Inverse.setAndInvert((Matrix3DReadOnly)m1);
            Matrix3DTools.multiply((Matrix3DReadOnly)m1Inverse, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixExpected);
            Matrix3DTools.multiplyInvertLeft((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
            Assertions.assertEquals((Object)m1, (Object)m1Copy);
            Assertions.assertEquals((Object)m2, (Object)m2Copy);
        }
        for (i = 0; i < 1000; ++i) {
            matrixActual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m1 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m1Inverse = new Matrix3D();
            m1Inverse.setAndInvert((Matrix3DReadOnly)m1);
            Matrix3DTools.multiply((Matrix3DReadOnly)m1Inverse, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixExpected);
            Matrix3DTools.multiplyInvertLeft((RotationMatrixReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyTransposeRight() throws Exception {
        Random random = new Random(53463L);
        Matrix3D matrixExpected = new Matrix3D();
        Matrix3D matrixActual = new Matrix3D();
        for (int i = 0; i < 1000; ++i) {
            matrixActual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m1Copy = new Matrix3D((Matrix3DReadOnly)m1);
            Matrix3D m2Copy = new Matrix3D((Matrix3DReadOnly)m2);
            Matrix3D m2Transpose = new Matrix3D();
            m2Transpose.setAndTranspose((Matrix3DReadOnly)m2);
            Matrix3DTools.multiply((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2Transpose, (CommonMatrix3DBasics)matrixExpected);
            Matrix3DTools.multiplyTransposeRight((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
            Assertions.assertEquals((Object)m1, (Object)m1Copy);
            Assertions.assertEquals((Object)m2, (Object)m2Copy);
        }
        DMatrixRMaj dm1 = new DMatrixRMaj(3, 3);
        DMatrixRMaj dm2 = new DMatrixRMaj(3, 3);
        DMatrixRMaj dmResult = new DMatrixRMaj(3, 3);
        for (int i = 0; i < 1000; ++i) {
            Matrix3D m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m1.get((DMatrix)dm1);
            m2.get((DMatrix)dm2);
            CommonOps_DDRM.multTransB((DMatrix1Row)dm1, (DMatrix1Row)dm2, (DMatrix1Row)dmResult);
            matrixExpected.set((DMatrix)dmResult);
            Matrix3DTools.multiplyTransposeRight((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInvertRight() throws Exception {
        Matrix3D m2;
        Matrix3D m1;
        int i;
        Random random = new Random(53463L);
        Matrix3D matrixExpected = new Matrix3D();
        Matrix3D matrixActual = new Matrix3D();
        matrixActual.setToZero();
        try {
            Matrix3DTools.multiplyInvertRight((Matrix3DReadOnly)matrixActual, (Matrix3DReadOnly)matrixActual, (CommonMatrix3DBasics)matrixActual);
            Assertions.fail((String)("Should have thrown a " + SingularMatrixException.class.getSimpleName()));
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        for (i = 0; i < 1000; ++i) {
            matrixActual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3D m1Copy = new Matrix3D((Matrix3DReadOnly)m1);
            Matrix3D m2Copy = new Matrix3D((Matrix3DReadOnly)m2);
            Matrix3D m2Inverse = new Matrix3D();
            m2Inverse.setAndInvert((Matrix3DReadOnly)m2);
            Matrix3DTools.multiply((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2Inverse, (CommonMatrix3DBasics)matrixExpected);
            Matrix3DTools.multiplyInvertRight((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
            Assertions.assertEquals((Object)m1, (Object)m1Copy);
            Assertions.assertEquals((Object)m2, (Object)m2Copy);
        }
        for (i = 0; i < 1000; ++i) {
            matrixActual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m1 = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            m2 = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Matrix3D m2Inverse = new Matrix3D();
            m2Inverse.setAndInvert((Matrix3DReadOnly)m2);
            Matrix3DTools.multiply((Matrix3DReadOnly)m1, (Matrix3DReadOnly)m2Inverse, (CommonMatrix3DBasics)matrixExpected);
            Matrix3DTools.multiplyInvertRight((Matrix3DReadOnly)m1, (RotationMatrixReadOnly)m2, (CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyInner() {
        Random random = new Random(3245L);
        for (int i = 0; i < 1000; ++i) {
            Matrix3D original = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)10.0);
            Matrix3D expected = new Matrix3D();
            Matrix3DTools.multiplyTransposeLeft((Matrix3DReadOnly)original, (Matrix3DReadOnly)original, (CommonMatrix3DBasics)expected);
            Matrix3D actual = new Matrix3D();
            Matrix3DTools.multiplyInner((Matrix3DReadOnly)original, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testMultiplyOuter() {
        Random random = new Random(3245L);
        for (int i = 0; i < 1000; ++i) {
            Matrix3D original = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)10.0);
            Matrix3D expected = new Matrix3D();
            Matrix3DTools.multiplyTransposeRight((Matrix3DReadOnly)original, (Matrix3DReadOnly)original, (CommonMatrix3DBasics)expected);
            Matrix3D actual = new Matrix3D();
            Matrix3DTools.multiplyOuter((Matrix3DReadOnly)original, (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testNormalize() throws Exception {
        Random random = new Random(39456L);
        Matrix3D matrixExpected = new Matrix3D();
        Matrix3D matrixActual = new Matrix3D();
        matrixActual.setIdentity();
        matrixExpected.setIdentity();
        Matrix3DTools.normalize((CommonMatrix3DBasics)matrixActual);
        EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        for (int i = 0; i < 1000; ++i) {
            matrixExpected.set((RotationMatrixReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random));
            matrixActual.set(matrixExpected);
            Matrix3DTools.normalize((CommonMatrix3DBasics)matrixActual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)matrixExpected, (Matrix3DReadOnly)matrixActual, (double)1.0E-10);
        }
        Vector3D vector1 = new Vector3D();
        Vector3D vector2 = new Vector3D();
        for (int i = 0; i < 1000; ++i) {
            int j;
            matrixActual = EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)1.0, (double)2.0);
            Matrix3DTools.normalize((CommonMatrix3DBasics)matrixActual);
            for (j = 0; j < 3; ++j) {
                matrixActual.getRow(j, (Tuple3DBasics)vector1);
                Assertions.assertEquals((double)1.0, (double)vector1.length(), (double)1.0E-10);
                matrixActual.getColumn(j, (Tuple3DBasics)vector1);
                Assertions.assertEquals((double)1.0, (double)vector1.length(), (double)1.0E-10);
            }
            for (j = 0; j < 3; ++j) {
                matrixActual.getRow(j, (Tuple3DBasics)vector1);
                matrixActual.getRow((j + 1) % 3, (Tuple3DBasics)vector2);
                Assertions.assertEquals((double)0.0, (double)vector1.dot((Vector3DReadOnly)vector2), (double)1.0E-10);
                matrixActual.getColumn(j, (Tuple3DBasics)vector1);
                matrixActual.getColumn((j + 1) % 3, (Tuple3DBasics)vector2);
                Assertions.assertEquals((double)0.0, (double)vector1.dot((Vector3DReadOnly)vector2), (double)1.0E-10);
            }
        }
    }

    @Test
    public void testTransformTuple() throws Exception {
        int i;
        Random random = new Random(3489756L);
        Matrix3D matrix = new Matrix3D();
        Vector3D tupleOriginal = new Vector3D();
        Vector3D tupleActual = new Vector3D();
        Vector3D tupleExpected = new Vector3D();
        matrix.setToZero();
        Matrix3D matrixCopy = new Matrix3D((Matrix3DReadOnly)matrix);
        tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
        Vector3D tupleOriginalCopy = new Vector3D((Tuple3DReadOnly)tupleOriginal);
        tupleExpected.setToZero();
        Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        Assertions.assertEquals((Object)tupleOriginal, (Object)tupleOriginalCopy);
        Assertions.assertEquals((Object)matrix, (Object)matrixCopy);
        matrix.setIdentity();
        tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
        tupleExpected.set((Tuple3DReadOnly)tupleOriginal);
        Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        for (int i2 = 0; i2 < 1000; ++i2) {
            matrix = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)1.0, (double)10.0);
            tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            tupleExpected.setX(matrix.getM00() * tupleOriginal.getX());
            tupleExpected.setY(matrix.getM11() * tupleOriginal.getY());
            tupleExpected.setZ(matrix.getM22() * tupleOriginal.getZ());
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        }
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        DMatrixRMaj denseVectorOriginal = new DMatrixRMaj(3, 1);
        DMatrixRMaj denseVectorTransformed = new DMatrixRMaj(3, 1);
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            matrix.get((DMatrix)denseMatrix);
            tupleOriginal.get((DMatrix)denseVectorOriginal);
            CommonOps_DDRM.mult((DMatrix1Row)denseMatrix, (DMatrix1Row)denseVectorOriginal, (DMatrix1Row)denseVectorTransformed);
            tupleExpected.set((DMatrix)denseVectorTransformed);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleExpected);
            tupleActual.set((Tuple3DReadOnly)tupleOriginal);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        }
    }

    @Test
    public void testAddTransformTuple() throws Exception {
        int i;
        Random random = new Random(3489756L);
        Matrix3D matrix = new Matrix3D();
        Vector3D tupleOriginal = new Vector3D();
        Vector3D tupleActual = new Vector3D();
        Vector3D tupleExpected = new Vector3D();
        matrix.setToZero();
        Matrix3D matrixCopy = new Matrix3D((Matrix3DReadOnly)matrix);
        tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
        Vector3D tupleOriginalCopy = new Vector3D((Tuple3DReadOnly)tupleOriginal);
        tupleExpected = EuclidCoreRandomTools.nextVector3D((Random)random);
        tupleActual.set((Tuple3DReadOnly)tupleExpected);
        Matrix3DTools.addTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        Assertions.assertEquals((Object)tupleOriginal, (Object)tupleOriginalCopy);
        Assertions.assertEquals((Object)matrix, (Object)matrixCopy);
        matrix.setIdentity();
        tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
        tupleActual = EuclidCoreRandomTools.nextVector3D((Random)random);
        tupleExpected.add((Tuple3DReadOnly)tupleActual, (Tuple3DReadOnly)tupleOriginal);
        Matrix3DTools.addTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        for (int i2 = 0; i2 < 1000; ++i2) {
            matrix = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)1.0, (double)10.0);
            tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            tupleActual = EuclidCoreRandomTools.nextVector3D((Random)random);
            tupleExpected.setX(matrix.getM00() * tupleOriginal.getX());
            tupleExpected.setY(matrix.getM11() * tupleOriginal.getY());
            tupleExpected.setZ(matrix.getM22() * tupleOriginal.getZ());
            tupleExpected.add((Tuple3DReadOnly)tupleActual);
            Matrix3DTools.addTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        }
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        DMatrixRMaj denseVectorOriginal = new DMatrixRMaj(3, 1);
        DMatrixRMaj denseVectorTransformed = new DMatrixRMaj(3, 1);
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            tupleActual = EuclidCoreRandomTools.nextVector3D((Random)random);
            matrix.get((DMatrix)denseMatrix);
            tupleOriginal.get((DMatrix)denseVectorOriginal);
            tupleActual.get((DMatrix)denseVectorTransformed);
            CommonOps_DDRM.multAdd((DMatrix1Row)denseMatrix, (DMatrix1Row)denseVectorOriginal, (DMatrix1Row)denseVectorTransformed);
            tupleExpected.set((DMatrix)denseVectorTransformed);
            Matrix3DTools.addTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            tupleActual = EuclidCoreRandomTools.nextVector3D((Random)random);
            tupleExpected.set((Tuple3DReadOnly)tupleActual);
            Matrix3DTools.addTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleExpected);
            Matrix3DTools.addTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        }
    }

    @Test
    public void testSubTransformTuple() throws Exception {
        int i;
        Random random = new Random(3489756L);
        Matrix3D matrix = new Matrix3D();
        Vector3D tupleOriginal = new Vector3D();
        Vector3D tupleActual = new Vector3D();
        Vector3D tupleExpected = new Vector3D();
        matrix.setToZero();
        Matrix3D matrixCopy = new Matrix3D((Matrix3DReadOnly)matrix);
        tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
        Vector3D tupleOriginalCopy = new Vector3D((Tuple3DReadOnly)tupleOriginal);
        tupleExpected = EuclidCoreRandomTools.nextVector3D((Random)random);
        tupleActual.set((Tuple3DReadOnly)tupleExpected);
        Matrix3DTools.subTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        Assertions.assertEquals((Object)tupleOriginal, (Object)tupleOriginalCopy);
        Assertions.assertEquals((Object)matrix, (Object)matrixCopy);
        matrix.setIdentity();
        tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
        tupleActual = EuclidCoreRandomTools.nextVector3D((Random)random);
        tupleExpected.sub((Tuple3DReadOnly)tupleActual, (Tuple3DReadOnly)tupleOriginal);
        Matrix3DTools.subTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        for (int i2 = 0; i2 < 1000; ++i2) {
            matrix = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)1.0, (double)10.0);
            tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            tupleActual = EuclidCoreRandomTools.nextVector3D((Random)random);
            tupleExpected.setX(matrix.getM00() * tupleOriginal.getX());
            tupleExpected.setY(matrix.getM11() * tupleOriginal.getY());
            tupleExpected.setZ(matrix.getM22() * tupleOriginal.getZ());
            tupleExpected.sub((Tuple3DReadOnly)tupleActual, (Tuple3DReadOnly)tupleExpected);
            Matrix3DTools.subTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        }
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        DMatrixRMaj denseVectorOriginal = new DMatrixRMaj(3, 1);
        DMatrixRMaj denseVectorTransformed = new DMatrixRMaj(3, 1);
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            tupleActual = EuclidCoreRandomTools.nextVector3D((Random)random);
            matrix.get((DMatrix)denseMatrix);
            tupleOriginal.get((DMatrix)denseVectorOriginal);
            tupleActual.get((DMatrix)denseVectorTransformed);
            CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)denseMatrix, (DMatrix1Row)denseVectorOriginal, (DMatrix1Row)denseVectorTransformed);
            tupleExpected.set((DMatrix)denseVectorTransformed);
            Matrix3DTools.subTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            tupleActual = EuclidCoreRandomTools.nextVector3D((Random)random);
            tupleExpected.set((Tuple3DReadOnly)tupleActual);
            Matrix3DTools.subTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleExpected);
            Matrix3DTools.subTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        }
    }

    @Test
    public void testTransformTuple2D() throws Exception {
        int i;
        Random random = new Random(3489756L);
        Matrix3D matrix = new Matrix3D();
        Vector2D tupleOriginal = new Vector2D();
        Vector2D tupleActual = new Vector2D();
        Vector2D tupleExpected = new Vector2D();
        matrix.setToZero();
        Matrix3D matrixCopy = new Matrix3D((Matrix3DReadOnly)matrix);
        tupleOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
        Vector2D tupleOriginalCopy = new Vector2D((Tuple2DReadOnly)tupleOriginal);
        tupleExpected.setToZero();
        Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)false);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tupleExpected, (Tuple2DReadOnly)tupleActual, (double)1.0E-10);
        Assertions.assertEquals((Object)tupleOriginal, (Object)tupleOriginalCopy);
        Assertions.assertEquals((Object)matrix, (Object)matrixCopy);
        matrix.setIdentity();
        tupleOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
        tupleExpected.set((Tuple2DReadOnly)tupleOriginal);
        Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)false);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tupleExpected, (Tuple2DReadOnly)tupleActual, (double)1.0E-10);
        for (int i2 = 0; i2 < 1000; ++i2) {
            matrix = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)1.0, (double)10.0);
            tupleOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
            tupleExpected.setX(matrix.getM00() * tupleOriginal.getX());
            tupleExpected.setY(matrix.getM11() * tupleOriginal.getY());
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tupleExpected, (Tuple2DReadOnly)tupleActual, (double)1.0E-10);
        }
        DMatrixRMaj denseMatrix = new DMatrixRMaj(2, 2);
        DMatrixRMaj denseVectorOriginal = new DMatrixRMaj(2, 1);
        DMatrixRMaj denseVectorTransformed = new DMatrixRMaj(2, 1);
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
            denseMatrix.set(0, 0, matrix.getM00());
            denseMatrix.set(0, 1, matrix.getM01());
            denseMatrix.set(1, 0, matrix.getM10());
            denseMatrix.set(1, 1, matrix.getM11());
            tupleOriginal.get((DMatrix)denseVectorOriginal);
            CommonOps_DDRM.mult((DMatrix1Row)denseMatrix, (DMatrix1Row)denseVectorOriginal, (DMatrix1Row)denseVectorTransformed);
            tupleExpected.set((DMatrix)denseVectorTransformed);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tupleExpected, (Tuple2DReadOnly)tupleActual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleExpected, (boolean)false);
            tupleActual.set((Tuple2DReadOnly)tupleOriginal);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tupleExpected, (Tuple2DReadOnly)tupleActual, (double)1.0E-10);
        }
        matrix.setIdentity();
        matrix.setM02(2.0);
        try {
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)("Should have thrown a " + NotAMatrix2DException.class.getSimpleName()));
        }
        catch (NotAMatrix2DException i3) {
            // empty catch block
        }
        matrix.setIdentity();
        matrix.setM12(2.0);
        try {
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)("Should have thrown a " + NotAMatrix2DException.class.getSimpleName()));
        }
        catch (NotAMatrix2DException i3) {
            // empty catch block
        }
        matrix.setIdentity();
        matrix.setM22(2.0);
        try {
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)("Should have thrown a " + NotAMatrix2DException.class.getSimpleName()));
        }
        catch (NotAMatrix2DException i3) {
            // empty catch block
        }
        matrix.setIdentity();
        matrix.setM20(2.0);
        try {
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)("Should have thrown a " + NotAMatrix2DException.class.getSimpleName()));
        }
        catch (NotAMatrix2DException i3) {
            // empty catch block
        }
        matrix.setIdentity();
        matrix.setM21(2.0);
        try {
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)("Should have thrown a " + NotAMatrix2DException.class.getSimpleName()));
        }
        catch (NotAMatrix2DException i3) {
            // empty catch block
        }
        for (int i4 = 0; i4 < 1000; ++i4) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            matrix.setColumn(2, 0.0, 0.0, 1.0);
            matrix.setRow(2, 0.0, 0.0, 1.0);
            tupleOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleExpected, (boolean)false);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)true);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tupleExpected, (Tuple2DReadOnly)tupleActual, (double)1.0E-10);
        }
    }

    @Test
    public void testTransformQuaternion() throws Exception {
        Random random = new Random(324636L);
        RotationMatrix matrix = new RotationMatrix();
        RotationMatrix matrixOriginal = new RotationMatrix();
        RotationMatrix matrixExpected = new RotationMatrix();
        Quaternion qOriginal = new Quaternion();
        Quaternion qExpected = new Quaternion();
        Quaternion qActual = new Quaternion();
        for (int i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            qOriginal = EuclidCoreRandomTools.nextQuaternion((Random)random);
            matrixOriginal.set((Orientation3DReadOnly)qOriginal);
            matrixExpected.set(matrix);
            matrixExpected.multiply((RotationMatrixReadOnly)matrixOriginal);
            qExpected.set((Orientation3DReadOnly)matrixExpected);
            matrix.transform((Orientation3DReadOnly)qOriginal, (Orientation3DBasics)qActual);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)qExpected, (QuaternionReadOnly)qActual, (double)1.0E-10);
        }
    }

    @Test
    public void testTransformVector4D() throws Exception {
        int i;
        Random random = new Random(3489756L);
        Matrix3D matrix = new Matrix3D();
        Vector4D vectorOriginal = new Vector4D();
        Vector4D vectorActual = new Vector4D();
        Vector4D vectorExpected = new Vector4D();
        matrix.setToZero();
        Matrix3D matrixCopy = new Matrix3D((Matrix3DReadOnly)matrix);
        vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
        Vector4D vectorOriginalCopy = new Vector4D((Tuple4DReadOnly)vectorOriginal);
        vectorExpected.set(0.0, 0.0, 0.0, vectorOriginal.getS());
        Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
        EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)vectorExpected, (Tuple4DReadOnly)vectorActual, (double)1.0E-10);
        Assertions.assertEquals((Object)vectorOriginal, (Object)vectorOriginalCopy);
        Assertions.assertEquals((Object)matrix, (Object)matrixCopy);
        matrix.setIdentity();
        vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
        vectorExpected.set(vectorOriginal);
        Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
        EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)vectorExpected, (Tuple4DReadOnly)vectorActual, (double)1.0E-10);
        for (int i2 = 0; i2 < 1000; ++i2) {
            matrix = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)1.0, (double)10.0);
            vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            vectorExpected.setX(matrix.getM00() * vectorOriginal.getX());
            vectorExpected.setY(matrix.getM11() * vectorOriginal.getY());
            vectorExpected.setZ(matrix.getM22() * vectorOriginal.getZ());
            vectorExpected.setS(vectorOriginal.getS());
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)vectorExpected, (Tuple4DReadOnly)vectorActual, (double)1.0E-10);
        }
        DMatrixRMaj denseMatrix = new DMatrixRMaj(3, 3);
        DMatrixRMaj denseVectorOriginal = new DMatrixRMaj(3, 1);
        DMatrixRMaj denseVectorTransformed = new DMatrixRMaj(3, 1);
        for (i = 0; i < 1000; ++i) {
            int index;
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            matrix.get((DMatrix)denseMatrix);
            for (index = 0; index < 3; ++index) {
                denseVectorOriginal.set(index, vectorOriginal.getElement(index));
            }
            CommonOps_DDRM.mult((DMatrix1Row)denseMatrix, (DMatrix1Row)denseVectorOriginal, (DMatrix1Row)denseVectorTransformed);
            for (index = 0; index < 3; ++index) {
                vectorExpected.setElement(index, denseVectorTransformed.get(index));
            }
            vectorExpected.setS(vectorOriginal.getS());
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)vectorExpected, (Tuple4DReadOnly)vectorActual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorExpected);
            vectorActual.set(vectorOriginal);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Vector4DReadOnly)vectorActual, (Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)vectorExpected, (Tuple4DReadOnly)vectorActual, (double)1.0E-10);
        }
    }

    @Test
    public void testTransformMatrix() throws Exception {
    }

    @Test
    public void testInverseTransformTuple() throws Exception {
        int i;
        Random random = new Random(3489756L);
        Matrix3D matrix = new Matrix3D();
        Matrix3D matrixInverse = new Matrix3D();
        Vector3D tupleOriginal = new Vector3D();
        Vector3D tupleActual = new Vector3D();
        Vector3D tupleExpected = new Vector3D();
        matrix.setToZero();
        try {
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
            Assertions.fail((String)("Should have thrown a " + SingularMatrixException.class.getSimpleName()));
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.invert((Matrix3DReadOnly)matrix, (CommonMatrix3DBasics)matrixInverse);
            tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            Matrix3DTools.transform((Matrix3DReadOnly)matrixInverse, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleExpected);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            tupleExpected.set((Tuple3DReadOnly)tupleOriginal);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            matrix.set((RotationMatrixReadOnly)rotationMatrix);
            tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleExpected);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector3D((Random)random);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)tupleExpected);
            tupleActual.set((Tuple3DReadOnly)tupleOriginal);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Tuple3DReadOnly)tupleActual, (Tuple3DBasics)tupleActual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)tupleExpected, (Tuple3DReadOnly)tupleActual, (double)1.0E-10);
        }
    }

    @Test
    public void testInverseTransformTuple2D() throws Exception {
        int i;
        Random random = new Random(3489756L);
        Matrix3D matrix = new Matrix3D();
        Matrix3D matrixInverse = new Matrix3D();
        Vector2D tupleOriginal = new Vector2D();
        Vector2D tupleActual = new Vector2D();
        Vector2D tupleExpected = new Vector2D();
        matrix.setToZero();
        try {
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)false);
            Assertions.fail((String)("Should have thrown a " + SingularMatrixException.class.getSimpleName()));
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            matrix.setRow(2, 0.0, 0.0, 1.0);
            matrix.setColumn(2, 0.0, 0.0, 1.0);
            Matrix3DTools.invert((Matrix3DReadOnly)matrix, (CommonMatrix3DBasics)matrixInverse);
            tupleOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
            Matrix3DTools.transform((Matrix3DReadOnly)matrixInverse, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleExpected, (boolean)false);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tupleExpected, (Tuple2DReadOnly)tupleActual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = new RotationMatrix();
            rotationMatrix.setToYawOrientation(Math.PI * 2 * random.nextDouble());
            matrix.set((RotationMatrixReadOnly)rotationMatrix);
            tupleOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleExpected, (boolean)false);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleActual, (boolean)false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tupleExpected, (Tuple2DReadOnly)tupleActual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            tupleOriginal = EuclidCoreRandomTools.nextVector2D((Random)random);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)tupleExpected, (boolean)false);
            tupleActual.set((Tuple2DReadOnly)tupleOriginal);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)tupleExpected, (Tuple2DReadOnly)tupleActual, (double)1.0E-10);
        }
        matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        try {
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)("Should have thrown a " + NotAMatrix2DException.class.getSimpleName()));
        }
        catch (NotAMatrix2DException i2) {
            // empty catch block
        }
        RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        try {
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Tuple2DReadOnly)tupleActual, (Tuple2DBasics)tupleActual, (boolean)true);
            Assertions.fail((String)("Should have thrown a " + NotAMatrix2DException.class.getSimpleName()));
        }
        catch (NotAMatrix2DException notAMatrix2DException) {
            // empty catch block
        }
    }

    @Test
    public void testInverseTransformTuple4D() throws Exception {
        int i;
        Random random = new Random(3489756L);
        Matrix3D matrix = new Matrix3D();
        Matrix3D matrixInverse = new Matrix3D();
        Vector4D vectorOriginal = new Vector4D();
        Vector4D vectorActual = new Vector4D();
        Vector4D vectorExpected = new Vector4D();
        matrix.setToZero();
        try {
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
            Assertions.fail((String)("Should have thrown a " + SingularMatrixException.class.getSimpleName()));
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            Matrix3DTools.invert((Matrix3DReadOnly)matrix, (CommonMatrix3DBasics)matrixInverse);
            vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            Matrix3DTools.transform((Matrix3DReadOnly)matrixInverse, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorExpected);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)vectorExpected, (Tuple4DReadOnly)vectorActual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            vectorExpected.set(vectorOriginal);
            Matrix3DTools.transform((Matrix3DReadOnly)matrix, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Vector4DReadOnly)vectorActual, (Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)vectorExpected, (Tuple4DReadOnly)vectorActual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            matrix.set((RotationMatrixReadOnly)rotationMatrix);
            vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorExpected);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)rotationMatrix, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)vectorExpected, (Tuple4DReadOnly)vectorActual, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            matrix = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            vectorOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Vector4DReadOnly)vectorOriginal, (Vector4DBasics)vectorExpected);
            vectorActual.set(vectorOriginal);
            Matrix3DTools.inverseTransform((Matrix3DReadOnly)matrix, (Vector4DReadOnly)vectorActual, (Vector4DBasics)vectorActual);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)vectorExpected, (Tuple4DReadOnly)vectorActual, (double)1.0E-10);
        }
    }
}

