/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTestTools;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameShapeTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.ConvexPolytope3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.Capsule3D;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.shape.primitives.Ellipsoid3D;
import us.ihmc.euclid.shape.primitives.Ramp3D;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Cylinder3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Ramp3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Sphere3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidFrameShapeToolsTest {
    private static final int ITERATIONS = 5000;
    private static final double EPSILON = 1.0E-12;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @Test
    public void testBoundingBoxBox3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            Box3D boxInFrame = EuclidShapeRandomTools.nextBox3D((Random)random);
            boxInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Box3D boxInWorld = new Box3D((Box3DReadOnly)boxInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            EuclidShapeTools.boundingBoxBox3D((Point3DReadOnly)boxInWorld.getPosition(), (RotationMatrixReadOnly)boxInWorld.getOrientation(), (Vector3DReadOnly)boxInWorld.getSize(), (BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxBox3D((ReferenceFrame)worldFrame, (Box3DReadOnly)boxInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            boxInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            Box3D boxInFrame = EuclidShapeRandomTools.nextBox3D((Random)random);
            boxInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Box3D boxInWorld = new Box3D((Box3DReadOnly)boxInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)boxInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            EuclidShapeTools.boundingBoxBox3D((Point3DReadOnly)boxInWorld.getPosition(), (RotationMatrixReadOnly)boxInWorld.getOrientation(), (Vector3DReadOnly)boxInWorld.getSize(), (BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxBox3D((ReferenceFrame)shapeFrame, (Box3DReadOnly)boxInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            boxInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            Box3D boxInFrame = EuclidShapeRandomTools.nextBox3D((Random)random);
            boxInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Box3D boxInBBXFrame = new Box3D((Box3DReadOnly)boxInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)boxInBBXFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            EuclidShapeTools.boundingBoxBox3D((Point3DReadOnly)boxInBBXFrame.getPosition(), (RotationMatrixReadOnly)boxInBBXFrame.getOrientation(), (Vector3DReadOnly)boxInBBXFrame.getSize(), (BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxBox3D((ReferenceFrame)shapeFrame, (Box3DReadOnly)boxInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            boxInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testBoundingBoxCapsule3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            Capsule3D capsuleInFrame = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Capsule3D capsuleInWorld = new Capsule3D((Capsule3DReadOnly)capsuleInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            capsuleInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxCapsule3D((ReferenceFrame)worldFrame, (Capsule3DReadOnly)capsuleInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            capsuleInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            Capsule3D capsuleInFrame = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Capsule3D capsuleInWorld = new Capsule3D((Capsule3DReadOnly)capsuleInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)capsuleInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            capsuleInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxCapsule3D((ReferenceFrame)shapeFrame, (Capsule3DReadOnly)capsuleInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            capsuleInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            Capsule3D capsuleInFrame = EuclidShapeRandomTools.nextCapsule3D((Random)random);
            Capsule3D capsuleInBBX = new Capsule3D((Capsule3DReadOnly)capsuleInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)capsuleInBBX);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            capsuleInBBX.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxCapsule3D((ReferenceFrame)shapeFrame, (Capsule3DReadOnly)capsuleInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            capsuleInBBX.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testBoundingBoxCylinder3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            Cylinder3D cylinderInFrame = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Cylinder3D cylinderInWorld = new Cylinder3D((Cylinder3DReadOnly)cylinderInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            cylinderInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxCylinder3D((ReferenceFrame)worldFrame, (Cylinder3DReadOnly)cylinderInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            cylinderInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            Cylinder3D cylinderInFrame = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Cylinder3D cylinderInWorld = new Cylinder3D((Cylinder3DReadOnly)cylinderInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)cylinderInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            cylinderInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxCylinder3D((ReferenceFrame)shapeFrame, (Cylinder3DReadOnly)cylinderInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            cylinderInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            Cylinder3D cylinderInFrame = EuclidShapeRandomTools.nextCylinder3D((Random)random);
            Cylinder3D cylinderInBBX = new Cylinder3D((Cylinder3DReadOnly)cylinderInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)cylinderInBBX);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            cylinderInBBX.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxCylinder3D((ReferenceFrame)shapeFrame, (Cylinder3DReadOnly)cylinderInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            cylinderInBBX.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testBoundingBoxEllipsoid3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            Ellipsoid3D ellipsoidInFrame = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            ellipsoidInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Ellipsoid3D ellipsoidInWorld = new Ellipsoid3D((Ellipsoid3DReadOnly)ellipsoidInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            EuclidShapeTools.boundingBoxEllipsoid3D((Point3DReadOnly)ellipsoidInWorld.getPosition(), (RotationMatrixReadOnly)ellipsoidInWorld.getOrientation(), (Vector3DReadOnly)ellipsoidInWorld.getRadii(), (BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxEllipsoid3D((ReferenceFrame)worldFrame, (Ellipsoid3DReadOnly)ellipsoidInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            ellipsoidInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            Ellipsoid3D ellipsoidInFrame = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            ellipsoidInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Ellipsoid3D ellipsoidInWorld = new Ellipsoid3D((Ellipsoid3DReadOnly)ellipsoidInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)ellipsoidInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            EuclidShapeTools.boundingBoxEllipsoid3D((Point3DReadOnly)ellipsoidInWorld.getPosition(), (RotationMatrixReadOnly)ellipsoidInWorld.getOrientation(), (Vector3DReadOnly)ellipsoidInWorld.getRadii(), (BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxEllipsoid3D((ReferenceFrame)shapeFrame, (Ellipsoid3DReadOnly)ellipsoidInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            ellipsoidInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            Ellipsoid3D ellipsoidInFrame = EuclidShapeRandomTools.nextEllipsoid3D((Random)random);
            ellipsoidInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Ellipsoid3D ellipsoidInBBXFrame = new Ellipsoid3D((Ellipsoid3DReadOnly)ellipsoidInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)ellipsoidInBBXFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            EuclidShapeTools.boundingBoxEllipsoid3D((Point3DReadOnly)ellipsoidInBBXFrame.getPosition(), (RotationMatrixReadOnly)ellipsoidInBBXFrame.getOrientation(), (Vector3DReadOnly)ellipsoidInBBXFrame.getRadii(), (BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxEllipsoid3D((ReferenceFrame)shapeFrame, (Ellipsoid3DReadOnly)ellipsoidInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            ellipsoidInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testBoundingBoxRamp3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            Ramp3D rampInFrame = EuclidShapeRandomTools.nextRamp3D((Random)random);
            rampInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Ramp3D rampInWorld = new Ramp3D((Ramp3DReadOnly)rampInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            rampInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxRamp3D((ReferenceFrame)worldFrame, (Ramp3DReadOnly)rampInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            rampInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            Ramp3D rampInFrame = EuclidShapeRandomTools.nextRamp3D((Random)random);
            rampInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Ramp3D rampInWorld = new Ramp3D((Ramp3DReadOnly)rampInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)rampInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            rampInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxRamp3D((ReferenceFrame)shapeFrame, (Ramp3DReadOnly)rampInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            rampInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            Ramp3D rampInFrame = EuclidShapeRandomTools.nextRamp3D((Random)random);
            rampInFrame.getPose().set((RigidBodyTransformReadOnly)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            Ramp3D rampInBBXFrame = new Ramp3D((Ramp3DReadOnly)rampInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)rampInBBXFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            rampInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxRamp3D((ReferenceFrame)shapeFrame, (Ramp3DReadOnly)rampInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            rampInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testBoundingBoxSphere3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            Sphere3D sphereInFrame = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Sphere3D sphereInWorld = new Sphere3D((Sphere3DReadOnly)sphereInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            sphereInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxSphere3D((ReferenceFrame)worldFrame, (Sphere3DReadOnly)sphereInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            sphereInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            Sphere3D sphereInFrame = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Sphere3D sphereInWorld = new Sphere3D((Sphere3DReadOnly)sphereInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)sphereInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            sphereInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxSphere3D((ReferenceFrame)shapeFrame, (Sphere3DReadOnly)sphereInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            sphereInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            Sphere3D sphereInFrame = EuclidShapeRandomTools.nextSphere3D((Random)random);
            Sphere3D sphereInBBXFrame = new Sphere3D((Sphere3DReadOnly)sphereInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)sphereInBBXFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            sphereInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxSphere3D((ReferenceFrame)shapeFrame, (Sphere3DReadOnly)sphereInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            sphereInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testBoundingBoxConvexPolytope3D() {
        RigidBodyTransform shapeFrameTransform;
        int i;
        Random random = new Random(5768787L);
        for (i = 0; i < 5000; ++i) {
            ConvexPolytope3D convexPolytopeInFrame = EuclidShapeRandomTools.nextConvexPolytope3D((Random)random);
            convexPolytopeInFrame.applyTransform((Transform)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            ConvexPolytope3D convexPolytopeInWorld = new ConvexPolytope3D((ConvexPolytope3DReadOnly)convexPolytopeInFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            convexPolytopeInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxConvexPolytope3D((ReferenceFrame)worldFrame, (ConvexPolytope3DReadOnly)convexPolytopeInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            convexPolytopeInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ConvexPolytope3D convexPolytopeInFrame = EuclidShapeRandomTools.nextConvexPolytope3D((Random)random);
            convexPolytopeInFrame.applyTransform((Transform)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            ConvexPolytope3D convexPolytopeInWorld = new ConvexPolytope3D((ConvexPolytope3DReadOnly)convexPolytopeInFrame);
            shapeFrame.transformFromThisToDesiredFrame(worldFrame, (Transformable)convexPolytopeInWorld);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            convexPolytopeInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxConvexPolytope3D((ReferenceFrame)shapeFrame, (ConvexPolytope3DReadOnly)convexPolytopeInFrame, (ReferenceFrame)worldFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            convexPolytopeInWorld.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 5000; ++i) {
            shapeFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            RigidBodyTransform boundingBoxFrameTransform = EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3);
            ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"shapeFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)shapeFrameTransform);
            ReferenceFrame boundingBoxFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"boundingBoxFrame", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)boundingBoxFrameTransform);
            ConvexPolytope3D convexPolytopeInFrame = EuclidShapeRandomTools.nextConvexPolytope3D((Random)random);
            convexPolytopeInFrame.applyTransform((Transform)EuclidFrameShapeToolsTest.nextRigidBodyTransformWithIdentityEdgeCase(random, 0.3, 0.3));
            ConvexPolytope3D convexPolytopeInBBXFrame = new ConvexPolytope3D((ConvexPolytope3DReadOnly)convexPolytopeInFrame);
            shapeFrame.transformFromThisToDesiredFrame(boundingBoxFrame, (Transformable)convexPolytopeInBBXFrame);
            BoundingBox3D expected = new BoundingBox3D();
            BoundingBox3D actual = new BoundingBox3D();
            convexPolytopeInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidFrameShapeTools.boundingBoxConvexPolytope3D((ReferenceFrame)shapeFrame, (ConvexPolytope3DReadOnly)convexPolytopeInFrame, (ReferenceFrame)boundingBoxFrame, (BoundingBox3DBasics)actual);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
            convexPolytopeInBBXFrame.getBoundingBox((BoundingBox3DBasics)expected);
            EuclidGeometryTestTools.assertBoundingBox3DEquals((String)("Iteration " + i), (BoundingBox3DReadOnly)expected, (BoundingBox3DReadOnly)actual, (double)1.0E-12);
        }
    }

    private static RigidBodyTransform nextRigidBodyTransformWithIdentityEdgeCase(Random random, double rotationIdentityPercentage, double positionZeroPercentage) {
        RigidBodyTransform next = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        next.getRotation().setToZero();
        if (random.nextDouble() < positionZeroPercentage) {
            next.getTranslation().setToZero();
        }
        return next;
    }
}

