/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;

public class Vertex2DSupplierTest {
    public static final double EPSILON = 1.0E-12;

    @Test
    public void testCreatingEmptySupplier() {
        Vertex2DSupplier expected = Vertex2DSupplier.emptyVertex2DSupplier();
        Vertex2DSupplier actual = Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[0]);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals(actual, 1.0E-12));
        actual = Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[0], (int)0);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals(actual, 1.0E-12));
        actual = Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[0], (int)0, (int)0);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals(actual, 1.0E-12));
        actual = Vertex2DSupplier.asVertex2DSupplier(Collections.emptyList());
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals(actual, 1.0E-12));
        actual = Vertex2DSupplier.asVertex2DSupplier(Collections.emptyList(), (int)0);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals(actual, 1.0E-12));
        actual = Vertex2DSupplier.asVertex2DSupplier(Collections.emptyList(), (int)0, (int)0);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)expected.epsilonEquals(actual, 1.0E-12));
    }

    @Test
    public void testAsVertex2DSupplier() throws Exception {
        int j;
        Vertex2DSupplier supplier;
        List subList;
        int listSize;
        int numberOfVertices;
        int i;
        Random random = new Random(23423L);
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = random.nextInt(200);
            ArrayList<Point2D> original = new ArrayList<Point2D>();
            while (original.size() < numberOfVertices) {
                original.add(EuclidCoreRandomTools.nextPoint2D((Random)random));
            }
            Vertex2DSupplier supplier2 = Vertex2DSupplier.asVertex2DSupplier(original);
            Assertions.assertEquals((int)numberOfVertices, (int)supplier2.getNumberOfVertices());
            for (int j2 = 0; j2 < numberOfVertices; ++j2) {
                Assertions.assertTrue((original.get(j2) == supplier2.getVertex(j2) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices2 = random.nextInt(listSize);
            ArrayList<Point2D> original = new ArrayList<Point2D>();
            while (original.size() < listSize) {
                original.add(EuclidCoreRandomTools.nextPoint2D((Random)random));
            }
            Vertex2DSupplier supplier3 = Vertex2DSupplier.asVertex2DSupplier(original, (int)numberOfVertices2);
            Assertions.assertEquals((int)numberOfVertices2, (int)supplier3.getNumberOfVertices());
            subList = original.subList(0, numberOfVertices2);
            for (int j3 = 0; j3 < numberOfVertices2; ++j3) {
                Assertions.assertTrue((subList.get(j3) == supplier3.getVertex(j3) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices3 = random.nextInt(listSize);
            int startIndex = random.nextInt(listSize - numberOfVertices3);
            ArrayList<Point2D> original = new ArrayList<Point2D>();
            while (original.size() < listSize) {
                original.add(EuclidCoreRandomTools.nextPoint2D((Random)random));
            }
            supplier = Vertex2DSupplier.asVertex2DSupplier(original, (int)startIndex, (int)numberOfVertices3);
            Assertions.assertEquals((int)numberOfVertices3, (int)supplier.getNumberOfVertices());
            List subList2 = original.subList(startIndex, startIndex + numberOfVertices3);
            for (j = 0; j < numberOfVertices3; ++j) {
                Assertions.assertTrue((subList2.get(j) == supplier.getVertex(j) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = random.nextInt(200);
            ArrayList<Point2D> original = new ArrayList<Point2D>();
            while (original.size() < numberOfVertices) {
                original.add(EuclidCoreRandomTools.nextPoint2D((Random)random));
            }
            Vertex2DSupplier supplier4 = Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])original.toArray(new Point2DReadOnly[0]));
            Assertions.assertEquals((int)numberOfVertices, (int)supplier4.getNumberOfVertices());
            for (int j4 = 0; j4 < numberOfVertices; ++j4) {
                Assertions.assertTrue((original.get(j4) == supplier4.getVertex(j4) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices4 = random.nextInt(listSize);
            ArrayList<Point2D> original = new ArrayList<Point2D>();
            while (original.size() < listSize) {
                original.add(EuclidCoreRandomTools.nextPoint2D((Random)random));
            }
            Vertex2DSupplier supplier5 = Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])original.toArray(new Point2DReadOnly[0]), (int)numberOfVertices4);
            Assertions.assertEquals((int)numberOfVertices4, (int)supplier5.getNumberOfVertices());
            subList = original.subList(0, numberOfVertices4);
            for (int j5 = 0; j5 < numberOfVertices4; ++j5) {
                Assertions.assertTrue((subList.get(j5) == supplier5.getVertex(j5) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices5 = random.nextInt(listSize);
            int startIndex = random.nextInt(listSize - numberOfVertices5);
            ArrayList<Point2D> original = new ArrayList<Point2D>();
            while (original.size() < listSize) {
                original.add(EuclidCoreRandomTools.nextPoint2D((Random)random));
            }
            supplier = Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])original.toArray(new Point2DReadOnly[0]), (int)startIndex, (int)numberOfVertices5);
            Assertions.assertEquals((int)numberOfVertices5, (int)supplier.getNumberOfVertices());
            List subList3 = original.subList(startIndex, startIndex + numberOfVertices5);
            for (j = 0; j < numberOfVertices5; ++j) {
                Assertions.assertTrue((subList3.get(j) == supplier.getVertex(j) ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            numberOfVertices = random.nextInt(200);
            ArrayList<Point2D> original = new ArrayList<Point2D>();
            while (original.size() < numberOfVertices) {
                original.add(EuclidCoreRandomTools.nextPoint2D((Random)random));
            }
            double[][] array = new double[numberOfVertices][2];
            for (int j6 = 0; j6 < numberOfVertices; ++j6) {
                array[j6] = new double[]{((Point2D)original.get(j6)).getX(), ((Point2D)original.get(j6)).getY()};
            }
            Vertex2DSupplier supplier6 = Vertex2DSupplier.asVertex2DSupplier((double[][])array);
            Assertions.assertEquals((int)numberOfVertices, (int)supplier6.getNumberOfVertices());
            for (int j7 = 0; j7 < numberOfVertices; ++j7) {
                Assertions.assertEquals(original.get(j7), (Object)supplier6.getVertex(j7));
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices6 = random.nextInt(listSize);
            ArrayList<Point2D> original = new ArrayList<Point2D>();
            while (original.size() < listSize) {
                original.add(EuclidCoreRandomTools.nextPoint2D((Random)random));
            }
            double[][] array = new double[listSize][2];
            for (int j8 = 0; j8 < listSize; ++j8) {
                array[j8] = new double[]{((Point2D)original.get(j8)).getX(), ((Point2D)original.get(j8)).getY()};
            }
            Vertex2DSupplier supplier7 = Vertex2DSupplier.asVertex2DSupplier((double[][])array, (int)numberOfVertices6);
            Assertions.assertEquals((int)numberOfVertices6, (int)supplier7.getNumberOfVertices());
            List subList4 = original.subList(0, numberOfVertices6);
            for (j = 0; j < numberOfVertices6; ++j) {
                Assertions.assertEquals(subList4.get(j), (Object)supplier7.getVertex(j));
            }
        }
        for (i = 0; i < 1000; ++i) {
            listSize = random.nextInt(500) + 1;
            int numberOfVertices7 = random.nextInt(listSize);
            int startIndex = random.nextInt(listSize - numberOfVertices7);
            ArrayList<Point2D> original = new ArrayList<Point2D>();
            while (original.size() < listSize) {
                original.add(EuclidCoreRandomTools.nextPoint2D((Random)random));
            }
            double[][] array = new double[listSize][2];
            for (int j9 = 0; j9 < listSize; ++j9) {
                array[j9] = new double[]{((Point2D)original.get(j9)).getX(), ((Point2D)original.get(j9)).getY()};
            }
            Vertex2DSupplier supplier8 = Vertex2DSupplier.asVertex2DSupplier((double[][])array, (int)startIndex, (int)numberOfVertices7);
            Assertions.assertEquals((int)numberOfVertices7, (int)supplier8.getNumberOfVertices());
            List subList5 = original.subList(startIndex, startIndex + numberOfVertices7);
            for (int j10 = 0; j10 < numberOfVertices7; ++j10) {
                Assertions.assertEquals(subList5.get(j10), (Object)supplier8.getVertex(j10));
            }
        }
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(9017L);
        for (int i = 0; i < 1000; ++i) {
            int sizeA = random.nextInt(100) + 1;
            List listA = IntStream.range(0, sizeA).mapToObj(v -> EuclidCoreRandomTools.nextPoint2D((Random)random)).collect(Collectors.toList());
            List listAPrime = listA.stream().map(Point2D::new).collect(Collectors.toList());
            List listSizeA = IntStream.range(0, sizeA).mapToObj(v -> EuclidCoreRandomTools.nextPoint2D((Random)random)).collect(Collectors.toList());
            int sizeB = random.nextInt(100) + 1;
            List listB = IntStream.range(0, sizeB).mapToObj(v -> EuclidCoreRandomTools.nextPoint2D((Random)random)).collect(Collectors.toList());
            Assertions.assertTrue((boolean)Vertex2DSupplier.asVertex2DSupplier(listA).equals(Vertex2DSupplier.asVertex2DSupplier(listA)));
            Assertions.assertTrue((boolean)Vertex2DSupplier.asVertex2DSupplier(listA).equals(Vertex2DSupplier.asVertex2DSupplier(listAPrime)));
            Assertions.assertFalse((boolean)Vertex2DSupplier.asVertex2DSupplier(listA).equals(Vertex2DSupplier.asVertex2DSupplier(listSizeA)));
            Assertions.assertFalse((boolean)Vertex2DSupplier.asVertex2DSupplier(listA).equals(Vertex2DSupplier.asVertex2DSupplier(listB)));
        }
    }

    @Test
    public void testEpsilonquals() throws Exception {
        Random random = new Random(9017L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = random.nextDouble();
            int sizeA = random.nextInt(100) + 1;
            List listA = IntStream.range(0, sizeA).mapToObj(v -> EuclidCoreRandomTools.nextPoint2D((Random)random)).collect(Collectors.toList());
            List<Point2D> listAPrime = listA.stream().map(Point2D::new).collect(Collectors.toList());
            listAPrime.forEach(p -> p.add(EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon), EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon)));
            List<Point2D> listSizeA = listA.stream().map(Point2D::new).collect(Collectors.toList());
            listSizeA.forEach(p -> p.add((random.nextBoolean() ? -1.0 : 1.0) * EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon, (double)(epsilon + 1.0)), (random.nextBoolean() ? -1.0 : 1.0) * EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon, (double)(epsilon + 1.0))));
            int sizeB = random.nextInt(100) + 1;
            List listB = IntStream.range(0, sizeB).mapToObj(v -> EuclidCoreRandomTools.nextPoint2D((Random)random)).collect(Collectors.toList());
            Assertions.assertTrue((boolean)Vertex2DSupplier.asVertex2DSupplier(listA).epsilonEquals(Vertex2DSupplier.asVertex2DSupplier(listA), epsilon), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)Vertex2DSupplier.asVertex2DSupplier(listA).epsilonEquals(Vertex2DSupplier.asVertex2DSupplier(listAPrime), epsilon), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)Vertex2DSupplier.asVertex2DSupplier(listA).epsilonEquals(Vertex2DSupplier.asVertex2DSupplier(listSizeA), epsilon), (String)("Iteration: " + i));
            Assertions.assertFalse((boolean)Vertex2DSupplier.asVertex2DSupplier(listA).epsilonEquals(Vertex2DSupplier.asVertex2DSupplier(listB), epsilon), (String)("Iteration: " + i));
        }
    }
}

