/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Triangle3D;
import us.ihmc.euclid.geometry.Triangle3DBasicsTest;
import us.ihmc.euclid.geometry.interfaces.Triangle3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class Triangle3DTest
extends Triangle3DBasicsTest<Triangle3D> {
    @Override
    public Triangle3D newEmptyTriangle3D() {
        return new Triangle3D();
    }

    @Override
    public Triangle3D newRandomTriangle3D(Random random) {
        Point3D pointA = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Point3D pointB = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Point3D pointC = EuclidCoreRandomTools.nextPoint3D((Random)random);
        return new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
    }

    @Override
    public Triangle3D newTriangle3D(Point3DReadOnly A, Point3DReadOnly B, Point3DReadOnly C) {
        return new Triangle3D(A, B, C);
    }

    @Override
    public double getEpsilon() {
        return 1.0E-5;
    }

    @Test
    public void testConstructors() {
        Random random = new Random(1000L);
        Triangle3D triangle = new Triangle3D();
        Assertions.assertTrue((0.0 == triangle.getA().getX() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getA().getY() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getA().getZ() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getB().getX() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getB().getY() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getB().getZ() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getC().getX() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getC().getY() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0 == triangle.getC().getZ() ? 1 : 0) != 0);
        for (int i = 0; i < 1000; ++i) {
            Point3D pointA = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D pointB = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D pointC = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Triangle3D triangle3DbyPointPointPoint = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
            Assertions.assertEquals((Object)triangle3DbyPointPointPoint.getA(), (Object)pointA);
            Assertions.assertEquals((Object)triangle3DbyPointPointPoint.getB(), (Object)pointB);
            Assertions.assertEquals((Object)triangle3DbyPointPointPoint.getC(), (Object)pointC);
            Triangle3D triangle3DbyCopy = new Triangle3D((Triangle3DReadOnly)triangle3DbyPointPointPoint);
            Assertions.assertFalse((triangle3DbyCopy == triangle3DbyPointPointPoint ? 1 : 0) != 0);
            Assertions.assertEquals((Object)triangle3DbyCopy.getA(), (Object)triangle3DbyPointPointPoint.getA());
            Assertions.assertEquals((Object)triangle3DbyCopy.getB(), (Object)triangle3DbyPointPointPoint.getB());
            Assertions.assertEquals((Object)triangle3DbyCopy.getC(), (Object)triangle3DbyPointPointPoint.getC());
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(1000L);
        Point3D pointA = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Point3D pointB = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Point3D pointC = EuclidCoreRandomTools.nextPoint3D((Random)random);
        Triangle3D original = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
        Triangle3D same = new Triangle3D((Triangle3DReadOnly)original);
        Assertions.assertTrue((boolean)original.epsilonEquals(same, this.getEpsilon()));
        for (int i = 0; i < 1000; ++i) {
            pointA = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointB = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointC = EuclidCoreRandomTools.nextPoint3D((Random)random);
            original = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
            Point3D pointAChanged = new Point3D((Tuple3DReadOnly)pointA);
            Point3D pointBChanged = new Point3D((Tuple3DReadOnly)pointB);
            Point3D pointCChanged = new Point3D((Tuple3DReadOnly)pointC);
            pointAChanged.setElement(i % 3, pointAChanged.getElement(i % 3) - 1.01 * this.getEpsilon());
            Triangle3D changedA = new Triangle3D((Point3DReadOnly)pointAChanged, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
            Assertions.assertFalse((boolean)changedA.epsilonEquals(original, this.getEpsilon()));
            pointAChanged.set(pointA);
            pointAChanged.setElement(i % 3, pointAChanged.getElement(i % 3) - 0.99 * this.getEpsilon());
            changedA = new Triangle3D((Point3DReadOnly)pointAChanged, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
            Assertions.assertTrue((boolean)changedA.epsilonEquals(original, this.getEpsilon()));
            pointBChanged.setElement(i % 3, pointBChanged.getElement(i % 3) - 1.01 * this.getEpsilon());
            Triangle3D changedB = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointBChanged, (Point3DReadOnly)pointC);
            Assertions.assertFalse((boolean)changedB.epsilonEquals(original, this.getEpsilon()));
            pointBChanged.set(pointB);
            pointBChanged.setElement(i % 3, pointBChanged.getElement(i % 3) - 0.99 * this.getEpsilon());
            changedB = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointBChanged, (Point3DReadOnly)pointC);
            Assertions.assertTrue((boolean)changedB.epsilonEquals(original, this.getEpsilon()));
            pointCChanged.setElement(i % 3, pointCChanged.getElement(i % 3) - 1.01 * this.getEpsilon());
            Triangle3D changedC = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointCChanged);
            Assertions.assertFalse((boolean)changedC.epsilonEquals(original, this.getEpsilon()));
            pointCChanged.set(pointC);
            pointCChanged.setElement(i % 3, pointCChanged.getElement(i % 3) - 0.99 * this.getEpsilon());
            changedC = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointCChanged);
            Assertions.assertTrue((boolean)changedC.epsilonEquals(original, this.getEpsilon()));
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Triangle3D original;
        Point3D pointC;
        Point3D pointB;
        Point3D pointA;
        int i;
        Random random = new Random(87452L);
        for (i = 0; i < 1000; ++i) {
            pointA = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointB = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointC = EuclidCoreRandomTools.nextPoint3D((Random)random);
            original = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
            Triangle3D expected = new Triangle3D((Triangle3DReadOnly)original);
            Assertions.assertTrue((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointC, (Point3DReadOnly)pointB);
            Assertions.assertTrue((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointB, (Point3DReadOnly)pointA, (Point3DReadOnly)pointC);
            Assertions.assertTrue((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointB, (Point3DReadOnly)pointC, (Point3DReadOnly)pointA);
            Assertions.assertTrue((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointC, (Point3DReadOnly)pointB, (Point3DReadOnly)pointA);
            Assertions.assertTrue((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointC, (Point3DReadOnly)pointA, (Point3DReadOnly)pointB);
            Assertions.assertTrue((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointA, (Point3DReadOnly)pointA);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointB, (Point3DReadOnly)pointB, (Point3DReadOnly)pointB);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointC, (Point3DReadOnly)pointC, (Point3DReadOnly)pointC);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointA, (Point3DReadOnly)pointB);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointA, (Point3DReadOnly)pointC);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointB, (Point3DReadOnly)pointB, (Point3DReadOnly)pointA);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointB, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointC, (Point3DReadOnly)pointC, (Point3DReadOnly)pointA);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointC, (Point3DReadOnly)pointC, (Point3DReadOnly)pointB);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointB);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointC, (Point3DReadOnly)pointC);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointB, (Point3DReadOnly)pointA, (Point3DReadOnly)pointA);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointB, (Point3DReadOnly)pointC, (Point3DReadOnly)pointC);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointC, (Point3DReadOnly)pointA, (Point3DReadOnly)pointA);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
            expected = new Triangle3D((Point3DReadOnly)pointC, (Point3DReadOnly)pointB, (Point3DReadOnly)pointB);
            Assertions.assertFalse((boolean)original.geometricallyEquals(expected, this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            pointA = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointB = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointC = EuclidCoreRandomTools.nextPoint3D((Random)random);
            original = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
            Point3D pointAChanged = new Point3D((Tuple3DReadOnly)pointA);
            Point3D pointBChanged = new Point3D((Tuple3DReadOnly)pointB);
            Point3D pointCChanged = new Point3D((Tuple3DReadOnly)pointC);
            pointAChanged.setElement(i % 3, pointAChanged.getElement(i % 3) - 1.01 * this.getEpsilon());
            Triangle3D changedA = new Triangle3D((Point3DReadOnly)pointAChanged, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
            Assertions.assertFalse((boolean)changedA.geometricallyEquals(original, this.getEpsilon()));
            pointAChanged.set(pointA);
            pointAChanged.setElement(i % 3, pointAChanged.getElement(i % 3) - 0.99 * this.getEpsilon());
            changedA = new Triangle3D((Point3DReadOnly)pointAChanged, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
            Assertions.assertTrue((boolean)changedA.geometricallyEquals(original, this.getEpsilon()));
            pointBChanged.setElement(i % 3, pointBChanged.getElement(i % 3) - 1.01 * this.getEpsilon());
            Triangle3D changedB = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointBChanged, (Point3DReadOnly)pointC);
            Assertions.assertFalse((boolean)changedB.geometricallyEquals(original, this.getEpsilon()));
            pointBChanged.set(pointB);
            pointBChanged.setElement(i % 3, pointBChanged.getElement(i % 3) - 0.99 * this.getEpsilon());
            changedB = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointBChanged, (Point3DReadOnly)pointC);
            Assertions.assertTrue((boolean)changedB.geometricallyEquals(original, this.getEpsilon()));
            pointCChanged.setElement(i % 3, pointCChanged.getElement(i % 3) - 1.01 * this.getEpsilon());
            Triangle3D changedC = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointCChanged);
            Assertions.assertFalse((boolean)changedC.geometricallyEquals(original, this.getEpsilon()));
            pointCChanged.set(pointC);
            pointCChanged.setElement(i % 3, pointCChanged.getElement(i % 3) - 0.99 * this.getEpsilon());
            changedC = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointCChanged);
            Assertions.assertTrue((boolean)changedC.geometricallyEquals(original, this.getEpsilon()));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(62691L);
        for (int i = 0; i < 1000; ++i) {
            Point3D pointA = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D pointB = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D pointC = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D pointAChanged = new Point3D((Tuple3DReadOnly)pointA);
            Point3D pointBChanged = new Point3D((Tuple3DReadOnly)pointB);
            Point3D pointCChanged = new Point3D((Tuple3DReadOnly)pointC);
            int hashOfPointAPointBPointC = EuclidHashCodeTools.toIntHashCode((Object)pointA, (Object)pointB, (Object)pointC);
            Triangle3D original = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
            int hashOfTriangle = original.hashCode();
            Assertions.assertEquals((int)hashOfPointAPointBPointC, (int)hashOfTriangle);
            pointAChanged.setElement(i % 3, random.nextDouble());
            Triangle3D changed = new Triangle3D((Point3DReadOnly)pointAChanged, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
            hashOfTriangle = changed.hashCode();
            Assertions.assertFalse((hashOfPointAPointBPointC == hashOfTriangle ? 1 : 0) != 0);
            pointBChanged.setElement(i % 3, random.nextDouble());
            changed = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointBChanged, (Point3DReadOnly)pointC);
            hashOfTriangle = changed.hashCode();
            Assertions.assertFalse((hashOfPointAPointBPointC == hashOfTriangle ? 1 : 0) != 0);
            pointCChanged.setElement(i % 3, random.nextDouble());
            changed = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointCChanged);
            hashOfTriangle = changed.hashCode();
            Assertions.assertFalse((hashOfPointAPointBPointC == hashOfTriangle ? 1 : 0) != 0);
        }
    }

    @Test
    public void testToString() throws Exception {
        Random random = new Random(62691L);
        for (int i = 0; i < 1000; ++i) {
            Point3D pointA = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D pointB = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Point3D pointC = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Triangle3D triangle = new Triangle3D((Point3DReadOnly)pointA, (Point3DReadOnly)pointB, (Point3DReadOnly)pointC);
            Assertions.assertEquals((Object)triangle.toString(), (Object)EuclidGeometryIOTools.getTriangle3DString((Triangle3DReadOnly)triangle));
        }
    }
}

