/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DBasics;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Line2DTest {
    private static final double maxRandomValue = 100000.0;

    private double randomDouble(Random random, double maxRandomValue) {
        return random.nextDouble() * maxRandomValue * 2.0 - maxRandomValue;
    }

    private double randomDouble(Random random) {
        return this.randomDouble(random, 100000.0);
    }

    private Point2D randomPoint(Random random) {
        return new Point2D(this.randomDouble(random, 100000.0), this.randomDouble(random, 100000.0));
    }

    @Test
    public void testConstructors() {
        double delta = 1.0E-5;
        Random random = new Random(1000L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Vector2D vector = new Vector2D(secondPointOnLine.getX() - firstPointOnLine.getX(), secondPointOnLine.getY() - firstPointOnLine.getY());
            Line2D line2dByPointVector = new Line2D((Point2DReadOnly)firstPointOnLine, (Vector2DReadOnly)vector);
            Line2D line2dByPointPoint = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Assertions.assertEquals((Object)line2dByPointPoint.getPoint(), (Object)line2dByPointVector.getPoint());
            Assertions.assertEquals((double)line2dByPointPoint.getDirection().getX(), (double)line2dByPointVector.getDirection().getX(), (double)delta);
            Assertions.assertEquals((double)line2dByPointPoint.getDirection().getY(), (double)line2dByPointVector.getDirection().getY(), (double)delta);
            Line2D line2dByCopy = new Line2D((Line2DReadOnly)line2dByPointVector);
            Assertions.assertFalse((line2dByPointVector == line2dByCopy ? 1 : 0) != 0);
            Assertions.assertEquals((Object)line2dByPointVector.getPoint(), (Object)line2dByCopy.getPoint());
            Assertions.assertEquals((double)line2dByPointVector.getDirection().getX(), (double)line2dByCopy.getDirection().getX(), (double)delta);
            Assertions.assertEquals((double)line2dByPointVector.getDirection().getY(), (double)line2dByCopy.getDirection().getY(), (double)delta);
        }
    }

    @Test
    public void testIsPointInFrontOfLine2d() {
        Line2D line2d = new Line2D();
        Point2D point1 = new Point2D();
        Point2D point2 = new Point2D();
        Point2D point3 = new Point2D();
        Vector2D frontDirection = new Vector2D();
        point1.set(0.0, 0.0);
        point2.set(1.0, 1.0);
        line2d.set((Point2DReadOnly)point1, (Point2DReadOnly)point2);
        frontDirection.set(0.0, 1.0);
        point3.set(0.0, 1.0);
        Assertions.assertEquals((Object)true, (Object)line2d.isPointInFrontOfLine((Vector2DReadOnly)frontDirection, (Point2DReadOnly)point3), (String)"not equal");
        point3.set(0.0, -1.0);
        Assertions.assertEquals((Object)false, (Object)line2d.isPointInFrontOfLine((Vector2DReadOnly)frontDirection, (Point2DReadOnly)point3), (String)"not equal");
        point1.set(0.0, 0.0);
        point2.set(-1.0, 1.0);
        line2d.set((Point2DReadOnly)point1, (Point2DReadOnly)point2);
        point3.set(0.0, 1.0);
        Assertions.assertEquals((Object)true, (Object)line2d.isPointInFrontOfLine((Vector2DReadOnly)frontDirection, (Point2DReadOnly)point3), (String)"not equal");
        point3.set(0.0, -1.0);
        Assertions.assertEquals((Object)false, (Object)line2d.isPointInFrontOfLine((Vector2DReadOnly)frontDirection, (Point2DReadOnly)point3), (String)"not equal");
        frontDirection.set(0.0, -1.0);
        point3.set(0.0, 1.0);
        Assertions.assertEquals((Object)false, (Object)line2d.isPointInFrontOfLine((Vector2DReadOnly)frontDirection, (Point2DReadOnly)point3), (String)"not equal");
        point3.set(0.0, -1.0);
        Assertions.assertEquals((Object)true, (Object)line2d.isPointInFrontOfLine((Vector2DReadOnly)frontDirection, (Point2DReadOnly)point3), (String)"not equal");
    }

    @Test
    public void testPointPointConstructorForException() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            Point2D firstPointOnLine = new Point2D(0.0, 0.0);
            new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)firstPointOnLine);
        });
    }

    @Test
    public void testGetPoint() {
        Point2D firstPointOnLine = new Point2D(0.0, 0.0);
        Point2D secondPointOnLine = new Point2D(1.0, 1.0);
        Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Assertions.assertEquals((Object)firstPointOnLine, (Object)line2d.getPoint());
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(32423L);
        Line2D line2D = EuclidGeometryRandomTools.nextLine2D((Random)random);
        line2D.setToZero();
        try {
            EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)line2D.getPoint());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Vector2D(1.0, 0.0), (Tuple2DReadOnly)line2D.getDirection(), (double)0.0);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(32423L);
        Line2D line2D = EuclidGeometryRandomTools.nextLine2D((Random)random);
        line2D.setToNaN();
        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)line2D.getPoint());
        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)line2D.getDirection());
    }

    @Test
    public void testContainsNaN() throws Exception {
        Line2D line2D = new Line2D();
        Assertions.assertFalse((boolean)line2D.containsNaN());
        line2D.set(0.0, 0.0, 0.0, 1.0);
        Assertions.assertFalse((boolean)line2D.containsNaN());
        line2D.set(Double.NaN, 0.0, 0.0, 1.0);
        Assertions.assertTrue((boolean)line2D.containsNaN());
        line2D.set(0.0, Double.NaN, 0.0, 1.0);
        Assertions.assertTrue((boolean)line2D.containsNaN());
        line2D.set(0.0, 0.0, Double.NaN, 1.0);
        Assertions.assertTrue((boolean)line2D.containsNaN());
        line2D.set(0.0, 0.0, 1.0, Double.NaN);
        Assertions.assertTrue((boolean)line2D.containsNaN());
    }

    @Test
    public void testGetNormalizedVector() {
        double delta = 1.0E-5;
        Random random = new Random(789L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            double xdiff = secondPointOnLine.getX() - firstPointOnLine.getX();
            double ydiff = secondPointOnLine.getY() - firstPointOnLine.getY();
            double length = EuclidCoreTools.norm((double)xdiff, (double)ydiff);
            Assertions.assertEquals((double)(xdiff / length), (double)line2d.getDirection().getX(), (double)delta);
            Assertions.assertEquals((double)(ydiff / length), (double)line2d.getDirection().getY(), (double)delta);
        }
    }

    @Test
    public void testGetNormalizedVectorCopy() {
        double delta = 1.0E-5;
        Point2D firstPointOnLine = new Point2D(0.0, 0.0);
        Point2D secondPointOnLine = new Point2D(1.0, 1.0);
        Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Vector2D normalizedVector = new Vector2D(EuclidCoreTools.squareRoot((double)2.0) / 2.0, EuclidCoreTools.squareRoot((double)2.0) / 2.0);
        Assertions.assertEquals((double)normalizedVector.getX(), (double)line2d.getDirection().getX(), (double)delta);
        Assertions.assertEquals((double)normalizedVector.getY(), (double)line2d.getDirection().getY(), (double)delta);
        Vector2D normalizedVector2 = new Vector2D((Tuple2DReadOnly)line2d.getDirection());
        Assertions.assertFalse((line2d.getDirection() == normalizedVector2 ? 1 : 0) != 0);
    }

    @Test
    public void testGetSlope() {
        Random random = new Random(2048L);
        double delta = 1.0E-5;
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            double slope = (secondPointOnLine.getY() - firstPointOnLine.getY()) / (secondPointOnLine.getX() - firstPointOnLine.getX());
            Assertions.assertEquals((double)slope, (double)line2d.slope(), (double)delta);
        }
        Point2D firstPointOnLine = new Point2D(0.0, 0.0);
        Point2D secondPointOnLine = new Point2D(0.0, 5.0);
        Line2D verticalLine = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)verticalLine.slope(), (double)delta);
        secondPointOnLine = new Point2D(0.0, -5.0);
        Line2D horizontalLine = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Assertions.assertEquals((double)Double.NEGATIVE_INFINITY, (double)horizontalLine.slope(), (double)delta);
    }

    @Test
    public void testGetXIntercept() {
        double delta = 1.0E-5;
        Random random = new Random(1886L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            double slope = (secondPointOnLine.getY() - firstPointOnLine.getY()) / (secondPointOnLine.getX() - firstPointOnLine.getX());
            double additive = firstPointOnLine.getY() - slope * firstPointOnLine.getX();
            Assertions.assertEquals((double)(-additive / slope), (double)line2d.xIntercept(), (double)delta);
        }
        Point2D firstPointOnLine = new Point2D(0.0, 0.0);
        Point2D secondPointOnLine = new Point2D(5.0, 0.0);
        Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Assertions.assertEquals((double)Double.NaN, (double)line2d.xIntercept(), (double)delta);
        firstPointOnLine = new Point2D(1.0, 1.0);
        secondPointOnLine = new Point2D(2.0, 1.0);
        line2d.set((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Assertions.assertEquals((double)Double.NEGATIVE_INFINITY, (double)line2d.xIntercept(), (double)delta);
        line2d.set((Point2DReadOnly)secondPointOnLine, (Point2DReadOnly)firstPointOnLine);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)line2d.xIntercept(), (double)delta);
    }

    @Test
    public void testGetYIntercept() {
        double delta = 1.0E-5;
        Random random = new Random(1972L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            double slope = (secondPointOnLine.getY() - firstPointOnLine.getY()) / (secondPointOnLine.getX() - firstPointOnLine.getX());
            double additive = firstPointOnLine.getY() - slope * firstPointOnLine.getX();
            Assertions.assertEquals((double)additive, (double)line2d.yIntercept(), (double)delta);
        }
        Point2D firstPointOnLine = new Point2D(0.0, 0.0);
        Point2D secondPointOnLine = new Point2D(0.0, 5.0);
        Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Assertions.assertEquals((double)Double.NaN, (double)line2d.yIntercept(), (double)delta);
        firstPointOnLine = new Point2D(1.0, 1.0);
        secondPointOnLine = new Point2D(1.0, 2.0);
        line2d.set((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Assertions.assertEquals((double)Double.NEGATIVE_INFINITY, (double)line2d.yIntercept(), (double)delta);
        line2d.set((Point2DReadOnly)secondPointOnLine, (Point2DReadOnly)firstPointOnLine);
        Assertions.assertEquals((double)Double.POSITIVE_INFINITY, (double)line2d.yIntercept(), (double)delta);
    }

    @Test
    public void testNegateDirection() {
        double delta = 1.0E-5;
        Random random = new Random(2036L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Vector2D normalizedVectorCopy = new Vector2D((Tuple2DReadOnly)line2d.getDirection());
            line2d.negateDirection();
            Assertions.assertEquals((double)(-normalizedVectorCopy.getX()), (double)line2d.getDirection().getX(), (double)delta);
            Assertions.assertEquals((double)(-normalizedVectorCopy.getY()), (double)line2d.getDirection().getY(), (double)delta);
        }
    }

    @Test
    public void testSetPointPoint() {
        double delta = 1.0E-5;
        Random random = new Random(9999L);
        Point2D firstPointOnLine = new Point2D(0.0, 0.0);
        Point2D secondPointOnLine = new Point2D(1.0, 1.0);
        Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        for (int i = 0; i < 1000; ++i) {
            firstPointOnLine = this.randomPoint(random);
            secondPointOnLine = this.randomPoint(random);
            line2d.set((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Assertions.assertFalse((firstPointOnLine == line2d.getPoint() ? 1 : 0) != 0);
            Assertions.assertEquals((Object)firstPointOnLine, (Object)line2d.getPoint());
            double xdiff = secondPointOnLine.getX() - firstPointOnLine.getX();
            double ydiff = secondPointOnLine.getY() - firstPointOnLine.getY();
            double length = EuclidCoreTools.norm((double)xdiff, (double)ydiff);
            Assertions.assertEquals((double)(xdiff / length), (double)line2d.getDirection().getX(), (double)delta);
            Assertions.assertEquals((double)(ydiff / length), (double)line2d.getDirection().getY(), (double)delta);
        }
    }

    @Test
    public void testSetPointPointException() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            Point2D firstPointOnLine = new Point2D(0.0, 0.0);
            Point2D secondPointOnLine = new Point2D(1.0, 1.0);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            line2d.set((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)firstPointOnLine);
        });
    }

    @Test
    public void testSetLine() {
        double delta = 1.0E-5;
        Point2D firstPointOnLine = new Point2D(0.0, 0.0);
        Point2D secondPointOnLine = new Point2D(1.0, 1.0);
        Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Point2D newFirstPointOnLine = new Point2D(10.0, 15.0);
        Point2D newSecondPointOnLine = new Point2D(15.0, 8.0);
        Line2D secondLine2d = new Line2D((Point2DReadOnly)newFirstPointOnLine, (Point2DReadOnly)newSecondPointOnLine);
        line2d.set(secondLine2d);
        Assertions.assertFalse((secondLine2d == line2d ? 1 : 0) != 0);
        Assertions.assertEquals((double)secondLine2d.getPoint().getX(), (double)line2d.getPoint().getX(), (double)delta);
        Assertions.assertEquals((double)secondLine2d.getPoint().getY(), (double)line2d.getPoint().getY(), (double)delta);
        Assertions.assertFalse((secondLine2d.getPoint() == line2d.getPoint() ? 1 : 0) != 0);
        Assertions.assertEquals((double)secondLine2d.getDirection().getX(), (double)line2d.getDirection().getX(), (double)delta);
        Assertions.assertEquals((double)secondLine2d.getDirection().getY(), (double)line2d.getDirection().getY(), (double)delta);
        Assertions.assertFalse((secondLine2d.getDirection() == line2d.getDirection() ? 1 : 0) != 0);
    }

    @Test
    public void testSetPoint2d() {
        Point2D firstPointOnLine = new Point2D(0.0, 0.0);
        Point2D secondPointOnLine = new Point2D(1.0, 1.0);
        Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Point2D newPoint = new Point2D(11.0, 9.0);
        line2d.setPoint((Point2DReadOnly)newPoint);
        Assertions.assertEquals((Object)newPoint, (Object)line2d.getPoint());
        Assertions.assertFalse((newPoint == line2d.getPoint() ? 1 : 0) != 0);
    }

    @Test
    public void testRotate() {
        double delta = 1.0E-5;
        Random random = new Random(777L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = new Point2D(0.0, 0.0);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            double angle = EuclidCoreTools.atan2((double)line2d.getDirection().getY(), (double)line2d.getDirection().getX());
            double rotation = this.randomDouble(random, Math.PI * 2);
            double newAngle = angle + rotation;
            line2d.rotate(rotation);
            Assertions.assertEquals((double)EuclidCoreTools.cos((double)newAngle), (double)line2d.getDirection().getX(), (double)delta);
            Assertions.assertEquals((double)EuclidCoreTools.sin((double)newAngle), (double)line2d.getDirection().getY(), (double)delta);
        }
    }

    @Test
    public void testShiftToLeftAndRight() {
        double distanceToShift = 0.2;
        double epsilon = 1.0E-7;
        Line2D line = new Line2D(0.0, 0.0, 0.0, 1.0);
        Line2D shiftedLine = new Line2D((Line2DReadOnly)line);
        shiftedLine.shiftToRight(distanceToShift);
        Point2DBasics shiftedLineOrigin = shiftedLine.getPoint();
        UnitVector2DBasics lineVector = line.getDirection();
        UnitVector2DBasics shiftedLineVector = shiftedLine.getDirection();
        Assertions.assertEquals((double)distanceToShift, (double)shiftedLineOrigin.getX(), (double)epsilon);
        Assertions.assertEquals((double)0.0, (double)shiftedLineOrigin.getY(), (double)epsilon);
        Assertions.assertEquals((double)lineVector.getX(), (double)shiftedLineVector.getX(), (double)epsilon);
        Assertions.assertEquals((double)lineVector.getY(), (double)shiftedLineVector.getY(), (double)epsilon);
        shiftedLine.set(line);
        shiftedLine.shiftToLeft(distanceToShift);
        shiftedLineOrigin = shiftedLine.getPoint();
        lineVector = line.getDirection();
        shiftedLineVector = shiftedLine.getDirection();
        Assertions.assertEquals((double)(-distanceToShift), (double)shiftedLineOrigin.getX(), (double)epsilon);
        Assertions.assertEquals((double)0.0, (double)shiftedLineOrigin.getY(), (double)epsilon);
        Assertions.assertEquals((double)lineVector.getX(), (double)shiftedLineVector.getX(), (double)epsilon);
        Assertions.assertEquals((double)lineVector.getY(), (double)shiftedLineVector.getY(), (double)epsilon);
        line = new Line2D(0.0, 0.0, 1.0, 0.0);
        shiftedLine.set(line);
        shiftedLine.shiftToRight(distanceToShift);
        shiftedLineOrigin = shiftedLine.getPoint();
        lineVector = line.getDirection();
        shiftedLineVector = shiftedLine.getDirection();
        Assertions.assertEquals((double)0.0, (double)shiftedLineOrigin.getX(), (double)epsilon);
        Assertions.assertEquals((double)(-distanceToShift), (double)shiftedLineOrigin.getY(), (double)epsilon);
        Assertions.assertEquals((double)lineVector.getX(), (double)shiftedLineVector.getX(), (double)epsilon);
        Assertions.assertEquals((double)lineVector.getY(), (double)shiftedLineVector.getY(), (double)epsilon);
        shiftedLine.set(line);
        shiftedLine.shiftToLeft(distanceToShift);
        shiftedLineOrigin = shiftedLine.getPoint();
        lineVector = line.getDirection();
        shiftedLineVector = shiftedLine.getDirection();
        Assertions.assertEquals((double)0.0, (double)shiftedLineOrigin.getX(), (double)epsilon);
        Assertions.assertEquals((double)distanceToShift, (double)shiftedLineOrigin.getY(), (double)epsilon);
        Assertions.assertEquals((double)lineVector.getX(), (double)shiftedLineVector.getX(), (double)epsilon);
        Assertions.assertEquals((double)lineVector.getY(), (double)shiftedLineVector.getY(), (double)epsilon);
        line = new Line2D(0.0, 0.0, 1.0, 1.0);
        shiftedLine.set(line);
        shiftedLine.shiftToRight(distanceToShift);
        double distanceAtFortyFiveDegrees = distanceToShift * EuclidCoreTools.squareRoot((double)2.0) / 2.0;
        shiftedLineOrigin = shiftedLine.getPoint();
        lineVector = line.getDirection();
        shiftedLineVector = shiftedLine.getDirection();
        Assertions.assertEquals((double)distanceAtFortyFiveDegrees, (double)shiftedLineOrigin.getX(), (double)epsilon);
        Assertions.assertEquals((double)(-distanceAtFortyFiveDegrees), (double)shiftedLineOrigin.getY(), (double)epsilon);
        Assertions.assertEquals((double)lineVector.getX(), (double)shiftedLineVector.getX(), (double)epsilon);
        Assertions.assertEquals((double)lineVector.getY(), (double)shiftedLineVector.getY(), (double)epsilon);
        shiftedLine.set(line);
        shiftedLine.shiftToLeft(distanceToShift);
        shiftedLineOrigin = shiftedLine.getPoint();
        lineVector = line.getDirection();
        shiftedLineVector = shiftedLine.getDirection();
        Assertions.assertEquals((double)(-distanceAtFortyFiveDegrees), (double)shiftedLineOrigin.getX(), (double)epsilon);
        Assertions.assertEquals((double)distanceAtFortyFiveDegrees, (double)shiftedLineOrigin.getY(), (double)epsilon);
        Assertions.assertEquals((double)lineVector.getX(), (double)shiftedLineVector.getX(), (double)epsilon);
        Assertions.assertEquals((double)lineVector.getY(), (double)shiftedLineVector.getY(), (double)epsilon);
    }

    @Test
    public void testInteriorBisector() {
        Random random = new Random(1982L);
        double delta = 1.0E-5;
        Point2D firstPointOnLine = new Point2D(0.0, 0.0);
        Point2D secondPointOnLine = new Point2D(1.0, 0.0);
        Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Line2D secondLine2d = new Line2D((Line2DReadOnly)line2d);
        Line2DBasics interiorBisector = line2d.interiorBisector((Line2DReadOnly)secondLine2d);
        Assertions.assertEquals((Object)line2d.getPoint(), (Object)interiorBisector.getPoint());
        Assertions.assertEquals((double)line2d.getDirection().getX(), (double)interiorBisector.getDirection().getX(), (double)delta);
        Assertions.assertEquals((double)line2d.getDirection().getY(), (double)interiorBisector.getDirection().getY(), (double)delta);
        Line2D parallelLine2d = new Line2D((Line2DReadOnly)line2d);
        parallelLine2d.setPoint((Point2DReadOnly)new Point2D(5.5, 18.0));
        Assertions.assertNull((Object)line2d.interiorBisector((Line2DReadOnly)parallelLine2d));
        for (int i = 0; i < 1000; ++i) {
            line2d.set(this.randomDouble(random, 10.0), this.randomDouble(random, 10.0), this.randomDouble(random, 10.0), this.randomDouble(random, 10.0));
            secondLine2d.set(this.randomDouble(random, 10.0), this.randomDouble(random, 10.0), this.randomDouble(random, 10.0), this.randomDouble(random, 10.0));
            interiorBisector = line2d.interiorBisector((Line2DReadOnly)secondLine2d);
            double tangent1 = line2d.slope();
            double additive1 = line2d.getPoint().getY() - tangent1 * line2d.getPoint().getX();
            double tangent2 = secondLine2d.slope();
            double additive2 = secondLine2d.getPoint().getY() - tangent2 * secondLine2d.getPoint().getX();
            double intersectX = (additive2 - additive1) / (tangent1 - tangent2);
            double intersectY = tangent1 * intersectX + additive1;
            Assertions.assertEquals((double)intersectX, (double)interiorBisector.getPoint().getX(), (double)delta);
            Assertions.assertEquals((double)intersectY, (double)interiorBisector.getPoint().getY(), (double)delta);
            Vector2D interiorNormalizedVector = new Vector2D((Tuple2DReadOnly)line2d.getDirection());
            Vector2D vector = new Vector2D((Tuple2DReadOnly)secondLine2d.getDirection());
            interiorNormalizedVector.add((Tuple2DReadOnly)vector);
            double length = interiorNormalizedVector.length();
            Assertions.assertEquals((double)(interiorNormalizedVector.getX() / length), (double)interiorBisector.getDirection().getX(), (double)delta);
            Assertions.assertEquals((double)(interiorNormalizedVector.getY() / length), (double)interiorBisector.getDirection().getY(), (double)delta);
        }
    }

    @Test
    public void testPerpendicularVector() {
        double delta = 1.0E-5;
        Random random = new Random(1984L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Vector2DBasics perpendicular = line2d.perpendicularVector();
            Assertions.assertEquals((double)0.0, (double)(perpendicular.getX() * line2d.getDirection().getX() + perpendicular.getY() * line2d.getDirection().getY()), (double)delta);
        }
    }

    @Test
    public void testPerpendicularLineThroughPoint() {
        double delta = 1.0E-5;
        Random random = new Random(8888L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Point2D pointOnPerpendicularLine = this.randomPoint(random);
            Line2DBasics perpendicularLine = line2d.perpendicularLineThroughPoint((Point2DReadOnly)pointOnPerpendicularLine);
            Assertions.assertTrue((boolean)perpendicularLine.isPointOnLine((Point2DReadOnly)pointOnPerpendicularLine, delta));
            Assertions.assertEquals((double)0.0, (double)(perpendicularLine.getDirection().getX() * line2d.getDirection().getX() + perpendicularLine.getDirection().getY() * line2d.getDirection().getY()), (double)delta);
        }
    }

    @Test
    public void testOrthogonalProjection() {
        double delta = 1.0E-5;
        Random random = new Random(2000L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            UnitVector2DBasics normalizedVector = line2d.getDirection();
            Vector2DBasics perpendicular = line2d.perpendicularVector();
            Point2D pointOnLine = new Point2D((Tuple2DReadOnly)firstPointOnLine);
            double distance = this.randomDouble(random, 10.0);
            double perpendicularDistance = this.randomDouble(random, 10.0);
            pointOnLine.setX(pointOnLine.getX() + distance * normalizedVector.getX());
            pointOnLine.setY(pointOnLine.getY() + distance * normalizedVector.getY());
            Point2D pointOffLine = new Point2D((Tuple2DReadOnly)pointOnLine);
            pointOffLine.setX(pointOffLine.getX() + perpendicularDistance * perpendicular.getX());
            pointOffLine.setY(pointOffLine.getY() + perpendicularDistance * perpendicular.getY());
            line2d.orthogonalProjection((Point2DBasics)pointOffLine);
            Assertions.assertEquals((double)pointOnLine.getX(), (double)pointOffLine.getX(), (double)delta);
            Assertions.assertEquals((double)pointOnLine.getY(), (double)pointOffLine.getY(), (double)delta);
        }
    }

    @Test
    public void testOrthogonalProjectionCopy() {
        double delta = 1.0E-5;
        Random random = new Random(1111L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            UnitVector2DBasics normalizedVector = line2d.getDirection();
            Vector2DBasics perpendicular = line2d.perpendicularVector();
            Point2D pointOnLine = new Point2D((Tuple2DReadOnly)firstPointOnLine);
            double distance = this.randomDouble(random, 10.0);
            double perpendicularDistance = this.randomDouble(random, 10.0);
            pointOnLine.setX(pointOnLine.getX() + distance * normalizedVector.getX());
            pointOnLine.setY(pointOnLine.getY() + distance * normalizedVector.getY());
            Point2D pointOffLine = new Point2D((Tuple2DReadOnly)pointOnLine);
            pointOffLine.setX(pointOffLine.getX() + perpendicularDistance * perpendicular.getX());
            pointOffLine.setY(pointOffLine.getY() + perpendicularDistance * perpendicular.getY());
            Point2DBasics orthogonalCopy = line2d.orthogonalProjectionCopy((Point2DReadOnly)pointOffLine);
            Assertions.assertEquals((double)pointOnLine.getX(), (double)orthogonalCopy.getX(), (double)delta);
            Assertions.assertEquals((double)pointOnLine.getY(), (double)orthogonalCopy.getY(), (double)delta);
            Assertions.assertNotSame((Object)pointOnLine, (Object)orthogonalCopy);
            Assertions.assertNotSame((Object)pointOffLine, (Object)orthogonalCopy);
        }
    }

    @Test
    public void testIntersectionWithLineSegment2d() {
        Random random = new Random(3333L);
        double delta = 1.0E-5;
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPoint = this.randomPoint(random);
            Point2D secondPoint = this.randomPoint(random);
            LineSegment2D lineSegment2d = new LineSegment2D((Point2DReadOnly)firstPoint, (Point2DReadOnly)secondPoint);
            Line2D colinearLine2d = new Line2D((Point2DReadOnly)firstPoint, (Point2DReadOnly)secondPoint);
            Line2D parallelLine2d = new Line2D((Line2DReadOnly)colinearLine2d);
            double distance = this.randomDouble(random, 10.0);
            parallelLine2d.shiftToLeft(distance);
            Assertions.assertNull((Object)parallelLine2d.intersectionWith((LineSegment2DReadOnly)lineSegment2d));
            Vector2D direction = new Vector2D(this.randomDouble(random, 10.0), this.randomDouble(random, 10.0));
            Line2D lineThroughEndPoint = new Line2D((Point2DReadOnly)firstPoint, (Vector2DReadOnly)direction);
            Point2DBasics intersection = lineThroughEndPoint.intersectionWith((LineSegment2DReadOnly)lineSegment2d);
            Assertions.assertEquals((double)firstPoint.getX(), (double)intersection.getX(), (double)delta);
            Assertions.assertEquals((double)firstPoint.getY(), (double)intersection.getY(), (double)delta);
            lineThroughEndPoint.setPoint((Point2DReadOnly)secondPoint);
            intersection = lineThroughEndPoint.intersectionWith((LineSegment2DReadOnly)lineSegment2d);
            Point2D midPoint = new Point2D();
            midPoint.add((Tuple2DReadOnly)firstPoint, (Tuple2DReadOnly)secondPoint);
            midPoint.scale(0.5);
            Line2D intersectingLine = new Line2D((Point2DReadOnly)midPoint, (Vector2DReadOnly)direction);
            intersection = intersectingLine.intersectionWith((LineSegment2DReadOnly)lineSegment2d);
            Assertions.assertEquals((double)midPoint.getX(), (double)intersection.getX(), (double)delta);
            Assertions.assertEquals((double)midPoint.getY(), (double)intersection.getY(), (double)delta);
        }
    }

    @Test
    public void testIntersectionWithLine2d() {
        Point2DBasics actualIntersection;
        Point2D pointOnLine2;
        Vector2D lineDirection2;
        Point2D expectedIntersection;
        Line2D line1;
        Vector2D lineDirection1;
        Point2D pointOnLine1;
        int i;
        double epsilon = 1.0E-12;
        Random random = new Random(23423L);
        for (i = 0; i < 1000; ++i) {
            pointOnLine1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineDirection1 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            line1 = new Line2D((Point2DReadOnly)pointOnLine1, (Vector2DReadOnly)lineDirection1);
            expectedIntersection = new Point2D();
            expectedIntersection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection1, (Tuple2DReadOnly)pointOnLine1);
            lineDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            pointOnLine2 = new Point2D((Tuple2DReadOnly)expectedIntersection);
            actualIntersection = line1.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection, (double)epsilon);
            pointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLine2);
            actualIntersection = line1.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection, (double)epsilon);
        }
        for (i = 0; i < 1000; ++i) {
            pointOnLine1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineDirection1 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            line1 = new Line2D((Point2DReadOnly)pointOnLine1, (Vector2DReadOnly)lineDirection1);
            Vector2D lineDirection22 = new Vector2D((Tuple2DReadOnly)lineDirection1);
            if (random.nextBoolean()) {
                lineDirection22.negate();
            }
            Point2D pointOnLine22 = new Point2D((Tuple2DReadOnly)pointOnLine1);
            Vector2D orthogonal = new Vector2D(-lineDirection1.getY(), lineDirection1.getX());
            pointOnLine22.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)pointOnLine22);
            pointOnLine22.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection22, (Tuple2DReadOnly)pointOnLine22);
            actualIntersection = line1.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine22, (Vector2DReadOnly)lineDirection22));
            Assertions.assertNull((Object)actualIntersection);
        }
        for (i = 0; i < 1000; ++i) {
            pointOnLine1 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            lineDirection1 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            line1 = new Line2D((Point2DReadOnly)pointOnLine1, (Vector2DReadOnly)lineDirection1);
            expectedIntersection = new Point2D();
            expectedIntersection.set(pointOnLine1);
            lineDirection2 = new Vector2D((Tuple2DReadOnly)lineDirection1);
            pointOnLine2 = new Point2D((Tuple2DReadOnly)expectedIntersection);
            actualIntersection = line1.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection, (double)epsilon);
            pointOnLine2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection2, (Tuple2DReadOnly)pointOnLine2);
            actualIntersection = line1.intersectionWith((Line2DReadOnly)new Line2D((Point2DReadOnly)pointOnLine2, (Vector2DReadOnly)lineDirection2));
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection, (double)epsilon);
        }
    }

    @Test
    public void testDistancePoint2d() {
        Random random = new Random(743L);
        double delta = 0.001;
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Point2D distantPoint = this.randomPoint(random);
            double calculatedDistance = line2d.distance((Point2DReadOnly)distantPoint);
            Line2DBasics orthogonalLine = line2d.perpendicularLineThroughPoint((Point2DReadOnly)firstPointOnLine);
            Point2DBasics orthogonalProjection = orthogonalLine.orthogonalProjectionCopy((Point2DReadOnly)distantPoint);
            double xdiff = orthogonalProjection.getX() - firstPointOnLine.getX();
            double ydiff = orthogonalProjection.getY() - firstPointOnLine.getY();
            double distance = EuclidCoreTools.norm((double)xdiff, (double)ydiff);
            Assertions.assertEquals((double)distance, (double)calculatedDistance, (double)delta);
        }
    }

    @Test
    public void testDistanceLine2d() {
        Random random = new Random(23L);
        for (int i = 0; i < 1000; ++i) {
            Point2D pointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)10.0);
            Vector2D lineDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Line2D line = new Line2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
            Point2D randomPointOnLine = new Point2D();
            randomPointOnLine.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple2DReadOnly)lineDirection, (Tuple2DReadOnly)pointOnLine);
            Vector2D orthogonal = new Vector2D(-lineDirection.getY(), lineDirection.getX());
            orthogonal.normalize();
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            Point2D point = new Point2D();
            point.scaleAdd(expectedDistance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)randomPointOnLine);
            double actualDistance = line.distance((Point2DReadOnly)point);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-12);
        }
    }

    @Test
    public void areLinesPerpendicularTest() {
        Point2D point1 = new Point2D(1.0, 1.0);
        Point2D point2 = new Point2D(5.0, 5.0);
        Point2D point3 = new Point2D(2.2, 3.3);
        Point2D point4 = new Point2D(10.0, 10.0);
        Point2D point5 = new Point2D(-2.0, 4.0);
        Point2D point5UnProjected = new Point2D((Tuple2DReadOnly)point5);
        Line2D line1 = new Line2D((Point2DReadOnly)point1, (Point2DReadOnly)point2);
        Line2D line2 = new Line2D((Point2DReadOnly)point3, (Point2DReadOnly)point4);
        line1.orthogonalProjection((Point2DBasics)point5);
        Line2D line3 = new Line2D((Point2DReadOnly)point5, (Point2DReadOnly)point5UnProjected);
        Assertions.assertFalse((boolean)line1.areLinesPerpendicular((Line2DReadOnly)line2));
        Assertions.assertTrue((boolean)line1.areLinesPerpendicular((Line2DReadOnly)line3));
    }

    @Test
    public void testIsPointOnLeftSideOfLine() {
        Random random = new Random(8989L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Vector2D normalizedVector = new Vector2D((Tuple2DReadOnly)line2d.getDirection());
            Vector2DBasics perpendicularVector = line2d.perpendicularVector();
            perpendicularVector.negate();
            Point2D checkPoint = new Point2D();
            double longitude = this.randomDouble(random);
            double latitude = (this.randomDouble(random) + 100000.0) / 2.0 + 1.0;
            checkPoint.scaleAdd(longitude, (Tuple2DReadOnly)normalizedVector, (Tuple2DReadOnly)firstPointOnLine);
            checkPoint.scaleAdd(latitude, (Tuple2DReadOnly)perpendicularVector, (Tuple2DReadOnly)checkPoint);
            Assertions.assertFalse((boolean)line2d.isPointOnLeftSideOfLine((Point2DReadOnly)checkPoint));
            checkPoint.scaleAdd(-2.0 * latitude, (Tuple2DReadOnly)perpendicularVector, (Tuple2DReadOnly)checkPoint);
            Assertions.assertTrue((boolean)line2d.isPointOnLeftSideOfLine((Point2DReadOnly)checkPoint));
        }
    }

    @Test
    public void testIsPointOnRightSideOfLine() {
        Random random = new Random(9999L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Vector2D normalizedVector = new Vector2D((Tuple2DReadOnly)line2d.getDirection());
            Vector2DBasics perpendicularVector = line2d.perpendicularVector();
            perpendicularVector.negate();
            Point2D checkPoint = new Point2D();
            double longitude = this.randomDouble(random);
            double latitude = (this.randomDouble(random) + 100000.0) / 2.0 + 1.0;
            checkPoint.scaleAdd(longitude, (Tuple2DReadOnly)normalizedVector, (Tuple2DReadOnly)firstPointOnLine);
            checkPoint.scaleAdd(latitude, (Tuple2DReadOnly)perpendicularVector, (Tuple2DReadOnly)checkPoint);
            Assertions.assertTrue((boolean)line2d.isPointOnRightSideOfLine((Point2DReadOnly)checkPoint));
            checkPoint.scaleAdd(-2.0 * latitude, (Tuple2DReadOnly)perpendicularVector, (Tuple2DReadOnly)checkPoint);
            Assertions.assertFalse((boolean)line2d.isPointOnRightSideOfLine((Point2DReadOnly)checkPoint));
        }
    }

    @Test
    public void testSideConsistency() {
        Random random = new Random(1234L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Vector2D normalizedVector = new Vector2D((Tuple2DReadOnly)line2d.getDirection());
            Vector2DBasics perpendicularVector = line2d.perpendicularVector();
            Point2D checkPoint = new Point2D();
            double longitude = this.randomDouble(random);
            double latitude = this.randomDouble(random);
            checkPoint.scaleAdd(longitude, (Tuple2DReadOnly)normalizedVector, (Tuple2DReadOnly)firstPointOnLine);
            checkPoint.scaleAdd(latitude, (Tuple2DReadOnly)perpendicularVector, (Tuple2DReadOnly)checkPoint);
            Assertions.assertFalse((line2d.isPointOnRightSideOfLine((Point2DReadOnly)checkPoint) == line2d.isPointOnLeftSideOfLine((Point2DReadOnly)checkPoint) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIsPointInFrontOfLine() {
        Random random = new Random(7777L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Point2D checkPoint = new Point2D((Tuple2DReadOnly)secondPointOnLine);
            double shift = (this.randomDouble(random) + 100000.0) / 2.0 + 1.0;
            checkPoint.setX(checkPoint.getX() + shift);
            Assertions.assertTrue((boolean)line2d.isPointInFrontOfLine((Point2DReadOnly)checkPoint));
            checkPoint.setX(checkPoint.getX() - 2.0 * shift);
            Assertions.assertFalse((boolean)line2d.isPointInFrontOfLine((Point2DReadOnly)checkPoint));
        }
    }

    @Test
    public void testIsPointInFrontOfLineException() {
        Random random = new Random(1776L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Vector2D direction = new Vector2D(1.0, 0.0);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Vector2DReadOnly)direction);
            Point2D checkPoint = this.randomPoint(random);
            try {
                line2d.isPointInFrontOfLine((Point2DReadOnly)checkPoint);
                Assertions.fail((String)"Failed to throw exception.");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testIsPointBehindLine() {
        Random random = new Random(1776L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Point2D checkPoint = new Point2D((Tuple2DReadOnly)secondPointOnLine);
            double shift = (this.randomDouble(random) - 100000.0) / 2.0 - 1.0;
            checkPoint.setX(checkPoint.getX() + shift);
            Assertions.assertTrue((boolean)line2d.isPointBehindLine((Point2DReadOnly)checkPoint));
            checkPoint.setX(checkPoint.getX() - 2.0 * shift);
            Assertions.assertFalse((boolean)line2d.isPointBehindLine((Point2DReadOnly)checkPoint));
        }
    }

    @Test
    public void testIsPointBehindLineException() {
        Random random = new Random(1776L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Vector2D direction = new Vector2D(1.0, 0.0);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Vector2DReadOnly)direction);
            Point2D checkPoint = this.randomPoint(random);
            try {
                line2d.isPointBehindLine((Point2DReadOnly)checkPoint);
                Assertions.fail((String)"Failed to throw exception.");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testFrontBehindConsistency() {
        Random random = new Random(1776L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            Point2D checkPoint = new Point2D((Tuple2DReadOnly)secondPointOnLine);
            double shift = this.randomDouble(random);
            checkPoint.setX(checkPoint.getX() + shift);
            Assertions.assertFalse((line2d.isPointBehindLine((Point2DReadOnly)checkPoint) == line2d.isPointInFrontOfLine((Point2DReadOnly)checkPoint) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetParameterGivenPointEpsilon() {
        Random random = new Random(1776L);
        double epsilon = 1.0E-5;
        double delta = 1.0E-5;
        for (int i = 0; i < 1000; ++i) {
            Point2D firsPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firsPointOnLine, (Point2DReadOnly)secondPointOnLine);
            double parameter = this.randomDouble(random);
            Point2D checkPoint = new Point2D((Tuple2DReadOnly)firsPointOnLine);
            Vector2D normalizedVector = new Vector2D((Tuple2DReadOnly)line2d.getDirection());
            checkPoint.scaleAdd(parameter, (Tuple2DReadOnly)normalizedVector, (Tuple2DReadOnly)firsPointOnLine);
            double calculatedParameter = line2d.parameterGivenPointOnLine((Point2DReadOnly)checkPoint, epsilon);
            Assertions.assertEquals((double)parameter, (double)calculatedParameter, (double)delta);
        }
    }

    @Test
    public void testGetParameterGivenPointEpsilonException() {
        Random random = new Random(1776L);
        double epsilon = 1.0E-5;
        for (int i = 0; i < 1000; ++i) {
            Point2D firsPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firsPointOnLine, (Point2DReadOnly)secondPointOnLine);
            double parameter = this.randomDouble(random);
            double perpendicularDistance = this.randomDouble(random);
            perpendicularDistance += Math.signum(perpendicularDistance);
            Point2D checkPoint = new Point2D((Tuple2DReadOnly)firsPointOnLine);
            Vector2D normalizedVector = new Vector2D((Tuple2DReadOnly)line2d.getDirection());
            checkPoint.scaleAdd(parameter, (Tuple2DReadOnly)normalizedVector, (Tuple2DReadOnly)firsPointOnLine);
            checkPoint.scaleAdd(perpendicularDistance, (Tuple2DReadOnly)line2d.perpendicularVector(), (Tuple2DReadOnly)checkPoint);
            try {
                line2d.parameterGivenPointOnLine((Point2DReadOnly)checkPoint, epsilon);
                Assertions.fail((String)"Failed to throw an exception");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testIntersectionWithConvexPolygon() {
        Random random = new Random(1776L);
        for (int i = 0; i < 1000; ++i) {
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            ArrayList<Point2D> pointList = new ArrayList<Point2D>();
            for (int j = 0; j < 25; ++j) {
                pointList.add(this.randomPoint(random));
            }
            ConvexPolygon2D convexPolygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(pointList));
            Point2DBasics[] intersectionList = line2d.intersectionWith((ConvexPolygon2DReadOnly)convexPolygon);
            Assertions.assertTrue((intersectionList == null || intersectionList.length % 2 == 0 ? 1 : 0) != 0);
            Assertions.assertTrue((intersectionList == null || intersectionList.length <= 2 ? 1 : 0) != 0);
        }
        Point2D firstPointOnLine = new Point2D(0.0, 0.0);
        Point2D secondPointOnLine = new Point2D(1.0, 1.0);
        Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Point2D firstPolygonPoint = new Point2D(0.0, 0.0);
        Point2D secondPolygonPoint = new Point2D(0.0, 1.0);
        Point2D thirdPolygonPoint = new Point2D(-1.0, 0.0);
        ArrayList<Point2D> polygonPoints = new ArrayList<Point2D>();
        polygonPoints.add(firstPolygonPoint);
        polygonPoints.add(secondPolygonPoint);
        polygonPoints.add(thirdPolygonPoint);
        ConvexPolygon2D triangle = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(polygonPoints));
        Point2DBasics[] intersections = line2d.intersectionWith((ConvexPolygon2DReadOnly)triangle);
        Assertions.assertEquals((int)1, (int)intersections.length);
        line2d.setPoint((Point2DReadOnly)new Point2D(-0.5, 0.0));
        intersections = line2d.intersectionWith((ConvexPolygon2DReadOnly)triangle);
        Assertions.assertEquals((int)2, (int)intersections.length);
        line2d.setPoint((Point2DReadOnly)new Point2D(0.5, 0.0));
        intersections = line2d.intersectionWith((ConvexPolygon2DReadOnly)triangle);
        Assertions.assertNull((Object)intersections);
        line2d.set(0.0, 0.0, 0.0, 1.0);
        intersections = line2d.intersectionWith((ConvexPolygon2DReadOnly)triangle);
    }

    @Test
    public void testcontainsNaN() {
        Random random = new Random(1776L);
        Point2D firstPointOnLine = this.randomPoint(random);
        Point2D secondPointOnLine = this.randomPoint(random);
        Line2D line2d = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Assertions.assertFalse((boolean)line2d.containsNaN());
        line2d.set(0.0, 0.0, 0.0, 1.0);
        Assertions.assertFalse((boolean)line2d.containsNaN());
        line2d.set(Double.NaN, 0.0, 0.0, 1.0);
        Assertions.assertTrue((boolean)line2d.containsNaN());
        line2d.set(0.0, Double.NaN, 0.0, 1.0);
        Assertions.assertTrue((boolean)line2d.containsNaN());
        line2d.set(0.0, 0.0, Double.NaN, 1.0);
        Assertions.assertTrue((boolean)line2d.containsNaN());
        line2d.set(0.0, 0.0, 0.0, Double.NaN);
        Assertions.assertTrue((boolean)line2d.containsNaN());
    }

    @Test
    public void testApplyTransformTranslation() {
        Random random = new Random(1776L);
        double delta = 1.0E-5;
        RigidBodyTransform transform = new RigidBodyTransform();
        Vector3D translation = new Vector3D(random.nextDouble(), random.nextDouble(), 0.0);
        Vector3D eulerAngles = new Vector3D(0.0, 0.0, 0.0);
        transform.setRotationEulerAndZeroTranslation((Vector3DReadOnly)eulerAngles);
        transform.setTranslation((Tuple3DReadOnly)translation);
        Point2D firstPointOnLine = this.randomPoint(random);
        Point2D secondPointOnLine = this.randomPoint(random);
        Line2D line = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Point2D point = new Point2D((Tuple2DReadOnly)line.getPoint());
        Vector2D vector = new Vector2D((Tuple2DReadOnly)line.getDirection());
        line.applyTransform((Transform)transform);
        Assertions.assertEquals((double)(point.getX() + translation.getX()), (double)line.getPointX(), (double)delta, (String)"pure translation failed");
        Assertions.assertEquals((double)(point.getY() + translation.getY()), (double)line.getPointY(), (double)delta, (String)"pure translation failed");
        Assertions.assertEquals((double)vector.getX(), (double)line.getDirectionX(), (double)delta, (String)"pure translation failed");
        Assertions.assertEquals((double)vector.getY(), (double)line.getDirectionY(), (double)delta, (String)"pure translation failed");
    }

    @Test
    public void testApplyTransformRotation() {
        Random random = new Random(1776L);
        double delta = 1.0E-5;
        RigidBodyTransform transform = new RigidBodyTransform();
        Point2D firstPointOnLine = this.randomPoint(random);
        Point2D secondPointOnLine = this.randomPoint(random);
        Vector3D translation = new Vector3D(0.0, 0.0, 0.0);
        Vector3D eulerAngles = new Vector3D(0.0, 0.0, this.randomDouble(random, Math.PI * 2));
        transform.setRotationEulerAndZeroTranslation((Vector3DReadOnly)eulerAngles);
        transform.setTranslation((Tuple3DReadOnly)translation);
        Line2D line = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Point2D point = new Point2D((Tuple2DReadOnly)line.getPoint());
        Vector2D vector = new Vector2D((Tuple2DReadOnly)line.getDirection());
        line.applyTransform((Transform)transform);
        double alpha = eulerAngles.getZ();
        double sina = EuclidCoreTools.sin((double)alpha);
        double cosa = EuclidCoreTools.cos((double)alpha);
        Assertions.assertEquals((double)(point.getX() * cosa - point.getY() * sina), (double)line.getPointX(), (double)delta, (String)"pure rotation failed");
        Assertions.assertEquals((double)(point.getX() * sina + point.getY() * cosa), (double)line.getPointY(), (double)delta, (String)"pure rotation failed");
        Assertions.assertEquals((double)(vector.getX() * cosa - vector.getY() * sina), (double)line.getDirectionX(), (double)delta, (String)"pure rotation failed");
        Assertions.assertEquals((double)(vector.getX() * sina + vector.getY() * cosa), (double)line.getDirectionY(), (double)delta, (String)"pure rotation failed");
    }

    @Test
    public void testApplyTransformRotationXaxisException() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            Random random = new Random(1776L);
            RigidBodyTransform transform = new RigidBodyTransform();
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Vector3D translation = new Vector3D(0.0, 0.0, 0.0);
            Vector3D eulerAngles = new Vector3D(this.randomDouble(random, Math.PI * 2), 0.0, 0.0);
            transform.setRotationEulerAndZeroTranslation((Vector3DReadOnly)eulerAngles);
            transform.setTranslation((Tuple3DReadOnly)translation);
            Line2D line = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            line.applyTransform((Transform)transform);
        });
    }

    @Test
    public void testApplyTransformRotationYaxisException() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            Random random = new Random(1776L);
            RigidBodyTransform transform = new RigidBodyTransform();
            Point2D firstPointOnLine = this.randomPoint(random);
            Point2D secondPointOnLine = this.randomPoint(random);
            Vector3D translation = new Vector3D(0.0, 0.0, 0.0);
            Vector3D eulerAngles = new Vector3D(0.0, this.randomDouble(random, Math.PI * 2), 0.0);
            transform.setRotationEulerAndZeroTranslation((Vector3DReadOnly)eulerAngles);
            transform.setTranslation((Tuple3DReadOnly)translation);
            Line2D line = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
            line.applyTransform((Transform)transform);
        });
    }

    @Test
    public void testApplyTransformCombination() {
        Random random = new Random(1776L);
        double delta = 1.0E-5;
        RigidBodyTransform transform = new RigidBodyTransform();
        Point2D firstPointOnLine = this.randomPoint(random);
        Point2D secondPointOnLine = this.randomPoint(random);
        Vector3D translation = new Vector3D(this.randomDouble(random), this.randomDouble(random), 0.0);
        Vector3D eulerAngles = new Vector3D(0.0, 0.0, this.randomDouble(random, Math.PI * 2));
        transform.setRotationEulerAndZeroTranslation((Vector3DReadOnly)eulerAngles);
        transform.setTranslation((Tuple3DReadOnly)translation);
        Line2D line = new Line2D((Point2DReadOnly)firstPointOnLine, (Point2DReadOnly)secondPointOnLine);
        Point2D point = new Point2D((Tuple2DReadOnly)line.getPoint());
        Vector2D vector = new Vector2D((Tuple2DReadOnly)line.getDirection());
        line.applyTransform((Transform)transform);
        double alpha = eulerAngles.getZ();
        double sina = EuclidCoreTools.sin((double)alpha);
        double cosa = EuclidCoreTools.cos((double)alpha);
        Assertions.assertEquals((double)(point.getX() * cosa - point.getY() * sina + translation.getX()), (double)line.getPointX(), (double)delta, (String)"pure rotation failed");
        Assertions.assertEquals((double)(point.getX() * sina + point.getY() * cosa + translation.getY()), (double)line.getPointY(), (double)delta, (String)"pure rotation failed");
        Assertions.assertEquals((double)(vector.getX() * cosa - vector.getY() * sina), (double)line.getDirectionX(), (double)delta, (String)"pure rotation failed");
        Assertions.assertEquals((double)(vector.getX() * sina + vector.getY() * cosa), (double)line.getDirectionY(), (double)delta, (String)"pure rotation failed");
    }

    @Test
    public void testOrthogonalProjectionCopyPoint2dLine2d() {
        Point2D startPoint = new Point2D(-10.0, 0.0);
        Point2D endPoint = new Point2D(10.0, 0.0);
        Line2D line1 = new Line2D((Point2DReadOnly)startPoint, (Point2DReadOnly)endPoint);
        Point2D origionalPoint = new Point2D(-20.0, 10.0);
        Point2DBasics projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)new Point2D(-20.0, 0.0), (Object)projectedPoint);
        origionalPoint = new Point2D(-20.0, -10.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)new Point2D(-20.0, 0.0), (Object)projectedPoint);
        origionalPoint = new Point2D(-20.0, 0.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)new Point2D(-20.0, 0.0), (Object)projectedPoint);
        origionalPoint = new Point2D(20.0, 10.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)new Point2D(20.0, 0.0), (Object)projectedPoint);
        origionalPoint = new Point2D(20.0, -10.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)new Point2D(20.0, 0.0), (Object)projectedPoint);
        origionalPoint = new Point2D(20.0, 0.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)new Point2D(20.0, 0.0), (Object)projectedPoint);
        origionalPoint = new Point2D(0.0, 10.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)new Point2D(0.0, 0.0), (Object)projectedPoint);
        origionalPoint = new Point2D(0.0, -10.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)new Point2D(0.0, 0.0), (Object)projectedPoint);
        origionalPoint = new Point2D(5.0, 0.0);
        projectedPoint = line1.orthogonalProjectionCopy((Point2DReadOnly)origionalPoint);
        Assertions.assertEquals((Object)new Point2D(5.0, 0.0), (Object)projectedPoint);
    }

    @Test
    public void testIntersectionLine2dLine2d() {
        Line2D line1 = new Line2D((Point2DReadOnly)new Point2D(-10.0, 0.0), (Point2DReadOnly)new Point2D(10.0, 0.0));
        Line2D line2 = new Line2D((Point2DReadOnly)new Point2D(-10.0, 10.0), (Point2DReadOnly)new Point2D(10.0, 0.0));
        Line2D line3 = new Line2D((Point2DReadOnly)new Point2D(0.0, 10.0), (Point2DReadOnly)new Point2D(0.0, -10.0));
        Line2D line4 = new Line2D((Point2DReadOnly)new Point2D(0.0, -10.0), (Point2DReadOnly)new Point2D(0.0, 10.0));
        Line2D line5 = new Line2D((Point2DReadOnly)new Point2D(-10.0, 0.0), (Point2DReadOnly)new Point2D(10.0, 0.0));
        Line2D line6 = new Line2D((Point2DReadOnly)new Point2D(10.0, 0.0), (Point2DReadOnly)new Point2D(-10.0, 0.0));
        Line2D line7 = new Line2D((Point2DReadOnly)new Point2D(10.0, 0.0), (Point2DReadOnly)new Point2D(20.0, 0.0));
        Line2D line8 = new Line2D((Point2DReadOnly)new Point2D(10.0, 0.0), (Point2DReadOnly)new Point2D(-20.0, 0.0));
        Line2D line9 = new Line2D((Point2DReadOnly)new Point2D(10.1, 0.0), (Point2DReadOnly)new Point2D(20.0, 0.0));
        Line2D line10 = new Line2D((Point2DReadOnly)new Point2D(10.0, 0.0), (Point2DReadOnly)new Point2D(20.0, 1.0));
        Line2D line11 = new Line2D((Point2DReadOnly)new Point2D(-10.0, 1.0), (Point2DReadOnly)new Point2D(10.0, 1.0));
        Assertions.assertEquals(null, (Object)line1.intersectionWith((Line2DReadOnly)line11));
        Assertions.assertEquals((Object)new Point2D(-10.0, 0.0), (Object)line1.intersectionWith((Line2DReadOnly)line5));
        Assertions.assertEquals((Object)new Point2D(-10.0, 0.0), (Object)line1.intersectionWith((Line2DReadOnly)line6));
        Assertions.assertEquals((Object)new Point2D(10.0, 0.0), (Object)line1.intersectionWith((Line2DReadOnly)line2));
        Assertions.assertEquals((Object)new Point2D(10.0, 0.0), (Object)line1.intersectionWith((Line2DReadOnly)line10));
        Assertions.assertEquals((Object)new Point2D(0.0, 0.0), (Object)line1.intersectionWith((Line2DReadOnly)line3));
        Assertions.assertEquals((Object)new Point2D(0.0, 0.0), (Object)line1.intersectionWith((Line2DReadOnly)line4));
        Assertions.assertEquals((Object)new Point2D(-10.0, 0.0), (Object)line1.intersectionWith((Line2DReadOnly)line7));
        Assertions.assertEquals((Object)new Point2D(-10.0, 0.0), (Object)line1.intersectionWith((Line2DReadOnly)line8));
        Assertions.assertEquals((Object)new Point2D(-10.0, 0.0), (Object)line1.intersectionWith((Line2DReadOnly)line9));
    }

    @Test
    public void testDistancePointLineTwo() {
        Point2D pointOnLine = new Point2D(0.0, 1.0);
        Vector2D directionVector = new Vector2D(1.0, 0.0);
        Line2D line = new Line2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)directionVector);
        Point2D point = new Point2D(0.0, 2.0);
        double distance = line.distance((Point2DReadOnly)point);
        double delta = 1.0E-12;
        Assertions.assertEquals((double)1.0, (double)distance, (double)delta, (String)"Distance to a horizontal line not calculated correctly");
        pointOnLine = new Point2D(-1.0, 0.0);
        directionVector = new Vector2D(0.0, 1.0);
        line = new Line2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)directionVector);
        point = new Point2D(2.0, 3.0);
        distance = line.distance((Point2DReadOnly)point);
        delta = 1.0E-12;
        Assertions.assertEquals((double)3.0, (double)distance, (double)delta, (String)"Distance to a horizontal line not calculated correctly");
    }

    @Test
    public void testGeometricallyEquals() {
        int i;
        Random random = new Random(56021L);
        double epsilon = 1.0E-6;
        Vector2D direction = new Vector2D();
        Line2D firstLine = EuclidGeometryRandomTools.nextLine2D((Random)random);
        Line2D secondLine = new Line2D((Line2DReadOnly)firstLine);
        Assertions.assertTrue((boolean)firstLine.geometricallyEquals(secondLine, epsilon));
        Assertions.assertTrue((boolean)secondLine.geometricallyEquals(firstLine, epsilon));
        Assertions.assertTrue((boolean)firstLine.geometricallyEquals(firstLine, epsilon));
        Assertions.assertTrue((boolean)secondLine.geometricallyEquals(secondLine, epsilon));
        for (i = 0; i < 1000; ++i) {
            firstLine = EuclidGeometryRandomTools.nextLine2D((Random)random);
            secondLine = new Line2D((Line2DReadOnly)firstLine);
            Vector2DBasics orthogonal = firstLine.perpendicularVector();
            orthogonal.scale(0.99 * epsilon / orthogonal.length());
            secondLine.translate(orthogonal.getX(), orthogonal.getY());
            Assertions.assertTrue((boolean)firstLine.geometricallyEquals(secondLine, epsilon));
            secondLine.set(firstLine);
            orthogonal = firstLine.perpendicularVector();
            orthogonal.scale(1.01 * epsilon / orthogonal.length());
            secondLine.translate(orthogonal.getX(), orthogonal.getY());
            Assertions.assertFalse((boolean)firstLine.geometricallyEquals(secondLine, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            firstLine = EuclidGeometryRandomTools.nextLine2D((Random)random);
            secondLine = new Line2D((Line2DReadOnly)firstLine);
            direction = new Vector2D((Tuple2DReadOnly)secondLine.getDirection());
            RotationMatrixTools.applyYawRotation((double)(epsilon * 0.99), (Tuple2DReadOnly)direction, (Tuple2DBasics)direction);
            secondLine.setDirection((Vector2DReadOnly)direction);
            Assertions.assertTrue((boolean)firstLine.geometricallyEquals(secondLine, epsilon));
            direction = new Vector2D((Tuple2DReadOnly)secondLine.getDirection());
            RotationMatrixTools.applyYawRotation((double)(epsilon * 1.01), (Tuple2DReadOnly)direction, (Tuple2DBasics)direction);
            secondLine.setDirection((Vector2DReadOnly)direction);
            Assertions.assertFalse((boolean)firstLine.geometricallyEquals(secondLine, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            firstLine = EuclidGeometryRandomTools.nextLine2D((Random)random);
            secondLine = new Line2D((Line2DReadOnly)firstLine);
            double scale = random.nextDouble() - random.nextDouble();
            secondLine.translate(secondLine.getDirectionX() * scale, secondLine.getDirectionY() * scale);
            Assertions.assertTrue((boolean)firstLine.geometricallyEquals(secondLine, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            firstLine = EuclidGeometryRandomTools.nextLine2D((Random)random);
            direction.set((Tuple2DReadOnly)firstLine.getDirection());
            direction.negate();
            secondLine = new Line2D((Point2DReadOnly)firstLine.getPoint(), (Vector2DReadOnly)direction);
            Assertions.assertTrue((boolean)firstLine.geometricallyEquals(secondLine, epsilon));
        }
    }
}

