/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.exceptions.BoundingBoxException;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTestTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public class BoundingBox2DTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testConstructors() throws Exception {
        Random random = new Random(345345L);
        Point2D min = new Point2D();
        Point2D max = new Point2D();
        BoundingBox2D boundingBox = new BoundingBox2D();
        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)boundingBox.getMinPoint());
        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)boundingBox.getMaxPoint());
        min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple2DReadOnly)min);
        boundingBox = new BoundingBox2D((Point2DReadOnly)min, (Point2DReadOnly)max);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)min, (Tuple2DReadOnly)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)max, (Tuple2DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple2DReadOnly)min);
        boundingBox = new BoundingBox2D((BoundingBox2DReadOnly)new BoundingBox2D((Point2DReadOnly)min, (Point2DReadOnly)max));
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)min, (Tuple2DReadOnly)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)max, (Tuple2DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple2DReadOnly)min);
        double[] minArray = new double[3];
        double[] maxArray = new double[3];
        min.get(minArray);
        max.get(maxArray);
        boundingBox = new BoundingBox2D(minArray, maxArray);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)min, (Tuple2DReadOnly)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)max, (Tuple2DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple2DReadOnly)min);
        boundingBox = new BoundingBox2D(min.getX(), min.getY(), max.getX(), max.getY());
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)min, (Tuple2DReadOnly)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)max, (Tuple2DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-12);
        try {
            new BoundingBox2D(new double[]{1.0, 0.0}, new double[]{0.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            new BoundingBox2D(new double[]{0.0, 1.0}, new double[]{0.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            new BoundingBox2D((Point2DReadOnly)new Point2D(1.0, 0.0), (Point2DReadOnly)new Point2D(0.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            new BoundingBox2D((Point2DReadOnly)new Point2D(0.0, 1.0), (Point2DReadOnly)new Point2D(0.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            new BoundingBox2D(1.0, 0.0, 0.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            new BoundingBox2D(0.0, 1.0, 0.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        new BoundingBox2D(new double[]{1.0, 1.0}, new double[]{1.0, 1.0});
        new BoundingBox2D((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)new Point2D(1.0, 1.0));
        new BoundingBox2D(1.0, 1.0, 1.0, 1.0);
    }

    @Test
    public void testStaticConstructors() throws Exception {
        Random random = new Random(32443L);
        Point2D min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        Point2D max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple2DReadOnly)min);
        Point2D center = new Point2D();
        center.add((Tuple2DReadOnly)min, (Tuple2DReadOnly)max);
        center.scale(0.5);
        Vector2D halfSize = new Vector2D();
        halfSize.sub((Tuple2DReadOnly)max, (Tuple2DReadOnly)min);
        halfSize.scale(0.5);
        BoundingBox2D boundingBox = BoundingBox2D.createUsingCenterAndPlusMinusVector((Point2DReadOnly)center, (Tuple2DReadOnly)halfSize);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)min, (Tuple2DReadOnly)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)max, (Tuple2DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-12);
        for (int i = 0; i < 1000; ++i) {
            BoundingBox2D boundingBoxOne = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            BoundingBox2D boundingBoxTwo = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            BoundingBox2D expected = new BoundingBox2D();
            expected.combine((BoundingBox2DReadOnly)boundingBoxOne, (BoundingBox2DReadOnly)boundingBoxTwo);
            BoundingBox2D actual = BoundingBox2D.union((BoundingBox2DReadOnly)boundingBoxOne, (BoundingBox2DReadOnly)boundingBoxTwo);
            EuclidGeometryTestTools.assertBoundingBox2DEquals((BoundingBox2DReadOnly)expected, (BoundingBox2DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testSetMin() throws Exception {
        Random random = new Random(3242L);
        BoundingBox2D boundingBox = new BoundingBox2D();
        Point2D min = new Point2D();
        min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)0.0);
        boundingBox.setMin((Point2DReadOnly)min);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)min, (Tuple2DReadOnly)boundingBox.getMinPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)0.0);
        boundingBox.setMin(new double[]{min.getX(), min.getY()});
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)min, (Tuple2DReadOnly)boundingBox.getMinPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)-10.0, (double)0.0);
        boundingBox.setMin(min.getX(), min.getY());
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)min, (Tuple2DReadOnly)boundingBox.getMinPoint(), (double)1.0E-12);
        boundingBox.setToZero();
        try {
            boundingBox.setMin(new double[]{1.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMin(new double[]{0.0, 1.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMin((Point2DReadOnly)new Point2D(1.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMin((Point2DReadOnly)new Point2D(0.0, 1.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMin(1.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMin(0.0, 1.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        boundingBox.setMin(new double[]{0.0, 0.0});
        boundingBox.setMin((Point2DReadOnly)new Point2D(0.0, 0.0));
        boundingBox.setMin(0.0, 0.0);
    }

    @Test
    public void testSetMax() throws Exception {
        Random random = new Random(3242L);
        BoundingBox2D boundingBox = new BoundingBox2D();
        Point2D max = new Point2D();
        max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
        boundingBox.setMax((Point2DReadOnly)max);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)max, (Tuple2DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-12);
        max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
        boundingBox.setMax(new double[]{max.getX(), max.getY()});
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)max, (Tuple2DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-12);
        max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
        boundingBox.setMax(max.getX(), max.getY());
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)max, (Tuple2DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-12);
        boundingBox.setToZero();
        try {
            boundingBox.setMax(new double[]{-1.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMax(new double[]{0.0, -1.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMax((Point2DReadOnly)new Point2D(-1.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMax((Point2DReadOnly)new Point2D(0.0, -1.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMax(-1.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.setMax(0.0, -1.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        boundingBox.setMax(new double[]{0.0, 0.0});
        boundingBox.setMax((Point2DReadOnly)new Point2D(0.0, 0.0));
        boundingBox.setMax(0.0, 0.0);
    }

    @Test
    public void testSetters() throws Exception {
        Random random = new Random(34534L);
        BoundingBox2D boundingBox = new BoundingBox2D();
        Point2D min = new Point2D();
        Point2D max = new Point2D();
        min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple2DReadOnly)min);
        boundingBox.set(min.getX(), min.getY(), max.getX(), max.getY());
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)min, (Tuple2DReadOnly)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)max, (Tuple2DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple2DReadOnly)min);
        double[] minArray = new double[3];
        double[] maxArray = new double[3];
        min.get(minArray);
        max.get(maxArray);
        boundingBox.set(minArray, maxArray);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)min, (Tuple2DReadOnly)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)max, (Tuple2DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple2DReadOnly)min);
        boundingBox.set((Point2DReadOnly)min, (Point2DReadOnly)max);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)min, (Tuple2DReadOnly)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)max, (Tuple2DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple2DReadOnly)min);
        Point2D center = new Point2D();
        center.add((Tuple2DReadOnly)min, (Tuple2DReadOnly)max);
        center.scale(0.5);
        Vector2D halfSize = new Vector2D();
        halfSize.sub((Tuple2DReadOnly)max, (Tuple2DReadOnly)min);
        halfSize.scale(0.5);
        boundingBox.set((Point2DReadOnly)center, (Vector2DReadOnly)halfSize);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)min, (Tuple2DReadOnly)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)max, (Tuple2DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-12);
        min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)10.0);
        max.add((Tuple2DReadOnly)min);
        boundingBox.set(new BoundingBox2D((Point2DReadOnly)min, (Point2DReadOnly)max));
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)min, (Tuple2DReadOnly)boundingBox.getMinPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)max, (Tuple2DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-12);
        try {
            boundingBox.set(new double[]{1.0, 0.0}, new double[]{0.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set(new double[]{0.0, 1.0}, new double[]{0.0, 0.0});
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set((Point2DReadOnly)new Point2D(1.0, 0.0), (Point2DReadOnly)new Point2D(0.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set((Point2DReadOnly)new Point2D(0.0, 1.0), (Point2DReadOnly)new Point2D(0.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set((Point2DReadOnly)new Point2D(1.0, 0.0), (Vector2DReadOnly)new Vector2D(-1.0, 0.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set((Point2DReadOnly)new Point2D(1.0, 0.0), (Vector2DReadOnly)new Vector2D(0.0, -1.0));
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set(1.0, 0.0, 0.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        try {
            boundingBox.set(0.0, 1.0, 0.0, 0.0);
            Assertions.fail((String)("Should have thrown a " + BoundingBoxException.class.getSimpleName()));
        }
        catch (BoundingBoxException boundingBoxException) {
            // empty catch block
        }
        boundingBox.set(new double[]{1.0, 1.0}, new double[]{1.0, 1.0});
        boundingBox.set((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)new Point2D(1.0, 1.0));
        boundingBox.set(1.0, 1.0, 1.0, 1.0);
    }

    @Test
    public void testCombine() throws Exception {
        int axisIndex;
        Point2DReadOnly[] originalMaxCoordinates;
        boolean isMinCoordinateFromOriginal;
        Point2DReadOnly[] originalMinCoordinates;
        BoundingBox2D combined;
        BoundingBox2D boundingBoxTwo;
        BoundingBox2D boundingBoxOne;
        int i;
        Random random = new Random(234234L);
        for (i = 0; i < 1000; ++i) {
            int n;
            boundingBoxOne = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            boundingBoxTwo = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            combined = new BoundingBox2D();
            combined.combine((BoundingBox2DReadOnly)boundingBoxOne, (BoundingBox2DReadOnly)boundingBoxTwo);
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point2DReadOnly)boundingBoxOne.getMinPoint()));
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point2DReadOnly)boundingBoxOne.getMaxPoint()));
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point2DReadOnly)boundingBoxTwo.getMinPoint()));
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point2DReadOnly)boundingBoxTwo.getMaxPoint()));
            originalMinCoordinates = new Point2DReadOnly[]{boundingBoxOne.getMinPoint(), boundingBoxTwo.getMinPoint()};
            for (int axisIndex2 = 0; axisIndex2 < 2; ++axisIndex2) {
                isMinCoordinateFromOriginal = false;
                Point2DReadOnly[] point2DReadOnlyArray = originalMinCoordinates;
                int n2 = point2DReadOnlyArray.length;
                for (n = 0; n < n2; ++n) {
                    Point2DReadOnly originalCoordinate = point2DReadOnlyArray[n];
                    if (combined.getMinPoint().getElement(axisIndex2) != originalCoordinate.getElement(axisIndex2)) continue;
                    isMinCoordinateFromOriginal = true;
                    break;
                }
                Assertions.assertTrue((boolean)isMinCoordinateFromOriginal, (String)("Unexpected min coordinate for the combined bounding box, axis index = " + axisIndex2));
            }
            originalMaxCoordinates = new Point2DReadOnly[]{boundingBoxOne.getMaxPoint(), boundingBoxTwo.getMaxPoint()};
            for (axisIndex = 0; axisIndex < 2; ++axisIndex) {
                boolean isMaxCoordinateFromOriginal = false;
                Point2DReadOnly[] point2DReadOnlyArray = originalMaxCoordinates;
                n = point2DReadOnlyArray.length;
                for (int originalCoordinate = 0; originalCoordinate < n; ++originalCoordinate) {
                    Point2DReadOnly originalCoordinate2 = point2DReadOnlyArray[originalCoordinate];
                    if (combined.getMaxPoint().getElement(axisIndex) != originalCoordinate2.getElement(axisIndex)) continue;
                    isMaxCoordinateFromOriginal = true;
                    break;
                }
                Assertions.assertTrue((boolean)isMaxCoordinateFromOriginal, (String)("Unexpected max coordinate for the combined bounding box, axis index = " + axisIndex));
            }
        }
        for (i = 0; i < 1000; ++i) {
            boundingBoxOne = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            boundingBoxTwo = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            combined = new BoundingBox2D();
            combined.set(boundingBoxOne);
            combined.combine((BoundingBox2DReadOnly)boundingBoxTwo);
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point2DReadOnly)boundingBoxOne.getMinPoint()));
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point2DReadOnly)boundingBoxOne.getMaxPoint()));
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point2DReadOnly)boundingBoxTwo.getMinPoint()));
            Assertions.assertTrue((boolean)combined.isInsideInclusive((Point2DReadOnly)boundingBoxTwo.getMaxPoint()));
            originalMinCoordinates = new Point2DReadOnly[]{boundingBoxOne.getMinPoint(), boundingBoxTwo.getMinPoint()};
            for (int axisIndex3 = 0; axisIndex3 < 2; ++axisIndex3) {
                isMinCoordinateFromOriginal = false;
                for (Point2DReadOnly originalCoordinate : originalMinCoordinates) {
                    if (combined.getMinPoint().getElement(axisIndex3) != originalCoordinate.getElement(axisIndex3)) continue;
                    isMinCoordinateFromOriginal = true;
                    break;
                }
                Assertions.assertTrue((boolean)isMinCoordinateFromOriginal, (String)("Unexpected min coordinate for the combined bounding box, axis index = " + axisIndex3));
            }
            originalMaxCoordinates = new Point2DReadOnly[]{boundingBoxOne.getMaxPoint(), boundingBoxTwo.getMaxPoint()};
            for (axisIndex = 0; axisIndex < 2; ++axisIndex) {
                boolean isMaxCoordinateFromOriginal = false;
                for (Point2DReadOnly originalCoordinate2 : originalMaxCoordinates) {
                    if (combined.getMaxPoint().getElement(axisIndex) != originalCoordinate2.getElement(axisIndex)) continue;
                    isMaxCoordinateFromOriginal = true;
                    break;
                }
                Assertions.assertTrue((boolean)isMaxCoordinateFromOriginal, (String)("Unexpected max coordinate for the combined bounding box, axis index = " + axisIndex));
            }
        }
        for (i = 0; i < 1000; ++i) {
            boundingBoxOne = new BoundingBox2D();
            boundingBoxOne.setToNaN();
            boundingBoxTwo = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            combined = new BoundingBox2D();
            combined.set(boundingBoxOne);
            combined.combine((BoundingBox2DReadOnly)boundingBoxTwo);
            EuclidGeometryTestTools.assertBoundingBox2DEquals((BoundingBox2DReadOnly)boundingBoxTwo, (BoundingBox2DReadOnly)combined, (double)1.0E-12);
            boundingBoxOne = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            boundingBoxTwo.setToNaN();
            combined = new BoundingBox2D();
            combined.set(boundingBoxOne);
            combined.combine((BoundingBox2DReadOnly)boundingBoxTwo);
            EuclidGeometryTestTools.assertBoundingBox2DEquals((BoundingBox2DReadOnly)boundingBoxOne, (BoundingBox2DReadOnly)combined, (double)1.0E-12);
        }
    }

    @Test
    public void testSetToNaN() throws Exception {
        Random random = new Random(453453L);
        BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
        boundingBox2D.setToNaN();
        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)boundingBox2D.getMinPoint());
        EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)boundingBox2D.getMaxPoint());
    }

    @Test
    public void testSetToZero() throws Exception {
        Random random = new Random(453453L);
        BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
        boundingBox2D.setToZero();
        EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)boundingBox2D.getMinPoint());
        EuclidCoreTestTools.assertTuple2DIsSetToZero((Tuple2DReadOnly)boundingBox2D.getMaxPoint());
    }

    @Test
    public void testContainsNaN() throws Exception {
        Random random = new Random(23434L);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertFalse((boolean)EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0).containsNaN());
        }
        Assertions.assertTrue((boolean)new BoundingBox2D(Double.NaN, 0.0, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)new BoundingBox2D(0.0, Double.NaN, 0.0, 0.0).containsNaN());
        Assertions.assertTrue((boolean)new BoundingBox2D(0.0, 0.0, Double.NaN, 0.0).containsNaN());
        Assertions.assertTrue((boolean)new BoundingBox2D(0.0, 0.0, 0.0, Double.NaN).containsNaN());
    }

    @Test
    public void testGetCenterPoint() throws Exception {
        Random random = new Random(24324L);
        for (int i = 0; i < 1000; ++i) {
            Point2D center = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D halfSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.0, (double)10.0);
            BoundingBox2D boundingBox2D = new BoundingBox2D();
            boundingBox2D.set((Point2DReadOnly)center, (Vector2DReadOnly)halfSize);
            Point2D actualCenter = new Point2D();
            boundingBox2D.getCenterPoint((Point2DBasics)actualCenter);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)center, (Tuple2DReadOnly)actualCenter, (double)1.0E-12);
            Vector2D centerToMin = new Vector2D();
            centerToMin.sub((Tuple2DReadOnly)boundingBox2D.getMinPoint(), (Tuple2DReadOnly)center);
            Vector2D centerToMax = new Vector2D();
            centerToMax.sub((Tuple2DReadOnly)boundingBox2D.getMaxPoint(), (Tuple2DReadOnly)center);
            centerToMax.negate();
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)centerToMax, (Tuple2DReadOnly)centerToMin, (double)1.0E-12);
        }
    }

    @Test
    public void testGetPointGivenParameters() throws Exception {
        int i;
        Random random = new Random(324432L);
        for (i = 0; i < 1000; ++i) {
            Point2D expectedPoint = new Point2D();
            Point2D actualPoint = new Point2D();
            BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            expectedPoint.interpolate((Tuple2DReadOnly)boundingBox2D.getMinPoint(), (Tuple2DReadOnly)boundingBox2D.getMaxPoint(), alpha);
            boundingBox2D.getPointGivenParameters(alpha, alpha, (Point2DBasics)actualPoint);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedPoint, (Tuple2DReadOnly)actualPoint, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D actualPoint = new Point2D();
            BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            Point2D alpha = new Point2D();
            for (int axisIndex = 0; axisIndex < 2; ++axisIndex) {
                alpha = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                alpha.setElement(axisIndex, 0.0);
                boundingBox2D.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)actualPoint);
                Assertions.assertEquals((double)boundingBox2D.getMinPoint().getElement(axisIndex), (double)actualPoint.getElement(axisIndex), (double)1.0E-12);
                alpha = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                alpha.setElement(axisIndex, 1.0);
                boundingBox2D.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)actualPoint);
                Assertions.assertEquals((double)boundingBox2D.getMaxPoint().getElement(axisIndex), (double)actualPoint.getElement(axisIndex), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testGetDiagonalLengthSquared() throws Exception {
        Random random = new Random(324234L);
        for (int i = 0; i < 1000; ++i) {
            Point2D center = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D halfSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.0, (double)10.0);
            BoundingBox2D boundingBox2D = new BoundingBox2D();
            boundingBox2D.set((Point2DReadOnly)center, (Vector2DReadOnly)halfSize);
            Assertions.assertEquals((double)(4.0 * halfSize.lengthSquared()), (double)boundingBox2D.getDiagonalLengthSquared(), (double)1.0E-12);
        }
    }

    @Test
    public void testIsInsideExclusive() throws Exception {
        Random random = new Random(3243L);
        for (int i = 0; i < 1000; ++i) {
            BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            Point2D minPoint = boundingBox2D.getMinPoint();
            Point2D maxPoint = boundingBox2D.getMaxPoint();
            Assertions.assertFalse((boolean)boundingBox2D.isInsideExclusive((Point2DReadOnly)minPoint));
            Assertions.assertFalse((boolean)boundingBox2D.isInsideExclusive((Point2DReadOnly)maxPoint));
            Assertions.assertFalse((boolean)boundingBox2D.isInsideExclusive(minPoint.getX(), minPoint.getY()));
            Assertions.assertFalse((boolean)boundingBox2D.isInsideExclusive(maxPoint.getX(), maxPoint.getY()));
            Point2D alpha = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)Double.MIN_VALUE, (double)0.999999999999999);
            Point2D query = new Point2D();
            boundingBox2D.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)query);
            Assertions.assertTrue((boolean)boundingBox2D.isInsideExclusive((Point2DReadOnly)query));
            Assertions.assertTrue((boolean)boundingBox2D.isInsideExclusive(query.getX(), query.getY()));
            for (int axisIndex = 0; axisIndex < 2; ++axisIndex) {
                alpha = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)Double.MIN_VALUE, (double)0.999999999999999);
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                boundingBox2D.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)query);
                Assertions.assertFalse((boolean)boundingBox2D.isInsideExclusive((Point2DReadOnly)query));
                Assertions.assertFalse((boolean)boundingBox2D.isInsideExclusive(query.getX(), query.getY()));
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                boundingBox2D.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)query);
                Assertions.assertFalse((boolean)boundingBox2D.isInsideExclusive((Point2DReadOnly)query));
                Assertions.assertFalse((boolean)boundingBox2D.isInsideExclusive(query.getX(), query.getY()));
                alpha = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)Double.MIN_VALUE, (double)0.999999999999999);
                boundingBox2D.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)query);
                query.setElement(axisIndex, minPoint.getElement(axisIndex));
                Assertions.assertFalse((boolean)boundingBox2D.isInsideExclusive((Point2DReadOnly)query));
                Assertions.assertFalse((boolean)boundingBox2D.isInsideExclusive(query.getX(), query.getY()));
                query.setElement(axisIndex, maxPoint.getElement(axisIndex));
                Assertions.assertFalse((boolean)boundingBox2D.isInsideExclusive((Point2DReadOnly)query));
                Assertions.assertFalse((boolean)boundingBox2D.isInsideExclusive(query.getX(), query.getY()));
            }
        }
    }

    @Test
    public void testIsInsideInclusive() throws Exception {
        Random random = new Random(3243L);
        for (int i = 0; i < 1000; ++i) {
            BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            Point2D minPoint = boundingBox2D.getMinPoint();
            Point2D maxPoint = boundingBox2D.getMaxPoint();
            Assertions.assertTrue((boolean)boundingBox2D.isInsideInclusive((Point2DReadOnly)minPoint));
            Assertions.assertTrue((boolean)boundingBox2D.isInsideInclusive((Point2DReadOnly)maxPoint));
            Assertions.assertTrue((boolean)boundingBox2D.isInsideInclusive(minPoint.getX(), minPoint.getY()));
            Assertions.assertTrue((boolean)boundingBox2D.isInsideInclusive(maxPoint.getX(), maxPoint.getY()));
            Point2D alpha = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)1.0);
            Point2D query = new Point2D();
            boundingBox2D.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)query);
            Assertions.assertTrue((boolean)boundingBox2D.isInsideInclusive((Point2DReadOnly)query));
            Assertions.assertTrue((boolean)boundingBox2D.isInsideInclusive(query.getX(), query.getY()));
            for (int axisIndex = 0; axisIndex < 2; ++axisIndex) {
                alpha = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)1.0);
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                boundingBox2D.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)query);
                Assertions.assertFalse((boolean)boundingBox2D.isInsideInclusive((Point2DReadOnly)query));
                Assertions.assertFalse((boolean)boundingBox2D.isInsideInclusive(query.getX(), query.getY()));
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                boundingBox2D.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)query);
                Assertions.assertFalse((boolean)boundingBox2D.isInsideInclusive((Point2DReadOnly)query));
                Assertions.assertFalse((boolean)boundingBox2D.isInsideInclusive(query.getX(), query.getY()));
                alpha = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)1.0);
                boundingBox2D.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)query);
                query.setElement(axisIndex, minPoint.getElement(axisIndex));
                Assertions.assertTrue((boolean)boundingBox2D.isInsideInclusive((Point2DReadOnly)query));
                Assertions.assertTrue((boolean)boundingBox2D.isInsideInclusive(query.getX(), query.getY()));
                query.setElement(axisIndex, maxPoint.getElement(axisIndex));
                Assertions.assertTrue((boolean)boundingBox2D.isInsideInclusive((Point2DReadOnly)query));
                Assertions.assertTrue((boolean)boundingBox2D.isInsideInclusive(query.getX(), query.getY()));
            }
        }
    }

    @Test
    public void testIsInsideEpsilon() throws Exception {
        Random random = new Random(3243L);
        for (int i = 0; i < 1000; ++i) {
            Point2D center = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D halfSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.0, (double)10.0);
            BoundingBox2D boundingBoxEpsilon = BoundingBox2D.createUsingCenterAndPlusMinusVector((Point2DReadOnly)center, (Tuple2DReadOnly)halfSize);
            double epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.min(halfSize.getX(), halfSize.getY())), (double)1.0);
            halfSize.add(epsilon, epsilon);
            BoundingBox2D boundingBoxExclusive = BoundingBox2D.createUsingCenterAndPlusMinusVector((Point2DReadOnly)center, (Tuple2DReadOnly)halfSize);
            Point2D minPoint = boundingBoxEpsilon.getMinPoint();
            Point2D maxPoint = boundingBoxEpsilon.getMaxPoint();
            Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)minPoint), (Object)boundingBoxEpsilon.isInsideEpsilon((Point2DReadOnly)minPoint, epsilon));
            Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)maxPoint), (Object)boundingBoxEpsilon.isInsideEpsilon((Point2DReadOnly)maxPoint, epsilon));
            Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)minPoint), (Object)boundingBoxEpsilon.isInsideEpsilon(minPoint.getX(), minPoint.getY(), epsilon));
            Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)maxPoint), (Object)boundingBoxEpsilon.isInsideEpsilon(maxPoint.getX(), maxPoint.getY(), epsilon));
            Point2D alpha = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)1.0);
            Point2D query = new Point2D();
            boundingBoxEpsilon.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)query);
            Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon((Point2DReadOnly)query, epsilon));
            Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon(query.getX(), query.getY(), epsilon));
            for (int axisIndex = 0; axisIndex < 2; ++axisIndex) {
                alpha = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)1.0);
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
                boundingBoxEpsilon.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)query);
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon((Point2DReadOnly)query, epsilon));
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon(query.getX(), query.getY(), epsilon));
                alpha.setElement(axisIndex, EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0));
                boundingBoxEpsilon.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)query);
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon((Point2DReadOnly)query, epsilon));
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon(query.getX(), query.getY(), epsilon));
                alpha = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.0, (double)1.0);
                boundingBoxEpsilon.getPointGivenParameters(alpha.getX(), alpha.getY(), (Point2DBasics)query);
                query.setElement(axisIndex, minPoint.getElement(axisIndex));
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon((Point2DReadOnly)query, epsilon));
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon(query.getX(), query.getY(), epsilon));
                query.setElement(axisIndex, maxPoint.getElement(axisIndex));
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon((Point2DReadOnly)query, epsilon));
                Assertions.assertEquals((Object)boundingBoxExclusive.isInsideExclusive((Point2DReadOnly)query), (Object)boundingBoxEpsilon.isInsideEpsilon(query.getX(), query.getY(), epsilon));
            }
            Assertions.assertFalse((boolean)boundingBoxEpsilon.isInsideEpsilon((Point2DReadOnly)boundingBoxEpsilon.getMaxPoint(), 0.0));
            Assertions.assertFalse((boolean)boundingBoxEpsilon.isInsideEpsilon((Point2DReadOnly)boundingBoxEpsilon.getMinPoint(), 0.0));
        }
    }

    @Test
    public void testIntersectsExclusive() throws Exception {
        Random random = new Random(34545L);
        for (int i = 0; i < 1000; ++i) {
            Point2D center = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D halfSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.0, (double)10.0);
            BoundingBox2D boundingBox2D = BoundingBox2D.createUsingCenterAndPlusMinusVector((Point2DReadOnly)center, (Tuple2DReadOnly)halfSize);
            Point2D queryCenter = new Point2D();
            Vector2D queryHalfSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.0, (double)10.0);
            BoundingBox2D query = new BoundingBox2D();
            double xParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double yParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            boundingBox2D.getPointGivenParameters(xParameter, yParameter, (Point2DBasics)queryCenter);
            query.set((Point2DReadOnly)queryCenter, (Vector2DReadOnly)queryHalfSize);
            Assertions.assertTrue((boolean)boundingBox2D.intersectsExclusive((BoundingBox2DReadOnly)query));
            for (double xSign = -1.0; xSign <= 1.0; xSign += 1.0) {
                for (double ySign = -1.0; ySign <= 1.0; ySign += 1.0) {
                    Vector2D shift = new Vector2D();
                    shift.add((Tuple2DReadOnly)queryHalfSize, (Tuple2DReadOnly)halfSize);
                    shift.scale(xSign, ySign);
                    queryCenter.scaleAdd(0.999, (Tuple2DReadOnly)shift, (Tuple2DReadOnly)center);
                    query.set((Point2DReadOnly)queryCenter, (Vector2DReadOnly)queryHalfSize);
                    Assertions.assertTrue((boolean)boundingBox2D.intersectsExclusive((BoundingBox2DReadOnly)query));
                    if (Math.abs(xSign) + Math.abs(ySign) == 0.0) continue;
                    queryCenter.scaleAdd(1.0001, (Tuple2DReadOnly)shift, (Tuple2DReadOnly)center);
                    query.set((Point2DReadOnly)queryCenter, (Vector2DReadOnly)queryHalfSize);
                    Assertions.assertFalse((boolean)boundingBox2D.intersectsExclusive((BoundingBox2DReadOnly)query));
                }
            }
            boundingBox2D.set(0.0, 0.0, 1.0, 1.0);
            query.set(-1.0, 0.0, 0.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox2D.intersectsExclusive((BoundingBox2DReadOnly)query));
            boundingBox2D.set(0.0, 0.0, 1.0, 1.0);
            query.set(0.0, -1.0, 1.0, 0.0);
            Assertions.assertFalse((boolean)boundingBox2D.intersectsExclusive((BoundingBox2DReadOnly)query));
            boundingBox2D.set(0.0, 0.0, 1.0, 1.0);
            query.set(1.0, 0.0, 2.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox2D.intersectsExclusive((BoundingBox2DReadOnly)query));
            boundingBox2D.set(0.0, 0.0, 1.0, 1.0);
            query.set(0.0, 1.0, 1.0, 2.0);
            Assertions.assertFalse((boolean)boundingBox2D.intersectsExclusive((BoundingBox2DReadOnly)query));
        }
    }

    @Test
    public void testIntersectsInclusive() throws Exception {
        Random random = new Random(34545L);
        for (int i = 0; i < 1000; ++i) {
            Point2D center = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D halfSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.0, (double)10.0);
            BoundingBox2D boundingBox2D = BoundingBox2D.createUsingCenterAndPlusMinusVector((Point2DReadOnly)center, (Tuple2DReadOnly)halfSize);
            Point2D queryCenter = new Point2D();
            Vector2D queryHalfSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.0, (double)10.0);
            BoundingBox2D query = new BoundingBox2D();
            double xParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double yParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            boundingBox2D.getPointGivenParameters(xParameter, yParameter, (Point2DBasics)queryCenter);
            query.set((Point2DReadOnly)queryCenter, (Vector2DReadOnly)queryHalfSize);
            Assertions.assertTrue((boolean)boundingBox2D.intersectsInclusive((BoundingBox2DReadOnly)query));
            for (double xSign = -1.0; xSign <= 1.0; xSign += 1.0) {
                for (double ySign = -1.0; ySign <= 1.0; ySign += 1.0) {
                    Vector2D shift = new Vector2D();
                    shift.add((Tuple2DReadOnly)queryHalfSize, (Tuple2DReadOnly)halfSize);
                    shift.scale(xSign, ySign);
                    queryCenter.scaleAdd(0.999, (Tuple2DReadOnly)shift, (Tuple2DReadOnly)center);
                    query.set((Point2DReadOnly)queryCenter, (Vector2DReadOnly)queryHalfSize);
                    Assertions.assertTrue((boolean)boundingBox2D.intersectsInclusive((BoundingBox2DReadOnly)query));
                    if (Math.abs(xSign) + Math.abs(ySign) == 0.0) continue;
                    queryCenter.scaleAdd(1.0001, (Tuple2DReadOnly)shift, (Tuple2DReadOnly)center);
                    query.set((Point2DReadOnly)queryCenter, (Vector2DReadOnly)queryHalfSize);
                    Assertions.assertFalse((boolean)boundingBox2D.intersectsInclusive((BoundingBox2DReadOnly)query));
                }
            }
            boundingBox2D.set(0.0, 0.0, 1.0, 1.0);
            query.set(-1.0, 0.0, 0.0, 1.0);
            Assertions.assertTrue((boolean)boundingBox2D.intersectsInclusive((BoundingBox2DReadOnly)query));
            boundingBox2D.set(0.0, 0.0, 1.0, 1.0);
            query.set(0.0, -1.0, 1.0, 0.0);
            Assertions.assertTrue((boolean)boundingBox2D.intersectsInclusive((BoundingBox2DReadOnly)query));
            boundingBox2D.set(0.0, 0.0, 1.0, 1.0);
            query.set(1.0, 0.0, 2.0, 1.0);
            Assertions.assertTrue((boolean)boundingBox2D.intersectsInclusive((BoundingBox2DReadOnly)query));
            boundingBox2D.set(0.0, 0.0, 1.0, 1.0);
            query.set(0.0, 1.0, 1.0, 2.0);
            Assertions.assertTrue((boolean)boundingBox2D.intersectsInclusive((BoundingBox2DReadOnly)query));
        }
    }

    @Test
    public void testIntersectsEpsilon() throws Exception {
        Random random = new Random(34545L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0);
            Point2D center = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D halfSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)(2.0 * Math.abs(epsilon)), (double)10.0);
            BoundingBox2D boundingBox2D = BoundingBox2D.createUsingCenterAndPlusMinusVector((Point2DReadOnly)center, (Tuple2DReadOnly)halfSize);
            Point2D queryCenter = new Point2D();
            Vector2D queryHalfSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)(2.0 * Math.abs(epsilon)), (double)10.0);
            BoundingBox2D query = new BoundingBox2D();
            double xParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            double yParameter = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            boundingBox2D.getPointGivenParameters(xParameter, yParameter, (Point2DBasics)queryCenter);
            query.set((Point2DReadOnly)queryCenter, (Vector2DReadOnly)queryHalfSize);
            Assertions.assertTrue((boolean)boundingBox2D.intersectsEpsilon((BoundingBox2DReadOnly)query, epsilon));
            for (double xSign = -1.0; xSign <= 1.0; xSign += 1.0) {
                for (double ySign = -1.0; ySign <= 1.0; ySign += 1.0) {
                    Vector2D shift = new Vector2D();
                    shift.add((Tuple2DReadOnly)queryHalfSize, (Tuple2DReadOnly)halfSize);
                    shift.add(epsilon, epsilon);
                    shift.scale(xSign, ySign);
                    queryCenter.scaleAdd(0.999, (Tuple2DReadOnly)shift, (Tuple2DReadOnly)center);
                    query.set((Point2DReadOnly)queryCenter, (Vector2DReadOnly)queryHalfSize);
                    Assertions.assertTrue((boolean)boundingBox2D.intersectsEpsilon((BoundingBox2DReadOnly)query, epsilon));
                    if (Math.abs(xSign) + Math.abs(ySign) == 0.0) continue;
                    queryCenter.scaleAdd(1.0001, (Tuple2DReadOnly)shift, (Tuple2DReadOnly)center);
                    query.set((Point2DReadOnly)queryCenter, (Vector2DReadOnly)queryHalfSize);
                    Assertions.assertFalse((boolean)boundingBox2D.intersectsEpsilon((BoundingBox2DReadOnly)query, epsilon));
                }
            }
            boundingBox2D.set(0.0, 0.0, 1.0, 1.0);
            query.set(-1.0, 0.0, 0.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox2D.intersectsEpsilon((BoundingBox2DReadOnly)query, 0.0));
            boundingBox2D.set(0.0, 0.0, 1.0, 1.0);
            query.set(0.0, -1.0, 1.0, 0.0);
            Assertions.assertFalse((boolean)boundingBox2D.intersectsEpsilon((BoundingBox2DReadOnly)query, 0.0));
            boundingBox2D.set(0.0, 0.0, 1.0, 1.0);
            query.set(1.0, 0.0, 2.0, 1.0);
            Assertions.assertFalse((boolean)boundingBox2D.intersectsEpsilon((BoundingBox2DReadOnly)query, 0.0));
            boundingBox2D.set(0.0, 0.0, 1.0, 1.0);
            query.set(0.0, 1.0, 1.0, 2.0);
            Assertions.assertFalse((boolean)boundingBox2D.intersectsEpsilon((BoundingBox2DReadOnly)query, 0.0));
        }
    }

    @Test
    public void testDoesIntersectWithLine2D() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            Point2D pointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D lineDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            boolean expected = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBox2D.getMinPoint(), (Point2DReadOnly)boundingBox2D.getMaxPoint(), (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, null, null) != 0;
            boolean actual = boundingBox2D.doesIntersectWithLine2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection);
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testDoesIntersectWithLineSegment2D() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            Point2D lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            boolean expected = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBox2D.getMinPoint(), (Point2DReadOnly)boundingBox2D.getMaxPoint(), (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, null, null) != 0;
            boolean actual = boundingBox2D.doesIntersectWithLineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testDoesIntersectWithRay2D() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            Point2D rayOrigin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            boolean expected = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBox2D.getMinPoint(), (Point2DReadOnly)boundingBox2D.getMaxPoint(), (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, null, null) != 0;
            boolean actual = boundingBox2D.doesIntersectWithRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection);
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testIntersectionWithLine2D() throws Exception {
        Random random = new Random(435345L);
        for (int i = 0; i < 1000; ++i) {
            Point2D pointOnLine = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D lineDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            Point2D expectedFirstIntersection = new Point2D();
            Point2D expectedSecondIntersection = new Point2D();
            Point2D actualFirstIntersection = new Point2D();
            Point2D actualSecondIntersection = new Point2D();
            int expectedN = EuclidGeometryTools.intersectionBetweenLine2DAndBoundingBox2D((Point2DReadOnly)boundingBox2D.getMinPoint(), (Point2DReadOnly)boundingBox2D.getMaxPoint(), (Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DBasics)expectedFirstIntersection, (Point2DBasics)expectedSecondIntersection);
            int actualN = boundingBox2D.intersectionWithLine2D((Point2DReadOnly)pointOnLine, (Vector2DReadOnly)lineDirection, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
            Assertions.assertEquals((int)expectedN, (int)actualN);
            if (expectedN == 0) {
                EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)expectedFirstIntersection);
                EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualFirstIntersection);
            } else {
                EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedFirstIntersection, (Tuple2DReadOnly)actualFirstIntersection, (double)1.0E-12);
            }
            if (expectedN <= 1) {
                EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)expectedSecondIntersection);
                EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualSecondIntersection);
                continue;
            }
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedSecondIntersection, (Tuple2DReadOnly)actualSecondIntersection, (double)1.0E-12);
        }
    }

    @Test
    public void testintersectionWithLineSegment2D() throws Exception {
        Random random = new Random(435345L);
        for (int i = 0; i < 1000; ++i) {
            Point2D lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            Point2D expectedFirstIntersection = new Point2D();
            Point2D expectedSecondIntersection = new Point2D();
            Point2D actualFirstIntersection = new Point2D();
            Point2D actualSecondIntersection = new Point2D();
            int expectedN = EuclidGeometryTools.intersectionBetweenLineSegment2DAndBoundingBox2D((Point2DReadOnly)boundingBox2D.getMinPoint(), (Point2DReadOnly)boundingBox2D.getMaxPoint(), (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)expectedFirstIntersection, (Point2DBasics)expectedSecondIntersection);
            int actualN = boundingBox2D.intersectionWithLineSegment2D((Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
            Assertions.assertEquals((int)expectedN, (int)actualN);
            if (expectedN == 0) {
                EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)expectedFirstIntersection);
                EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualFirstIntersection);
            } else {
                EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedFirstIntersection, (Tuple2DReadOnly)actualFirstIntersection, (double)1.0E-12);
            }
            if (expectedN <= 1) {
                EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)expectedSecondIntersection);
                EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualSecondIntersection);
                continue;
            }
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedSecondIntersection, (Tuple2DReadOnly)actualSecondIntersection, (double)1.0E-12);
        }
    }

    @Test
    public void testintersectionWithRay2D() throws Exception {
        Random random = new Random(435345L);
        for (int i = 0; i < 1000; ++i) {
            Point2D rayOrigin = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Vector2D rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            Point2D expectedFirstIntersection = new Point2D();
            Point2D expectedSecondIntersection = new Point2D();
            Point2D actualFirstIntersection = new Point2D();
            Point2D actualSecondIntersection = new Point2D();
            int expectedN = EuclidGeometryTools.intersectionBetweenRay2DAndBoundingBox2D((Point2DReadOnly)boundingBox2D.getMinPoint(), (Point2DReadOnly)boundingBox2D.getMaxPoint(), (Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DBasics)expectedFirstIntersection, (Point2DBasics)expectedSecondIntersection);
            int actualN = boundingBox2D.intersectionWithRay2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
            Assertions.assertEquals((int)expectedN, (int)actualN);
            if (expectedN == 0) {
                EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)expectedFirstIntersection);
                EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualFirstIntersection);
            } else {
                EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedFirstIntersection, (Tuple2DReadOnly)actualFirstIntersection, (double)1.0E-12);
            }
            if (expectedN <= 1) {
                EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)expectedSecondIntersection);
                EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualSecondIntersection);
                continue;
            }
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedSecondIntersection, (Tuple2DReadOnly)actualSecondIntersection, (double)1.0E-12);
        }
    }

    @Test
    public void testUpdateToIncludePoint() throws Exception {
        boolean hasGrownToPoint;
        boolean hasNotChanged;
        int axis;
        Point2D extendedMax;
        Point2D originalMax;
        boolean hasGrownToPoint2;
        Point2D extendedMin;
        Point2D originalMin;
        Point2D point;
        BoundingBox2D extended;
        BoundingBox2D original;
        int i;
        Random random = new Random(234234L);
        for (i = 0; i < 1000; ++i) {
            original = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            extended = new BoundingBox2D((BoundingBox2DReadOnly)original);
            point = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            extended.updateToIncludePoint((Point2DReadOnly)point);
            if (original.isInsideInclusive((Point2DReadOnly)point)) {
                Assertions.assertEquals((Object)original, (Object)extended);
                continue;
            }
            Assertions.assertTrue((boolean)extended.isInsideInclusive((Point2DReadOnly)point));
            originalMin = original.getMinPoint();
            extendedMin = extended.getMinPoint();
            for (int axis2 = 0; axis2 < 2; ++axis2) {
                boolean hasNotChanged2 = originalMin.getElement(axis2) == extendedMin.getElement(axis2);
                hasGrownToPoint2 = point.getElement(axis2) == extendedMin.getElement(axis2);
                Assertions.assertTrue((hasNotChanged2 || hasGrownToPoint2 ? 1 : 0) != 0);
            }
            originalMax = original.getMaxPoint();
            extendedMax = extended.getMaxPoint();
            for (axis = 0; axis < 2; ++axis) {
                hasNotChanged = originalMax.getElement(axis) == extendedMax.getElement(axis);
                hasGrownToPoint = point.getElement(axis) == extendedMax.getElement(axis);
                Assertions.assertTrue((hasNotChanged || hasGrownToPoint ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < 1000; ++i) {
            original = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
            extended = new BoundingBox2D((BoundingBox2DReadOnly)original);
            point = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            extended.updateToIncludePoint(point.getX(), point.getY());
            if (original.isInsideInclusive((Point2DReadOnly)point)) {
                Assertions.assertEquals((Object)original, (Object)extended);
                continue;
            }
            Assertions.assertTrue((boolean)extended.isInsideInclusive((Point2DReadOnly)point));
            originalMin = original.getMinPoint();
            extendedMin = extended.getMinPoint();
            for (int axis3 = 0; axis3 < 2; ++axis3) {
                boolean hasNotChanged3 = originalMin.getElement(axis3) == extendedMin.getElement(axis3);
                hasGrownToPoint2 = point.getElement(axis3) == extendedMin.getElement(axis3);
                Assertions.assertTrue((hasNotChanged3 || hasGrownToPoint2 ? 1 : 0) != 0);
            }
            originalMax = original.getMaxPoint();
            extendedMax = extended.getMaxPoint();
            for (axis = 0; axis < 2; ++axis) {
                hasNotChanged = originalMax.getElement(axis) == extendedMax.getElement(axis);
                hasGrownToPoint = point.getElement(axis) == extendedMax.getElement(axis);
                Assertions.assertTrue((hasNotChanged || hasGrownToPoint ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testGetters() throws Exception {
        Random random = new Random(3242L);
        BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
        Point2D min = boundingBox2D.getMinPoint();
        Point2D max = boundingBox2D.getMaxPoint();
        Assertions.assertTrue((min.getX() == boundingBox2D.getMinX() ? 1 : 0) != 0);
        Assertions.assertTrue((min.getY() == boundingBox2D.getMinY() ? 1 : 0) != 0);
        Assertions.assertTrue((max.getX() == boundingBox2D.getMaxX() ? 1 : 0) != 0);
        Assertions.assertTrue((max.getY() == boundingBox2D.getMaxY() ? 1 : 0) != 0);
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(234234L);
        double epsilon = random.nextDouble();
        BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
        double minX = boundingBox2D.getMinX();
        double minY = boundingBox2D.getMinY();
        double maxX = boundingBox2D.getMaxX();
        double maxY = boundingBox2D.getMaxY();
        double small = 0.999 * epsilon;
        double big = 1.001 * epsilon;
        Assertions.assertTrue((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX + small, minY, maxX, maxY), epsilon));
        Assertions.assertTrue((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX, minY + small, maxX, maxY), epsilon));
        Assertions.assertTrue((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX, minY, maxX + small, maxY), epsilon));
        Assertions.assertTrue((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX, minY, maxX, maxY + small), epsilon));
        Assertions.assertTrue((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX - small, minY, maxX, maxY), epsilon));
        Assertions.assertTrue((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX, minY - small, maxX, maxY), epsilon));
        Assertions.assertTrue((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX, minY, maxX - small, maxY), epsilon));
        Assertions.assertTrue((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX, minY, maxX, maxY - small), epsilon));
        Assertions.assertFalse((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX + big, minY, maxX, maxY), epsilon));
        Assertions.assertFalse((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX, minY + big, maxX, maxY), epsilon));
        Assertions.assertFalse((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX, minY, maxX + big, maxY), epsilon));
        Assertions.assertFalse((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX, minY, maxX, maxY + big), epsilon));
        Assertions.assertFalse((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX - big, minY, maxX, maxY), epsilon));
        Assertions.assertFalse((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX, minY - big, maxX, maxY), epsilon));
        Assertions.assertFalse((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX, minY, maxX - big, maxY), epsilon));
        Assertions.assertFalse((boolean)boundingBox2D.epsilonEquals(new BoundingBox2D(minX, minY, maxX, maxY - big), epsilon));
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(234234L);
        BoundingBox2D boundingBox2D = EuclidGeometryRandomTools.nextBoundingBox2D((Random)random, (double)10.0, (double)10.0);
        double minX = boundingBox2D.getMinX();
        double minY = boundingBox2D.getMinY();
        double maxX = boundingBox2D.getMaxX();
        double maxY = boundingBox2D.getMaxY();
        double smallestEpsilon = 8.8888E-16;
        Assertions.assertTrue((boolean)boundingBox2D.equals((BoundingBox2DReadOnly)new BoundingBox2D(minX, minY, maxX, maxY)));
        BoundingBox2D bbxAxObject = new BoundingBox2D(minX, minY, maxX, maxY);
        Assertions.assertTrue((boolean)boundingBox2D.equals((Object)bbxAxObject));
        Assertions.assertFalse((boolean)boundingBox2D.equals(null));
        Assertions.assertFalse((boolean)boundingBox2D.equals((Object)new double[5]));
        Assertions.assertFalse((boolean)boundingBox2D.equals((BoundingBox2DReadOnly)new BoundingBox2D(minX + smallestEpsilon, minY, maxX, maxY)));
        Assertions.assertFalse((boolean)boundingBox2D.equals((BoundingBox2DReadOnly)new BoundingBox2D(minX, minY + smallestEpsilon, maxX, maxY)));
        Assertions.assertFalse((boolean)boundingBox2D.equals((BoundingBox2DReadOnly)new BoundingBox2D(minX, minY, maxX + smallestEpsilon, maxY)));
        Assertions.assertFalse((boolean)boundingBox2D.equals((BoundingBox2DReadOnly)new BoundingBox2D(minX, minY, maxX, maxY + smallestEpsilon)));
        Assertions.assertFalse((boolean)boundingBox2D.equals((BoundingBox2DReadOnly)new BoundingBox2D(minX - smallestEpsilon, minY, maxX, maxY)));
        Assertions.assertFalse((boolean)boundingBox2D.equals((BoundingBox2DReadOnly)new BoundingBox2D(minX, minY - smallestEpsilon, maxX, maxY)));
        Assertions.assertFalse((boolean)boundingBox2D.equals((BoundingBox2DReadOnly)new BoundingBox2D(minX, minY, maxX - smallestEpsilon, maxY)));
        Assertions.assertFalse((boolean)boundingBox2D.equals((BoundingBox2DReadOnly)new BoundingBox2D(minX, minY, maxX, maxY - smallestEpsilon)));
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(987234L);
        Point2D firstPoint = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.1, (double)2.5);
        Point2D secondPoint = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)2.5, (double)5.0);
        BoundingBox2D firstBox = new BoundingBox2D((Point2DReadOnly)firstPoint, (Point2DReadOnly)secondPoint);
        BoundingBox2D secondBox = new BoundingBox2D((BoundingBox2DReadOnly)firstBox);
        Assertions.assertTrue((boolean)firstBox.geometricallyEquals(secondBox, 1.0E-12));
        Assertions.assertTrue((boolean)secondBox.geometricallyEquals(firstBox, 1.0E-12));
        Assertions.assertTrue((boolean)firstBox.geometricallyEquals(firstBox, 1.0E-12));
        Assertions.assertTrue((boolean)secondBox.geometricallyEquals(secondBox, 1.0E-12));
        for (int i = 0; i < 1000; ++i) {
            Point2D min = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)0.1, (double)2.5);
            Point2D max = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)2.5, (double)5.0);
            firstBox = new BoundingBox2D((Point2DReadOnly)min, (Point2DReadOnly)max);
            Point2D minCorrupted = new Point2D((Tuple2DReadOnly)min);
            minCorrupted.add((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)9.9E-13));
            secondBox = new BoundingBox2D((Point2DReadOnly)minCorrupted, (Point2DReadOnly)max);
            Assertions.assertTrue((boolean)firstBox.geometricallyEquals(secondBox, 1.0E-12));
            minCorrupted = new Point2D((Tuple2DReadOnly)min);
            minCorrupted.add((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.01E-12));
            secondBox = new BoundingBox2D((Point2DReadOnly)minCorrupted, (Point2DReadOnly)max);
            Assertions.assertFalse((boolean)firstBox.geometricallyEquals(secondBox, 1.0E-12));
            Point2D maxCorrupted = new Point2D((Tuple2DReadOnly)max);
            maxCorrupted.add((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)9.9E-13));
            secondBox = new BoundingBox2D((Point2DReadOnly)min, (Point2DReadOnly)maxCorrupted);
            Assertions.assertTrue((boolean)firstBox.geometricallyEquals(secondBox, 1.0E-12));
            maxCorrupted = new Point2D((Tuple2DReadOnly)max);
            maxCorrupted.add((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.01E-12));
            secondBox = new BoundingBox2D((Point2DReadOnly)min, (Point2DReadOnly)maxCorrupted);
            Assertions.assertFalse((boolean)firstBox.geometricallyEquals(secondBox, 1.0E-12));
        }
    }
}

