/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.yawPitchRoll;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.exceptions.NotAnOrientation2DException;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.rotationConversion.QuaternionConversion;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.rotationConversion.RotationVectorConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.YawPitchRollTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public abstract class YawPitchRollReadOnlyTest<T extends YawPitchRollReadOnly> {
    public abstract T createEmptyYawPitchRoll();

    public abstract T createYawPitchRoll(Orientation3DReadOnly var1);

    public abstract T createYawPitchRoll(double var1, double var3, double var5);

    public abstract T createRandomYawPitchRoll(Random var1);

    public abstract double getEpsilon();

    public abstract double getSmallestEpsilon();

    @Test
    public void testComponentGetters() {
        Random random = new Random(346L);
        for (int i = 0; i < 1000; ++i) {
            double expectedYaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double expectedPitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.5707963267948966);
            double expectedRoll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            T ypr = this.createYawPitchRoll(expectedYaw, expectedPitch, expectedRoll);
            Assertions.assertEquals((double)expectedYaw, (double)ypr.getYaw(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedPitch, (double)ypr.getPitch(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedRoll, (double)ypr.getRoll(), (double)this.getEpsilon());
            Assertions.assertEquals((double)((float)expectedYaw), (double)ypr.getYaw32(), (double)this.getEpsilon());
            Assertions.assertEquals((double)((float)expectedPitch), (double)ypr.getPitch32(), (double)this.getEpsilon());
            Assertions.assertEquals((double)((float)expectedRoll), (double)ypr.getRoll32(), (double)this.getEpsilon());
        }
    }

    @Test
    public void testContainsNaN() {
        T ypr = this.createYawPitchRoll(0.0, 0.0, 0.0);
        Assertions.assertFalse((boolean)ypr.containsNaN());
        ypr = this.createYawPitchRoll(Double.NaN, 0.0, 0.0);
        Assertions.assertTrue((boolean)ypr.containsNaN());
        ypr = this.createYawPitchRoll(0.0, Double.NaN, 0.0);
        Assertions.assertTrue((boolean)ypr.containsNaN());
        ypr = this.createYawPitchRoll(0.0, 0.0, Double.NaN);
        Assertions.assertTrue((boolean)ypr.containsNaN());
    }

    @Test
    public void testIsZero() {
        Random random = new Random(342L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = random.nextDouble();
            double roll = 0.0;
            double pitch = 0.0;
            double yaw = 0.0;
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isZero(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = Double.NaN;
            Assertions.assertFalse((boolean)this.createYawPitchRoll(yaw, pitch, roll).isZero(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = Double.NaN;
            Assertions.assertFalse((boolean)this.createYawPitchRoll(yaw, pitch, roll).isZero(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            roll = Double.NaN;
            Assertions.assertFalse((boolean)this.createYawPitchRoll(yaw, pitch, roll).isZero(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = epsilon;
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isZero(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = epsilon;
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isZero(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            roll = epsilon;
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isZero(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isZero(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isZero(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isZero(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = 1.01 * epsilon;
            Assertions.assertFalse((boolean)this.createYawPitchRoll(yaw, pitch, roll).isZero(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = 1.01 * epsilon;
            Assertions.assertFalse((boolean)this.createYawPitchRoll(yaw, pitch, roll).isZero(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            roll = 1.01 * epsilon;
            Assertions.assertFalse((boolean)this.createYawPitchRoll(yaw, pitch, roll).isZero(epsilon));
        }
    }

    @Test
    public void testIsOrientation2D() {
        Random random = new Random(342L);
        for (int i = 0; i < 1000; ++i) {
            double epsilon = random.nextDouble();
            double roll = 0.0;
            double pitch = 0.0;
            double yaw = 0.0;
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isOrientation2D(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            yaw = Double.NaN;
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isOrientation2D(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            pitch = Double.NaN;
            Assertions.assertFalse((boolean)this.createYawPitchRoll(yaw, pitch, roll).isOrientation2D(epsilon));
            roll = 0.0;
            pitch = 0.0;
            yaw = 0.0;
            roll = Double.NaN;
            Assertions.assertFalse((boolean)this.createYawPitchRoll(yaw, pitch, roll).isOrientation2D(epsilon));
            yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)100.0);
            roll = 0.0;
            pitch = 0.0;
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isOrientation2D(epsilon));
            roll = 0.0;
            pitch = 0.0;
            pitch = epsilon;
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isOrientation2D(epsilon));
            roll = 0.0;
            pitch = 0.0;
            roll = epsilon;
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isOrientation2D(epsilon));
            roll = 0.0;
            pitch = 0.0;
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isOrientation2D(epsilon));
            roll = 0.0;
            pitch = 0.0;
            pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)epsilon);
            Assertions.assertTrue((boolean)this.createYawPitchRoll(yaw, pitch, roll).isOrientation2D(epsilon));
            roll = 0.0;
            pitch = 0.0;
            pitch = 1.01 * epsilon;
            Assertions.assertFalse((boolean)this.createYawPitchRoll(yaw, pitch, roll).isOrientation2D(epsilon));
            roll = 0.0;
            pitch = 0.0;
            roll = 1.01 * epsilon;
            Assertions.assertFalse((boolean)this.createYawPitchRoll(yaw, pitch, roll).isOrientation2D(epsilon));
        }
    }

    @Test
    public void testDistance() throws Exception {
        Random random = new Random(345093L);
        for (int i = 0; i < 1000; ++i) {
            T ypr1 = this.createRandomYawPitchRoll(random);
            T ypr2 = this.createRandomYawPitchRoll(random);
            double actual = ypr1.distance(ypr2);
            double expected = YawPitchRollTools.distance(ypr1, ypr2);
            Assertions.assertEquals((double)expected, (double)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testOrientationGetters() throws Exception {
        T ypr;
        RotationMatrix actual;
        RotationMatrix expected;
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            expected = new RotationMatrix();
            actual = new RotationMatrix();
            ypr = this.createRandomYawPitchRoll(random);
            ypr.get((CommonMatrix3DBasics)actual);
            RotationMatrixConversion.convertYawPitchRollToMatrix(ypr, (CommonMatrix3DBasics)expected);
            EuclidCoreTestTools.assertRotationMatrixGeometricallyEquals((RotationMatrixReadOnly)expected, (RotationMatrixReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = new AxisAngle();
            actual = new AxisAngle();
            ypr = this.createRandomYawPitchRoll(random);
            ypr.get((AxisAngleBasics)actual);
            AxisAngleConversion.convertYawPitchRollToAxisAngle(ypr, (AxisAngleBasics)expected);
            EuclidCoreTestTools.assertAxisAngleGeometricallyEquals((AxisAngleReadOnly)expected, (AxisAngleReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = new Quaternion();
            actual = new Quaternion();
            ypr = this.createRandomYawPitchRoll(random);
            ypr.get((QuaternionBasics)actual);
            QuaternionConversion.convertYawPitchRollToQuaternion(ypr, (QuaternionBasics)expected);
            EuclidCoreTestTools.assertQuaternionGeometricallyEquals((QuaternionReadOnly)expected, (QuaternionReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            expected = new YawPitchRoll();
            actual = new YawPitchRoll();
            ypr = this.createRandomYawPitchRoll(random);
            ypr.get((YawPitchRollBasics)actual);
            expected.set(ypr.getYaw(), ypr.getPitch(), ypr.getRoll());
            EuclidCoreTestTools.assertYawPitchRollGeometricallyEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testGetRotationVector() throws Exception {
        Random random = new Random(435983L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D expected = new Vector3D();
            Vector3D actual = new Vector3D();
            T ypr = this.createRandomYawPitchRoll(random);
            ypr.getRotationVector((Vector3DBasics)actual);
            RotationVectorConversion.convertYawPitchRollToRotationVector(ypr, (Vector3DBasics)expected);
            EuclidCoreTestTools.assertRotationVectorGeometricallyEquals((Vector3DReadOnly)expected, (Vector3DReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testGetEuler() throws Exception {
        Random random = new Random(435983L);
        for (int i = 0; i < 1000; ++i) {
            Quaternion q = EuclidCoreRandomTools.nextQuaternion((Random)random);
            T ypr = this.createYawPitchRoll((Orientation3DReadOnly)q);
            Point3D expected = new Point3D();
            Point3D actual = new Point3D();
            q.getEuler((Tuple3DBasics)expected);
            ypr.getEuler((Tuple3DBasics)actual);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testGetDoubleArray() {
        int i;
        Random random = new Random(3513515L);
        for (i = 0; i < 1000; ++i) {
            double[] yprArray = new double[4];
            T ypr = this.createRandomYawPitchRoll(random);
            ypr.get(yprArray);
            Assertions.assertTrue((ypr.getYaw() == yprArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getPitch() == yprArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getRoll() == yprArray[2] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            int startIndex = random.nextInt(20);
            double[] yprArray = new double[startIndex + 4 + random.nextInt(10)];
            T ypr = this.createRandomYawPitchRoll(random);
            ypr.get(startIndex, yprArray);
            Assertions.assertTrue((ypr.getYaw() == yprArray[startIndex + 0] ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getPitch() == yprArray[startIndex + 1] ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getRoll() == yprArray[startIndex + 2] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetFloatArray() {
        int i;
        Random random = new Random(3513515L);
        for (i = 0; i < 1000; ++i) {
            float[] yprArray = new float[4];
            T ypr = this.createRandomYawPitchRoll(random);
            ypr.get(yprArray);
            Assertions.assertTrue((ypr.getYaw32() == yprArray[0] ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getPitch32() == yprArray[1] ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getRoll32() == yprArray[2] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            int startIndex = random.nextInt(20);
            float[] yprArray = new float[startIndex + 4 + random.nextInt(10)];
            T ypr = this.createRandomYawPitchRoll(random);
            ypr.get(startIndex, yprArray);
            Assertions.assertTrue((ypr.getYaw32() == yprArray[startIndex + 0] ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getPitch32() == yprArray[startIndex + 1] ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getRoll32() == yprArray[startIndex + 2] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetElement() throws Exception {
        Random random = new Random(324234L);
        for (int i = 0; i < 1000; ++i) {
            T ypr = this.createRandomYawPitchRoll(random);
            Assertions.assertTrue((ypr.getYaw() == ypr.getElement(0) ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getPitch() == ypr.getElement(1) ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getRoll() == ypr.getElement(2) ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getYaw32() == ypr.getElement32(0) ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getPitch32() == ypr.getElement32(1) ? 1 : 0) != 0);
            Assertions.assertTrue((ypr.getRoll32() == ypr.getElement32(2) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTransform() {
        Point3D expected;
        Point3D actual;
        Point3D tupleOriginal;
        T ypr;
        int i;
        Random random = new Random(24546654L);
        for (i = 0; i < 1000; ++i) {
            ypr = this.createRandomYawPitchRoll(random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            ypr.transform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix(ypr).transform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            ypr = this.createRandomYawPitchRoll(random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            YawPitchRollTools.addTransform(ypr, (Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix(ypr).addTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            ypr = this.createRandomYawPitchRoll(random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual = new Point2D();
            expected = new Point2D();
            ypr.transform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, false);
            new RotationMatrix(ypr).transform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)expected, false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)this.getEpsilon());
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testTransform$0(random, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testTransform$1((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testTransform$2((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr = this.createYawPitchRoll(random.nextDouble(), 0.0, 0.0);
            ypr.transform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, true);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = this.createRandomYawPitchRoll(random);
            tupleOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            ypr.transform((Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)actual);
            new RotationMatrix(ypr).transform((Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            ypr = this.createRandomYawPitchRoll(random);
            tupleOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix();
            expected = new RotationMatrix();
            ypr.transform((RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)actual);
            new RotationMatrix(ypr).transform((RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            ypr = this.createRandomYawPitchRoll(random);
            tupleOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            ypr.transform((Vector4DReadOnly)tupleOriginal, (Vector4DBasics)actual);
            new RotationMatrix(ypr).transform((Vector4DReadOnly)tupleOriginal, (Vector4DBasics)expected);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testInverseTransform() {
        Point3D expected;
        Point3D actual;
        Point3D tupleOriginal;
        T ypr;
        int i;
        Random random = new Random(24546654L);
        for (i = 0; i < 1000; ++i) {
            ypr = this.createRandomYawPitchRoll(random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint3D((Random)random);
            actual = new Point3D();
            expected = new Point3D();
            ypr.inverseTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)actual);
            new RotationMatrix(ypr).inverseTransform((Tuple3DReadOnly)tupleOriginal, (Tuple3DBasics)expected);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            ypr = this.createRandomYawPitchRoll(random);
            tupleOriginal = EuclidCoreRandomTools.nextPoint2D((Random)random);
            actual = new Point2D();
            expected = new Point2D();
            ypr.inverseTransform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, false);
            new RotationMatrix(ypr).inverseTransform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)expected, false);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expected, (Tuple2DReadOnly)actual, (double)this.getEpsilon());
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testInverseTransform$3(random, (Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testInverseTransform$4((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            EuclidCoreTestTools.assertExceptionIsThrown(() -> this.lambda$testInverseTransform$5((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual), (Class[])new Class[]{NotAnOrientation2DException.class});
            ypr = this.createYawPitchRoll(random.nextDouble(), 0.0, 0.0);
            ypr.inverseTransform((Tuple2DReadOnly)tupleOriginal, (Tuple2DBasics)actual, true);
        }
        for (i = 0; i < 1000; ++i) {
            ypr = this.createRandomYawPitchRoll(random);
            tupleOriginal = EuclidCoreRandomTools.nextMatrix3D((Random)random);
            actual = new Matrix3D();
            expected = new Matrix3D();
            ypr.inverseTransform((Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)actual);
            new RotationMatrix(ypr).inverseTransform((Matrix3DReadOnly)tupleOriginal, (Matrix3DBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            ypr = this.createRandomYawPitchRoll(random);
            tupleOriginal = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            actual = new RotationMatrix();
            expected = new RotationMatrix();
            ypr.inverseTransform((RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)actual);
            new RotationMatrix(ypr).inverseTransform((RotationMatrixReadOnly)tupleOriginal, (RotationMatrixBasics)expected);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            ypr = this.createRandomYawPitchRoll(random);
            tupleOriginal = EuclidCoreRandomTools.nextVector4D((Random)random);
            actual = new Vector4D();
            expected = new Vector4D();
            ypr.inverseTransform((Vector4DReadOnly)tupleOriginal, (Vector4DBasics)actual);
            new RotationMatrix(ypr).inverseTransform((Vector4DReadOnly)tupleOriginal, (Vector4DBasics)expected);
            EuclidCoreTestTools.assertTuple4DEquals((Tuple4DReadOnly)expected, (Tuple4DReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(621541L);
        T ypr = this.createRandomYawPitchRoll(random);
        Assertions.assertFalse((boolean)ypr.equals(this.createEmptyYawPitchRoll()));
        T emptyYawPitchRollAsObject = this.createEmptyYawPitchRoll();
        Assertions.assertFalse((boolean)ypr.equals(emptyYawPitchRollAsObject));
        T yprAsObject = ypr;
        Assertions.assertTrue((boolean)ypr.equals(yprAsObject));
        Assertions.assertFalse((boolean)ypr.equals(null));
        Assertions.assertFalse((boolean)ypr.equals(new double[5]));
        double yaw = ypr.getYaw();
        double pitch = ypr.getPitch();
        double roll = ypr.getRoll();
        Assertions.assertTrue((boolean)ypr.equals(this.createYawPitchRoll(yaw, pitch, roll)));
        Assertions.assertFalse((boolean)ypr.equals(this.createYawPitchRoll(yaw + this.getSmallestEpsilon(), pitch, roll)));
        Assertions.assertFalse((boolean)ypr.equals(this.createYawPitchRoll(yaw - this.getSmallestEpsilon(), pitch, roll)));
        Assertions.assertFalse((boolean)ypr.equals(this.createYawPitchRoll(yaw, pitch + this.getSmallestEpsilon(), roll)));
        Assertions.assertFalse((boolean)ypr.equals(this.createYawPitchRoll(yaw, pitch - this.getSmallestEpsilon(), roll)));
        Assertions.assertFalse((boolean)ypr.equals(this.createYawPitchRoll(yaw, pitch, roll + this.getSmallestEpsilon())));
        Assertions.assertFalse((boolean)ypr.equals(this.createYawPitchRoll(yaw, pitch, roll - this.getSmallestEpsilon())));
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(621541L);
        double epsilon = random.nextDouble();
        T ypr = this.createRandomYawPitchRoll(random);
        double yaw = ypr.getYaw();
        double pitch = ypr.getPitch();
        double roll = ypr.getRoll();
        Assertions.assertTrue((boolean)ypr.epsilonEquals(this.createYawPitchRoll(yaw + 0.999 * epsilon, pitch, roll), epsilon));
        Assertions.assertTrue((boolean)ypr.epsilonEquals(this.createYawPitchRoll(yaw - 0.999 * epsilon, pitch, roll), epsilon));
        Assertions.assertTrue((boolean)ypr.epsilonEquals(this.createYawPitchRoll(yaw, pitch + 0.999 * epsilon, roll), epsilon));
        Assertions.assertTrue((boolean)ypr.epsilonEquals(this.createYawPitchRoll(yaw, pitch - 0.999 * epsilon, roll), epsilon));
        Assertions.assertTrue((boolean)ypr.epsilonEquals(this.createYawPitchRoll(yaw, pitch, roll + 0.999 * epsilon), epsilon));
        Assertions.assertTrue((boolean)ypr.epsilonEquals(this.createYawPitchRoll(yaw, pitch, roll - 0.999 * epsilon), epsilon));
        Assertions.assertFalse((boolean)ypr.epsilonEquals(this.createYawPitchRoll(yaw + 1.001 * epsilon, pitch, roll), epsilon));
        Assertions.assertFalse((boolean)ypr.epsilonEquals(this.createYawPitchRoll(yaw - 1.001 * epsilon, pitch, roll), epsilon));
        Assertions.assertFalse((boolean)ypr.epsilonEquals(this.createYawPitchRoll(yaw, pitch + 1.001 * epsilon, roll), epsilon));
        Assertions.assertFalse((boolean)ypr.epsilonEquals(this.createYawPitchRoll(yaw, pitch - 1.001 * epsilon, roll), epsilon));
        Assertions.assertFalse((boolean)ypr.epsilonEquals(this.createYawPitchRoll(yaw, pitch, roll + 1.001 * epsilon), epsilon));
        Assertions.assertFalse((boolean)ypr.epsilonEquals(this.createYawPitchRoll(yaw, pitch, roll - 1.001 * epsilon), epsilon));
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        YawPitchRoll yprbB;
        T ypr;
        double angleEps;
        T yprbA;
        double epsilon;
        int i;
        Random random = new Random(35454L);
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            yprbA = this.createRandomYawPitchRoll(random);
            angleEps = epsilon * 0.99;
            ypr = this.createYawPitchRoll((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleEps));
            yprbB = new YawPitchRoll(ypr);
            yprbB.prepend(yprbA);
            Assertions.assertTrue((boolean)yprbA.geometricallyEquals((YawPitchRollReadOnly)yprbB, epsilon));
        }
        for (i = 0; i < 1000; ++i) {
            epsilon = random.nextDouble();
            yprbA = this.createRandomYawPitchRoll(random);
            angleEps = epsilon * 1.01;
            ypr = this.createYawPitchRoll((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), angleEps));
            yprbB = new YawPitchRoll(ypr);
            yprbB.prepend(yprbA);
            Assertions.assertFalse((boolean)yprbA.geometricallyEquals((YawPitchRollReadOnly)yprbB, epsilon));
        }
    }

    private /* synthetic */ void lambda$testInverseTransform$5(Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        this.createYawPitchRoll(1.0, 1.0, 0.0).inverseTransform(tupleOriginal, actual, true);
    }

    private /* synthetic */ void lambda$testInverseTransform$4(Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        this.createYawPitchRoll(1.0, 0.0, 1.0).inverseTransform(tupleOriginal, actual, true);
    }

    private /* synthetic */ void lambda$testInverseTransform$3(Random random, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        this.createRandomYawPitchRoll(random).inverseTransform(tupleOriginal, actual, true);
    }

    private /* synthetic */ void lambda$testTransform$2(Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        this.createYawPitchRoll(1.0, 1.0, 0.0).transform(tupleOriginal, actual, true);
    }

    private /* synthetic */ void lambda$testTransform$1(Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        this.createYawPitchRoll(1.0, 0.0, 1.0).transform(tupleOriginal, actual, true);
    }

    private /* synthetic */ void lambda$testTransform$0(Random random, Tuple2DReadOnly tupleOriginal, Tuple2DBasics actual) {
        this.createRandomYawPitchRoll(random).transform(tupleOriginal, actual, true);
    }
}

