/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.ejml.dense.row.SingularOps_DDRM;
import org.ejml.dense.row.decomposition.svd.SvdImplicitQrDecompose_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.Matrix3DTools;
import us.ihmc.euclid.tools.SingularValueDecomposition3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;

public class SingularValueDecomposition3DTest {
    private static final int ITERATIONS = 10000;
    private static final double EPSILON = 1.0E-11;

    @Test
    public void testDefaultConfiguration() {
        Random random = new Random(36456L);
        SingularValueDecomposition3D svd = new SingularValueDecomposition3D();
        long ejmlTotalTime = 0L;
        long euclidTotalTime = 0L;
        ArrayList<Supplier<Pair>> generators = new ArrayList<Supplier<Pair>>();
        generators.add(() -> Pair.of((Object)new Matrix3D((DMatrix)RandomMatrices_DDRM.symmetric((int)3, (double)-100.0, (double)100.0, (Random)random)), (Object)"Symmetric matrix"));
        generators.add(() -> Pair.of((Object)new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random, (double)Math.PI)), (Object)"Rotation matrix"));
        generators.add(() -> Pair.of((Object)EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)100.0), (Object)"Diagonal matrix"));
        generators.add(() -> Pair.of((Object)EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)10.0), (Object)"General matrix"));
        generators.add(() -> Pair.of((Object)EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)10000.0), (Object)"Large values matrix"));
        for (int i = 0; i < 50000; ++i) {
            svd.decompose((Matrix3DReadOnly)EuclidCoreRandomTools.nextMatrix3D((Random)random));
            SingularValueDecomposition3DTest.ejmlSVDDecomposition((Matrix3DReadOnly)EuclidCoreRandomTools.nextMatrix3D((Random)random), (Matrix3DBasics)new Matrix3D(), (Matrix3DBasics)new Matrix3D(), (Matrix3DBasics)new Matrix3D(), true);
        }
        for (Supplier supplier : generators) {
            for (int i = 0; i < 10000; ++i) {
                Matrix3D A = (Matrix3D)((Pair)supplier.get()).getKey();
                long start = System.nanoTime();
                svd.decompose((Matrix3DReadOnly)A);
                long end = System.nanoTime();
                euclidTotalTime += end - start;
                double varEpsilon = Math.max(1.0, Math.abs(A.determinant())) * 1.0E-11;
                RotationMatrix Ueuclid = new RotationMatrix((Orientation3DReadOnly)svd.getU());
                Matrix3DBasics Weuclid = svd.getW(null);
                RotationMatrix Veuclid = new RotationMatrix((Orientation3DReadOnly)svd.getV());
                Matrix3D Wejml = new Matrix3D();
                Matrix3D Uejml = new Matrix3D();
                Matrix3D Vejml = new Matrix3D();
                ejmlTotalTime += SingularValueDecomposition3DTest.ejmlSVDDecomposition((Matrix3DReadOnly)A, (Matrix3DBasics)Uejml, (Matrix3DBasics)Wejml, (Matrix3DBasics)Vejml, true);
                double[] singularValuesEJML = new double[]{Wejml.getM00(), Wejml.getM11(), Wejml.getM22()};
                double[] singularValuesEuclid = new double[]{Weuclid.getM00(), Weuclid.getM11(), Math.abs(Weuclid.getM22())};
                if (Weuclid.getM22() < 0.0) {
                    if (SingularValueDecomposition3DTest.columnDot(2, (Matrix3DReadOnly)Uejml, (Matrix3DReadOnly)Ueuclid) < 0.0) {
                        SingularValueDecomposition3DTest.negateColumn(2, (Matrix3DBasics)Uejml);
                    } else {
                        SingularValueDecomposition3DTest.negateColumn(2, (Matrix3DBasics)Vejml);
                    }
                }
                for (int col = 0; col < 3; ++col) {
                    if (!(SingularValueDecomposition3DTest.columnDot(col, (Matrix3DReadOnly)Uejml, (Matrix3DReadOnly)Ueuclid) < 0.0) || !(SingularValueDecomposition3DTest.columnDot(col, (Matrix3DReadOnly)Vejml, (Matrix3DReadOnly)Veuclid) < 0.0)) continue;
                    SingularValueDecomposition3DTest.negateColumn(col, (Matrix3DBasics)Uejml);
                    SingularValueDecomposition3DTest.negateColumn(col, (Matrix3DBasics)Vejml);
                }
                String messagePrefix = "Iteration: " + i + ", generator: " + (String)((Pair)supplier.get()).getValue();
                try {
                    SingularValueDecomposition3DTest.performGeneralAssertions(messagePrefix, (Matrix3DReadOnly)A, svd.getOutput(), true, 1.0E-11);
                    Assertions.assertArrayEquals((double[])singularValuesEJML, (double[])singularValuesEuclid, (double)varEpsilon, (String)messagePrefix);
                    if (EuclidCoreTools.epsilonEquals((double)singularValuesEJML[0], (double)singularValuesEJML[1], (double)1.0E-11) || EuclidCoreTools.epsilonEquals((double)singularValuesEJML[0], (double)singularValuesEJML[2], (double)1.0E-11)) continue;
                    EuclidCoreTestTools.assertMatrix3DEquals((String)messagePrefix, (Matrix3DReadOnly)Uejml, (Matrix3DReadOnly)Ueuclid, (double)varEpsilon);
                    EuclidCoreTestTools.assertMatrix3DEquals((String)messagePrefix, (Matrix3DReadOnly)Vejml, (Matrix3DReadOnly)Veuclid, (double)varEpsilon);
                    continue;
                }
                catch (Throwable e) {
                    System.out.println(messagePrefix);
                    System.out.println("A:\n" + A);
                    System.out.println("U EJML:\n" + Uejml);
                    System.out.println("U Euclid:\n" + Ueuclid);
                    System.out.println("W EJML:\n" + Wejml);
                    System.out.println("W Euclid:\n" + Weuclid);
                    System.out.println("V EJML:\n" + Vejml);
                    System.out.println("V Euclid:\n" + Veuclid);
                    throw e;
                }
            }
        }
        double euclidAverageMilllis = (double)euclidTotalTime / 1000000.0 / 10000.0 / (double)generators.size();
        double ejmlAverageMilllis = (double)ejmlTotalTime / 1000000.0 / 10000.0 / (double)generators.size();
        System.out.println(String.format("Average time in millisec:\n\t-EJML:%s\n\t-Euclid:%s", Double.toString(ejmlAverageMilllis), Double.toString(euclidAverageMilllis)));
    }

    public static void performGeneralAssertions(String messagePrefix, Matrix3DReadOnly A, SingularValueDecomposition3D.SVD3DOutput outputToTest, boolean sorted, double epsilon) {
        Matrix3D A_output = new Matrix3D();
        outputToTest.getW((Matrix3DBasics)A_output);
        Matrix3DTools.multiply((Orientation3DReadOnly)outputToTest.getU(), (boolean)false, (Matrix3DReadOnly)A_output, (boolean)false, (boolean)false, (CommonMatrix3DBasics)A_output);
        Matrix3DTools.multiply((Matrix3DReadOnly)A_output, (boolean)false, (boolean)false, (Orientation3DReadOnly)outputToTest.getV(), (boolean)true, (CommonMatrix3DBasics)A_output);
        EuclidCoreTestTools.assertMatrix3DEquals((String)messagePrefix, (Matrix3DReadOnly)A, (Matrix3DReadOnly)A_output, (double)(Math.max(1.0, A.maxAbsElement()) * epsilon));
        Vector3D W = outputToTest.getW();
        Assertions.assertTrue((W.getX() >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((W.getY() >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((A.determinant() * W.getZ() >= 0.0 ? 1 : 0) != 0);
        if (sorted) {
            Assertions.assertTrue((EuclidCoreTools.epsilonEquals((double)W.getX(), (double)W.getY(), (double)epsilon) || W.getX() > W.getY() ? 1 : 0) != 0);
            Assertions.assertTrue((EuclidCoreTools.epsilonEquals((double)W.getY(), (double)Math.abs(W.getZ()), (double)epsilon) || W.getY() > Math.abs(W.getZ()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUnsorted() {
        Random random = new Random(36456L);
        SingularValueDecomposition3D svd = new SingularValueDecomposition3D();
        svd.setSortDescendingOrder(false);
        long euclidTotalTime = 0L;
        ArrayList<Supplier<Pair>> generators = new ArrayList<Supplier<Pair>>();
        generators.add(() -> Pair.of((Object)new Matrix3D((DMatrix)RandomMatrices_DDRM.symmetric((int)3, (double)-100.0, (double)100.0, (Random)random)), (Object)"Symmetric matrix"));
        generators.add(() -> Pair.of((Object)new Matrix3D((Matrix3DReadOnly)EuclidCoreRandomTools.nextRotationMatrix((Random)random, (double)Math.PI)), (Object)"Rotation matrix"));
        generators.add(() -> Pair.of((Object)EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)100.0), (Object)"Diagonal matrix"));
        generators.add(() -> Pair.of((Object)EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)10.0), (Object)"General matrix"));
        generators.add(() -> Pair.of((Object)EuclidCoreRandomTools.nextMatrix3D((Random)random, (double)10000.0), (Object)"Large values matrix"));
        for (int i = 0; i < 50000; ++i) {
            svd.decompose((Matrix3DReadOnly)EuclidCoreRandomTools.nextMatrix3D((Random)random));
        }
        for (Supplier supplier : generators) {
            for (int i = 0; i < 10000; ++i) {
                Matrix3D A = (Matrix3D)((Pair)supplier.get()).getKey();
                long start = System.nanoTime();
                svd.decompose((Matrix3DReadOnly)A);
                long end = System.nanoTime();
                euclidTotalTime += end - start;
                RotationMatrix Ueuclid = new RotationMatrix((Orientation3DReadOnly)svd.getU());
                Matrix3DBasics Weuclid = svd.getW(null);
                RotationMatrix Veuclid = new RotationMatrix((Orientation3DReadOnly)svd.getV());
                String messagePrefix = "Iteration: " + i + ", generator: " + (String)((Pair)supplier.get()).getValue();
                try {
                    SingularValueDecomposition3DTest.performGeneralAssertions(messagePrefix, (Matrix3DReadOnly)A, svd.getOutput(), false, 1.0E-11);
                    continue;
                }
                catch (Throwable e) {
                    System.out.println(messagePrefix);
                    System.out.println("epsilon: " + Math.max(1.0, A.maxAbsElement()) * 1.0E-11);
                    System.out.println("A:\n" + A);
                    System.out.println("U Euclid:\n" + Ueuclid);
                    System.out.println("W Euclid:\n" + Weuclid);
                    System.out.println("V Euclid:\n" + Veuclid);
                    throw e;
                }
            }
        }
        double euclidAverageMilllis = (double)euclidTotalTime / 1000000.0 / 10000.0 / (double)generators.size();
        System.out.println(String.format("Average time in millisec:\n\t-Euclid:%s", Double.toString(euclidAverageMilllis)));
    }

    static double columnDot(int col, Matrix3DReadOnly a, Matrix3DReadOnly b) {
        double dot = 0.0;
        for (int row = 0; row < 3; ++row) {
            dot += a.getElement(row, col) * b.getElement(row, col);
        }
        return dot;
    }

    static void negateColumn(int col, Matrix3DBasics m) {
        for (int row = 0; row < 3; ++row) {
            m.setElement(row, col, -m.getElement(row, col));
        }
    }

    private static long ejmlSVDDecomposition(Matrix3DReadOnly A, Matrix3DBasics U, Matrix3DBasics W, Matrix3DBasics V, boolean sort) {
        DMatrixRMaj A_ejml = new DMatrixRMaj(3, 3);
        A.get((DMatrix)A_ejml);
        DMatrixRMaj U_ejml = new DMatrixRMaj(3, 3);
        DMatrixRMaj W_ejml = new DMatrixRMaj(3, 3);
        DMatrixRMaj V_ejml = new DMatrixRMaj(3, 3);
        SvdImplicitQrDecompose_DDRM svdEJML = new SvdImplicitQrDecompose_DDRM(false, true, true, false);
        long start = System.nanoTime();
        svdEJML.decompose(A_ejml);
        svdEJML.getU(U_ejml, false);
        svdEJML.getW(W_ejml);
        svdEJML.getV(V_ejml, false);
        if (sort) {
            SingularOps_DDRM.descendingOrder((DMatrixRMaj)U_ejml, (boolean)false, (DMatrixRMaj)W_ejml, (DMatrixRMaj)V_ejml, (boolean)false);
        }
        U.set((DMatrix)U_ejml);
        W.set((DMatrix)W_ejml);
        V.set((DMatrix)V_ejml);
        long end = System.nanoTime();
        return end - start;
    }

    @Test
    public void testSortBColumns() {
        Random random = new Random(425346L);
        for (int i = 0; i < 10000; ++i) {
            Matrix3D diag = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random, (double)10.0);
            Quaternion V = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Matrix3D originalB = new Matrix3D();
            Matrix3DTools.multiply((Matrix3DReadOnly)diag, (Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)V), (CommonMatrix3DBasics)originalB);
            Matrix3D sortedB = new Matrix3D((Matrix3DReadOnly)originalB);
            SingularValueDecomposition3D.sortBColumns((Matrix3DBasics)sortedB, (QuaternionBasics)V);
            Matrix3D recomputedB = new Matrix3D();
            Matrix3DTools.multiply((Matrix3DReadOnly)diag, (Matrix3DReadOnly)new RotationMatrix((Orientation3DReadOnly)V), (CommonMatrix3DBasics)recomputedB);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)sortedB, (Matrix3DReadOnly)recomputedB, (double)1.0E-11);
            Vector3D[] cols = new Vector3D[]{new Vector3D(), new Vector3D(), new Vector3D()};
            sortedB.getColumn(0, (Tuple3DBasics)cols[0]);
            sortedB.getColumn(1, (Tuple3DBasics)cols[1]);
            sortedB.getColumn(2, (Tuple3DBasics)cols[2]);
            Assertions.assertTrue((cols[0].length() > cols[1].length() ? 1 : 0) != 0);
            Assertions.assertTrue((cols[1].length() > cols[2].length() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSwapColumn() {
        Matrix3D original = new Matrix3D(0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0);
        Matrix3D actual = new Matrix3D();
        Matrix3D expected = new Matrix3D();
        Vector3D tuple1 = new Vector3D();
        Vector3D tuple2 = new Vector3D();
        for (int c1 = 0; c1 < 2; ++c1) {
            for (int c2 = c1 + 1; c2 < 3; ++c2) {
                for (boolean negateC1 : new boolean[]{false, true}) {
                    expected.set(original);
                    expected.getColumn(c1, (Tuple3DBasics)tuple1);
                    expected.getColumn(c2, (Tuple3DBasics)tuple2);
                    if (negateC1) {
                        tuple1.negate();
                    }
                    expected.setColumn(c1, (Tuple3DReadOnly)tuple2);
                    expected.setColumn(c2, (Tuple3DReadOnly)tuple1);
                    actual.set(original);
                    SingularValueDecomposition3DTest.swapColumns(c1, negateC1, c2, (Matrix3DBasics)actual);
                    Assertions.assertEquals((Object)expected, (Object)actual);
                }
            }
        }
    }

    @Test
    public void testApplyJacobiGivensRotation() {
        Random random = new Random(4576756L);
        for (int i = 0; i < 10000; ++i) {
            Axis3D rotationAxis;
            int q;
            int p;
            Matrix3D Q = new Matrix3D();
            Matrix3D S = EuclidCoreRandomTools.nextSymmetricMatrix3D((Random)random, (double)10.0);
            switch (random.nextInt(3)) {
                case 0: {
                    p = 0;
                    q = 1;
                    rotationAxis = Axis3D.Z;
                    break;
                }
                case 1: {
                    p = 0;
                    q = 2;
                    rotationAxis = Axis3D.Y;
                    break;
                }
                default: {
                    p = 1;
                    q = 2;
                    rotationAxis = Axis3D.X;
                }
            }
            double s_pp = S.getElement(p, p);
            double s_pq = S.getElement(p, q);
            double s_qq = S.getElement(q, q);
            double ch = 2.0 * (s_pp - s_qq);
            double sh = s_pq;
            if (SingularValueDecomposition3D.gamma * sh * sh < ch * ch) {
                double omega = 1.0 / Math.sqrt(ch * ch + sh * sh);
                ch *= omega;
                sh *= omega;
            } else {
                ch = SingularValueDecomposition3D.cosPiOverEight;
                sh = SingularValueDecomposition3D.sinPiOverEight;
            }
            Matrix3D expected = new Matrix3D();
            SingularValueDecomposition3DTest.packGivensRotation(rotationAxis, ch, sh, (Vector4DBasics)new Vector4D(), (Matrix3DBasics)Q);
            expected.setAndTranspose((Matrix3DReadOnly)Q);
            expected.multiply((Matrix3DReadOnly)S);
            expected.multiply((Matrix3DReadOnly)Q);
            Matrix3D actual = new Matrix3D((Matrix3DReadOnly)S);
            SingularValueDecomposition3DTest.applyJacobiGivensRotation(rotationAxis, ch, sh, (Matrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-11);
        }
    }

    @Test
    public void testSwapElements() {
        Random random = new Random(4677L);
        for (int i = 0; i < 10000; ++i) {
            int c2;
            int c1;
            switch (random.nextInt(3)) {
                case 0: {
                    c1 = 0;
                    c2 = 1;
                    break;
                }
                case 1: {
                    c1 = 0;
                    c2 = 2;
                    break;
                }
                default: {
                    c1 = 1;
                    c2 = 2;
                }
            }
            Vector4D quaternion = EuclidCoreRandomTools.nextVector4D((Random)random);
            quaternion.normalize();
            Matrix3D original = new Matrix3D();
            RotationMatrixConversion.convertQuaternionToMatrix((double)quaternion.getX(), (double)quaternion.getY(), (double)quaternion.getZ(), (double)quaternion.getS(), (CommonMatrix3DBasics)original);
            Matrix3D expected = new Matrix3D();
            RotationMatrixConversion.convertQuaternionToMatrix((double)quaternion.getX(), (double)quaternion.getY(), (double)quaternion.getZ(), (double)quaternion.getS(), (CommonMatrix3DBasics)expected);
            SingularValueDecomposition3DTest.swapColumns(c1, true, c2, (Matrix3DBasics)expected);
            Matrix3D actual = new Matrix3D();
            SingularValueDecomposition3DTest.swapElements(c1, c2, (Vector4DBasics)quaternion);
            RotationMatrixConversion.convertQuaternionToMatrix((double)quaternion.getX(), (double)quaternion.getY(), (double)quaternion.getZ(), (double)quaternion.getS(), (CommonMatrix3DBasics)actual);
            EuclidCoreTestTools.assertMatrix3DEquals((String)("Iteration: " + i + ", original:\n" + original + "\nc1=" + c1 + ", c2=" + c2), (Matrix3DReadOnly)expected, (Matrix3DReadOnly)actual, (double)1.0E-11);
        }
    }

    @Test
    public void testBug20201215() {
        Matrix3D A = new Matrix3D();
        A.setToDiagonal(0.3, 0.3, 0.0);
        SingularValueDecomposition3D svd = new SingularValueDecomposition3D();
        Assertions.assertTrue((boolean)svd.decompose((Matrix3DReadOnly)A));
        Assertions.assertEquals((double)A.getM00(), (double)svd.getW().getX());
        Assertions.assertEquals((double)A.getM11(), (double)svd.getW().getY());
        Assertions.assertEquals((double)A.getM22(), (double)svd.getW().getZ());
        EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)new Quaternion(), (QuaternionReadOnly)svd.getU(), (double)1.0E-11);
        EuclidCoreTestTools.assertQuaternionEquals((QuaternionReadOnly)new Quaternion(), (QuaternionReadOnly)svd.getV(), (double)1.0E-11);
    }

    static void applyJacobiGivensRotation(Axis3D rotationAxis, double ch, double sh, Matrix3DBasics S) {
        switch (rotationAxis) {
            case X: {
                SingularValueDecomposition3D.applyJacobiGivensRotationX((double)ch, (double)sh, (Matrix3DBasics)S);
                break;
            }
            case Y: {
                SingularValueDecomposition3D.applyJacobiGivensRotationY((double)ch, (double)sh, (Matrix3DBasics)S);
                break;
            }
            case Z: {
                SingularValueDecomposition3D.applyJacobiGivensRotationZ((double)ch, (double)sh, (Matrix3DBasics)S);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value for Axis3D: " + rotationAxis);
            }
        }
    }

    static void packGivensRotation(Axis3D rotationAxis, double ch, double sh, Vector4DBasics givensQuaternionToPack, Matrix3DBasics givensRotationToPack) {
        double ch2 = ch * ch;
        double sh2 = sh * sh;
        double diag_a = ch2 + sh2;
        double diag_b = (ch2 - sh2) / diag_a;
        double off_diag = 2.0 * ch * sh / diag_a;
        switch (rotationAxis) {
            case X: {
                givensQuaternionToPack.set(sh, 0.0, 0.0, ch);
                givensRotationToPack.set(1.0, 0.0, 0.0, 0.0, diag_b, -off_diag, 0.0, off_diag, diag_b);
                break;
            }
            case Y: {
                givensQuaternionToPack.set(0.0, -sh, 0.0, ch);
                givensRotationToPack.set(diag_b, 0.0, -off_diag, 0.0, 1.0, 0.0, off_diag, 0.0, diag_b);
                break;
            }
            case Z: {
                givensQuaternionToPack.set(0.0, 0.0, sh, ch);
                givensRotationToPack.set(diag_b, -off_diag, 0.0, off_diag, diag_b, 0.0, 0.0, 0.0, 1.0);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value for Axis3D: " + rotationAxis);
            }
        }
    }

    static void swapColumns(int col1, boolean negateCol1, int col2, Matrix3DBasics matrixToSwapColumns) {
        double m22;
        double m21;
        double m20;
        double m12;
        double m11;
        double m10;
        double m02;
        double m01;
        double m00;
        if (col2 <= col1) {
            throw new IllegalArgumentException("col2 is expected to be strictly greater than col1");
        }
        if (col1 == 0) {
            double r0 = matrixToSwapColumns.getM00();
            double r1 = matrixToSwapColumns.getM10();
            double r2 = matrixToSwapColumns.getM20();
            if (negateCol1) {
                r0 = -r0;
                r1 = -r1;
                r2 = -r2;
            }
            if (col2 == 1) {
                m00 = matrixToSwapColumns.getM01();
                m01 = r0;
                m02 = matrixToSwapColumns.getM02();
                m10 = matrixToSwapColumns.getM11();
                m11 = r1;
                m12 = matrixToSwapColumns.getM12();
                m20 = matrixToSwapColumns.getM21();
                m21 = r2;
                m22 = matrixToSwapColumns.getM22();
            } else {
                m00 = matrixToSwapColumns.getM02();
                m01 = matrixToSwapColumns.getM01();
                m02 = r0;
                m10 = matrixToSwapColumns.getM12();
                m11 = matrixToSwapColumns.getM11();
                m12 = r1;
                m20 = matrixToSwapColumns.getM22();
                m21 = matrixToSwapColumns.getM21();
                m22 = r2;
            }
        } else {
            double r0 = matrixToSwapColumns.getM01();
            double r1 = matrixToSwapColumns.getM11();
            double r2 = matrixToSwapColumns.getM21();
            if (negateCol1) {
                r0 = -r0;
                r1 = -r1;
                r2 = -r2;
            }
            m00 = matrixToSwapColumns.getM00();
            m01 = matrixToSwapColumns.getM02();
            m02 = r0;
            m10 = matrixToSwapColumns.getM10();
            m11 = matrixToSwapColumns.getM12();
            m12 = r1;
            m20 = matrixToSwapColumns.getM20();
            m21 = matrixToSwapColumns.getM22();
            m22 = r2;
        }
        if (matrixToSwapColumns instanceof RotationMatrixBasics) {
            ((RotationMatrixBasics)matrixToSwapColumns).setUnsafe(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        } else {
            matrixToSwapColumns.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }
    }

    static void swapElements(int c1, int c2, Vector4DBasics quaternion) {
        if (c2 <= c1) {
            throw new IllegalArgumentException("c2 is expected to be strictly greater than col1");
        }
        double q1x = quaternion.getX() * SingularValueDecomposition3D.sqrtTwoOverTwo;
        double q1y = quaternion.getY() * SingularValueDecomposition3D.sqrtTwoOverTwo;
        double q1z = quaternion.getZ() * SingularValueDecomposition3D.sqrtTwoOverTwo;
        double q1s = quaternion.getS() * SingularValueDecomposition3D.sqrtTwoOverTwo;
        if (c1 == 0) {
            if (c2 == 1) {
                quaternion.set(q1x + q1y, q1y - q1x, q1s + q1z, q1s - q1z);
            } else {
                quaternion.set(q1x + q1z, q1y - q1s, q1z - q1x, q1s + q1y);
            }
        } else {
            quaternion.set(q1s + q1x, q1y + q1z, q1z - q1y, q1s - q1x);
        }
    }
}

