/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.Orientation2D;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.QuaternionBasedTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class EuclidCoreTestToolsTest {
    private static final String MESSAGE_PREFIX = "blop";
    private static final String FORMAT = EuclidCoreIOTools.getStringFormat((int)15, (int)12);
    private static final double EPSILON = 1.0E-4;

    @Test
    public void testAssertYawPitchRollEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertYawPitchRollEquals";
        Class<YawPitchRollReadOnly> argumentsClass = YawPitchRollReadOnly.class;
        YawPitchRoll expected = null;
        YawPitchRoll actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
        actual = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
        actual = new YawPitchRoll((Orientation3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertYawPitchRollGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertYawPitchRollGeometricallyEquals";
        Class<YawPitchRollReadOnly> argumentsClass = YawPitchRollReadOnly.class;
        YawPitchRoll expected = null;
        YawPitchRoll actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
        actual = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
        actual = new YawPitchRoll((Orientation3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertRotationVectorGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertRotationVectorGeometricallyEquals";
        Class<Vector3DReadOnly> argumentsClass = Vector3DReadOnly.class;
        Vector3D expected = null;
        Vector3D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = new Vector3D((Tuple3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertTuple2DEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertTuple2DEquals";
        Class<Tuple2DReadOnly> argumentsClass = Tuple2DReadOnly.class;
        Vector2D expected = null;
        Vector2D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector2D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextVector2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector2D((Random)random);
        actual = EuclidCoreRandomTools.nextVector2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector2D((Random)random);
        actual = new Vector2D((Tuple2DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertPoint2DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertPoint2DGeometricallyEquals";
        Class<Point2DReadOnly> argumentsClass = Point2DReadOnly.class;
        Point2D expected = null;
        Point2D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint2D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextPoint2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint2D((Random)random);
        actual = EuclidCoreRandomTools.nextPoint2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint2D((Random)random);
        actual = new Point2D((Tuple2DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertVector2DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertVector2DGeometricallyEquals";
        Class<Vector2DReadOnly> argumentsClass = Vector2DReadOnly.class;
        Vector2D expected = null;
        Vector2D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector2D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextVector2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector2D((Random)random);
        actual = EuclidCoreRandomTools.nextVector2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector2D((Random)random);
        actual = new Vector2D((Tuple2DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertTuple3DEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertTuple3DEquals";
        Class<Tuple3DReadOnly> argumentsClass = Tuple3DReadOnly.class;
        Vector3D expected = null;
        Vector3D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = new Vector3D((Tuple3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertPoint3DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertPoint3DGeometricallyEquals";
        Class<Point3DReadOnly> argumentsClass = Point3DReadOnly.class;
        Point3D expected = null;
        Point3D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextPoint3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        actual = EuclidCoreRandomTools.nextPoint3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextPoint3D((Random)random);
        actual = new Point3D((Tuple3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertVector3DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertVector3DGeometricallyEquals";
        Class<Vector3DReadOnly> argumentsClass = Vector3DReadOnly.class;
        Vector3D expected = null;
        Vector3D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = EuclidCoreRandomTools.nextVector3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector3D((Random)random);
        actual = new Vector3D((Tuple3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertTuple4DEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertTuple4DEquals";
        Class<Tuple4DReadOnly> argumentsClass = Tuple4DReadOnly.class;
        Vector4D expected = null;
        Vector4D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector4D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextVector4D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector4D((Random)random);
        actual = EuclidCoreRandomTools.nextVector4D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector4D((Random)random);
        actual = new Vector4D((Tuple4DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertVector4DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertVector4DGeometricallyEquals";
        Class<Vector4DReadOnly> argumentsClass = Vector4DReadOnly.class;
        Vector4D expected = null;
        Vector4D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector4D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextVector4D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector4D((Random)random);
        actual = EuclidCoreRandomTools.nextVector4D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextVector4D((Random)random);
        actual = new Vector4D((Tuple4DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertMatrix3DEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertMatrix3DEquals";
        Class<Matrix3DReadOnly> argumentsClass = Matrix3DReadOnly.class;
        Matrix3D expected = null;
        Matrix3D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        actual = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextMatrix3D((Random)random);
        actual = new Matrix3D((Matrix3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertRotationMatrixGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertRotationMatrixGeometricallyEquals";
        Class<RotationMatrixReadOnly> argumentsClass = RotationMatrixReadOnly.class;
        RotationMatrix expected = null;
        RotationMatrix actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        actual = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
        actual = new RotationMatrix((RotationMatrixReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertQuaternionEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertQuaternionEquals";
        Class<QuaternionReadOnly> argumentsClass = QuaternionReadOnly.class;
        Quaternion expected = null;
        Quaternion actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextQuaternion((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
        actual = EuclidCoreRandomTools.nextQuaternion((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
        actual = new Quaternion((QuaternionReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertQuaternionGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertQuaternionGeometricallyEquals";
        Class<QuaternionReadOnly> argumentsClass = QuaternionReadOnly.class;
        Quaternion expected = null;
        Quaternion actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextQuaternion((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
        actual = EuclidCoreRandomTools.nextQuaternion((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextQuaternion((Random)random);
        actual = new Quaternion((QuaternionReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertAxisAngleEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertAxisAngleEquals";
        Class<AxisAngleReadOnly> argumentsClass = AxisAngleReadOnly.class;
        AxisAngle expected = null;
        AxisAngle actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        actual = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        actual = new AxisAngle((Orientation3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertAxisAngleGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertAxisAngleGeometricallyEquals";
        Class<AxisAngleReadOnly> argumentsClass = AxisAngleReadOnly.class;
        AxisAngle expected = null;
        AxisAngle actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        actual = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        actual = new AxisAngle((Orientation3DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertOrientation2DEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertOrientation2DEquals";
        Class<Orientation2DReadOnly> argumentsClass = Orientation2DReadOnly.class;
        Orientation2D expected = null;
        Orientation2D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextOrientation2D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextOrientation2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextOrientation2D((Random)random);
        actual = EuclidCoreRandomTools.nextOrientation2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextOrientation2D((Random)random);
        actual = new Orientation2D((Orientation2DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertOrientation2DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertOrientation2DGeometricallyEquals";
        Class<Orientation2DReadOnly> argumentsClass = Orientation2DReadOnly.class;
        Orientation2D expected = null;
        Orientation2D actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextOrientation2D((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextOrientation2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextOrientation2D((Random)random);
        actual = EuclidCoreRandomTools.nextOrientation2D((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextOrientation2D((Random)random);
        actual = new Orientation2D((Orientation2DReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertRigidBodyTransformEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertRigidBodyTransformEquals";
        Class<RigidBodyTransform> argumentsClass = RigidBodyTransform.class;
        RigidBodyTransform expected = null;
        RigidBodyTransform actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = new RigidBodyTransform((RigidBodyTransformReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertRigidBodyTransformGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertRigidBodyTransformGeometricallyEquals";
        Class<RigidBodyTransform> argumentsClass = RigidBodyTransform.class;
        RigidBodyTransform expected = null;
        RigidBodyTransform actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        actual = new RigidBodyTransform((RigidBodyTransformReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertQuaternionBasedTransformEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertQuaternionBasedTransformEquals";
        Class<QuaternionBasedTransform> argumentsClass = QuaternionBasedTransform.class;
        QuaternionBasedTransform expected = null;
        QuaternionBasedTransform actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        actual = new QuaternionBasedTransform((RigidBodyTransformReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertQuaternionBasedTransformGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertQuaternionBasedTransformGeometricallyEquals";
        Class<QuaternionBasedTransform> argumentsClass = QuaternionBasedTransform.class;
        QuaternionBasedTransform expected = null;
        QuaternionBasedTransform actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        actual = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
        actual = new QuaternionBasedTransform((RigidBodyTransformReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertAffineTransformEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertAffineTransformEquals";
        Class<AffineTransformReadOnly> argumentsClass = AffineTransformReadOnly.class;
        AffineTransform expected = null;
        AffineTransform actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        actual = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        actual = new AffineTransform((AffineTransformReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertAffineTransformGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        String methodName = "assertAffineTransformGeometricallyEquals";
        Class<AffineTransformReadOnly> argumentsClass = AffineTransformReadOnly.class;
        AffineTransform expected = null;
        AffineTransform actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        actual = null;
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        actual = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidCoreRandomTools.nextAffineTransform((Random)random);
        actual = new AffineTransform((AffineTransformReadOnly)expected);
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    private static void assertAssertionMethodsBehaveProperly(boolean failExpected, String methodName, Class<?> argumentsClass, Object expected, Object actual, double epsilon) throws Throwable {
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(EuclidCoreTestTools.class, failExpected, methodName, argumentsClass, expected, actual, epsilon);
    }

    public static void assertAssertionMethodsBehaveProperly(Class<?> assertionClassHolder, boolean failExpected, String methodName, Class<?> argumentsClass, Object expected, Object actual, double epsilon) throws Throwable {
        Method assertionMethod3;
        Method assertionMethod2;
        block17: {
            Method assertionMethod1 = assertionClassHolder.getMethod(methodName, argumentsClass, argumentsClass, Double.TYPE);
            assertionMethod2 = assertionClassHolder.getMethod(methodName, String.class, argumentsClass, argumentsClass, Double.TYPE);
            assertionMethod3 = assertionClassHolder.getMethod(methodName, String.class, argumentsClass, argumentsClass, Double.TYPE, String.class);
            try {
                try {
                    assertionMethod1.invoke(null, expected, actual, epsilon);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    EuclidCoreTestToolsTest.handleInvokationExceptions(methodName, e);
                }
                if (failExpected) {
                    EuclidCoreTestToolsTest.didNotThrowAssertionError();
                }
            }
            catch (AssertionError e) {
                if (failExpected) break block17;
                EuclidCoreTestToolsTest.unexpectedlyThrewAssertionError(e);
            }
        }
        try {
            try {
                assertionMethod2.invoke(null, MESSAGE_PREFIX, expected, actual, epsilon);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                EuclidCoreTestToolsTest.handleInvokationExceptions(methodName, e);
            }
            if (failExpected) {
                EuclidCoreTestToolsTest.didNotThrowAssertionError();
            }
        }
        catch (AssertionError e) {
            if (!failExpected) {
                EuclidCoreTestToolsTest.unexpectedlyThrewAssertionError(e);
            }
            Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().startsWith(MESSAGE_PREFIX));
        }
        try {
            try {
                assertionMethod3.invoke(null, MESSAGE_PREFIX, expected, actual, epsilon, FORMAT);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                EuclidCoreTestToolsTest.handleInvokationExceptions(methodName, e);
            }
            if (failExpected) {
                EuclidCoreTestToolsTest.didNotThrowAssertionError();
            }
        }
        catch (AssertionError e) {
            if (!failExpected) {
                EuclidCoreTestToolsTest.unexpectedlyThrewAssertionError(e);
            }
            Assertions.assertTrue((boolean)((Throwable)((Object)e)).getMessage().startsWith(MESSAGE_PREFIX));
        }
    }

    private static void handleInvokationExceptions(String methodName, Exception e) throws Throwable {
        if (e instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)e;
            if (invocationTargetException.getTargetException() instanceof AssertionError) {
                throw (AssertionError)((Object)invocationTargetException.getTargetException());
            }
            throw invocationTargetException.getTargetException();
        }
        throw e;
    }

    private static void unexpectedlyThrewAssertionError(AssertionError e) {
        Assertions.fail((String)("Should NOT have thrown an " + AssertionError.class.getSimpleName() + ": " + e));
    }

    private static void didNotThrowAssertionError() {
        Assertions.fail((String)("Should have thrown an " + AssertionError.class.getSimpleName()));
    }
}

