/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.convexPolytope.tools;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeConstructionTools;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.SymmetricEigenDecomposition3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidPolytopeConstructionToolsTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testEigenVector() throws Exception {
        Random random = new Random(4535L);
        for (int i = 0; i < 1000; ++i) {
            double minX = 500.0;
            double maxX = 1000.0;
            double minY = 50.0;
            double maxY = 100.0;
            double minZ = 0.0;
            double maxZ = 25.0;
            int numberOfPoints = random.nextInt(1000) + 100;
            List points = IntStream.range(0, numberOfPoints).mapToObj(h -> EuclidCoreRandomTools.nextPoint3D((Random)random, (double)minX, (double)maxX, (double)minY, (double)maxY, (double)minZ, (double)maxZ)).collect(Collectors.toList());
            points.stream().filter(p -> random.nextBoolean()).forEach(Tuple3DBasics::negate);
            Matrix3D actualCovariance = new Matrix3D();
            EuclidPolytopeConstructionTools.computeCovariance3D(points, null, (Matrix3DBasics)actualCovariance);
            Vector3D actualNormal = new Vector3D(1.0, 1.0, 1.0);
            EuclidPolytopeConstructionTools.updateFace3DNormal((Matrix3DReadOnly)actualCovariance, (Vector3DBasics)actualNormal);
            Vector3D expectedNormal = new Vector3D((Tuple3DReadOnly)Axis3D.Z);
            String errorMessage = "Iteration" + i + ", nPoints: " + numberOfPoints + ", angle: " + expectedNormal.angle((Vector3DReadOnly)actualNormal);
            Assertions.assertTrue((boolean)EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)expectedNormal, (Vector3DReadOnly)actualNormal, (double)0.3), (String)errorMessage);
            actualNormal = new Vector3D(-1.0, -1.0, -1.0);
            EuclidPolytopeConstructionTools.updateFace3DNormal((SymmetricEigenDecomposition3D)new SymmetricEigenDecomposition3D(), (Matrix3DReadOnly)actualCovariance, (Vector3DBasics)actualNormal);
            expectedNormal.negate();
            errorMessage = "Iteration" + i + ", nPoints: " + numberOfPoints + ", angle: " + expectedNormal.angle((Vector3DReadOnly)actualNormal);
            Assertions.assertTrue((boolean)EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)expectedNormal, (Vector3DReadOnly)actualNormal, (double)0.3), (String)errorMessage);
        }
    }

    @Test
    public void testEigenVectorBug() throws Exception {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D expectedNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            List vertices = EuclidShapeRandomTools.nextCircleBasedConvexPolygon3D((Random)random, (double)5.0, (double)1.0, (int)15, (Vector3DReadOnly)expectedNormal);
            for (int j = 3; j <= vertices.size(); ++j) {
                Matrix3D actualCovariance = new Matrix3D();
                Vector3D actualNormal = new Vector3D((Tuple3DReadOnly)expectedNormal);
                EuclidPolytopeConstructionTools.computeCovariance3D(vertices.subList(0, j), null, (Matrix3DBasics)actualCovariance);
                EuclidPolytopeConstructionTools.updateFace3DNormal((SymmetricEigenDecomposition3D)new SymmetricEigenDecomposition3D(), (Matrix3DReadOnly)actualCovariance, (Vector3DBasics)actualNormal);
                String errorMessage = "Iteration" + i + ", nPoints: " + j + ", angle: " + expectedNormal.angle((Vector3DReadOnly)actualNormal);
                Assertions.assertTrue((boolean)EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)expectedNormal, (Vector3DReadOnly)actualNormal, (double)1.0E-5), (String)errorMessage);
            }
        }
    }

    @Test
    public void testEigenVectorBug2() throws Exception {
        Vector3D expectedNormal = new Vector3D(-0.7049187675308247, 0.4022247557105953, 0.5842129552452384);
        Matrix3D covariance = new Matrix3D(0.2991963714095545, 0.27863404057179947, 0.16917739943062554, 0.27863404057179947, 0.5887317541092697, -0.06913253316457282, 0.16917739943062554, -0.06913253316457282, 0.25172865278680445);
        Vector3D actualNormal = new Vector3D(-0.7049187675308248, 0.40222475571059535, 0.5842129552452384);
        Assertions.assertTrue((boolean)EuclidPolytopeConstructionTools.updateFace3DNormal((Matrix3DReadOnly)covariance, (Vector3DBasics)actualNormal));
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-12);
    }

    @Test
    public void testCovariance3D() {
        Random random = new Random(4524523L);
        for (int i = 0; i < 1000; ++i) {
            int numberOfPoints = random.nextInt(100) + 3;
            double maxAbsoluteX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0);
            double maxAbsoluteY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0);
            double maxAbsoluteZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)100.0);
            List points = IntStream.range(0, numberOfPoints).mapToObj(h -> EuclidCoreRandomTools.nextPoint3D((Random)random, (double)maxAbsoluteX, (double)maxAbsoluteY, (double)maxAbsoluteZ)).collect(Collectors.toList());
            Matrix3D actualCovariance = new Matrix3D();
            EuclidPolytopeConstructionTools.computeCovariance3D(points, null, (Matrix3DBasics)actualCovariance);
            Matrix3D expectedCovariance = EuclidPolytopeConstructionToolsTest.computeCovarianceMatrix(points);
            double maxValue = 1.0;
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    maxValue = Math.max(maxValue, Math.abs(expectedCovariance.getElement(row, column)));
                }
            }
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedCovariance, (Matrix3DReadOnly)new Matrix3D((Matrix3DReadOnly)actualCovariance), (double)(1.0E-12 * maxValue));
        }
    }

    @Test
    void testComputeConvexPolygon3DArea() throws Exception {
        List circleBasedConvexPolygon2D;
        int i;
        Random random = new Random(3534L);
        for (i = 0; i < 1000; ++i) {
            circleBasedConvexPolygon2D = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)5.0, (double)1.0, (int)20);
            List circleBasedConvexPolygon3D = circleBasedConvexPolygon2D.stream().map(Point3D::new).collect(Collectors.toList());
            Point2D centroid2D = new Point2D();
            double expectedArea = EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)circleBasedConvexPolygon2D, (int)circleBasedConvexPolygon2D.size(), (boolean)true, (Point2DBasics)centroid2D);
            Point3D expectedCentroid3D = new Point3D((Tuple2DReadOnly)centroid2D);
            Point3D actualCentroid3D = new Point3D();
            double actualArea = EuclidPolytopeConstructionTools.computeConvexPolygon3DArea(circleBasedConvexPolygon3D, (Vector3DReadOnly)Axis3D.Z, (int)circleBasedConvexPolygon3D.size(), (boolean)true, (Point3DBasics)actualCentroid3D);
            Assertions.assertEquals((double)expectedArea, (double)actualArea, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedCentroid3D, (Tuple3DReadOnly)actualCentroid3D, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            circleBasedConvexPolygon2D = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)5.0, (double)1.0, (int)20);
            Point2D centroid2D = new Point2D();
            double expectedArea = EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)circleBasedConvexPolygon2D, (int)circleBasedConvexPolygon2D.size(), (boolean)true, (Point2DBasics)centroid2D);
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Vector3D normal = new Vector3D();
            transform.getRotation().getColumn(2, (Tuple3DBasics)normal);
            List circleBasedConvexPolygon3D = circleBasedConvexPolygon2D.stream().map(Point3D::new).peek(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0)).collect(Collectors.toList());
            Point3D expectedCentroid3D = new Point3D((Tuple2DReadOnly)centroid2D);
            expectedCentroid3D.applyTransform((Transform)transform);
            Point3D actualCentroid3D = new Point3D();
            double actualArea = EuclidPolytopeConstructionTools.computeConvexPolygon3DArea(circleBasedConvexPolygon3D, (Vector3DReadOnly)normal, (int)circleBasedConvexPolygon3D.size(), (boolean)true, (Point3DBasics)actualCentroid3D);
            Assertions.assertEquals((double)expectedArea, (double)actualArea, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedCentroid3D, (Tuple3DReadOnly)actualCentroid3D, (double)1.0E-12);
        }
    }

    private static Matrix3D computeCovarianceMatrix(List<? extends Point3DReadOnly> dataset) {
        DMatrixRMaj covariance = new DMatrixRMaj(3, 3);
        int n = dataset.size();
        DMatrixRMaj datasetMatrix = new DMatrixRMaj(n, 3);
        Point3D average = EuclidGeometryTools.averagePoint3Ds(dataset);
        for (int i = 0; i < n; ++i) {
            Point3DReadOnly dataPoint = dataset.get(i);
            datasetMatrix.set(i, 0, dataPoint.getX() - average.getX());
            datasetMatrix.set(i, 1, dataPoint.getY() - average.getY());
            datasetMatrix.set(i, 2, dataPoint.getZ() - average.getZ());
        }
        CommonOps_DDRM.multInner((DMatrix1Row)datasetMatrix, (DMatrix1Row)covariance);
        CommonOps_DDRM.scale((double)(1.0 / (double)n), (DMatrixD1)covariance);
        return new Matrix3D((DMatrix)covariance);
    }
}

