/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame.tools;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.FrameVector4D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector4DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.tools.EuclidCoreTestToolsTest;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class EuclidFrameTestToolsTest {
    private static final double EPSILON = 1.0E-4;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @Test
    public void testAssertRotationFrameVectorGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((String)"frameA", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((String)"frameB", (Random)random, (ReferenceFrame)worldFrame);
        String methodName = "assertRotationFrameVectorGeometricallyEquals";
        Class<FrameVector3DReadOnly> argumentsClass = FrameVector3DReadOnly.class;
        FrameVector3D expected = null;
        FrameVector3D actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        actual = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector3D((FrameTuple3DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector3D(frameB, (Tuple3DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertFrameTuple2DEquals() throws Throwable {
        Random random = new Random(453453L);
        ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((String)"frameA", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((String)"frameB", (Random)random, (ReferenceFrame)worldFrame);
        String methodName = "assertFrameTuple2DEquals";
        Class<FrameTuple2DReadOnly> argumentsClass = FrameTuple2DReadOnly.class;
        FrameVector2D expected = null;
        FrameVector2D actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)frameA);
        actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)frameA);
        actual = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector2D((FrameTuple2DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector2D(frameB, (Tuple2DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertFramePoint2DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((String)"frameA", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((String)"frameB", (Random)random, (ReferenceFrame)worldFrame);
        String methodName = "assertFramePoint2DGeometricallyEquals";
        Class<FramePoint2DReadOnly> argumentsClass = FramePoint2DReadOnly.class;
        FramePoint2D expected = null;
        FramePoint2D actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)frameA);
        actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)frameA);
        actual = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)frameA);
        actual = new FramePoint2D((FrameTuple2DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)frameA);
        actual = new FramePoint2D(frameB, (Tuple2DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertFrameVector2DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((String)"frameA", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((String)"frameB", (Random)random, (ReferenceFrame)worldFrame);
        String methodName = "assertFrameVector2DGeometricallyEquals";
        Class<FrameVector2DReadOnly> argumentsClass = FrameVector2DReadOnly.class;
        FrameVector2D expected = null;
        FrameVector2D actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)frameA);
        actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)frameA);
        actual = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector2D((FrameTuple2DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector2D(frameB, (Tuple2DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertFrameTuple3DEquals() throws Throwable {
        Random random = new Random(453453L);
        ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((String)"frameA", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((String)"frameB", (Random)random, (ReferenceFrame)worldFrame);
        String methodName = "assertFrameTuple3DEquals";
        Class<FrameTuple3DReadOnly> argumentsClass = FrameTuple3DReadOnly.class;
        FrameVector3D expected = null;
        FrameVector3D actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        actual = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector3D((FrameTuple3DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector3D(frameB, (Tuple3DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertFramePoint3DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((String)"frameA", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((String)"frameB", (Random)random, (ReferenceFrame)worldFrame);
        String methodName = "assertFramePoint3DGeometricallyEquals";
        Class<FramePoint3DReadOnly> argumentsClass = FramePoint3DReadOnly.class;
        FramePoint3D expected = null;
        FramePoint3D actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)frameA);
        actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)frameA);
        actual = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)frameA);
        actual = new FramePoint3D((FrameTuple3DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)frameA);
        actual = new FramePoint3D(frameB, (Tuple3DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertFrameVector3DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((String)"frameA", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((String)"frameB", (Random)random, (ReferenceFrame)worldFrame);
        String methodName = "assertFrameVector3DGeometricallyEquals";
        Class<FrameVector3DReadOnly> argumentsClass = FrameVector3DReadOnly.class;
        FrameVector3D expected = null;
        FrameVector3D actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        actual = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector3D((FrameTuple3DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector3D(frameB, (Tuple3DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertFrameTuple4DEquals() throws Throwable {
        Random random = new Random(453453L);
        ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((String)"frameA", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((String)"frameB", (Random)random, (ReferenceFrame)worldFrame);
        String methodName = "assertFrameTuple4DEquals";
        Class<FrameTuple4DReadOnly> argumentsClass = FrameTuple4DReadOnly.class;
        FrameVector4D expected = null;
        FrameVector4D actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)frameA);
        actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)frameA);
        actual = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector4D((FrameTuple4DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector4D(frameB, (Tuple4DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertFrameVector4DGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((String)"frameA", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((String)"frameB", (Random)random, (ReferenceFrame)worldFrame);
        String methodName = "assertFrameVector4DGeometricallyEquals";
        Class<FrameVector4DReadOnly> argumentsClass = FrameVector4DReadOnly.class;
        FrameVector4D expected = null;
        FrameVector4D actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)frameA);
        actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)frameA);
        actual = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector4D((FrameTuple4DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameVector4D((Random)random, (ReferenceFrame)frameA);
        actual = new FrameVector4D(frameB, (Tuple4DReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    @Test
    public void testAssertFrameQuaternionGeometricallyEquals() throws Throwable {
        Random random = new Random(453453L);
        ReferenceFrame frameA = EuclidFrameRandomTools.nextReferenceFrame((String)"frameA", (Random)random, (ReferenceFrame)worldFrame);
        ReferenceFrame frameB = EuclidFrameRandomTools.nextReferenceFrame((String)"frameB", (Random)random, (ReferenceFrame)worldFrame);
        String methodName = "assertFrameQuaternionGeometricallyEquals";
        Class<FrameQuaternionReadOnly> argumentsClass = FrameQuaternionReadOnly.class;
        FrameQuaternion expected = null;
        FrameQuaternion actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)frameA);
        actual = null;
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = null;
        actual = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)frameA);
        actual = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)frameA);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)frameA);
        actual = new FrameQuaternion((FrameQuaternionReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(false, methodName, argumentsClass, expected, actual, 1.0E-4);
        expected = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)frameA);
        actual = new FrameQuaternion(frameB, (QuaternionReadOnly)expected);
        EuclidFrameTestToolsTest.assertAssertionMethodsBehaveProperly(true, methodName, argumentsClass, expected, actual, 1.0E-4);
    }

    private static void assertAssertionMethodsBehaveProperly(boolean failExpected, String methodName, Class<?> argumentsClass, Object expected, Object actual, double epsilon) throws Throwable {
        EuclidCoreTestToolsTest.assertAssertionMethodsBehaveProperly(EuclidFrameTestTools.class, failExpected, methodName, argumentsClass, expected, actual, epsilon);
    }
}

