/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.FrameYawPitchRoll;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.FrameTypeCopier;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.api.RandomFrameTypeBuilder;
import us.ihmc.euclid.referenceFrame.api.RandomFramelessTypeBuilder;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameYawPitchRollReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.YawPitchRollBasicsTest;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public class FrameYawPitchRollTest {
    public static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    public static final double EPSILON = 1.0E-10;

    @Test
    public void testConstructors() throws Exception {
        YawPitchRoll expectedYawPitchRoll;
        FrameYawPitchRoll frameYawPitchRoll;
        FrameYawPitchRoll frameYawPitchRoll2;
        YawPitchRoll randomYawPitchRoll;
        ReferenceFrame randomFrame;
        int i;
        Random random = new Random(435345L);
        FrameYawPitchRoll frameYawPitchRoll3 = new FrameYawPitchRoll();
        Assertions.assertTrue((frameYawPitchRoll3.getReferenceFrame() == worldFrame ? 1 : 0) != 0);
        Assertions.assertTrue((frameYawPitchRoll3.getYaw() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((frameYawPitchRoll3.getPitch() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((frameYawPitchRoll3.getRoll() == 0.0 ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameYawPitchRoll frameYawPitchRoll4 = new FrameYawPitchRoll(randomFrame);
            Assertions.assertTrue((frameYawPitchRoll4.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            Assertions.assertTrue((frameYawPitchRoll4.getYaw() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((frameYawPitchRoll4.getPitch() == 0.0 ? 1 : 0) != 0);
            Assertions.assertTrue((frameYawPitchRoll4.getRoll() == 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomYawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            double[] array = new double[4];
            randomYawPitchRoll.get(array);
            frameYawPitchRoll2 = new FrameYawPitchRoll(randomFrame, array);
            Assertions.assertTrue((frameYawPitchRoll2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)randomYawPitchRoll, (YawPitchRollReadOnly)frameYawPitchRoll2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameYawPitchRoll = new FrameYawPitchRoll(randomFrame, (Orientation3DReadOnly)(randomYawPitchRoll = EuclidCoreRandomTools.nextYawPitchRoll((Random)random)));
            Assertions.assertTrue((frameYawPitchRoll.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)randomYawPitchRoll, (YawPitchRollReadOnly)frameYawPitchRoll, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            RotationMatrix randomRotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            expectedYawPitchRoll = new YawPitchRoll((Orientation3DReadOnly)randomRotationMatrix);
            frameYawPitchRoll2 = new FrameYawPitchRoll(randomFrame, (Orientation3DReadOnly)randomRotationMatrix);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expectedYawPitchRoll, (YawPitchRollReadOnly)frameYawPitchRoll2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            AxisAngle randomAxisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            expectedYawPitchRoll = new YawPitchRoll((Orientation3DReadOnly)randomAxisAngle);
            frameYawPitchRoll2 = new FrameYawPitchRoll(randomFrame, (Orientation3DReadOnly)randomAxisAngle);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expectedYawPitchRoll, (YawPitchRollReadOnly)frameYawPitchRoll2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            Vector3D randomRotationVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            expectedYawPitchRoll = new YawPitchRoll((Vector3DReadOnly)randomRotationVector);
            frameYawPitchRoll2 = new FrameYawPitchRoll(randomFrame, (Vector3DReadOnly)randomRotationVector);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expectedYawPitchRoll, (YawPitchRollReadOnly)frameYawPitchRoll2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            YawPitchRoll expectedYawPitchRoll2 = new YawPitchRoll(yaw, pitch, roll);
            FrameYawPitchRoll frameYawPitchRoll5 = new FrameYawPitchRoll(randomFrame, yaw, pitch, roll);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expectedYawPitchRoll2, (YawPitchRollReadOnly)frameYawPitchRoll5, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameYawPitchRoll randomFrameYawPitchRoll = EuclidFrameRandomTools.nextFrameYawPitchRoll((Random)random, (ReferenceFrame)randomFrame);
            frameYawPitchRoll = new FrameYawPitchRoll((FrameYawPitchRollReadOnly)randomFrameYawPitchRoll);
            Assertions.assertTrue((frameYawPitchRoll.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)randomFrameYawPitchRoll, (YawPitchRollReadOnly)frameYawPitchRoll, (double)1.0E-10);
        }
    }

    @Test
    public void testMatchingFrame() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameYawPitchRoll, 10);
        Random random = new Random(3225L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            ReferenceFrame destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameYawPitchRoll expected = EuclidFrameRandomTools.nextFrameYawPitchRoll((Random)random, (ReferenceFrame)sourceFrame);
            FrameYawPitchRoll actual = EuclidFrameRandomTools.nextFrameYawPitchRoll((Random)random, (ReferenceFrame)destinationFrame);
            actual.setMatchingFrame((FrameOrientation3DReadOnly)expected);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertFrameYawPitchRollEquals((FrameYawPitchRollReadOnly)expected, (FrameYawPitchRollReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testSetIncludingFrame() throws Exception {
        YawPitchRoll yawPitchRoll;
        FrameYawPitchRoll frameYawPitchRoll;
        ReferenceFrame newFrame;
        YawPitchRoll yawPitchRoll2;
        FrameYawPitchRoll frameYawPitchRoll2;
        ReferenceFrame newFrame2;
        int i;
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("setIncludingFrame", new Class[]{FrameVector3DReadOnly.class}));
        signaturesToIgnore.add(new MethodSignature("setIncludingFrame", new Class[]{ReferenceFrame.class, Vector3DReadOnly.class}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetIncludingFramePreserveFunctionality(EuclidFrameRandomTools::nextFrameYawPitchRoll, methodFilter, 10);
        Random random = new Random(2342L);
        ReferenceFrame initialFrame = ReferenceFrame.getWorldFrame();
        for (i = 0; i < 1000; ++i) {
            AxisAngle orientation = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameYawPitchRoll2 = EuclidFrameRandomTools.nextFrameYawPitchRoll((Random)random, (ReferenceFrame)initialFrame);
            yawPitchRoll2 = new YawPitchRoll();
            Assertions.assertEquals((Object)initialFrame, (Object)frameYawPitchRoll2.getReferenceFrame());
            frameYawPitchRoll2.setIncludingFrame(newFrame2, (Orientation3DReadOnly)orientation);
            yawPitchRoll2.set((Orientation3DReadOnly)orientation);
            Assertions.assertEquals((Object)newFrame2, (Object)frameYawPitchRoll2.getReferenceFrame());
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)yawPitchRoll2, (YawPitchRollReadOnly)frameYawPitchRoll2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D rotationVector = EuclidCoreRandomTools.nextRotationVector((Random)random);
            newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameYawPitchRoll2 = EuclidFrameRandomTools.nextFrameYawPitchRoll((Random)random, (ReferenceFrame)initialFrame);
            yawPitchRoll2 = new YawPitchRoll();
            Assertions.assertEquals((Object)initialFrame, (Object)frameYawPitchRoll2.getReferenceFrame());
            frameYawPitchRoll2.setRotationVectorIncludingFrame(newFrame2, (Vector3DReadOnly)rotationVector);
            yawPitchRoll2.setRotationVector((Vector3DReadOnly)rotationVector);
            Assertions.assertEquals((Object)newFrame2, (Object)frameYawPitchRoll2.getReferenceFrame());
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)yawPitchRoll2, (YawPitchRollReadOnly)frameYawPitchRoll2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            ReferenceFrame newFrame3 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector3D rotationVector = new FrameVector3D(newFrame3, (Tuple3DReadOnly)EuclidCoreRandomTools.nextRotationVector((Random)random));
            frameYawPitchRoll2 = EuclidFrameRandomTools.nextFrameYawPitchRoll((Random)random, (ReferenceFrame)initialFrame);
            yawPitchRoll2 = new YawPitchRoll();
            Assertions.assertEquals((Object)initialFrame, (Object)frameYawPitchRoll2.getReferenceFrame());
            frameYawPitchRoll2.setRotationVectorIncludingFrame((FrameVector3DReadOnly)rotationVector);
            yawPitchRoll2.setRotationVector((Vector3DReadOnly)rotationVector);
            Assertions.assertEquals((Object)newFrame3, (Object)frameYawPitchRoll2.getReferenceFrame());
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)yawPitchRoll2, (YawPitchRollReadOnly)frameYawPitchRoll2, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double pitch = EuclidCoreRandomTools.nextDouble((Random)random, (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE);
            double roll = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameYawPitchRoll = EuclidFrameRandomTools.nextFrameYawPitchRoll((Random)random, (ReferenceFrame)initialFrame);
            yawPitchRoll = new YawPitchRoll();
            Assertions.assertEquals((Object)initialFrame, (Object)frameYawPitchRoll.getReferenceFrame());
            frameYawPitchRoll.setYawPitchRollIncludingFrame(newFrame, yaw, pitch, roll);
            yawPitchRoll.setYawPitchRoll(yaw, pitch, roll);
            Assertions.assertEquals((Object)newFrame, (Object)frameYawPitchRoll.getReferenceFrame());
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)yawPitchRoll, (YawPitchRollReadOnly)frameYawPitchRoll, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D eulerAngles = EuclidCoreRandomTools.nextRotationVector((Random)random);
            eulerAngles.setY(EuclidCoreTools.clamp((double)eulerAngles.getY(), (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE));
            newFrame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameYawPitchRoll frameYawPitchRoll3 = EuclidFrameRandomTools.nextFrameYawPitchRoll((Random)random, (ReferenceFrame)initialFrame);
            yawPitchRoll2 = new YawPitchRoll();
            Assertions.assertEquals((Object)initialFrame, (Object)frameYawPitchRoll3.getReferenceFrame());
            frameYawPitchRoll3.setEulerIncludingFrame(newFrame2, (Vector3DReadOnly)eulerAngles);
            yawPitchRoll2.setEuler((Vector3DReadOnly)eulerAngles);
            Assertions.assertEquals((Object)newFrame2, (Object)frameYawPitchRoll3.getReferenceFrame());
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)yawPitchRoll2, (YawPitchRollReadOnly)frameYawPitchRoll3, (double)1.0E-10);
        }
        for (i = 0; i < 1000; ++i) {
            double rotX = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            double rotY = EuclidCoreRandomTools.nextDouble((Random)random, (double)YawPitchRollConversion.MAX_SAFE_PITCH_ANGLE);
            double rotZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
            newFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            frameYawPitchRoll = EuclidFrameRandomTools.nextFrameYawPitchRoll((Random)random, (ReferenceFrame)initialFrame);
            yawPitchRoll = new YawPitchRoll();
            Assertions.assertEquals((Object)initialFrame, (Object)frameYawPitchRoll.getReferenceFrame());
            frameYawPitchRoll.setEulerIncludingFrame(newFrame, rotX, rotY, rotZ);
            yawPitchRoll.setEuler(rotX, rotY, rotZ);
            Assertions.assertEquals((Object)newFrame, (Object)frameYawPitchRoll.getReferenceFrame());
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)yawPitchRoll, (YawPitchRollReadOnly)frameYawPitchRoll, (double)1.0E-10);
        }
    }

    @Test
    public void testConsistencyWithYawPitchRoll() {
        FrameTypeCopier frameTypeBuilder = (frame, yawPitchRoll) -> new FrameYawPitchRoll(frame, (Orientation3DReadOnly)((YawPitchRollReadOnly)yawPitchRoll));
        RandomFramelessTypeBuilder framelessTypeBuilder = EuclidCoreRandomTools::nextYawPitchRoll;
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, framelessTypeBuilder, methodFilter, 10);
        RandomFramelessTypeBuilder frameless2DTypeBuilder = random -> new YawPitchRoll(EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), 0.0, 0.0);
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality(frameTypeBuilder, frameless2DTypeBuilder, methodFilter, 10);
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        Predicate<Method> methodFilter = m -> !m.getName().equals("equals") && !m.getName().equals("epsilonEquals");
        RandomFrameTypeBuilder frameTypeBuilder = EuclidFrameRandomTools::nextFrameYawPitchRoll;
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(frameTypeBuilder, methodFilter, 10);
        RandomFrameTypeBuilder frame2DTypeBuilder = (random, frame) -> new FrameYawPitchRoll(frame, EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), 0.0, 0.0);
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(frame2DTypeBuilder, methodFilter, 10);
    }

    @Test
    public void testOverloading() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameOrientation3DReadOnly.class, Orientation3DReadOnly.class, true);
        tester.assertOverloadingWithFrameObjects(FrameOrientation3DBasics.class, Orientation3DBasics.class, true);
        tester.assertOverloadingWithFrameObjects(FrameYawPitchRollReadOnly.class, YawPitchRollReadOnly.class, true);
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{YawPitchRoll.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{YawPitchRoll.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{YawPitchRoll.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        tester.assertOverloadingWithFrameObjects(FrameYawPitchRoll.class, YawPitchRoll.class, true, 1, methodFilter);
    }

    @Test
    public void testChangeFrame() throws Exception {
        Random random = new Random(43563L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            YawPitchRoll expected = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            FrameYawPitchRoll yawPitchRoll = new FrameYawPitchRoll(initialFrame, (Orientation3DReadOnly)expected);
            RigidBodyTransform transform = initialFrame.getTransformToDesiredFrame(anotherFrame);
            expected.applyTransform((Transform)transform);
            yawPitchRoll.changeFrame(anotherFrame);
            Assertions.assertTrue((anotherFrame == yawPitchRoll.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertYawPitchRollGeometricallyEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)yawPitchRoll, (double)1.0E-10);
            ReferenceFrame differentRootFrame = ReferenceFrameTools.constructARootFrame((String)"anotherRootFrame");
            try {
                yawPitchRoll.changeFrame(differentRootFrame);
                Assertions.fail((String)"Should have thrown a RuntimeException");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSet() throws Exception {
        Random random = new Random(3452L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            YawPitchRoll expected = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            int initialFrameIndex = random.nextInt(referenceFrames.length);
            ReferenceFrame initialFrame = referenceFrames[initialFrameIndex];
            FrameYawPitchRoll actual = EuclidFrameRandomTools.nextFrameYawPitchRoll((Random)random, (ReferenceFrame)initialFrame);
            Assertions.assertFalse((boolean)expected.epsilonEquals((YawPitchRollReadOnly)actual, 1.0E-10));
            actual.set(initialFrame, (YawPitchRollReadOnly)expected);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)1.0E-10);
            Assertions.assertEquals((Object)initialFrame, (Object)actual.getReferenceFrame());
            actual.set((YawPitchRollReadOnly)EuclidCoreRandomTools.nextYawPitchRoll((Random)random));
            Assertions.assertFalse((boolean)expected.epsilonEquals((YawPitchRollReadOnly)actual, 1.0E-10));
            expected.set((YawPitchRollReadOnly)actual);
            int differenceFrameIndex = initialFrameIndex + random.nextInt(referenceFrames.length - 1) + 1;
            ReferenceFrame differentFrame = referenceFrames[differenceFrameIndex %= referenceFrames.length];
            try {
                actual.set(differentFrame, (YawPitchRollReadOnly)EuclidCoreRandomTools.nextYawPitchRoll((Random)random));
                Assertions.fail((String)"Should have thrown a ReferenceFrameMismatchException");
                continue;
            }
            catch (ReferenceFrameMismatchException e) {
                EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)1.0E-10);
            }
        }
    }

    @Test
    public void testSetFromReferenceFrame() throws Exception {
        Random random = new Random(6572L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            FrameYawPitchRoll expected = new FrameYawPitchRoll(anotherFrame);
            expected.changeFrame(initialFrame);
            FrameYawPitchRoll actual = EuclidFrameRandomTools.nextFrameYawPitchRoll((Random)random, (ReferenceFrame)initialFrame);
            actual.setFromReferenceFrame(anotherFrame);
            Assertions.assertTrue((initialFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertYawPitchRollEquals((YawPitchRollReadOnly)expected, (YawPitchRollReadOnly)actual, (double)1.0E-10);
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(32120L);
        for (int i = 0; i < 1000; ++i) {
            FrameYawPitchRoll frameYawPitchRoll1 = EuclidFrameRandomTools.nextFrameYawPitchRoll((Random)random, (ReferenceFrame)worldFrame);
            FrameYawPitchRoll frameYawPitchRoll2 = new FrameYawPitchRoll(worldFrame);
            double epsilon = random.nextDouble();
            AxisAngle axisAngleDiff = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), 0.99 * epsilon);
            YawPitchRoll difference = new YawPitchRoll((Orientation3DReadOnly)axisAngleDiff);
            frameYawPitchRoll2.set(frameYawPitchRoll1);
            frameYawPitchRoll2.append((Orientation3DReadOnly)difference);
            Assertions.assertTrue((boolean)frameYawPitchRoll1.geometricallyEquals(frameYawPitchRoll2, epsilon));
            axisAngleDiff = new AxisAngle((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0), 1.01 * epsilon);
            difference = new YawPitchRoll((Orientation3DReadOnly)axisAngleDiff);
            frameYawPitchRoll2.set(frameYawPitchRoll1);
            frameYawPitchRoll2.append((Orientation3DReadOnly)difference);
            Assertions.assertFalse((boolean)frameYawPitchRoll1.geometricallyEquals(frameYawPitchRoll2, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(763L);
        for (int i = 0; i < 1000; ++i) {
            YawPitchRoll expected = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            FrameYawPitchRoll actual = new FrameYawPitchRoll(null, (Orientation3DReadOnly)expected);
            Assertions.assertEquals((int)expected.hashCode(), (int)actual.hashCode());
        }
    }

    @Test
    public void testYawPitchRollBasicsFeatures() throws Exception {
        YawPitchRollBasicsTest<FrameYawPitchRoll> yawPitchRollBasicsTest = new YawPitchRollBasicsTest<FrameYawPitchRoll>(){

            @Override
            public FrameYawPitchRoll createEmptyYawPitchRoll() {
                return new FrameYawPitchRoll(worldFrame);
            }

            @Override
            public FrameYawPitchRoll createRandomYawPitchRoll(Random random) {
                return EuclidFrameRandomTools.nextFrameYawPitchRoll((Random)random, (ReferenceFrame)worldFrame);
            }

            @Override
            public FrameYawPitchRoll createYawPitchRoll(double yaw, double pitch, double roll) {
                return new FrameYawPitchRoll(worldFrame, yaw, pitch, roll);
            }

            @Override
            public FrameYawPitchRoll createYawPitchRoll(Orientation3DReadOnly orientation3DReadOnly) {
                return new FrameYawPitchRoll(worldFrame, orientation3DReadOnly);
            }

            @Override
            public double getSmallestEpsilon() {
                return 1.0E-15;
            }

            @Override
            public double getEpsilon() {
                return 1.0E-10;
            }
        };
        for (Method testMethod : yawPitchRollBasicsTest.getClass().getMethods()) {
            if (!testMethod.getName().startsWith("test") || !Modifier.isPublic(testMethod.getModifiers()) || Modifier.isStatic(testMethod.getModifiers())) continue;
            testMethod.invoke((Object)yawPitchRollBasicsTest, new Object[0]);
        }
    }
}

