/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;

public abstract class Pose3DBasicsTest<T extends Pose3DBasics> {
    private static final double EPSILON = 1.0E-7;

    public abstract T createEmptyPose3D();

    public abstract T createRandomPose3D(Random var1);

    public T copy(Pose3DReadOnly source) {
        T copy = this.createEmptyPose3D();
        copy.set(source);
        return copy;
    }

    @Test
    public void testSetToNaN() {
        Random random = new Random(70324L);
        for (int i = 0; i < 1000; ++i) {
            T toSet = this.createRandomPose3D(random);
            toSet.setToNaN();
            Assertions.assertEquals((double)Double.NaN, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)Double.NaN, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)Double.NaN, (double)toSet.getZ(), (double)1.0E-7);
            Assertions.assertEquals((double)Double.NaN, (double)toSet.getYaw(), (double)1.0E-7);
            Assertions.assertEquals((double)Double.NaN, (double)toSet.getPitch(), (double)1.0E-7);
            Assertions.assertEquals((double)Double.NaN, (double)toSet.getRoll(), (double)1.0E-7);
        }
    }

    @Test
    public void testSetToZero() {
        Random random = new Random(70924L);
        for (int i = 0; i < 1000; ++i) {
            T toSet = this.createRandomPose3D(random);
            toSet.setToZero();
            Assertions.assertEquals((double)0.0, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)toSet.getZ(), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)toSet.getYaw(), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)toSet.getPitch(), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)toSet.getRoll(), (double)1.0E-7);
        }
    }

    @Test
    public void testSetComponents() {
        Random random = new Random(71484L);
        for (int i = 0; i < 1000; ++i) {
            double x = random.nextDouble() - random.nextDouble();
            double y = random.nextDouble() - random.nextDouble();
            double z = random.nextDouble() - random.nextDouble();
            T toSet = this.createRandomPose3D(random);
            Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            toSet.setX(x);
            toSet.setY(y);
            toSet.setZ(z);
            toSet.setOrientation((Orientation3DReadOnly)quaternion);
            Assertions.assertEquals((double)x, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)z, (double)toSet.getZ(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getYaw(), (double)toSet.getYaw(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getPitch(), (double)toSet.getPitch(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getRoll(), (double)toSet.getRoll(), (double)1.0E-7);
            toSet = this.createRandomPose3D(random);
            AxisAngle aa = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            toSet.setPosition(x, y, z);
            toSet.setOrientation((Orientation3DReadOnly)aa);
            Assertions.assertEquals((double)x, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)z, (double)toSet.getZ(), (double)1.0E-7);
            Assertions.assertEquals((double)aa.getYaw(), (double)toSet.getYaw(), (double)1.0E-7);
            Assertions.assertEquals((double)aa.getPitch(), (double)toSet.getPitch(), (double)1.0E-7);
            Assertions.assertEquals((double)aa.getRoll(), (double)toSet.getRoll(), (double)1.0E-7);
            toSet = this.createRandomPose3D(random);
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            toSet.set(x, y, z, quaternion.getYaw(), quaternion.getPitch(), quaternion.getRoll());
            Assertions.assertEquals((double)x, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)z, (double)toSet.getZ(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getYaw(), (double)toSet.getYaw(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getPitch(), (double)toSet.getPitch(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getRoll(), (double)toSet.getRoll(), (double)1.0E-7);
            toSet = this.createRandomPose3D(random);
            Vector3D tuple = new Vector3D(x, y, z);
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            toSet.set((Tuple3DReadOnly)tuple, (Orientation3DReadOnly)quaternion);
            Assertions.assertEquals((double)x, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)z, (double)toSet.getZ(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getYaw(), (double)toSet.getYaw(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getPitch(), (double)toSet.getPitch(), (double)1.0E-7);
            Assertions.assertEquals((double)quaternion.getRoll(), (double)toSet.getRoll(), (double)1.0E-7);
            toSet = this.createRandomPose3D(random);
            RotationMatrix rot = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            toSet.setPosition((Tuple3DReadOnly)tuple);
            toSet.setOrientation((Orientation3DReadOnly)rot);
            Assertions.assertEquals((double)x, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)z, (double)toSet.getZ(), (double)1.0E-7);
            Assertions.assertEquals((double)rot.getYaw(), (double)toSet.getYaw(), (double)1.0E-7);
            Assertions.assertEquals((double)rot.getPitch(), (double)toSet.getPitch(), (double)1.0E-7);
            Assertions.assertEquals((double)rot.getRoll(), (double)toSet.getRoll(), (double)1.0E-7);
            toSet = this.createRandomPose3D(random);
            YawPitchRoll ypr = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
            T toCopy = this.createEmptyPose3D();
            toCopy.setPosition(x, y, z);
            toCopy.setOrientationYawPitchRoll(ypr.getYaw(), ypr.getPitch(), ypr.getRoll());
            Assertions.assertEquals((double)ypr.getYaw(), (double)toCopy.getYaw(), (double)1.0E-7);
            Assertions.assertEquals((double)ypr.getPitch(), (double)toCopy.getPitch(), (double)1.0E-7);
            Assertions.assertEquals((double)ypr.getRoll(), (double)toCopy.getRoll(), (double)1.0E-7);
            toSet.set(toCopy);
            Assertions.assertEquals((double)x, (double)toSet.getX(), (double)1.0E-7);
            Assertions.assertEquals((double)y, (double)toSet.getY(), (double)1.0E-7);
            Assertions.assertEquals((double)z, (double)toSet.getZ(), (double)1.0E-7);
            Assertions.assertEquals((double)ypr.getYaw(), (double)toSet.getYaw(), (double)1.0E-7);
            Assertions.assertEquals((double)ypr.getPitch(), (double)toSet.getPitch(), (double)1.0E-7);
            Assertions.assertEquals((double)ypr.getRoll(), (double)toSet.getRoll(), (double)1.0E-7);
        }
    }

    @Test
    public void testPointDistance() {
        Random random = new Random(41133L);
        for (int i = 0; i < 1000; ++i) {
            T firstPose = this.createRandomPose3D(random);
            T secondPose = this.copy((Pose3DReadOnly)firstPose);
            Vector3D translation = EuclidCoreRandomTools.nextVector3D((Random)random);
            double length = translation.length();
            secondPose.appendTranslation((Tuple3DReadOnly)translation);
            Assertions.assertEquals((double)length, (double)firstPose.getPositionDistance(secondPose), (double)1.0E-7);
            Point3D point = new Point3D();
            point.set((Tuple3DReadOnly)firstPose.getPosition());
            point.add((Tuple3DReadOnly)translation);
            Assertions.assertEquals((double)length, (double)firstPose.getPositionDistance((Point3DReadOnly)point), (double)1.0E-7);
        }
    }

    @Test
    public void testEquals() {
        int i;
        Random random = new Random(9827L);
        double x = random.nextDouble() - random.nextDouble();
        double y = random.nextDouble() - random.nextDouble();
        double z = random.nextDouble() - random.nextDouble();
        Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Vector3D normal = new Vector3D();
        T firstPose = this.createEmptyPose3D();
        firstPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
        T secondPose = this.copy((Pose3DReadOnly)firstPose);
        Assertions.assertTrue((boolean)firstPose.equals(secondPose));
        Assertions.assertTrue((boolean)secondPose.equals(secondPose));
        Assertions.assertTrue((boolean)firstPose.equals(firstPose));
        Assertions.assertTrue((boolean)secondPose.equals(secondPose));
        for (i = 0; i < 1000; ++i) {
            x = random.nextDouble() - random.nextDouble();
            y = random.nextDouble() - random.nextDouble();
            z = random.nextDouble() - random.nextDouble();
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            firstPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
            secondPose.set(firstPose);
            Vector3D translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0E-7);
            secondPose.appendTranslation((Tuple3DReadOnly)translation);
            Assertions.assertFalse((boolean)firstPose.equals(secondPose));
        }
        for (i = 0; i < 1000; ++i) {
            x = random.nextDouble() - random.nextDouble();
            y = random.nextDouble() - random.nextDouble();
            z = random.nextDouble() - random.nextDouble();
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            firstPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
            quaternion.getRotationVector((Vector3DBasics)normal);
            Vector3D orthogonal = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normal, (boolean)true);
            normal.applyTransform((Transform)new RigidBodyTransform((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)orthogonal, 1.0E-7), (Tuple3DReadOnly)new Vector3D()));
            secondPose.set(x, y, z, normal.angle((Vector3DReadOnly)Axis3D.Z), normal.angle((Vector3DReadOnly)Axis3D.Y), normal.angle((Vector3DReadOnly)Axis3D.X));
            Assertions.assertFalse((boolean)firstPose.equals(secondPose));
        }
    }

    @Test
    public void testEpsilonEquals() {
        int i;
        Random random = new Random(9827L);
        double x = random.nextDouble() - random.nextDouble();
        double y = random.nextDouble() - random.nextDouble();
        double z = random.nextDouble() - random.nextDouble();
        Quaternion quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
        T firstPose = this.createEmptyPose3D();
        firstPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
        T secondPose = this.copy((Pose3DReadOnly)firstPose);
        Assertions.assertTrue((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
        Assertions.assertTrue((boolean)secondPose.epsilonEquals(firstPose, 1.0E-7));
        Assertions.assertTrue((boolean)firstPose.epsilonEquals(firstPose, 1.0E-7));
        Assertions.assertTrue((boolean)secondPose.epsilonEquals(secondPose, 1.0E-7));
        for (i = 0; i < 1000; ++i) {
            x = random.nextDouble() - random.nextDouble();
            y = random.nextDouble() - random.nextDouble();
            z = random.nextDouble() - random.nextDouble();
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            firstPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
            secondPose.set(firstPose);
            secondPose.setX(x + (double)(random.nextBoolean() ? 1 : -1) * 0.99 * 1.0E-7);
            Assertions.assertTrue((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            secondPose.set(firstPose);
            secondPose.setY(y + (double)(random.nextBoolean() ? 1 : -1) * 0.99 * 1.0E-7);
            Assertions.assertTrue((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            secondPose.set(firstPose);
            secondPose.setZ(z + (double)(random.nextBoolean() ? 1 : -1) * 0.99 * 1.0E-7);
            Assertions.assertTrue((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            secondPose.set(firstPose);
            secondPose.setX(x + (double)(random.nextBoolean() ? 1 : -1) * 1.01 * 1.0E-7);
            Assertions.assertFalse((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            secondPose.set(firstPose);
            secondPose.setY(y + (double)(random.nextBoolean() ? 1 : -1) * 1.01 * 1.0E-7);
            Assertions.assertFalse((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            secondPose.set(firstPose);
            secondPose.setZ(z + (double)(random.nextBoolean() ? 1 : -1) * 1.01 * 1.0E-7);
            Assertions.assertFalse((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
        }
        for (i = 0; i < 1000; ++i) {
            x = random.nextDouble() - random.nextDouble();
            y = random.nextDouble() - random.nextDouble();
            z = random.nextDouble() - random.nextDouble();
            quaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            double qx = quaternion.getX();
            double qy = quaternion.getY();
            double qz = quaternion.getZ();
            double qs = quaternion.getS();
            firstPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
            quaternion.setUnsafe(qx + (double)(random.nextBoolean() ? 1 : -1) * 0.99 * 1.0E-7, qy, qz, qs);
            secondPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
            Assertions.assertTrue((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            quaternion.setUnsafe(qx, qy + (double)(random.nextBoolean() ? 1 : -1) * 0.99 * 1.0E-7, qz, qs);
            secondPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
            Assertions.assertTrue((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            quaternion.setUnsafe(qx, qy, qz + (double)(random.nextBoolean() ? 1 : -1) * 0.99 * 1.0E-7, qs);
            secondPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
            Assertions.assertTrue((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            quaternion.setUnsafe(qx, qy, qz, qs + (double)(random.nextBoolean() ? 1 : -1) * 0.99 * 1.0E-7);
            secondPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
            Assertions.assertTrue((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            quaternion.setUnsafe(qx + (double)(random.nextBoolean() ? 1 : -1) * 1.01 * 1.0E-7, qy, qz, qs);
            secondPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
            Assertions.assertFalse((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            quaternion.setUnsafe(qx, qy + (double)(random.nextBoolean() ? 1 : -1) * 1.01 * 1.0E-7, qz, qs);
            secondPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
            Assertions.assertFalse((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            quaternion.setUnsafe(qx, qy, qz + (double)(random.nextBoolean() ? 1 : -1) * 1.01 * 1.0E-7, qs);
            secondPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
            Assertions.assertFalse((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
            quaternion.setUnsafe(qx, qy, qz, qs + (double)(random.nextBoolean() ? 1 : -1) * 1.01 * 1.0E-7);
            secondPose.set((Tuple3DReadOnly)new Point3D(x, y, z), (Orientation3DReadOnly)quaternion);
            Assertions.assertFalse((boolean)firstPose.epsilonEquals(secondPose, 1.0E-7));
        }
    }
}

