/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Tuple3DBasicsTest;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public abstract class Point3DBasicsTest<T extends Point3DBasics>
extends Tuple3DBasicsTest<T> {
    @Test
    public void testDistance() {
        Random random = new Random(654135L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            translation.scale(expectedDistance);
            Point3DBasics p1 = (Point3DBasics)this.createRandomTuple(random);
            Point3DBasics p2 = (Point3DBasics)this.createTuple(p1.getX() + translation.getX(), p1.getY() + translation.getY(), p1.getZ() + translation.getZ());
            double actualDistance = p1.distance((Point3DReadOnly)p2);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)this.getEpsilon());
        }
    }

    @Test
    public void testDistanceSquared() {
        Random random = new Random(654135L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            double expectedDistanceSquared = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            translation.scale(EuclidCoreTools.squareRoot((double)expectedDistanceSquared));
            Point3DBasics p1 = (Point3DBasics)this.createRandomTuple(random);
            Point3DBasics p2 = (Point3DBasics)this.createTuple(p1.getX() + translation.getX(), p1.getY() + translation.getY(), p1.getZ() + translation.getZ());
            double actualDistanceSquared = p1.distanceSquared((Point3DReadOnly)p2);
            Assertions.assertEquals((double)expectedDistanceSquared, (double)actualDistanceSquared, (double)this.getEpsilon());
        }
    }

    @Test
    public void testDistanceXY() {
        double actualDistance;
        Point3DBasics p2;
        Point3DBasics p1;
        double expectedDistance;
        Vector3D translation;
        int i;
        Random random = new Random(654135L);
        for (i = 0; i < 1000; ++i) {
            translation = EuclidCoreRandomTools.nextVector3D((Random)random);
            translation.setZ(0.0);
            translation.normalize();
            expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            translation.scale(expectedDistance);
            p1 = (Point3DBasics)this.createRandomTuple(random);
            p2 = (Point3DBasics)this.createTuple(p1.getX() + translation.getX(), p1.getY() + translation.getY(), p1.getZ() + random.nextDouble());
            actualDistance = p1.distanceXY((Point3DReadOnly)p2);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            translation = EuclidCoreRandomTools.nextVector3D((Random)random);
            translation.setZ(0.0);
            translation.normalize();
            expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            translation.scale(expectedDistance);
            p1 = (Point3DBasics)this.createRandomTuple(random);
            p2 = new Point2D(p1.getX() + translation.getX(), p1.getY() + translation.getY());
            actualDistance = p1.distanceXY((Point2DReadOnly)p2);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)this.getEpsilon());
        }
    }

    @Test
    public void testDistanceXYSquared() {
        double actualDistance;
        Point3DBasics p2;
        Point3DBasics p1;
        double expectedDistanceSquared;
        Vector3D translation;
        int i;
        Random random = new Random(65415L);
        for (i = 0; i < 1000; ++i) {
            translation = EuclidCoreRandomTools.nextVector3D((Random)random, (double)1.0, (double)2.0);
            translation.setZ(0.0);
            translation.normalize();
            expectedDistanceSquared = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
            translation.scale(EuclidCoreTools.squareRoot((double)expectedDistanceSquared));
            p1 = (Point3DBasics)this.createRandomTuple(random);
            p2 = (Point3DBasics)this.createTuple(p1.getX() + translation.getX(), p1.getY() + translation.getY(), p1.getZ() + random.nextDouble());
            actualDistance = p1.distanceXYSquared((Point3DReadOnly)p2);
            Assertions.assertEquals((double)expectedDistanceSquared, (double)actualDistance, (double)(10.0 * this.getEpsilon()));
        }
        for (i = 0; i < 1000; ++i) {
            translation = EuclidCoreRandomTools.nextVector3D((Random)random, (double)1.0, (double)2.0);
            translation.setZ(0.0);
            translation.normalize();
            expectedDistanceSquared = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
            translation.scale(EuclidCoreTools.squareRoot((double)expectedDistanceSquared));
            p1 = (Point3DBasics)this.createRandomTuple(random);
            p2 = new Point2D(p1.getX() + translation.getX(), p1.getY() + translation.getY());
            actualDistance = p1.distanceXYSquared((Point2DReadOnly)p2);
            Assertions.assertEquals((double)expectedDistanceSquared, (double)actualDistance, (double)this.getEpsilon());
        }
    }

    @Test
    public void testDistanceFromOrigin() throws Exception {
        Random random = new Random(654135L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            double expectedDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            translation.scale(expectedDistance);
            Point3DBasics p = (Point3DBasics)this.createTuple(translation.getX(), translation.getY(), translation.getZ());
            double actualDistance = p.distanceFromOrigin();
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)this.getEpsilon());
        }
    }

    @Test
    public void testDistanceFromOriginSquared() throws Exception {
        Random random = new Random(654135L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D translation = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            double expectedDistanceSquared = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            translation.scale(EuclidCoreTools.squareRoot((double)expectedDistanceSquared));
            Point3DBasics p = (Point3DBasics)this.createTuple(translation.getX(), translation.getY(), translation.getZ());
            double actualDistance = p.distanceFromOriginSquared();
            Assertions.assertEquals((double)expectedDistanceSquared, (double)actualDistance, (double)this.getEpsilon());
        }
    }

    @Test
    public void testApplyTransform() throws Exception {
        Point3DBasics actual;
        Point3DBasics expected;
        Point3DBasics original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = (Point3DBasics)this.createRandomTuple(random);
            expected = (Point3DBasics)this.createEmptyTuple();
            actual = (Point3DBasics)this.createEmptyTuple();
            expected.set((Tuple3DReadOnly)original);
            transform.transform(expected);
            actual.set((Tuple3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = (Point3DBasics)this.createRandomTuple(random);
            expected = (Point3DBasics)this.createEmptyTuple();
            actual = (Point3DBasics)this.createEmptyTuple();
            expected.set((Tuple3DReadOnly)original);
            transform.transform(expected);
            actual.set((Tuple3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            original = (Point3DBasics)this.createRandomTuple(random);
            expected = (Point3DBasics)this.createEmptyTuple();
            actual = (Point3DBasics)this.createEmptyTuple();
            expected.set((Tuple3DReadOnly)original);
            transform.transform(expected);
            actual.set((Tuple3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testApplyInverseTransform() throws Exception {
        Point3DBasics actual;
        Point3DBasics expected;
        Point3DBasics original;
        RigidBodyTransform transform;
        int i;
        Random random = new Random(23523L);
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            original = (Point3DBasics)this.createRandomTuple(random);
            expected = (Point3DBasics)this.createEmptyTuple();
            actual = (Point3DBasics)this.createEmptyTuple();
            expected.set((Tuple3DReadOnly)original);
            actual.set((Tuple3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextQuaternionBasedTransform((Random)random);
            original = (Point3DBasics)this.createRandomTuple(random);
            expected = (Point3DBasics)this.createEmptyTuple();
            actual = (Point3DBasics)this.createEmptyTuple();
            expected.set((Tuple3DReadOnly)original);
            actual.set((Tuple3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            transform = EuclidCoreRandomTools.nextNonSingularAffineTransform((Random)random);
            original = (Point3DBasics)this.createRandomTuple(random);
            expected = (Point3DBasics)this.createEmptyTuple();
            actual = (Point3DBasics)this.createEmptyTuple();
            expected.set((Tuple3DReadOnly)original);
            actual.set((Tuple3DReadOnly)original);
            actual.applyTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)this.getEpsilon());
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Point3D pointB;
            double epsilon = random.nextDouble();
            Point3D pointA = EuclidCoreRandomTools.nextPoint3D((Random)random);
            if (pointA.epsilonEquals((Tuple3DReadOnly)(pointB = EuclidCoreRandomTools.nextPoint3D((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)pointA.geometricallyEquals((Point3DReadOnly)pointB, EuclidCoreTools.squareRoot((double)3.0) * this.getEpsilon()));
            } else if (EuclidCoreTools.norm((double)(pointA.getX() - pointB.getX()), (double)(pointA.getY() - pointB.getY()), (double)(pointA.getZ() - pointB.getZ())) <= this.getEpsilon()) {
                Assertions.assertTrue((boolean)pointA.geometricallyEquals((Point3DReadOnly)pointB, this.getEpsilon()));
            } else {
                Assertions.assertFalse((boolean)pointA.geometricallyEquals((Point3DReadOnly)pointB, this.getEpsilon()));
            }
            pointA = EuclidCoreRandomTools.nextPoint3D((Random)random);
            pointB = new Point3D((Tuple3DReadOnly)pointA);
            Vector3D perturb = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(0.99 * epsilon));
            pointB.add((Tuple3DReadOnly)perturb);
            Assertions.assertTrue((boolean)pointA.geometricallyEquals((Point3DReadOnly)pointB, epsilon));
            pointB = new Point3D((Tuple3DReadOnly)pointA);
            perturb = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(1.01 * epsilon));
            pointB.add((Tuple3DReadOnly)perturb);
            Assertions.assertFalse((boolean)pointA.geometricallyEquals((Point3DReadOnly)pointB, epsilon));
        }
    }
}

