/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple2D.Point2DBasicsTest;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class Point2D32Test
extends Point2DBasicsTest<Point2D32> {
    @Test
    public void testPoint2D32() {
        int i;
        Random random = new Random(621541L);
        Point2D32 point = new Point2D32();
        Assertions.assertTrue((0.0f == point.getX32() ? 1 : 0) != 0);
        Assertions.assertTrue((0.0f == point.getY32() ? 1 : 0) != 0);
        for (i = 0; i < 1000; ++i) {
            float newY;
            float newX = random.nextFloat();
            Assertions.assertTrue((newX == (point = new Point2D32(newX, newY = random.nextFloat())).getX32() ? 1 : 0) != 0);
            Assertions.assertTrue((newY == point.getY32() ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            float[] randomPoint2D32Array = new float[]{random.nextFloat(), random.nextFloat()};
            float[] copyRandomPoint2D32Array = new float[]{randomPoint2D32Array[0], randomPoint2D32Array[1]};
            Point2D32 pointArray = new Point2D32(randomPoint2D32Array);
            Assertions.assertTrue((randomPoint2D32Array[0] == pointArray.getX32() ? 1 : 0) != 0);
            Assertions.assertTrue((randomPoint2D32Array[1] == pointArray.getY32() ? 1 : 0) != 0);
            Assertions.assertTrue((copyRandomPoint2D32Array[0] == randomPoint2D32Array[0] ? 1 : 0) != 0);
            Assertions.assertTrue((copyRandomPoint2D32Array[1] == randomPoint2D32Array[1] ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D32 point2 = EuclidCoreRandomTools.nextPoint2D32((Random)random);
            point = new Point2D32((Tuple2DReadOnly)point2);
            Assertions.assertTrue((point.getX32() == point2.getX32() ? 1 : 0) != 0);
            Assertions.assertTrue((point.getY32() == point2.getY32() ? 1 : 0) != 0);
        }
    }

    @Override
    public void testSetters() throws Exception {
        int i;
        super.testSetters();
        Random random = new Random(621541L);
        Point2D32 tuple1 = this.createEmptyTuple();
        for (i = 0; i < 1000; ++i) {
            float x = random.nextFloat();
            tuple1.setX(x);
            Assertions.assertEquals((double)tuple1.getX32(), (double)x, (double)this.getEpsilon());
        }
        for (i = 0; i < 1000; ++i) {
            float y = random.nextFloat();
            tuple1.setY(y);
            Assertions.assertEquals((double)tuple1.getY32(), (double)y, (double)this.getEpsilon());
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(621541L);
        Point2D32 point = EuclidCoreRandomTools.nextPoint2D32((Random)random);
        int newHashCode = point.hashCode();
        Assertions.assertEquals((int)newHashCode, (int)point.hashCode());
        int previousHashCode = point.hashCode();
        for (int i = 0; i < 1000; ++i) {
            point.setElement(i % 2, (double)random.nextFloat());
            newHashCode = point.hashCode();
            Assertions.assertNotEquals((int)newHashCode, (int)previousHashCode);
            previousHashCode = newHashCode;
        }
    }

    @Override
    @Test
    public void testGeometricallyEquals() throws Exception {
        super.testGeometricallyEquals();
        Random random = new Random(621541L);
        for (int i = 0; i < 100; ++i) {
            Point2D32 pointB;
            Point2D32 pointA = EuclidCoreRandomTools.nextPoint2D32((Random)random);
            if (pointA.geometricallyEquals((Point2DReadOnly)(pointB = EuclidCoreRandomTools.nextPoint2D32((Random)random)), this.getEpsilon())) {
                Assertions.assertTrue((boolean)pointA.geometricallyEquals(pointB, this.getEpsilon()));
                continue;
            }
            Assertions.assertFalse((boolean)pointA.geometricallyEquals(pointB, this.getEpsilon()));
        }
    }

    @Override
    public double getEpsilon() {
        return 1.0E-6;
    }

    @Override
    public Point2D32 createEmptyTuple() {
        return new Point2D32();
    }

    @Override
    public Point2D32 createTuple(double x, double y) {
        return new Point2D32((float)x, (float)y);
    }

    @Override
    public Point2D32 createRandomTuple(Random random) {
        return EuclidCoreRandomTools.nextPoint2D32((Random)random);
    }
}

