/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class TupleToolsTest {
    @Test
    public void testEpsilonEqualsTuple2D() throws Exception {
        Random random = new Random(621541L);
        Point2D tuple1 = new Point2D();
        Point2D tuple2 = new Point2D();
        double epsilon = random.nextDouble();
        tuple1.setX(random.nextDouble());
        tuple1.setY(random.nextDouble());
        tuple2.setX(tuple1.getX() + 0.1 * epsilon);
        tuple2.setY(tuple1.getY() + 0.1 * epsilon);
        Assertions.assertTrue((boolean)TupleTools.epsilonEquals((Tuple2DReadOnly)tuple1, (Tuple2DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - 0.1 * epsilon);
        tuple2.setY(tuple1.getY() - 0.1 * epsilon);
        Assertions.assertTrue((boolean)TupleTools.epsilonEquals((Tuple2DReadOnly)tuple1, (Tuple2DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - 1.1 * epsilon);
        tuple2.setY(tuple1.getY() - 0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple2DReadOnly)tuple1, (Tuple2DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - 0.1 * epsilon);
        tuple2.setY(tuple1.getY() - 1.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple2DReadOnly)tuple1, (Tuple2DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() + 1.1 * epsilon);
        tuple2.setY(tuple1.getY() + 0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple2DReadOnly)tuple1, (Tuple2DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() + 0.1 * epsilon);
        tuple2.setY(tuple1.getY() + 1.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple2DReadOnly)tuple1, (Tuple2DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() + epsilon);
        tuple2.setY(tuple1.getY() + epsilon);
        Assertions.assertTrue((boolean)TupleTools.epsilonEquals((Tuple2DReadOnly)tuple1, (Tuple2DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - epsilon);
        tuple2.setY(tuple1.getY() - epsilon);
        Assertions.assertTrue((boolean)TupleTools.epsilonEquals((Tuple2DReadOnly)tuple1, (Tuple2DReadOnly)tuple2, (double)epsilon));
    }

    @Test
    public void testEpsilonEqualsTuple3D() throws Exception {
        Random random = new Random(621541L);
        Point3D tuple1 = new Point3D();
        Point3D tuple2 = new Point3D();
        double epsilon = random.nextDouble();
        tuple1.setX(random.nextDouble());
        tuple1.setY(random.nextDouble());
        tuple1.setZ(random.nextDouble());
        tuple2.setX(tuple1.getX() + 0.1 * epsilon);
        tuple2.setY(tuple1.getY() + 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() + 0.1 * epsilon);
        Assertions.assertTrue((boolean)TupleTools.epsilonEquals((Tuple3DReadOnly)tuple1, (Tuple3DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - 0.1 * epsilon);
        tuple2.setY(tuple1.getY() - 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() - 0.1 * epsilon);
        Assertions.assertTrue((boolean)TupleTools.epsilonEquals((Tuple3DReadOnly)tuple1, (Tuple3DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - 1.1 * epsilon);
        tuple2.setY(tuple1.getY() - 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() - 0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple3DReadOnly)tuple1, (Tuple3DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - 0.1 * epsilon);
        tuple2.setY(tuple1.getY() - 1.1 * epsilon);
        tuple2.setZ(tuple1.getZ() - 0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple3DReadOnly)tuple1, (Tuple3DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - 0.1 * epsilon);
        tuple2.setY(tuple1.getY() - 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() - 1.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple3DReadOnly)tuple1, (Tuple3DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() + 1.1 * epsilon);
        tuple2.setY(tuple1.getY() + 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() + 0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple3DReadOnly)tuple1, (Tuple3DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() + 0.1 * epsilon);
        tuple2.setY(tuple1.getY() + 1.1 * epsilon);
        tuple2.setZ(tuple1.getZ() + 0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple3DReadOnly)tuple1, (Tuple3DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() + 0.1 * epsilon);
        tuple2.setY(tuple1.getY() + 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() + 1.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple3DReadOnly)tuple1, (Tuple3DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() + epsilon);
        tuple2.setY(tuple1.getY() + epsilon);
        tuple2.setZ(tuple1.getZ() + epsilon);
        Assertions.assertTrue((boolean)TupleTools.epsilonEquals((Tuple3DReadOnly)tuple1, (Tuple3DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - epsilon);
        tuple2.setY(tuple1.getY() - epsilon);
        tuple2.setZ(tuple1.getZ() - epsilon);
        Assertions.assertTrue((boolean)TupleTools.epsilonEquals((Tuple3DReadOnly)tuple1, (Tuple3DReadOnly)tuple2, (double)epsilon));
    }

    @Test
    public void testEpsilonEqualsTuple4D() throws Exception {
        Random random = new Random(621541L);
        Vector4D tuple1 = new Vector4D();
        Vector4D tuple2 = new Vector4D();
        double epsilon = random.nextDouble();
        tuple1.setX(random.nextDouble());
        tuple1.setY(random.nextDouble());
        tuple1.setZ(random.nextDouble());
        tuple1.setS(random.nextDouble());
        tuple2.setX(tuple1.getX() + 0.1 * epsilon);
        tuple2.setY(tuple1.getY() + 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() + 0.1 * epsilon);
        tuple2.setS(tuple1.getS() + 0.1 * epsilon);
        Assertions.assertTrue((boolean)TupleTools.epsilonEquals((Tuple4DReadOnly)tuple1, (Tuple4DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - 0.1 * epsilon);
        tuple2.setY(tuple1.getY() - 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() - 0.1 * epsilon);
        tuple2.setS(tuple1.getS() - 0.1 * epsilon);
        Assertions.assertTrue((boolean)TupleTools.epsilonEquals((Tuple4DReadOnly)tuple1, (Tuple4DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - 1.1 * epsilon);
        tuple2.setY(tuple1.getY() - 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() - 0.1 * epsilon);
        tuple2.setS(tuple1.getS() - 0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple4DReadOnly)tuple1, (Tuple4DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - 0.1 * epsilon);
        tuple2.setY(tuple1.getY() - 1.1 * epsilon);
        tuple2.setZ(tuple1.getZ() - 0.1 * epsilon);
        tuple2.setS(tuple1.getS() - 0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple4DReadOnly)tuple1, (Tuple4DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - 0.1 * epsilon);
        tuple2.setY(tuple1.getY() - 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() - 1.1 * epsilon);
        tuple2.setS(tuple1.getS() - 0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple4DReadOnly)tuple1, (Tuple4DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - 0.1 * epsilon);
        tuple2.setY(tuple1.getY() - 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() - 0.1 * epsilon);
        tuple2.setS(tuple1.getS() - 1.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple4DReadOnly)tuple1, (Tuple4DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() + 1.1 * epsilon);
        tuple2.setY(tuple1.getY() + 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() + 0.1 * epsilon);
        tuple2.setS(tuple1.getS() + 0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple4DReadOnly)tuple1, (Tuple4DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() + 0.1 * epsilon);
        tuple2.setY(tuple1.getY() + 1.1 * epsilon);
        tuple2.setZ(tuple1.getZ() + 0.1 * epsilon);
        tuple2.setS(tuple1.getS() + 0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple4DReadOnly)tuple1, (Tuple4DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() + 0.1 * epsilon);
        tuple2.setY(tuple1.getY() + 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() + 1.1 * epsilon);
        tuple2.setS(tuple1.getS() + 0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple4DReadOnly)tuple1, (Tuple4DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() + 0.1 * epsilon);
        tuple2.setY(tuple1.getY() + 0.1 * epsilon);
        tuple2.setZ(tuple1.getZ() + 0.1 * epsilon);
        tuple2.setS(tuple1.getS() + 1.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.epsilonEquals((Tuple4DReadOnly)tuple1, (Tuple4DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() + epsilon);
        tuple2.setY(tuple1.getY() + epsilon);
        tuple2.setZ(tuple1.getZ() + epsilon);
        tuple2.setS(tuple1.getZ() + epsilon);
        Assertions.assertTrue((boolean)TupleTools.epsilonEquals((Tuple4DReadOnly)tuple1, (Tuple4DReadOnly)tuple2, (double)epsilon));
        tuple2.setX(tuple1.getX() - epsilon);
        tuple2.setY(tuple1.getY() - epsilon);
        tuple2.setZ(tuple1.getZ() - epsilon);
        tuple2.setS(tuple1.getS() - epsilon);
        Assertions.assertTrue((boolean)TupleTools.epsilonEquals((Tuple4DReadOnly)tuple1, (Tuple4DReadOnly)tuple2, (double)epsilon));
    }

    @Test
    public void testIsTupleZero2D() throws Exception {
        Random random = new Random(621541L);
        Vector2D tuple = new Vector2D();
        double epsilon = random.nextDouble();
        tuple.setX(random.nextDouble());
        tuple.setY(random.nextDouble());
        tuple.setX(0.1 * epsilon);
        tuple.setY(0.1 * epsilon);
        Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple2DReadOnly)tuple, (double)epsilon));
        tuple.setX(-0.1 * epsilon);
        tuple.setY(-0.1 * epsilon);
        Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple2DReadOnly)tuple, (double)epsilon));
        tuple.setX(-1.1 * epsilon);
        tuple.setY(-0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple2DReadOnly)tuple, (double)epsilon));
        tuple.setX(-0.1 * epsilon);
        tuple.setY(-1.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple2DReadOnly)tuple, (double)epsilon));
        tuple.setX(1.1 * epsilon);
        tuple.setY(0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple2DReadOnly)tuple, (double)epsilon));
        tuple.setX(0.1 * epsilon);
        tuple.setY(1.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple2DReadOnly)tuple, (double)epsilon));
        tuple.setX(epsilon);
        tuple.setY(epsilon);
        Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple2DReadOnly)tuple, (double)epsilon));
        tuple.setX(-epsilon);
        tuple.setY(-epsilon);
        Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple2DReadOnly)tuple, (double)epsilon));
    }

    @Test
    public void testIsTupleZero3D() throws Exception {
        Random random = new Random(621541L);
        Vector3D tuple = new Vector3D();
        double epsilon = random.nextDouble();
        tuple.setX(random.nextDouble());
        tuple.setY(random.nextDouble());
        tuple.setZ(random.nextDouble());
        tuple.setX(0.1 * epsilon);
        tuple.setY(0.1 * epsilon);
        tuple.setZ(0.1 * epsilon);
        Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple3DReadOnly)tuple, (double)epsilon));
        tuple.setX(-0.1 * epsilon);
        tuple.setY(-0.1 * epsilon);
        tuple.setZ(-0.1 * epsilon);
        Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple3DReadOnly)tuple, (double)epsilon));
        tuple.setX(-1.1 * epsilon);
        tuple.setY(-0.1 * epsilon);
        tuple.setZ(-0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple3DReadOnly)tuple, (double)epsilon));
        tuple.setX(-0.1 * epsilon);
        tuple.setY(-1.1 * epsilon);
        tuple.setZ(-0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple3DReadOnly)tuple, (double)epsilon));
        tuple.setX(-0.1 * epsilon);
        tuple.setY(-0.1 * epsilon);
        tuple.setZ(-1.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple3DReadOnly)tuple, (double)epsilon));
        tuple.setX(1.1 * epsilon);
        tuple.setY(0.1 * epsilon);
        tuple.setZ(0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple3DReadOnly)tuple, (double)epsilon));
        tuple.setX(0.1 * epsilon);
        tuple.setY(1.1 * epsilon);
        tuple.setZ(0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple3DReadOnly)tuple, (double)epsilon));
        tuple.setX(0.1 * epsilon);
        tuple.setY(0.1 * epsilon);
        tuple.setZ(1.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple3DReadOnly)tuple, (double)epsilon));
        tuple.setX(epsilon);
        tuple.setY(epsilon);
        tuple.setZ(epsilon);
        Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple3DReadOnly)tuple, (double)epsilon));
        tuple.setX(-epsilon);
        tuple.setY(-epsilon);
        tuple.setZ(-epsilon);
        Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple3DReadOnly)tuple, (double)epsilon));
    }

    @Test
    public void testIsTupleZero4D() throws Exception {
        Random random = new Random(621541L);
        Vector4D tuple = new Vector4D();
        double epsilon = random.nextDouble();
        tuple.setX(random.nextDouble());
        tuple.setY(random.nextDouble());
        tuple.setZ(random.nextDouble());
        tuple.setS(random.nextDouble());
        tuple.setX(0.1 * epsilon);
        tuple.setY(0.1 * epsilon);
        tuple.setZ(0.1 * epsilon);
        tuple.setS(0.1 * epsilon);
        Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple4DReadOnly)tuple, (double)epsilon));
        tuple.setX(-0.1 * epsilon);
        tuple.setY(-0.1 * epsilon);
        tuple.setZ(-0.1 * epsilon);
        tuple.setS(-0.1 * epsilon);
        Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple4DReadOnly)tuple, (double)epsilon));
        tuple.setX(-1.1 * epsilon);
        tuple.setY(-0.1 * epsilon);
        tuple.setZ(-0.1 * epsilon);
        tuple.setS(-0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple4DReadOnly)tuple, (double)epsilon));
        tuple.setX(-0.1 * epsilon);
        tuple.setY(-1.1 * epsilon);
        tuple.setZ(-0.1 * epsilon);
        tuple.setS(-0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple4DReadOnly)tuple, (double)epsilon));
        tuple.setX(-0.1 * epsilon);
        tuple.setY(-0.1 * epsilon);
        tuple.setZ(-1.1 * epsilon);
        tuple.setS(-0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple4DReadOnly)tuple, (double)epsilon));
        tuple.setX(-0.1 * epsilon);
        tuple.setY(-0.1 * epsilon);
        tuple.setZ(-0.1 * epsilon);
        tuple.setS(-1.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple4DReadOnly)tuple, (double)epsilon));
        tuple.setX(1.1 * epsilon);
        tuple.setY(0.1 * epsilon);
        tuple.setZ(0.1 * epsilon);
        tuple.setS(0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple4DReadOnly)tuple, (double)epsilon));
        tuple.setX(0.1 * epsilon);
        tuple.setY(1.1 * epsilon);
        tuple.setZ(0.1 * epsilon);
        tuple.setS(0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple4DReadOnly)tuple, (double)epsilon));
        tuple.setX(0.1 * epsilon);
        tuple.setY(0.1 * epsilon);
        tuple.setZ(1.1 * epsilon);
        tuple.setS(0.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple4DReadOnly)tuple, (double)epsilon));
        tuple.setX(0.1 * epsilon);
        tuple.setY(0.1 * epsilon);
        tuple.setZ(0.1 * epsilon);
        tuple.setS(1.1 * epsilon);
        Assertions.assertFalse((boolean)TupleTools.isTupleZero((Tuple4DReadOnly)tuple, (double)epsilon));
        tuple.setX(epsilon);
        tuple.setY(epsilon);
        tuple.setZ(epsilon);
        tuple.setS(epsilon);
        Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple4DReadOnly)tuple, (double)epsilon));
        tuple.setX(-epsilon);
        tuple.setY(-epsilon);
        tuple.setZ(-epsilon);
        tuple.setS(-epsilon);
        Assertions.assertTrue((boolean)TupleTools.isTupleZero((Tuple4DReadOnly)tuple, (double)epsilon));
    }
}

