/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.AxisAngleTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class AxisAngleToolsTest {
    private static final double EPSILON = 1.0E-14;

    @Test
    public void testDistance() {
        int i;
        Random random = new Random(32434L);
        for (i = 0; i < 1000; ++i) {
            AxisAngle aa1 = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            AxisAngle aa2 = EuclidCoreRandomTools.nextAxisAngle((Random)random);
            Quaternion q1 = new Quaternion((Orientation3DReadOnly)aa1);
            Quaternion q2 = new Quaternion((Orientation3DReadOnly)aa2);
            double actualDistance = AxisAngleTools.distance((AxisAngleReadOnly)aa1, (AxisAngleReadOnly)aa2);
            double expectedDistance = q1.distance((QuaternionReadOnly)q2);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-14);
            Assertions.assertEquals((double)0.0, (double)aa1.distance((AxisAngleReadOnly)aa1), (double)1.0E-14);
        }
        for (i = 0; i < 1000; ++i) {
            Vector3D u1 = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)1.0));
            Vector3D u2 = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)1.0));
            AxisAngle aa1 = new AxisAngle((Vector3DReadOnly)u1, EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            AxisAngle aa2 = new AxisAngle((Vector3DReadOnly)u2, EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI));
            Quaternion q1 = new Quaternion((Orientation3DReadOnly)aa1);
            Quaternion q2 = new Quaternion((Orientation3DReadOnly)aa2);
            double actualDistance = AxisAngleTools.distance((AxisAngleReadOnly)aa1, (AxisAngleReadOnly)aa2);
            double expectedDistance = q1.distance((QuaternionReadOnly)q2);
            Assertions.assertEquals((double)expectedDistance, (double)actualDistance, (double)1.0E-14);
            Assertions.assertEquals((double)0.0, (double)aa1.distance((AxisAngleReadOnly)aa1), (double)1.0E-14);
        }
    }
}

