/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.shape.primitives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTestTools;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.shape.tools.EuclidShapeTestTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;

public class Box3DTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    void testConstructors() throws Exception {
        Box3D box3D;
        Pose3D pose;
        RotationMatrix orientation;
        Point3D position;
        double sizeZ;
        double sizeY;
        double sizeX;
        int i;
        Random random = new Random(34590376L);
        Box3D box3D2 = new Box3D();
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(1.0, 1.0, 1.0), (Tuple3DReadOnly)box3D2.getSize(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)box3D2.getPosition());
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)box3D2.getOrientation(), (double)1.0E-12);
        box3D2 = new Box3D();
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(1.0, 1.0, 1.0), (Tuple3DReadOnly)box3D2.getSize(), (double)1.0E-12);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)box3D2.getPosition());
        EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)box3D2.getOrientation(), (double)1.0E-12);
        for (i = 0; i < 1000; ++i) {
            sizeX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            Box3D box3D3 = new Box3D(sizeX, sizeY, sizeZ);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(sizeX, sizeY, sizeZ), (Tuple3DReadOnly)box3D3.getSize(), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)box3D3.getPosition());
            EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)box3D3.getOrientation(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            sizeX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            orientation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Box3D box3D4 = new Box3D((Point3DReadOnly)position, (Orientation3DReadOnly)orientation, sizeX, sizeY, sizeZ);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(sizeX, sizeY, sizeZ), (Tuple3DReadOnly)box3D4.getSize(), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)position, (Tuple3DReadOnly)box3D4.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)orientation, (Matrix3DReadOnly)box3D4.getOrientation(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            sizeX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            orientation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            pose = new Pose3D((Tuple3DReadOnly)position, (Orientation3DReadOnly)orientation);
            box3D = new Box3D((Pose3DReadOnly)pose, sizeX, sizeY, sizeZ);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(sizeX, sizeY, sizeZ), (Tuple3DReadOnly)box3D.getSize(), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)position, (Tuple3DReadOnly)box3D.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)orientation, (Matrix3DReadOnly)box3D.getOrientation(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            sizeX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            sizeZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            position = EuclidCoreRandomTools.nextPoint3D((Random)random);
            orientation = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            pose = new RigidBodyTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)position);
            box3D = new Box3D((RigidBodyTransformReadOnly)pose, sizeX, sizeY, sizeZ);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(sizeX, sizeY, sizeZ), (Tuple3DReadOnly)box3D.getSize(), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)position, (Tuple3DReadOnly)box3D.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)orientation, (Matrix3DReadOnly)box3D.getOrientation(), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            Box3D original = EuclidShapeRandomTools.nextBox3D((Random)random);
            Box3D copy = new Box3D((Box3DReadOnly)original);
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)original, (Box3DReadOnly)copy, (double)1.0E-12);
        }
    }

    @Test
    void testSetToNaN() throws Exception {
        Random random = new Random(34575754L);
        for (int i = 0; i < 1000; ++i) {
            Box3D box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            Assertions.assertFalse((boolean)box3D.containsNaN());
            Assertions.assertFalse((boolean)box3D.getPose().containsNaN());
            Assertions.assertFalse((boolean)box3D.getPosition().containsNaN());
            Assertions.assertFalse((boolean)box3D.getOrientation().containsNaN());
            Assertions.assertFalse((boolean)box3D.getSize().containsNaN());
            box3D.setToNaN();
            Assertions.assertTrue((boolean)box3D.containsNaN());
            Assertions.assertTrue((boolean)box3D.getPose().containsNaN());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)box3D.getPosition());
            EuclidCoreTestTools.assertMatrix3DContainsOnlyNaN((Matrix3DReadOnly)box3D.getOrientation());
            EuclidCoreTestTools.assertTuple3DContainsOnlyNaN((Tuple3DReadOnly)box3D.getSize());
        }
    }

    @Test
    void testSetToZero() throws Exception {
        Random random = new Random(34575754L);
        for (int i = 0; i < 1000; ++i) {
            Box3D box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((Tuple3DReadOnly)box3D.getPosition(), 1.0E-12));
            Assertions.assertFalse((boolean)new Point3D().epsilonEquals((Tuple3DReadOnly)box3D.getSize(), 1.0E-12));
            Assertions.assertFalse((boolean)new RotationMatrix().epsilonEquals((Matrix3DReadOnly)box3D.getOrientation(), 1.0E-12));
            box3D.setToZero();
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)box3D.getPosition());
            EuclidCoreTestTools.assertIdentity((Matrix3DReadOnly)box3D.getOrientation(), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)box3D.getSize());
        }
    }

    @Test
    void testSetters() throws Exception {
        Box3D actual;
        Box3D expected;
        int i;
        Random random = new Random(45837543L);
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextBox3D((Random)random);
            actual = EuclidShapeRandomTools.nextBox3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-12));
            actual.set(expected);
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)expected, (Box3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextBox3D((Random)random);
            actual = EuclidShapeRandomTools.nextBox3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-12));
            actual.set((Box3DReadOnly)expected);
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)expected, (Box3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextBox3D((Random)random);
            actual = EuclidShapeRandomTools.nextBox3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-12));
            actual.set((Point3DReadOnly)expected.getPosition(), (Orientation3DReadOnly)expected.getOrientation(), expected.getSizeX(), expected.getSizeY(), expected.getSizeZ());
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)expected, (Box3DReadOnly)actual, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().set((Point3DReadOnly)new Point3D(), (Orientation3DReadOnly)new Quaternion(), -0.1, 1.0, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().set((Point3DReadOnly)new Point3D(), (Orientation3DReadOnly)new Quaternion(), 1.0, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().set((Point3DReadOnly)new Point3D(), (Orientation3DReadOnly)new Quaternion(), 1.0, 1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextBox3D((Random)random);
            actual = EuclidShapeRandomTools.nextBox3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-12));
            actual.set((Pose3DReadOnly)new Pose3D((Tuple3DReadOnly)expected.getPosition(), (Orientation3DReadOnly)expected.getOrientation()), expected.getSizeX(), expected.getSizeY(), expected.getSizeZ());
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)expected, (Box3DReadOnly)actual, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().set((Pose3DReadOnly)new Pose3D(), -0.1, 1.0, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().set((Pose3DReadOnly)new Pose3D(), 1.0, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().set((Pose3DReadOnly)new Pose3D(), 1.0, 1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextBox3D((Random)random);
            actual = EuclidShapeRandomTools.nextBox3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-12));
            actual.set((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)expected.getOrientation(), (Tuple3DReadOnly)expected.getPosition()), expected.getSizeX(), expected.getSizeY(), expected.getSizeZ());
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)expected, (Box3DReadOnly)actual, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), -0.1, 1.0, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), 1.0, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), 1.0, 1.0, -0.1));
        for (i = 0; i < 1000; ++i) {
            expected = EuclidShapeRandomTools.nextBox3D((Random)random);
            actual = EuclidShapeRandomTools.nextBox3D((Random)random);
            Assertions.assertFalse((boolean)expected.epsilonEquals(actual, 1.0E-12));
            actual.set((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)expected.getOrientation(), (Tuple3DReadOnly)expected.getPosition()), new double[]{expected.getSizeX(), expected.getSizeY(), expected.getSizeZ()});
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)expected, (Box3DReadOnly)actual, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), new double[]{-0.1, 1.0, 1.0}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), new double[]{1.0, -0.1, 1.0}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().set((RigidBodyTransformReadOnly)new RigidBodyTransform(), new double[]{1.0, 1.0, -0.1}));
    }

    @Test
    void testSetSize() throws Exception {
        Random random = new Random(0x536566L);
        for (int i = 0; i < 1000; ++i) {
            double sizeX = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            double sizeY = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            double sizeZ = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)5.0);
            Box3D box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)sizeX, (double)box3D.getSizeX(), (double)1.0E-12));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)sizeY, (double)box3D.getSizeY(), (double)1.0E-12));
            Assertions.assertFalse((boolean)EuclidCoreTools.epsilonEquals((double)sizeZ, (double)box3D.getSizeZ(), (double)1.0E-12));
            box3D.getSize().set(sizeX, sizeY, sizeZ);
            Assertions.assertEquals((double)sizeX, (double)box3D.getSizeX(), (double)1.0E-12);
            Assertions.assertEquals((double)sizeY, (double)box3D.getSizeY(), (double)1.0E-12);
            Assertions.assertEquals((double)sizeZ, (double)box3D.getSizeZ(), (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().getSize().set(-0.1, 1.0, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().getSize().set(1.0, -0.1, 1.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().getSize().set(1.0, 1.0, -0.1));
    }

    @Test
    void testScale() throws Exception {
        Random random = new Random(405743L);
        for (int i = 0; i < 1000; ++i) {
            Box3D actual = EuclidShapeRandomTools.nextBox3D((Random)random);
            Box3D expected = new Box3D((Box3DReadOnly)actual);
            Vector3D size = new Vector3D((Tuple3DReadOnly)actual.getSize());
            double scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            actual.scale(scale);
            size.scale(scale);
            expected.getSize().set((Tuple3DReadOnly)size);
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)expected, (Box3DReadOnly)actual, (double)1.0E-12);
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Box3D().scale(-0.1));
    }

    @Test
    void testIsPointInside() throws Exception {
        double xSign;
        double zSign;
        double ySign;
        Point3D pointOutside;
        double sizeZ;
        double sizeY;
        Point3D pointInside;
        Box3D box3D;
        int i;
        Random random = new Random(435635675L);
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Point3DReadOnly[])box3D.getVertices());
            Assertions.assertTrue((boolean)box3D.isPointInside((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            pointInside = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)(0.5 * box3D.getSizeX()), (double)(0.5 * box3D.getSizeY()), (double)(0.5 * box3D.getSizeZ()));
            box3D.transformToWorld((Transformable)pointInside);
            Assertions.assertTrue((boolean)box3D.isPointInside((Point3DReadOnly)pointInside));
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            double sizeX = box3D.getSizeX();
            sizeY = box3D.getSizeY();
            sizeZ = box3D.getSizeZ();
            pointOutside = new Point3D();
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeX, EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeY)), EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeZ)));
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)box3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.set(-EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeX, EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeY)), EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeZ)));
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)box3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeX)), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeY, EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeZ)));
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)box3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeX)), -EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeY, -EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeZ)));
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)box3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeX)), EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeY)), EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeZ);
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)box3D.isPointInside((Point3DReadOnly)pointOutside));
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeX)), EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeY)), -EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeZ);
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)box3D.isPointInside((Point3DReadOnly)pointOutside));
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            double sizeX = box3D.getSizeX();
            sizeY = box3D.getSizeY();
            sizeZ = box3D.getSizeZ();
            pointOutside = new Point3D();
            ySign = random.nextBoolean() ? -1.0 : 1.0;
            zSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeX)), ySign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeY, zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeZ);
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)box3D.isPointInside((Point3DReadOnly)pointOutside));
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            zSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeX, EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeY)), zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeZ);
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)box3D.isPointInside((Point3DReadOnly)pointOutside));
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            ySign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeX, ySign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeY, EuclidCoreRandomTools.nextDouble((Random)random, (double)(0.5 * sizeZ)));
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)box3D.isPointInside((Point3DReadOnly)pointOutside));
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            double sizeX = box3D.getSizeX();
            sizeY = box3D.getSizeY();
            sizeZ = box3D.getSizeZ();
            pointOutside = new Point3D();
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            ySign = random.nextBoolean() ? -1.0 : 1.0;
            zSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeX, ySign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeY, zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)10.0) * sizeZ);
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertFalse((boolean)box3D.isPointInside((Point3DReadOnly)pointOutside));
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            for (Point3DBasics vertex : box3D.getVertices()) {
                Assertions.assertTrue((boolean)box3D.isPointInside((Point3DReadOnly)vertex, 1.0E-12));
            }
        }
    }

    @Test
    void testEvaluatePoint3DCollision() throws Exception {
        double ySign;
        double zSign;
        double ySign2;
        double xSign;
        Vector3D expectedNormal;
        Point3D expectedClosestPoint;
        Vector3D actualNormal;
        Point3D actualClosestPoint;
        Point3D pointOutside;
        double halfSizeZ;
        double halfSizeY;
        double halfSizeX;
        Box3D box3D;
        int i;
        Random random = new Random(354534665L);
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            halfSizeX = 0.5 * box3D.getSizeX();
            halfSizeY = 0.5 * box3D.getSizeY();
            halfSizeZ = 0.5 * box3D.getSizeZ();
            pointOutside = new Point3D();
            actualClosestPoint = new Point3D();
            actualNormal = new Vector3D();
            expectedClosestPoint = new Point3D();
            expectedNormal = new Vector3D();
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeX, EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeY), EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeZ));
            expectedClosestPoint.set(xSign * halfSizeX, pointOutside.getY(), pointOutside.getZ());
            expectedNormal.set(xSign, 0.0, 0.0);
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedClosestPoint);
            box3D.transformToWorld((Transformable)expectedNormal);
            Assertions.assertFalse((boolean)box3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint, (Tuple3DReadOnly)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-12);
            ySign2 = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeX), ySign2 * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeY, EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeZ));
            expectedClosestPoint.set(pointOutside.getX(), ySign2 * halfSizeY, pointOutside.getZ());
            expectedNormal.set(0.0, ySign2, 0.0);
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedClosestPoint);
            box3D.transformToWorld((Transformable)expectedNormal);
            Assertions.assertFalse((boolean)box3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint, (Tuple3DReadOnly)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-12);
            double zSign2 = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeX), EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeY), zSign2 * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeZ);
            expectedClosestPoint.set(pointOutside.getX(), pointOutside.getY(), zSign2 * halfSizeZ);
            expectedNormal.set(0.0, 0.0, zSign2);
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedClosestPoint);
            box3D.transformToWorld((Transformable)expectedNormal);
            Assertions.assertFalse((boolean)box3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint, (Tuple3DReadOnly)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            halfSizeX = 0.5 * box3D.getSizeX();
            halfSizeY = 0.5 * box3D.getSizeY();
            halfSizeZ = 0.5 * box3D.getSizeZ();
            pointOutside = new Point3D();
            actualClosestPoint = new Point3D();
            actualNormal = new Vector3D();
            expectedClosestPoint = new Point3D();
            expectedNormal = new Vector3D();
            ySign2 = random.nextBoolean() ? -1.0 : 1.0;
            zSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeX), ySign2 * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeY, zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeZ);
            expectedClosestPoint.set(pointOutside.getX(), ySign2 * halfSizeY, zSign * halfSizeZ);
            expectedNormal.sub((Tuple3DReadOnly)pointOutside, (Tuple3DReadOnly)expectedClosestPoint);
            expectedNormal.normalize();
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedClosestPoint);
            box3D.transformToWorld((Transformable)expectedNormal);
            Assertions.assertFalse((boolean)box3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint, (Tuple3DReadOnly)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-12);
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            zSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeX, EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeY), zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeZ);
            expectedClosestPoint.set(xSign * halfSizeX, pointOutside.getY(), zSign * halfSizeZ);
            expectedNormal.sub((Tuple3DReadOnly)pointOutside, (Tuple3DReadOnly)expectedClosestPoint);
            expectedNormal.normalize();
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedClosestPoint);
            box3D.transformToWorld((Transformable)expectedNormal);
            Assertions.assertFalse((boolean)box3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint, (Tuple3DReadOnly)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-12);
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            ySign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeX, ySign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeY, EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeZ));
            expectedClosestPoint.set(xSign * halfSizeX, ySign * halfSizeY, pointOutside.getZ());
            expectedNormal.sub((Tuple3DReadOnly)pointOutside, (Tuple3DReadOnly)expectedClosestPoint);
            expectedNormal.normalize();
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedClosestPoint);
            box3D.transformToWorld((Transformable)expectedNormal);
            Assertions.assertFalse((boolean)box3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint, (Tuple3DReadOnly)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            halfSizeX = 0.5 * box3D.getSizeX();
            halfSizeY = 0.5 * box3D.getSizeY();
            halfSizeZ = 0.5 * box3D.getSizeZ();
            pointOutside = new Point3D();
            actualClosestPoint = new Point3D();
            actualNormal = new Vector3D();
            expectedClosestPoint = new Point3D();
            expectedNormal = new Vector3D();
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            ySign = random.nextBoolean() ? -1.0 : 1.0;
            double zSign3 = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeX, ySign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeY, zSign3 * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeZ);
            expectedClosestPoint.set(xSign * halfSizeX, ySign * halfSizeY, zSign3 * halfSizeZ);
            expectedNormal.sub((Tuple3DReadOnly)pointOutside, (Tuple3DReadOnly)expectedClosestPoint);
            expectedNormal.normalize();
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedClosestPoint);
            box3D.transformToWorld((Transformable)expectedNormal);
            Assertions.assertFalse((boolean)box3D.evaluatePoint3DCollision((Point3DReadOnly)pointOutside, (Point3DBasics)actualClosestPoint, (Vector3DBasics)actualNormal));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint, (Tuple3DReadOnly)actualClosestPoint, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            double size = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.2, (double)10.0);
            box3D.getSize().set(size, size, size);
            double halfSizeX2 = 0.5 * box3D.getSizeX();
            double halfSizeY2 = 0.5 * box3D.getSizeY();
            double halfSizeZ2 = 0.5 * box3D.getSizeZ();
            Point3D pointInside = new Point3D();
            Point3D actualClosestPoint2 = new Point3D();
            Vector3D actualNormal2 = new Vector3D();
            Point3D expectedClosestPoint2 = new Point3D();
            Vector3D expectedNormal2 = new Vector3D();
            double xSign2 = random.nextBoolean() ? -1.0 : 1.0;
            Point3D[] faceVertices = new Point3D[]{new Point3D(xSign2 * halfSizeX2, halfSizeY2, halfSizeZ2), new Point3D(xSign2 * halfSizeX2, -halfSizeY2, halfSizeZ2), new Point3D(xSign2 * halfSizeX2, -halfSizeY2, -halfSizeZ2), new Point3D(xSign2 * halfSizeX2, halfSizeY2, -halfSizeZ2)};
            if (random.nextBoolean()) {
                pointInside.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)new Point3D(), (Point3DReadOnly)faceVertices[0], (Point3DReadOnly)faceVertices[1], (Point3DReadOnly)faceVertices[2]));
            } else {
                pointInside.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)new Point3D(), (Point3DReadOnly)faceVertices[0], (Point3DReadOnly)faceVertices[2], (Point3DReadOnly)faceVertices[3]));
            }
            expectedClosestPoint2.set(xSign2 * halfSizeX2, pointInside.getY(), pointInside.getZ());
            expectedNormal2.set(xSign2, 0.0, 0.0);
            box3D.transformToWorld((Transformable)pointInside);
            box3D.transformToWorld((Transformable)expectedClosestPoint2);
            box3D.transformToWorld((Transformable)expectedNormal2);
            Assertions.assertTrue((boolean)box3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPoint2, (Vector3DBasics)actualNormal2));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint2, (Tuple3DReadOnly)actualClosestPoint2, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal2, (Tuple3DReadOnly)actualNormal2, (double)1.0E-12);
            ySign = random.nextBoolean() ? -1.0 : 1.0;
            faceVertices = new Point3D[]{new Point3D(halfSizeX2, ySign * halfSizeY2, halfSizeZ2), new Point3D(-halfSizeX2, ySign * halfSizeY2, halfSizeZ2), new Point3D(-halfSizeX2, ySign * halfSizeY2, -halfSizeZ2), new Point3D(halfSizeX2, ySign * halfSizeY2, -halfSizeZ2)};
            if (random.nextBoolean()) {
                pointInside.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)new Point3D(), (Point3DReadOnly)faceVertices[0], (Point3DReadOnly)faceVertices[1], (Point3DReadOnly)faceVertices[2]));
            } else {
                pointInside.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)new Point3D(), (Point3DReadOnly)faceVertices[0], (Point3DReadOnly)faceVertices[2], (Point3DReadOnly)faceVertices[3]));
            }
            expectedClosestPoint2.set(pointInside.getX(), ySign * halfSizeY2, pointInside.getZ());
            expectedNormal2.set(0.0, ySign, 0.0);
            box3D.transformToWorld((Transformable)pointInside);
            box3D.transformToWorld((Transformable)expectedClosestPoint2);
            box3D.transformToWorld((Transformable)expectedNormal2);
            Assertions.assertTrue((boolean)box3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPoint2, (Vector3DBasics)actualNormal2));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint2, (Tuple3DReadOnly)actualClosestPoint2, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal2, (Tuple3DReadOnly)actualNormal2, (double)1.0E-12);
            zSign = random.nextBoolean() ? -1.0 : 1.0;
            faceVertices = new Point3D[]{new Point3D(halfSizeX2, halfSizeY2, zSign * halfSizeZ2), new Point3D(-halfSizeX2, halfSizeY2, zSign * halfSizeZ2), new Point3D(-halfSizeX2, -halfSizeY2, zSign * halfSizeZ2), new Point3D(halfSizeX2, -halfSizeY2, zSign * halfSizeZ2)};
            if (random.nextBoolean()) {
                pointInside.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)new Point3D(), (Point3DReadOnly)faceVertices[0], (Point3DReadOnly)faceVertices[1], (Point3DReadOnly)faceVertices[2]));
            } else {
                pointInside.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)new Point3D(), (Point3DReadOnly)faceVertices[0], (Point3DReadOnly)faceVertices[2], (Point3DReadOnly)faceVertices[3]));
            }
            expectedClosestPoint2.set(pointInside.getX(), pointInside.getY(), zSign * halfSizeZ2);
            expectedNormal2.set(0.0, 0.0, zSign);
            box3D.transformToWorld((Transformable)pointInside);
            box3D.transformToWorld((Transformable)expectedClosestPoint2);
            box3D.transformToWorld((Transformable)expectedNormal2);
            Assertions.assertTrue((boolean)box3D.evaluatePoint3DCollision((Point3DReadOnly)pointInside, (Point3DBasics)actualClosestPoint2, (Vector3DBasics)actualNormal2));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedClosestPoint2, (Tuple3DReadOnly)actualClosestPoint2, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal2, (Tuple3DReadOnly)actualNormal2, (double)1.0E-12);
        }
    }

    @Test
    void testGetVertices() throws Exception {
        Box3D box3D;
        int i;
        Random random = new Random(3465L);
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            box3D.getPose().setToZero();
            Point3D expectedAbsoluteVertex = new Point3D((Tuple3DReadOnly)box3D.getSize());
            expectedAbsoluteVertex.scale(0.5);
            Assertions.assertEquals((int)8, (int)box3D.getVertices().length);
            Point3DBasics[] vertices = box3D.getVertices();
            for (int j = 0; j < vertices.length; ++j) {
                Point3DBasics vertex = vertices[j];
                EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)vertex, (Tuple3DReadOnly)box3D.getVertex(j), (double)1.0E-12);
                vertex.absolute();
                EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedAbsoluteVertex, (Tuple3DReadOnly)vertex, (double)1.0E-12);
            }
            double x = 0.5 * box3D.getSizeX();
            double y = 0.5 * box3D.getSizeY();
            double z = 0.5 * box3D.getSizeZ();
            int vertexIndex = 0;
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Point3D(x, y, z), (Tuple3DReadOnly)box3D.getVertex(vertexIndex++), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Point3D(-x, y, z), (Tuple3DReadOnly)box3D.getVertex(vertexIndex++), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Point3D(x, -y, z), (Tuple3DReadOnly)box3D.getVertex(vertexIndex++), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Point3D(-x, -y, z), (Tuple3DReadOnly)box3D.getVertex(vertexIndex++), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Point3D(x, y, -z), (Tuple3DReadOnly)box3D.getVertex(vertexIndex++), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Point3D(-x, y, -z), (Tuple3DReadOnly)box3D.getVertex(vertexIndex++), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Point3D(x, -y, -z), (Tuple3DReadOnly)box3D.getVertex(vertexIndex++), (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Point3D(-x, -y, -z), (Tuple3DReadOnly)box3D.getVertex(vertexIndex++), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            Point3DBasics[] expectedVertices = box3D.getVertices();
            RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            box3D.applyTransform((Transform)transform);
            Arrays.asList(expectedVertices).forEach(arg_0 -> ((RigidBodyTransform)transform).transform(arg_0));
            Point3DBasics[] actualVertices = box3D.getVertices();
            for (int j = 0; j < 8; ++j) {
                EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedVertices[j], (Tuple3DReadOnly)actualVertices[j], (double)1.0E-12);
            }
        }
    }

    @Test
    void testApplyTransform() {
        RigidBodyTransform transform;
        Box3D expected;
        Box3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextBox3D((Random)random);
            expected = new Box3D((Box3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPose().applyTransform((Transform)transform);
            actual.applyTransform((Transform)transform);
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)expected, (Box3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextBox3D((Random)random);
            expected = new Box3D((Box3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPose().applyTransform((Transform)transform);
            actual.applyTransform((Transform)transform);
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)expected, (Box3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    void testApplyInverseTransform() {
        RigidBodyTransform transform;
        Box3D expected;
        Box3D original;
        Box3D actual;
        int i;
        Random random = new Random(346L);
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextBox3D((Random)random);
            original = new Box3D((Box3DReadOnly)actual);
            expected = new Box3D((Box3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            expected.getPose().applyInverseTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)expected, (Box3DReadOnly)actual, (double)1.0E-12);
            actual.applyTransform((Transform)transform);
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)original, (Box3DReadOnly)actual, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            actual = EuclidShapeRandomTools.nextBox3D((Random)random);
            original = new Box3D((Box3DReadOnly)actual);
            expected = new Box3D((Box3DReadOnly)actual);
            transform = EuclidCoreRandomTools.nextAffineTransform((Random)random);
            expected.getPose().applyInverseTransform((Transform)transform);
            actual.applyInverseTransform((Transform)transform);
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)expected, (Box3DReadOnly)actual, (double)1.0E-12);
            actual.applyTransform((Transform)transform);
            EuclidShapeTestTools.assertBox3DEquals((Box3DReadOnly)original, (Box3DReadOnly)actual, (double)1.0E-12);
        }
    }

    @Test
    public void testGeometricallyEquals() {
        Box3D box1;
        int i;
        Random random = new Random(89725L);
        for (i = 0; i < 1000; ++i) {
            double lengthX = random.nextDouble();
            double widthY = random.nextDouble();
            double heightZ = random.nextDouble();
            box1 = new Box3D(lengthX, widthY, heightZ);
            Box3D box2 = new Box3D(lengthX, widthY, heightZ);
            Assertions.assertTrue((boolean)box1.geometricallyEquals(box2, 1.0E-12), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)box2.geometricallyEquals(box1, 1.0E-12), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)box1.geometricallyEquals(box1, 1.0E-12), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)box2.geometricallyEquals(box2, 1.0E-12), (String)("Iteration: " + i));
            RigidBodyTransform pose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            box1 = new Box3D((RigidBodyTransformReadOnly)pose, lengthX, widthY, heightZ);
            box2 = new Box3D((RigidBodyTransformReadOnly)pose, lengthX, widthY, heightZ);
            Assertions.assertTrue((boolean)box1.geometricallyEquals(box2, 1.0E-12), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)box2.geometricallyEquals(box1, 1.0E-12), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)box1.geometricallyEquals(box1, 1.0E-12), (String)("Iteration: " + i));
            Assertions.assertTrue((boolean)box2.geometricallyEquals(box2, 1.0E-12), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            double length1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double width1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)length1);
            double height1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)width1);
            double length2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double width2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)length2);
            double height2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)width2);
            Vector3D size1 = new Vector3D(length1, width1, height1);
            Vector3D size2 = new Vector3D(length2, width2, height2);
            Box3D box12 = new Box3D((RigidBodyTransformReadOnly)pose, length1, width1, height1);
            Box3D box2 = new Box3D((RigidBodyTransformReadOnly)pose, length2, width2, height2);
            Assertions.assertTrue((box12.geometricallyEquals(box2, 1.0E-12) == size1.geometricallyEquals(size2, 1.0E-12) ? 1 : 0) != 0, (String)("Iteration: " + i));
            double epsilon = random.nextDouble();
            Assertions.assertTrue((box12.geometricallyEquals(box2, epsilon) == size1.geometricallyEquals(size2, epsilon) ? 1 : 0) != 0, (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double epsilon = random.nextDouble();
            RigidBodyTransform pose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            Vector3D size1 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)(2.0 * epsilon), (double)10.0);
            Box3D box13 = new Box3D((RigidBodyTransformReadOnly)pose, size1.getX(), size1.getY(), size1.getZ());
            Vector3D size2 = new Vector3D();
            size2.add((Tuple3DReadOnly)size1, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(0.99 * epsilon)));
            Box3D box2 = new Box3D((RigidBodyTransformReadOnly)pose, size2.getX(), size2.getY(), size2.getZ());
            Assertions.assertTrue((box13.geometricallyEquals(box2, epsilon) == size1.geometricallyEquals(size2, epsilon) ? 1 : 0) != 0, (String)("Iteration: " + i));
            size2.add((Tuple3DReadOnly)size1, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(1.01 * epsilon)));
            box2 = new Box3D((RigidBodyTransformReadOnly)pose, size2.getX(), size2.getY(), size2.getZ());
            Assertions.assertTrue((box13.geometricallyEquals(box2, epsilon) == size1.geometricallyEquals(size2, epsilon) ? 1 : 0) != 0, (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            double epsilon = random.nextDouble();
            Vector3D size = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            Quaternion orientation = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Point3D position1 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            RigidBodyTransform pose1 = new RigidBodyTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)position1);
            box1 = new Box3D((RigidBodyTransformReadOnly)pose1, size.getX(), size.getY(), size.getZ());
            Point3D position2 = new Point3D();
            position2.add((Tuple3DReadOnly)position1, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(0.99 * epsilon)));
            RigidBodyTransform pose2 = new RigidBodyTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)position2);
            Box3D box2 = new Box3D((RigidBodyTransformReadOnly)pose2, size.getX(), size.getY(), size.getZ());
            Assertions.assertTrue((boolean)box1.geometricallyEquals(box2, epsilon), (String)("Iteration: " + i));
            position2.add((Tuple3DReadOnly)position1, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(1.01 * epsilon)));
            pose2 = new RigidBodyTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)position2);
            box2 = new Box3D((RigidBodyTransformReadOnly)pose2, size.getX(), size.getY(), size.getZ());
            Assertions.assertFalse((boolean)box1.geometricallyEquals(box2, epsilon), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            Box3D box2;
            Quaternion orientation1 = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion orientation2 = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Point3D position = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            RigidBodyTransform pose1 = new RigidBodyTransform((Orientation3DReadOnly)orientation1, (Tuple3DReadOnly)position);
            RigidBodyTransform pose2 = new RigidBodyTransform((Orientation3DReadOnly)orientation2, (Tuple3DReadOnly)position);
            Vector3D size = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)10.0);
            box1 = new Box3D((RigidBodyTransformReadOnly)pose1, size.getX(), size.getY(), size.getZ());
            Assertions.assertTrue((box1.geometricallyEquals(box2 = new Box3D((RigidBodyTransformReadOnly)pose2, size.getX(), size.getY(), size.getZ()), 1.0E-12) == orientation1.geometricallyEquals(orientation2, 1.0E-12) ? 1 : 0) != 0, (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            double lengthX = random.nextDouble();
            double widthY = random.nextDouble();
            double heightZ = random.nextDouble();
            Box3D box14 = new Box3D((RigidBodyTransformReadOnly)pose, lengthX, widthY, heightZ);
            int axis = random.nextInt(3);
            switch (axis) {
                case 0: {
                    pose.appendRollRotation(Math.PI);
                    break;
                }
                case 1: {
                    pose.appendPitchRotation(Math.PI);
                    break;
                }
                case 2: {
                    pose.appendYawRotation(Math.PI);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected axis value: " + axis);
                }
            }
            Box3D box2 = new Box3D((RigidBodyTransformReadOnly)pose, lengthX, widthY, heightZ);
            Assertions.assertTrue((boolean)box14.geometricallyEquals(box2, 1.0E-12), (String)("Iteration: " + i));
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)1.5707963267948966);
            switch (axis) {
                case 0: {
                    pose.appendRollRotation(angle);
                    break;
                }
                case 1: {
                    pose.appendPitchRotation(angle);
                    break;
                }
                case 2: {
                    pose.appendYawRotation(angle);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected axis value: " + axis);
                }
            }
            box2 = new Box3D((RigidBodyTransformReadOnly)pose, lengthX, widthY, heightZ);
            Assertions.assertFalse((boolean)box14.geometricallyEquals(box2, 1.0E-12), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform pose2 = new RigidBodyTransform((RigidBodyTransformReadOnly)pose1);
            pose2.appendYawRotation(1.5707963267948966);
            double lengthX = random.nextDouble();
            double widthY = random.nextDouble();
            double heightZ = random.nextDouble();
            Box3D box15 = new Box3D((RigidBodyTransformReadOnly)pose1, lengthX, widthY, heightZ);
            Box3D box2 = new Box3D((RigidBodyTransformReadOnly)pose2, widthY, lengthX, heightZ);
            Assertions.assertTrue((boolean)box15.geometricallyEquals(box2, 1.0E-12), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform pose2 = new RigidBodyTransform((RigidBodyTransformReadOnly)pose1);
            pose2.appendPitchRotation(1.5707963267948966);
            double lengthX = random.nextDouble();
            double widthY = random.nextDouble();
            double heightZ = random.nextDouble();
            Box3D box16 = new Box3D((RigidBodyTransformReadOnly)pose1, lengthX, widthY, heightZ);
            Box3D box2 = new Box3D((RigidBodyTransformReadOnly)pose2, heightZ, widthY, lengthX);
            Assertions.assertTrue((boolean)box16.geometricallyEquals(box2, 1.0E-12), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform pose2 = new RigidBodyTransform((RigidBodyTransformReadOnly)pose1);
            pose2.appendRollRotation(1.5707963267948966);
            double lengthX = random.nextDouble();
            double widthY = random.nextDouble();
            double heightZ = random.nextDouble();
            Box3D box17 = new Box3D((RigidBodyTransformReadOnly)pose1, lengthX, widthY, heightZ);
            Box3D box2 = new Box3D((RigidBodyTransformReadOnly)pose2, lengthX, heightZ, widthY);
            Assertions.assertTrue((boolean)box17.geometricallyEquals(box2, 1.0E-12), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform pose2 = new RigidBodyTransform((RigidBodyTransformReadOnly)pose1);
            pose2.appendYawRotation(1.5707963267948966);
            pose2.appendPitchRotation(1.5707963267948966);
            double lengthX = random.nextDouble();
            double widthY = random.nextDouble();
            double heightZ = random.nextDouble();
            Box3D box18 = new Box3D((RigidBodyTransformReadOnly)pose1, lengthX, widthY, heightZ);
            Box3D box2 = new Box3D((RigidBodyTransformReadOnly)pose2, heightZ, lengthX, widthY);
            Assertions.assertTrue((boolean)box18.geometricallyEquals(box2, 1.0E-12), (String)("Iteration: " + i));
        }
        for (i = 0; i < 1000; ++i) {
            RigidBodyTransform pose1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform pose2 = new RigidBodyTransform((RigidBodyTransformReadOnly)pose1);
            pose2.appendYawRotation(1.5707963267948966);
            pose2.appendRollRotation(1.5707963267948966);
            double lengthX = random.nextDouble();
            double widthY = random.nextDouble();
            double heightZ = random.nextDouble();
            Box3D box19 = new Box3D((RigidBodyTransformReadOnly)pose1, lengthX, widthY, heightZ);
            Box3D box2 = new Box3D((RigidBodyTransformReadOnly)pose2, widthY, heightZ, lengthX);
            Assertions.assertTrue((boolean)box19.geometricallyEquals(box2, 1.0E-12), (String)("Iteration: " + i));
        }
    }

    @Test
    void testGetSupportingVertex() throws Exception {
        Vector3D supportDirection;
        Box3D box;
        int i;
        Random random = new Random(546161L);
        for (i = 0; i < 1000; ++i) {
            box = EuclidShapeRandomTools.nextBox3D((Random)random);
            supportDirection = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3DBasics expectedSupportingVertex = Stream.of(box.getVertices()).sorted((v1, v2) -> -Double.compare(TupleTools.dot((Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)v1), TupleTools.dot((Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)v2))).findFirst().get();
            Point3DReadOnly actualSupportingVertex = box.getSupportingVertex((Vector3DReadOnly)supportDirection);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedSupportingVertex, (Tuple3DReadOnly)actualSupportingVertex, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            box = EuclidShapeRandomTools.nextBox3D((Random)random);
            supportDirection = EuclidCoreRandomTools.nextVector3D((Random)random);
            Point3DReadOnly supportingVertex = box.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Point3D supportingVertexTranslated = new Point3D();
            supportDirection.normalize();
            Assertions.assertTrue((boolean)box.isPointInside(supportingVertex, 1.0E-12));
            supportingVertexTranslated.scaleAdd(1.0E-6, (Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)supportingVertex);
            Assertions.assertFalse((boolean)box.isPointInside((Point3DReadOnly)supportingVertexTranslated));
            supportingVertexTranslated.scaleAdd(0.01, (Tuple3DReadOnly)supportDirection, (Tuple3DReadOnly)supportingVertex);
            Vector3D expectedNormal = new Vector3D();
            expectedNormal.sub((Tuple3DReadOnly)supportingVertexTranslated, (Tuple3DReadOnly)supportingVertex);
            expectedNormal.normalize();
            Vector3D actualNormal = new Vector3D();
            box.evaluatePoint3DCollision((Point3DReadOnly)supportingVertexTranslated, (Point3DBasics)new Point3D(), (Vector3DBasics)actualNormal);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedNormal, (Tuple3DReadOnly)actualNormal, (double)1.0E-12);
        }
    }

    @Test
    void testDistance() throws Exception {
        double ySign;
        double xSign;
        Point3D pointOutside;
        double halfSizeZ;
        double halfSizeY;
        double halfSizeX;
        Box3D box3D;
        int i;
        Random random = new Random(986L);
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            halfSizeX = 0.5 * box3D.getSizeX();
            halfSizeY = 0.5 * box3D.getSizeY();
            halfSizeZ = 0.5 * box3D.getSizeZ();
            pointOutside = new Point3D();
            double xSign2 = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign2 * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeX, EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeY), EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeZ));
            double expectedDistance = Math.abs(pointOutside.getX() - xSign2 * halfSizeX);
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertEquals((double)expectedDistance, (double)box3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
            double ySign2 = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeX), ySign2 * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeY, EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeZ));
            expectedDistance = Math.abs(pointOutside.getY() - ySign2 * halfSizeY);
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertEquals((double)expectedDistance, (double)box3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
            double zSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeX), EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeY), zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeZ);
            expectedDistance = Math.abs(pointOutside.getZ() - zSign * halfSizeZ);
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertEquals((double)expectedDistance, (double)box3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            halfSizeX = 0.5 * box3D.getSizeX();
            halfSizeY = 0.5 * box3D.getSizeY();
            halfSizeZ = 0.5 * box3D.getSizeZ();
            pointOutside = new Point3D();
            Point3D closestPoint = new Point3D();
            double ySign3 = random.nextBoolean() ? -1.0 : 1.0;
            double zSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeX), ySign3 * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeY, zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeZ);
            closestPoint.set(pointOutside.getX(), ySign3 * halfSizeY, zSign * halfSizeZ);
            double expectedDistance = closestPoint.distance((Point3DReadOnly)pointOutside);
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertEquals((double)expectedDistance, (double)box3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            zSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeX, EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeY), zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeZ);
            closestPoint.set(xSign * halfSizeX, pointOutside.getY(), zSign * halfSizeZ);
            expectedDistance = closestPoint.distance((Point3DReadOnly)pointOutside);
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertEquals((double)expectedDistance, (double)box3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            ySign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeX, ySign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeY, EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeZ));
            closestPoint.set(xSign * halfSizeX, ySign * halfSizeY, pointOutside.getZ());
            expectedDistance = closestPoint.distance((Point3DReadOnly)pointOutside);
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertEquals((double)expectedDistance, (double)box3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            halfSizeX = 0.5 * box3D.getSizeX();
            halfSizeY = 0.5 * box3D.getSizeY();
            halfSizeZ = 0.5 * box3D.getSizeZ();
            pointOutside = new Point3D();
            Point3D closestVertex = new Point3D();
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            ySign = random.nextBoolean() ? -1.0 : 1.0;
            double zSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeX, ySign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeY, zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeZ);
            closestVertex.set(xSign * halfSizeX, ySign * halfSizeY, zSign * halfSizeZ);
            double expectedDistance = closestVertex.distance((Point3DReadOnly)pointOutside);
            box3D.transformToWorld((Transformable)pointOutside);
            Assertions.assertEquals((double)expectedDistance, (double)box3D.distance((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Point3DReadOnly[])box3D.getVertices());
            Assertions.assertEquals((double)0.0, (double)box3D.distance((Point3DReadOnly)pointInside));
        }
    }

    @Test
    void testSignedDistance() throws Exception {
        Box3D box3D;
        int i;
        Random random = new Random(345346L);
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            Point3D point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)box3D.getSizeX(), (double)box3D.getSizeY(), (double)box3D.getSizeZ());
            double distance = box3D.distance((Point3DReadOnly)point);
            double signedDistance = box3D.signedDistance((Point3DReadOnly)point);
            if (!box3D.isPointInside((Point3DReadOnly)point)) {
                Assertions.assertEquals((double)distance, (double)signedDistance, (double)1.0E-12);
                continue;
            }
            Assertions.assertTrue((signedDistance < 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            double size = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
            box3D.getSize().set(size, size, size);
            double halfSize = 0.5 * size;
            Point3D pointInside = new Point3D();
            double xSign = random.nextBoolean() ? -1.0 : 1.0;
            Point3D[] faceVertices = new Point3D[]{new Point3D(xSign * halfSize, halfSize, halfSize), new Point3D(xSign * halfSize, -halfSize, halfSize), new Point3D(xSign * halfSize, -halfSize, -halfSize), new Point3D(xSign * halfSize, halfSize, -halfSize)};
            if (random.nextBoolean()) {
                pointInside.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)new Point3D(), (Point3DReadOnly)faceVertices[0], (Point3DReadOnly)faceVertices[1], (Point3DReadOnly)faceVertices[2]));
            } else {
                pointInside.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)new Point3D(), (Point3DReadOnly)faceVertices[0], (Point3DReadOnly)faceVertices[2], (Point3DReadOnly)faceVertices[3]));
            }
            double expectedDistance = -Math.abs(pointInside.getX() - xSign * halfSize);
            box3D.transformToWorld((Transformable)pointInside);
            Assertions.assertEquals((double)expectedDistance, (double)box3D.signedDistance((Point3DReadOnly)pointInside), (double)1.0E-12);
            double ySign = random.nextBoolean() ? -1.0 : 1.0;
            faceVertices = new Point3D[]{new Point3D(halfSize, ySign * halfSize, halfSize), new Point3D(-halfSize, ySign * halfSize, halfSize), new Point3D(-halfSize, ySign * halfSize, -halfSize), new Point3D(halfSize, ySign * halfSize, -halfSize)};
            if (random.nextBoolean()) {
                pointInside.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)new Point3D(), (Point3DReadOnly)faceVertices[0], (Point3DReadOnly)faceVertices[1], (Point3DReadOnly)faceVertices[2]));
            } else {
                pointInside.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)new Point3D(), (Point3DReadOnly)faceVertices[0], (Point3DReadOnly)faceVertices[2], (Point3DReadOnly)faceVertices[3]));
            }
            expectedDistance = -Math.abs(pointInside.getY() - ySign * halfSize);
            box3D.transformToWorld((Transformable)pointInside);
            Assertions.assertEquals((double)expectedDistance, (double)box3D.signedDistance((Point3DReadOnly)pointInside), (double)1.0E-12);
            double zSign = random.nextBoolean() ? -1.0 : 1.0;
            faceVertices = new Point3D[]{new Point3D(halfSize, halfSize, zSign * halfSize), new Point3D(-halfSize, halfSize, zSign * halfSize), new Point3D(-halfSize, -halfSize, zSign * halfSize), new Point3D(halfSize, -halfSize, zSign * halfSize)};
            if (random.nextBoolean()) {
                pointInside.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)new Point3D(), (Point3DReadOnly)faceVertices[0], (Point3DReadOnly)faceVertices[1], (Point3DReadOnly)faceVertices[2]));
            } else {
                pointInside.set(EuclidGeometryRandomTools.nextPoint3DInTetrahedron((Random)random, (Point3DReadOnly)new Point3D(), (Point3DReadOnly)faceVertices[0], (Point3DReadOnly)faceVertices[2], (Point3DReadOnly)faceVertices[3]));
            }
            expectedDistance = -Math.abs(pointInside.getZ() - zSign * halfSize);
            box3D.transformToWorld((Transformable)pointInside);
            Assertions.assertEquals((double)expectedDistance, (double)box3D.signedDistance((Point3DReadOnly)pointInside), (double)1.0E-12);
        }
    }

    @Test
    void testOrthogonalProjection() throws Exception {
        double ySign;
        double ySign2;
        double xSign;
        Point3D expectedProjection;
        Point3D pointOutside;
        double halfSizeZ;
        double halfSizeY;
        double halfSizeX;
        Box3D box3D;
        int i;
        Random random = new Random(984L);
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            halfSizeX = 0.5 * box3D.getSizeX();
            halfSizeY = 0.5 * box3D.getSizeY();
            halfSizeZ = 0.5 * box3D.getSizeZ();
            pointOutside = new Point3D();
            expectedProjection = new Point3D();
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeX, EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeY), EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeZ));
            expectedProjection.set(xSign * halfSizeX, pointOutside.getY(), pointOutside.getZ());
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedProjection);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedProjection, (Tuple3DReadOnly)box3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
            ySign2 = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeX), ySign2 * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeY, EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeZ));
            expectedProjection.set(pointOutside.getX(), ySign2 * halfSizeY, pointOutside.getZ());
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedProjection);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedProjection, (Tuple3DReadOnly)box3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
            double zSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeX), EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeY), zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeZ);
            expectedProjection.set(pointOutside.getX(), pointOutside.getY(), zSign * halfSizeZ);
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedProjection);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedProjection, (Tuple3DReadOnly)box3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            halfSizeX = 0.5 * box3D.getSizeX();
            halfSizeY = 0.5 * box3D.getSizeY();
            halfSizeZ = 0.5 * box3D.getSizeZ();
            pointOutside = new Point3D();
            expectedProjection = new Point3D();
            ySign2 = random.nextBoolean() ? -1.0 : 1.0;
            double zSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeX), ySign2 * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeY, zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeZ);
            expectedProjection.set(pointOutside.getX(), ySign2 * halfSizeY, zSign * halfSizeZ);
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedProjection);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedProjection, (Tuple3DReadOnly)box3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            zSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeX, EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeY), zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeZ);
            expectedProjection.set(xSign * halfSizeX, pointOutside.getY(), zSign * halfSizeZ);
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedProjection);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedProjection, (Tuple3DReadOnly)box3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            ySign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeX, ySign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeY, EuclidCoreRandomTools.nextDouble((Random)random, (double)halfSizeZ));
            expectedProjection.set(xSign * halfSizeX, ySign * halfSizeY, pointOutside.getZ());
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedProjection);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedProjection, (Tuple3DReadOnly)box3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            halfSizeX = 0.5 * box3D.getSizeX();
            halfSizeY = 0.5 * box3D.getSizeY();
            halfSizeZ = 0.5 * box3D.getSizeZ();
            pointOutside = new Point3D();
            expectedProjection = new Point3D();
            xSign = random.nextBoolean() ? -1.0 : 1.0;
            ySign = random.nextBoolean() ? -1.0 : 1.0;
            double zSign = random.nextBoolean() ? -1.0 : 1.0;
            pointOutside.set(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeX, ySign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeY, zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0) * halfSizeZ);
            expectedProjection.set(xSign * halfSizeX, ySign * halfSizeY, zSign * halfSizeZ);
            box3D.transformToWorld((Transformable)pointOutside);
            box3D.transformToWorld((Transformable)expectedProjection);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedProjection, (Tuple3DReadOnly)box3D.orthogonalProjectionCopy((Point3DReadOnly)pointOutside), (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            Point3D pointInside = EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Point3DReadOnly[])box3D.getVertices());
            Assertions.assertNull((Object)box3D.orthogonalProjectionCopy((Point3DReadOnly)pointInside));
        }
    }

    @Test
    void testIntersectionWith() throws Exception {
        double halfSizeZ;
        double halfSizeY;
        double halfSizeX;
        Box3D box3D;
        int i;
        Random random = new Random(865L);
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            halfSizeX = 0.5 * box3D.getSizeX();
            halfSizeY = 0.5 * box3D.getSizeY();
            halfSizeZ = 0.5 * box3D.getSizeZ();
            double xSign = random.nextBoolean() ? -1.0 : 1.0;
            ArrayList<LineSegment3D> edges = new ArrayList<LineSegment3D>();
            edges.add(new LineSegment3D(xSign * halfSizeX, halfSizeY, halfSizeZ, xSign * halfSizeX, halfSizeY, -halfSizeZ));
            edges.add(new LineSegment3D(xSign * halfSizeX, halfSizeY, -halfSizeZ, xSign * halfSizeX, -halfSizeY, -halfSizeZ));
            edges.add(new LineSegment3D(xSign * halfSizeX, -halfSizeY, -halfSizeZ, xSign * halfSizeX, -halfSizeY, halfSizeZ));
            edges.add(new LineSegment3D(xSign * halfSizeX, -halfSizeY, halfSizeZ, xSign * halfSizeX, halfSizeY, halfSizeZ));
            LineSegment3D edge1 = (LineSegment3D)edges.remove(random.nextInt(4));
            LineSegment3D edge2 = (LineSegment3D)edges.remove(random.nextInt(3));
            Point3D pointOnEdge1 = new Point3D();
            Point3D pointOnEdge2 = new Point3D();
            pointOnEdge1.interpolate((Tuple3DReadOnly)edge1.getFirstEndpoint(), (Tuple3DReadOnly)edge1.getSecondEndpoint(), random.nextDouble());
            pointOnEdge2.interpolate((Tuple3DReadOnly)edge2.getFirstEndpoint(), (Tuple3DReadOnly)edge2.getSecondEndpoint(), random.nextDouble());
            pointOnEdge1.addX(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            pointOnEdge2.addX(xSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Line3D line = new Line3D((Point3DReadOnly)pointOnEdge1, (Point3DReadOnly)pointOnEdge2);
            box3D.transformToWorld((Transformable)line);
            Assertions.assertEquals((int)0, (int)box3D.intersectionWith((Line3DReadOnly)line, null, null));
            double ySign = random.nextBoolean() ? -1.0 : 1.0;
            edges = new ArrayList();
            edges.add(new LineSegment3D(halfSizeX, ySign * halfSizeY, halfSizeZ, halfSizeX, ySign * halfSizeY, -halfSizeZ));
            edges.add(new LineSegment3D(halfSizeX, ySign * halfSizeY, -halfSizeZ, -halfSizeX, ySign * halfSizeY, -halfSizeZ));
            edges.add(new LineSegment3D(-halfSizeX, ySign * halfSizeY, -halfSizeZ, -halfSizeX, ySign * halfSizeY, halfSizeZ));
            edges.add(new LineSegment3D(-halfSizeX, ySign * halfSizeY, halfSizeZ, halfSizeX, ySign * halfSizeY, halfSizeZ));
            edge1 = (LineSegment3D)edges.remove(random.nextInt(4));
            edge2 = (LineSegment3D)edges.remove(random.nextInt(3));
            pointOnEdge1 = new Point3D();
            pointOnEdge2 = new Point3D();
            pointOnEdge1.interpolate((Tuple3DReadOnly)edge1.getFirstEndpoint(), (Tuple3DReadOnly)edge1.getSecondEndpoint(), random.nextDouble());
            pointOnEdge2.interpolate((Tuple3DReadOnly)edge2.getFirstEndpoint(), (Tuple3DReadOnly)edge2.getSecondEndpoint(), random.nextDouble());
            pointOnEdge1.addY(ySign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            pointOnEdge2.addY(ySign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            line = new Line3D((Point3DReadOnly)pointOnEdge1, (Point3DReadOnly)pointOnEdge2);
            box3D.transformToWorld((Transformable)line);
            Assertions.assertEquals((int)0, (int)box3D.intersectionWith((Line3DReadOnly)line, null, null));
            double zSign = random.nextBoolean() ? -1.0 : 1.0;
            edges = new ArrayList();
            edges.add(new LineSegment3D(halfSizeX, halfSizeY, zSign * halfSizeZ, halfSizeX, -halfSizeY, zSign * halfSizeZ));
            edges.add(new LineSegment3D(halfSizeX, -halfSizeY, zSign * halfSizeZ, -halfSizeX, -halfSizeY, zSign * halfSizeZ));
            edges.add(new LineSegment3D(-halfSizeX, -halfSizeY, zSign * halfSizeZ, -halfSizeX, halfSizeY, zSign * halfSizeZ));
            edges.add(new LineSegment3D(-halfSizeX, halfSizeY, zSign * halfSizeZ, halfSizeX, halfSizeY, zSign * halfSizeZ));
            edge1 = (LineSegment3D)edges.remove(random.nextInt(4));
            edge2 = (LineSegment3D)edges.remove(random.nextInt(3));
            pointOnEdge1 = new Point3D();
            pointOnEdge2 = new Point3D();
            pointOnEdge1.interpolate((Tuple3DReadOnly)edge1.getFirstEndpoint(), (Tuple3DReadOnly)edge1.getSecondEndpoint(), random.nextDouble());
            pointOnEdge2.interpolate((Tuple3DReadOnly)edge2.getFirstEndpoint(), (Tuple3DReadOnly)edge2.getSecondEndpoint(), random.nextDouble());
            pointOnEdge1.addZ(zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            pointOnEdge2.addZ(zSign * EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            line = new Line3D((Point3DReadOnly)pointOnEdge1, (Point3DReadOnly)pointOnEdge2);
            box3D.transformToWorld((Transformable)line);
            Assertions.assertEquals((int)0, (int)box3D.intersectionWith((Line3DReadOnly)line, null, null));
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            halfSizeX = 0.5 * box3D.getSizeX();
            halfSizeY = 0.5 * box3D.getSizeY();
            halfSizeZ = 0.5 * box3D.getSizeZ();
            Point3D expectedIntersection1 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)halfSizeX, (double)halfSizeY, (double)halfSizeZ);
            Point3D expectedIntersection2 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)halfSizeX, (double)halfSizeY, (double)halfSizeZ);
            Point3D actualIntersection1 = new Point3D();
            Point3D actualIntersection2 = new Point3D();
            double sign1 = random.nextBoolean() ? -1.0 : 1.0;
            double sign2 = random.nextBoolean() ? -1.0 : 1.0;
            int index1 = random.nextInt(3);
            int index2 = random.nextInt(3);
            if (sign1 == sign2 && index2 == index1) {
                index2 = (index2 + 1) % 3;
            }
            expectedIntersection1.setElement(index1, sign1 * 0.5 * box3D.getSize().getElement(index1));
            expectedIntersection2.setElement(index2, sign2 * 0.5 * box3D.getSize().getElement(index2));
            Line3D line = new Line3D((Point3DReadOnly)expectedIntersection1, (Point3DReadOnly)expectedIntersection2);
            box3D.transformToWorld((Transformable)line);
            box3D.transformToWorld((Transformable)expectedIntersection1);
            box3D.transformToWorld((Transformable)expectedIntersection2);
            Assertions.assertEquals((int)2, (int)box3D.intersectionWith((Line3DReadOnly)line, (Point3DBasics)actualIntersection1, (Point3DBasics)actualIntersection2));
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedIntersection1, (Tuple3DReadOnly)actualIntersection1, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedIntersection2, (Tuple3DReadOnly)actualIntersection2, (double)1.0E-12);
        }
    }

    @Test
    void testGetBoundingBox3D() throws Exception {
        Box3D box3D;
        int i;
        Random random = new Random(34563L);
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            BoundingBox3D boundingBox = EuclidGeometryRandomTools.nextBoundingBox3D((Random)random);
            box3D.getBoundingBox((BoundingBox3DBasics)boundingBox);
            for (Point3DBasics vertex : box3D.getVertices()) {
                Assertions.assertTrue((boolean)boundingBox.isInsideInclusive((Point3DReadOnly)vertex));
            }
            for (int j = 0; j < 100; ++j) {
                Assertions.assertTrue((boolean)boundingBox.isInsideExclusive((Point3DReadOnly)EuclidGeometryRandomTools.nextWeightedAverage((Random)random, (Point3DReadOnly[])box3D.getVertices())));
            }
        }
        for (i = 0; i < 1000; ++i) {
            box3D = EuclidShapeRandomTools.nextBox3D((Random)random);
            BoundingBox3D expectedBoundingBox = new BoundingBox3D();
            expectedBoundingBox.setToNaN();
            Vector3D supportDirection = new Vector3D((Tuple3DReadOnly)Axis3D.X);
            expectedBoundingBox.updateToIncludePoint(box3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(box3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Y);
            expectedBoundingBox.updateToIncludePoint(box3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(box3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Z);
            expectedBoundingBox.updateToIncludePoint(box3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            supportDirection.negate();
            expectedBoundingBox.updateToIncludePoint(box3D.getSupportingVertex((Vector3DReadOnly)supportDirection));
            BoundingBox3DReadOnly actualBoundingBox = box3D.getBoundingBox();
            EuclidGeometryTestTools.assertBoundingBox3DEquals((BoundingBox3DReadOnly)expectedBoundingBox, (BoundingBox3DReadOnly)actualBoundingBox, (double)1.0E-12);
        }
    }
}

