/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.referenceFrame;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tuple4D.Tuple4DReadOnlyTest;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public abstract class FrameTuple4DReadOnlyTest<F extends FrameTuple4DReadOnly> {
    public static final double EPSILON = 1.0E-15;

    public final F createEmptyFrameTuple() {
        return this.createEmptyFrameTuple(ReferenceFrame.getWorldFrame());
    }

    public F createEmptyFrameTuple(ReferenceFrame referenceFrame) {
        return this.createFrameTuple(referenceFrame, 0.0, 0.0, 0.0, 0.0);
    }

    public F createFrameTuple(ReferenceFrame referenceFrame, Tuple4DReadOnly tuple4dReadOnly) {
        return this.createFrameTuple(referenceFrame, tuple4dReadOnly.getX(), tuple4dReadOnly.getY(), tuple4dReadOnly.getZ(), tuple4dReadOnly.getS());
    }

    public final F createRandomFrameTuple(Random random) {
        return this.createRandomFrameTuple(random, ReferenceFrame.getWorldFrame());
    }

    public F createRandomFrameTuple(Random random, ReferenceFrame referenceFrame) {
        return this.createFrameTuple(referenceFrame, random.nextDouble(), random.nextDouble(), random.nextDouble(), random.nextDouble());
    }

    public final F createFrameTuple(double x, double y, double z, double s) {
        return this.createFrameTuple(ReferenceFrame.getWorldFrame(), x, y, z, s);
    }

    public abstract F createFrameTuple(ReferenceFrame var1, double var2, double var4, double var6, double var8);

    @Test
    public void testTuple3DReadOnlyFeatures() throws Throwable {
        Tuple4DReadOnlyTest test = new Tuple4DReadOnlyTest<F>(){

            @Override
            public F createEmptyTuple() {
                return FrameTuple4DReadOnlyTest.this.createEmptyFrameTuple();
            }

            @Override
            public F createRandomTuple(Random random) {
                return FrameTuple4DReadOnlyTest.this.createRandomFrameTuple(random);
            }

            @Override
            public F createTuple(double x, double y, double z, double s) {
                return FrameTuple4DReadOnlyTest.this.createFrameTuple(x, y, z, s);
            }

            @Override
            public double getEpsilon() {
                return 1.0E-15;
            }
        };
        for (Method testMethod : test.getClass().getMethods()) {
            if (!testMethod.getName().startsWith("test") || !Modifier.isPublic(testMethod.getModifiers()) || Modifier.isStatic(testMethod.getModifiers())) continue;
            try {
                testMethod.invoke((Object)test, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    @Test
    public void testEpsilonEquals() throws Exception {
        Random random = new Random(621541L);
        double epsilon = 0.0;
        ReferenceFrame frame1 = ReferenceFrame.getWorldFrame();
        ReferenceFrame frame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        double x = random.nextDouble();
        double y = random.nextDouble();
        double z = random.nextDouble();
        double s = random.nextDouble();
        F tuple1 = this.createFrameTuple(frame1, x, y, z, s);
        F tuple2 = this.createFrameTuple(frame1, x, y, z, s);
        F tuple3 = this.createFrameTuple(frame2, x, y, z, s);
        F tuple4 = this.createFrameTuple(frame2, x, y, z, s);
        Assertions.assertTrue((boolean)tuple1.epsilonEquals(tuple2, epsilon));
        Assertions.assertFalse((boolean)tuple1.epsilonEquals(tuple3, epsilon));
        Assertions.assertFalse((boolean)tuple3.epsilonEquals(tuple2, epsilon));
        Assertions.assertTrue((boolean)tuple3.epsilonEquals(tuple4, epsilon));
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(621541L);
        ReferenceFrame frame1 = ReferenceFrame.getWorldFrame();
        ReferenceFrame frame2 = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
        double x = random.nextDouble();
        double y = random.nextDouble();
        double z = random.nextDouble();
        double s = random.nextDouble();
        F tuple1 = this.createFrameTuple(frame1, x, y, z, s);
        F tuple2 = this.createFrameTuple(frame1, x, y, z, s);
        F tuple3 = this.createFrameTuple(frame2, x, y, z, s);
        F tuple4 = this.createFrameTuple(frame2, x, y, z, s);
        Assertions.assertTrue((boolean)tuple1.equals(tuple2));
        Assertions.assertFalse((boolean)tuple1.equals(tuple3));
        Assertions.assertFalse((boolean)tuple3.equals(tuple2));
        Assertions.assertTrue((boolean)tuple3.equals(tuple4));
        F tuple2AsObject = tuple2;
        F tuple3AsObject = tuple3;
        F tuple4AsObject = tuple4;
        Assertions.assertTrue((boolean)tuple1.equals(tuple2AsObject));
        Assertions.assertFalse((boolean)tuple1.equals(tuple3AsObject));
        Assertions.assertFalse((boolean)tuple3.equals(tuple2AsObject));
        Assertions.assertTrue((boolean)tuple3.equals(tuple4AsObject));
    }

    @Test
    public void testOverloading() throws Exception {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(FrameTuple4DReadOnly.class, Tuple4DReadOnly.class, true);
    }
}

